import { PropInterface } from "@magic-xpa/gui";
import { Transaction } from "../rt/Transaction";
import { ReturnResult } from "../util/ReturnResult";
import { DataViewCommandType } from "../commands/ClientToServer/DataviewCommand";
import { CommandsProcessorBase_SendingInstruction } from "../CommandsProcessorBase";
import { CommandFactory } from "../commands/ClientToServer/CommandFactory";
import { ConstInterface } from "../ConstInterface";
import { RefParam } from "@magic-xpa/mscorelib";
import { RemoteCommandsProcessor } from "../remote/RemoteCommandsProcessor";
import { MGDataCollection } from "../tasks/MGDataCollection";
export class TaskTransactionManager {
    get isClosingTopmostTask() {
        return MGDataCollection.Instance.StartupMgData.getFirstTask().InEndTask;
    }
    constructor(task) {
        this.task = null;
        this.task = task;
    }
    AllowTransaction(transBegin, forLocal) {
        let result;
        if (forLocal)
            result = (transBegin === ConstInterface.TRANS_TASK_PREFIX || transBegin === ConstInterface.TRANS_RECORD_PREFIX);
        else
            result = (transBegin === ConstInterface.TRANS_TASK_PREFIX || transBegin === ConstInterface.TRANS_RECORD_PREFIX || transBegin === ConstInterface.TRANS_NONE);
        return result;
    }
    PrepareTransactionProperties(transaction, forLocal) {
        let transactionBeginValue = this.GetTransactionBeginValue(forLocal);
        let flag = transaction !== null && this.AllowTransaction(transactionBeginValue, forLocal);
        if (flag)
            transaction.setTransBegin(transactionBeginValue);
    }
    GetTransactionBeginValue(forLocal) {
        let result = ConstInterface.TRANS_NONE;
        let prop = this.task.getProp(PropInterface.PROP_TYPE_TRASACTION_BEGIN);
        if (prop !== null) {
            let propgetValue = forLocal ? prop.StudioValue : prop.GetComputedValue();
            if (propgetValue !== null) {
                result = propgetValue.charAt(0);
            }
        }
        return result;
    }
    async checkAndCommit(reversibleExit, level, isAbort) {
        let oper = isAbort ? ConstInterface.TRANS_ABORT : ConstInterface.TRANS_COMMIT;
        let result = await this.ExecuteLocalUpdatesCommand();
        if (!result.Success) {
            if (!this.task.IsInteractive)
                this.task.abort();
            return false;
        }
        let refResult = new RefParam(result);
        let ret = await this.checkAndCommitPerDataview(this.task.DataviewManager.RemoteDataviewManager, reversibleExit, level, oper, refResult);
        result = refResult.value;
        if (!ret) {
            if (level === ConstInterface.TRANS_RECORD_PREFIX && this.task.DataView.modifiedRecordsNumber() > 0 && this.task.DataView.FlushUpdates) {
                try {
                    this.task.TryingToCommit = true;
                    await RemoteCommandsProcessor.GetInstance().Execute(CommandsProcessorBase_SendingInstruction.TASKS_AND_COMMANDS);
                }
                finally {
                    this.task.TryingToCommit = false;
                }
            }
        }
        return false;
    }
    async ExecuteLocalUpdatesCommand() {
        let command = CommandFactory.CreateDataViewCommand(this.task.getTaskTag(), DataViewCommandType.ExecuteLocalUpdates);
        return await this.task.DataviewManager.Execute(command);
    }
    async checkAndCommitPerDataview(dataviewmanager, reversibleExit, level, oper, refResult) {
        refResult.value = new ReturnResult();
        let returnValue = false;
        let currentTransaction = dataviewmanager.Transaction;
        if (currentTransaction !== null && !this.task.isAborting() &&
            currentTransaction.isOpened() && currentTransaction.isOwner(this.task) &&
            currentTransaction.getLevel() === level) {
            let cmd = CommandFactory.CreateTransactionCommand(oper, this.task.getTaskTag(), reversibleExit, level);
            if (this.isClosingTopmostTask && MGDataCollection.Instance.StartupMgData.getFirstTask().ClosingFormUI)
                this.task.getMGData().CmdsToServer.Add(cmd);
            try {
                this.task.TryingToCommit = true;
                if (!(this.isClosingTopmostTask && MGDataCollection.Instance.StartupMgData.getFirstTask().ClosingFormUI))
                    refResult.value = await dataviewmanager.Execute(cmd);
            }
            finally {
                this.task.TryingToCommit = false;
            }
            returnValue = true;
        }
        return returnValue;
    }
    HandelTransactionErrorHandlingsRetry(transBegin) {
        let task = this.task;
        if (task.Transaction === null && transBegin[0] === ConstInterface.TRANS_NONE) {
            task.TransactionErrorHandlingsRetry = new Transaction(task, task.getTaskTag());
            task.TransactionErrorHandlingsRetry.setTransBegin(ConstInterface.TRANS_RECORD_PREFIX);
            transBegin[0] = ConstInterface.TRANS_RECORD_PREFIX;
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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