import { DcValuesBuilderBase } from "@magic-xpa/gui";
import { Logger, StorageAttribute, XMLConstants, XmlParser } from "@magic-xpa/utils";
import { ConstInterface } from "../ConstInterface";
import { Environment } from "../env/Environment";
export class XMLBasedDcValuesBuilder extends DcValuesBuilderBase {
    set SerializedDCVals(value) {
        this.parser.setXMLdata(value);
        this.parser.setCurrIndex(0);
    }
    constructor() {
        super();
        this.dcv = null;
        this.parser = null;
        this.parser = new XmlParser();
    }
    Build() {
        this.dcv = null;
        let endContext = this.parser.getXMLdata().indexOf(XMLConstants.TAG_TERM, this.parser.getCurrIndex());
        if (endContext !== -1 && endContext < this.parser.getXMLdata().length) {
            let tag = this.parser.getXMLsubstring(endContext);
            this.parser.add2CurrIndex(tag.indexOf(ConstInterface.MG_TAG_DC_VALS) + ConstInterface.MG_TAG_DC_VALS.length);
            let tokensVector = XmlParser.getTokens(this.parser.getXMLsubstring(endContext), XMLConstants.XML_ATTR_DELIM);
            this.dcv = this.CreateDcValues();
            this.InitDCValues(this.dcv, tokensVector);
        }
        return this.dcv;
    }
    InitDCValues(dcv, tokensVector) {
        let type = StorageAttribute.NONE;
        let displayValues = null;
        let serializedLinkValues = null;
        for (let j = 0; j < tokensVector.length; j += 2) {
            let attribute = (tokensVector.get_Item(j));
            let valueStr = (tokensVector.get_Item(j + 1));
            switch (attribute) {
                case XMLConstants.MG_ATTR_ID:
                    this.SetId(dcv, XmlParser.getInt(valueStr));
                    break;
                case XMLConstants.MG_ATTR_TYPE:
                    type = valueStr[0];
                    this.SetType(dcv, type);
                    break;
                case ConstInterface.MG_ATTR_DISP:
                    valueStr = XmlParser.unescape(valueStr);
                    displayValues = this.ParseValues(valueStr, StorageAttribute.UNICODE);
                    break;
                case ConstInterface.MG_ATTR_LINKED:
                    valueStr = XmlParser.unescape(valueStr);
                    serializedLinkValues = valueStr;
                    break;
                case ConstInterface.MG_ATTR_NULL_FLAGS:
                    this.SetNullFlags(dcv, valueStr);
                    break;
                default:
                    Logger.Instance.WriteExceptionToLogWithMsg("in DcValues.initElements() unknown attribute: " + attribute);
                    break;
            }
        }
        this.SetDisplayValues(dcv, displayValues);
        if (serializedLinkValues == null)
            this.SetLinkValues(dcv, displayValues);
        else
            this.SetLinkValues(dcv, this.ParseValues(serializedLinkValues, type));
    }
    ParseValues(valueStr, dataType) {
        let useHex = false;
        if (Environment.Instance.GetDebugLevel() > 1 ||
            dataType === StorageAttribute.ALPHA || dataType === StorageAttribute.UNICODE || dataType === StorageAttribute.BOOLEAN) {
            useHex = true;
        }
        return super.ParseValues(valueStr, dataType, useHex);
    }
}
//# sourceMappingURL=data:application/json;base64,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