import { CommandsProcessorBase_SendingInstruction } from "../CommandsProcessorBase";
import { MirrorPrmMap } from "../util/PrmMap";
import { NNumber, NString, StringBuilder } from "@magic-xpa/mscorelib";
import { DisplayConvertor } from "@magic-xpa/gui";
import { ConstInterface } from "../ConstInterface";
import { CommandFactory } from "../commands/ClientToServer/CommandFactory";
import { RemoteCommandsProcessor } from "../remote/RemoteCommandsProcessor";
import { Environment } from "./Environment";
import { LastFocusedManager } from "../rt/LastFocusedManager";
import { AccessHelper } from "../AccessHelper";
import { MirrorString } from "./MirrorString";
export class EnvParamsTable extends MirrorPrmMap {
    constructor() {
        super(MirrorString);
        this.mirroredID = ConstInterface.MG_TAG_ENV_PARAM;
    }
    get(s) {
        let valName = null;
        let ret = null;
        if (s.charAt(0) !== '[') {
            valName = s;
            s = NString.Insert(s, 0, ConstInterface.INI_SECTION_MAGIC_ENV_BRACKETS);
        }
        else if (s.startsWith(ConstInterface.INI_SECTION_MAGIC_ENV_BRACKETS))
            valName = s.substr(ConstInterface.INI_SECTION_MAGIC_ENV_BRACKETS.length);
        if (!s.startsWith(ConstInterface.INI_SECTION_LOGICAL_NAMES_BRACKETS))
            s = s.toUpperCase();
        if (valName !== null)
            ret = this.getFromEnvironment(valName);
        if (ret !== null)
            return ret;
        try {
            let resultObject = super.getvalue(s);
            if (resultObject !== null) {
                ret = resultObject.ToString();
                if (valName !== null) {
                    ret = this.getProcessedValue(valName, ret);
                }
            }
        }
        catch (ex_BE) {
        }
        return ret;
    }
    getln(section, number) {
        section = section.toUpperCase().trim();
        let sectionFound = false;
        let keys = this.values.Keys;
        for (let i = 0; i < keys.length; i++) {
            let key = keys[i];
            if (key.startsWith(section)) {
                sectionFound = true;
                if (number > 1)
                    number--;
                else
                    return key.substr(section.length) + "=" + this.values.get_Item(key);
            }
            else if (sectionFound)
                break;
        }
        return null;
    }
    getFromEnvironment(valName) {
        switch (valName.toLowerCase()) {
            case ConstInterface.MG_ATTR_DECIMAL_SEPARATOR:
                return Environment.Instance.GetDecimal();
            case ConstInterface.MG_ATTR_DATE:
                return DisplayConvertor.Instance.getDateChar().toString();
            case ConstInterface.MG_ATTR_TIME:
                return Environment.Instance.GetTime();
            case ConstInterface.MG_ATTR_OWNER:
                return Environment.Instance.getOwner();
            case ConstInterface.MG_ATTR_DATEMODE:
                return Environment.Instance.GetDateMode(LastFocusedManager.Instance.getCurrTask().getCompIdx());
            case ConstInterface.MG_ATTR_CENTURY:
                return Environment.Instance.GetCentury(LastFocusedManager.Instance.getCurrTask().getCompIdx()).toString();
            case ConstInterface.MG_ATTR_IDLETIME:
                return Environment.Instance.getIdleTime(LastFocusedManager.Instance.getCurrTask().getCompIdx()).toString();
            case ConstInterface.MG_ATTR_UPD_IN_QUERY:
                return Environment.Instance.allowUpdateInQueryMode(LastFocusedManager.Instance.getCurrTask().getCompIdx()).toString();
            case ConstInterface.MG_ATTR_CRE_IN_MODIFY:
                return Environment.Instance.allowCreateInModifyMode(LastFocusedManager.Instance.getCurrTask().getCompIdx()).toString();
            case ConstInterface.MG_ATTR_CONTEXT_INACTIVITY_TIMEOUT:
                return Environment.Instance.getContextInactivityTimeout().toString();
            case ConstInterface.MG_ATTR_CONTEXT_UNLOAD_TIMEOUT:
                return Environment.Instance.getContextUnloadTimeout().toString();
            case ConstInterface.MG_ATTR_TERMINAL:
                return Environment.Instance.getTerminal().toString();
            case ConstInterface.MG_ATTR_WEBCLIENT_REINIT_SESSION:
                return Environment.Instance.getWebClientReinitSession();
        }
        return null;
    }
    getProcessedValue(valName, val) {
        switch (valName.toLowerCase()) {
            case ConstInterface.MG_ATTR_HTTP_TIMEOUT:
            case ConstInterface.MG_ATTR_RTF_BUFFER_SIZE:
            case ConstInterface.MG_ATTR_RANGE_POP_TIME:
            case ConstInterface.MG_ATTR_TEMP_POP_TIME:
            case ConstInterface.MG_ATTR_BATCH_PAINT_TIME:
                return NNumber.Parse(val).toString();
            case ConstInterface.MG_ATTR_USE_SIGNED_BROWSER_CLIENT:
            case ConstInterface.MG_ATTR_CLOSE_PRINTED_TABLES_IN_SUBTASKS:
            case ConstInterface.MG_ATTR_GENERIC_TEXT_PRINTING:
            case ConstInterface.MG_ATTR_HIGH_RESOLUTION_PRINT:
            case ConstInterface.MG_ATTR_MERGE_TRIM:
            case ConstInterface.MG_ATTR_ORIGINAL_IMAGE_LOAD:
            case ConstInterface.MG_ATTR_PRINT_DATA_TRIM:
            case ConstInterface.MG_ATTR_PSCRIPT_PRINT_NT:
            case ConstInterface.MG_ATTR_SPECIAL_CONV_ADD_SLASH:
            case ConstInterface.MG_ATTR_SPECIAL_FULL_EXPAND_PRINT:
            case ConstInterface.MG_ATTR_SPECIAL_FULL_TEXT:
            case ConstInterface.MG_ATTR_SPECIAL_LAST_LINE_PRINT:
            case ConstInterface.MG_ATTR_SPECIAL_PRINTER_OEM:
            case ConstInterface.MG_ATTR_EMBED_FONTS:
            case ConstInterface.MG_ATTR_CENTER_SCREEN_IN_ONLINE:
            case ConstInterface.MG_ATTR_REPOSITION_AFTER_MODIFY:
            case ConstInterface.MG_ATTR_ISAM_TRANSACTION:
                return (val[0] === 'Y' || val[0] === '1') ? "Y" : "N";
            case ConstInterface.MG_ATTR_TIME_SEPARATOR:
            case ConstInterface.MG_ATTR_IOTIMING:
            case ConstInterface.MG_ATTR_THOUSAND_SEPARATOR:
                return val[0].toString();
            default:
                return val;
        }
    }
    async set(s, updateIni) {
        let allOK = true;
        let sendToServer = false;
        let name, val;
        let i;
        let serverVal = s;
        let offsets = new Array(s.length + 1);
        let offsetsChars = new Array(s.length + 1);
        offsets[0] = 0;
        offsetsChars[0] = 's';
        let nextOffset = 1;
        for (i = 1; i < s.length; i++) {
            if ((s[i] === '=' || s[i] === ',') && s[i - 1] !== '\\') {
                offsets[nextOffset] = i + 1;
                offsetsChars[nextOffset] = s[i];
                nextOffset++;
            }
            if (s[i] === '*') {
                s = NString.Remove(s, i, 1);
                break;
            }
            if (s[i] === '\\') {
                s = NString.Remove(s, i, 1);
            }
        }
        offsets[nextOffset] = s.length + 1;
        offsetsChars[nextOffset] = '\0';
        nextOffset++;
        for (i = 0; i < nextOffset - 1; i++) {
            name = s.substr(offsets[i], offsets[i + 1] - offsets[i] - 1);
            if (s[offsets[i + 1] - 1] === '=') {
                i++;
                let valInit = i;
                let allowedSeparators = this.getAllowedSeparators(name);
                for (let sep = 0; sep < allowedSeparators; sep++) {
                    if (offsetsChars[i + 1] === ',')
                        i++;
                    else
                        break;
                }
                val = s.substr(offsets[valInit], offsets[i + 1] - offsets[valInit] - 1);
            }
            else
                val = null;
            if (this.isReservedLogicalName(name)) {
                allOK = false;
                continue;
            }
            if (name[0] !== '[')
                name = NString.Insert(name, 0, ConstInterface.INI_SECTION_MAGIC_ENV_BRACKETS);
            if (!name.startsWith(ConstInterface.INI_SECTION_LOGICAL_NAMES_BRACKETS))
                name = name.toUpperCase();
            name = name.trim();
            val = val.trim();
            sendToServer = true;
            if (!NString.IsNullOrEmpty(val) ||
                name.startsWith(ConstInterface.INI_SECTION_LOGICAL_NAMES_BRACKETS)) {
                super.setValue(name, new MirrorString(val), !updateIni);
                this.checkSetInEnvironment(name, val);
            }
            else
                super.remove(name);
        }
        if (updateIni && sendToServer) {
            let cmd = CommandFactory.CreateIniputForceWriteCommand(serverVal);
            AccessHelper.mgDataTable.getMGData(0).CmdsToServer.Add(cmd);
            await RemoteCommandsProcessor.GetInstance().Execute(CommandsProcessorBase_SendingInstruction.ONLY_COMMANDS);
        }
        return allOK;
    }
    isReservedLogicalName(name) {
        if (!name.startsWith("[")) {
            name = NString.Insert(name, 0, ConstInterface.INI_SECTION_LOGICAL_NAMES_BRACKETS);
            if (this.values.ContainsKey(name) && this.values.get_Item(name).isReserved())
                return true;
        }
        return false;
    }
    getAllowedSeparators(name) {
        if (name.charAt(0) !== '[')
            return 0;
        let section = name.substr(1, name.indexOf(']') - 1);
        let param = name.substr(name.indexOf(']') + 1);
        switch (section.toUpperCase()) {
            case ConstInterface.INI_SECTION_MAGIC_ENV:
                if (param.toUpperCase() === ConstInterface.MG_ATTR_LANGUAGE.toUpperCase())
                    return 999;
                else
                    return 0;
            case ConstInterface.INI_SECTION_MAGIC_SYSTEMS:
                return 8;
            case ConstInterface.INI_SECTION_MAGIC_DBMS:
                return 13;
            case ConstInterface.INI_SECTION_MAGIC_SERVERS:
                return 6;
            case ConstInterface.INI_SECTION_MAGIC_COMMS:
                return 2;
            case ConstInterface.INI_SECTION_MAGIC_PRINTERS:
                return 3;
            case ConstInterface.INI_SECTION_MAGIC_SYSTEM_MENU:
                return 11;
            case ConstInterface.INI_SECTION_MAGIC_DATABASES:
                return 21;
            case ConstInterface.INI_SECTION_MAGIC_LANGUAGE:
                return 1;
            case ConstInterface.INI_SECTION_MAGIC_SERVICES:
                return 8;
            case ConstInterface.INI_SECTION_TOOLS_MENU:
                return 7;
            default:
                return 0;
        }
    }
    checkSetInEnvironment(name, val) {
        if (name.startsWith(ConstInterface.INI_SECTION_MAGIC_ENV_BRACKETS)) {
            name = name.substr(ConstInterface.INI_SECTION_MAGIC_ENV_BRACKETS.length);
            switch (name.toLowerCase()) {
                case ConstInterface.MG_ATTR_DECIMAL_SEPARATOR:
                    Environment.Instance.setDecimalSeparator(val[0]);
                    break;
                case ConstInterface.MG_ATTR_DATE:
                    DisplayConvertor.Instance.setDateChar(val[0].charCodeAt(0));
                    break;
                case ConstInterface.MG_ATTR_TIME:
                    Environment.Instance.setTimeSeparator(val[0]);
                    break;
                case ConstInterface.MG_ATTR_OWNER:
                    Environment.Instance.setOwner(val);
                    break;
                case ConstInterface.MG_ATTR_DATEMODE:
                    Environment.Instance.setDateMode(LastFocusedManager.Instance.getCurrTask().getCompIdx(), val[0]);
                    break;
                case ConstInterface.MG_ATTR_CENTURY:
                    Environment.Instance.setCentury(LastFocusedManager.Instance.getCurrTask().getCompIdx(), NNumber.Parse(val));
                    break;
                case ConstInterface.MG_ATTR_IDLETIME:
                    Environment.Instance.setIdleTime(LastFocusedManager.Instance.getCurrTask().getCompIdx(), NNumber.Parse(val));
                    break;
                case ConstInterface.MG_ATTR_UPD_IN_QUERY_LOWER:
                    Environment.Instance.setAllowUpdateInQueryMode(LastFocusedManager.Instance.getCurrTask().getCompIdx(), val[0] === '1');
                    break;
                case ConstInterface.MG_ATTR_CRE_IN_MODIFY_LOWER:
                    Environment.Instance.setAllowCreateInModifyMode(LastFocusedManager.Instance.getCurrTask().getCompIdx(), val[0] === '1');
                    break;
                case ConstInterface.MG_ATTR_CONTEXT_INACTIVITY_TIMEOUT_LOWER:
                    Environment.Instance.setContextInactivityTimeout(NNumber.Parse(val));
                    break;
                case ConstInterface.MG_ATTR_CONTEXT_INACTIVITY_WARNING_TIME_LOWER:
                    Environment.Instance.setContextInactivityWarningTime(NNumber.Parse(val));
                    break;
                case ConstInterface.MG_ATTR_CONTEXT_UNLOAD_TIMEOUT_LOWER:
                    Environment.Instance.setContextUnloadTimeout(NNumber.Parse(val));
                    break;
                case ConstInterface.MG_ATTR_TERMINAL:
                    Environment.Instance.setTerminal(NNumber.Parse(val));
                    break;
            }
        }
    }
    translate(logicalName) {
        let stringBuilder = new StringBuilder(logicalName);
        this.log(stringBuilder);
        return stringBuilder.ToString();
    }
    log(stringBldr) {
        let finished;
        do {
            let offset = 0;
            finished = true;
            while (offset < stringBldr.Length && stringBldr.get_Item(offset) > '\0') {
                if (stringBldr.get_Item(offset) === '%') {
                    let oldLength = stringBldr.Length;
                    offset = this.log_trans(stringBldr, offset);
                    if (oldLength !== stringBldr.Length)
                        finished = false;
                }
                else
                    offset = offset + 1;
            }
        } while (!finished);
    }
    log_trans(stringBldr, offset) {
        let ignoreTrans = false;
        let startSym = offset;
        let endSym = offset + 1;
        while (endSym < stringBldr.Length) {
            if (stringBldr.get_Item(endSym) === '%')
                break;
            endSym++;
        }
        if (endSym >= stringBldr.Length) {
            offset = endSym;
            ignoreTrans = true;
        }
        else if (stringBldr.get_Item(endSym) !== '%')
            offset++;
        if (!ignoreTrans) {
            let sym = ConstInterface.INI_SECTION_LOGICAL_NAMES_BRACKETS +
                stringBldr.ToString(startSym + 1, endSym - startSym - 1);
            let trans = this.get(sym);
            if (trans === null) {
                stringBldr.Replace(stringBldr.ToString(offset, endSym + 1 - offset), "", offset, endSym + 1 - offset);
                offset += 1;
            }
            else {
                stringBldr.Replace(stringBldr.ToString(startSym, endSym + 1 - startSym), trans, startSym, endSym + 1 - startSym);
            }
        }
        return offset;
    }
}
EnvParamsTable.Instance = new EnvParamsTable();
//# sourceMappingURL=data:application/json;base64,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