import { ConstInterface } from "../ConstInterface";
import { ParamParseResult } from "../util/ParamParseResult";
import { XmlParser } from "@magic-xpa/utils";
import { Debug, NString } from "@magic-xpa/mscorelib";
export class MirrorString {
    constructor(s) {
        this._reserved = false;
        this._value = null;
        if (arguments.length === 0) {
            this.constructor_0();
            return;
        }
        this.constructor_1(s);
    }
    constructor_0() {
        this._reserved = false;
    }
    constructor_1(s) {
        this._value = s;
        this._reserved = false;
    }
    mirrorToXML() {
        return ConstInterface.MG_ATTR_ENV_VALUE + "=\"" + XmlParser.escape(this._value) + "\"";
    }
    init(name, xmlParser) {
        let valueStart, valueEnd, reserveStart, paramEnd;
        let xmlData = xmlParser.getXMLdata();
        let valueAttr = ConstInterface.MG_ATTR_ENV_VALUE + "=\"";
        paramEnd = xmlData.indexOf("/>", xmlParser.getCurrIndex());
        valueStart = NString.IndexOf(xmlData, valueAttr, xmlParser.getCurrIndex(), paramEnd - xmlParser.getCurrIndex());
        if (valueStart !== -1) {
            valueStart += valueAttr.length;
            reserveStart = NString.IndexOf(xmlData, ConstInterface.MG_ATTR_ENV_RESERVED + "=\"", xmlParser.getCurrIndex(), paramEnd - xmlParser.getCurrIndex());
            valueEnd = reserveStart !== -1
                ? xmlData.indexOf(ConstInterface.MG_ATTR_ENV_RESERVED + "=\"", valueStart) - 2
                : paramEnd - 1;
            this._value = xmlData.substr(valueStart, valueEnd - valueStart).trim();
            if (reserveStart !== -1) {
                reserveStart += ConstInterface.MG_ATTR_ENV_RESERVED.length + 2;
                this._reserved = (xmlData[reserveStart] === 'Y');
            }
            else
                this._reserved = false;
            xmlParser.setCurrIndex(valueEnd);
            if (name.startsWith(ConstInterface.INI_SECTION_LOGICAL_NAMES_BRACKETS))
                return ParamParseResult.OK;
            else
                return ParamParseResult.TOUPPER;
        }
        else if (NString.IndexOf(xmlData, ConstInterface.MG_ATTR_ENV_REMOVED, xmlParser.getCurrIndex(), paramEnd - xmlParser.getCurrIndex()) !== -1) {
            return ParamParseResult.DELETE;
        }
        else {
            Debug.Assert(false, "bad XML parsing");
            return ParamParseResult.FAILED;
        }
    }
    ToString() {
        return this._value;
    }
    isReserved() {
        return this._reserved;
    }
}
//# sourceMappingURL=data:application/json;base64,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