import { InternalInterface } from '@magic-xpa/utils';
export class ActionManager {
    constructor() {
        this._actCount = null;
        this._actState = null;
        this._numerator = 0;
        this._numerator = 0;
        this._actState = new Array(InternalInterface.MG_ACT_TOT_CNT);
        for (let _ai = 0; _ai < this._actState.length; ++_ai)
            this._actState[_ai] = false;
        this._actCount = new Array(InternalInterface.MG_ACT_TOT_CNT);
        for (let _ai = 0; _ai < this._actCount.length; ++_ai)
            this._actCount[_ai] = 0;
    }
    enable(act, enable) {
        this._actState[act] = enable;
        if (enable) {
            this._numerator++;
            this._actCount[act] = this._numerator;
        }
    }
    isEnabled(act) {
        return this._actState[act];
    }
    getActCount(act) {
        return this._actCount[act];
    }
    enableList(act, enable, onlyIfChanged) {
        for (let i = 0; i < act.length; i = i + 1) {
            let num = act[i];
            let flag = !onlyIfChanged || this._actState[num] !== enable;
            if (flag) {
                this.enable(num, enable);
            }
        }
    }
    enableNavigationActions(enable) {
        this.enableList(ActionManager.actNavigation, enable, false);
    }
}
ActionManager.actEnabled = [
    InternalInterface.MG_ACT_CLOSE, InternalInterface.MG_ACT_EXIT,
    InternalInterface.MG_ACT_RTO_MODIFY,
    InternalInterface.MG_ACT_RTO_CREATE,
    InternalInterface.MG_ACT_RTO_QUERY, InternalInterface.MG_ACT_OK,
    InternalInterface.MG_ACT_CANCEL,
    InternalInterface.MG_ACT_TBL_PRVFLD,
    InternalInterface.MG_ACT_TBL_NXTFLD,
    InternalInterface.MG_ACT_TBL_BEGLINE,
    InternalInterface.MG_ACT_TBL_ENDLINE,
    InternalInterface.MG_ACT_TBL_BEGPAGE,
    InternalInterface.MG_ACT_TAB_NEXT,
    InternalInterface.MG_ACT_TAB_PREV,
    InternalInterface.MG_ACT_TBL_ENDPAGE,
    InternalInterface.MG_ACT_USING_HELP,
    InternalInterface.MG_ACT_ABOUT,
    InternalInterface.MG_ACT_CTRL_HIT, InternalInterface.MG_ACT_HIT,
    InternalInterface.MG_ACT_WEB_ON_DBLICK,
    InternalInterface.MG_ACT_WEB_CLICK,
    InternalInterface.MG_ACT_RT_REFRESH_RECORD,
    InternalInterface.MG_ACT_RT_REFRESH_SCREEN,
    InternalInterface.MG_ACT_RT_REFRESH_VIEW,
    InternalInterface.MG_ACT_RT_QUIT,
    InternalInterface.MG_ACT_SERVER_TERMINATION,
    InternalInterface.MG_ACT_SUBFORM_REFRESH,
    InternalInterface.MG_ACT_SUBFORM_CLOSE,
    InternalInterface.MG_ACT_EXIT_SYSTEM,
    InternalInterface.MG_ACT_SUBFORM_OPEN,
    InternalInterface.MG_ACT_COL_SORT,
    InternalInterface.MG_ACT_CTRL_MODIFY,
    InternalInterface.MG_ACT_ROLLBACK,
    InternalInterface.MG_ACT_EXT_EVENT,
    InternalInterface.MG_ACT_COL_CLICK,
    InternalInterface.MG_ACT_PRESS,
    InternalInterface.MG_ACT_ENABLE_EVENTS,
    InternalInterface.MG_ACT_COL_FILTER,
    InternalInterface.MG_ACT_INDEX_CHANGE,
    InternalInterface.MG_ACT_WEBCLIENT_ROUTE,
    InternalInterface.MG_ACT_SET_EXTERNAL_VALUE,
    InternalInterface.MG_ACT_FETCH_RECORDS_AHEAD_FROM_SERVER,
    InternalInterface.MG_ACT_CONTEXT_REMOVE
];
ActionManager.actNavigation = [
    InternalInterface.MG_ACT_TBL_PRVLINE,
    InternalInterface.MG_ACT_TBL_PRVPAGE,
    InternalInterface.MG_ACT_TBL_BEGTBL,
    InternalInterface.MG_ACT_TBL_NXTLINE,
    InternalInterface.MG_ACT_TBL_NXTPAGE,
    InternalInterface.MG_ACT_TBL_ENDTBL
];
//# sourceMappingURL=data:application/json;base64,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