import { ApplicationException, Exception, NString, RefParam, StringBuilder, isNullOrUndefined } from "@magic-xpa/mscorelib";
import { BrkScope, Constants, InternalInterface, Logger, Logger_LogLevels, StorageAttributeCheck, XMLConstants, XmlParser } from "@magic-xpa/utils";
import { Event } from "./Event";
import { FieldBase } from "../data/FieldBase";
import { OperationTable } from "../rt/OperationTable";
import { FlowMonitorQueue } from "../util/FlowMonitorQueue";
import { ServerError } from "../remote/ServerError";
import { YesNoExp } from "../exp/YesNoExp";
import { ConstInterface } from "../ConstInterface";
import { FlowMonitorInterface } from "../FlowMonitorInterface";
import { LastFocusedManager } from "../rt/LastFocusedManager";
import { AccessHelper } from "../AccessHelper";
import { RemoteCommandsProcessor } from "../remote/RemoteCommandsProcessor";
import { Environment } from "../env/Environment";
export class EventHandler {
    constructor() {
        this._enabledExp = new YesNoExp(true);
        this._operationTab = null;
        this._propagateExp = new YesNoExp(true);
        this._isHandlerOnForm = false;
        this._ctrl = null;
        this._ctrlName = null;
        this._dvLen = 0;
        this._dvPos = 0;
        this._evt = null;
        this._handledByClient = false;
        this._handlerFld = null;
        this._hasParameters = false;
        this._id = 0;
        this._level = '\0';
        this._scope = null;
        this._task = null;
        this._taskMgdID = -1;
        this._operationTab = new OperationTable();
    }
    getCtrlName() {
        return this._ctrlName;
    }
    fillData(taskRef, parser) {
        if (this._task === null) {
            this._task = taskRef;
            this._taskMgdID = this._task.getMgdID();
        }
        while (this.initInnerObjects(parser, parser.getNextTag())) {
        }
        let dataView = this._task.DataView;
        this._hasParameters = dataView.ParametersExist(this._dvPos, this._dvLen);
    }
    initInnerObjects(parser, foundTagName) {
        if (foundTagName === null)
            return false;
        if (foundTagName === ConstInterface.MG_TAG_HANDLER)
            this.initInnerElements(parser, this._task);
        else if (foundTagName === ConstInterface.MG_TAG_OPER)
            this._operationTab.fillData(this._task, this, parser);
        else if (foundTagName === ConstInterface.MG_TAG_EVENT && this._evt === null) {
            this._evt = new Event();
            this._evt.fillData(parser, this._task);
            if (this._evt.getType() === ConstInterface.EVENT_TYPE_TIMER ||
                (this._evt.getType() === ConstInterface.EVENT_TYPE_USER && this._evt.getUserEventType() === ConstInterface.EVENT_TYPE_TIMER))
                this._task.getMGData().addTimerHandler(this);
            if (((this._evt.getType() === ConstInterface.EVENT_TYPE_INTERNAL && this._evt.getInternalCode() === InternalInterface.MG_ACT_ZOOM) || (this._evt.getType() === ConstInterface.EVENT_TYPE_USER && this._evt.getUserEvent() !== null && this._evt.getUserEventType() === ConstInterface.EVENT_TYPE_INTERNAL && this._evt.getUserEvent().getInternalCode() === InternalInterface.MG_ACT_ZOOM)) && !this._task.getEnableZoomHandler()) {
                if (this._handlerFld !== null)
                    this._handlerFld.setHasZoomHandler();
                else if (this._ctrl !== null)
                    this._ctrl.HasZoomHandler = true;
                else
                    this._task.setEnableZoomHandler();
            }
        }
        else if (foundTagName === '/' + ConstInterface.MG_TAG_HANDLER) {
            parser.setCurrIndex2EndOfTag();
            return false;
        }
        else {
            Logger.Instance.WriteExceptionToLogWithMsg("there is no such tag in EventHandler.initInnerObjects() " + foundTagName);
            return false;
        }
        return true;
    }
    initInnerElements(parser, taskRef) {
        let endContext = parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex());
        if (endContext !== -1 && endContext < parser.getXMLdata().length) {
            let tag = parser.getXMLsubstring(endContext);
            parser.add2CurrIndex(tag.indexOf(ConstInterface.MG_TAG_HANDLER) + ConstInterface.MG_TAG_HANDLER.length);
            let tokensVector = XmlParser.getTokens(parser.getXMLsubstring(endContext), XMLConstants.XML_ATTR_DELIM);
            this.initElements(tokensVector, taskRef);
            parser.setCurrIndex(++endContext);
            return;
        }
        Logger.Instance.WriteExceptionToLogWithMsg("in Handler.FillData() out of string bounds");
    }
    initElements(tokensVector, taskRef) {
        for (let j = 0; j < tokensVector.length; j += 2) {
            let attribute = (tokensVector.get_Item(j));
            let valueStr = (tokensVector.get_Item(j + 1));
            switch (attribute) {
                case ConstInterface.MG_ATTR_HANDLEDBY:
                    this._handledByClient = (valueStr.toUpperCase() === "C".toUpperCase());
                    break;
                case XMLConstants.MG_ATTR_ID:
                    this._id = XmlParser.getInt(valueStr);
                    break;
                case ConstInterface.MG_ATTR_LEVEL:
                    this._level = valueStr[0];
                    break;
                case ConstInterface.MG_ATTR_OBJECT:
                    let valueStringCtrlName = XmlParser.unescape(valueStr);
                    this._ctrlName = XmlParser.unescape(valueStringCtrlName).toUpperCase();
                    this.calculateCtrlFromControlName(taskRef);
                    break;
                case ConstInterface.MG_ATTR_VARIABLE:
                    this._handlerFld = this._task.DataView.getField(XmlParser.getInt(valueStr));
                    this._handlerFld.setHasChangeEvent();
                    break;
                case ConstInterface.MG_ATTR_SCOPE:
                    this._scope = valueStr[0];
                    break;
                case ConstInterface.MG_ATTR_PROPAGATE:
                    this._propagateExp.setVal(taskRef, valueStr);
                    break;
                case ConstInterface.MG_ATTR_ENABLED:
                    this._enabledExp.setVal(taskRef, valueStr);
                    break;
                case ConstInterface.MG_ATTR_DVPOS:
                    let i = valueStr.indexOf(",");
                    if (i > -1) {
                        this._dvLen = XmlParser.getInt(valueStr.substr(0, i));
                        this._dvPos = XmlParser.getInt(valueStr.substr(i + 1));
                        for (let fldIdx = this._dvPos; fldIdx < this._dvPos + this._dvLen; fldIdx++) {
                            let field = this._task.DataView.getField(fldIdx);
                            field.IsEventHandlerField = true;
                        }
                    }
                    break;
                case ConstInterface.MG_ATTR_HANDLER_ONFORM:
                    this._isHandlerOnForm = XmlParser.getBoolean(valueStr);
                    break;
                default:
                    Logger.Instance.WriteExceptionToLogWithMsg("There is no such tag in EventHandler class. Insert case to EventHandler.initElements for " + attribute);
                    break;
            }
        }
    }
    calculateCtrlFromControlName(taskRef) {
        if (!NString.IsNullOrEmpty(this._ctrlName)) {
            this._ctrl = ((taskRef.getForm() !== null) ? taskRef.getForm().getCtrlByCtrlName(this._ctrlName) : null);
        }
    }
    isSpecificHandlerOf(rtEvt) {
        if (this._ctrl === null && this._ctrlName === null && this._handlerFld === null && !this._isHandlerOnForm)
            return false;
        if (this._scope === BrkScope.Task && this._task !== rtEvt.getTask())
            return false;
        if (this._evt.equals(rtEvt)) {
            if (this._handlerFld !== null) {
                return (this._handlerFld === rtEvt.getFld());
            }
            if (rtEvt.Control !== null && !this._isHandlerOnForm) {
                let eventCtrlName = rtEvt.Control.getControlNameForHandlerSearch();
                if (eventCtrlName !== null && this._ctrlName.toLowerCase() === eventCtrlName.toLowerCase())
                    return true;
            }
            else if (rtEvt.Control === null && this._isHandlerOnForm)
                return true;
        }
        return false;
    }
    isNonSpecificHandlerOf(rtEvt) {
        if (this._ctrl !== null || this._ctrlName !== null || this._handlerFld !== null || this._isHandlerOnForm)
            return false;
        if (this._scope === BrkScope.Task && this._task !== rtEvt.getTask() && rtEvt.getType() !== ConstInterface.EVENT_TYPE_TIMER)
            return false;
        if (this._scope === BrkScope.Global && this._task !== rtEvt.getTask())
            return false;
        if (this._evt.getType() === ConstInterface.EVENT_TYPE_USER && this._evt.getUserEventType() === ConstInterface.EVENT_TYPE_NOTINITED) {
            try {
                this._evt.findUserEvent();
            }
            catch (applicationException) {
                if (applicationException instanceof ApplicationException) {
                }
                else
                    throw applicationException;
            }
        }
        return this._evt.equals(rtEvt);
    }
    isGlobalHandlerOf(rtEvt) {
        if (this._scope !== BrkScope.Global)
            return false;
        if (this._ctrl != null || this._ctrlName != null || this._handlerFld != null || this._isHandlerOnForm)
            return false;
        return this._evt.equals(rtEvt);
    }
    isGlobalSpecificHandlerOf(rtEvt) {
        if (this._scope !== BrkScope.Global)
            return false;
        if (this._ctrl == null && this._ctrlName == null && this._handlerFld == null)
            return false;
        return (this._ctrlName != null && this._evt.equals(rtEvt) &&
            NString.Equals(this._ctrlName, rtEvt.Control.Name, true));
    }
    async execute(rtEvt, returnedFromServer, enabledCndCheckedAndTrue) {
        let ctrl = null;
        let retVal;
        let depth = 0;
        let taskEnd = false;
        let brkLevel = this._task.getBrkLevel();
        let brkLevelIndex = this._task.getBrkLevelIndex();
        let initialLoopStackSize = 0;
        if (taskEnd !== null && this._evt.getType() !== ConstInterface.EVENT_TYPE_EXPRESSION && (this._evt.getType() !== ConstInterface.EVENT_TYPE_USER || (this._evt.getUserEvent().getType() !== ConstInterface.EVENT_TYPE_EXPRESSION && this._evt.getUserEvent().getType() !== ConstInterface.EVENT_TYPE_TIMER))) {
            if (this._evt.getType() !== ConstInterface.EVENT_TYPE_USER_FUNC)
                this._task.setBrkLevel(rtEvt.getBrkLevel(), this._id);
        }
        else
            this._task.setBrkLevel(this._evt.getBrkLevel(), this._id);
        let args = rtEvt.getArgList();
        try {
            let flowMonitor = FlowMonitorQueue.Instance;
            if (rtEvt.getType() === ConstInterface.EVENT_TYPE_INTERNAL && rtEvt.getInternalCode() === InternalInterface.MG_ACT_WEBCLIENT_ROUTE) {
                if (!this._task.IsRoute() && this._task !== AccessHelper.mgDataTable.StartupMgData.getFirstTask()) {
                    return new RetVals(true, true);
                }
            }
            let nextOperIdx = -1;
            if (returnedFromServer) {
                nextOperIdx = AccessHelper.eventsManager.getNextOperIdx(this._operationTab.getOperation(0), false);
            }
            if (nextOperIdx === -1 && !enabledCndCheckedAndTrue && !await this.isEnabled())
                return new RetVals(true, false);
            if (this._scope === BrkScope.Task && (rtEvt.getType() === ConstInterface.EVENT_TYPE_TIMER || rtEvt.getType() === ConstInterface.EVENT_TYPE_EXPRESSION)) {
                let currTask = LastFocusedManager.Instance.getLastFocusedTask();
                if (this._task !== currTask)
                    return new RetVals(true, true);
            }
            if (!this._handledByClient) {
                return new RetVals(false, true);
            }
            if (rtEvt.getType() !== ConstInterface.EVENT_TYPE_USER && !await this._evt.dataEventIsTrue())
                return new RetVals(false, true);
            if (rtEvt.getType() === ConstInterface.EVENT_TYPE_INTERNAL && rtEvt.getInternalCode() === InternalInterface.MG_ACT_TASK_SUFFIX)
                taskEnd = true;
            if (rtEvt.getType() === ConstInterface.EVENT_TYPE_INTERNAL) {
                switch (rtEvt.getInternalCode()) {
                    case InternalInterface.MG_ACT_REC_PREFIX:
                        flowMonitor.addTaskFlowRec(InternalInterface.MG_ACT_REC_PREFIX, FlowMonitorInterface.FLWMTR_START, this._task.GetTaskDetails());
                        break;
                    case InternalInterface.MG_ACT_REC_SUFFIX:
                        flowMonitor.addTaskFlowRec(InternalInterface.MG_ACT_REC_SUFFIX, FlowMonitorInterface.FLWMTR_START, this._task.GetTaskDetails());
                        break;
                    case InternalInterface.MG_ACT_CTRL_SUFFIX:
                        flowMonitor.addTaskFlowCtrl(InternalInterface.MG_ACT_CTRL_SUFFIX, rtEvt.Control.Name, FlowMonitorInterface.FLWMTR_START, this._task.GetTaskDetails());
                        break;
                    case InternalInterface.MG_ACT_CTRL_PREFIX:
                        flowMonitor.addTaskFlowCtrl(InternalInterface.MG_ACT_CTRL_PREFIX, rtEvt.Control.Name, FlowMonitorInterface.FLWMTR_START, this._task.GetTaskDetails());
                        break;
                    case InternalInterface.MG_ACT_VARIABLE:
                        flowMonitor.addTaskFlowFld(InternalInterface.MG_ACT_VARIABLE, rtEvt.getFld().getName(), FlowMonitorInterface.FLWMTR_START, this._task.GetTaskDetails());
                        break;
                    case InternalInterface.MG_ACT_CTRL_VERIFICATION:
                        flowMonitor.addTaskFlowCtrl(InternalInterface.MG_ACT_CTRL_VERIFICATION, rtEvt.Control.Name, FlowMonitorInterface.FLWMTR_START, this._task.GetTaskDetails());
                        break;
                    case InternalInterface.MG_ACT_TASK_PREFIX:
                        flowMonitor.addTaskFlowRec(InternalInterface.MG_ACT_TASK_PREFIX, FlowMonitorInterface.FLWMTR_START, this._task.GetTaskDetails());
                        break;
                    case InternalInterface.MG_ACT_TASK_SUFFIX:
                        flowMonitor.addTaskFlowRec(InternalInterface.MG_ACT_TASK_SUFFIX, FlowMonitorInterface.FLWMTR_START, this._task.GetTaskDetails());
                        break;
                    default:
                        flowMonitor.addTaskFlowHandler(this._evt.getBrkLevel(true), FlowMonitorInterface.FLWMTR_START, this._task.GetTaskDetails());
                        break;
                }
            }
            else
                flowMonitor.addTaskFlowHandler(this._evt.getBrkLevel(true), FlowMonitorInterface.FLWMTR_START, this._task.GetTaskDetails());
            try {
                if (taskEnd !== null)
                    ctrl = rtEvt.Control;
                let mgdID = AccessHelper.mgDataTable.currMgdID;
                let isChangedCurrWnd = false;
                let isChangedCurrWndRef = new RefParam(isChangedCurrWnd);
                if (this._evt.getType() === ConstInterface.EVENT_TYPE_TIMER && mgdID !== rtEvt.getMgdID()) {
                    AccessHelper.mgDataTable.currMgdID = rtEvt.getMgdID();
                    isChangedCurrWndRef.value = true;
                }
                await this.resetLocalVariables(args);
                initialLoopStackSize = this._task.getLoopStackSize();
                let retVals = null;
                if (this._operationTab.getSize() > 0)
                    retVals = await this.executeOperations(0, this._operationTab.getSize() - 1, taskEnd, mgdID, depth, isChangedCurrWndRef, false, false, -1);
                isChangedCurrWnd = isChangedCurrWndRef.value;
                if (retVals !== null)
                    return retVals;
                if (!taskEnd)
                    await this._task.evalEndCond(ConstInterface.END_COND_EVAL_IMMIDIATE);
                if (isChangedCurrWnd) {
                    let oldMgd = AccessHelper.mgDataTable.getMGData(mgdID);
                    if (oldMgd !== null && !oldMgd.IsAborting)
                        AccessHelper.mgDataTable.currMgdID = mgdID;
                }
            }
            catch (ex) {
                if (ex instanceof ServerError) {
                    if (Logger.Instance.LogLevel !== Logger_LogLevels.Basic)
                        Logger.Instance.WriteExceptionToLog(ex);
                    throw ex;
                }
                else if (ex instanceof Exception) {
                    Logger.Instance.WriteExceptionToLog(ex);
                    return new RetVals(false, true);
                }
                else
                    throw ex;
            }
            finally {
                retVal = await this._propagateExp.getVal();
                let currLoopStackSize = this._task.getLoopStackSize();
                for (; currLoopStackSize > initialLoopStackSize; currLoopStackSize = currLoopStackSize--)
                    this._task.popLoopCounter();
            }
            if (args !== null)
                await this.getArgValsFromFlds(args);
            if (rtEvt.getType() === ConstInterface.EVENT_TYPE_INTERNAL) {
                switch (rtEvt.getInternalCode()) {
                    case InternalInterface.MG_ACT_REC_PREFIX:
                        flowMonitor.addTaskFlowRec(InternalInterface.MG_ACT_REC_PREFIX, FlowMonitorInterface.FLWMTR_END, this._task.GetTaskDetails());
                        break;
                    case InternalInterface.MG_ACT_REC_SUFFIX:
                        flowMonitor.addTaskFlowRec(InternalInterface.MG_ACT_REC_SUFFIX, FlowMonitorInterface.FLWMTR_END, this._task.GetTaskDetails());
                        break;
                    case InternalInterface.MG_ACT_TASK_PREFIX:
                        flowMonitor.addTaskFlowRec(InternalInterface.MG_ACT_TASK_PREFIX, FlowMonitorInterface.FLWMTR_END, this._task.GetTaskDetails());
                        break;
                    case InternalInterface.MG_ACT_TASK_SUFFIX:
                        flowMonitor.addTaskFlowRec(InternalInterface.MG_ACT_TASK_SUFFIX, FlowMonitorInterface.FLWMTR_END, this._task.GetTaskDetails());
                        break;
                    case InternalInterface.MG_ACT_CTRL_SUFFIX:
                        flowMonitor.addTaskFlowCtrl(InternalInterface.MG_ACT_CTRL_SUFFIX, ctrl.Name, FlowMonitorInterface.FLWMTR_END, this._task.GetTaskDetails());
                        break;
                    case InternalInterface.MG_ACT_CTRL_PREFIX:
                        flowMonitor.addTaskFlowCtrl(InternalInterface.MG_ACT_CTRL_PREFIX, ctrl.Name, FlowMonitorInterface.FLWMTR_END, this._task.GetTaskDetails());
                        break;
                    case InternalInterface.MG_ACT_VARIABLE:
                        flowMonitor.addTaskFlowFld(InternalInterface.MG_ACT_VARIABLE, rtEvt.getFld().getName(), FlowMonitorInterface.FLWMTR_END, this._task.GetTaskDetails());
                        break;
                    case InternalInterface.MG_ACT_CTRL_VERIFICATION:
                        flowMonitor.addTaskFlowCtrl(InternalInterface.MG_ACT_CTRL_VERIFICATION, ctrl.Name, FlowMonitorInterface.FLWMTR_END, this._task.GetTaskDetails());
                        break;
                    default:
                        flowMonitor.addTaskFlowHandler(this._evt.getBrkLevel(true), FlowMonitorInterface.FLWMTR_END, this._task.GetTaskDetails());
                        break;
                }
            }
            else
                flowMonitor.addTaskFlowHandler(this._evt.getBrkLevel(true), 1, this._task.GetTaskDetails());
        }
        finally {
            this._task.setBrkLevel(brkLevel, brkLevelIndex);
        }
        return new RetVals(retVal, true);
    }
    async executeOperations(fromIdx, toIdx, taskEnd, mgdID, depth, isChangedCurrWndRef, inBlockIf, inReturnedFromServer, inNextOperIdx) {
        let oper;
        let operType;
        let nextOperIdx = -1;
        let returnedFromServer = false;
        let mgd = this._task.getMGData();
        let execFlowIdx = fromIdx;
        let retvals;
        let blockIfReturnedFromServer = false;
        let executeBlock;
        let blockLoopExeconServer;
        let flowMonitor = FlowMonitorQueue.Instance;
        let routeOperationExecuted = false;
        if (!inReturnedFromServer) {
            oper = this._operationTab.getOperation(execFlowIdx);
            nextOperIdx = AccessHelper.eventsManager.getNextOperIdx(oper, true);
            if (nextOperIdx > -1) {
                returnedFromServer = true;
                if (inBlockIf)
                    blockIfReturnedFromServer = true;
            }
            else
                returnedFromServer = false;
        }
        else {
            returnedFromServer = inReturnedFromServer;
            nextOperIdx = inNextOperIdx;
        }
        for (; execFlowIdx <= toIdx &&
            (!AccessHelper.eventsManager.GetStopExecutionFlag()) &&
            !mgd.IsAborting && !routeOperationExecuted; execFlowIdx += 1) {
            if (inBlockIf && blockIfReturnedFromServer && this._operationTab.getOperation(toIdx).getServerId() < nextOperIdx)
                break;
            oper = this._operationTab.getOperation(execFlowIdx);
            operType = oper.getType();
            blockIfReturnedFromServer = false;
            if (RemoteCommandsProcessor.GetInstance().DelayCommandExecution) {
                this._task.setUseLoopStack(depth > 0);
                await oper.operServer(null);
                break;
            }
            if (returnedFromServer && oper.getServerId() < nextOperIdx)
                if (operType !== ConstInterface.MG_OPER_BLOCK)
                    continue;
                else if (this._operationTab.getOperation(oper.getBlockEnd()).getServerId() < nextOperIdx)
                    continue;
            if (!taskEnd) {
                let mainLevel = this._task.getMainLevel().toLowerCase();
                if (await this._task.evalEndCond(ConstInterface.END_COND_EVAL_IMMIDIATE) && Environment.Instance.getSpecialImmediateHandlerEnd() &&
                    mainLevel != "RP".toLowerCase() && mainLevel != "TP".toLowerCase() && mainLevel != "RS".toLowerCase() && mainLevel != "TS".toLowerCase())
                    break;
            }
            if (this._taskMgdID !== mgdID)
                isChangedCurrWndRef.value = true;
            if (!this._task.isMainProg() && this._task.isOpenWin())
                AccessHelper.mgDataTable.currMgdID = this._taskMgdID;
            await AccessHelper.eventsManager.CheckAndShowSpinner(true);
            switch (operType) {
                case ConstInterface.MG_OPER_VERIFY:
                    if (await oper.execute(returnedFromServer)) {
                        if (!(this._task.getBrkLevel() === "TS")) {
                            AccessHelper.eventsManager.setStopExecution(true);
                        }
                        if (this._task.getInRecordSuffix() && this._task.getLevel() === Constants.TASK_LEVEL_TASK)
                            this._task.setLevel(Constants.TASK_LEVEL_RECORD);
                        return new RetVals(false, true);
                    }
                    break;
                case ConstInterface.MG_OPER_LOOP:
                    this._task.enterLoop();
                    this._task.increaseLoopCounter();
                    this._task.setUseLoopStack(true);
                    await flowMonitor.addFlowFieldOperation(oper, true, this._task.GetTaskDetails());
                    blockLoopExeconServer = false;
                    if (!oper.getExecOnServer()) {
                        while (await oper.execute(false)) {
                            retvals = await this.executeOperations(execFlowIdx + 1, oper.getBlockClose() - 1, taskEnd, mgdID, depth + 1, isChangedCurrWndRef, false, false, -1);
                            if (retvals !== null)
                                return retvals;
                            if ((mgd.IsAborting || AccessHelper.eventsManager.GetStopExecutionFlag()))
                                break;
                            this._task.increaseLoopCounter();
                            this._task.setUseLoopStack(true);
                        }
                    }
                    else {
                        if (await oper.execute(false))
                            blockLoopExeconServer = true;
                    }
                    if (!blockLoopExeconServer)
                        execFlowIdx = oper.getBlockEnd() - 1;
                    this._task.leaveLoop();
                    break;
                case ConstInterface.MG_OPER_BLOCK:
                    if (!oper.getExecOnServer() || (returnedFromServer && oper.getServerId() < nextOperIdx)) {
                        this._task.setUseLoopStack(true);
                        if (!returnedFromServer || oper.getServerId() >= nextOperIdx)
                            execFlowIdx = await this.getSignificantBlock(execFlowIdx, oper.getBlockEnd());
                        else
                            execFlowIdx = this.getStartBlockIfIdxByOper(execFlowIdx, nextOperIdx);
                    }
                    else {
                        this._task.setUseLoopStack(depth > 0);
                        await oper.operServer(null);
                        nextOperIdx = AccessHelper.eventsManager.getNextOperIdx(oper, true);
                        if (nextOperIdx > -1) {
                            returnedFromServer = true;
                            if (inBlockIf)
                                blockIfReturnedFromServer = true;
                            if (nextOperIdx < this._operationTab.getOperation(oper.getBlockEnd()).getServerId()) {
                                while (this._operationTab.getOperation(oper.getBlockClose()).getServerId() < nextOperIdx) {
                                    execFlowIdx = oper.getBlockClose();
                                    oper = this._operationTab.getOperation(execFlowIdx);
                                }
                            }
                        }
                        else {
                            returnedFromServer = false;
                            execFlowIdx = -1;
                        }
                    }
                    if (execFlowIdx !== -1) {
                        executeBlock = true;
                        oper = this._operationTab.getOperation(execFlowIdx);
                        if (returnedFromServer) {
                            if (this._operationTab.getOperation(oper.getBlockClose()).getServerId() <= nextOperIdx) {
                                executeBlock = false;
                                blockIfReturnedFromServer = true;
                            }
                        }
                        if (executeBlock) {
                            retvals = await this.executeOperations(execFlowIdx + 1, oper.getBlockClose() - 1, taskEnd, mgdID, depth + 1, isChangedCurrWndRef, true, returnedFromServer, nextOperIdx);
                            if (retvals !== null)
                                if (!retvals.ReturnedFromServer)
                                    return retvals;
                                else {
                                    returnedFromServer = retvals.ReturnedFromServer;
                                    nextOperIdx = retvals.NextOperIdx;
                                    blockIfReturnedFromServer = retvals.BlockIfReturnedFromServer;
                                    execFlowIdx = oper.getBlockEnd() - 1;
                                    continue;
                                }
                        }
                    }
                    execFlowIdx = oper.getBlockEnd() - 1;
                    break;
                case ConstInterface.MG_OPER_ENDBLOCK:
                    await flowMonitor.addFlowFieldOperation(oper, true, this._task.GetTaskDetails());
                    break;
                case ConstInterface.MG_OPER_CALL:
                    this._task.setUseLoopStack(depth > 0);
                    routeOperationExecuted = await oper.execute(returnedFromServer);
                    break;
                default:
                    this._task.setUseLoopStack(depth > 0);
                    await oper.execute(returnedFromServer);
                    break;
            }
            if (!blockIfReturnedFromServer) {
                nextOperIdx = AccessHelper.eventsManager.getNextOperIdx(oper, true);
                if (nextOperIdx > -1) {
                    returnedFromServer = true;
                    if (inBlockIf)
                        blockIfReturnedFromServer = true;
                }
                else
                    returnedFromServer = false;
            }
        }
        if (routeOperationExecuted)
            retvals = new RetVals(false, true);
        else if (blockIfReturnedFromServer)
            retvals = new RetVals(nextOperIdx, returnedFromServer, blockIfReturnedFromServer);
        else
            retvals = null;
        return retvals;
    }
    async getSignificantBlock(startBlockIdx, endIdx) {
        let retIdx = -1;
        while (startBlockIdx < endIdx) {
            let oper = this._operationTab.getOperation(startBlockIdx);
            let operType = oper.getType();
            if (operType !== ConstInterface.MG_OPER_BLOCK && operType !== ConstInterface.MG_OPER_ELSE && operType !== ConstInterface.MG_OPER_SERVER)
                break;
            if (await oper.execute(false)) {
                retIdx = startBlockIdx;
                break;
            }
            else
                startBlockIdx = oper.getBlockClose();
        }
        return retIdx;
    }
    getStartBlockIdxByEnd(endIdx) {
        let retIdx = -1;
        let found = false;
        let j;
        for (j = endIdx - 1; j >= 0 && !found; j--) {
            let oper = this._operationTab.getOperation(j);
            let operType = oper.getType();
            if (operType === ConstInterface.MG_OPER_BLOCK || operType === ConstInterface.MG_OPER_LOOP) {
                if (oper.getBlockEnd() === endIdx) {
                    retIdx = j;
                    found = true;
                }
            }
        }
        return retIdx;
    }
    getStartBlockIdxByElse(elseIdx) {
        let retIdx = -1;
        let found = false;
        let elseBlockEnd = this._operationTab.getOperation(elseIdx).getBlockEnd();
        let j;
        for (j = elseIdx - 1; j >= 0 && !found; j--) {
            let oper = this._operationTab.getOperation(j);
            let operType = oper.getType();
            if (operType === ConstInterface.MG_OPER_BLOCK) {
                if (oper.getBlockEnd() === elseBlockEnd) {
                    retIdx = j;
                    found = true;
                }
            }
        }
        return retIdx;
    }
    getStartBlockIfIdxByOper(blockOperIdx, srvrOperIdx) {
        let retIdx = -1;
        let found = false;
        let j = this._operationTab.serverId2operIdx(srvrOperIdx, blockOperIdx) - 1;
        if (j === -2) {
            j = this._operationTab.serverId2FollowingOperIdx(srvrOperIdx, blockOperIdx) - 1;
        }
        while (j >= 0 && !found) {
            let oper = this._operationTab.getOperation(j);
            let operType = oper.getType();
            if (operType === ConstInterface.MG_OPER_BLOCK) {
                if (j === blockOperIdx) {
                    retIdx = j;
                    found = true;
                }
                else
                    j--;
            }
            else if (operType === ConstInterface.MG_OPER_ELSE) {
                let blockStrt = this.getStartBlockIdxByElse(j);
                if (blockStrt === blockOperIdx) {
                    retIdx = j;
                    found = true;
                }
                else
                    j = blockStrt - 1;
            }
            else if (operType === ConstInterface.MG_OPER_ENDBLOCK)
                j = this.getStartBlockIdxByEnd(j) - 1;
            else
                j--;
        }
        return retIdx;
    }
    getLevel() {
        return this._level;
    }
    getEvent() {
        return this._evt;
    }
    getId() {
        return this._id;
    }
    async isEnabled() {
        return await this._enabledExp.getVal();
    }
    async resetLocalVariables(args) {
        let dv = this._task.DataView;
        let argIdx = 0;
        try {
            for (let fieldIdx = this._dvPos; fieldIdx < this._dvPos + this._dvLen; fieldIdx++) {
                let aField = dv.getField(fieldIdx);
                let varIsParm = !this._hasParameters || aField.isParam();
                if ((args !== null && argIdx < args.getSize()) && varIsParm) {
                    if (!args.getArg(argIdx).skipArg()) {
                        await args.getArg(argIdx).setValueToField(aField);
                    }
                    else {
                        aField.invalidate(true, FieldBase.CLEAR_FLAGS);
                        await aField.compute(false);
                    }
                    argIdx++;
                }
                else {
                    aField.invalidate(true, FieldBase.CLEAR_FLAGS);
                    await aField.compute(false);
                }
                await aField.updateDisplay();
            }
        }
        catch (exception) {
            throw exception;
        }
    }
    async getArgValsFromFlds(args) {
        let dv = this._task.DataView;
        let k = 0;
        let j;
        for (j = this._dvPos; j < this._dvPos + this._dvLen && k < args.getSize(); j++) {
            let aField = dv.getField(j);
            if (!this._hasParameters || aField.isParam()) {
                let arg = args.getArg(k);
                if (arg.getType() === ConstInterface.ARG_TYPE_FIELD) {
                    let argFld = arg.getField();
                    if (argFld.getTask() !== null && !argFld.getTask().isAborting()) {
                        let val = aField.getValue(false);
                        await argFld.setValueAndStartRecompute(val, aField.isNull(), true, aField.isModified(), false);
                        await argFld.updateDisplay();
                    }
                }
                k++;
            }
        }
    }
    getTask() {
        return this._task;
    }
    argsMatch(Exp_params) {
        let argsMatched = true;
        let dv = this._task.DataView;
        let j = 0;
        let paramCount = 0;
        for (let i = this._dvPos; i < this._dvPos + this._dvLen; i++) {
            let field = dv.getField(i);
            if (field.isParam()) {
                paramCount++;
                if (j < Exp_params.length) {
                    let fieldAttr = field.getType();
                    let argAttr = Exp_params[j].Attr;
                    if (!Exp_params[j].IsNull && !StorageAttributeCheck.isTheSameType(fieldAttr, argAttr) && !StorageAttributeCheck.StorageFldAlphaUnicodeOrBlob(fieldAttr, argAttr)) {
                        argsMatched = false;
                        break;
                    }
                    j++;
                }
            }
        }
        if (paramCount !== Exp_params.length) {
            argsMatched = false;
        }
        return argsMatched;
    }
    getOperationTab() {
        return this._operationTab;
    }
    getControlNameForControlHeader() {
        if (this.getEvent().getType() == ConstInterface.EVENT_TYPE_INTERNAL) {
            if (this.getEvent().isControlHeader() && !isNullOrUndefined(this._ctrl))
                return this.getCtrlName();
        }
        return NString.Empty;
    }
    getVarNameForVariableHeader() {
        if (this.getEvent().isVariableHeader() && !isNullOrUndefined(this._handlerFld))
            return this._handlerFld.getVarName().toUpperCase();
        return NString.Empty;
    }
    getEventHandlerInfo() {
        let eventDescription = new StringBuilder();
        this.getEvent().AppendDescription(eventDescription);
        let headerAdditionalInfo = this.getControlNameForControlHeader() + this.getVarNameForVariableHeader();
        eventDescription.Append(headerAdditionalInfo);
        if (!NString.IsNullOrEmpty(eventDescription.toString()))
            eventDescription = new StringBuilder(' ' + eventDescription.toString(), eventDescription.toString().length + 1);
        return NString.Format("Handler {0}{1}", this.getEvent().getEventType(), eventDescription);
    }
    toString() {
        return NString.Format("(Handler for {0} on task {1}, scope {2})", this._evt, this._task, this._scope);
    }
}
export class RetVals {
    constructor(pOrOperIdx, eOrInReturnedFromServer, inBlockIfReturnedFromServer) {
        this.BlockIfReturnedFromServer = false;
        this.Enabled = false;
        this.NextOperIdx = 0;
        this.Propagate = false;
        this.ReturnedFromServer = false;
        if (arguments.length === 2)
            this.constructor_0(pOrOperIdx, eOrInReturnedFromServer);
        else
            this.constructor_1(pOrOperIdx, eOrInReturnedFromServer, inBlockIfReturnedFromServer);
    }
    constructor_0(p, e) {
        this.Propagate = p;
        this.Enabled = e;
        this.NextOperIdx = 0;
        this.ReturnedFromServer = false;
        this.BlockIfReturnedFromServer = false;
    }
    constructor_1(operIdx, inReturnedFromServer, inBlockIfReturnedFromServer) {
        this.Propagate = false;
        this.Enabled = true;
        this.NextOperIdx = operIdx;
        this.ReturnedFromServer = inReturnedFromServer;
        this.BlockIfReturnedFromServer = inBlockIfReturnedFromServer;
    }
}
//# sourceMappingURL=data:application/json;base64,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