import { Char, Int32, List, NString } from "@magic-xpa/mscorelib";
import { ForceExit, InternalInterface, Priority, XMLConstants, XmlParser } from "@magic-xpa/utils";
import { GuiFieldBase, MgControlBase, Modifiers, PropInterface, } from "@magic-xpa/gui";
import { EventSubType } from "../enums";
import { Event } from "./Event";
import { ConstInterface } from "../ConstInterface";
import { ArgumentsList } from "../rt/ArgumentsList";
import { TaskBase } from "../tasks/TaskBase";
import { RunTimeEventBase } from "./RunTimeEventBase";
import { AccessHelper } from "../AccessHelper";
export class RunTimeEvent extends RunTimeEventBase {
    set Control(value) {
        this._ctrl = value;
    }
    set DisplayLine(value) {
        this._displayLine = value;
    }
    get Control() {
        return this._ctrl;
    }
    get ControlsList() {
        return this._controlsList;
    }
    get Direction() {
        return this._direction;
    }
    constructor(taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt, ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask, ignoreSpecifiedControlOrGuiTriggeredEventOrLineOrXOrControlOrActivatedFromMDIFrame, yOrCtlIdx, width, height) {
        super();
        this._controlsList = null;
        this._direction = 0;
        this._displayLine = Int32.MinValue;
        this._eventSubType = EventSubType.Normal;
        this._actEnableList = null;
        this._argList = null;
        this._ctrl = null;
        this._dotNetObject = null;
        this._eventFld = null;
        this._fromServer = false;
        this._guiTriggeredEvent = false;
        this._immediate = false;
        this._isIdleTimer = false;
        this._isRealRefresh = true;
        this._mgdId = 0;
        this._routeParams = null;
        this._mprgCreator = null;
        this._priority = Priority.HIGH;
        this._produceClick = false;
        this._reversibleExit = true;
        this._selectionEnd = 0;
        this._selectionStart = 0;
        this._sendAll = false;
        this._task = null;
        this._taskTag = null;
        this._val = null;
        this.IgnoreSpecifiedControl = false;
        this.LastFocusedVal = null;
        if (arguments.length === 1 && (taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt === null || taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt instanceof TaskBase))
            this.constructor_5(taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt);
        else if (arguments.length === 2 && (taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt === null || taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt instanceof TaskBase) && (ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask === null || ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask instanceof MgControlBase))
            this.constructor_6(taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt, ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask);
        else if (arguments.length === 1 && (taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt === null || taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt instanceof MgControlBase))
            this.constructor_7(taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt);
        else if (arguments.length === 2 && (taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt === null || taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt instanceof MgControlBase) && (ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask === null || ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask.constructor === Boolean))
            this.constructor_8(taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt, ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask);
        else if (arguments.length === 3 && (taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt === null || taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt instanceof MgControlBase) && (ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask === null || ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask.constructor === Boolean) && (ignoreSpecifiedControlOrGuiTriggeredEventOrLineOrXOrControlOrActivatedFromMDIFrame === null || ignoreSpecifiedControlOrGuiTriggeredEventOrLineOrXOrControlOrActivatedFromMDIFrame.constructor === Boolean))
            this.constructor_9(taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt, ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask, ignoreSpecifiedControlOrGuiTriggeredEventOrLineOrXOrControlOrActivatedFromMDIFrame);
        else if (arguments.length === 2 && (taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt === null || taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt instanceof TaskBase) && (ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask === null || ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask.constructor === Boolean))
            this.constructor_10(taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt, ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask);
        else if (arguments.length === 1 && (taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt === null || taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt instanceof GuiFieldBase))
            this.constructor_11(taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt);
        else if (arguments.length === 2 && (taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt === null || taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt instanceof MgControlBase) && (ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask === null || ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask.constructor === Number))
            this.constructor_12(taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt, ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask);
        else if (arguments.length === 3 && (taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt === null || taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt instanceof MgControlBase) && (ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask === null || ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask.constructor === Number) && (ignoreSpecifiedControlOrGuiTriggeredEventOrLineOrXOrControlOrActivatedFromMDIFrame === null || ignoreSpecifiedControlOrGuiTriggeredEventOrLineOrXOrControlOrActivatedFromMDIFrame.constructor === Boolean))
            this.constructor_13(taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt, ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask, ignoreSpecifiedControlOrGuiTriggeredEventOrLineOrXOrControlOrActivatedFromMDIFrame);
        else if (arguments.length === 3 && (taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt === null || taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt instanceof MgControlBase) && (ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask === null || ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask instanceof List) && (ignoreSpecifiedControlOrGuiTriggeredEventOrLineOrXOrControlOrActivatedFromMDIFrame === null || ignoreSpecifiedControlOrGuiTriggeredEventOrLineOrXOrControlOrActivatedFromMDIFrame.constructor === Boolean))
            this.constructor_14(taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt, ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask, ignoreSpecifiedControlOrGuiTriggeredEventOrLineOrXOrControlOrActivatedFromMDIFrame);
        else if (arguments.length === 3 && (taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt === null || taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt instanceof MgControlBase) && (ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask === null || ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask.constructor === Number) && (ignoreSpecifiedControlOrGuiTriggeredEventOrLineOrXOrControlOrActivatedFromMDIFrame === null || ignoreSpecifiedControlOrGuiTriggeredEventOrLineOrXOrControlOrActivatedFromMDIFrame.constructor === Number))
            this.constructor_15(taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt, ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask);
        else if (arguments.length === 6)
            this.constructor_16(taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt);
        else if (arguments.length === 2 && (taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt === null || taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt instanceof Event) && (ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask === null || ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask instanceof RunTimeEvent)) {
            super.constructor_1(taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt);
            this.constructor_17(ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask);
        }
        else if (arguments.length === 1 && taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt instanceof RunTimeEvent)
            Object.assign(this, taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt);
    }
    constructor_5(taskRef) {
        this.init(taskRef);
    }
    constructor_6(taskRef, ctrlRef) {
        this.constructor_5((ctrlRef !== null) ? ctrlRef.getForm().getTask() : taskRef);
        this.Control = ctrlRef;
    }
    constructor_7(ctrlRef) {
        this.constructor_6(null, ctrlRef);
        if (ctrlRef !== null && super.getType() === Char.MinValue) {
            let prop = ctrlRef.GetComputedProperty(PropInterface.PROP_TYPE_TRIGGER);
            if (prop !== null) {
                let xmlParser = new XmlParser(prop.GetComputedValue());
                super.fillData(xmlParser, ctrlRef.getForm().getTask());
            }
        }
    }
    constructor_8(ctrlRef, guiTriggeredEvent) {
        this.constructor_7(ctrlRef);
        this._guiTriggeredEvent = guiTriggeredEvent;
        if (guiTriggeredEvent) {
            this._priority = Priority.LOW;
        }
    }
    constructor_9(ctrlRef, guiTriggeredEvent, ignoreSpecifiedControl) {
        this.constructor_8(ctrlRef, guiTriggeredEvent);
        this.IgnoreSpecifiedControl = ignoreSpecifiedControl;
    }
    constructor_10(taskref, guiTriggeredEvent) {
        this.constructor_5(taskref);
        this._guiTriggeredEvent = guiTriggeredEvent;
        if (guiTriggeredEvent) {
            this._priority = Priority.LOW;
        }
    }
    constructor_11(fldRef) {
        this._eventFld = fldRef;
        this.init((fldRef !== null) ? fldRef.getTask() : null);
    }
    constructor_12(ctrlRef, line) {
        this.constructor_7(ctrlRef);
        this._displayLine = line;
    }
    constructor_13(ctrlRef, line, guiTriggeredEvent) {
        this.constructor_8(ctrlRef, guiTriggeredEvent);
        this._displayLine = line;
    }
    constructor_14(ctrlRef, controlsList, guiTriggeredEvent) {
        this.constructor_8(ctrlRef, guiTriggeredEvent);
        this._controlsList = controlsList;
    }
    constructor_15(ctrlRef, direction) {
        this.constructor_8(ctrlRef, true);
        this._direction = direction;
    }
    constructor_16(ctrlRef) {
        this.constructor_8(ctrlRef, true);
    }
    constructor_17(rtEvt) {
        this._taskTag = rtEvt._taskTag;
        this._task = rtEvt._task;
        this.Control = rtEvt.Control;
        this._eventFld = rtEvt._eventFld;
        this._mgdId = rtEvt._mgdId;
        this._displayLine = rtEvt._displayLine;
        this._reversibleExit = rtEvt._reversibleExit;
        this._argList = rtEvt._argList;
        this._immediate = rtEvt._immediate;
        this._mprgCreator = rtEvt._mprgCreator;
        this._priority = rtEvt._priority;
        this._guiTriggeredEvent = rtEvt._guiTriggeredEvent;
        this._isIdleTimer = rtEvt._isIdleTimer;
        this._val = rtEvt._val;
        this._selectionStart = rtEvt._selectionStart;
        this._selectionEnd = rtEvt._selectionEnd;
        this._controlsList = rtEvt._controlsList;
        this._direction = rtEvt._direction;
        this._dotNetObject = rtEvt._dotNetObject;
        this.LastFocusedVal = rtEvt.LastFocusedVal;
        this._routeParams = rtEvt._routeParams;
    }
    CompareTo(obj) {
        let otherTimeEvent = obj;
        let otherPriority = otherTimeEvent._priority;
        let result = otherPriority - this._priority;
        if (result === 0)
            result = (this._timestamp - otherTimeEvent._timestamp);
        return result;
    }
    replicate() {
        let runTimeEvent = new RunTimeEvent(this);
        runTimeEvent.setTimestamp();
        return runTimeEvent;
    }
    init(taskRef) {
        this._task = (taskRef || AccessHelper.mgDataTable.getCurrMGData().getFirstTask());
        this._taskTag = ((this._task === null) ? "" : this._task.getTaskTag());
        this._mprgCreator = null;
    }
    convertParamsToArgs() {
        this._argList = new ArgumentsList();
        this._argList.buildListFromParams(this._parameters, this._paramAttrs, this._paramVals, this._paramNulls);
        this._parameters = 0;
        this._paramAttrs = null;
        this._paramVals = null;
        this._paramNulls = null;
    }
    getTask() {
        super.findUserEvent();
        return this._task;
    }
    setTask(taskRef) {
        this._task = taskRef;
        if (this._task !== null)
            this._taskTag = this._task.getTaskTag();
        else
            this._taskTag = null;
    }
    setTimer(sec, mgdID, isIdle) {
        this._type = ConstInterface.EVENT_TYPE_TIMER;
        this._seconds = sec;
        this._mgdId = mgdID;
        this._isIdleTimer = isIdle;
    }
    getDisplayLine() {
        return this._displayLine;
    }
    getMgdID() {
        return this._mgdId;
    }
    getBrkLevel(flowMonitor) {
        if (arguments.length === 0) {
            return this.getBrkLevel_00();
        }
        return this.getBrkLevel_01(flowMonitor);
    }
    getBrkLevel_00() {
        let level = super.getBrkLevel();
        if (this._type === ConstInterface.EVENT_TYPE_INTERNAL) {
            switch (this.InternalEvent) {
                case InternalInterface.MG_ACT_CTRL_PREFIX:
                case InternalInterface.MG_ACT_CTRL_SUFFIX:
                case InternalInterface.MG_ACT_CTRL_VERIFICATION:
                    level += this.Control.Name;
                    break;
                case InternalInterface.MG_ACT_VARIABLE:
                    level += this._eventFld.getVarName();
                    break;
            }
        }
        return level;
    }
    getBrkLevel_01(flowMonitor) {
        return super.getBrkLevel(flowMonitor);
    }
    setCtrl(newCtrl) {
        this._ctrl = newCtrl;
    }
    setNonReversibleExit() {
        this._reversibleExit = false;
    }
    reversibleExit() {
        return this._reversibleExit;
    }
    buildXML(message) {
        message.Append("\n   " + XMLConstants.TAG_OPEN + ConstInterface.MG_TAG_EVENT);
        if (this._type !== Char.MinValue)
            message.Append(" " + ConstInterface.MG_ATTR_EVENTTYPE + "=\"" + this._type + "\"");
        if (this._type === ConstInterface.EVENT_TYPE_SYSTEM && this.kbdItm != null) {
            let modifier = this.kbdItm.getModifier();
            if (modifier !== Modifiers.MODIFIER_NONE)
                message.Append(" " + ConstInterface.MG_ATTR_MODIFIER + "=\"" + modifier + "\"");
            message.Append(" " + ConstInterface.MG_ATTR_KEYCODE + "=\"" + this.kbdItm.getKeyCode() + "\"");
        }
        if (this.InternalEvent !== Int32.MinValue)
            message.Append(" " + ConstInterface.MG_ATTR_INTERNALEVENT + "=\"" + this.InternalEvent + "\"");
        if (this._seconds !== Int32.MinValue)
            message.Append(" " + ConstInterface.MG_ATTR_SECONDS + "=\"" + this._seconds + "\"");
        if (this.Exp != null)
            message.Append(" " + XMLConstants.MG_ATTR_EXP + "=\"" + this.Exp.getId() + "\"");
        if (this._forceExit !== ForceExit.None)
            message.Append(" " + XMLConstants.MG_ATTR_EXP + "=\"" + this._forceExit + "\"");
        if (this.UserEvt != null)
            message.Append(" " + ConstInterface.MG_ATTR_USER + "=\"" + this.UserEvtTaskTag + "," + this._userEvtIdx + "\"");
        message.Append(XMLConstants.TAG_TERM);
    }
    getArgList() {
        return this._argList;
    }
    setArgList(aArgList) {
        let result = this._argList === null;
        this._argList = aArgList;
        return result;
    }
    setRouteParamList(routeParams) {
        this._routeParams = routeParams;
    }
    getRouteParamList() {
        return this._routeParams;
    }
    setImmediate(val) {
        this._immediate = val;
    }
    isImmediate() {
        return this._immediate;
    }
    setMainPrgCreator(src) {
        this._mprgCreator = src;
    }
    getMainPrgCreator() {
        return this._mprgCreator;
    }
    setIsRealRefresh(val) {
        this._isRealRefresh = val;
    }
    getRefreshType() {
        return this._isRealRefresh;
    }
    setFromServer() {
        this._fromServer = true;
    }
    resetFromServer() {
        this._fromServer = false;
    }
    isFromServer() {
        return this._fromServer;
    }
    isQuit() {
        return this._eventSubType === EventSubType.CancelIsQuit;
    }
    RollbackInCancel() {
        return this._eventSubType !== EventSubType.CancelWithNoRollback;
    }
    ExitDueToError() {
        return this._eventSubType === EventSubType.ExitDueToError;
    }
    RtViewRefreshUseCurrentRow() {
        return this._eventSubType === EventSubType.RtRefreshViewUseCurrentRow;
    }
    SetEventSubType(eventSubType) {
        this._eventSubType = eventSubType;
    }
    getFld() {
        return this._eventFld;
    }
    isGuiTriggeredEvent() {
        return this._guiTriggeredEvent;
    }
    getPriority() {
        return this._priority;
    }
    setPriority(priority) {
        this._priority = priority;
    }
    isIdleTimer() {
        return this._isIdleTimer;
    }
    getValue() {
        return this._val;
    }
    setValue(val) {
        this._val = val;
    }
    getStartSelection() {
        return this._selectionStart;
    }
    getEndSelection() {
        return this._selectionEnd;
    }
    setEditParms(start, end, text) {
        this._selectionStart = start;
        this._selectionEnd = end;
        this.setValue(text);
    }
    isProduceClick() {
        return this._produceClick;
    }
    setProduceClick(produceClick) {
        this._produceClick = produceClick;
    }
    getActEnableList() {
        return this._actEnableList;
    }
    isSendAll() {
        return this._sendAll;
    }
    setSendAll(sendAll) {
        this._sendAll = sendAll;
    }
    isBlockedByModalWindow(activeWindowData) {
        if (activeWindowData.IsModal) {
            let eventTask = this.getTask();
            let baseTask = activeWindowData.getTask(0);
            if (eventTask !== baseTask && baseTask.isDescendentOf(eventTask))
                return true;
        }
        return false;
    }
    toString() {
        return NString.Format("{{RTEvent {0} ({1}), type {2}{3}}}", [
            this.getBrkLevel(), this.InternalEvent, this._type, (this._task === null) ? "" : (" on " + this._task)
        ]);
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiUnVuVGltZUV2ZW50LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvZW5naW5lL3NyYy9ldmVudC9SdW5UaW1lRXZlbnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUFDLElBQUksRUFBZSxLQUFLLEVBQUUsSUFBSSxFQUFFLE9BQU8sRUFBZ0IsTUFBTSxzQkFBc0IsQ0FBQztBQUM1RixPQUFPLEVBQUMsU0FBUyxFQUFFLGlCQUFpQixFQUFFLFFBQVEsRUFBRSxZQUFZLEVBQUUsU0FBUyxFQUFDLE1BQU0sa0JBQWtCLENBQUM7QUFDakcsT0FBTyxFQUFDLFlBQVksRUFBa0IsYUFBYSxFQUFFLFNBQVMsRUFBWSxhQUFhLEdBQUUsTUFBTSxnQkFBZ0IsQ0FBQztBQUNoSCxPQUFPLEVBQUMsWUFBWSxFQUFDLE1BQU0sVUFBVSxDQUFDO0FBQ3RDLE9BQU8sRUFBQyxLQUFLLEVBQUMsTUFBTSxTQUFTLENBQUM7QUFDOUIsT0FBTyxFQUFDLGNBQWMsRUFBQyxNQUFNLG1CQUFtQixDQUFDO0FBQ2pELE9BQU8sRUFBQyxhQUFhLEVBQUMsTUFBTSxxQkFBcUIsQ0FBQztBQUVsRCxPQUFPLEVBQUMsUUFBUSxFQUFDLE1BQU0sbUJBQW1CLENBQUM7QUFDM0MsT0FBTyxFQUFDLGdCQUFnQixFQUFDLE1BQU0sb0JBQW9CLENBQUM7QUFDcEQsT0FBTyxFQUFDLFlBQVksRUFBQyxNQUFNLGlCQUFpQixDQUFDO0FBSzdDLE1BQU0sT0FBTyxZQUFhLFNBQVEsZ0JBQWdCO0lBMkNoRCxJQUFJLE9BQU8sQ0FBQyxLQUFvQjtRQUM5QixJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztJQUNyQixDQUFDO0lBRUQsSUFBSSxXQUFXLENBQUMsS0FBYTtRQUMzQixJQUFJLENBQUMsWUFBWSxHQUFHLEtBQUssQ0FBQztJQUM1QixDQUFDO0lBRUQsSUFBSSxPQUFPO1FBQ1QsT0FBTyxJQUFJLENBQUMsS0FBSyxDQUFDO0lBQ3BCLENBQUM7SUFVRCxJQUFJLFlBQVk7UUFDZCxPQUFPLElBQUksQ0FBQyxhQUFhLENBQUM7SUFDNUIsQ0FBQztJQUVELElBQUksU0FBUztRQUNYLE9BQU8sSUFBSSxDQUFDLFVBQVUsQ0FBQztJQUN6QixDQUFDO0lBZ0JELFlBQVksc0NBQTJDLEVBQUUsMkZBQWlHLEVBQUUsa0ZBQXdGLEVBQUUsU0FBa0IsRUFBRSxLQUFjLEVBQUUsTUFBZTtRQUN2UyxLQUFLLEVBQUUsQ0FBQztRQWhGRixrQkFBYSxHQUF3QixJQUFJLENBQUM7UUFDMUMsZUFBVSxHQUFXLENBQUMsQ0FBQztRQUN2QixpQkFBWSxHQUFXLEtBQUssQ0FBQyxRQUFRLENBQUM7UUFFdEMsa0JBQWEsR0FBaUIsWUFBWSxDQUFDLE1BQU0sQ0FBQztRQUVsRCxtQkFBYyxHQUFhLElBQUksQ0FBQztRQUNoQyxhQUFRLEdBQWtCLElBQUksQ0FBQztRQUMvQixVQUFLLEdBQWtCLElBQUksQ0FBQztRQUM1QixrQkFBYSxHQUFRLElBQUksQ0FBQztRQUMxQixjQUFTLEdBQWlCLElBQUksQ0FBQztRQUMvQixnQkFBVyxHQUFZLEtBQUssQ0FBQztRQUM3Qix1QkFBa0IsR0FBWSxLQUFLLENBQUM7UUFDcEMsZUFBVSxHQUFZLEtBQUssQ0FBQztRQUM1QixpQkFBWSxHQUFZLEtBQUssQ0FBQztRQUM5QixtQkFBYyxHQUFZLElBQUksQ0FBQztRQUMvQixXQUFNLEdBQVcsQ0FBQyxDQUFDO1FBQ25CLGlCQUFZLEdBQWMsSUFBSSxDQUFDO1FBSS9CLGlCQUFZLEdBQWEsSUFBSSxDQUFDO1FBRTlCLGNBQVMsR0FBYSxRQUFRLENBQUMsSUFBSSxDQUFDO1FBRXBDLGtCQUFhLEdBQVksS0FBSyxDQUFDO1FBQy9CLG9CQUFlLEdBQVksSUFBSSxDQUFDO1FBRWhDLGtCQUFhLEdBQVcsQ0FBQyxDQUFDO1FBQzFCLG9CQUFlLEdBQVcsQ0FBQyxDQUFDO1FBQzVCLGFBQVEsR0FBWSxLQUFLLENBQUM7UUFDMUIsVUFBSyxHQUFhLElBQUksQ0FBQztRQUN2QixhQUFRLEdBQVcsSUFBSSxDQUFDO1FBQ3hCLFNBQUksR0FBUSxJQUFJLENBQUM7UUFvQnpCLDJCQUFzQixHQUFZLEtBQUssQ0FBQztRQUV4QyxtQkFBYyxHQUFtQixJQUFJLENBQUM7UUEwQnBDLElBQUksU0FBUyxDQUFDLE1BQU0sS0FBSyxDQUFDLElBQUksQ0FBQyxzQ0FBc0MsS0FBSyxJQUFJLElBQUksc0NBQXNDLFlBQVksUUFBUSxDQUFDO1lBQzNJLElBQUksQ0FBQyxhQUFhLENBQUMsc0NBQXNDLENBQUMsQ0FBQzthQUV4RCxJQUFJLFNBQVMsQ0FBQyxNQUFNLEtBQUssQ0FBQyxJQUFJLENBQUMsc0NBQXNDLEtBQUssSUFBSSxJQUFJLHNDQUFzQyxZQUFZLFFBQVEsQ0FBQyxJQUFJLENBQUMsMkZBQTJGLEtBQUssSUFBSSxJQUFJLDJGQUEyRixZQUFZLGFBQWEsQ0FBQztZQUNsWCxJQUFJLENBQUMsYUFBYSxDQUFDLHNDQUFzQyxFQUFFLDJGQUEyRixDQUFDLENBQUM7YUFFckosSUFBSSxTQUFTLENBQUMsTUFBTSxLQUFLLENBQUMsSUFBSSxDQUFDLHNDQUFzQyxLQUFLLElBQUksSUFBSSxzQ0FBc0MsWUFBWSxhQUFhLENBQUM7WUFDckosSUFBSSxDQUFDLGFBQWEsQ0FBQyxzQ0FBc0MsQ0FBQyxDQUFDO2FBRXhELElBQUksU0FBUyxDQUFDLE1BQU0sS0FBSyxDQUFDLElBQUksQ0FBQyxzQ0FBc0MsS0FBSyxJQUFJLElBQUksc0NBQXNDLFlBQVksYUFBYSxDQUFDLElBQUksQ0FBQywyRkFBMkYsS0FBSyxJQUFJLElBQUksMkZBQTJGLENBQUMsV0FBVyxLQUFLLE9BQU8sQ0FBQztZQUN0WCxJQUFJLENBQUMsYUFBYSxDQUFDLHNDQUFzQyxFQUFFLDJGQUEyRixDQUFDLENBQUM7YUFFckosSUFBSSxTQUFTLENBQUMsTUFBTSxLQUFLLENBQUMsSUFBSSxDQUFDLHNDQUFzQyxLQUFLLElBQUksSUFBSSxzQ0FBc0MsWUFBWSxhQUFhLENBQUMsSUFBSSxDQUFDLDJGQUEyRixLQUFLLElBQUksSUFBSSwyRkFBMkYsQ0FBQyxXQUFXLEtBQUssT0FBTyxDQUFDLElBQUksQ0FBQyxrRkFBa0YsS0FBSyxJQUFJLElBQUksa0ZBQWtGLENBQUMsV0FBVyxLQUFLLE9BQU8sQ0FBQztZQUNya0IsSUFBSSxDQUFDLGFBQWEsQ0FBQyxzQ0FBc0MsRUFBRSwyRkFBMkYsRUFBRSxrRkFBa0YsQ0FBQyxDQUFDO2FBRXpPLElBQUksU0FBUyxDQUFDLE1BQU0sS0FBSyxDQUFDLElBQUksQ0FBQyxzQ0FBc0MsS0FBSyxJQUFJLElBQUksc0NBQXNDLFlBQVksUUFBUSxDQUFDLElBQUksQ0FBQywyRkFBMkYsS0FBSyxJQUFJLElBQUksMkZBQTJGLENBQUMsV0FBVyxLQUFLLE9BQU8sQ0FBQztZQUNqWCxJQUFJLENBQUMsY0FBYyxDQUFDLHNDQUFzQyxFQUFFLDJGQUEyRixDQUFDLENBQUM7YUFFdEosSUFBSSxTQUFTLENBQUMsTUFBTSxLQUFLLENBQUMsSUFBSSxDQUFDLHNDQUFzQyxLQUFLLElBQUksSUFBSSxzQ0FBc0MsWUFBWSxZQUFZLENBQUM7WUFDcEosSUFBSSxDQUFDLGNBQWMsQ0FBQyxzQ0FBc0MsQ0FBQyxDQUFDO2FBRXpELElBQUksU0FBUyxDQUFDLE1BQU0sS0FBSyxDQUFDLElBQUksQ0FBQyxzQ0FBc0MsS0FBSyxJQUFJLElBQUksc0NBQXNDLFlBQVksYUFBYSxDQUFDLElBQUksQ0FBQywyRkFBMkYsS0FBSyxJQUFJLElBQUksMkZBQTJGLENBQUMsV0FBVyxLQUFLLE1BQU0sQ0FBQztZQUNyWCxJQUFJLENBQUMsY0FBYyxDQUFDLHNDQUFzQyxFQUFFLDJGQUEyRixDQUFDLENBQUM7YUFFdEosSUFBSSxTQUFTLENBQUMsTUFBTSxLQUFLLENBQUMsSUFBSSxDQUFDLHNDQUFzQyxLQUFLLElBQUksSUFBSSxzQ0FBc0MsWUFBWSxhQUFhLENBQUMsSUFBSSxDQUFDLDJGQUEyRixLQUFLLElBQUksSUFBSSwyRkFBMkYsQ0FBQyxXQUFXLEtBQUssTUFBTSxDQUFDLElBQUksQ0FBQyxrRkFBa0YsS0FBSyxJQUFJLElBQUksa0ZBQWtGLENBQUMsV0FBVyxLQUFLLE9BQU8sQ0FBQztZQUNwa0IsSUFBSSxDQUFDLGNBQWMsQ0FBQyxzQ0FBc0MsRUFBRSwyRkFBMkYsRUFBRSxrRkFBa0YsQ0FBQyxDQUFDO2FBRTFPLElBQUksU0FBUyxDQUFDLE1BQU0sS0FBSyxDQUFDLElBQUksQ0FBQyxzQ0FBc0MsS0FBSyxJQUFJLElBQUksc0NBQXNDLFlBQVksYUFBYSxDQUFDLElBQUksQ0FBQywyRkFBMkYsS0FBSyxJQUFJLElBQUksMkZBQTJGLFlBQVksSUFBSSxDQUFDLElBQUksQ0FBQyxrRkFBa0YsS0FBSyxJQUFJLElBQUksa0ZBQWtGLENBQUMsV0FBVyxLQUFLLE9BQU8sQ0FBQztZQUM3akIsSUFBSSxDQUFDLGNBQWMsQ0FBQyxzQ0FBc0MsRUFBRSwyRkFBMkYsRUFBRSxrRkFBa0YsQ0FBQyxDQUFDO2FBRTFPLElBQUksU0FBUyxDQUFDLE1BQU0sS0FBSyxDQUFDLElBQUksQ0FBQyxzQ0FBc0MsS0FBSyxJQUFJLElBQUksc0NBQXNDLFlBQVksYUFBYSxDQUFDLElBQUksQ0FBQywyRkFBMkYsS0FBSyxJQUFJLElBQUksMkZBQTJGLENBQUMsV0FBVyxLQUFLLE1BQU0sQ0FBQyxJQUFJLENBQUMsa0ZBQWtGLEtBQUssSUFBSSxJQUFJLGtGQUFrRixDQUFDLFdBQVcsS0FBSyxNQUFNLENBQUM7WUFDbmtCLElBQUksQ0FBQyxjQUFjLENBQUMsc0NBQXNDLEVBQUUsMkZBQTJGLENBQUMsQ0FBQzthQUV0SixJQUFJLFNBQVMsQ0FBQyxNQUFNLEtBQUssQ0FBQztZQUM3QixJQUFJLENBQUMsY0FBYyxDQUFDLHNDQUFzQyxDQUFDLENBQUM7YUFFekQsSUFBSSxTQUFTLENBQUMsTUFBTSxLQUFLLENBQUMsSUFBSSxDQUFDLHNDQUFzQyxLQUFLLElBQUksSUFBSSxzQ0FBc0MsWUFBWSxLQUFLLENBQUMsSUFBSSxDQUFDLDJGQUEyRixLQUFLLElBQUksSUFBSSwyRkFBMkYsWUFBWSxZQUFZLENBQUMsRUFBRTtZQUVoWCxLQUFLLENBQUMsYUFBYSxDQUFDLHNDQUFzQyxDQUFDLENBQUM7WUFDNUQsSUFBSSxDQUFDLGNBQWMsQ0FBRSwyRkFBMkYsQ0FBQyxDQUFDO1NBQ25IO2FBRUksSUFBSSxTQUFTLENBQUMsTUFBTSxLQUFLLENBQUMsSUFBSSxzQ0FBc0MsWUFBWSxZQUFZO1lBQy9GLE1BQU0sQ0FBQyxNQUFNLENBQUMsSUFBSSxFQUFFLHNDQUFzQyxDQUFDLENBQUM7SUFFaEUsQ0FBQztJQU1PLGFBQWEsQ0FBQyxPQUFpQjtRQUNyQyxJQUFJLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxDQUFDO0lBQ3JCLENBQUM7SUFPTyxhQUFhLENBQUMsT0FBaUIsRUFBRSxPQUFzQjtRQUM3RCxJQUFJLENBQUMsYUFBYSxDQUFDLENBQUMsT0FBTyxLQUFLLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBWSxPQUFPLENBQUMsT0FBTyxFQUFFLENBQUMsT0FBTyxFQUFHLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBQzNGLElBQUksQ0FBQyxPQUFPLEdBQUcsT0FBTyxDQUFDO0lBQ3pCLENBQUM7SUFNTyxhQUFhLENBQUMsT0FBc0I7UUFDMUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxJQUFJLEVBQUUsT0FBTyxDQUFDLENBQUM7UUFDbEMsSUFBSSxPQUFPLEtBQUssSUFBSSxJQUFJLEtBQUssQ0FBQyxPQUFPLEVBQUUsS0FBSyxJQUFJLENBQUMsUUFBUSxFQUN6RDtZQUVFLElBQUksSUFBSSxHQUFhLE9BQU8sQ0FBQyxtQkFBbUIsQ0FBQyxhQUFhLENBQUMsaUJBQWlCLENBQUMsQ0FBQztZQUNsRixJQUFJLElBQUksS0FBSyxJQUFJLEVBQUU7Z0JBQ2pCLElBQUksU0FBUyxHQUFjLElBQUksU0FBUyxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsRUFBRSxDQUFDLENBQUM7Z0JBQ2xFLEtBQUssQ0FBQyxRQUFRLENBQUMsU0FBUyxFQUFZLE9BQU8sQ0FBQyxPQUFPLEVBQUUsQ0FBQyxPQUFPLEVBQUUsQ0FBQyxDQUFDO2FBQ2xFO1NBQ0Y7SUFDSCxDQUFDO0lBT08sYUFBYSxDQUFDLE9BQXNCLEVBQUUsaUJBQTBCO1FBQ3RFLElBQUksQ0FBQyxhQUFhLENBQUMsT0FBTyxDQUFDLENBQUM7UUFDNUIsSUFBSSxDQUFDLGtCQUFrQixHQUFHLGlCQUFpQixDQUFDO1FBQzVDLElBQUksaUJBQWlCLEVBQUU7WUFHckIsSUFBSSxDQUFDLFNBQVMsR0FBRyxRQUFRLENBQUMsR0FBRyxDQUFDO1NBQy9CO0lBQ0gsQ0FBQztJQU9PLGFBQWEsQ0FBQyxPQUFzQixFQUFFLGlCQUEwQixFQUFFLHNCQUErQjtRQUN2RyxJQUFJLENBQUMsYUFBYSxDQUFDLE9BQU8sRUFBRSxpQkFBaUIsQ0FBQyxDQUFDO1FBQy9DLElBQUksQ0FBQyxzQkFBc0IsR0FBRyxzQkFBc0IsQ0FBQztJQUN2RCxDQUFDO0lBT08sY0FBYyxDQUFDLE9BQWlCLEVBQUUsaUJBQTBCO1FBQ2xFLElBQUksQ0FBQyxhQUFhLENBQUMsT0FBTyxDQUFDLENBQUM7UUFDNUIsSUFBSSxDQUFDLGtCQUFrQixHQUFHLGlCQUFpQixDQUFDO1FBQzVDLElBQUksaUJBQWlCLEVBQUU7WUFDckIsSUFBSSxDQUFDLFNBQVMsR0FBRyxRQUFRLENBQUMsR0FBRyxDQUFDO1NBQy9CO0lBQ0gsQ0FBQztJQU1PLGNBQWMsQ0FBQyxNQUFvQjtRQUN6QyxJQUFJLENBQUMsU0FBUyxHQUFHLE1BQU0sQ0FBQztRQUN4QixJQUFJLENBQUMsSUFBSSxDQUFDLENBQUMsTUFBTSxLQUFLLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBWSxNQUFNLENBQUMsT0FBTyxFQUFHLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxDQUFDO0lBQ3JFLENBQUM7SUFPTyxjQUFjLENBQUMsT0FBc0IsRUFBRSxJQUFZO1FBQ3pELElBQUksQ0FBQyxhQUFhLENBQUMsT0FBTyxDQUFDLENBQUM7UUFDNUIsSUFBSSxDQUFDLFlBQVksR0FBRyxJQUFJLENBQUM7SUFDM0IsQ0FBQztJQUVPLGNBQWMsQ0FBQyxPQUFzQixFQUFFLElBQVksRUFBRSxpQkFBMEI7UUFDckYsSUFBSSxDQUFDLGFBQWEsQ0FBQyxPQUFPLEVBQUUsaUJBQWlCLENBQUMsQ0FBQztRQUMvQyxJQUFJLENBQUMsWUFBWSxHQUFHLElBQUksQ0FBQztJQUMzQixDQUFDO0lBRU8sY0FBYyxDQUFDLE9BQXNCLEVBQUUsWUFBaUMsRUFBRSxpQkFBMEI7UUFDMUcsSUFBSSxDQUFDLGFBQWEsQ0FBQyxPQUFPLEVBQUUsaUJBQWlCLENBQUMsQ0FBQztRQUMvQyxJQUFJLENBQUMsYUFBYSxHQUFHLFlBQVksQ0FBQztJQUNwQyxDQUFDO0lBRU8sY0FBYyxDQUFDLE9BQXNCLEVBQUUsU0FBaUI7UUFDOUQsSUFBSSxDQUFDLGFBQWEsQ0FBQyxPQUFPLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDbEMsSUFBSSxDQUFDLFVBQVUsR0FBRyxTQUFTLENBQUM7SUFDOUIsQ0FBQztJQUVPLGNBQWMsQ0FBQyxPQUFzQjtRQUMzQyxJQUFJLENBQUMsYUFBYSxDQUFDLE9BQU8sRUFBRSxJQUFJLENBQUMsQ0FBQztJQUNwQyxDQUFDO0lBUU8sY0FBYyxDQUFFLEtBQW1CO1FBQ3pDLElBQUksQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQztRQUMvQixJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQyxLQUFLLENBQUM7UUFDekIsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUMsT0FBTyxDQUFDO1FBQzdCLElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDLFNBQVMsQ0FBQztRQUNqQyxJQUFJLENBQUMsTUFBTSxHQUFHLEtBQUssQ0FBQyxNQUFNLENBQUM7UUFDM0IsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUMsWUFBWSxDQUFDO1FBQ3ZDLElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDLGVBQWUsQ0FBQztRQUM3QyxJQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUM7UUFDL0IsSUFBSSxDQUFDLFVBQVUsR0FBRyxLQUFLLENBQUMsVUFBVSxDQUFDO1FBQ25DLElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDLFlBQVksQ0FBQztRQUN2QyxJQUFJLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQyxTQUFTLENBQUM7UUFDakMsSUFBSSxDQUFDLGtCQUFrQixHQUFHLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQztRQUNuRCxJQUFJLENBQUMsWUFBWSxHQUFHLEtBQUssQ0FBQyxZQUFZLENBQUM7UUFDdkMsSUFBSSxDQUFDLElBQUksR0FBRyxLQUFLLENBQUMsSUFBSSxDQUFDO1FBQ3ZCLElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDLGVBQWUsQ0FBQztRQUM3QyxJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQyxhQUFhLENBQUM7UUFDekMsSUFBSSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUMsYUFBYSxDQUFDO1FBQ3pDLElBQUksQ0FBQyxVQUFVLEdBQUcsS0FBSyxDQUFDLFVBQVUsQ0FBQztRQUNuQyxJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQyxhQUFhLENBQUM7UUFDekMsSUFBSSxDQUFDLGNBQWMsR0FBRyxLQUFLLENBQUMsY0FBYyxDQUFDO1FBQzNDLElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDLFlBQVksQ0FBQztJQUN6QyxDQUFDO0lBTUQsU0FBUyxDQUFDLEdBQVE7UUFDaEIsSUFBSSxjQUFjLEdBQStCLEdBQUcsQ0FBQztRQUNyRCxJQUFJLGFBQWEsR0FBYSxjQUFjLENBQUMsU0FBUyxDQUFDO1FBQ3ZELElBQUksTUFBTSxHQUFXLGFBQWEsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDO1FBQ3BELElBQUksTUFBTSxLQUFLLENBQUM7WUFDZCxNQUFNLEdBQVcsQ0FBQyxJQUFJLENBQUMsVUFBVSxHQUFHLGNBQWMsQ0FBQyxVQUFVLENBQUMsQ0FBQztRQUNqRSxPQUFPLE1BQU0sQ0FBQztJQUNoQixDQUFDO0lBS0QsU0FBUztRQUNQLElBQUksWUFBWSxHQUFpQixJQUFJLFlBQVksQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUN4RCxZQUFZLENBQUMsWUFBWSxFQUFFLENBQUM7UUFDNUIsT0FBTyxZQUFZLENBQUM7SUFDdEIsQ0FBQztJQUtPLElBQUksQ0FBQyxPQUFpQjtRQUM1QixJQUFJLENBQUMsS0FBSyxHQUFHLENBQUMsT0FBTyxJQUFhLFlBQVksQ0FBQyxXQUFXLENBQUMsYUFBYSxFQUFHLENBQUMsWUFBWSxFQUFFLENBQUMsQ0FBQztRQUM1RixJQUFJLENBQUMsUUFBUSxHQUFHLENBQUMsQ0FBQyxJQUFJLENBQUMsS0FBSyxLQUFLLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxFQUFFLENBQUMsQ0FBQztRQUN2RSxJQUFJLENBQUMsWUFBWSxHQUFHLElBQUksQ0FBQztJQUMzQixDQUFDO0lBS0QsbUJBQW1CO1FBQ2pCLElBQUksQ0FBQyxRQUFRLEdBQUcsSUFBSSxhQUFhLEVBQUUsQ0FBQztRQUNwQyxJQUFJLENBQUMsUUFBUSxDQUFDLG1CQUFtQixDQUFDLElBQUksQ0FBQyxXQUFXLEVBQUUsSUFBSSxDQUFDLFdBQVcsRUFBRSxJQUFJLENBQUMsVUFBVSxFQUFFLElBQUksQ0FBQyxXQUFXLENBQUMsQ0FBQztRQUN6RyxJQUFJLENBQUMsV0FBVyxHQUFHLENBQUMsQ0FBQztRQUNyQixJQUFJLENBQUMsV0FBVyxHQUFHLElBQUksQ0FBQztRQUN4QixJQUFJLENBQUMsVUFBVSxHQUFHLElBQUksQ0FBQztRQUN2QixJQUFJLENBQUMsV0FBVyxHQUFHLElBQUksQ0FBQztJQUMxQixDQUFDO0lBS0QsT0FBTztRQUNMLEtBQUssQ0FBQyxhQUFhLEVBQUUsQ0FBQztRQUN0QixPQUFPLElBQUksQ0FBQyxLQUFLLENBQUM7SUFDcEIsQ0FBQztJQU1ELE9BQU8sQ0FBQyxPQUFpQjtRQUN2QixJQUFJLENBQUMsS0FBSyxHQUFHLE9BQU8sQ0FBQztRQUVyQixJQUFJLElBQUksQ0FBQyxLQUFLLEtBQUssSUFBSTtZQUNyQixJQUFJLENBQUMsUUFBUSxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxFQUFFLENBQUM7O1lBRXhDLElBQUksQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFDO0lBQ3pCLENBQUM7SUFPRCxRQUFRLENBQUMsR0FBVyxFQUFFLEtBQWEsRUFBRSxNQUFlO1FBQ2xELElBQUksQ0FBQyxLQUFLLEdBQUcsY0FBYyxDQUFDLGdCQUFnQixDQUFTO1FBQ3JELElBQUksQ0FBQyxRQUFRLEdBQUcsR0FBRyxDQUFDO1FBQ3BCLElBQUksQ0FBQyxNQUFNLEdBQUcsS0FBSyxDQUFDO1FBQ3BCLElBQUksQ0FBQyxZQUFZLEdBQUcsTUFBTSxDQUFDO0lBQzdCLENBQUM7SUFPRCxjQUFjO1FBQ1osT0FBTyxJQUFJLENBQUMsWUFBWSxDQUFDO0lBQzNCLENBQUM7SUFLRCxRQUFRO1FBQ04sT0FBTyxJQUFJLENBQUMsTUFBTSxDQUFDO0lBQ3JCLENBQUM7SUFPRCxXQUFXLENBQUMsV0FBcUI7UUFDL0IsSUFBSSxTQUFTLENBQUMsTUFBTSxLQUFLLENBQUMsRUFBRTtZQUMxQixPQUFPLElBQUksQ0FBQyxjQUFjLEVBQUUsQ0FBQztTQUM5QjtRQUNELE9BQU8sSUFBSSxDQUFDLGNBQWMsQ0FBQyxXQUFXLENBQUMsQ0FBQztJQUMxQyxDQUFDO0lBRU8sY0FBYztRQUNwQixJQUFJLEtBQUssR0FBVyxLQUFLLENBQUMsV0FBVyxFQUFFLENBQUM7UUFDeEMsSUFBSSxJQUFJLENBQUMsS0FBSyxLQUFLLGNBQWMsQ0FBQyxtQkFBbUIsRUFBRTtZQUNyRCxRQUFRLElBQUksQ0FBQyxhQUFhLEVBQUU7Z0JBQzFCLEtBQUssaUJBQWlCLENBQUMsa0JBQWtCLENBQUM7Z0JBQzFDLEtBQUssaUJBQWlCLENBQUMsa0JBQWtCLENBQUM7Z0JBQzFDLEtBQUssaUJBQWlCLENBQUMsd0JBQXdCO29CQUM3QyxLQUFLLElBQUksSUFBSSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUM7b0JBQzNCLE1BQU07Z0JBQ1IsS0FBSyxpQkFBaUIsQ0FBQyxlQUFlO29CQUNwQyxLQUFLLElBQUksSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLEVBQUUsQ0FBQztvQkFDckMsTUFBTTthQUNUO1NBQ0Y7UUFDRCxPQUFPLEtBQUssQ0FBQztJQUNmLENBQUM7SUFFTyxjQUFjLENBQUMsV0FBb0I7UUFDekMsT0FBTyxLQUFLLENBQUMsV0FBVyxDQUFDLFdBQVcsQ0FBQyxDQUFDO0lBQ3hDLENBQUM7SUFNRCxPQUFPLENBQUMsT0FBc0I7UUFDNUIsSUFBSSxDQUFDLEtBQUssR0FBRyxPQUFPLENBQUM7SUFDdkIsQ0FBQztJQUtELG9CQUFvQjtRQUNsQixJQUFJLENBQUMsZUFBZSxHQUFHLEtBQUssQ0FBQztJQUMvQixDQUFDO0lBS0QsY0FBYztRQUNaLE9BQU8sSUFBSSxDQUFDLGVBQWUsQ0FBQztJQUM5QixDQUFDO0lBS00sUUFBUSxDQUFDLE9BQXNCO1FBQ3BDLE9BQU8sQ0FBQyxNQUFNLENBQUMsT0FBTyxHQUFHLFlBQVksQ0FBQyxRQUFRLEdBQUcsY0FBYyxDQUFDLFlBQVksQ0FBQyxDQUFDO1FBRTlFLElBQUksSUFBSSxDQUFDLEtBQUssS0FBSyxJQUFJLENBQUMsUUFBUTtZQUM5QixPQUFPLENBQUMsTUFBTSxDQUFDLEdBQUcsR0FBRyxjQUFjLENBQUMsaUJBQWlCLEdBQUcsS0FBSyxHQUFHLElBQUksQ0FBQyxLQUFLLEdBQUcsSUFBSSxDQUFDLENBQUM7UUFFckYsSUFBSSxJQUFJLENBQUMsS0FBSyxLQUFLLGNBQWMsQ0FBQyxpQkFBaUIsSUFBSSxJQUFJLENBQUMsTUFBTSxJQUFJLElBQUksRUFBRTtZQUMxRSxJQUFJLFFBQVEsR0FBYyxJQUFJLENBQUMsTUFBTSxDQUFDLFdBQVcsRUFBRSxDQUFDO1lBQ3BELElBQUksUUFBUSxLQUFLLFNBQVMsQ0FBQyxhQUFhO2dCQUN0QyxPQUFPLENBQUMsTUFBTSxDQUFDLEdBQUcsR0FBRyxjQUFjLENBQUMsZ0JBQWdCLEdBQUcsS0FBSyxHQUFHLFFBQVEsR0FBRyxJQUFJLENBQUMsQ0FBQztZQUNsRixPQUFPLENBQUMsTUFBTSxDQUFDLEdBQUcsR0FBRyxjQUFjLENBQUMsZUFBZSxHQUFHLEtBQUssR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDLFVBQVUsRUFBRSxHQUFHLElBQUksQ0FBQyxDQUFDO1NBQ2hHO1FBQ0QsSUFBSSxJQUFJLENBQUMsYUFBYSxLQUFLLEtBQUssQ0FBQyxRQUFRO1lBQ3ZDLE9BQU8sQ0FBQyxNQUFNLENBQUMsR0FBRyxHQUFHLGNBQWMsQ0FBQyxxQkFBcUIsR0FBRyxLQUFLLEdBQUcsSUFBSSxDQUFDLGFBQWEsR0FBRyxJQUFJLENBQUMsQ0FBQztRQUNqRyxJQUFJLElBQUksQ0FBQyxRQUFRLEtBQUssS0FBSyxDQUFDLFFBQVE7WUFDbEMsT0FBTyxDQUFDLE1BQU0sQ0FBQyxHQUFHLEdBQUcsY0FBYyxDQUFDLGVBQWUsR0FBRyxLQUFLLEdBQUcsSUFBSSxDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUMsQ0FBQztRQUN0RixJQUFJLElBQUksQ0FBQyxHQUFHLElBQUksSUFBSTtZQUNsQixPQUFPLENBQUMsTUFBTSxDQUFDLEdBQUcsR0FBRyxZQUFZLENBQUMsV0FBVyxHQUFHLEtBQUssR0FBRyxJQUFJLENBQUMsR0FBRyxDQUFDLEtBQUssRUFBRSxHQUFHLElBQUksQ0FBQyxDQUFDO1FBQ25GLElBQUksSUFBSSxDQUFDLFVBQVUsS0FBSyxTQUFTLENBQUMsSUFBSTtZQUNwQyxPQUFPLENBQUMsTUFBTSxDQUFDLEdBQUcsR0FBRyxZQUFZLENBQUMsV0FBVyxHQUFHLEtBQUssR0FBVyxJQUFJLENBQUMsVUFBVSxHQUFHLElBQUksQ0FBQyxDQUFDO1FBQzFGLElBQUksSUFBSSxDQUFDLE9BQU8sSUFBSSxJQUFJO1lBQ3RCLE9BQU8sQ0FBQyxNQUFNLENBQUMsR0FBRyxHQUFHLGNBQWMsQ0FBQyxZQUFZLEdBQUcsS0FBSyxHQUFHLElBQUksQ0FBQyxjQUFjLEdBQUcsR0FBRyxHQUFHLElBQUksQ0FBQyxXQUFXLEdBQUcsSUFBSSxDQUFDLENBQUM7UUFFbEgsT0FBTyxDQUFDLE1BQU0sQ0FBQyxZQUFZLENBQUMsUUFBUSxDQUFDLENBQUM7SUFDeEMsQ0FBQztJQU1ELFVBQVU7UUFDUixPQUFPLElBQUksQ0FBQyxRQUFRLENBQUM7SUFDdkIsQ0FBQztJQU1ELFVBQVUsQ0FBQyxRQUF1QjtRQUNoQyxJQUFJLE1BQU0sR0FBWSxJQUFJLENBQUMsUUFBUSxLQUFLLElBQUksQ0FBQztRQUM3QyxJQUFJLENBQUMsUUFBUSxHQUFHLFFBQVEsQ0FBQztRQUN6QixPQUFPLE1BQU0sQ0FBQztJQUNoQixDQUFDO0lBTUQsaUJBQWlCLENBQUMsV0FBc0I7UUFDdEMsSUFBSSxDQUFDLFlBQVksR0FBRyxXQUFXLENBQUM7SUFDbEMsQ0FBQztJQUVELGlCQUFpQjtRQUNmLE9BQU8sSUFBSSxDQUFDLFlBQVksQ0FBQztJQUMzQixDQUFDO0lBTUQsWUFBWSxDQUFDLEdBQVk7UUFDdkIsSUFBSSxDQUFDLFVBQVUsR0FBRyxHQUFHLENBQUM7SUFDeEIsQ0FBQztJQUtELFdBQVc7UUFDVCxPQUFPLElBQUksQ0FBQyxVQUFVLENBQUM7SUFDekIsQ0FBQztJQVFELGlCQUFpQixDQUFDLEdBQWE7UUFDN0IsSUFBSSxDQUFDLFlBQVksR0FBRyxHQUFHLENBQUM7SUFDMUIsQ0FBQztJQU1ELGlCQUFpQjtRQUNmLE9BQU8sSUFBSSxDQUFDLFlBQVksQ0FBQztJQUMzQixDQUFDO0lBS0QsZ0JBQWdCLENBQUMsR0FBWTtRQUMzQixJQUFJLENBQUMsY0FBYyxHQUFHLEdBQUcsQ0FBQztJQUM1QixDQUFDO0lBS0QsY0FBYztRQUNaLE9BQU8sSUFBSSxDQUFDLGNBQWMsQ0FBQztJQUM3QixDQUFDO0lBS0QsYUFBYTtRQUNYLElBQUksQ0FBQyxXQUFXLEdBQUcsSUFBSSxDQUFDO0lBQzFCLENBQUM7SUFLRCxlQUFlO1FBQ2IsSUFBSSxDQUFDLFdBQVcsR0FBRyxLQUFLLENBQUM7SUFDM0IsQ0FBQztJQUlELFlBQVk7UUFDVixPQUFPLElBQUksQ0FBQyxXQUFXLENBQUM7SUFDMUIsQ0FBQztJQUlELE1BQU07UUFDSixPQUFPLElBQUksQ0FBQyxhQUFhLEtBQUssWUFBWSxDQUFDLFlBQVksQ0FBQztJQUMxRCxDQUFDO0lBTUQsZ0JBQWdCO1FBQ2QsT0FBTyxJQUFJLENBQUMsYUFBYSxLQUFLLFlBQVksQ0FBQyxvQkFBb0IsQ0FBQztJQUNsRSxDQUFDO0lBS0QsY0FBYztRQUNaLE9BQU8sSUFBSSxDQUFDLGFBQWEsS0FBSyxZQUFZLENBQUMsY0FBYyxDQUFDO0lBQzVELENBQUM7SUFNRCwwQkFBMEI7UUFDeEIsT0FBTyxJQUFJLENBQUMsYUFBYSxLQUFLLFlBQVksQ0FBQywwQkFBMEIsQ0FBQztJQUN4RSxDQUFDO0lBS0QsZUFBZSxDQUFDLFlBQTBCO1FBQ3hDLElBQUksQ0FBQyxhQUFhLEdBQUcsWUFBWSxDQUFDO0lBQ3BDLENBQUM7SUFNRCxNQUFNO1FBQ0osT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDO0lBQ3hCLENBQUM7SUFPRCxtQkFBbUI7UUFDakIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUM7SUFDakMsQ0FBQztJQUtELFdBQVc7UUFDVCxPQUFPLElBQUksQ0FBQyxTQUFTLENBQUM7SUFDeEIsQ0FBQztJQU1ELFdBQVcsQ0FBQyxRQUFrQjtRQUM1QixJQUFJLENBQUMsU0FBUyxHQUFHLFFBQVEsQ0FBQztJQUM1QixDQUFDO0lBRUQsV0FBVztRQUNULE9BQU8sSUFBSSxDQUFDLFlBQVksQ0FBQztJQUMzQixDQUFDO0lBRUQsUUFBUTtRQUNOLE9BQU8sSUFBSSxDQUFDLElBQUksQ0FBQztJQUNuQixDQUFDO0lBRUQsUUFBUSxDQUFDLEdBQVE7UUFDZixJQUFJLENBQUMsSUFBSSxHQUFHLEdBQUcsQ0FBQztJQUNsQixDQUFDO0lBR0QsaUJBQWlCO1FBQ2YsT0FBTyxJQUFJLENBQUMsZUFBZSxDQUFDO0lBQzlCLENBQUM7SUFFRCxlQUFlO1FBQ2IsT0FBTyxJQUFJLENBQUMsYUFBYSxDQUFDO0lBQzVCLENBQUM7SUFRRCxZQUFZLENBQUMsS0FBYSxFQUFFLEdBQVcsRUFBRSxJQUFZO1FBQ25ELElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDO1FBQzdCLElBQUksQ0FBQyxhQUFhLEdBQUcsR0FBRyxDQUFDO1FBQ3pCLElBQUksQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDdEIsQ0FBQztJQU1ELGNBQWM7UUFDWixPQUFPLElBQUksQ0FBQyxhQUFhLENBQUM7SUFDNUIsQ0FBQztJQU1ELGVBQWUsQ0FBQyxZQUFxQjtRQUNuQyxJQUFJLENBQUMsYUFBYSxHQUFHLFlBQVksQ0FBQztJQUNwQyxDQUFDO0lBT0QsZ0JBQWdCO1FBQ2QsT0FBTyxJQUFJLENBQUMsY0FBYyxDQUFDO0lBQzdCLENBQUM7SUFNRCxTQUFTO1FBQ1AsT0FBTyxJQUFJLENBQUMsUUFBUSxDQUFDO0lBQ3ZCLENBQUM7SUFNRCxVQUFVLENBQUMsT0FBZ0I7UUFDekIsSUFBSSxDQUFDLFFBQVEsR0FBRyxPQUFPLENBQUM7SUFDMUIsQ0FBQztJQVlNLHNCQUFzQixDQUFDLGdCQUF3QjtRQUNwRCxJQUFJLGdCQUFnQixDQUFDLE9BQU8sRUFBRTtZQUU1QixJQUFJLFNBQVMsR0FBYSxJQUFJLENBQUMsT0FBTyxFQUFFLENBQUM7WUFDekMsSUFBSSxRQUFRLEdBQWEsZ0JBQWdCLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDO1lBQ3JELElBQUksU0FBUyxLQUFLLFFBQVEsSUFBSSxRQUFRLENBQUMsY0FBYyxDQUFDLFNBQVMsQ0FBQztnQkFDOUQsT0FBTyxJQUFJLENBQUM7U0FDZjtRQUNELE9BQU8sS0FBSyxDQUFDO0lBQ2YsQ0FBQztJQUVELFFBQVE7UUFDTixPQUFPLE9BQU8sQ0FBQyxNQUFNLENBQUMsb0NBQW9DLEVBQUU7WUFDMUQsSUFBSSxDQUFDLFdBQVcsRUFBRSxFQUFFLElBQUksQ0FBQyxhQUFhLEVBQUUsSUFBSSxDQUFDLEtBQUssRUFBRSxDQUFDLElBQUksQ0FBQyxLQUFLLEtBQUssSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQztTQUN2RyxDQUFDLENBQUM7SUFDTCxDQUFDO0NBQ0YiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQge0NoYXIsIElDb21wYXJhYmxlLCBJbnQzMiwgTGlzdCwgTlN0cmluZywgU3RyaW5nQnVpbGRlcn0gZnJvbSBcIkBtYWdpYy14cGEvbXNjb3JlbGliXCI7XHJcbmltcG9ydCB7Rm9yY2VFeGl0LCBJbnRlcm5hbEludGVyZmFjZSwgUHJpb3JpdHksIFhNTENvbnN0YW50cywgWG1sUGFyc2VyfSBmcm9tIFwiQG1hZ2ljLXhwYS91dGlsc1wiO1xyXG5pbXBvcnQge0d1aUZpZWxkQmFzZSwgTGFzdEZvY3VzZWRWYWwsIE1nQ29udHJvbEJhc2UsIE1vZGlmaWVycywgUHJvcGVydHksIFByb3BJbnRlcmZhY2UsfSBmcm9tIFwiQG1hZ2ljLXhwYS9ndWlcIjtcclxuaW1wb3J0IHtFdmVudFN1YlR5cGV9IGZyb20gXCIuLi9lbnVtc1wiO1xyXG5pbXBvcnQge0V2ZW50fSBmcm9tIFwiLi9FdmVudFwiO1xyXG5pbXBvcnQge0NvbnN0SW50ZXJmYWNlfSBmcm9tIFwiLi4vQ29uc3RJbnRlcmZhY2VcIjtcclxuaW1wb3J0IHtBcmd1bWVudHNMaXN0fSBmcm9tIFwiLi4vcnQvQXJndW1lbnRzTGlzdFwiO1xyXG5pbXBvcnQge01HRGF0YX0gZnJvbSBcIi4uL3Rhc2tzL01HRGF0YVwiO1xyXG5pbXBvcnQge1Rhc2tCYXNlfSBmcm9tIFwiLi4vdGFza3MvVGFza0Jhc2VcIjtcclxuaW1wb3J0IHtSdW5UaW1lRXZlbnRCYXNlfSBmcm9tIFwiLi9SdW5UaW1lRXZlbnRCYXNlXCI7XHJcbmltcG9ydCB7QWNjZXNzSGVscGVyfSBmcm9tIFwiLi4vQWNjZXNzSGVscGVyXCI7XHJcblxyXG4vLy8gPHN1bW1hcnk+XHJcbi8vLyAgIHRoaXMgY2xhc3MgcmVwcmVzZW50cyB0aGUgcnVudGltZSBldmVudHNcclxuLy8vIDwvc3VtbWFyeT5cclxuZXhwb3J0IGNsYXNzIFJ1blRpbWVFdmVudCBleHRlbmRzIFJ1blRpbWVFdmVudEJhc2UgaW1wbGVtZW50cyBJQ29tcGFyYWJsZSB7XHJcblxyXG4gIC8vIEFUVEVOVElPTiAhXHJcbiAgLy8gYW55IGNoYW5nZSB0byB0aGUgbWVtYmVyIHZhcmlhYmxlcyBtdXN0IGJlIGZvbGxvd2VkIGJ5IGEgY2hhbmdlIHRvIHRoZSBDVE9SIHRoYXRcclxuICAvLyBnZXRzIG9uZSBhcmd1bWVudCBvZiB0aGUgdHlwZSAnRXZlbnQnIGFuZCBvbmUgYXJndW1lbnQgb2YgdGhlIHR5cGUgJ1J1blRpbWVFdmVudCcuXHJcblxyXG4gIHByaXZhdGUgX2NvbnRyb2xzTGlzdDogTGlzdDxNZ0NvbnRyb2xCYXNlPiA9IG51bGw7IC8vIGxpc3Qgb2YgY29udHJvbHNcclxuICBwcml2YXRlIF9kaXJlY3Rpb246IG51bWJlciA9IDA7XHJcbiAgcHJpdmF0ZSBfZGlzcGxheUxpbmU6IG51bWJlciA9IEludDMyLk1pblZhbHVlO1xyXG5cclxuICBwcml2YXRlIF9ldmVudFN1YlR5cGU6IEV2ZW50U3ViVHlwZSA9IEV2ZW50U3ViVHlwZS5Ob3JtYWw7XHJcblxyXG4gIHByaXZhdGUgX2FjdEVuYWJsZUxpc3Q6IG51bWJlcltdID0gbnVsbDtcclxuICBwcml2YXRlIF9hcmdMaXN0OiBBcmd1bWVudHNMaXN0ID0gbnVsbDtcclxuICBwcml2YXRlIF9jdHJsOiBNZ0NvbnRyb2xCYXNlID0gbnVsbDsgLy8gdGhlIGNvbnRyb2wgb24gd2hpY2ggdGhlIGV2ZW50IHdhcyB0cmlnZ2VyZWRcclxuICBwcml2YXRlIF9kb3ROZXRPYmplY3Q6IGFueSA9IG51bGw7IC8vIG9iamVjdCBrZXkgb2YgYSBjb250cm9sXHJcbiAgcHJpdmF0ZSBfZXZlbnRGbGQ6IEd1aUZpZWxkQmFzZSA9IG51bGw7IC8vIEZvciB2YXJpYWJsZSBldmVudHMgLSB0aGUgZmllbGQgb24gd2hpY2ggdGhlIGNvbnRyb2wgd2FzIHRyaWdnZXJlZFxyXG4gIHByaXZhdGUgX2Zyb21TZXJ2ZXI6IGJvb2xlYW4gPSBmYWxzZTsgIC8vIGlmIFRSVUUsIHRoZSBldmVudCB3YXMgY3JlYXRlZCBvbiB0aGUgc2VydmVyIGFuZCBzZW50IHRvIHRoZSBjbGllbnRcclxuICBwcml2YXRlIF9ndWlUcmlnZ2VyZWRFdmVudDogYm9vbGVhbiA9IGZhbHNlOyAvLyBpZiB0cnVlLCB0aGUgZXZlbnQgd2FzIHRyaWdnZXJlZCBieSBHVUkgbGV2ZWwgKGluY2x1ZGVzIHRpbWVyIGV2ZW50cylcclxuICBwcml2YXRlIF9pbW1lZGlhdGU6IGJvb2xlYW4gPSBmYWxzZTtcclxuICBwcml2YXRlIF9pc0lkbGVUaW1lcjogYm9vbGVhbiA9IGZhbHNlO1xyXG4gIHByaXZhdGUgX2lzUmVhbFJlZnJlc2g6IGJvb2xlYW4gPSB0cnVlOyAvLyB1c2VkIG9ubHkgaW4gTUdfQUNUX1ZJRVdfUkVGUkVTSCBldmVudHMgdG8gaW5kaWNhdGUgYSByZWZyZXNoIGludm9rZWQgU3BlY2lmaWNhbGx5IGJ5IHRoZSB1c2VyXHJcbiAgcHJpdmF0ZSBfbWdkSWQ6IG51bWJlciA9IDA7IC8vIG1nZGF0YSBpZCB0aGF0IHNlbnQgdGltZXIgZXZlbnRcclxuICBwcml2YXRlIF9yb3V0ZVBhcmFtczogTGlzdDxhbnk+ID0gbnVsbDtcclxuXHJcbiAgLy8gVXNlZCBvbmx5IGlmICd0YXNrJyBpcyBhIG1haW4gcHJnLiBBIHJlZmVyZW5jZSB0byB0aGUgdGFzayB3aGljaFxyXG4gIC8vIGNhdXNlZCB0aGUgbWFpbiBwcmcgdG8gYmVjb21lIGFjdGl2ZSBpbiB0aGUgcnVudGltZS5cclxuICBwcml2YXRlIF9tcHJnQ3JlYXRvcjogVGFza0Jhc2UgPSBudWxsO1xyXG5cclxuICBwcml2YXRlIF9wcmlvcml0eTogUHJpb3JpdHkgPSBQcmlvcml0eS5ISUdIOyAvLyBwcmlvcml0eSBvZiBldmVudCBmb3IgZXZlbnRzIHF1ZXVlXHJcblxyXG4gIHByaXZhdGUgX3Byb2R1Y2VDbGljazogYm9vbGVhbiA9IGZhbHNlOyAvLyBpZiBUUlVFLCB0aGUgZXZlbnQgc2hvdWxkIHByb2R1Y2UgY2xpY2tcclxuICBwcml2YXRlIF9yZXZlcnNpYmxlRXhpdDogYm9vbGVhbiA9IHRydWU7XHJcblxyXG4gIHByaXZhdGUgX3NlbGVjdGlvbkVuZDogbnVtYmVyID0gMDtcclxuICBwcml2YXRlIF9zZWxlY3Rpb25TdGFydDogbnVtYmVyID0gMDtcclxuICBwcml2YXRlIF9zZW5kQWxsOiBib29sZWFuID0gZmFsc2U7ICAvLyB0aGlzIGZsYWcgaXMgc2V0IGZvciBzZW5kaW5nIGFsbCByZWNvcmRzXHJcbiAgcHJpdmF0ZSBfdGFzazogVGFza0Jhc2UgPSBudWxsOyAvLyBhIHJlZmVyZW5jZSB0byB0aGUgdGFza1xyXG4gIHByaXZhdGUgX3Rhc2tUYWc6IHN0cmluZyA9IG51bGw7IC8vIHRoZSB0YXNrIGlkIG9uIHdoaWNoIHRoZSBldmVudCB3YXMgdHJpZ2dlcmVkXHJcbiAgcHJpdmF0ZSBfdmFsOiBhbnkgPSBudWxsO1xyXG5cclxuXHJcblxyXG4gIHNldCBDb250cm9sKHZhbHVlOiBNZ0NvbnRyb2xCYXNlKSB7XHJcbiAgICB0aGlzLl9jdHJsID0gdmFsdWU7XHJcbiAgfVxyXG5cclxuICBzZXQgRGlzcGxheUxpbmUodmFsdWU6IG51bWJlcikge1xyXG4gICAgdGhpcy5fZGlzcGxheUxpbmUgPSB2YWx1ZTtcclxuICB9XHJcblxyXG4gIGdldCBDb250cm9sKCk6IE1nQ29udHJvbEJhc2Uge1xyXG4gICAgcmV0dXJuIHRoaXMuX2N0cmw7XHJcbiAgfVxyXG5cclxuICAvLy8gPHN1bW1hcnk+XHJcbiAgLy8vIFNob3VsZCB0aGUgY29udHJvbCBzZXQgb24gdGhlIGV2ZW50IGJlIGlnbm9yZWQuIGlmIHRydWUsIHdoZW4gcHJvY2Vzc2luZyB0aGUgZXZlbnQgd2Ugc2hvdWxkXHJcbiAgLy8vIHVzZSB0aGUgY3VycmVudCBmb2N1c2VkIGNvbnRyb2wgaW5zdGVhZCBvZiB0aGUgb25lIHNldCBvbiB0aGUgZXZlbnQuXHJcbiAgLy8vIDwvc3VtbWFyeT5cclxuICBJZ25vcmVTcGVjaWZpZWRDb250cm9sOiBib29sZWFuID0gZmFsc2U7XHJcblxyXG4gIExhc3RGb2N1c2VkVmFsOiBMYXN0Rm9jdXNlZFZhbCA9IG51bGw7IC8vIHZhbHVlIG9mIGxhc3QgZWRpdGVkIGNvbnRyb2xcclxuXHJcbiAgZ2V0IENvbnRyb2xzTGlzdCgpOiBMaXN0PE1nQ29udHJvbEJhc2U+IHtcclxuICAgIHJldHVybiB0aGlzLl9jb250cm9sc0xpc3Q7XHJcbiAgfVxyXG5cclxuICBnZXQgRGlyZWN0aW9uKCk6IG51bWJlciB7XHJcbiAgICByZXR1cm4gdGhpcy5fZGlyZWN0aW9uO1xyXG4gIH1cclxuXHJcbiAgY29uc3RydWN0b3IodGFza1JlZjogVGFza0Jhc2UpO1xyXG4gIGNvbnN0cnVjdG9yKHRhc2tSZWY6IFRhc2tCYXNlLCBjdHJsUmVmOiBNZ0NvbnRyb2xCYXNlKTtcclxuICBjb25zdHJ1Y3RvcihjdHJsUmVmOiBNZ0NvbnRyb2xCYXNlKTtcclxuICBjb25zdHJ1Y3RvcihjdHJsUmVmOiBNZ0NvbnRyb2xCYXNlLCBndWlUcmlnZ2VyZWRFdmVudDogYm9vbGVhbik7XHJcbiAgY29uc3RydWN0b3IoY3RybFJlZjogTWdDb250cm9sQmFzZSwgZ3VpVHJpZ2dlcmVkRXZlbnQ6IGJvb2xlYW4sIGlnbm9yZVNwZWNpZmllZENvbnRyb2w6IGJvb2xlYW4pO1xyXG4gIGNvbnN0cnVjdG9yKHRhc2tyZWY6IFRhc2tCYXNlLCBndWlUcmlnZ2VyZWRFdmVudDogYm9vbGVhbik7XHJcbiAgY29uc3RydWN0b3IoZmxkUmVmOiBHdWlGaWVsZEJhc2UpO1xyXG4gIGNvbnN0cnVjdG9yKGN0cmxSZWY6IE1nQ29udHJvbEJhc2UsIGxpbmU6IG51bWJlcik7XHJcbiAgY29uc3RydWN0b3IoY3RybFJlZjogTWdDb250cm9sQmFzZSwgbGluZTogbnVtYmVyLCBndWlUcmlnZ2VyZWRFdmVudDogYm9vbGVhbik7XHJcbiAgY29uc3RydWN0b3IoY3RybFJlZjogTWdDb250cm9sQmFzZSwgY29udHJvbHNMaXN0OiBMaXN0PE1nQ29udHJvbEJhc2U+LCBndWlUcmlnZ2VyZWRFdmVudDogYm9vbGVhbik7XHJcbiAgY29uc3RydWN0b3IoY3RybFJlZjogTWdDb250cm9sQmFzZSwgZGlyZWN0aW9uOiBudW1iZXIsIGxpbmU6IG51bWJlcik7XHJcbiAgY29uc3RydWN0b3IoY3RybFJlZjogTWdDb250cm9sQmFzZSwgY29sdW1uSGVhZGVyOiBzdHJpbmcsIHg6IG51bWJlciwgeTogbnVtYmVyLCB3aWR0aDogbnVtYmVyLCBoZWlnaHQ6IG51bWJlcik7XHJcbiAgY29uc3RydWN0b3IoZXZ0OiBFdmVudCwgcnRFdnQ6IFJ1blRpbWVFdmVudCk7XHJcbiAgY29uc3RydWN0b3IocnRFdnQ6IFJ1blRpbWVFdmVudCk7XHJcbiAgY29uc3RydWN0b3IodGFza1JlZk9yQ3RybFJlZk9yVGFza3JlZk9yRmxkUmVmT3JFdnQ6IGFueSwgY3RybFJlZk9yR3VpVHJpZ2dlcmVkRXZlbnRPckxpbmVPckNvbnRyb2xzTGlzdE9yRGlyZWN0aW9uT3JDb2x1bW5IZWFkZXJPclJ0RXZ0T3JDdXJyZW50VGFzaz86IGFueSwgaWdub3JlU3BlY2lmaWVkQ29udHJvbE9yR3VpVHJpZ2dlcmVkRXZlbnRPckxpbmVPclhPckNvbnRyb2xPckFjdGl2YXRlZEZyb21NRElGcmFtZT86IGFueSwgeU9yQ3RsSWR4PzogbnVtYmVyLCB3aWR0aD86IG51bWJlciwgaGVpZ2h0PzogbnVtYmVyKSB7XHJcbiAgICBzdXBlcigpO1xyXG4gICAgaWYgKGFyZ3VtZW50cy5sZW5ndGggPT09IDEgJiYgKHRhc2tSZWZPckN0cmxSZWZPclRhc2tyZWZPckZsZFJlZk9yRXZ0ID09PSBudWxsIHx8IHRhc2tSZWZPckN0cmxSZWZPclRhc2tyZWZPckZsZFJlZk9yRXZ0IGluc3RhbmNlb2YgVGFza0Jhc2UpKVxyXG4gICAgICB0aGlzLmNvbnN0cnVjdG9yXzUodGFza1JlZk9yQ3RybFJlZk9yVGFza3JlZk9yRmxkUmVmT3JFdnQpO1xyXG5cclxuICAgIGVsc2UgaWYgKGFyZ3VtZW50cy5sZW5ndGggPT09IDIgJiYgKHRhc2tSZWZPckN0cmxSZWZPclRhc2tyZWZPckZsZFJlZk9yRXZ0ID09PSBudWxsIHx8IHRhc2tSZWZPckN0cmxSZWZPclRhc2tyZWZPckZsZFJlZk9yRXZ0IGluc3RhbmNlb2YgVGFza0Jhc2UpICYmIChjdHJsUmVmT3JHdWlUcmlnZ2VyZWRFdmVudE9yTGluZU9yQ29udHJvbHNMaXN0T3JEaXJlY3Rpb25PckNvbHVtbkhlYWRlck9yUnRFdnRPckN1cnJlbnRUYXNrID09PSBudWxsIHx8IGN0cmxSZWZPckd1aVRyaWdnZXJlZEV2ZW50T3JMaW5lT3JDb250cm9sc0xpc3RPckRpcmVjdGlvbk9yQ29sdW1uSGVhZGVyT3JSdEV2dE9yQ3VycmVudFRhc2sgaW5zdGFuY2VvZiBNZ0NvbnRyb2xCYXNlKSlcclxuICAgICAgdGhpcy5jb25zdHJ1Y3Rvcl82KHRhc2tSZWZPckN0cmxSZWZPclRhc2tyZWZPckZsZFJlZk9yRXZ0LCBjdHJsUmVmT3JHdWlUcmlnZ2VyZWRFdmVudE9yTGluZU9yQ29udHJvbHNMaXN0T3JEaXJlY3Rpb25PckNvbHVtbkhlYWRlck9yUnRFdnRPckN1cnJlbnRUYXNrKTtcclxuXHJcbiAgICBlbHNlIGlmIChhcmd1bWVudHMubGVuZ3RoID09PSAxICYmICh0YXNrUmVmT3JDdHJsUmVmT3JUYXNrcmVmT3JGbGRSZWZPckV2dCA9PT0gbnVsbCB8fCB0YXNrUmVmT3JDdHJsUmVmT3JUYXNrcmVmT3JGbGRSZWZPckV2dCBpbnN0YW5jZW9mIE1nQ29udHJvbEJhc2UpKVxyXG4gICAgICB0aGlzLmNvbnN0cnVjdG9yXzcodGFza1JlZk9yQ3RybFJlZk9yVGFza3JlZk9yRmxkUmVmT3JFdnQpO1xyXG5cclxuICAgIGVsc2UgaWYgKGFyZ3VtZW50cy5sZW5ndGggPT09IDIgJiYgKHRhc2tSZWZPckN0cmxSZWZPclRhc2tyZWZPckZsZFJlZk9yRXZ0ID09PSBudWxsIHx8IHRhc2tSZWZPckN0cmxSZWZPclRhc2tyZWZPckZsZFJlZk9yRXZ0IGluc3RhbmNlb2YgTWdDb250cm9sQmFzZSkgJiYgKGN0cmxSZWZPckd1aVRyaWdnZXJlZEV2ZW50T3JMaW5lT3JDb250cm9sc0xpc3RPckRpcmVjdGlvbk9yQ29sdW1uSGVhZGVyT3JSdEV2dE9yQ3VycmVudFRhc2sgPT09IG51bGwgfHwgY3RybFJlZk9yR3VpVHJpZ2dlcmVkRXZlbnRPckxpbmVPckNvbnRyb2xzTGlzdE9yRGlyZWN0aW9uT3JDb2x1bW5IZWFkZXJPclJ0RXZ0T3JDdXJyZW50VGFzay5jb25zdHJ1Y3RvciA9PT0gQm9vbGVhbikpXHJcbiAgICAgIHRoaXMuY29uc3RydWN0b3JfOCh0YXNrUmVmT3JDdHJsUmVmT3JUYXNrcmVmT3JGbGRSZWZPckV2dCwgY3RybFJlZk9yR3VpVHJpZ2dlcmVkRXZlbnRPckxpbmVPckNvbnRyb2xzTGlzdE9yRGlyZWN0aW9uT3JDb2x1bW5IZWFkZXJPclJ0RXZ0T3JDdXJyZW50VGFzayk7XHJcblxyXG4gICAgZWxzZSBpZiAoYXJndW1lbnRzLmxlbmd0aCA9PT0gMyAmJiAodGFza1JlZk9yQ3RybFJlZk9yVGFza3JlZk9yRmxkUmVmT3JFdnQgPT09IG51bGwgfHwgdGFza1JlZk9yQ3RybFJlZk9yVGFza3JlZk9yRmxkUmVmT3JFdnQgaW5zdGFuY2VvZiBNZ0NvbnRyb2xCYXNlKSAmJiAoY3RybFJlZk9yR3VpVHJpZ2dlcmVkRXZlbnRPckxpbmVPckNvbnRyb2xzTGlzdE9yRGlyZWN0aW9uT3JDb2x1bW5IZWFkZXJPclJ0RXZ0T3JDdXJyZW50VGFzayA9PT0gbnVsbCB8fCBjdHJsUmVmT3JHdWlUcmlnZ2VyZWRFdmVudE9yTGluZU9yQ29udHJvbHNMaXN0T3JEaXJlY3Rpb25PckNvbHVtbkhlYWRlck9yUnRFdnRPckN1cnJlbnRUYXNrLmNvbnN0cnVjdG9yID09PSBCb29sZWFuKSAmJiAoaWdub3JlU3BlY2lmaWVkQ29udHJvbE9yR3VpVHJpZ2dlcmVkRXZlbnRPckxpbmVPclhPckNvbnRyb2xPckFjdGl2YXRlZEZyb21NRElGcmFtZSA9PT0gbnVsbCB8fCBpZ25vcmVTcGVjaWZpZWRDb250cm9sT3JHdWlUcmlnZ2VyZWRFdmVudE9yTGluZU9yWE9yQ29udHJvbE9yQWN0aXZhdGVkRnJvbU1ESUZyYW1lLmNvbnN0cnVjdG9yID09PSBCb29sZWFuKSlcclxuICAgICAgdGhpcy5jb25zdHJ1Y3Rvcl85KHRhc2tSZWZPckN0cmxSZWZPclRhc2tyZWZPckZsZFJlZk9yRXZ0LCBjdHJsUmVmT3JHdWlUcmlnZ2VyZWRFdmVudE9yTGluZU9yQ29udHJvbHNMaXN0T3JEaXJlY3Rpb25PckNvbHVtbkhlYWRlck9yUnRFdnRPckN1cnJlbnRUYXNrLCBpZ25vcmVTcGVjaWZpZWRDb250cm9sT3JHdWlUcmlnZ2VyZWRFdmVudE9yTGluZU9yWE9yQ29udHJvbE9yQWN0aXZhdGVkRnJvbU1ESUZyYW1lKTtcclxuXHJcbiAgICBlbHNlIGlmIChhcmd1bWVudHMubGVuZ3RoID09PSAyICYmICh0YXNrUmVmT3JDdHJsUmVmT3JUYXNrcmVmT3JGbGRSZWZPckV2dCA9PT0gbnVsbCB8fCB0YXNrUmVmT3JDdHJsUmVmT3JUYXNrcmVmT3JGbGRSZWZPckV2dCBpbnN0YW5jZW9mIFRhc2tCYXNlKSAmJiAoY3RybFJlZk9yR3VpVHJpZ2dlcmVkRXZlbnRPckxpbmVPckNvbnRyb2xzTGlzdE9yRGlyZWN0aW9uT3JDb2x1bW5IZWFkZXJPclJ0RXZ0T3JDdXJyZW50VGFzayA9PT0gbnVsbCB8fCBjdHJsUmVmT3JHdWlUcmlnZ2VyZWRFdmVudE9yTGluZU9yQ29udHJvbHNMaXN0T3JEaXJlY3Rpb25PckNvbHVtbkhlYWRlck9yUnRFdnRPckN1cnJlbnRUYXNrLmNvbnN0cnVjdG9yID09PSBCb29sZWFuKSlcclxuICAgICAgdGhpcy5jb25zdHJ1Y3Rvcl8xMCh0YXNrUmVmT3JDdHJsUmVmT3JUYXNrcmVmT3JGbGRSZWZPckV2dCwgY3RybFJlZk9yR3VpVHJpZ2dlcmVkRXZlbnRPckxpbmVPckNvbnRyb2xzTGlzdE9yRGlyZWN0aW9uT3JDb2x1bW5IZWFkZXJPclJ0RXZ0T3JDdXJyZW50VGFzayk7XHJcblxyXG4gICAgZWxzZSBpZiAoYXJndW1lbnRzLmxlbmd0aCA9PT0gMSAmJiAodGFza1JlZk9yQ3RybFJlZk9yVGFza3JlZk9yRmxkUmVmT3JFdnQgPT09IG51bGwgfHwgdGFza1JlZk9yQ3RybFJlZk9yVGFza3JlZk9yRmxkUmVmT3JFdnQgaW5zdGFuY2VvZiBHdWlGaWVsZEJhc2UpKVxyXG4gICAgICB0aGlzLmNvbnN0cnVjdG9yXzExKHRhc2tSZWZPckN0cmxSZWZPclRhc2tyZWZPckZsZFJlZk9yRXZ0KTtcclxuXHJcbiAgICBlbHNlIGlmIChhcmd1bWVudHMubGVuZ3RoID09PSAyICYmICh0YXNrUmVmT3JDdHJsUmVmT3JUYXNrcmVmT3JGbGRSZWZPckV2dCA9PT0gbnVsbCB8fCB0YXNrUmVmT3JDdHJsUmVmT3JUYXNrcmVmT3JGbGRSZWZPckV2dCBpbnN0YW5jZW9mIE1nQ29udHJvbEJhc2UpICYmIChjdHJsUmVmT3JHdWlUcmlnZ2VyZWRFdmVudE9yTGluZU9yQ29udHJvbHNMaXN0T3JEaXJlY3Rpb25PckNvbHVtbkhlYWRlck9yUnRFdnRPckN1cnJlbnRUYXNrID09PSBudWxsIHx8IGN0cmxSZWZPckd1aVRyaWdnZXJlZEV2ZW50T3JMaW5lT3JDb250cm9sc0xpc3RPckRpcmVjdGlvbk9yQ29sdW1uSGVhZGVyT3JSdEV2dE9yQ3VycmVudFRhc2suY29uc3RydWN0b3IgPT09IE51bWJlcikpXHJcbiAgICAgIHRoaXMuY29uc3RydWN0b3JfMTIodGFza1JlZk9yQ3RybFJlZk9yVGFza3JlZk9yRmxkUmVmT3JFdnQsIGN0cmxSZWZPckd1aVRyaWdnZXJlZEV2ZW50T3JMaW5lT3JDb250cm9sc0xpc3RPckRpcmVjdGlvbk9yQ29sdW1uSGVhZGVyT3JSdEV2dE9yQ3VycmVudFRhc2spO1xyXG5cclxuICAgIGVsc2UgaWYgKGFyZ3VtZW50cy5sZW5ndGggPT09IDMgJiYgKHRhc2tSZWZPckN0cmxSZWZPclRhc2tyZWZPckZsZFJlZk9yRXZ0ID09PSBudWxsIHx8IHRhc2tSZWZPckN0cmxSZWZPclRhc2tyZWZPckZsZFJlZk9yRXZ0IGluc3RhbmNlb2YgTWdDb250cm9sQmFzZSkgJiYgKGN0cmxSZWZPckd1aVRyaWdnZXJlZEV2ZW50T3JMaW5lT3JDb250cm9sc0xpc3RPckRpcmVjdGlvbk9yQ29sdW1uSGVhZGVyT3JSdEV2dE9yQ3VycmVudFRhc2sgPT09IG51bGwgfHwgY3RybFJlZk9yR3VpVHJpZ2dlcmVkRXZlbnRPckxpbmVPckNvbnRyb2xzTGlzdE9yRGlyZWN0aW9uT3JDb2x1bW5IZWFkZXJPclJ0RXZ0T3JDdXJyZW50VGFzay5jb25zdHJ1Y3RvciA9PT0gTnVtYmVyKSAmJiAoaWdub3JlU3BlY2lmaWVkQ29udHJvbE9yR3VpVHJpZ2dlcmVkRXZlbnRPckxpbmVPclhPckNvbnRyb2xPckFjdGl2YXRlZEZyb21NRElGcmFtZSA9PT0gbnVsbCB8fCBpZ25vcmVTcGVjaWZpZWRDb250cm9sT3JHdWlUcmlnZ2VyZWRFdmVudE9yTGluZU9yWE9yQ29udHJvbE9yQWN0aXZhdGVkRnJvbU1ESUZyYW1lLmNvbnN0cnVjdG9yID09PSBCb29sZWFuKSlcclxuICAgICAgdGhpcy5jb25zdHJ1Y3Rvcl8xMyh0YXNrUmVmT3JDdHJsUmVmT3JUYXNrcmVmT3JGbGRSZWZPckV2dCwgY3RybFJlZk9yR3VpVHJpZ2dlcmVkRXZlbnRPckxpbmVPckNvbnRyb2xzTGlzdE9yRGlyZWN0aW9uT3JDb2x1bW5IZWFkZXJPclJ0RXZ0T3JDdXJyZW50VGFzaywgaWdub3JlU3BlY2lmaWVkQ29udHJvbE9yR3VpVHJpZ2dlcmVkRXZlbnRPckxpbmVPclhPckNvbnRyb2xPckFjdGl2YXRlZEZyb21NRElGcmFtZSk7XHJcblxyXG4gICAgZWxzZSBpZiAoYXJndW1lbnRzLmxlbmd0aCA9PT0gMyAmJiAodGFza1JlZk9yQ3RybFJlZk9yVGFza3JlZk9yRmxkUmVmT3JFdnQgPT09IG51bGwgfHwgdGFza1JlZk9yQ3RybFJlZk9yVGFza3JlZk9yRmxkUmVmT3JFdnQgaW5zdGFuY2VvZiBNZ0NvbnRyb2xCYXNlKSAmJiAoY3RybFJlZk9yR3VpVHJpZ2dlcmVkRXZlbnRPckxpbmVPckNvbnRyb2xzTGlzdE9yRGlyZWN0aW9uT3JDb2x1bW5IZWFkZXJPclJ0RXZ0T3JDdXJyZW50VGFzayA9PT0gbnVsbCB8fCBjdHJsUmVmT3JHdWlUcmlnZ2VyZWRFdmVudE9yTGluZU9yQ29udHJvbHNMaXN0T3JEaXJlY3Rpb25PckNvbHVtbkhlYWRlck9yUnRFdnRPckN1cnJlbnRUYXNrIGluc3RhbmNlb2YgTGlzdCkgJiYgKGlnbm9yZVNwZWNpZmllZENvbnRyb2xPckd1aVRyaWdnZXJlZEV2ZW50T3JMaW5lT3JYT3JDb250cm9sT3JBY3RpdmF0ZWRGcm9tTURJRnJhbWUgPT09IG51bGwgfHwgaWdub3JlU3BlY2lmaWVkQ29udHJvbE9yR3VpVHJpZ2dlcmVkRXZlbnRPckxpbmVPclhPckNvbnRyb2xPckFjdGl2YXRlZEZyb21NRElGcmFtZS5jb25zdHJ1Y3RvciA9PT0gQm9vbGVhbikpXHJcbiAgICAgIHRoaXMuY29uc3RydWN0b3JfMTQodGFza1JlZk9yQ3RybFJlZk9yVGFza3JlZk9yRmxkUmVmT3JFdnQsIGN0cmxSZWZPckd1aVRyaWdnZXJlZEV2ZW50T3JMaW5lT3JDb250cm9sc0xpc3RPckRpcmVjdGlvbk9yQ29sdW1uSGVhZGVyT3JSdEV2dE9yQ3VycmVudFRhc2ssIGlnbm9yZVNwZWNpZmllZENvbnRyb2xPckd1aVRyaWdnZXJlZEV2ZW50T3JMaW5lT3JYT3JDb250cm9sT3JBY3RpdmF0ZWRGcm9tTURJRnJhbWUpO1xyXG5cclxuICAgIGVsc2UgaWYgKGFyZ3VtZW50cy5sZW5ndGggPT09IDMgJiYgKHRhc2tSZWZPckN0cmxSZWZPclRhc2tyZWZPckZsZFJlZk9yRXZ0ID09PSBudWxsIHx8IHRhc2tSZWZPckN0cmxSZWZPclRhc2tyZWZPckZsZFJlZk9yRXZ0IGluc3RhbmNlb2YgTWdDb250cm9sQmFzZSkgJiYgKGN0cmxSZWZPckd1aVRyaWdnZXJlZEV2ZW50T3JMaW5lT3JDb250cm9sc0xpc3RPckRpcmVjdGlvbk9yQ29sdW1uSGVhZGVyT3JSdEV2dE9yQ3VycmVudFRhc2sgPT09IG51bGwgfHwgY3RybFJlZk9yR3VpVHJpZ2dlcmVkRXZlbnRPckxpbmVPckNvbnRyb2xzTGlzdE9yRGlyZWN0aW9uT3JDb2x1bW5IZWFkZXJPclJ0RXZ0T3JDdXJyZW50VGFzay5jb25zdHJ1Y3RvciA9PT0gTnVtYmVyKSAmJiAoaWdub3JlU3BlY2lmaWVkQ29udHJvbE9yR3VpVHJpZ2dlcmVkRXZlbnRPckxpbmVPclhPckNvbnRyb2xPckFjdGl2YXRlZEZyb21NRElGcmFtZSA9PT0gbnVsbCB8fCBpZ25vcmVTcGVjaWZpZWRDb250cm9sT3JHdWlUcmlnZ2VyZWRFdmVudE9yTGluZU9yWE9yQ29udHJvbE9yQWN0aXZhdGVkRnJvbU1ESUZyYW1lLmNvbnN0cnVjdG9yID09PSBOdW1iZXIpKVxyXG4gICAgICB0aGlzLmNvbnN0cnVjdG9yXzE1KHRhc2tSZWZPckN0cmxSZWZPclRhc2tyZWZPckZsZFJlZk9yRXZ0LCBjdHJsUmVmT3JHdWlUcmlnZ2VyZWRFdmVudE9yTGluZU9yQ29udHJvbHNMaXN0T3JEaXJlY3Rpb25PckNvbHVtbkhlYWRlck9yUnRFdnRPckN1cnJlbnRUYXNrKTtcclxuXHJcbiAgICBlbHNlIGlmIChhcmd1bWVudHMubGVuZ3RoID09PSA2KVxyXG4gICAgICB0aGlzLmNvbnN0cnVjdG9yXzE2KHRhc2tSZWZPckN0cmxSZWZPclRhc2tyZWZPckZsZFJlZk9yRXZ0KTtcclxuXHJcbiAgICBlbHNlIGlmIChhcmd1bWVudHMubGVuZ3RoID09PSAyICYmICh0YXNrUmVmT3JDdHJsUmVmT3JUYXNrcmVmT3JGbGRSZWZPckV2dCA9PT0gbnVsbCB8fCB0YXNrUmVmT3JDdHJsUmVmT3JUYXNrcmVmT3JGbGRSZWZPckV2dCBpbnN0YW5jZW9mIEV2ZW50KSAmJiAoY3RybFJlZk9yR3VpVHJpZ2dlcmVkRXZlbnRPckxpbmVPckNvbnRyb2xzTGlzdE9yRGlyZWN0aW9uT3JDb2x1bW5IZWFkZXJPclJ0RXZ0T3JDdXJyZW50VGFzayA9PT0gbnVsbCB8fCBjdHJsUmVmT3JHdWlUcmlnZ2VyZWRFdmVudE9yTGluZU9yQ29udHJvbHNMaXN0T3JEaXJlY3Rpb25PckNvbHVtbkhlYWRlck9yUnRFdnRPckN1cnJlbnRUYXNrIGluc3RhbmNlb2YgUnVuVGltZUV2ZW50KSkge1xyXG4gICAgICAvLyBDYWxsIGJhc2UgY2xhc3MgY29uc3RydWN0b3IgdG8gaW5pdGlhbGl6ZSB0aGUgZXZlbnQgdHlwZSBhbmQgdGhlIG90aGVyIGZpZWxkc1xyXG4gICAgICBzdXBlci5jb25zdHJ1Y3Rvcl8xKHRhc2tSZWZPckN0cmxSZWZPclRhc2tyZWZPckZsZFJlZk9yRXZ0KTtcclxuICAgICAgdGhpcy5jb25zdHJ1Y3Rvcl8xNyggY3RybFJlZk9yR3VpVHJpZ2dlcmVkRXZlbnRPckxpbmVPckNvbnRyb2xzTGlzdE9yRGlyZWN0aW9uT3JDb2x1bW5IZWFkZXJPclJ0RXZ0T3JDdXJyZW50VGFzayk7XHJcbiAgICB9XHJcblxyXG4gICAgZWxzZSBpZiAoYXJndW1lbnRzLmxlbmd0aCA9PT0gMSAmJiB0YXNrUmVmT3JDdHJsUmVmT3JUYXNrcmVmT3JGbGRSZWZPckV2dCBpbnN0YW5jZW9mIFJ1blRpbWVFdmVudClcclxuICAgICAgT2JqZWN0LmFzc2lnbih0aGlzLCB0YXNrUmVmT3JDdHJsUmVmT3JUYXNrcmVmT3JGbGRSZWZPckV2dCk7XHJcblxyXG4gIH1cclxuXHJcbiAgLy8vIDxzdW1tYXJ5PlxyXG4gIC8vLyAgIENUT1JcclxuICAvLy8gPC9zdW1tYXJ5PlxyXG4gIC8vLyA8cGFyYW0gbmFtZSA9IFwidGFza1JlZlwiPmEgcmVmZXJlbmNlIHRvIHRoZSB0YXNrPC9wYXJhbT5cclxuICBwcml2YXRlIGNvbnN0cnVjdG9yXzUodGFza1JlZjogVGFza0Jhc2UpOiB2b2lkIHtcclxuICAgIHRoaXMuaW5pdCh0YXNrUmVmKTtcclxuICB9XHJcblxyXG4gIC8vLyA8c3VtbWFyeT5cclxuICAvLy8gICBDVE9SXHJcbiAgLy8vIDwvc3VtbWFyeT5cclxuICAvLy8gPHBhcmFtIG5hbWUgPSBcInRhc2tSZWZcIj5yZWZlcmVuY2UgdG8gdGFzazwvcGFyYW0+XHJcbiAgLy8vIDxwYXJhbSBuYW1lID0gXCJjdHJsUmVmXCI+cmVmZXJlbmNlIHRvIGNvbnRyb2w8L3BhcmFtPlxyXG4gIHByaXZhdGUgY29uc3RydWN0b3JfNih0YXNrUmVmOiBUYXNrQmFzZSwgY3RybFJlZjogTWdDb250cm9sQmFzZSk6IHZvaWQge1xyXG4gICAgdGhpcy5jb25zdHJ1Y3Rvcl81KChjdHJsUmVmICE9PSBudWxsKSA/ICg8VGFza0Jhc2U+Y3RybFJlZi5nZXRGb3JtKCkuZ2V0VGFzaygpKSA6IHRhc2tSZWYpO1xyXG4gICAgdGhpcy5Db250cm9sID0gY3RybFJlZjtcclxuICB9XHJcblxyXG4gIC8vLyA8c3VtbWFyeT5cclxuICAvLy8gICBDVE9SXHJcbiAgLy8vIDwvc3VtbWFyeT5cclxuICAvLy8gPHBhcmFtIG5hbWUgPSBcImN0cmxSZWZcIj5hIHJlZmVyZW5jZSB0byB0aGUgY29udHJvbCA8L3BhcmFtPlxyXG4gIHByaXZhdGUgY29uc3RydWN0b3JfNyhjdHJsUmVmOiBNZ0NvbnRyb2xCYXNlKTogdm9pZCB7XHJcbiAgICB0aGlzLmNvbnN0cnVjdG9yXzYobnVsbCwgY3RybFJlZik7XHJcbiAgICBpZiAoY3RybFJlZiAhPT0gbnVsbCAmJiBzdXBlci5nZXRUeXBlKCkgPT09IENoYXIuTWluVmFsdWUpIC8vIG5vdCBpbml0aWFsaXplZCB5ZXRcclxuICAgIHtcclxuICAgICAgLy8gb24gdGhlIGZpcnN0IHRpbWUsIGlmIGEgVFJJR0dFUiBwcm9wZXJ0eSBleGlzdHMsIHBhcnNlIHRoZSBldmVudCBhbmQgYWRkIGl0IHRvIHRoZSBjb250cm9sXHJcbiAgICAgIGxldCBwcm9wOiBQcm9wZXJ0eSA9IGN0cmxSZWYuR2V0Q29tcHV0ZWRQcm9wZXJ0eShQcm9wSW50ZXJmYWNlLlBST1BfVFlQRV9UUklHR0VSKTtcclxuICAgICAgaWYgKHByb3AgIT09IG51bGwpIHtcclxuICAgICAgICBsZXQgeG1sUGFyc2VyOiBYbWxQYXJzZXIgPSBuZXcgWG1sUGFyc2VyKHByb3AuR2V0Q29tcHV0ZWRWYWx1ZSgpKTtcclxuICAgICAgICBzdXBlci5maWxsRGF0YSh4bWxQYXJzZXIsIDxUYXNrQmFzZT5jdHJsUmVmLmdldEZvcm0oKS5nZXRUYXNrKCkpO1xyXG4gICAgICB9XHJcbiAgICB9XHJcbiAgfVxyXG5cclxuICAvLy8gPHN1bW1hcnk+XHJcbiAgLy8vXHJcbiAgLy8vIDwvc3VtbWFyeT5cclxuICAvLy8gPHBhcmFtIG5hbWU9XCJjdHJsUmVmXCI+PC9wYXJhbT5cclxuICAvLy8gPHBhcmFtIG5hbWU9XCJndWlUcmlnZ2VyZWRFdmVudFwiPjwvcGFyYW0+XHJcbiAgcHJpdmF0ZSBjb25zdHJ1Y3Rvcl84KGN0cmxSZWY6IE1nQ29udHJvbEJhc2UsIGd1aVRyaWdnZXJlZEV2ZW50OiBib29sZWFuKTogdm9pZCB7XHJcbiAgICB0aGlzLmNvbnN0cnVjdG9yXzcoY3RybFJlZik7XHJcbiAgICB0aGlzLl9ndWlUcmlnZ2VyZWRFdmVudCA9IGd1aVRyaWdnZXJlZEV2ZW50O1xyXG4gICAgaWYgKGd1aVRyaWdnZXJlZEV2ZW50KSB7XHJcbiAgICAgIC8vIEV2ZW50cyB0aGF0IGFyZSB0cmlnZ2VyZWQgYnkgR1VJIGxldmVsLCBtdXN0IGJlIGV4ZWN1dGVkIGFmdGVyIGFsbFxyXG4gICAgICAvLyBvdGhlciBldmVudHMsIHRodXMgdGhheSBoYXZlIGxvdyBwcmlvcml0eTtcclxuICAgICAgdGhpcy5fcHJpb3JpdHkgPSBQcmlvcml0eS5MT1c7XHJcbiAgICB9XHJcbiAgfVxyXG5cclxuICAvLy8gPHN1bW1hcnk+XHJcbiAgLy8vXHJcbiAgLy8vIDwvc3VtbWFyeT5cclxuICAvLy8gPHBhcmFtIG5hbWU9XCJjdHJsUmVmXCI+PC9wYXJhbT5cclxuICAvLy8gPHBhcmFtIG5hbWU9XCJndWlUcmlnZ2VyZWRFdmVudFwiPjwvcGFyYW0+XHJcbiAgcHJpdmF0ZSBjb25zdHJ1Y3Rvcl85KGN0cmxSZWY6IE1nQ29udHJvbEJhc2UsIGd1aVRyaWdnZXJlZEV2ZW50OiBib29sZWFuLCBpZ25vcmVTcGVjaWZpZWRDb250cm9sOiBib29sZWFuKTogdm9pZCB7XHJcbiAgICB0aGlzLmNvbnN0cnVjdG9yXzgoY3RybFJlZiwgZ3VpVHJpZ2dlcmVkRXZlbnQpO1xyXG4gICAgdGhpcy5JZ25vcmVTcGVjaWZpZWRDb250cm9sID0gaWdub3JlU3BlY2lmaWVkQ29udHJvbDtcclxuICB9XHJcblxyXG4gIC8vLyA8c3VtbWFyeT5cclxuICAvLy8gICBDVE9SXHJcbiAgLy8vIDwvc3VtbWFyeT5cclxuICAvLy8gPHBhcmFtIG5hbWUgPSBcInRhc2tyZWZcIj5yZWZlcmVuY2UgdG8gdGFzazwvcGFyYW0+XHJcbiAgLy8vIDxwYXJhbSBuYW1lID0gXCJndWlUcmlnZ2VyZWRFdmVudFwiPjwvcGFyYW0+XHJcbiAgcHJpdmF0ZSBjb25zdHJ1Y3Rvcl8xMCh0YXNrcmVmOiBUYXNrQmFzZSwgZ3VpVHJpZ2dlcmVkRXZlbnQ6IGJvb2xlYW4pOiB2b2lkIHtcclxuICAgIHRoaXMuY29uc3RydWN0b3JfNSh0YXNrcmVmKTtcclxuICAgIHRoaXMuX2d1aVRyaWdnZXJlZEV2ZW50ID0gZ3VpVHJpZ2dlcmVkRXZlbnQ7XHJcbiAgICBpZiAoZ3VpVHJpZ2dlcmVkRXZlbnQpIHtcclxuICAgICAgdGhpcy5fcHJpb3JpdHkgPSBQcmlvcml0eS5MT1c7XHJcbiAgICB9XHJcbiAgfVxyXG5cclxuICAvLy8gPHN1bW1hcnk+XHJcbiAgLy8vICAgQ1RPUlxyXG4gIC8vLyA8L3N1bW1hcnk+XHJcbiAgLy8vIDxwYXJhbSBuYW1lID0gXCJmbGRSZWZcIj5hIHJlZmVyZW5jZSB0byB0aGUgZmllbGQ8L3BhcmFtPlxyXG4gIHByaXZhdGUgY29uc3RydWN0b3JfMTEoZmxkUmVmOiBHdWlGaWVsZEJhc2UpOiB2b2lkIHtcclxuICAgIHRoaXMuX2V2ZW50RmxkID0gZmxkUmVmO1xyXG4gICAgdGhpcy5pbml0KChmbGRSZWYgIT09IG51bGwpID8gKDxUYXNrQmFzZT5mbGRSZWYuZ2V0VGFzaygpKSA6IG51bGwpO1xyXG4gIH1cclxuXHJcbiAgLy8vIDxzdW1tYXJ5PlxyXG4gIC8vLyAgIENUT1JcclxuICAvLy8gPC9zdW1tYXJ5PlxyXG4gIC8vLyA8cGFyYW0gbmFtZSA9IFwiY3RybFJlZlwiPmEgcmVmZXJlbmNlIHRvIHRoZSBjb250cm9sIG9uIHdoaWNoIHRoZSBldmVudCBvY2N1cmVkIDwvcGFyYW0+XHJcbiAgLy8vIDxwYXJhbSBuYW1lID0gXCJsaW5lXCI+dGhlIGxpbmUgb2YgdGhlIHRhYmxlIGluIHdoaWNoIHRoZSBjb250cm9sIGlzIGxvY2F0ZWQgPC9wYXJhbT5cclxuICBwcml2YXRlIGNvbnN0cnVjdG9yXzEyKGN0cmxSZWY6IE1nQ29udHJvbEJhc2UsIGxpbmU6IG51bWJlcik6IHZvaWQge1xyXG4gICAgdGhpcy5jb25zdHJ1Y3Rvcl83KGN0cmxSZWYpO1xyXG4gICAgdGhpcy5fZGlzcGxheUxpbmUgPSBsaW5lO1xyXG4gIH1cclxuXHJcbiAgcHJpdmF0ZSBjb25zdHJ1Y3Rvcl8xMyhjdHJsUmVmOiBNZ0NvbnRyb2xCYXNlLCBsaW5lOiBudW1iZXIsIGd1aVRyaWdnZXJlZEV2ZW50OiBib29sZWFuKTogdm9pZCB7XHJcbiAgICB0aGlzLmNvbnN0cnVjdG9yXzgoY3RybFJlZiwgZ3VpVHJpZ2dlcmVkRXZlbnQpO1xyXG4gICAgdGhpcy5fZGlzcGxheUxpbmUgPSBsaW5lO1xyXG4gIH1cclxuXHJcbiAgcHJpdmF0ZSBjb25zdHJ1Y3Rvcl8xNChjdHJsUmVmOiBNZ0NvbnRyb2xCYXNlLCBjb250cm9sc0xpc3Q6IExpc3Q8TWdDb250cm9sQmFzZT4sIGd1aVRyaWdnZXJlZEV2ZW50OiBib29sZWFuKTogdm9pZCB7XHJcbiAgICB0aGlzLmNvbnN0cnVjdG9yXzgoY3RybFJlZiwgZ3VpVHJpZ2dlcmVkRXZlbnQpO1xyXG4gICAgdGhpcy5fY29udHJvbHNMaXN0ID0gY29udHJvbHNMaXN0O1xyXG4gIH1cclxuXHJcbiAgcHJpdmF0ZSBjb25zdHJ1Y3Rvcl8xNShjdHJsUmVmOiBNZ0NvbnRyb2xCYXNlLCBkaXJlY3Rpb246IG51bWJlcik6IHZvaWQge1xyXG4gICAgdGhpcy5jb25zdHJ1Y3Rvcl84KGN0cmxSZWYsIHRydWUpO1xyXG4gICAgdGhpcy5fZGlyZWN0aW9uID0gZGlyZWN0aW9uO1xyXG4gIH1cclxuXHJcbiAgcHJpdmF0ZSBjb25zdHJ1Y3Rvcl8xNihjdHJsUmVmOiBNZ0NvbnRyb2xCYXNlICk6IHZvaWQge1xyXG4gICAgdGhpcy5jb25zdHJ1Y3Rvcl84KGN0cmxSZWYsIHRydWUpO1xyXG4gIH1cclxuXHJcbiAgLy8vIDxzdW1tYXJ5PlxyXG4gIC8vLyAgIENUT1IgLSBjcmVhdGVzIGEgbmV3IHJ1biB0aW1lIGV2ZW50IGJ5IGNvcHlpbmcgdGhlIG1lbWJlciB2YXJpYWJsZXMgb2YgYSBnaXZlblxyXG4gIC8vLyAgIGV2ZW50IGFuZCB0aGUgbWVtYmVyIHZhcmlhYmxlcyBvZiBhIGdpdmVuIHJ1biB0aW1lIGV2ZW50XHJcbiAgLy8vIDwvc3VtbWFyeT5cclxuICAvLy8gPHBhcmFtIG5hbWUgPSBcImV2dFwiPmEgcmVmZXJlbmNlIHRvIHRoZSBldmVudCB0byBiZSB1c2VkIDwvcGFyYW0+XHJcbiAgLy8vIDxwYXJhbSBuYW1lID0gXCJydEV2dFwiPmEgcmVmZXJlbmNlIHRvIHRoZSBydW4gdGltZSBldmVudCB0byBiZSB1c2VkIDwvcGFyYW0+XHJcbiAgcHJpdmF0ZSBjb25zdHJ1Y3Rvcl8xNyggcnRFdnQ6IFJ1blRpbWVFdmVudCk6IHZvaWQge1xyXG4gICAgdGhpcy5fdGFza1RhZyA9IHJ0RXZ0Ll90YXNrVGFnO1xyXG4gICAgdGhpcy5fdGFzayA9IHJ0RXZ0Ll90YXNrO1xyXG4gICAgdGhpcy5Db250cm9sID0gcnRFdnQuQ29udHJvbDtcclxuICAgIHRoaXMuX2V2ZW50RmxkID0gcnRFdnQuX2V2ZW50RmxkO1xyXG4gICAgdGhpcy5fbWdkSWQgPSBydEV2dC5fbWdkSWQ7XHJcbiAgICB0aGlzLl9kaXNwbGF5TGluZSA9IHJ0RXZ0Ll9kaXNwbGF5TGluZTtcclxuICAgIHRoaXMuX3JldmVyc2libGVFeGl0ID0gcnRFdnQuX3JldmVyc2libGVFeGl0O1xyXG4gICAgdGhpcy5fYXJnTGlzdCA9IHJ0RXZ0Ll9hcmdMaXN0O1xyXG4gICAgdGhpcy5faW1tZWRpYXRlID0gcnRFdnQuX2ltbWVkaWF0ZTtcclxuICAgIHRoaXMuX21wcmdDcmVhdG9yID0gcnRFdnQuX21wcmdDcmVhdG9yO1xyXG4gICAgdGhpcy5fcHJpb3JpdHkgPSBydEV2dC5fcHJpb3JpdHk7XHJcbiAgICB0aGlzLl9ndWlUcmlnZ2VyZWRFdmVudCA9IHJ0RXZ0Ll9ndWlUcmlnZ2VyZWRFdmVudDtcclxuICAgIHRoaXMuX2lzSWRsZVRpbWVyID0gcnRFdnQuX2lzSWRsZVRpbWVyO1xyXG4gICAgdGhpcy5fdmFsID0gcnRFdnQuX3ZhbDtcclxuICAgIHRoaXMuX3NlbGVjdGlvblN0YXJ0ID0gcnRFdnQuX3NlbGVjdGlvblN0YXJ0O1xyXG4gICAgdGhpcy5fc2VsZWN0aW9uRW5kID0gcnRFdnQuX3NlbGVjdGlvbkVuZDtcclxuICAgIHRoaXMuX2NvbnRyb2xzTGlzdCA9IHJ0RXZ0Ll9jb250cm9sc0xpc3Q7XHJcbiAgICB0aGlzLl9kaXJlY3Rpb24gPSBydEV2dC5fZGlyZWN0aW9uO1xyXG4gICAgdGhpcy5fZG90TmV0T2JqZWN0ID0gcnRFdnQuX2RvdE5ldE9iamVjdDtcclxuICAgIHRoaXMuTGFzdEZvY3VzZWRWYWwgPSBydEV2dC5MYXN0Rm9jdXNlZFZhbDtcclxuICAgIHRoaXMuX3JvdXRlUGFyYW1zID0gcnRFdnQuX3JvdXRlUGFyYW1zO1xyXG4gIH1cclxuXHJcblxyXG4gIC8vLyA8c3VtbWFyeT5cclxuICAvLy8gICBpbXBsZW1lbnRpbmcgY29tcGFyYXRvciwgdGhlIGV2ZW50cyBhcmUgY29tcGFyZWQgYnkgcHJpb3JpdHlcclxuICAvLy8gPC9zdW1tYXJ5PlxyXG4gIENvbXBhcmVUbyhvYmo6IGFueSk6IG51bWJlciB7XHJcbiAgICBsZXQgb3RoZXJUaW1lRXZlbnQ6IFJ1blRpbWVFdmVudCA9IDxSdW5UaW1lRXZlbnQ+b2JqO1xyXG4gICAgbGV0IG90aGVyUHJpb3JpdHk6IFByaW9yaXR5ID0gb3RoZXJUaW1lRXZlbnQuX3ByaW9yaXR5O1xyXG4gICAgbGV0IHJlc3VsdDogbnVtYmVyID0gb3RoZXJQcmlvcml0eSAtIHRoaXMuX3ByaW9yaXR5O1xyXG4gICAgaWYgKHJlc3VsdCA9PT0gMClcclxuICAgICAgcmVzdWx0ID0gPG51bWJlcj4odGhpcy5fdGltZXN0YW1wIC0gb3RoZXJUaW1lRXZlbnQuX3RpbWVzdGFtcCk7XHJcbiAgICByZXR1cm4gcmVzdWx0O1xyXG4gIH1cclxuXHJcbiAgLy8vIDxzdW1tYXJ5PlxyXG4gIC8vLyAgIHJldHVybnMgYSByZXBsaWNhIG9mIHRoaXMgcnVudGltZSBldmVudFxyXG4gIC8vLyA8L3N1bW1hcnk+XHJcbiAgcmVwbGljYXRlKCk6IFJ1blRpbWVFdmVudCB7XHJcbiAgICBsZXQgcnVuVGltZUV2ZW50OiBSdW5UaW1lRXZlbnQgPSBuZXcgUnVuVGltZUV2ZW50KHRoaXMpO1xyXG4gICAgcnVuVGltZUV2ZW50LnNldFRpbWVzdGFtcCgpO1xyXG4gICAgcmV0dXJuIHJ1blRpbWVFdmVudDtcclxuICB9XHJcblxyXG4gIC8vLyA8c3VtbWFyeT5cclxuICAvLy8gICBhIGhlbHBlciBtZXRob2QgdGhhdCBkb2VzIHNvbWUgY29tbW9uIGluaXRpYWxpemF0aW9uIGZvciBzb21lIG9mIHRoZSBjb25zdHJ1Y3RvcnNcclxuICAvLy8gPC9zdW1tYXJ5PlxyXG4gIHByaXZhdGUgaW5pdCh0YXNrUmVmOiBUYXNrQmFzZSk6IHZvaWQge1xyXG4gICAgdGhpcy5fdGFzayA9ICh0YXNrUmVmIHx8ICg8TUdEYXRhPkFjY2Vzc0hlbHBlci5tZ0RhdGFUYWJsZS5nZXRDdXJyTUdEYXRhKCkpLmdldEZpcnN0VGFzaygpKTtcclxuICAgIHRoaXMuX3Rhc2tUYWcgPSAoKHRoaXMuX3Rhc2sgPT09IG51bGwpID8gXCJcIiA6IHRoaXMuX3Rhc2suZ2V0VGFza1RhZygpKTtcclxuICAgIHRoaXMuX21wcmdDcmVhdG9yID0gbnVsbDtcclxuICB9XHJcblxyXG4gIC8vLyA8c3VtbWFyeT5cclxuICAvLy8gICBjb252ZXJ0cyBwYXJhbWV0ZXJzIHRvIGFyZ3VtZW50IGxpc3RcclxuICAvLy8gPC9zdW1tYXJ5PlxyXG4gIGNvbnZlcnRQYXJhbXNUb0FyZ3MoKTogdm9pZCB7XHJcbiAgICB0aGlzLl9hcmdMaXN0ID0gbmV3IEFyZ3VtZW50c0xpc3QoKTtcclxuICAgIHRoaXMuX2FyZ0xpc3QuYnVpbGRMaXN0RnJvbVBhcmFtcyh0aGlzLl9wYXJhbWV0ZXJzLCB0aGlzLl9wYXJhbUF0dHJzLCB0aGlzLl9wYXJhbVZhbHMsIHRoaXMuX3BhcmFtTnVsbHMpO1xyXG4gICAgdGhpcy5fcGFyYW1ldGVycyA9IDA7XHJcbiAgICB0aGlzLl9wYXJhbUF0dHJzID0gbnVsbDtcclxuICAgIHRoaXMuX3BhcmFtVmFscyA9IG51bGw7XHJcbiAgICB0aGlzLl9wYXJhbU51bGxzID0gbnVsbDtcclxuICB9XHJcblxyXG4gIC8vLyA8c3VtbWFyeT5cclxuICAvLy8gICBnZXQgYSByZWZlcmVuY2UgdG8gdGhlIHRhc2tcclxuICAvLy8gPC9zdW1tYXJ5PlxyXG4gIGdldFRhc2soKTogVGFza0Jhc2Uge1xyXG4gICAgc3VwZXIuZmluZFVzZXJFdmVudCgpO1xyXG4gICAgcmV0dXJuIHRoaXMuX3Rhc2s7XHJcbiAgfVxyXG5cclxuICAvLy8gPHN1bW1hcnk+XHJcbiAgLy8vICAgc2V0IHRoZSB0YXNrXHJcbiAgLy8vIDwvc3VtbWFyeT5cclxuICAvLy8gPHBhcmFtIG5hbWUgPSBcImFUYXNrXCI+LSByZWZlcmVuY2UgdG8gYSB0YXNrPC9wYXJhbT5cclxuICBzZXRUYXNrKHRhc2tSZWY6IFRhc2tCYXNlKTogdm9pZCB7XHJcbiAgICB0aGlzLl90YXNrID0gdGFza1JlZjtcclxuXHJcbiAgICBpZiAodGhpcy5fdGFzayAhPT0gbnVsbClcclxuICAgICAgdGhpcy5fdGFza1RhZyA9IHRoaXMuX3Rhc2suZ2V0VGFza1RhZygpO1xyXG4gICAgZWxzZVxyXG4gICAgICB0aGlzLl90YXNrVGFnID0gbnVsbDtcclxuICB9XHJcblxyXG4gIC8vLyA8c3VtbWFyeT5cclxuICAvLy8gICBzZXQgYSBUaW1lciBldmVudFxyXG4gIC8vLyA8L3N1bW1hcnk+XHJcbiAgLy8vIDxwYXJhbSBuYW1lID0gXCJzZWNvbmRzXCI+dGhlIG51bWJlciBvZiBzZWNvbmRzIGZvciB0aGlzIGV2ZW50czwvcGFyYW0+XHJcbiAgLy8vIDxwYXJhbSBuYW1lID0gXCJudW1iZXJXbmRcIj50aGUgbWdkYXRhIElEIGZvciB0aGUgZXZlbnQ8L3BhcmFtPlxyXG4gIHNldFRpbWVyKHNlYzogbnVtYmVyLCBtZ2RJRDogbnVtYmVyLCBpc0lkbGU6IGJvb2xlYW4pOiB2b2lkIHtcclxuICAgIHRoaXMuX3R5cGUgPSBDb25zdEludGVyZmFjZS5FVkVOVF9UWVBFX1RJTUVSIC8qJ1QnKi87XHJcbiAgICB0aGlzLl9zZWNvbmRzID0gc2VjO1xyXG4gICAgdGhpcy5fbWdkSWQgPSBtZ2RJRDtcclxuICAgIHRoaXMuX2lzSWRsZVRpbWVyID0gaXNJZGxlO1xyXG4gIH1cclxuXHJcblxyXG4gIC8vLyA8c3VtbWFyeT5cclxuICAvLy8gICBnZXQgdGhlIGxpbmUgaW4gdGFibGUgb2YgY29udHJvbCBpbiBhIHRhYmxlXHJcbiAgLy8vIDwvc3VtbWFyeT5cclxuICAvLy8gPHJldHVybnM+IHRoZSBsaW5lIG51bWJlcjwvcmV0dXJucz5cclxuICBnZXREaXNwbGF5TGluZSgpOiBudW1iZXIge1xyXG4gICAgcmV0dXJuIHRoaXMuX2Rpc3BsYXlMaW5lO1xyXG4gIH1cclxuXHJcbiAgLy8vIDxzdW1tYXJ5PlxyXG4gIC8vLyAgIGdldCBudW1iZXIgb2Ygd2luZG93IChmb3IgdGltZXIgZXZlbnRzKVxyXG4gIC8vLyA8L3N1bW1hcnk+XHJcbiAgZ2V0TWdkSUQoKTogbnVtYmVyIHtcclxuICAgIHJldHVybiB0aGlzLl9tZ2RJZDtcclxuICB9XHJcblxyXG4gIC8vLyA8c3VtbWFyeT5cclxuICAvLy8gICBnZXQgdGhlIGJyZWFrIGxldmVsIG9mIEV2ZW50XHJcbiAgLy8vIDwvc3VtbWFyeT5cclxuICBnZXRCcmtMZXZlbCgpOiBzdHJpbmc7XHJcbiAgZ2V0QnJrTGV2ZWwoZmxvd01vbml0b3I6IGJvb2xlYW4pOiBzdHJpbmc7XHJcbiAgZ2V0QnJrTGV2ZWwoZmxvd01vbml0b3I/OiBib29sZWFuKTogc3RyaW5nIHtcclxuICAgIGlmIChhcmd1bWVudHMubGVuZ3RoID09PSAwKSB7XHJcbiAgICAgIHJldHVybiB0aGlzLmdldEJya0xldmVsXzAwKCk7XHJcbiAgICB9XHJcbiAgICByZXR1cm4gdGhpcy5nZXRCcmtMZXZlbF8wMShmbG93TW9uaXRvcik7XHJcbiAgfVxyXG5cclxuICBwcml2YXRlIGdldEJya0xldmVsXzAwKCk6IHN0cmluZyB7XHJcbiAgICBsZXQgbGV2ZWw6IHN0cmluZyA9IHN1cGVyLmdldEJya0xldmVsKCk7XHJcbiAgICBpZiAodGhpcy5fdHlwZSA9PT0gQ29uc3RJbnRlcmZhY2UuRVZFTlRfVFlQRV9JTlRFUk5BTCkge1xyXG4gICAgICBzd2l0Y2ggKHRoaXMuSW50ZXJuYWxFdmVudCkge1xyXG4gICAgICAgIGNhc2UgSW50ZXJuYWxJbnRlcmZhY2UuTUdfQUNUX0NUUkxfUFJFRklYOlxyXG4gICAgICAgIGNhc2UgSW50ZXJuYWxJbnRlcmZhY2UuTUdfQUNUX0NUUkxfU1VGRklYOlxyXG4gICAgICAgIGNhc2UgSW50ZXJuYWxJbnRlcmZhY2UuTUdfQUNUX0NUUkxfVkVSSUZJQ0FUSU9OOlxyXG4gICAgICAgICAgbGV2ZWwgKz0gdGhpcy5Db250cm9sLk5hbWU7XHJcbiAgICAgICAgICBicmVhaztcclxuICAgICAgICBjYXNlIEludGVybmFsSW50ZXJmYWNlLk1HX0FDVF9WQVJJQUJMRTpcclxuICAgICAgICAgIGxldmVsICs9IHRoaXMuX2V2ZW50RmxkLmdldFZhck5hbWUoKTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICB9XHJcbiAgICB9XHJcbiAgICByZXR1cm4gbGV2ZWw7XHJcbiAgfVxyXG5cclxuICBwcml2YXRlIGdldEJya0xldmVsXzAxKGZsb3dNb25pdG9yOiBib29sZWFuKTogc3RyaW5nIHtcclxuICAgIHJldHVybiBzdXBlci5nZXRCcmtMZXZlbChmbG93TW9uaXRvcik7XHJcbiAgfVxyXG5cclxuLy8vIDxzdW1tYXJ5PlxyXG4gIC8vLyAgIHNldCBhIG5ldyBjb250cm9sIGZvciB0aGUgcnVudGltZSBldmVudFxyXG4gIC8vLyA8L3N1bW1hcnk+XHJcbiAgLy8vIDxwYXJhbSBuYW1lID0gXCJuZXdDdHJsXCI+YSByZWZlcmVuY2UgdG8gdGhlIG5ldyBjb250cm9sIDwvcGFyYW0+XHJcbiAgc2V0Q3RybChuZXdDdHJsOiBNZ0NvbnRyb2xCYXNlKTogdm9pZCB7XHJcbiAgICB0aGlzLl9jdHJsID0gbmV3Q3RybDtcclxuICB9XHJcblxyXG4gIC8vLyA8c3VtbWFyeT5cclxuICAvLy8gICBzZXQgdGhlIHJldmVyc2libGUgZXhpdCBmbGFnIHRvIGZhbHNlXHJcbiAgLy8vIDwvc3VtbWFyeT5cclxuICBzZXROb25SZXZlcnNpYmxlRXhpdCgpOiB2b2lkIHtcclxuICAgIHRoaXMuX3JldmVyc2libGVFeGl0ID0gZmFsc2U7XHJcbiAgfVxyXG5cclxuICAvLy8gPHN1bW1hcnk+XHJcbiAgLy8vICAgcmV0dXJucyB0aGUgdmFsdWUgb2YgdGhlIHJldmVyc2libGUgZXhpdCBmbGFnXHJcbiAgLy8vIDwvc3VtbWFyeT5cclxuICByZXZlcnNpYmxlRXhpdCgpOiBib29sZWFuIHtcclxuICAgIHJldHVybiB0aGlzLl9yZXZlcnNpYmxlRXhpdDtcclxuICB9XHJcblxyXG4gIC8vLyA8c3VtbWFyeT5cclxuICAvLy8gICBidWlsZCBYTUwgRXZlbnQgc3RyaW5nIGZvciBTZXJ2ZXJcclxuICAvLy8gPC9zdW1tYXJ5PlxyXG4gIHB1YmxpYyBidWlsZFhNTChtZXNzYWdlOiBTdHJpbmdCdWlsZGVyKTogdm9pZCB7XHJcbiAgICBtZXNzYWdlLkFwcGVuZChcIlxcbiAgIFwiICsgWE1MQ29uc3RhbnRzLlRBR19PUEVOICsgQ29uc3RJbnRlcmZhY2UuTUdfVEFHX0VWRU5UKTtcclxuXHJcbiAgICBpZiAodGhpcy5fdHlwZSAhPT0gQ2hhci5NaW5WYWx1ZSlcclxuICAgICAgbWVzc2FnZS5BcHBlbmQoXCIgXCIgKyBDb25zdEludGVyZmFjZS5NR19BVFRSX0VWRU5UVFlQRSArIFwiPVxcXCJcIiArIHRoaXMuX3R5cGUgKyBcIlxcXCJcIik7XHJcblxyXG4gICAgaWYgKHRoaXMuX3R5cGUgPT09IENvbnN0SW50ZXJmYWNlLkVWRU5UX1RZUEVfU1lTVEVNICYmIHRoaXMua2JkSXRtICE9IG51bGwpIHtcclxuICAgICAgbGV0IG1vZGlmaWVyOiBNb2RpZmllcnMgPSB0aGlzLmtiZEl0bS5nZXRNb2RpZmllcigpO1xyXG4gICAgICBpZiAobW9kaWZpZXIgIT09IE1vZGlmaWVycy5NT0RJRklFUl9OT05FKVxyXG4gICAgICAgIG1lc3NhZ2UuQXBwZW5kKFwiIFwiICsgQ29uc3RJbnRlcmZhY2UuTUdfQVRUUl9NT0RJRklFUiArIFwiPVxcXCJcIiArIG1vZGlmaWVyICsgXCJcXFwiXCIpO1xyXG4gICAgICBtZXNzYWdlLkFwcGVuZChcIiBcIiArIENvbnN0SW50ZXJmYWNlLk1HX0FUVFJfS0VZQ09ERSArIFwiPVxcXCJcIiArIHRoaXMua2JkSXRtLmdldEtleUNvZGUoKSArIFwiXFxcIlwiKTtcclxuICAgIH1cclxuICAgIGlmICh0aGlzLkludGVybmFsRXZlbnQgIT09IEludDMyLk1pblZhbHVlKVxyXG4gICAgICBtZXNzYWdlLkFwcGVuZChcIiBcIiArIENvbnN0SW50ZXJmYWNlLk1HX0FUVFJfSU5URVJOQUxFVkVOVCArIFwiPVxcXCJcIiArIHRoaXMuSW50ZXJuYWxFdmVudCArIFwiXFxcIlwiKTtcclxuICAgIGlmICh0aGlzLl9zZWNvbmRzICE9PSBJbnQzMi5NaW5WYWx1ZSlcclxuICAgICAgbWVzc2FnZS5BcHBlbmQoXCIgXCIgKyBDb25zdEludGVyZmFjZS5NR19BVFRSX1NFQ09ORFMgKyBcIj1cXFwiXCIgKyB0aGlzLl9zZWNvbmRzICsgXCJcXFwiXCIpO1xyXG4gICAgaWYgKHRoaXMuRXhwICE9IG51bGwpXHJcbiAgICAgIG1lc3NhZ2UuQXBwZW5kKFwiIFwiICsgWE1MQ29uc3RhbnRzLk1HX0FUVFJfRVhQICsgXCI9XFxcIlwiICsgdGhpcy5FeHAuZ2V0SWQoKSArIFwiXFxcIlwiKTtcclxuICAgIGlmICh0aGlzLl9mb3JjZUV4aXQgIT09IEZvcmNlRXhpdC5Ob25lKVxyXG4gICAgICBtZXNzYWdlLkFwcGVuZChcIiBcIiArIFhNTENvbnN0YW50cy5NR19BVFRSX0VYUCArIFwiPVxcXCJcIiArIDxzdHJpbmc+dGhpcy5fZm9yY2VFeGl0ICsgXCJcXFwiXCIpO1xyXG4gICAgaWYgKHRoaXMuVXNlckV2dCAhPSBudWxsKVxyXG4gICAgICBtZXNzYWdlLkFwcGVuZChcIiBcIiArIENvbnN0SW50ZXJmYWNlLk1HX0FUVFJfVVNFUiArIFwiPVxcXCJcIiArIHRoaXMuVXNlckV2dFRhc2tUYWcgKyBcIixcIiArIHRoaXMuX3VzZXJFdnRJZHggKyBcIlxcXCJcIik7XHJcblxyXG4gICAgbWVzc2FnZS5BcHBlbmQoWE1MQ29uc3RhbnRzLlRBR19URVJNKTtcclxuICB9XHJcblxyXG4gIC8vLyA8c3VtbWFyeT5cclxuICAvLy8gICBnZXQgdGhlIGFyZ0xpc3RcclxuICAvLy8gPC9zdW1tYXJ5PlxyXG4gIC8vLyA8cmV0dXJucz4gdGhlIGFyZ0xpc3Q8L3JldHVybnM+XHJcbiAgZ2V0QXJnTGlzdCgpOiBBcmd1bWVudHNMaXN0IHtcclxuICAgIHJldHVybiB0aGlzLl9hcmdMaXN0O1xyXG4gIH1cclxuXHJcbiAgLy8vIDxzdW1tYXJ5PlxyXG4gIC8vLyAgIHNldCB0aGUgYXJnTGlzdFxyXG4gIC8vLyA8L3N1bW1hcnk+XHJcbiAgLy8vIDxwYXJhbSBuYW1lID0gXCJhQXJnTGlzdFwiPjwvcGFyYW0+XHJcbiAgc2V0QXJnTGlzdChhQXJnTGlzdDogQXJndW1lbnRzTGlzdCk6IGJvb2xlYW4ge1xyXG4gICAgbGV0IHJlc3VsdDogYm9vbGVhbiA9IHRoaXMuX2FyZ0xpc3QgPT09IG51bGw7XHJcbiAgICB0aGlzLl9hcmdMaXN0ID0gYUFyZ0xpc3Q7XHJcbiAgICByZXR1cm4gcmVzdWx0O1xyXG4gIH1cclxuXHJcbiAgLy8vIDxzdW1tYXJ5PlxyXG4gIC8vLyAgIHNldCB0aGUgYXJnTGlzdFxyXG4gIC8vLyA8L3N1bW1hcnk+XHJcbiAgLy8vIDxwYXJhbSBuYW1lID0gXCJhQXJnTGlzdFwiPjwvcGFyYW0+XHJcbiAgc2V0Um91dGVQYXJhbUxpc3Qocm91dGVQYXJhbXM6IExpc3Q8YW55Pik6IHZvaWQge1xyXG4gICAgdGhpcy5fcm91dGVQYXJhbXMgPSByb3V0ZVBhcmFtcztcclxuICB9XHJcblxyXG4gIGdldFJvdXRlUGFyYW1MaXN0KCk6IExpc3Q8YW55PiB7XHJcbiAgICByZXR1cm4gdGhpcy5fcm91dGVQYXJhbXM7XHJcbiAgfVxyXG5cclxuICAvLy8gPHN1bW1hcnk+XHJcbiAgLy8vICAgc2V0IGEgdmFsdWUgdG8gdGhlIGltbWVkaWF0ZSBmbGFnXHJcbiAgLy8vIDwvc3VtbWFyeT5cclxuICAvLy8gPHBhcmFtIG5hbWUgPSBcInZhbFwiPnRoZSB2YWx1ZSB0byB1c2U8L3BhcmFtPlxyXG4gIHNldEltbWVkaWF0ZSh2YWw6IGJvb2xlYW4pOiB2b2lkIHtcclxuICAgIHRoaXMuX2ltbWVkaWF0ZSA9IHZhbDtcclxuICB9XHJcblxyXG4gIC8vLyA8c3VtbWFyeT5cclxuICAvLy8gICByZXR1cm5zIHRoZSB2YWx1ZSBvZiB0aGUgaW1tZWRpYXRlIGZsYWdcclxuICAvLy8gPC9zdW1tYXJ5PlxyXG4gIGlzSW1tZWRpYXRlKCk6IGJvb2xlYW4ge1xyXG4gICAgcmV0dXJuIHRoaXMuX2ltbWVkaWF0ZTtcclxuICB9XHJcblxyXG4gIC8vLyA8c3VtbWFyeT5cclxuICAvLy8gICBzZXQgdGhlIHJlZmVyZW5jZSB0byB0aGUgdGFzayB3aGljaCBpcyBcInJlc3BvbnNpYmxlXCIgZm9yIGEgbWFpbiBwcm9ncmFtIHRvIGJlY29tZSBhY3RpdmUuXHJcbiAgLy8vICAgRm9yIGV4YW1wbGU6IGlmIHRhc2sgQSBjYWxscyB0YXNrIEIgYW5kIEIncyBjdGxJZHggaXMgZGlmZmVyZW50IHRoYW4gQSdzLCB0aGVuIEIncyBtYWluXHJcbiAgLy8vICAgcHJvZ3JhbSB3aWxsIGJlIGluc2VydGVkIGludG8gdGhlIHRhc2sgaGlyYXJjaHkgdGh1cyBCIGlzIFwicmVzcG9uc2libGVcIiBmb3IgdGhlIG1haW4gcHJnLlxyXG4gIC8vLyA8L3N1bW1hcnk+XHJcbiAgLy8vIDxwYXJhbSBuYW1lID0gXCJzcmNcIj50aGUgXCJyZXNwb25zaWJsZVwiIHRhc2suPC9wYXJhbT5cclxuICBzZXRNYWluUHJnQ3JlYXRvcihzcmM6IFRhc2tCYXNlKTogdm9pZCB7XHJcbiAgICB0aGlzLl9tcHJnQ3JlYXRvciA9IHNyYztcclxuICB9XHJcblxyXG4gIC8vLyA8c3VtbWFyeT5cclxuICAvLy8gICBnZXQgdGhlIHRhc2sgd2hpY2ggaXMgXCJyZXNwb25zaWJsZVwiIGZvciBhIG1haW4gcHJvZ3JhbSdzIGV4ZWN1dGlvblxyXG4gIC8vLyA8L3N1bW1hcnk+XHJcbiAgLy8vIDxyZXR1cm5zPiB0aGUgXCJyZXNwb25zaWJsZVwiIHRhc2suPC9yZXR1cm5zPlxyXG4gIGdldE1haW5QcmdDcmVhdG9yKCk6IFRhc2tCYXNlIHtcclxuICAgIHJldHVybiB0aGlzLl9tcHJnQ3JlYXRvcjtcclxuICB9XHJcblxyXG4vLy8gPHN1bW1hcnk+XHJcbiAgLy8vICAgc2V0cyB0aGUgaXNSZWFsUmVmcmVzaCBmbGFnIHRvIGEgZ2l2ZW4gdmFsdWVcclxuICAvLy8gPC9zdW1tYXJ5PlxyXG4gIHNldElzUmVhbFJlZnJlc2godmFsOiBib29sZWFuKTogdm9pZCB7XHJcbiAgICB0aGlzLl9pc1JlYWxSZWZyZXNoID0gdmFsO1xyXG4gIH1cclxuXHJcbiAgLy8vIDxzdW1tYXJ5PlxyXG4gIC8vLyAgIHJldHVybnMgdGhlIHR5cGUgb2YgYSByZWZyZXNoIGV2ZW50IHRydWUgaXMgcmVhbCByZWZyZXNoIGUuaS4gb25lIGludm9rZWQgZGlyZWN0bGx5IGJ5IHRoZSB1c2VyXHJcbiAgLy8vIDwvc3VtbWFyeT5cclxuICBnZXRSZWZyZXNoVHlwZSgpOiBib29sZWFuIHtcclxuICAgIHJldHVybiB0aGlzLl9pc1JlYWxSZWZyZXNoO1xyXG4gIH1cclxuXHJcbiAgLy8vIDxzdW1tYXJ5PlxyXG4gIC8vLyAgIG1hcmsgdGhlIGV2ZW50IGFzIGFuIGV2ZW50IHdoaWNoIHdhcyBjcmVhdGVkIGJ5IHRoZSBzZXJ2ZXJcclxuICAvLy8gPC9zdW1tYXJ5PlxyXG4gIHNldEZyb21TZXJ2ZXIoKTogdm9pZCB7XHJcbiAgICB0aGlzLl9mcm9tU2VydmVyID0gdHJ1ZTtcclxuICB9XHJcblxyXG4gIC8vLyA8c3VtbWFyeT5cclxuICAvLy8gICBtYXJrIHRoZSBldmVudCBhcyBhbiBldmVudCB3aGljaCB3YXMgbm90IGNyZWF0ZWQgYnkgdGhlIHNlcnZlclxyXG4gIC8vLyA8L3N1bW1hcnk+XHJcbiAgcmVzZXRGcm9tU2VydmVyKCk6IHZvaWQge1xyXG4gICAgdGhpcy5fZnJvbVNlcnZlciA9IGZhbHNlO1xyXG4gIH1cclxuXHJcbiAgLy8vIDxyZXR1cm5zPiBhbiBpbmRpY2F0aW9uIHdoZWF0aGVyIHRoZSBzZXJ2ZXIgY3JlYXRlZCB0aGlzIGV2ZW50XHJcbiAgLy8vIDwvcmV0dXJucz5cclxuICBpc0Zyb21TZXJ2ZXIoKTogYm9vbGVhbiB7XHJcbiAgICByZXR1cm4gdGhpcy5fZnJvbVNlcnZlcjtcclxuICB9XHJcblxyXG4gIC8vLyA8cmV0dXJucz4gYW4gaW5kaWNhdGlvbiB3aGVhdGhlciB0aGUgZXZlbnQgaXMgYSBwYXJ0IG9mIHF1aXQgcHJvY2Vzc1xyXG4gIC8vLyA8L3JldHVybnM+XHJcbiAgaXNRdWl0KCk6IGJvb2xlYW4ge1xyXG4gICAgcmV0dXJuIHRoaXMuX2V2ZW50U3ViVHlwZSA9PT0gRXZlbnRTdWJUeXBlLkNhbmNlbElzUXVpdDtcclxuICB9XHJcblxyXG4gIC8vLyA8c3VtbWFyeT5cclxuICAvLy8gICBJbmRpY2F0ZXMgdGhhdCB3ZSBkbyBub3Qgd2FudCB0aGUgTUdfQUNUX0NBTkNFTCB0byBwZXJmb3JtIHJvbGxiYWNrLlxyXG4gIC8vLyA8L3N1bW1hcnk+XHJcbiAgLy8vIDxyZXR1cm5zPjwvcmV0dXJucz5cclxuICBSb2xsYmFja0luQ2FuY2VsKCk6IGJvb2xlYW4ge1xyXG4gICAgcmV0dXJuIHRoaXMuX2V2ZW50U3ViVHlwZSAhPT0gRXZlbnRTdWJUeXBlLkNhbmNlbFdpdGhOb1JvbGxiYWNrO1xyXG4gIH1cclxuXHJcbiAgLy8vIDxzdW1tYXJ5PlxyXG4gIC8vLyAgd2hpbGUgZXhpdCB0aGUgdGFzayBkdWUgZXJyb3IgKGNhbiBiZSBvbiBhbnkgZXJyb3IgaW4gZGF0YWJhc2UgaW4gbm9uIGludGVyYWN0aXZlKVxyXG4gIC8vLyA8cmV0dXJucz48L3JldHVybnM+XHJcbiAgRXhpdER1ZVRvRXJyb3IoKTogYm9vbGVhbiB7XHJcbiAgICByZXR1cm4gdGhpcy5fZXZlbnRTdWJUeXBlID09PSBFdmVudFN1YlR5cGUuRXhpdER1ZVRvRXJyb3I7XHJcbiAgfVxyXG5cclxuICAvLy8gPHN1bW1hcnk+XHJcbiAgLy8vICAgSW5kaWNhdGVzIHRoYXQgd2UgZG8gbm90IHdhbnQgdGhlIE1HX0FDVF9DQU5DRUwgdG8gcGVyZm9ybSByb2xsYmFjay5cclxuICAvLy8gPC9zdW1tYXJ5PlxyXG4gIC8vLyA8cmV0dXJucz48L3JldHVybnM+XHJcbiAgUnRWaWV3UmVmcmVzaFVzZUN1cnJlbnRSb3coKTogYm9vbGVhbiB7XHJcbiAgICByZXR1cm4gdGhpcy5fZXZlbnRTdWJUeXBlID09PSBFdmVudFN1YlR5cGUuUnRSZWZyZXNoVmlld1VzZUN1cnJlbnRSb3c7XHJcbiAgfVxyXG5cclxuICAvLy8gPHN1bW1hcnk+XHJcbiAgLy8vICAgc2V0cyBzdWIgZXZlbnQgdHlwZSAodXNlIGZvciBjYW5jZWwgJiBydF92aWV3X3JlZnJlc2ggYWN0aW9uKVxyXG4gIC8vLyA8L3N1bW1hcnk+XHJcbiAgU2V0RXZlbnRTdWJUeXBlKGV2ZW50U3ViVHlwZTogRXZlbnRTdWJUeXBlKTogdm9pZCB7XHJcbiAgICB0aGlzLl9ldmVudFN1YlR5cGUgPSBldmVudFN1YlR5cGU7XHJcbiAgfVxyXG5cclxuICAvLy8gPHN1bW1hcnk+XHJcbiAgLy8vICAgcmV0dXJuIHRoZSBGaWVsZEJhc2Ugd2hvc2UgY2hhbmdlIHRyaWdnZXJlZCB0aGlzIGV2ZW50XHJcbiAgLy8vIDwvc3VtbWFyeT5cclxuICAvLy8gPHJldHVybnM+cmVmZXJlbmNlIHRvIHRoZSBmaWVsZCB0aGF0IHRyaWdnZXJlZCB0aGUgZXZlbnQ8L3JldHVybnM+XHJcbiAgZ2V0RmxkKCk6IEd1aUZpZWxkQmFzZSB7XHJcbiAgICByZXR1cm4gdGhpcy5fZXZlbnRGbGQ7XHJcbiAgfVxyXG5cclxuICAvLy8gPHN1bW1hcnk+XHJcbiAgLy8vICAgR3VpIEV2ZW50IC0gZXZlbnQgdGhhdCB3ZXJlIGFkZGVkIGJ5IEd1aSBMYXllciwgbGlrZSBjbGljaywgdGltZXIsIGVjdFxyXG4gIC8vLyAgIEZvciBhbGwgdGhpcyBldmVudCB0aGUgcHJpb3JpdHkgaXMgbG93XHJcbiAgLy8vIDwvc3VtbWFyeT5cclxuICAvLy8gPHJldHVybnM+IHRydWUgZm9yIEdVSSBFdmVudHMgPC9yZXR1cm5zPlxyXG4gIGlzR3VpVHJpZ2dlcmVkRXZlbnQoKTogYm9vbGVhbiB7XHJcbiAgICByZXR1cm4gdGhpcy5fZ3VpVHJpZ2dlcmVkRXZlbnQ7XHJcbiAgfVxyXG5cclxuICAvLy8gPHN1bW1hcnk+XHJcbiAgLy8vIDwvc3VtbWFyeT5cclxuICAvLy8gPHJldHVybnM+IHByaW9yaXR5IDwvcmV0dXJucz5cclxuICBnZXRQcmlvcml0eSgpOiBQcmlvcml0eSB7XHJcbiAgICByZXR1cm4gdGhpcy5fcHJpb3JpdHk7XHJcbiAgfVxyXG5cclxuICAvLy8gPHN1bW1hcnk+XHJcbiAgLy8vICAgc2V0cyBwcmlvcml0eVxyXG4gIC8vLyA8L3N1bW1hcnk+XHJcbiAgLy8vIDxwYXJhbSBuYW1lID0gXCJwcmlvcml0eVwiPiA8L3BhcmFtPlxyXG4gIHNldFByaW9yaXR5KHByaW9yaXR5OiBQcmlvcml0eSk6IHZvaWQge1xyXG4gICAgdGhpcy5fcHJpb3JpdHkgPSBwcmlvcml0eTtcclxuICB9XHJcblxyXG4gIGlzSWRsZVRpbWVyKCk6IGJvb2xlYW4ge1xyXG4gICAgcmV0dXJuIHRoaXMuX2lzSWRsZVRpbWVyO1xyXG4gIH1cclxuXHJcbiAgZ2V0VmFsdWUoKTogYW55IHtcclxuICAgIHJldHVybiB0aGlzLl92YWw7XHJcbiAgfVxyXG5cclxuICBzZXRWYWx1ZSh2YWw6IGFueSk6IHZvaWQge1xyXG4gICAgdGhpcy5fdmFsID0gdmFsO1xyXG4gIH1cclxuXHJcblxyXG4gIGdldFN0YXJ0U2VsZWN0aW9uKCk6IG51bWJlciB7XHJcbiAgICByZXR1cm4gdGhpcy5fc2VsZWN0aW9uU3RhcnQ7XHJcbiAgfVxyXG5cclxuICBnZXRFbmRTZWxlY3Rpb24oKTogbnVtYmVyIHtcclxuICAgIHJldHVybiB0aGlzLl9zZWxlY3Rpb25FbmQ7XHJcbiAgfVxyXG5cclxuICAvLy8gPHN1bW1hcnk+XHJcbiAgLy8vICAgc2V0cyBzZXRFZGl0UGFybXNcclxuICAvLy8gPC9zdW1tYXJ5PlxyXG4gIC8vLyA8cGFyYW0gbmFtZSA9IFwic3RhcnRcIj5zdGFydCBzZWxlY3Rpb248L3BhcmFtPlxyXG4gIC8vLyA8cGFyYW0gbmFtZSA9IFwiZW5kXCI+ZW5kIHNlbGVjdGlvbjwvcGFyYW0+XHJcbiAgLy8vIDxwYXJhbSBuYW1lID0gXCJ0ZXh0XCI+dGhlIHRleHQgYmVpbmcgd3JpdHRlbjwvcGFyYW0+XHJcbiAgc2V0RWRpdFBhcm1zKHN0YXJ0OiBudW1iZXIsIGVuZDogbnVtYmVyLCB0ZXh0OiBzdHJpbmcpOiB2b2lkIHtcclxuICAgIHRoaXMuX3NlbGVjdGlvblN0YXJ0ID0gc3RhcnQ7XHJcbiAgICB0aGlzLl9zZWxlY3Rpb25FbmQgPSBlbmQ7XHJcbiAgICB0aGlzLnNldFZhbHVlKHRleHQpO1xyXG4gIH1cclxuXHJcbiAgLy8vIDxzdW1tYXJ5PlxyXG4gIC8vLyAgIHJldHVybnMgdHJ1ZSBmb3IgcHJvZHVjZUNsaWNrIGZsYWdcclxuICAvLy8gPC9zdW1tYXJ5PlxyXG4gIC8vLyA8cmV0dXJucz48L3JldHVybnM+XHJcbiAgaXNQcm9kdWNlQ2xpY2soKTogYm9vbGVhbiB7XHJcbiAgICByZXR1cm4gdGhpcy5fcHJvZHVjZUNsaWNrO1xyXG4gIH1cclxuXHJcbiAgLy8vIDxzdW1tYXJ5PlxyXG4gIC8vLyAgIHNldCBwcm9kdWNlIGNsaWNrXHJcbiAgLy8vIDwvc3VtbWFyeT5cclxuICAvLy8gPHBhcmFtIG5hbWUgPSBcInByb2R1Y2VDbGlja1wiPjwvcGFyYW0+XHJcbiAgc2V0UHJvZHVjZUNsaWNrKHByb2R1Y2VDbGljazogYm9vbGVhbik6IHZvaWQge1xyXG4gICAgdGhpcy5fcHJvZHVjZUNsaWNrID0gcHJvZHVjZUNsaWNrO1xyXG4gIH1cclxuXHJcblxyXG4gIC8vLyA8c3VtbWFyeT5cclxuICAvLy8gICBnZXQgdGhlIGFjdGlvbiBsaXN0IHRvIGVuYWJsZS9kaXNhYmxlXHJcbiAgLy8vIDwvc3VtbWFyeT5cclxuICAvLy8gPHJldHVybnM+PC9yZXR1cm5zPlxyXG4gIGdldEFjdEVuYWJsZUxpc3QoKTogbnVtYmVyW10ge1xyXG4gICAgcmV0dXJuIHRoaXMuX2FjdEVuYWJsZUxpc3Q7XHJcbiAgfVxyXG5cclxuICAvLy8gPHN1bW1hcnk+XHJcbiAgLy8vICAgcmV0dXJuIHNlbmQgYWxsIGZsYWdcclxuICAvLy8gPC9zdW1tYXJ5PlxyXG4gIC8vLyA8cmV0dXJucz48L3JldHVybnM+XHJcbiAgaXNTZW5kQWxsKCk6IGJvb2xlYW4ge1xyXG4gICAgcmV0dXJuIHRoaXMuX3NlbmRBbGw7XHJcbiAgfVxyXG5cclxuICAvLy8gPHN1bW1hcnk+XHJcbiAgLy8vICAgc2V0IHNlbmRhbGwgZmxhZ1xyXG4gIC8vLyA8L3N1bW1hcnk+XHJcbiAgLy8vIDxwYXJhbSBuYW1lID0gXCJzZW5kQWxsXCI+IDwvcGFyYW0+XHJcbiAgc2V0U2VuZEFsbChzZW5kQWxsOiBib29sZWFuKTogdm9pZCB7XHJcbiAgICB0aGlzLl9zZW5kQWxsID0gc2VuZEFsbDtcclxuICB9XHJcblxyXG4gIC8vLyA8c3VtbWFyeT5cclxuICAvLy8gICBDaGVjayBpZiB0aGlzIGV2ZW50IGlzIGJsb2NrZWQgYnkgdGhlIGN1cnJlbnRseSBhY3RpdmUgd2luZG93LiBJZiB0aGVcclxuICAvLy8gICBjdXJyZW50IHdpbmRvdyBpcyBtb2RhbCwgYW5kIHRoZSBldmVudCBkZWZpbmVkIGluIG9uZSBvZiBpdHMgYW5jZXN0b3JzLFxyXG4gIC8vLyAgIHRoZSBldmVudCBzaG91bGQgbm90IGJlIGV4ZWN1dGVkLlxyXG4gIC8vLyA8L3N1bW1hcnk+XHJcbiAgLy8vIDxwYXJhbSBuYW1lID0gXCJhY3RpdmVXaW5kb3dEYXRhXCI+VGhlIE1HRGF0YSBvYmplY3QgZGVzY3JpYmluZyB0aGUgY3VycmVudGx5IGFjdGl2ZSB3aW5kb3cuPC9wYXJhbT5cclxuICAvLy8gPHJldHVybnM+XHJcbiAgLy8vICAgVGhlIG1ldGhvZCByZXR1cm5zIHRydWUgaWYgdGhlIGN1cnJlbnRseSBhY3RpdmUgd2luZG93IGlzIG1vZGFsIGlzIGFcclxuICAvLy8gICBkZXNjZW5kYW50IG9mIHRoZSBldmVudCdzIHRhc2suIE90aGVyd2lzZSBpdCByZXR1cm5zIGZhbHNlLlxyXG4gIC8vLyA8L3JldHVybnM+XHJcbiAgcHVibGljIGlzQmxvY2tlZEJ5TW9kYWxXaW5kb3coYWN0aXZlV2luZG93RGF0YTogTUdEYXRhKTogYm9vbGVhbiB7XHJcbiAgICBpZiAoYWN0aXZlV2luZG93RGF0YS5Jc01vZGFsKSB7XHJcbiAgICAgIC8vIENoZWNrIHRoYXQgdGhlIGV2ZW50J3MgdGFzayBpcyBhbiBhbmNlc3RvciBvZiB0aGUgYWN0aXZlIHdpbmRvdydzIHRhc2suXHJcbiAgICAgIGxldCBldmVudFRhc2s6IFRhc2tCYXNlID0gdGhpcy5nZXRUYXNrKCk7XHJcbiAgICAgIGxldCBiYXNlVGFzazogVGFza0Jhc2UgPSBhY3RpdmVXaW5kb3dEYXRhLmdldFRhc2soMCk7XHJcbiAgICAgIGlmIChldmVudFRhc2sgIT09IGJhc2VUYXNrICYmIGJhc2VUYXNrLmlzRGVzY2VuZGVudE9mKGV2ZW50VGFzaykpXHJcbiAgICAgICAgcmV0dXJuIHRydWU7XHJcbiAgICB9XHJcbiAgICByZXR1cm4gZmFsc2U7XHJcbiAgfVxyXG5cclxuICB0b1N0cmluZygpOiBzdHJpbmcge1xyXG4gICAgcmV0dXJuIE5TdHJpbmcuRm9ybWF0KFwie3tSVEV2ZW50IHswfSAoezF9KSwgdHlwZSB7Mn17M319fVwiLCBbXHJcbiAgICAgIHRoaXMuZ2V0QnJrTGV2ZWwoKSwgdGhpcy5JbnRlcm5hbEV2ZW50LCB0aGlzLl90eXBlLCAodGhpcy5fdGFzayA9PT0gbnVsbCkgPyBcIlwiIDogKFwiIG9uIFwiICsgdGhpcy5fdGFzaylcclxuICAgIF0pO1xyXG4gIH1cclxufVxyXG4iXX0=