import { List } from '@magic-xpa/mscorelib';
import { Logger, XMLConstants } from '@magic-xpa/utils';
import { Event } from './Event';
import { ConstInterface } from '../ConstInterface';
export class UserEventsTable {
    constructor() {
        this._userEventsTab = null;
        this._userEventsTab = new List();
    }
    fillData(tsk, parser) {
        while (this.initInnerObjects(parser, parser.getNextTag(), tsk)) {
        }
    }
    initInnerObjects(parser, foundTagName, tsk) {
        if (foundTagName === null)
            return false;
        switch (foundTagName) {
            case ConstInterface.MG_TAG_EVENT: {
                let evt = new Event();
                evt.fillData(parser, tsk);
                this._userEventsTab.push(evt);
                break;
            }
            case ConstInterface.MG_TAG_USER_EVENTS:
                parser.setCurrIndex(parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex()) + 1);
                break;
            case ConstInterface.MG_TAG_USER_EVENTS_END:
                parser.setCurrIndex2EndOfTag();
                return false;
            default:
                Logger.Instance.WriteExceptionToLogWithMsg("There is no such tag in UserEventsTable.initInnerObjects : " + foundTagName);
                return false;
        }
        return true;
    }
    getEvent(idx) {
        if (idx < 0 || this._userEventsTab === null || idx >= this._userEventsTab.length)
            return null;
        return this._userEventsTab.get_Item(idx);
    }
    getSize() {
        if (this._userEventsTab === null)
            return 0;
        return this._userEventsTab.length;
    }
}
//# sourceMappingURL=data:application/json;base64,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