import { List } from '@magic-xpa/mscorelib';
import { Logger } from '@magic-xpa/utils';
import { Expression } from './Expression';
import { ConstInterface } from '../ConstInterface';
export class ExpTable {
    constructor() {
        this._exps = new List();
    }
    fillData(task, parser) {
        while (this.initInnerObjects(parser, parser.getNextTag(), task)) {
        }
    }
    initInnerObjects(parser, foundTagName, task) {
        if (foundTagName === null)
            return false;
        if (foundTagName === ConstInterface.MG_TAG_EXP) {
            let expression = new Expression();
            expression.fillData(task, parser);
            this._exps.push(expression);
        }
        else if (foundTagName === ConstInterface.MG_TAG_EXPTABLE) {
            parser.setCurrIndex(parser.getXMLdata().indexOf(">", parser.getCurrIndex()) + 1);
        }
        else if (foundTagName === ('/' + ConstInterface.MG_TAG_EXPTABLE)) {
            parser.setCurrIndex2EndOfTag();
            return false;
        }
        else {
            Logger.Instance.WriteExceptionToLogWithMsg("There is no such tag in ExpTable.initInnerObjects(): " + foundTagName);
            return false;
        }
        return true;
    }
    getExpById(id) {
        let exp;
        if (id < 0)
            return null;
        for (let i = 0; i < this._exps.length; i++) {
            exp = this._exps.get_Item(i);
            if (exp.getId() === id)
                return exp;
            exp = null;
        }
        return exp;
    }
    getExp(idx) {
        let exp = null;
        if (idx >= 0 && idx < this._exps.length)
            exp = this._exps.get_Item(idx);
        return exp;
    }
    getSize() {
        let count = 0;
        if (this._exps !== null)
            count = this._exps.length;
        return count;
    }
}
//# sourceMappingURL=data:application/json;base64,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