import { StringBuilder } from "@magic-xpa/mscorelib";
import { StorageAttribute, StrUtil, UtilDateJpn } from "@magic-xpa/utils";
import { Manager } from "@magic-xpa/gui";
export class ExpressionLocalJpn {
    constructor(expressionEvaluator) {
        this._expressionEvaluator = null;
        this._expressionEvaluator = expressionEvaluator;
    }
    eval_op_han(strVal) {
        let strbufZenkaku = new StringBuilder(StrUtil.rtrim(strVal));
        let strbufHankaku = new StringBuilder(0);
        let strRet = null;
        for (let i = 0; i < strbufZenkaku.Length; i = i + 1) {
            let cLetter = strbufZenkaku.get_Item(i);
            if (0xff01 <= cLetter.charCodeAt(0) && cLetter.charCodeAt(0) <= 0xff5e && cLetter.charCodeAt(0) !== 0xff3c && cLetter.charCodeAt(0) !== 0xff40) {
                strbufHankaku.Append(String.fromCharCode(cLetter.charCodeAt(0) - 0xfee0));
            }
            else if (0x309b <= cLetter.charCodeAt(0) && cLetter.charCodeAt(0) <= 0x30f6) {
                strbufHankaku.Append(ExpressionLocalJpn.tableZen2Han[cLetter.charCodeAt(0) - 0x309b][0]);
                if (ExpressionLocalJpn.tableZen2Han[cLetter.charCodeAt(0) - 0x309b][1].charCodeAt(0) > 0x0000) {
                    strbufHankaku.Append(ExpressionLocalJpn.tableZen2Han[cLetter.charCodeAt(0) - 0x309b][1]);
                }
            }
            else {
                let j;
                for (j = 0; j < ExpressionLocalJpn.tableExceptZen2Han.length; j++) {
                    if (cLetter === ExpressionLocalJpn.tableExceptZen2Han[j][0]) {
                        strbufHankaku.Append(ExpressionLocalJpn.tableExceptZen2Han[j][1]);
                        break;
                    }
                }
                if (j === ExpressionLocalJpn.tableExceptZen2Han.length)
                    strbufHankaku.Append(cLetter);
            }
        }
        strRet = strbufHankaku.ToString();
        strbufZenkaku = null;
        strbufHankaku = null;
        return strRet;
    }
    eval_op_zens(strVal, mode) {
        let strbufHankaku = new StringBuilder(StrUtil.rtrim(strVal));
        let strbufZenkaku = new StringBuilder(0);
        let strRet = null;
        for (let i = 0; i < strbufHankaku.Length; i = i + 1) {
            let cLetter = strbufHankaku.get_Item(i);
            if (0x0020 <= cLetter.charCodeAt(0) && cLetter.charCodeAt(0) <= 0x007e) {
                switch (cLetter) {
                    case String.fromCharCode(0x0020):
                        if (mode === 1) {
                            strbufZenkaku.Append(String.fromCharCode(0x3000));
                        }
                        else if (mode === 2) {
                            strbufZenkaku.Append(String.fromCharCode(0x0020));
                            strbufZenkaku.Append(String.fromCharCode(0x0020));
                        }
                        else {
                            strbufZenkaku.Append(String.fromCharCode(0x0020));
                        }
                        break;
                    case String.fromCharCode(0x0022):
                        strbufZenkaku.Append(String.fromCharCode(0x201d));
                        break;
                    case String.fromCharCode(0x0027):
                        strbufZenkaku.Append(String.fromCharCode(0x2019));
                        break;
                    case String.fromCharCode(0x005c):
                        strbufZenkaku.Append(String.fromCharCode(0xffe5));
                        break;
                    case String.fromCharCode(0x0060):
                        strbufZenkaku.Append(String.fromCharCode(0x2018));
                        break;
                    default:
                        strbufZenkaku.Append(String.fromCharCode(cLetter.charCodeAt(0) + 0xfee0));
                        break;
                }
            }
            else if (0xff61 <= cLetter.charCodeAt(0) && cLetter.charCodeAt(0) <= 0xff9f) {
                let cCombine = String.fromCharCode(0x0000);
                if ((i + 1) < strbufHankaku.Length) {
                    cCombine = strbufHankaku.get_Item(i + 1);
                    if (cCombine.charCodeAt(0) !== 0xff9e && cCombine.charCodeAt(0) !== 0xff9f)
                        cCombine = String.fromCharCode(0x0000);
                }
                if (cCombine.charCodeAt(0) === 0xff9e) {
                    if (0xff76 <= cLetter.charCodeAt(0) && cLetter.charCodeAt(0) <= 0xff84 || 0xff8a <= cLetter.charCodeAt(0) && cLetter.charCodeAt(0) <= 0xff8e)
                        strbufZenkaku.Append((ExpressionLocalJpn.tableHan2Zen[cLetter.charCodeAt(0) - 0xff61] + 0x001));
                    else if (cLetter.charCodeAt(0) === 0xff73)
                        strbufZenkaku.Append(String.fromCharCode(0x30f4));
                    else
                        cCombine = String.fromCharCode(0x0000);
                }
                else if (cCombine.charCodeAt(0) === 0xff9f) {
                    if (0xff8a <= cLetter.charCodeAt(0) && cLetter.charCodeAt(0) <= 0xff8e)
                        strbufZenkaku.Append((ExpressionLocalJpn.tableHan2Zen[cLetter.charCodeAt(0) - 0xff61] + 0x002));
                    else
                        cCombine = String.fromCharCode(0x0000);
                }
                if (cCombine.charCodeAt(0) !== 0x0000)
                    i++;
                else
                    strbufZenkaku.Append(ExpressionLocalJpn.tableHan2Zen[cLetter.charCodeAt(0) - 0xff61]);
            }
            else {
                strbufZenkaku.Append(cLetter);
            }
        }
        strRet = strbufZenkaku.ToString();
        strbufHankaku = null;
        strbufZenkaku = null;
        return strRet;
    }
    eval_op_zimeread() {
        let strRet = null;
        let utilImeJpn = Manager.UtilImeJpn;
        if (utilImeJpn !== null)
            strRet = utilImeJpn.StrImeRead;
        return strRet;
    }
    eval_op_zkana(strVal, mode) {
        let strbufConverted = new StringBuilder(StrUtil.rtrim(strVal));
        let strRet = null;
        for (let i = 0; i < strbufConverted.Length; i = i + 1) {
            let cLetter = strbufConverted.get_Item(i);
            if (mode === 0) {
                if (0x3041 <= cLetter.charCodeAt(0) && cLetter.charCodeAt(0) <= 0x3093)
                    strbufConverted.set_Item(i, String.fromCharCode(cLetter.charCodeAt(0) + 0x0060));
            }
            else {
                if (0x30A1 <= cLetter.charCodeAt(0) && cLetter.charCodeAt(0) <= 0x30f3)
                    strbufConverted.set_Item(i, String.fromCharCode(cLetter.charCodeAt(0) - 0x0060));
            }
        }
        strRet = strbufConverted.ToString();
        strbufConverted = null;
        return strRet;
    }
    eval_op_jcdow(resVal, val1, displayConvertor) {
        this._expressionEvaluator.eval_op_date_str(resVal, val1, "SSSSSST", displayConvertor);
    }
    eval_op_jmonth(resVal, val1) {
        if (val1.MgNumVal === null) {
            this._expressionEvaluator.SetNULL(resVal, StorageAttribute.ALPHA);
            return;
        }
        val1.MgNumVal = this._expressionEvaluator.mul_add(val1.MgNumVal, 31, -30);
        this._expressionEvaluator.eval_op_month(resVal, val1);
        let month = resVal.MgNumVal.NUM_2_LONG();
        resVal.Attr = StorageAttribute.ALPHA;
        resVal.StrVal = UtilDateJpn.convertStrMonth(month);
    }
    eval_op_jndow(resVal, val1, displayConvertor) {
        if (val1.MgNumVal === null) {
            this._expressionEvaluator.SetNULL(resVal, StorageAttribute.ALPHA);
            return;
        }
        val1.MgNumVal = this._expressionEvaluator.mul_add(val1.MgNumVal, 0, 6);
        this.eval_op_jcdow(resVal, val1.MgNumVal, displayConvertor);
    }
    eval_op_jyear(resVal, val1) {
        this._expressionEvaluator.eval_op_date_brk(resVal, val1.MgNumVal, 4);
    }
    eval_op_jgengo(resVal, val1, val2, displayConvertor) {
        let strFormat;
        resVal.Attr = StorageAttribute.ALPHA;
        if (val1 === null || val2 === null) {
            this._expressionEvaluator.SetNULL(resVal, StorageAttribute.ALPHA);
            return;
        }
        let intType = val2.NUM_2_LONG();
        if (intType >= 4)
            strFormat = "JJJJ";
        else if (intType >= 2)
            strFormat = "JJ";
        else if (intType >= 1)
            strFormat = "J";
        else {
            resVal.StrVal = "";
            return;
        }
        this._expressionEvaluator.eval_op_date_str(resVal, val1, strFormat, displayConvertor);
    }
}
ExpressionLocalJpn.tableZen2Han = [
    [String.fromCharCode(0xff9e), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff9f), String.fromCharCode(0x0000)],
    [String.fromCharCode(0x309d), String.fromCharCode(0x0000)],
    [String.fromCharCode(0x309e), String.fromCharCode(0x0000)],
    [String.fromCharCode(0x309f), String.fromCharCode(0x0000)],
    [String.fromCharCode(0x30a0), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff67), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff71), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff68), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff72), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff69), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff73), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff6a), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff74), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff6b), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff75), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff76), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff76), String.fromCharCode(0xff9e)],
    [String.fromCharCode(0xff77), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff77), String.fromCharCode(0xff9e)],
    [String.fromCharCode(0xff78), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff78), String.fromCharCode(0xff9e)],
    [String.fromCharCode(0xff79), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff79), String.fromCharCode(0xff9e)],
    [String.fromCharCode(0xff7a), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff7a), String.fromCharCode(0xff9e)],
    [String.fromCharCode(0xff7b), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff7b), String.fromCharCode(0xff9e)],
    [String.fromCharCode(0xff7c), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff7c), String.fromCharCode(0xff9e)],
    [String.fromCharCode(0xff7d), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff7d), String.fromCharCode(0xff9e)],
    [String.fromCharCode(0xff7e), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff7e), String.fromCharCode(0xff9e)],
    [String.fromCharCode(0xff7f), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff7f), String.fromCharCode(0xff9e)],
    [String.fromCharCode(0xff80), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff80), String.fromCharCode(0xff9e)],
    [String.fromCharCode(0xff81), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff81), String.fromCharCode(0xff9e)],
    [String.fromCharCode(0xff6f), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff82), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff82), String.fromCharCode(0xff9e)],
    [String.fromCharCode(0xff83), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff83), String.fromCharCode(0xff9e)],
    [String.fromCharCode(0xff84), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff84), String.fromCharCode(0xff9e)],
    [String.fromCharCode(0xff85), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff86), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff87), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff88), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff89), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff8a), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff8a), String.fromCharCode(0xff9e)],
    [String.fromCharCode(0xff8a), String.fromCharCode(0xff9f)],
    [String.fromCharCode(0xff8b), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff8b), String.fromCharCode(0xff9e)],
    [String.fromCharCode(0xff8b), String.fromCharCode(0xff9f)],
    [String.fromCharCode(0xff8c), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff8c), String.fromCharCode(0xff9e)],
    [String.fromCharCode(0xff8c), String.fromCharCode(0xff9f)],
    [String.fromCharCode(0xff8d), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff8d), String.fromCharCode(0xff9e)],
    [String.fromCharCode(0xff8d), String.fromCharCode(0xff9f)],
    [String.fromCharCode(0xff8e), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff8e), String.fromCharCode(0xff9e)],
    [String.fromCharCode(0xff8e), String.fromCharCode(0xff9f)],
    [String.fromCharCode(0xff8f), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff90), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff91), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff92), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff93), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff6c), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff94), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff6d), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff95), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff6e), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff96), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff97), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff98), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff99), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff9a), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff9b), String.fromCharCode(0x0000)],
    [String.fromCharCode(0x30ee), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff9c), String.fromCharCode(0x0000)],
    [String.fromCharCode(0x30f0), String.fromCharCode(0x0000)],
    [String.fromCharCode(0x30f1), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff66), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff9d), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff73), String.fromCharCode(0xff9e)],
    [String.fromCharCode(0xff76), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff79), String.fromCharCode(0x0000)]
];
ExpressionLocalJpn.tableExceptZen2Han = [
    [String.fromCharCode(0x2018), String.fromCharCode(0x0060)],
    [String.fromCharCode(0x2019), String.fromCharCode(0x0027)],
    [String.fromCharCode(0x201D), String.fromCharCode(0x0022)],
    [String.fromCharCode(0x3000), String.fromCharCode(0x0020)],
    [String.fromCharCode(0x3001), String.fromCharCode(0xFF64)],
    [String.fromCharCode(0x3002), String.fromCharCode(0xFF61)],
    [String.fromCharCode(0x300C), String.fromCharCode(0xFF62)],
    [String.fromCharCode(0x300D), String.fromCharCode(0xFF63)],
    [String.fromCharCode(0x30FB), String.fromCharCode(0xFF65)],
    [String.fromCharCode(0x30FC), String.fromCharCode(0xFF70)],
    [String.fromCharCode(0xFFE5), String.fromCharCode(0x005C)]
];
ExpressionLocalJpn.tableHan2Zen = [
    String.fromCharCode(0x3002), String.fromCharCode(0x300c), String.fromCharCode(0x300d),
    String.fromCharCode(0x3001), String.fromCharCode(0x30fb), String.fromCharCode(0x30f2),
    String.fromCharCode(0x30a1), String.fromCharCode(0x30a3), String.fromCharCode(0x30a5),
    String.fromCharCode(0x30a7), String.fromCharCode(0x30a9), String.fromCharCode(0x30e3),
    String.fromCharCode(0x30e5), String.fromCharCode(0x30e7), String.fromCharCode(0x30c3),
    String.fromCharCode(0x30fc), String.fromCharCode(0x30a2), String.fromCharCode(0x30a4),
    String.fromCharCode(0x30a6), String.fromCharCode(0x30a8), String.fromCharCode(0x30aa),
    String.fromCharCode(0x30ab), String.fromCharCode(0x30ad), String.fromCharCode(0x30af),
    String.fromCharCode(0x30b1), String.fromCharCode(0x30b3), String.fromCharCode(0x30b5),
    String.fromCharCode(0x30b7), String.fromCharCode(0x30b9), String.fromCharCode(0x30bb),
    String.fromCharCode(0x30bd), String.fromCharCode(0x30bf), String.fromCharCode(0x30c1),
    String.fromCharCode(0x30c4), String.fromCharCode(0x30c6), String.fromCharCode(0x30c8),
    String.fromCharCode(0x30ca), String.fromCharCode(0x30cb), String.fromCharCode(0x30cc),
    String.fromCharCode(0x30cd), String.fromCharCode(0x30ce), String.fromCharCode(0x30cf),
    String.fromCharCode(0x30d2), String.fromCharCode(0x30d5), String.fromCharCode(0x30d8),
    String.fromCharCode(0x30db), String.fromCharCode(0x30de), String.fromCharCode(0x30df),
    String.fromCharCode(0x30e0), String.fromCharCode(0x30e1), String.fromCharCode(0x30e2),
    String.fromCharCode(0x30e4), String.fromCharCode(0x30e6), String.fromCharCode(0x30e8),
    String.fromCharCode(0x30e9), String.fromCharCode(0x30ea), String.fromCharCode(0x30eb),
    String.fromCharCode(0x30ec), String.fromCharCode(0x30ed), String.fromCharCode(0x30ef),
    String.fromCharCode(0x30f3), String.fromCharCode(0x309b), String.fromCharCode(0x309c)
];
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiRXhwcmVzc2lvbkxvY2FsSnBuLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvZW5naW5lL3NyYy9leHAvRXhwcmVzc2lvbkxvY2FsSnBuLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBQyxhQUFhLEVBQUMsTUFBTSxzQkFBc0IsQ0FBQztBQUNuRCxPQUFPLEVBQUMsZ0JBQWdCLEVBQUUsT0FBTyxFQUFFLFdBQVcsRUFBYSxNQUFNLGtCQUFrQixDQUFDO0FBQ3BGLE9BQU8sRUFBMkIsT0FBTyxFQUFXLE1BQU0sZ0JBQWdCLENBQUM7QUFRM0UsTUFBTSxPQUFPLGtCQUFrQjtJQTZKN0IsWUFBWSxtQkFBd0M7UUFGNUMseUJBQW9CLEdBQXdCLElBQUksQ0FBQztRQUd2RCxJQUFJLENBQUMsb0JBQW9CLEdBQUcsbUJBQW1CLENBQUM7SUFDbEQsQ0FBQztJQVNELFdBQVcsQ0FBQyxNQUFjO1FBQ3hCLElBQUksYUFBYSxHQUFrQixJQUFJLGFBQWEsQ0FBQyxPQUFPLENBQUMsS0FBSyxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUM7UUFDNUUsSUFBSSxhQUFhLEdBQWtCLElBQUksYUFBYSxDQUFDLENBQUMsQ0FBQyxDQUFDO1FBQ3hELElBQUksTUFBTSxHQUFXLElBQUksQ0FBQztRQUUxQixLQUFLLElBQUksQ0FBQyxHQUFXLENBQUMsRUFBRSxDQUFDLEdBQUcsYUFBYSxDQUFDLE1BQU0sRUFBRSxDQUFDLEdBQUcsQ0FBQyxHQUFHLENBQUMsRUFBRTtZQUMzRCxJQUFJLE9BQU8sR0FBVyxhQUFhLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQyxDQUFDO1lBR2hELElBQUksTUFBTSxJQUFJLE9BQU8sQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLElBQUksT0FBTyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsSUFBSSxNQUFNLElBQUksT0FBTyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsS0FBSyxNQUFNLElBQUksT0FBTyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsS0FBSyxNQUFNLEVBQUU7Z0JBQzlJLGFBQWEsQ0FBQyxNQUFNLENBQUMsTUFBTSxDQUFDLFlBQVksQ0FBQyxPQUFPLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxHQUFHLE1BQU0sQ0FBQyxDQUFDLENBQUM7YUFDM0U7aUJBRUksSUFBSSxNQUFNLElBQUksT0FBTyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsSUFBSSxPQUFPLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxJQUFJLE1BQU0sRUFBRTtnQkFDM0UsYUFBYSxDQUFDLE1BQU0sQ0FBQyxrQkFBa0IsQ0FBQyxZQUFZLENBQUMsT0FBTyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsR0FBRyxNQUFNLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO2dCQUV6RixJQUFJLGtCQUFrQixDQUFDLFlBQVksQ0FBQyxPQUFPLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxHQUFHLE1BQU0sQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsR0FBRyxNQUFNLEVBQUU7b0JBQzdGLGFBQWEsQ0FBQyxNQUFNLENBQUMsa0JBQWtCLENBQUMsWUFBWSxDQUFDLE9BQU8sQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLEdBQUcsTUFBTSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztpQkFDMUY7YUFDRjtpQkFFSTtnQkFDSCxJQUFJLENBQVMsQ0FBQztnQkFDZCxLQUFLLENBQUMsR0FBRyxDQUFDLEVBQUUsQ0FBQyxHQUFHLGtCQUFrQixDQUFDLGtCQUFrQixDQUFDLE1BQU0sRUFBRSxDQUFDLEVBQUUsRUFBRTtvQkFDakUsSUFBSSxPQUFPLEtBQUssa0JBQWtCLENBQUMsa0JBQWtCLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUU7d0JBQzNELGFBQWEsQ0FBQyxNQUFNLENBQUMsa0JBQWtCLENBQUMsa0JBQWtCLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQzt3QkFDbEUsTUFBTTtxQkFDUDtpQkFDRjtnQkFDRCxJQUFJLENBQUMsS0FBSyxrQkFBa0IsQ0FBQyxrQkFBa0IsQ0FBQyxNQUFNO29CQUNwRCxhQUFhLENBQUMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxDQUFDO2FBQ2pDO1NBQ0Y7UUFFRCxNQUFNLEdBQUcsYUFBYSxDQUFDLFFBQVEsRUFBRSxDQUFDO1FBRWxDLGFBQWEsR0FBRyxJQUFJLENBQUM7UUFDckIsYUFBYSxHQUFHLElBQUksQ0FBQztRQUVyQixPQUFPLE1BQU0sQ0FBQztJQUNoQixDQUFDO0lBY0QsWUFBWSxDQUFDLE1BQWMsRUFBRSxJQUFZO1FBQ3ZDLElBQUksYUFBYSxHQUFrQixJQUFJLGFBQWEsQ0FBQyxPQUFPLENBQUMsS0FBSyxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUM7UUFDNUUsSUFBSSxhQUFhLEdBQWtCLElBQUksYUFBYSxDQUFDLENBQUMsQ0FBQyxDQUFDO1FBQ3hELElBQUksTUFBTSxHQUFXLElBQUksQ0FBQztRQUUxQixLQUFLLElBQUksQ0FBQyxHQUFXLENBQUMsRUFBRSxDQUFDLEdBQUcsYUFBYSxDQUFDLE1BQU0sRUFBRSxDQUFDLEdBQUcsQ0FBQyxHQUFHLENBQUMsRUFBRTtZQUMzRCxJQUFJLE9BQU8sR0FBVyxhQUFhLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQyxDQUFDO1lBR2hELElBQUksTUFBTSxJQUFJLE9BQU8sQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLElBQUksT0FBTyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsSUFBSSxNQUFNLEVBQUU7Z0JBRXRFLFFBQVEsT0FBTyxFQUFFO29CQUNmLEtBQUssTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUM7d0JBQzlCLElBQUksSUFBSSxLQUFLLENBQUMsRUFBRTs0QkFDZCxhQUFhLENBQUMsTUFBTSxDQUFDLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQzt5QkFDbkQ7NkJBQ0ksSUFBSSxJQUFJLEtBQUssQ0FBQyxFQUFFOzRCQUNuQixhQUFhLENBQUMsTUFBTSxDQUFDLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQzs0QkFDbEQsYUFBYSxDQUFDLE1BQU0sQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUM7eUJBQ25EOzZCQUVJOzRCQUNILGFBQWEsQ0FBQyxNQUFNLENBQUMsTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDO3lCQUNuRDt3QkFDRCxNQUFNO29CQUdSLEtBQUssTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUM7d0JBQzlCLGFBQWEsQ0FBQyxNQUFNLENBQUMsTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDO3dCQUNsRCxNQUFNO29CQUdSLEtBQUssTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUM7d0JBQzlCLGFBQWEsQ0FBQyxNQUFNLENBQUMsTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDO3dCQUNsRCxNQUFNO29CQUdSLEtBQUssTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUM7d0JBQzlCLGFBQWEsQ0FBQyxNQUFNLENBQUMsTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDO3dCQUNsRCxNQUFNO29CQUdSLEtBQUssTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUM7d0JBQzlCLGFBQWEsQ0FBQyxNQUFNLENBQUMsTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDO3dCQUNsRCxNQUFNO29CQUdSO3dCQUNFLGFBQWEsQ0FBQyxNQUFNLENBQUMsTUFBTSxDQUFDLFlBQVksQ0FBQyxPQUFPLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxHQUFHLE1BQU0sQ0FBQyxDQUFDLENBQUM7d0JBQzFFLE1BQU07aUJBQ1Q7YUFDRjtpQkFFSSxJQUFJLE1BQU0sSUFBSSxPQUFPLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxJQUFJLE9BQU8sQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLElBQUksTUFBTSxFQUFFO2dCQUMzRSxJQUFJLFFBQVEsR0FBVyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxDQUFDO2dCQUVuRCxJQUFJLENBQUMsQ0FBQyxHQUFHLENBQUMsQ0FBQyxHQUFHLGFBQWEsQ0FBQyxNQUFNLEVBQUU7b0JBRWxDLFFBQVEsR0FBRyxhQUFhLENBQUMsUUFBUSxDQUFDLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQztvQkFDekMsSUFBSSxRQUFRLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxLQUFLLE1BQU0sSUFBSSxRQUFRLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxLQUFLLE1BQU07d0JBQ3hFLFFBQVEsR0FBRyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxDQUFDO2lCQUMxQztnQkFFRCxJQUFJLFFBQVEsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLEtBQUssTUFBTSxFQUVyQztvQkFDRSxJQUFJLE1BQU0sSUFBSSxPQUFPLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxJQUFJLE9BQU8sQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLElBQUksTUFBTSxJQUFJLE1BQU0sSUFBSSxPQUFPLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxJQUFJLE9BQU8sQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLElBQUksTUFBTTt3QkFDMUksYUFBYSxDQUFDLE1BQU0sQ0FBQyxDQUFDLGtCQUFrQixDQUFDLFlBQVksQ0FBQyxPQUFPLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxHQUFHLE1BQU0sQ0FBQyxHQUFHLEtBQUssQ0FBQyxDQUFDLENBQUM7eUJBQzdGLElBQUksT0FBTyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsS0FBSyxNQUFNO3dCQUN2QyxhQUFhLENBQUMsTUFBTSxDQUFDLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQzs7d0JBRWxELFFBQVEsR0FBRyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxDQUFDO2lCQUMxQztxQkFDSSxJQUFJLFFBQVEsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLEtBQUssTUFBTSxFQUUxQztvQkFDRSxJQUFJLE1BQU0sSUFBSSxPQUFPLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxJQUFJLE9BQU8sQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLElBQUksTUFBTTt3QkFDcEUsYUFBYSxDQUFDLE1BQU0sQ0FBQyxDQUFDLGtCQUFrQixDQUFDLFlBQVksQ0FBQyxPQUFPLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxHQUFHLE1BQU0sQ0FBQyxHQUFHLEtBQUssQ0FBQyxDQUFDLENBQUM7O3dCQUVoRyxRQUFRLEdBQUcsTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsQ0FBQztpQkFDMUM7Z0JBRUQsSUFBSSxRQUFRLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxLQUFLLE1BQU07b0JBQ25DLENBQUMsRUFBRSxDQUFDOztvQkFFSixhQUFhLENBQUMsTUFBTSxDQUFDLGtCQUFrQixDQUFDLFlBQVksQ0FBQyxPQUFPLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxHQUFHLE1BQU0sQ0FBQyxDQUFDLENBQUM7YUFDekY7aUJBRUk7Z0JBQ0gsYUFBYSxDQUFDLE1BQU0sQ0FBQyxPQUFPLENBQUMsQ0FBQzthQUMvQjtTQUNGO1FBRUQsTUFBTSxHQUFHLGFBQWEsQ0FBQyxRQUFRLEVBQUUsQ0FBQztRQUVsQyxhQUFhLEdBQUcsSUFBSSxDQUFDO1FBQ3JCLGFBQWEsR0FBRyxJQUFJLENBQUM7UUFFckIsT0FBTyxNQUFNLENBQUM7SUFDaEIsQ0FBQztJQUtELGdCQUFnQjtRQUNkLElBQUksTUFBTSxHQUFXLElBQUksQ0FBQztRQUMxQixJQUFJLFVBQVUsR0FBZSxPQUFPLENBQUMsVUFBVSxDQUFDO1FBRWhELElBQUksVUFBVSxLQUFLLElBQUk7WUFDckIsTUFBTSxHQUFHLFVBQVUsQ0FBQyxVQUFVLENBQUM7UUFFakMsT0FBTyxNQUFNLENBQUM7SUFDaEIsQ0FBQztJQWFELGFBQWEsQ0FBQyxNQUFjLEVBQUUsSUFBWTtRQUN4QyxJQUFJLGVBQWUsR0FBa0IsSUFBSSxhQUFhLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDO1FBQzlFLElBQUksTUFBTSxHQUFXLElBQUksQ0FBQztRQUUxQixLQUFLLElBQUksQ0FBQyxHQUFXLENBQUMsRUFBRSxDQUFDLEdBQUcsZUFBZSxDQUFDLE1BQU0sRUFBRSxDQUFDLEdBQUcsQ0FBQyxHQUFHLENBQUMsRUFBRTtZQUM3RCxJQUFJLE9BQU8sR0FBVyxlQUFlLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQyxDQUFDO1lBRWxELElBQUksSUFBSSxLQUFLLENBQUMsRUFBRTtnQkFFZCxJQUFJLE1BQU0sSUFBSSxPQUFPLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxJQUFJLE9BQU8sQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLElBQUksTUFBTTtvQkFDcEUsZUFBZSxDQUFDLFFBQVEsQ0FBQyxDQUFDLEVBQUUsTUFBTSxDQUFDLFlBQVksQ0FBQyxPQUFPLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxHQUFHLE1BQU0sQ0FBQyxDQUFDLENBQUM7YUFDcEY7aUJBRUk7Z0JBQ0gsSUFBSSxNQUFNLElBQUksT0FBTyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsSUFBSSxPQUFPLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxJQUFJLE1BQU07b0JBQ3BFLGVBQWUsQ0FBQyxRQUFRLENBQUMsQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsT0FBTyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsR0FBRyxNQUFNLENBQUMsQ0FBQyxDQUFDO2FBQ3BGO1NBQ0Y7UUFDRCxNQUFNLEdBQUcsZUFBZSxDQUFDLFFBQVEsRUFBRSxDQUFDO1FBQ3BDLGVBQWUsR0FBRyxJQUFJLENBQUM7UUFFdkIsT0FBTyxNQUFNLENBQUM7SUFDaEIsQ0FBQztJQUtELGFBQWEsQ0FBQyxNQUFjLEVBQUUsSUFBYyxFQUFFLGdCQUFrQztRQUM5RSxJQUFJLENBQUMsb0JBQW9CLENBQUMsZ0JBQWdCLENBQUMsTUFBTSxFQUFFLElBQUksRUFBRSxTQUFTLEVBQUUsZ0JBQWdCLENBQUMsQ0FBQztJQUN4RixDQUFDO0lBS0QsY0FBYyxDQUFDLE1BQWMsRUFBRSxJQUFZO1FBQ3pDLElBQUksSUFBSSxDQUFDLFFBQVEsS0FBSyxJQUFJLEVBQUU7WUFDMUIsSUFBSSxDQUFDLG9CQUFvQixDQUFDLE9BQU8sQ0FBQyxNQUFNLEVBQUUsZ0JBQWdCLENBQUMsS0FBSyxDQUFDLENBQUM7WUFDbEUsT0FBTztTQUNSO1FBRUQsSUFBSSxDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUMsb0JBQW9CLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxRQUFRLEVBQUUsRUFBRSxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUM7UUFDMUUsSUFBSSxDQUFDLG9CQUFvQixDQUFDLGFBQWEsQ0FBQyxNQUFNLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDdEQsSUFBSSxLQUFLLEdBQVcsTUFBTSxDQUFDLFFBQVEsQ0FBQyxVQUFVLEVBQUUsQ0FBQztRQUVqRCxNQUFNLENBQUMsSUFBSSxHQUFHLGdCQUFnQixDQUFDLEtBQUssQ0FBQztRQUNyQyxNQUFNLENBQUMsTUFBTSxHQUFHLFdBQVcsQ0FBQyxlQUFlLENBQUMsS0FBSyxDQUFDLENBQUM7SUFDckQsQ0FBQztJQUtELGFBQWEsQ0FBQyxNQUFjLEVBQUUsSUFBWSxFQUFFLGdCQUFrQztRQUM1RSxJQUFJLElBQUksQ0FBQyxRQUFRLEtBQUssSUFBSSxFQUFFO1lBQzFCLElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxPQUFPLENBQUMsTUFBTSxFQUFFLGdCQUFnQixDQUFDLEtBQUssQ0FBQyxDQUFDO1lBQ2xFLE9BQU87U0FDUjtRQUVELElBQUksQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFDLG9CQUFvQixDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsUUFBUSxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQztRQUN2RSxJQUFJLENBQUMsYUFBYSxDQUFDLE1BQU0sRUFBRSxJQUFJLENBQUMsUUFBUSxFQUFFLGdCQUFnQixDQUFDLENBQUM7SUFDOUQsQ0FBQztJQUtELGFBQWEsQ0FBQyxNQUFjLEVBQUUsSUFBWTtRQUN4QyxJQUFJLENBQUMsb0JBQW9CLENBQUMsZ0JBQWdCLENBQUMsTUFBTSxFQUFFLElBQUksQ0FBQyxRQUFRLEVBQUUsQ0FBQyxDQUFDLENBQUM7SUFDdkUsQ0FBQztJQUtELGNBQWMsQ0FBQyxNQUFjLEVBQUUsSUFBYyxFQUFFLElBQWMsRUFBRSxnQkFBa0M7UUFDL0YsSUFBSSxTQUFpQixDQUFDO1FBRXRCLE1BQU0sQ0FBQyxJQUFJLEdBQUcsZ0JBQWdCLENBQUMsS0FBSyxDQUFDO1FBRXJDLElBQUksSUFBSSxLQUFLLElBQUksSUFBSSxJQUFJLEtBQUssSUFBSSxFQUFFO1lBQ2xDLElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxPQUFPLENBQUMsTUFBTSxFQUFFLGdCQUFnQixDQUFDLEtBQUssQ0FBQyxDQUFDO1lBQ2xFLE9BQU87U0FDUjtRQUVELElBQUksT0FBTyxHQUFXLElBQUksQ0FBQyxVQUFVLEVBQUUsQ0FBQztRQUV4QyxJQUFJLE9BQU8sSUFBSSxDQUFDO1lBQ2QsU0FBUyxHQUFHLE1BQU0sQ0FBQzthQUNoQixJQUFJLE9BQU8sSUFBSSxDQUFDO1lBQ25CLFNBQVMsR0FBRyxJQUFJLENBQUM7YUFDZCxJQUFJLE9BQU8sSUFBSSxDQUFDO1lBQ25CLFNBQVMsR0FBRyxHQUFHLENBQUM7YUFDYjtZQUNILE1BQU0sQ0FBQyxNQUFNLEdBQUcsRUFBRSxDQUFDO1lBQ25CLE9BQU87U0FDUjtRQUVELElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxnQkFBZ0IsQ0FBQyxNQUFNLEVBQUUsSUFBSSxFQUFFLFNBQVMsRUFBRSxnQkFBZ0IsQ0FBQyxDQUFDO0lBQ3hGLENBQUM7O0FBemJNLCtCQUFZLEdBQ2pCO0lBQ0UsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDMUQsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7Q0FDM0QsQ0FBQztBQVdHLHFDQUFrQixHQUN2QjtJQUNFLENBQUMsTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsRUFBRSxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQzFELENBQUMsTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsRUFBRSxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQzFELENBQUMsTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsRUFBRSxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQzFELENBQUMsTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsRUFBRSxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQzFELENBQUMsTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsRUFBRSxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQzFELENBQUMsTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsRUFBRSxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQzFELENBQUMsTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsRUFBRSxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQzFELENBQUMsTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsRUFBRSxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQzFELENBQUMsTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsRUFBRSxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQzFELENBQUMsTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsRUFBRSxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQzFELENBQUMsTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsRUFBRSxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxDQUFDO0NBQzNELENBQUM7QUFVRywrQkFBWSxHQUNqQjtJQUNFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLEVBQUUsTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsRUFBRSxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQztJQUNyRixNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLEVBQUUsTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUM7SUFDckYsTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsRUFBRSxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDO0lBQ3JGLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLEVBQUUsTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsRUFBRSxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQztJQUNyRixNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLEVBQUUsTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUM7SUFDckYsTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsRUFBRSxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDO0lBQ3JGLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLEVBQUUsTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsRUFBRSxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQztJQUNyRixNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLEVBQUUsTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUM7SUFDckYsTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsRUFBRSxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDO0lBQ3JGLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLEVBQUUsTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsRUFBRSxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQztJQUNyRixNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLEVBQUUsTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUM7SUFDckYsTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsRUFBRSxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDO0lBQ3JGLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLEVBQUUsTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsRUFBRSxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQztJQUNyRixNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLEVBQUUsTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUM7SUFDckYsTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsRUFBRSxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDO0lBQ3JGLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLEVBQUUsTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsRUFBRSxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQztJQUNyRixNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLEVBQUUsTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUM7SUFDckYsTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsRUFBRSxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDO0lBQ3JGLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLEVBQUUsTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsRUFBRSxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQztJQUNyRixNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLEVBQUUsTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUM7SUFDckYsTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsRUFBRSxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDO0NBQ3RGLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQge1N0cmluZ0J1aWxkZXJ9IGZyb20gXCJAbWFnaWMteHBhL21zY29yZWxpYlwiO1xyXG5pbXBvcnQge1N0b3JhZ2VBdHRyaWJ1dGUsIFN0clV0aWwsIFV0aWxEYXRlSnBuLCBVdGlsSW1lSnBufSBmcm9tIFwiQG1hZ2ljLXhwYS91dGlsc1wiO1xyXG5pbXBvcnQge0Rpc3BsYXlDb252ZXJ0b3IsIEV4cFZhbCwgTWFuYWdlciwgTlVNX1RZUEV9IGZyb20gXCJAbWFnaWMteHBhL2d1aVwiO1xyXG5pbXBvcnQge0V4cHJlc3Npb25FdmFsdWF0b3J9IGZyb20gXCIuL0V4cHJlc3Npb25FdmFsdWF0b3JcIjtcclxuXHJcbi8vLyA8c3VtbWFyeT5cclxuLy8vICAgSlBOOiBDbGFzcyBmb3IgSmFwYW5lc2UgZXh0ZW5kZWQgZnVuY3Rpb25zXHJcbi8vLyA8L3N1bW1hcnk+XHJcbi8vLyA8YXV0aG9yPiAgVG9zaGlybyBOYWtheW9zaGkgKE1TSilcclxuLy8vIDwvYXV0aG9yPlxyXG5leHBvcnQgY2xhc3MgRXhwcmVzc2lvbkxvY2FsSnBuIHtcclxuICBzdGF0aWMgdGFibGVaZW4ySGFuOiBzdHJpbmdbXVtdID1cclxuICAgIFtcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjllKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjlmKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHgzMDlkKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHgzMDllKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHgzMDlmKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHgzMGEwKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjY3KSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjcxKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjY4KSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjcyKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjY5KSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjczKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjZhKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjc0KSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjZiKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjc1KSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjc2KSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjc2KSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweGZmOWUpXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjc3KSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjc3KSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweGZmOWUpXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjc4KSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjc4KSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweGZmOWUpXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjc5KSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjc5KSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweGZmOWUpXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjdhKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjdhKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweGZmOWUpXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjdiKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjdiKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweGZmOWUpXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjdjKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjdjKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweGZmOWUpXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjdkKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjdkKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweGZmOWUpXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjdlKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjdlKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweGZmOWUpXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjdmKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjdmKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweGZmOWUpXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjgwKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjgwKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweGZmOWUpXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjgxKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjgxKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweGZmOWUpXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjZmKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjgyKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjgyKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweGZmOWUpXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjgzKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjgzKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweGZmOWUpXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjg0KSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjg0KSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweGZmOWUpXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjg1KSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjg2KSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjg3KSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjg4KSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjg5KSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjhhKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjhhKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweGZmOWUpXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjhhKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweGZmOWYpXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjhiKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjhiKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweGZmOWUpXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjhiKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweGZmOWYpXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjhjKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjhjKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweGZmOWUpXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjhjKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweGZmOWYpXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjhkKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjhkKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweGZmOWUpXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjhkKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweGZmOWYpXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjhlKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjhlKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweGZmOWUpXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjhlKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweGZmOWYpXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjhmKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjkwKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjkxKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjkyKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjkzKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjZjKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjk0KSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjZkKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjk1KSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjZlKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjk2KSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjk3KSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjk4KSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjk5KSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjlhKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjliKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHgzMGVlKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjljKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHgzMGYwKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHgzMGYxKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjY2KSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjlkKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjczKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweGZmOWUpXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjc2KSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXSxcclxuICAgICAgW1N0cmluZy5mcm9tQ2hhckNvZGUoMHhmZjc5KSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApXVxyXG4gICAgXTtcclxuXHJcblxyXG4gIC8vLyA8c3VtbWFyeT5cclxuICAvLy8gICBtYXBwaW5nIHRhYmxlIG9mIEphcGFuZXNlIGNoYXJhY3RlcnMgIzJcclxuICAvLy8gICBjb252ZXJ0IGZyb20gemVua2FrdSAoZXhjZXB0aW9uYWwpIHRvIGhhbmtha3VcclxuICAvLy9cclxuICAvLy8gICByb3cgaW5kZXg6IG5vIHNwZWNpYWwgbWVhbmluZ1xyXG4gIC8vLyAgIGNvbHVtbiAjMTogemVua2FrdShmdWxsLXdpZHRoKSBjb2RlXHJcbiAgLy8vICAgY29sdW1uICMyOiBoYW5rYWt1KGhhbGYtd2lkdGgpIGNvZGVcclxuICAvLy8gPC9zdW1tYXJ5PlxyXG4gIHN0YXRpYyB0YWJsZUV4Y2VwdFplbjJIYW46IHN0cmluZ1tdW10gPVxyXG4gICAgW1xyXG4gICAgICBbU3RyaW5nLmZyb21DaGFyQ29kZSgweDIwMTgpLCBTdHJpbmcuZnJvbUNoYXJDb2RlKDB4MDA2MCldLFxyXG4gICAgICBbU3RyaW5nLmZyb21DaGFyQ29kZSgweDIwMTkpLCBTdHJpbmcuZnJvbUNoYXJDb2RlKDB4MDAyNyldLFxyXG4gICAgICBbU3RyaW5nLmZyb21DaGFyQ29kZSgweDIwMUQpLCBTdHJpbmcuZnJvbUNoYXJDb2RlKDB4MDAyMildLFxyXG4gICAgICBbU3RyaW5nLmZyb21DaGFyQ29kZSgweDMwMDApLCBTdHJpbmcuZnJvbUNoYXJDb2RlKDB4MDAyMCldLFxyXG4gICAgICBbU3RyaW5nLmZyb21DaGFyQ29kZSgweDMwMDEpLCBTdHJpbmcuZnJvbUNoYXJDb2RlKDB4RkY2NCldLFxyXG4gICAgICBbU3RyaW5nLmZyb21DaGFyQ29kZSgweDMwMDIpLCBTdHJpbmcuZnJvbUNoYXJDb2RlKDB4RkY2MSldLFxyXG4gICAgICBbU3RyaW5nLmZyb21DaGFyQ29kZSgweDMwMEMpLCBTdHJpbmcuZnJvbUNoYXJDb2RlKDB4RkY2MildLFxyXG4gICAgICBbU3RyaW5nLmZyb21DaGFyQ29kZSgweDMwMEQpLCBTdHJpbmcuZnJvbUNoYXJDb2RlKDB4RkY2MyldLFxyXG4gICAgICBbU3RyaW5nLmZyb21DaGFyQ29kZSgweDMwRkIpLCBTdHJpbmcuZnJvbUNoYXJDb2RlKDB4RkY2NSldLFxyXG4gICAgICBbU3RyaW5nLmZyb21DaGFyQ29kZSgweDMwRkMpLCBTdHJpbmcuZnJvbUNoYXJDb2RlKDB4RkY3MCldLFxyXG4gICAgICBbU3RyaW5nLmZyb21DaGFyQ29kZSgweEZGRTUpLCBTdHJpbmcuZnJvbUNoYXJDb2RlKDB4MDA1QyldXHJcbiAgICBdO1xyXG5cclxuXHJcbiAgLy8vIDxzdW1tYXJ5PlxyXG4gIC8vLyAgIG1hcHBpbmcgdGFibGUgb2YgSmFwYW5lc2UgY2hhcmFjdGVycyAjM1xyXG4gIC8vLyAgIGNvbnZlcnQgZnJvbSBoYW5rYWt1ICgweGZmNjEgfiAweGZmOWYpIHRvIHplbmtha3VcclxuICAvLy9cclxuICAvLy8gICByb3cgaW5kZXg6IGhhbmtha3UoaGFsZi13aWR0aCkgY29kZSAtKG1pbnVzKSAweGZmNjFcclxuICAvLy8gICBjb2x1bW46ICAgIHplbmtha3UoZnVsbC13aWR0aCkgY29kZVxyXG4gIC8vLyA8L3N1bW1hcnk+XHJcbiAgc3RhdGljIHRhYmxlSGFuMlplbjogc3RyaW5nW10gPVxyXG4gICAgW1xyXG4gICAgICBTdHJpbmcuZnJvbUNoYXJDb2RlKDB4MzAwMiksIFN0cmluZy5mcm9tQ2hhckNvZGUoMHgzMDBjKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDMwMGQpLFxyXG4gICAgICBTdHJpbmcuZnJvbUNoYXJDb2RlKDB4MzAwMSksIFN0cmluZy5mcm9tQ2hhckNvZGUoMHgzMGZiKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDMwZjIpLFxyXG4gICAgICBTdHJpbmcuZnJvbUNoYXJDb2RlKDB4MzBhMSksIFN0cmluZy5mcm9tQ2hhckNvZGUoMHgzMGEzKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDMwYTUpLFxyXG4gICAgICBTdHJpbmcuZnJvbUNoYXJDb2RlKDB4MzBhNyksIFN0cmluZy5mcm9tQ2hhckNvZGUoMHgzMGE5KSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDMwZTMpLFxyXG4gICAgICBTdHJpbmcuZnJvbUNoYXJDb2RlKDB4MzBlNSksIFN0cmluZy5mcm9tQ2hhckNvZGUoMHgzMGU3KSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDMwYzMpLFxyXG4gICAgICBTdHJpbmcuZnJvbUNoYXJDb2RlKDB4MzBmYyksIFN0cmluZy5mcm9tQ2hhckNvZGUoMHgzMGEyKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDMwYTQpLFxyXG4gICAgICBTdHJpbmcuZnJvbUNoYXJDb2RlKDB4MzBhNiksIFN0cmluZy5mcm9tQ2hhckNvZGUoMHgzMGE4KSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDMwYWEpLFxyXG4gICAgICBTdHJpbmcuZnJvbUNoYXJDb2RlKDB4MzBhYiksIFN0cmluZy5mcm9tQ2hhckNvZGUoMHgzMGFkKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDMwYWYpLFxyXG4gICAgICBTdHJpbmcuZnJvbUNoYXJDb2RlKDB4MzBiMSksIFN0cmluZy5mcm9tQ2hhckNvZGUoMHgzMGIzKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDMwYjUpLFxyXG4gICAgICBTdHJpbmcuZnJvbUNoYXJDb2RlKDB4MzBiNyksIFN0cmluZy5mcm9tQ2hhckNvZGUoMHgzMGI5KSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDMwYmIpLFxyXG4gICAgICBTdHJpbmcuZnJvbUNoYXJDb2RlKDB4MzBiZCksIFN0cmluZy5mcm9tQ2hhckNvZGUoMHgzMGJmKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDMwYzEpLFxyXG4gICAgICBTdHJpbmcuZnJvbUNoYXJDb2RlKDB4MzBjNCksIFN0cmluZy5mcm9tQ2hhckNvZGUoMHgzMGM2KSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDMwYzgpLFxyXG4gICAgICBTdHJpbmcuZnJvbUNoYXJDb2RlKDB4MzBjYSksIFN0cmluZy5mcm9tQ2hhckNvZGUoMHgzMGNiKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDMwY2MpLFxyXG4gICAgICBTdHJpbmcuZnJvbUNoYXJDb2RlKDB4MzBjZCksIFN0cmluZy5mcm9tQ2hhckNvZGUoMHgzMGNlKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDMwY2YpLFxyXG4gICAgICBTdHJpbmcuZnJvbUNoYXJDb2RlKDB4MzBkMiksIFN0cmluZy5mcm9tQ2hhckNvZGUoMHgzMGQ1KSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDMwZDgpLFxyXG4gICAgICBTdHJpbmcuZnJvbUNoYXJDb2RlKDB4MzBkYiksIFN0cmluZy5mcm9tQ2hhckNvZGUoMHgzMGRlKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDMwZGYpLFxyXG4gICAgICBTdHJpbmcuZnJvbUNoYXJDb2RlKDB4MzBlMCksIFN0cmluZy5mcm9tQ2hhckNvZGUoMHgzMGUxKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDMwZTIpLFxyXG4gICAgICBTdHJpbmcuZnJvbUNoYXJDb2RlKDB4MzBlNCksIFN0cmluZy5mcm9tQ2hhckNvZGUoMHgzMGU2KSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDMwZTgpLFxyXG4gICAgICBTdHJpbmcuZnJvbUNoYXJDb2RlKDB4MzBlOSksIFN0cmluZy5mcm9tQ2hhckNvZGUoMHgzMGVhKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDMwZWIpLFxyXG4gICAgICBTdHJpbmcuZnJvbUNoYXJDb2RlKDB4MzBlYyksIFN0cmluZy5mcm9tQ2hhckNvZGUoMHgzMGVkKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDMwZWYpLFxyXG4gICAgICBTdHJpbmcuZnJvbUNoYXJDb2RlKDB4MzBmMyksIFN0cmluZy5mcm9tQ2hhckNvZGUoMHgzMDliKSwgU3RyaW5nLmZyb21DaGFyQ29kZSgweDMwOWMpXHJcbiAgICBdO1xyXG5cclxuXHJcbiAgcHJpdmF0ZSBfZXhwcmVzc2lvbkV2YWx1YXRvcjogRXhwcmVzc2lvbkV2YWx1YXRvciA9IG51bGw7XHJcblxyXG4gIGNvbnN0cnVjdG9yKGV4cHJlc3Npb25FdmFsdWF0b3I6IEV4cHJlc3Npb25FdmFsdWF0b3IpIHtcclxuICAgIHRoaXMuX2V4cHJlc3Npb25FdmFsdWF0b3IgPSBleHByZXNzaW9uRXZhbHVhdG9yO1xyXG4gIH1cclxuXHJcbiAgLy8vIDxzdW1tYXJ5PlxyXG4gIC8vLyAgIEhBTjogQ29udmVydCBhIHN0cmluZyBmcm9tIHplbmtha3UoZnVsbC13aWR0aCkgdG8gaGFua2FrdShoYWxmLXdpZHRoKVxyXG4gIC8vLyA8L3N1bW1hcnk+XHJcbiAgLy8vIDxwYXJhbSBuYW1lID0gXCJzdHJWYWw6XCI+emVua2FrdSBzdHJpbmdcclxuICAvLy8gPC9wYXJhbT5cclxuICAvLy8gPHJldHVybnM+IGhhbmFrYWt1IHN0cmluZ1xyXG4gIC8vLyA8L3JldHVybnM+XHJcbiAgZXZhbF9vcF9oYW4oc3RyVmFsOiBzdHJpbmcpOiBzdHJpbmcge1xyXG4gICAgbGV0IHN0cmJ1Zlplbmtha3U6IFN0cmluZ0J1aWxkZXIgPSBuZXcgU3RyaW5nQnVpbGRlcihTdHJVdGlsLnJ0cmltKHN0clZhbCkpO1xyXG4gICAgbGV0IHN0cmJ1Zkhhbmtha3U6IFN0cmluZ0J1aWxkZXIgPSBuZXcgU3RyaW5nQnVpbGRlcigwKTtcclxuICAgIGxldCBzdHJSZXQ6IHN0cmluZyA9IG51bGw7XHJcblxyXG4gICAgZm9yIChsZXQgaTogbnVtYmVyID0gMDsgaSA8IHN0cmJ1Zlplbmtha3UuTGVuZ3RoOyBpID0gaSArIDEpIHtcclxuICAgICAgbGV0IGNMZXR0ZXI6IHN0cmluZyA9IHN0cmJ1Zlplbmtha3UuZ2V0X0l0ZW0oaSk7XHJcblxyXG4gICAgICAvLyBkaWdpdCwgYWxwaGFiZXQgYW5kIGV0Yy5cclxuICAgICAgaWYgKDB4ZmYwMSA8PSBjTGV0dGVyLmNoYXJDb2RlQXQoMCkgJiYgY0xldHRlci5jaGFyQ29kZUF0KDApIDw9IDB4ZmY1ZSAmJiBjTGV0dGVyLmNoYXJDb2RlQXQoMCkgIT09IDB4ZmYzYyAmJiBjTGV0dGVyLmNoYXJDb2RlQXQoMCkgIT09IDB4ZmY0MCkge1xyXG4gICAgICAgIHN0cmJ1Zkhhbmtha3UuQXBwZW5kKFN0cmluZy5mcm9tQ2hhckNvZGUoY0xldHRlci5jaGFyQ29kZUF0KDApIC0gMHhmZWUwKSk7XHJcbiAgICAgIH1cclxuICAgICAgLy8ga2F0YWthbmFcclxuICAgICAgZWxzZSBpZiAoMHgzMDliIDw9IGNMZXR0ZXIuY2hhckNvZGVBdCgwKSAmJiBjTGV0dGVyLmNoYXJDb2RlQXQoMCkgPD0gMHgzMGY2KSB7XHJcbiAgICAgICAgc3RyYnVmSGFua2FrdS5BcHBlbmQoRXhwcmVzc2lvbkxvY2FsSnBuLnRhYmxlWmVuMkhhbltjTGV0dGVyLmNoYXJDb2RlQXQoMCkgLSAweDMwOWJdWzBdKTtcclxuXHJcbiAgICAgICAgaWYgKEV4cHJlc3Npb25Mb2NhbEpwbi50YWJsZVplbjJIYW5bY0xldHRlci5jaGFyQ29kZUF0KDApIC0gMHgzMDliXVsxXS5jaGFyQ29kZUF0KDApID4gMHgwMDAwKSB7XHJcbiAgICAgICAgICBzdHJidWZIYW5rYWt1LkFwcGVuZChFeHByZXNzaW9uTG9jYWxKcG4udGFibGVaZW4ySGFuW2NMZXR0ZXIuY2hhckNvZGVBdCgwKSAtIDB4MzA5Yl1bMV0pO1xyXG4gICAgICAgIH1cclxuICAgICAgfVxyXG4gICAgICAvLyBvdGhlcnNcclxuICAgICAgZWxzZSB7XHJcbiAgICAgICAgbGV0IGo6IG51bWJlcjtcclxuICAgICAgICBmb3IgKGogPSAwOyBqIDwgRXhwcmVzc2lvbkxvY2FsSnBuLnRhYmxlRXhjZXB0WmVuMkhhbi5sZW5ndGg7IGorKykge1xyXG4gICAgICAgICAgaWYgKGNMZXR0ZXIgPT09IEV4cHJlc3Npb25Mb2NhbEpwbi50YWJsZUV4Y2VwdFplbjJIYW5bal1bMF0pIHtcclxuICAgICAgICAgICAgc3RyYnVmSGFua2FrdS5BcHBlbmQoRXhwcmVzc2lvbkxvY2FsSnBuLnRhYmxlRXhjZXB0WmVuMkhhbltqXVsxXSk7XHJcbiAgICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgICAgfVxyXG4gICAgICAgIH1cclxuICAgICAgICBpZiAoaiA9PT0gRXhwcmVzc2lvbkxvY2FsSnBuLnRhYmxlRXhjZXB0WmVuMkhhbi5sZW5ndGgpXHJcbiAgICAgICAgICBzdHJidWZIYW5rYWt1LkFwcGVuZChjTGV0dGVyKTtcclxuICAgICAgfVxyXG4gICAgfVxyXG5cclxuICAgIHN0clJldCA9IHN0cmJ1Zkhhbmtha3UuVG9TdHJpbmcoKTtcclxuXHJcbiAgICBzdHJidWZaZW5rYWt1ID0gbnVsbDtcclxuICAgIHN0cmJ1Zkhhbmtha3UgPSBudWxsO1xyXG5cclxuICAgIHJldHVybiBzdHJSZXQ7XHJcbiAgfVxyXG5cclxuICAvLy8gPHN1bW1hcnk+XHJcbiAgLy8vICAgWkVOL1pFTlM6IENvbnZlcnQgYSBzdHJpbmcgZnJvbSBoYW5rYWt1KGhhbGYtd2lkdGgpIHRvIHplbmtha3UoZnVsbC13aWR0aClcclxuICAvLy8gPC9zdW1tYXJ5PlxyXG4gIC8vLyA8cGFyYW0gbmFtZSA9IFwic3RyVmFsOlwiPmhhbmtha3Ugc3RyaW5nXHJcbiAgLy8vIDwvcGFyYW0+XHJcbiAgLy8vIDxwYXJhbSBuYW1lID0gXCJtb2RlOlwiPnNwZWNpZnkgaG93IHRvIGNvbnZlcnQgYSBoYW5rYWt1IHNwYWNlXHJcbiAgLy8vICAgMCA9IHRvIGhhbmtha3Ugc3BhY2UgeCAxXHJcbiAgLy8vICAgMSA9IHRvIHplbmtha3Ugc3BhY2UgeCAxXHJcbiAgLy8vICAgMiA9IHRvIGhhbmtha3Ugc3BhY2UgeCAyXHJcbiAgLy8vIDwvcGFyYW0+XHJcbiAgLy8vIDxyZXR1cm5zPiB6ZW5rYWt1IHN0cmluZ1xyXG4gIC8vLyA8L3JldHVybnM+XHJcbiAgZXZhbF9vcF96ZW5zKHN0clZhbDogc3RyaW5nLCBtb2RlOiBudW1iZXIpOiBzdHJpbmcge1xyXG4gICAgbGV0IHN0cmJ1Zkhhbmtha3U6IFN0cmluZ0J1aWxkZXIgPSBuZXcgU3RyaW5nQnVpbGRlcihTdHJVdGlsLnJ0cmltKHN0clZhbCkpO1xyXG4gICAgbGV0IHN0cmJ1Zlplbmtha3U6IFN0cmluZ0J1aWxkZXIgPSBuZXcgU3RyaW5nQnVpbGRlcigwKTtcclxuICAgIGxldCBzdHJSZXQ6IHN0cmluZyA9IG51bGw7XHJcblxyXG4gICAgZm9yIChsZXQgaTogbnVtYmVyID0gMDsgaSA8IHN0cmJ1Zkhhbmtha3UuTGVuZ3RoOyBpID0gaSArIDEpIHtcclxuICAgICAgbGV0IGNMZXR0ZXI6IHN0cmluZyA9IHN0cmJ1Zkhhbmtha3UuZ2V0X0l0ZW0oaSk7XHJcblxyXG4gICAgICAvLyBzcGFjZSwgZGlnaXQsIGFscGhhYmV0IGFuZCBldGMuXHJcbiAgICAgIGlmICgweDAwMjAgPD0gY0xldHRlci5jaGFyQ29kZUF0KDApICYmIGNMZXR0ZXIuY2hhckNvZGVBdCgwKSA8PSAweDAwN2UpIHtcclxuXHJcbiAgICAgICAgc3dpdGNoIChjTGV0dGVyKSB7XHJcbiAgICAgICAgICBjYXNlIFN0cmluZy5mcm9tQ2hhckNvZGUoMHgwMDIwKTogLy8gc3BhY2VcclxuICAgICAgICAgICAgaWYgKG1vZGUgPT09IDEpIHtcclxuICAgICAgICAgICAgICBzdHJidWZaZW5rYWt1LkFwcGVuZChTdHJpbmcuZnJvbUNoYXJDb2RlKDB4MzAwMCkpOyAvLyB6ZW5rYWt1IHNwYWNlIHggMS9Ccm93c2VyQ2xpZW50L1xyXG4gICAgICAgICAgICB9XHJcbiAgICAgICAgICAgIGVsc2UgaWYgKG1vZGUgPT09IDIpIHtcclxuICAgICAgICAgICAgICBzdHJidWZaZW5rYWt1LkFwcGVuZChTdHJpbmcuZnJvbUNoYXJDb2RlKDB4MDAyMCkpOyAvLyBoYW5rYWt1IHNwYWNlIHggMlxyXG4gICAgICAgICAgICAgIHN0cmJ1Zlplbmtha3UuQXBwZW5kKFN0cmluZy5mcm9tQ2hhckNvZGUoMHgwMDIwKSk7XHJcbiAgICAgICAgICAgIH1cclxuICAgICAgICAgICAgLyogbW9kZSA9PSAwICovXHJcbiAgICAgICAgICAgIGVsc2Uge1xyXG4gICAgICAgICAgICAgIHN0cmJ1Zlplbmtha3UuQXBwZW5kKFN0cmluZy5mcm9tQ2hhckNvZGUoMHgwMDIwKSk7IC8vIGhhbmtha3Ugc3BhY2UgeCAxXHJcbiAgICAgICAgICAgIH1cclxuICAgICAgICAgICAgYnJlYWs7XHJcblxyXG5cclxuICAgICAgICAgIGNhc2UgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMjIpOiAvLyBcIlxyXG4gICAgICAgICAgICBzdHJidWZaZW5rYWt1LkFwcGVuZChTdHJpbmcuZnJvbUNoYXJDb2RlKDB4MjAxZCkpO1xyXG4gICAgICAgICAgICBicmVhaztcclxuXHJcblxyXG4gICAgICAgICAgY2FzZSBTdHJpbmcuZnJvbUNoYXJDb2RlKDB4MDAyNyk6IC8vICdcclxuICAgICAgICAgICAgc3RyYnVmWmVua2FrdS5BcHBlbmQoU3RyaW5nLmZyb21DaGFyQ29kZSgweDIwMTkpKTtcclxuICAgICAgICAgICAgYnJlYWs7XHJcblxyXG5cclxuICAgICAgICAgIGNhc2UgU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwNWMpOiAvLyBcXFxyXG4gICAgICAgICAgICBzdHJidWZaZW5rYWt1LkFwcGVuZChTdHJpbmcuZnJvbUNoYXJDb2RlKDB4ZmZlNSkpO1xyXG4gICAgICAgICAgICBicmVhaztcclxuXHJcblxyXG4gICAgICAgICAgY2FzZSBTdHJpbmcuZnJvbUNoYXJDb2RlKDB4MDA2MCk6IC8vIGBcclxuICAgICAgICAgICAgc3RyYnVmWmVua2FrdS5BcHBlbmQoU3RyaW5nLmZyb21DaGFyQ29kZSgweDIwMTgpKTtcclxuICAgICAgICAgICAgYnJlYWs7XHJcblxyXG5cclxuICAgICAgICAgIGRlZmF1bHQ6XHJcbiAgICAgICAgICAgIHN0cmJ1Zlplbmtha3UuQXBwZW5kKFN0cmluZy5mcm9tQ2hhckNvZGUoY0xldHRlci5jaGFyQ29kZUF0KDApICsgMHhmZWUwKSk7XHJcbiAgICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIH1cclxuICAgICAgfVxyXG4gICAgICAvLyBrdXRvdXRlbiwga2F0YWthbmEgYW5kIGV0Yy5cclxuICAgICAgZWxzZSBpZiAoMHhmZjYxIDw9IGNMZXR0ZXIuY2hhckNvZGVBdCgwKSAmJiBjTGV0dGVyLmNoYXJDb2RlQXQoMCkgPD0gMHhmZjlmKSB7XHJcbiAgICAgICAgbGV0IGNDb21iaW5lOiBzdHJpbmcgPSBTdHJpbmcuZnJvbUNoYXJDb2RlKDB4MDAwMCk7IC8vIGZsYWcgb2YgZGFrdW9uIG9yIGhhbi1kYWt1b25cclxuXHJcbiAgICAgICAgaWYgKChpICsgMSkgPCBzdHJidWZIYW5rYWt1Lkxlbmd0aCkge1xyXG4gICAgICAgICAgLy8gY2hlY2sgdGhlIG5leHQgbGV0dGVyXHJcbiAgICAgICAgICBjQ29tYmluZSA9IHN0cmJ1Zkhhbmtha3UuZ2V0X0l0ZW0oaSArIDEpO1xyXG4gICAgICAgICAgaWYgKGNDb21iaW5lLmNoYXJDb2RlQXQoMCkgIT09IDB4ZmY5ZSAmJiBjQ29tYmluZS5jaGFyQ29kZUF0KDApICE9PSAweGZmOWYpXHJcbiAgICAgICAgICAgIGNDb21iaW5lID0gU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApO1xyXG4gICAgICAgIH1cclxuXHJcbiAgICAgICAgaWYgKGNDb21iaW5lLmNoYXJDb2RlQXQoMCkgPT09IDB4ZmY5ZSlcclxuICAgICAgICAvLyBzeW1ib2wgb2YgZGFrdW9uXHJcbiAgICAgICAge1xyXG4gICAgICAgICAgaWYgKDB4ZmY3NiA8PSBjTGV0dGVyLmNoYXJDb2RlQXQoMCkgJiYgY0xldHRlci5jaGFyQ29kZUF0KDApIDw9IDB4ZmY4NCB8fCAweGZmOGEgPD0gY0xldHRlci5jaGFyQ29kZUF0KDApICYmIGNMZXR0ZXIuY2hhckNvZGVBdCgwKSA8PSAweGZmOGUpXHJcbiAgICAgICAgICAgIHN0cmJ1Zlplbmtha3UuQXBwZW5kKChFeHByZXNzaW9uTG9jYWxKcG4udGFibGVIYW4yWmVuW2NMZXR0ZXIuY2hhckNvZGVBdCgwKSAtIDB4ZmY2MV0gKyAweDAwMSkpO1xyXG4gICAgICAgICAgZWxzZSBpZiAoY0xldHRlci5jaGFyQ29kZUF0KDApID09PSAweGZmNzMpXHJcbiAgICAgICAgICAgIHN0cmJ1Zlplbmtha3UuQXBwZW5kKFN0cmluZy5mcm9tQ2hhckNvZGUoMHgzMGY0KSk7XHJcbiAgICAgICAgICBlbHNlXHJcbiAgICAgICAgICAgIGNDb21iaW5lID0gU3RyaW5nLmZyb21DaGFyQ29kZSgweDAwMDApOyAvLyB0aGUgc3ltYm9sIGlzIGluZGVwZW5kZW50XHJcbiAgICAgICAgfVxyXG4gICAgICAgIGVsc2UgaWYgKGNDb21iaW5lLmNoYXJDb2RlQXQoMCkgPT09IDB4ZmY5ZilcclxuICAgICAgICAvLyBzeW1ib2wgb2YgaGFuLWRha3VvblxyXG4gICAgICAgIHtcclxuICAgICAgICAgIGlmICgweGZmOGEgPD0gY0xldHRlci5jaGFyQ29kZUF0KDApICYmIGNMZXR0ZXIuY2hhckNvZGVBdCgwKSA8PSAweGZmOGUpXHJcbiAgICAgICAgICAgIHN0cmJ1Zlplbmtha3UuQXBwZW5kKChFeHByZXNzaW9uTG9jYWxKcG4udGFibGVIYW4yWmVuW2NMZXR0ZXIuY2hhckNvZGVBdCgwKSAtIDB4ZmY2MV0gKyAweDAwMikpO1xyXG4gICAgICAgICAgZWxzZVxyXG4gICAgICAgICAgICBjQ29tYmluZSA9IFN0cmluZy5mcm9tQ2hhckNvZGUoMHgwMDAwKTsgLy8gdGhlIHN5bWJvbCBpcyBpbmRlcGVuZGVudFxyXG4gICAgICAgIH1cclxuXHJcbiAgICAgICAgaWYgKGNDb21iaW5lLmNoYXJDb2RlQXQoMCkgIT09IDB4MDAwMClcclxuICAgICAgICAgIGkrKztcclxuICAgICAgICBlbHNlXHJcbiAgICAgICAgICBzdHJidWZaZW5rYWt1LkFwcGVuZChFeHByZXNzaW9uTG9jYWxKcG4udGFibGVIYW4yWmVuW2NMZXR0ZXIuY2hhckNvZGVBdCgwKSAtIDB4ZmY2MV0pO1xyXG4gICAgICB9XHJcbiAgICAgIC8vIG90aGVyc1xyXG4gICAgICBlbHNlIHtcclxuICAgICAgICBzdHJidWZaZW5rYWt1LkFwcGVuZChjTGV0dGVyKTtcclxuICAgICAgfVxyXG4gICAgfVxyXG5cclxuICAgIHN0clJldCA9IHN0cmJ1Zlplbmtha3UuVG9TdHJpbmcoKTtcclxuXHJcbiAgICBzdHJidWZIYW5rYWt1ID0gbnVsbDtcclxuICAgIHN0cmJ1Zlplbmtha3UgPSBudWxsO1xyXG5cclxuICAgIHJldHVybiBzdHJSZXQ7XHJcbiAgfVxyXG5cclxuICAvLy8gPHN1bW1hcnk+XHJcbiAgLy8vICAgWklNRVJlYWQ6IHJldHVybiBjb21wb3NpdGlvbiBzdHJpbmcgaW4gSU1FXHJcbiAgLy8vIDwvc3VtbWFyeT5cclxuICBldmFsX29wX3ppbWVyZWFkKCk6IHN0cmluZyB7XHJcbiAgICBsZXQgc3RyUmV0OiBzdHJpbmcgPSBudWxsO1xyXG4gICAgbGV0IHV0aWxJbWVKcG46IFV0aWxJbWVKcG4gPSBNYW5hZ2VyLlV0aWxJbWVKcG47XHJcblxyXG4gICAgaWYgKHV0aWxJbWVKcG4gIT09IG51bGwpXHJcbiAgICAgIHN0clJldCA9IHV0aWxJbWVKcG4uU3RySW1lUmVhZDtcclxuXHJcbiAgICByZXR1cm4gc3RyUmV0O1xyXG4gIH1cclxuXHJcbiAgLy8vIDxzdW1tYXJ5PlxyXG4gIC8vLyAgIFpLQU5BOiBDb252ZXJ0IGEgc3RyaW5nIGZyb20gaGlyYWdhbmEgdG8ga2F0YWthbmEgKGFuZCB2aWNlIHZlcnNhKVxyXG4gIC8vLyA8L3N1bW1hcnk+XHJcbiAgLy8vIDxwYXJhbSBuYW1lID0gXCJzdHJWYWw6XCI+aGFua2FrdShvciBrYXRha2FuYSkgc3RyaW5nXHJcbiAgLy8vIDwvcGFyYW0+XHJcbiAgLy8vIDxwYXJhbSBuYW1lID0gXCJtb2RlOlwiPnNwZWNpZnkgdGhlIGRpcmVjdGlvbiBvZiBjb252ZXJzaW9uXHJcbiAgLy8vICAgMCA9IGZyb20gaGlyYWdhbmEgdG8ga2F0YWthbmFcclxuICAvLy8gICAxID0gZnJvbSBrYXRha2FuYSB0byBoaXJhZ2FuYVxyXG4gIC8vLyA8L3BhcmFtPlxyXG4gIC8vLyA8cmV0dXJucz4ga2F0YWthbmEob3IgaGlyYWdhbmEpIHN0cmluZ1xyXG4gIC8vLyA8L3JldHVybnM+XHJcbiAgZXZhbF9vcF96a2FuYShzdHJWYWw6IHN0cmluZywgbW9kZTogbnVtYmVyKTogc3RyaW5nIHtcclxuICAgIGxldCBzdHJidWZDb252ZXJ0ZWQ6IFN0cmluZ0J1aWxkZXIgPSBuZXcgU3RyaW5nQnVpbGRlcihTdHJVdGlsLnJ0cmltKHN0clZhbCkpO1xyXG4gICAgbGV0IHN0clJldDogc3RyaW5nID0gbnVsbDtcclxuXHJcbiAgICBmb3IgKGxldCBpOiBudW1iZXIgPSAwOyBpIDwgc3RyYnVmQ29udmVydGVkLkxlbmd0aDsgaSA9IGkgKyAxKSB7XHJcbiAgICAgIGxldCBjTGV0dGVyOiBzdHJpbmcgPSBzdHJidWZDb252ZXJ0ZWQuZ2V0X0l0ZW0oaSk7XHJcblxyXG4gICAgICBpZiAobW9kZSA9PT0gMCkge1xyXG4gICAgICAgIC8vIGhpcmFnYW5hIC0tPiBrYXRha2FuYVxyXG4gICAgICAgIGlmICgweDMwNDEgPD0gY0xldHRlci5jaGFyQ29kZUF0KDApICYmIGNMZXR0ZXIuY2hhckNvZGVBdCgwKSA8PSAweDMwOTMpXHJcbiAgICAgICAgICBzdHJidWZDb252ZXJ0ZWQuc2V0X0l0ZW0oaSwgU3RyaW5nLmZyb21DaGFyQ29kZShjTGV0dGVyLmNoYXJDb2RlQXQoMCkgKyAweDAwNjApKTtcclxuICAgICAgfVxyXG4gICAgICAvLyBrYXRha2FuYSAtLT4gaGlyYWdhbmFcclxuICAgICAgZWxzZSB7XHJcbiAgICAgICAgaWYgKDB4MzBBMSA8PSBjTGV0dGVyLmNoYXJDb2RlQXQoMCkgJiYgY0xldHRlci5jaGFyQ29kZUF0KDApIDw9IDB4MzBmMylcclxuICAgICAgICAgIHN0cmJ1ZkNvbnZlcnRlZC5zZXRfSXRlbShpLCBTdHJpbmcuZnJvbUNoYXJDb2RlKGNMZXR0ZXIuY2hhckNvZGVBdCgwKSAtIDB4MDA2MCkpO1xyXG4gICAgICB9XHJcbiAgICB9XHJcbiAgICBzdHJSZXQgPSBzdHJidWZDb252ZXJ0ZWQuVG9TdHJpbmcoKTtcclxuICAgIHN0cmJ1ZkNvbnZlcnRlZCA9IG51bGw7XHJcblxyXG4gICAgcmV0dXJuIHN0clJldDtcclxuICB9XHJcblxyXG4gIC8vLyA8c3VtbWFyeT5cclxuICAvLy8gICBKQ0RPVzogSmFwYW5lc2UgdmVyc2lvbiBvZiBDRE9XXHJcbiAgLy8vIDwvc3VtbWFyeT5cclxuICBldmFsX29wX2pjZG93KHJlc1ZhbDogRXhwVmFsLCB2YWwxOiBOVU1fVFlQRSwgZGlzcGxheUNvbnZlcnRvcjogRGlzcGxheUNvbnZlcnRvcik6IHZvaWQge1xyXG4gICAgdGhpcy5fZXhwcmVzc2lvbkV2YWx1YXRvci5ldmFsX29wX2RhdGVfc3RyKHJlc1ZhbCwgdmFsMSwgXCJTU1NTU1NUXCIsIGRpc3BsYXlDb252ZXJ0b3IpO1xyXG4gIH1cclxuXHJcbiAgLy8vIDxzdW1tYXJ5PlxyXG4gIC8vLyAgIEpNT05USDogSmFwYW5lc2UgdmVyc2lvbiBvZiBOTU9OVEhcclxuICAvLy8gPC9zdW1tYXJ5PlxyXG4gIGV2YWxfb3Bfam1vbnRoKHJlc1ZhbDogRXhwVmFsLCB2YWwxOiBFeHBWYWwpOiB2b2lkIHtcclxuICAgIGlmICh2YWwxLk1nTnVtVmFsID09PSBudWxsKSB7XHJcbiAgICAgIHRoaXMuX2V4cHJlc3Npb25FdmFsdWF0b3IuU2V0TlVMTChyZXNWYWwsIFN0b3JhZ2VBdHRyaWJ1dGUuQUxQSEEpO1xyXG4gICAgICByZXR1cm47XHJcbiAgICB9XHJcblxyXG4gICAgdmFsMS5NZ051bVZhbCA9IHRoaXMuX2V4cHJlc3Npb25FdmFsdWF0b3IubXVsX2FkZCh2YWwxLk1nTnVtVmFsLCAzMSwgLTMwKTtcclxuICAgIHRoaXMuX2V4cHJlc3Npb25FdmFsdWF0b3IuZXZhbF9vcF9tb250aChyZXNWYWwsIHZhbDEpO1xyXG4gICAgbGV0IG1vbnRoOiBudW1iZXIgPSByZXNWYWwuTWdOdW1WYWwuTlVNXzJfTE9ORygpO1xyXG5cclxuICAgIHJlc1ZhbC5BdHRyID0gU3RvcmFnZUF0dHJpYnV0ZS5BTFBIQTtcclxuICAgIHJlc1ZhbC5TdHJWYWwgPSBVdGlsRGF0ZUpwbi5jb252ZXJ0U3RyTW9udGgobW9udGgpO1xyXG4gIH1cclxuXHJcbiAgLy8vIDxzdW1tYXJ5PlxyXG4gIC8vLyAgIEpORE9XOiBKYXBhbmVzZSB2ZXJzaW9uIG9mIE5ET1dcclxuICAvLy8gPC9zdW1tYXJ5PlxyXG4gIGV2YWxfb3Bfam5kb3cocmVzVmFsOiBFeHBWYWwsIHZhbDE6IEV4cFZhbCwgZGlzcGxheUNvbnZlcnRvcjogRGlzcGxheUNvbnZlcnRvcik6IHZvaWQge1xyXG4gICAgaWYgKHZhbDEuTWdOdW1WYWwgPT09IG51bGwpIHtcclxuICAgICAgdGhpcy5fZXhwcmVzc2lvbkV2YWx1YXRvci5TZXROVUxMKHJlc1ZhbCwgU3RvcmFnZUF0dHJpYnV0ZS5BTFBIQSk7XHJcbiAgICAgIHJldHVybjtcclxuICAgIH1cclxuXHJcbiAgICB2YWwxLk1nTnVtVmFsID0gdGhpcy5fZXhwcmVzc2lvbkV2YWx1YXRvci5tdWxfYWRkKHZhbDEuTWdOdW1WYWwsIDAsIDYpO1xyXG4gICAgdGhpcy5ldmFsX29wX2pjZG93KHJlc1ZhbCwgdmFsMS5NZ051bVZhbCwgZGlzcGxheUNvbnZlcnRvcik7XHJcbiAgfVxyXG5cclxuICAvLy8gPHN1bW1hcnk+XHJcbiAgLy8vICAgSllFQVI6IFJldHVybiBKYXBhbmVzZSB5ZWFyIG9mIGFuIGVyYVxyXG4gIC8vLyA8L3N1bW1hcnk+XHJcbiAgZXZhbF9vcF9qeWVhcihyZXNWYWw6IEV4cFZhbCwgdmFsMTogRXhwVmFsKTogdm9pZCB7XHJcbiAgICB0aGlzLl9leHByZXNzaW9uRXZhbHVhdG9yLmV2YWxfb3BfZGF0ZV9icmsocmVzVmFsLCB2YWwxLk1nTnVtVmFsLCA0KTtcclxuICB9XHJcblxyXG4gIC8vLyA8c3VtbWFyeT5cclxuICAvLy8gICBKR0VOR086IFJldHVybiBKYXBhbmVzZSBnZW5nbyAodGhlIG5hbWUgb2YgYW4gZXJhKVxyXG4gIC8vLyA8L3N1bW1hcnk+XHJcbiAgZXZhbF9vcF9qZ2VuZ28ocmVzVmFsOiBFeHBWYWwsIHZhbDE6IE5VTV9UWVBFLCB2YWwyOiBOVU1fVFlQRSwgZGlzcGxheUNvbnZlcnRvcjogRGlzcGxheUNvbnZlcnRvcik6IHZvaWQge1xyXG4gICAgbGV0IHN0ckZvcm1hdDogc3RyaW5nO1xyXG5cclxuICAgIHJlc1ZhbC5BdHRyID0gU3RvcmFnZUF0dHJpYnV0ZS5BTFBIQTtcclxuXHJcbiAgICBpZiAodmFsMSA9PT0gbnVsbCB8fCB2YWwyID09PSBudWxsKSB7XHJcbiAgICAgIHRoaXMuX2V4cHJlc3Npb25FdmFsdWF0b3IuU2V0TlVMTChyZXNWYWwsIFN0b3JhZ2VBdHRyaWJ1dGUuQUxQSEEpO1xyXG4gICAgICByZXR1cm47XHJcbiAgICB9XHJcblxyXG4gICAgbGV0IGludFR5cGU6IG51bWJlciA9IHZhbDIuTlVNXzJfTE9ORygpO1xyXG5cclxuICAgIGlmIChpbnRUeXBlID49IDQpXHJcbiAgICAgIHN0ckZvcm1hdCA9IFwiSkpKSlwiO1xyXG4gICAgZWxzZSBpZiAoaW50VHlwZSA+PSAyKVxyXG4gICAgICBzdHJGb3JtYXQgPSBcIkpKXCI7XHJcbiAgICBlbHNlIGlmIChpbnRUeXBlID49IDEpXHJcbiAgICAgIHN0ckZvcm1hdCA9IFwiSlwiO1xyXG4gICAgZWxzZSB7XHJcbiAgICAgIHJlc1ZhbC5TdHJWYWwgPSBcIlwiO1xyXG4gICAgICByZXR1cm47XHJcbiAgICB9XHJcblxyXG4gICAgdGhpcy5fZXhwcmVzc2lvbkV2YWx1YXRvci5ldmFsX29wX2RhdGVfc3RyKHJlc1ZhbCwgdmFsMSwgc3RyRm9ybWF0LCBkaXNwbGF5Q29udmVydG9yKTtcclxuICB9XHJcbn1cclxuIl19