import { NString } from "@magic-xpa/mscorelib";
import { StorageAttribute, XMLConstants, XmlParser } from "@magic-xpa/utils";
import { ExpVal, RecordUtils } from "@magic-xpa/gui";
import { MirrorPrmMap } from "../util/PrmMap";
import { ParamParseResult } from '../util/ParamParseResult';
import { ConstInterface } from "../ConstInterface";
import { Environment } from "../env/Environment";
export class MirrorExpVal extends ExpVal {
    constructor(val) {
        if (arguments.length === 0) {
            super();
            this.constructor_2();
            return;
        }
        super();
        this.constructor_3(val);
    }
    constructor_2() {
    }
    constructor_3(val) {
        super.Copy(val);
    }
    mirrorToXML() {
        let toBase64 = (Environment.Instance.GetDebugLevel() <= 1);
        let cellAttr = (this.Attr === StorageAttribute.BLOB_VECTOR ? this.VectorField.getCellsType() : StorageAttribute.SKIP);
        let value = "";
        value = RecordUtils.itemValToXML(super.ToMgVal(), this.Attr, cellAttr, toBase64);
        return ConstInterface.MG_ATTR_PAR_ATTRS + "=\"" + this.Attr + "\" " + ConstInterface.MG_ATTR_LEN + "=" +
            value.length + " " + ConstInterface.MG_ATTR_ENV_VALUE + "=\"" + value + "\"";
    }
    init(name, xmlParser) {
        let valueOffset, attrOffset, lenOffset, valueLen, lenOffsetEnd, count;
        let currType;
        let isNull;
        let paramAttr, paramValue, correctValue = null;
        count = xmlParser.getXMLdata().indexOf(XMLConstants.TAG_TERM, xmlParser.getCurrIndex()) - xmlParser.getCurrIndex();
        attrOffset = NString.IndexOf(xmlParser.getXMLdata(), ConstInterface.MG_ATTR_PAR_ATTRS, xmlParser.getCurrIndex(), count);
        if (attrOffset !== -1) {
            attrOffset += ConstInterface.MG_ATTR_PAR_ATTRS.length + 2;
            paramAttr = xmlParser.getXMLdata().substr(attrOffset, 1);
            lenOffset = xmlParser.getXMLdata().indexOf(ConstInterface.MG_ATTR_LEN, attrOffset);
            lenOffset += ConstInterface.MG_ATTR_LEN.length + 1;
            lenOffsetEnd = xmlParser.getXMLdata().indexOf(" ", lenOffset);
            valueLen = XmlParser.getInt(xmlParser.getXMLdata().substr(lenOffset, lenOffsetEnd - lenOffset));
            valueOffset = xmlParser.getXMLdata().indexOf(ConstInterface.MG_ATTR_ENV_VALUE, lenOffset);
            valueOffset += ConstInterface.MG_ATTR_ENV_VALUE.length + 2;
            paramValue = xmlParser.getXMLdata().substr(valueOffset, valueLen);
            currType = paramAttr[0];
            correctValue = RecordUtils.getString(paramValue, currType);
            isNull = false;
            xmlParser.setCurrIndex(valueOffset + valueLen);
        }
        else if (xmlParser.getXMLdata().indexOf(ConstInterface.MG_ATTR_ENV_REMOVED, xmlParser.getCurrIndex()) !== -1) {
            return ParamParseResult.DELETE;
        }
        else {
            currType = StorageAttribute.NONE;
            isNull = true;
        }
        super.Init(currType, isNull, correctValue);
        return ParamParseResult.TOUPPER;
    }
}
export class GlobalParams extends MirrorPrmMap {
    constructor() {
        super(MirrorExpVal);
        this.mirroredID = ConstInterface.MG_TAG_GLOBALPARAMSCHANGES;
    }
    set(s, v) {
        if (v.IsNull || v.isEmptyString())
            super.remove(s.trim().toUpperCase());
        else
            super.setValue(s.trim().toUpperCase(), new MirrorExpVal(v));
    }
    get(s) {
        try {
            return super.getvalue(s.trim().toUpperCase());
        }
        catch (err) {
            return null;
        }
    }
}
GlobalParams.Instance = new GlobalParams();
//# sourceMappingURL=data:application/json;base64,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