import { XmlParser, StorageAttribute } from "@magic-xpa/utils";
import { DisplayConvertor } from "@magic-xpa/gui";
export class YesNoExp {
    constructor(defaultVal) {
        this._exp = null;
        this._val = false;
        this._val = defaultVal;
        this._exp = null;
    }
    setVal(task, strVal) {
        switch (strVal[0]) {
            case 'Y':
                this._val = true;
                break;
            case 'N':
                this._val = false;
                break;
            default:
                let expId = XmlParser.getInt(strVal);
                if (task != null)
                    this._exp = task.getExpById(expId);
                break;
        }
    }
    async getVal() {
        if (this._exp !== null)
            return await DisplayConvertor.toBoolean(await this._exp.evaluateWithResultTypeAndLength(StorageAttribute.BOOLEAN, 0));
        return this._val;
    }
    isServerExp() {
        if (this._exp != null)
            return this._exp.computedByServerOnly();
        return false;
    }
}
//# sourceMappingURL=data:application/json;base64,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