import { List } from "@magic-xpa/mscorelib";
import { XMLConstants } from "@magic-xpa/utils";
import { Manager, RuntimeContextBase } from "@magic-xpa/gui";
import { RemoteTaskService } from "../tasks/RemoteTaskService";
export class FormsTable {
    get Count() {
        return this._formsStringXml.length;
    }
    get_Item(formDisplayIndex) {
        if (formDisplayIndex > 0 && formDisplayIndex <= this._formsStringXml.length)
            return this._formsStringXml.get_Item(formDisplayIndex - 1);
        return null;
    }
    constructor(task, parentForm) {
        this._task = null;
        this._parentForm = null;
        this._formsStringXml = null;
        this._task = task;
        this._parentForm = parentForm;
    }
    async fillData() {
        this._formsStringXml = new List();
        let parser = Manager.GetCurrentRuntimeContext().Parser;
        while (await this.initInnerObjects(parser.getNextTag())) {
        }
    }
    InitFormFromXmlString(formDisplayIndex) {
        let formStrXml = this.get_Item(1);
        if (formDisplayIndex > 0 && formDisplayIndex <= this._formsStringXml.length)
            formStrXml = this.get_Item(formDisplayIndex);
        if (formStrXml !== null) {
            RuntimeContextBase.Instance.Parser.push();
            RuntimeContextBase.Instance.Parser.PrepareFormReadString(formStrXml);
            this._task.FormInitData(this._parentForm);
            RuntimeContextBase.Instance.Parser.pop();
        }
    }
    async initInnerObjects(foundTagName) {
        if (foundTagName === null)
            return false;
        let parser = Manager.GetCurrentRuntimeContext().Parser;
        if (foundTagName === XMLConstants.MG_TAG_FORMS) {
            parser.setCurrIndex(parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex()) + 1);
        }
        else if (foundTagName === XMLConstants.MG_TAG_FORM) {
            let formStringXml = RuntimeContextBase.Instance.Parser.ReadToEndOfCurrentElement();
            this._formsStringXml.push(formStringXml);
            return true;
        }
        else if (foundTagName === ('/' + XMLConstants.MG_TAG_FORM)) {
            parser.setCurrIndex2EndOfTag();
            return true;
        }
        else if (foundTagName === ('/' + XMLConstants.MG_TAG_FORMS)) {
            await this.PrepareMainDisplayForConnectedTask();
            parser.setCurrIndex2EndOfTag();
            return false;
        }
        return true;
    }
    async PrepareMainDisplayForConnectedTask() {
        if (this._task.TaskService instanceof RemoteTaskService)
            await this._task.PrepareTaskForm();
    }
}
//# sourceMappingURL=data:application/json;base64,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