import { ApplicationException, Debug, NString } from "@magic-xpa/mscorelib";
import { Logger } from "@magic-xpa/utils";
import { ConstInterface } from "../ConstInterface";
import { HttpClientEvents } from "./client/HttpClientEvents";
import { HttpClientSync } from "./client/HttpClientSync";
import { HttpClientAsync } from "./client/HttpClientAsync";
export class HttpManager {
    getHttpClient() {
        if (this.IsAbortingMagicEngine)
            return new HttpClientSync();
        return this._httpClientAsync;
    }
    set HttpCommunicationTimeoutMS(value) {
        this._httpCommunicationTimeoutMS = value;
    }
    static setNativeHttpClient(httpClient) {
        HttpManager._nativeHttpClient = httpClient;
    }
    static GetInstance() {
        if (HttpManager._instance === null) {
            HttpManager._instance = new HttpManager();
        }
        return HttpManager._instance;
    }
    get IsAbortingMagicEngine() { return this._isAbortingMagicEngine; }
    set IsAbortingMagicEngine(isAbortingMagicEngine) { this._isAbortingMagicEngine = isAbortingMagicEngine; }
    constructor() {
        this._httpCommunicationTimeoutMS = HttpManager.DEFAULT_HTTP_COMMUNICATION_TIMEOUT;
        this._httpClientAsync = null;
        this._isAbortingMagicEngine = false;
        this._httpClientAsync = new HttpClientAsync(HttpManager._nativeHttpClient);
        this.RegisterBasicDelegates();
    }
    RegisterBasicDelegates() {
        HttpClientEvents.GetHttpCommunicationTimeout_Event = this.GetHttpCommunicationTimeoutMS.bind(this);
    }
    GetHttpCommunicationTimeoutMS() {
        return this._httpCommunicationTimeoutMS;
    }
    SetCommunicationsFailureHandler(handler) {
        this.getHttpClient().CommunicationsFailureHandler = handler;
    }
    async GetContent(requestedURL, requestContent, useCache, isError) {
        let response;
        Debug.Assert(this.getHttpClient() != null);
        try {
            Logger.Instance.WriteServerToLog("*************************************************************************************************");
            isError.value = false;
            Logger.Instance.WriteServerToLog(requestedURL);
            HttpManager.LogAccessToServer("", requestContent);
            response = await this.getHttpClient().GetContent(requestedURL, requestContent, useCache);
            Debug.Assert(response !== null);
            let errorResponse = HttpManager.CheckAndGetErrorResponse(response);
            if (errorResponse !== null) {
                response = errorResponse;
                isError.value = true;
            }
            return response;
        }
        catch (ex) {
            let url = new URL(requestedURL);
            throw new ApplicationException(ex.Message + "\n" + url.origin + url.pathname, ex);
        }
        finally {
        }
    }
    static CheckAndGetErrorResponse(httpResponse) {
        let errorResponse = null;
        if (httpResponse.startsWith(ConstInterface.V24_RIA_ERROR_PREFIX))
            errorResponse = httpResponse.substr(ConstInterface.V24_RIA_ERROR_PREFIX.length);
        return errorResponse;
    }
    static LogAccessToServer(msg, requestContent) {
        if (Logger.Instance.ShouldLogServerRelatedMessages()) {
            if (!NString.IsNullOrEmpty(msg)) {
                msg = msg + "; accessing server ...";
            }
            if (requestContent === null) {
                if (!NString.IsNullOrEmpty(msg)) {
                    Logger.Instance.WriteServerToLog(msg);
                }
            }
            else {
                if (!NString.IsNullOrEmpty(msg)) {
                    msg = msg + " ";
                }
                msg = msg + "uploading " + requestContent.length + " bytes";
                Logger.Instance.WriteServerToLog(msg);
            }
        }
    }
}
HttpManager._instance = null;
HttpManager.DEFAULT_HTTP_COMMUNICATION_TIMEOUT = 5 * 1000;
HttpManager.DEFAULT_OFFLINE_HTTP_COMMUNICATION_TIMEOUT = 2 * 1000;
HttpManager._nativeHttpClient = null;
//# sourceMappingURL=data:application/json;base64,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