import { NString } from "@magic-xpa/mscorelib";
import { HttpClientBase } from "./HttpClientBase";
import { Logger, Logger_LogLevels, Logger_MessageDirection, Misc } from "@magic-xpa/utils";
import { HttpClientEvents } from "./HttpClientEvents";
export class HttpClientSync extends HttpClientBase {
    constructor() {
        super();
        this.httpRequest = null;
        this.headers = new Headers();
    }
    prepareRequest() {
    }
    addHeaders(urlString, useCache, httpHeaders, clientID) {
        if (!urlString.startsWith("/")) {
            this.headers.append("MgxpaRIAglobalUniqueSessionID", clientID);
        }
        if (!useCache) {
            this.headers.append("Cache-Control", "no-cache");
        }
        return httpHeaders;
    }
    async sendRequestToServer(httpMethod, urlString, httpHeaders, requestContent, contentFromServer) {
        await fetch(urlString, { method: 'POST', headers: this.headers, body: requestContent, keepalive: true });
        return NString.Empty;
    }
    logResponse(httpResponse, clientID, urlString, contentFromServer, timeBeforeRequest) {
        let responseTime = Misc.getSystemMilliseconds() - timeBeforeRequest;
        if (Logger.Instance.LogLevel === Logger_LogLevels.Basic)
            Logger.Instance.WriteBasicToLog(Logger_MessageDirection.MessageEntering, HttpClientEvents.GetRuntimeCtxID(), HttpClientEvents.GetSessionCounter(), clientID, HttpClientEvents.ShouldDisplayGenericError() ? "-" : new URL(urlString).host, responseTime, this.httpRequest.status.toString(), JSON.stringify(this.httpRequest.getAllResponseHeaders()), contentFromServer.value.length);
    }
    handleHttpErrorException(ex, urlString) {
        throw ex;
    }
    async shouldRetry(httpCommunicationTimeoutMS, urlString, communicationsFailureHandler, ex, startTimeRef) {
        return Promise.resolve(false);
    }
    logAndThrowException(ex) {
    }
    logExecutionAttempts(executionAttempts) {
    }
}
//# sourceMappingURL=data:application/json;base64,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