import { Encoding, NString } from "@magic-xpa/mscorelib";
import { Logger } from "@magic-xpa/utils";
export class HttpUtility {
    static ASCIIGetString(bytes) {
        return Encoding.ASCII.GetString(bytes, 0, bytes.length);
    }
    static IntToHexCharCode(n) {
        if (n <= 9)
            return n + 0x30;
        return (n - 10) + 0X61;
    }
    static IsSafe(ch) {
        if ((ch >= 'a' && ch <= 'z') ||
            (ch >= 'A' && ch <= 'Z') ||
            (ch >= '0' && ch <= '9'))
            return true;
        switch (ch) {
            case '\'':
            case '(':
            case ')':
            case '*':
            case '-':
            case '.':
            case '_':
            case '!':
                return true;
        }
        return false;
    }
    static UrlEncode(str, e) {
        let encodedStr = null;
        if (str !== null) {
            encodedStr = HttpUtility.ASCIIGetString(HttpUtility.UrlEncodeToBytes(str, e));
            Logger.Instance.WriteServerMessagesToLog(NString.Format("\n String: {0} \n UrlEncoded by: {1} \n To: {2}", str, e, encodedStr));
        }
        return encodedStr;
    }
    static UrlEncodeToBytes(str, e) {
        if (str === null) {
            return null;
        }
        let bytes = e.GetBytes(str);
        return HttpUtility.UrlEncodeBytesToBytesInternal(bytes, 0, bytes.length);
    }
    static UrlEncodeBytesToBytesInternal(bytes, offset, count) {
        if (!HttpUtility.EncodingEnabled) {
            return bytes;
        }
        let num = 0;
        let num2 = 0;
        for (let i = 0; i < count; i++) {
            let ch = String.fromCharCode(bytes[offset + i]);
            if (ch === ' ') {
                num = num++;
            }
            else if (!HttpUtility.IsSafe(ch)) {
                num2 = num2 + 1;
            }
        }
        if (num === 0 && num2 === 0) {
            return bytes;
        }
        let buffer = new Uint8Array(count + num2 * 2);
        let num4 = 0;
        for (let j = 0; j < count; j++) {
            let num6 = bytes[offset + j];
            let ch = String.fromCharCode(num6);
            if (HttpUtility.IsSafe(ch)) {
                buffer[num4++] = num6;
            }
            else if (ch === ' ') {
                buffer[num4++] = 0X2b;
            }
            else {
                buffer[num4++] = 0X25;
                buffer[num4++] = HttpUtility.IntToHexCharCode(num6 >> 4 & 15);
                buffer[num4++] = HttpUtility.IntToHexCharCode(num6 & 15);
            }
        }
        return buffer;
    }
}
HttpUtility.EncodingEnabled = true;
//# sourceMappingURL=data:application/json;base64,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