import { RemoteDataViewCommandBase } from "./RemoteDataViewCommandBase";
import { ResultValue } from "../rt/ResultValue";
import { CommandFactory } from "../commands/ClientToServer/CommandFactory";
import { RemoteCommandsProcessor } from "./RemoteCommandsProcessor";
import { CommandsProcessorBase_SendingInstruction, CommandsProcessorBase_SessionStage } from "../CommandsProcessorBase";
import { ReturnResult } from "../util/ReturnResult";
export class RemoteControlItemsRefreshCommand extends RemoteDataViewCommandBase {
    constructor(command) {
        super(command);
        this.control = null;
        this.control = command.Control;
    }
    async Execute() {
        let res = new ResultValue();
        let cmd = CommandFactory.CreatecFetchDataControlValuesCommand(this.Task.getTaskTag(), this.control.getName());
        this.Task.getMGData().CmdsToServer.Add(cmd);
        await RemoteCommandsProcessor.GetInstance().Execute_1(CommandsProcessorBase_SendingInstruction.TASKS_AND_COMMANDS, CommandsProcessorBase_SessionStage.NORMAL, res);
        for (let i = 0; i < this.Task.DataView.getSize(); i = i + 1) {
            this.Task.DataView.getRecByIdx(i).AddDcValuesReference(this.control.getDitIdx(), this.control.getDcRef());
        }
        this.Task.DataView.getOriginalRec().AddDcValuesReference(this.control.getDitIdx(), this.control.getDcRef());
        return new ReturnResult();
    }
}
//# sourceMappingURL=data:application/json;base64,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