import { DataViewCommandBase } from '../commands/DataViewCommandBase';
import { RemoteCommandsProcessor } from './RemoteCommandsProcessor';
import { CommandsProcessorBase_SendingInstruction } from '../CommandsProcessorBase';
import { ReturnResult } from '../util/ReturnResult';
import { ClientOriginatedCommandTaskTag } from '../commands/ClientOriginatedCommandTaskTag';
import { AccessHelper } from '../AccessHelper';
export class RemoteDataViewCommandBase extends DataViewCommandBase {
    constructor(command) {
        super();
        this.Command = null;
        this.Task = null;
        this.Command = command;
        if (command instanceof ClientOriginatedCommandTaskTag) {
            this.Task = AccessHelper.mgDataTable.GetTaskByID(command.TaskTag);
        }
    }
    async Execute() {
        let cmdsToServer = this.Task.getMGData().CmdsToServer;
        cmdsToServer.Add(this.Command);
        await RemoteCommandsProcessor.GetInstance().Execute(CommandsProcessorBase_SendingInstruction.TASKS_AND_COMMANDS);
        return new ReturnResult();
    }
}
//# sourceMappingURL=data:application/json;base64,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