import { RemoteDataViewCommandBase } from "./RemoteDataViewCommandBase";
import { DummyDataViewCommand } from "./RemoteInitDataViewCommand";
import { ExecOperCommand } from "../commands/ClientToServer/ExecOperCommand";
import { RemoteDataViewCommandUpdateNonModifiable } from "./RemoteDataViewCommandUpdateNonModifiable";
import { DataviewCommand, DataViewCommandType } from "../commands/ClientToServer/DataviewCommand";
import { SetTransactionStateRemoteDataViewCommand } from "./SetTransactionStateRemoteDataViewCommand";
import { AddUserRangeRemoteDataViewCommand } from "./AddUserRangeRemoteDataViewCommand";
import { ResetUserRangeRemoteDataviewCommand } from "./ResetUserRangeRemoteDataviewCommand";
import { AddUserLocateRemoteDataViewCommand } from "./AddUserLocateRemoteDataViewCommand";
import { ResetUserLocateRemoteDataviewCommand } from "./ResetUserLocateRemoteDataviewCommand";
import { AddUserSortRemoteDataViewCommand } from "./AddUserSortRemoteDataViewCommand";
import { ResetUserSortRemoteDataviewCommand } from "./ResetUserSortRemoteDataviewCommand";
import { RemoteControlItemsRefreshCommand } from "./RemoteControlItemsRefreshCommand";
import { ConstInterface } from "../ConstInterface";
export class RemoteDataViewCommandFactory {
    CreateDataViewCommand(command) {
        let remoteDataViewCommandBase = new DummyDataViewCommand(command);
        let execOperCommand = ((command instanceof ExecOperCommand) ? command : null);
        if (execOperCommand !== null && execOperCommand.Operation !== null && execOperCommand.Operation.getType() === ConstInterface.MG_OPER_UPDATE) {
            remoteDataViewCommandBase = new RemoteDataViewCommandUpdateNonModifiable(execOperCommand);
        }
        else {
            if (!(command instanceof DataviewCommand)) {
                remoteDataViewCommandBase = new RemoteDataViewCommandBase(command);
            }
            else {
                let dataviewCommand = ((command instanceof DataviewCommand) ? command : null);
                switch (dataviewCommand.CommandType) {
                    case DataViewCommandType.SetTransactionState:
                        remoteDataViewCommandBase = new SetTransactionStateRemoteDataViewCommand(dataviewCommand);
                        break;
                    case DataViewCommandType.AddUserRange:
                        remoteDataViewCommandBase = new AddUserRangeRemoteDataViewCommand(command);
                        break;
                    case DataViewCommandType.ResetUserRange:
                        remoteDataViewCommandBase = new ResetUserRangeRemoteDataviewCommand(command);
                        break;
                    case DataViewCommandType.AddUserLocate:
                        remoteDataViewCommandBase = new AddUserLocateRemoteDataViewCommand(command);
                        break;
                    case DataViewCommandType.ResetUserLocate:
                        remoteDataViewCommandBase = new ResetUserLocateRemoteDataviewCommand(command);
                        break;
                    case DataViewCommandType.AddUserSort:
                        remoteDataViewCommandBase = new AddUserSortRemoteDataViewCommand(command);
                        break;
                    case DataViewCommandType.ResetUserSort:
                        remoteDataViewCommandBase = new ResetUserSortRemoteDataviewCommand(command);
                        break;
                    case DataViewCommandType.ControlItemsRefresh:
                        remoteDataViewCommandBase = new RemoteControlItemsRefreshCommand(command);
                        break;
                }
            }
        }
        return remoteDataViewCommandBase;
    }
    constructor() {
    }
}
//# sourceMappingURL=data:application/json;base64,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