import { DataviewManagerBase } from "../data/DataviewManagerBase";
import { RemoteDataViewCommandFactory } from "./RemoteDataViewCommandFactory";
import { ReturnResult } from "../util/ReturnResult";
export class RemoteDataviewManager extends DataviewManagerBase {
    constructor(task) {
        super(task);
        this._remoteDataViewCommandFactory = null;
        this._remoteDataViewCommandFactory = new RemoteDataViewCommandFactory();
    }
    async Execute(command) {
        await super.Execute(command);
        let remoteDataViewCommandBase = this._remoteDataViewCommandFactory.CreateDataViewCommand(command);
        let innerResult = await remoteDataViewCommandBase.Execute();
        return new ReturnResult(innerResult);
    }
}
//# sourceMappingURL=data:application/json;base64,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