import { ApplicationException, NString, isNullOrUndefined } from "@magic-xpa/mscorelib";
import { MsgInterface, StrUtil } from "@magic-xpa/utils";
import { ServerConfig } from "../ServerConfig";
import { AccessHelper } from "../AccessHelper";
export class ServerError extends ApplicationException {
    constructor(msg, codeOrInnerException) {
        super(msg);
        this._code = 0;
        if (arguments.length === 1 || isNullOrUndefined(codeOrInnerException))
            return;
        if (typeof codeOrInnerException == 'number')
            this._code = codeOrInnerException;
        else
            this.InnerException = codeOrInnerException;
        this.errorLevel = 3;
    }
    GetCode() {
        return this._code;
    }
    GetMessage() {
        let message;
        let shouldDisplayGenericError = ServerConfig.Instance.ShouldDisplayGenericError();
        if (shouldDisplayGenericError && this.GetCode() > 0) {
            let genericErrorMessage = AccessHelper.languageData.getConstMessage(MsgInterface.STR_GENERIC_ERROR_MESSAGE);
            genericErrorMessage = StrUtil.replaceStringTokens(genericErrorMessage, "%d", 1, "{0}");
            message = NString.Format(genericErrorMessage, this.GetCode());
        }
        else
            message = this.Message;
        return message;
    }
}
ServerError.INF_NO_RESULT = -11;
ServerError.ERR_CTX_NOT_FOUND = -197;
ServerError.ERR_AUTHENTICATION = -157;
ServerError.ERR_ACCESS_DENIED = -133;
ServerError.ERR_WEBCLIENT_PROGRAM_RELOADED = -278;
ServerError.ERR_EXECUTED_PROGRAM_CHANGED = -283;
ServerError.ERR_THREAD_ABORTED = -138;
//# sourceMappingURL=data:application/json;base64,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