import { List } from '@magic-xpa/mscorelib';
import { Argument } from './Argument';
import { StrUtil } from '@magic-xpa/utils';
export class ArgumentsList {
    constructor(srcArgsOrExp_paramsOrArgument) {
        this._list = null;
        this.RefreshOnString = null;
        if (arguments.length === 0) {
            this.constructor_0();
            return;
        }
        if (arguments.length === 1 && (srcArgsOrExp_paramsOrArgument === null || srcArgsOrExp_paramsOrArgument instanceof Array)) {
            this.constructor_2(srcArgsOrExp_paramsOrArgument);
            return;
        }
        this.constructor_3(srcArgsOrExp_paramsOrArgument);
    }
    constructor_0() {
    }
    async Initialize(srcArgs) {
        this.constructor_0();
        if (srcArgs === null)
            this._list = null;
        else {
            this._list = new List();
            for (let i = 0; i < srcArgs.getSize(); i = i + 1) {
                let arg = new Argument(srcArgs.getArg(i));
                await arg.Initialize(srcArgs.getArg(i));
                this._list.push(arg);
            }
        }
    }
    constructor_2(Exp_params) {
        this.constructor_0();
        let argCnt = Exp_params.length;
        if (argCnt === 0)
            this._list = null;
        else {
            this._list = new List();
            for (let i = 0; i < argCnt; i = i + 1) {
                this._list.push(new Argument(Exp_params[i]));
            }
        }
    }
    constructor_3(argument) {
        this.Add(argument);
    }
    fillList(valueStr, srcTask) {
        let tok = StrUtil.tokenize(valueStr, "$");
        let size = tok.length;
        this._list = new List();
        for (let i = 0; i < size; i = i + 1) {
            let argument = new Argument();
            argument.fillData(tok[i], srcTask);
            this._list.push(argument);
        }
    }
    buildListFromParams(size, attrs, vals, nulls) {
        this._list = new List();
        for (let i = 0; i < size; i = i + 1) {
            let argument = new Argument();
            argument.fillDataByParams(attrs.charAt(i), vals[i], nulls.charAt(i) !== '0');
            this._list.push(argument);
        }
    }
    buildXML(message) {
        for (let i = 0; i < this._list.length; i = i + 1) {
            if (i > 0)
                message.Append('$');
            this._list.get_Item(i).buildXML(message);
        }
    }
    getSize() {
        return (this._list === null) ? 0 : this._list.length;
    }
    getArg(idx) {
        if (idx < 0 || idx >= this._list.length)
            return null;
        return this._list.get_Item(idx);
    }
    async getArgValue(idx, expType, expSize) {
        let arg = this.getArg(idx);
        if (arg === null)
            return null;
        return await arg.getValue(expType, expSize);
    }
    FillListFromString(argsString) {
        let pattern = new RegExp("(?<!\\\\),");
        let array = argsString.split(pattern);
        this._list = new List();
        for (let i = 0; i < array.length; i = i + 1) {
            let argument = new Argument();
            argument.FillFromString(array[i]);
            this._list.push(argument);
        }
    }
    Add(argument) {
        if (this._list === null)
            this._list = new List();
        this._list.push(argument);
    }
}
//# sourceMappingURL=data:application/json;base64,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