import { ExpressionEvaluator, NullValueException } from "../exp/ExpressionEvaluator";
import { DisplayConvertor, ExpVal } from "@magic-xpa/gui";
import { StorageAttribute, StrUtil } from "@magic-xpa/utils";
import { Char, NString } from "@magic-xpa/mscorelib";
export class Boundary {
    constructor(task, minIdx, maxIdx, returnType, size, cacheTableId) {
        this._cacheTableFldId = 0;
        this._max = null;
        this._min = null;
        this._retType = StorageAttribute.NONE;
        this._size = 0;
        this._maxExpVal = null;
        this._minExpVal = null;
        this.DiscardMin = false;
        this.DiscardMax = false;
        this.MaxEqualsMin = false;
        if (arguments.length === 5)
            this.constructor_0(task, minIdx, maxIdx, returnType, size);
        else
            this.constructor_1(task, minIdx, maxIdx, returnType, size, cacheTableId);
    }
    constructor_0(task, minIdx, maxIdx, returnType, size) {
        this.constructor_1(task, minIdx, maxIdx, returnType, size, -1);
    }
    constructor_1(task, minIdx, maxIdx, returnType, size, cacheTableId) {
        this._retType = returnType;
        this._size = size;
        this._cacheTableFldId = cacheTableId;
        if (minIdx !== -1)
            this._min = task.getExpById(minIdx);
        if (maxIdx !== -1)
            this._max = task.getExpById(maxIdx);
    }
    hasMinExp() {
        return this._min !== null;
    }
    hasMaxExp() {
        return this._max !== null;
    }
    getExpType() {
        return this._retType;
    }
    getCacheTableFldId() {
        return this._cacheTableFldId;
    }
    async compute(padValueWithMinMaxCharacters) {
        if (this.hasMinExp()) {
            let minVal = await this._min.evaluateWithResultTypeAndLength(this.getExpType(), this._size);
            if (minVal !== null) {
                minVal = NString.TrimEnd(minVal, new Array(0));
            }
            this._minExpVal = new ExpVal(this.getExpType(), minVal === null, minVal);
            this.MaxEqualsMin = this.IsMaxEqualsMin();
            if (!this._minExpVal.IsNull && (this._minExpVal.Attr === StorageAttribute.ALPHA || this._minExpVal.Attr === StorageAttribute.UNICODE)) {
                if (padValueWithMinMaxCharacters) {
                    this._minExpVal.StrVal = DisplayConvertor.StringValueToMgValue(this._minExpVal.StrVal, this._minExpVal.Attr, Char.MinValue, this._size).toString();
                    this.MaxEqualsMin = false;
                }
                this._minExpVal.StrVal = StrUtil.SearchAndReplaceWildChars(this._minExpVal.StrVal, this._size, Char.MinValue);
            }
            this.DiscardMin = await this._min.DiscardCndRangeResult();
        }
        if (this.hasMaxExp()) {
            let maxVal = await this._max.evaluateWithResultTypeAndLength(this.getExpType(), this._size);
            this._maxExpVal = new ExpVal(this.getExpType(), maxVal === null, maxVal);
            if (!this._maxExpVal.IsNull && (this._maxExpVal.Attr === StorageAttribute.ALPHA || this._maxExpVal.Attr === StorageAttribute.UNICODE)) {
                if (padValueWithMinMaxCharacters) {
                    this._maxExpVal.StrVal = DisplayConvertor.StringValueToMgValue(this._maxExpVal.StrVal, this._maxExpVal.Attr, Char.MaxValue, this._size);
                }
                this._maxExpVal.StrVal = StrUtil.SearchAndReplaceWildChars(this._maxExpVal.StrVal, this._size, Char.MaxValue);
            }
            this.DiscardMax = await this._max.DiscardCndRangeResult();
        }
    }
    checkRange(val, IsNull) {
        let res = true;
        let cmpVal = new ExpVal(this.getExpType(), IsNull, val);
        if (cmpVal.IsNull && ((this.hasMinExp() && this._minExpVal.IsNull) || (this.hasMaxExp() && this._maxExpVal.IsNull))) {
            res = true;
        }
        else {
            if (this.hasMinExp()) {
                if (!this._minExpVal.IsNull && !cmpVal.IsNull) {
                    try {
                        if (ExpressionEvaluator.val_cmp_any(cmpVal, this._minExpVal) < 0)
                            res = false;
                    }
                    catch (exception) {
                        if (exception instanceof NullValueException) {
                            res = false;
                        }
                        else
                            throw exception;
                    }
                }
                else {
                    if (cmpVal.IsNull !== this._minExpVal.IsNull)
                        res = false;
                }
            }
            if (this.hasMaxExp() && res) {
                if (!this._maxExpVal.IsNull && !cmpVal.IsNull) {
                    try {
                        if (ExpressionEvaluator.val_cmp_any(cmpVal, this._maxExpVal) > 0)
                            res = false;
                    }
                    catch (exception) {
                        if (exception instanceof NullValueException)
                            res = false;
                        else
                            throw exception;
                    }
                }
                else if (cmpVal.IsNull !== this._maxExpVal.IsNull)
                    res = false;
            }
        }
        return res;
    }
    IsMaxEqualsMin() {
        let result = false;
        if (this.hasMaxExp() && this.hasMinExp()) {
            if (this._min.getId() === this._max.getId()) {
                if (this._retType === StorageAttribute.ALPHA || this._retType === StorageAttribute.UNICODE)
                    result = !this.WildCharExist();
                else
                    result = true;
            }
        }
        return result;
    }
    WildCharExist() {
        let wildChars = ["*", "?"];
        let result = false;
        if (!this._minExpVal.IsNull) {
            let stringValue = this._minExpVal.StrVal;
            for (let i = 0; i < wildChars.length; i = i + 1) {
                if (stringValue.endsWith(wildChars[i])) {
                    result = true;
                    break;
                }
            }
        }
        return result;
    }
    toString() {
        return NString.Format("{{Boundary: {0}-{1}, {2}, {3}}}", [
            this._max, this._max, this._retType, this._size
        ]);
    }
}
//# sourceMappingURL=data:application/json;base64,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