import { Logger, StrUtil, XMLConstants, XmlParser } from "@magic-xpa/utils";
import { NString, NNumber } from "@magic-xpa/mscorelib";
import { ConstInterface } from "../ConstInterface";
export class CompMainPrgTable {
    constructor() {
        this._ctlIdxTab = null;
    }
    fillData(parser) {
        let endContext = parser.getXMLdata().indexOf(XMLConstants.TAG_TERM, parser.getCurrIndex());
        if (endContext !== -1 && endContext < parser.getXMLdata().length) {
            let tag = parser.getXMLsubstring(endContext);
            parser.add2CurrIndex(tag.indexOf(ConstInterface.MG_TAG_COMPMAINPRG) + ConstInterface.MG_TAG_COMPMAINPRG.length);
            let tokensVector = XmlParser.getTokens(parser.getXMLsubstring(endContext), XMLConstants.XML_ATTR_DELIM);
            Logger.Instance.WriteDevToLog("in CompMainPrg.FillData: " + tokensVector.toString());
            this.initElements(tokensVector);
            parser.setCurrIndex(endContext + XMLConstants.TAG_TERM.length);
            return;
        }
        Logger.Instance.WriteExceptionToLogWithMsg("in CompMainPrg.FillData() out of string bounds");
    }
    initElements(tokensVector) {
        for (let j = 0; j < tokensVector.length; j += 2) {
            let attribute = (tokensVector.get_Item(j));
            let valueStr = (tokensVector.get_Item(j + 1));
            if (attribute === XMLConstants.MG_ATTR_VALUE) {
                valueStr = StrUtil.DeleteStringsFromEnds(valueStr, "\"");
                this.initCtlIdxTab(valueStr);
            }
            else
                Logger.Instance.WriteExceptionToLogWithMsg(NString.Format("There is no such index in CompMainPrg. Add case to CompMainPrg.initElements for {0}", attribute));
        }
        Logger.Instance.WriteDevToLog("End CompMainPrg ");
    }
    initCtlIdxTab(val) {
        if (NString.IsNullOrEmpty(val))
            return;
        if (val.indexOf(",") !== -1)
            this._ctlIdxTab = StrUtil.tokenize(val, ",");
        else {
            this._ctlIdxTab = new Array(1);
            this._ctlIdxTab[0] = val;
        }
    }
    getCtlIdx(idx) {
        if (idx >= 0 && idx < this.getSize()) {
            let s = this._ctlIdxTab[idx];
            return NNumber.Parse(s);
        }
        return -1;
    }
    getIndexOf(ctlIdx) {
        let i;
        for (i = 0; i < this.getSize(); i++) {
            if (ctlIdx === this.getCtlIdx(i))
                return i;
        }
        return -1;
    }
    getSize() {
        if (this._ctlIdxTab === null)
            return 0;
        return this._ctlIdxTab.length;
    }
}
//# sourceMappingURL=data:application/json;base64,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