import { YesNoExp } from '../exp/YesNoExp';
import { NString, RefParam } from '@magic-xpa/mscorelib';
import { Logger, XMLConstants, XmlParser } from '@magic-xpa/utils';
import { ConstInterface } from '../ConstInterface';
export class DataviewHeaderBase {
    get ReturnField() {
        if (this.returnfield === null && this._retVal !== null)
            this.returnfield = this.Task.getFieldByValueStr(this._retVal);
        return this.returnfield;
    }
    get IsMainSource() {
        return this._id === -1;
    }
    get Task() {
        return this._task;
    }
    get Fields() {
        return this._task.DataView.GetFieldsTab().getLinkFields(this._id);
    }
    get Id() {
        return this._id;
    }
    get LinkEvaluateCondition() {
        return this._linkEvalCondition;
    }
    constructor(task) {
        this._cond = null;
        this._task = null;
        this.Loc = null;
        this._dir = '\0';
        this._id = 0;
        this._keyIdx = 0;
        this._retVal = null;
        this.returnfield = null;
        this.LinkStartAfterField = 0;
        this.KeyExpression = 0;
        this._task = task;
        this._keyIdx = -1;
        this._cond = new YesNoExp(true);
    }
    SetAttributes(attributes) {
        let keys = attributes.Keys;
        keys.forEach((text) => {
            this.setAttribute(text, attributes.get_Item(text));
        });
    }
    setAttribute(attribute, valueStr) {
        switch (attribute) {
            case XMLConstants.MG_ATTR_ID:
                this._id = XmlParser.getInt(valueStr);
                break;
            case ConstInterface.MG_ATTR_KEY:
                this._keyIdx = XmlParser.getInt(valueStr);
                break;
            case ConstInterface.MG_ATTR_KEY_EXP:
                this.KeyExpression = XmlParser.getInt(valueStr);
                break;
            case ConstInterface.MG_ATTR_DIR:
                this._dir = valueStr[0];
                break;
            case ConstInterface.MG_ATTR_COND:
            case ConstInterface.MG_ATTR_COND_RES:
                this._cond.setVal(this._task, valueStr);
                break;
            case ConstInterface.MG_ATTR_RET_VAL:
                this._retVal = valueStr;
                break;
            case ConstInterface.MG_ATTR_LINK_EVAL_CONDITION:
                this._linkEvalCondition = valueStr[0];
                break;
            case ConstInterface.MG_ATTR_LINK_MODE:
                this.Mode = valueStr[0];
                break;
            case ConstInterface.MG_ATTR_LINK_START:
                this.LinkStartAfterField = XmlParser.getInt(valueStr);
                break;
            default:
                Logger.Instance.WriteExceptionToLogWithMsg(NString.Format("Unrecognized attribute: '{0}'", attribute));
                break;
        }
    }
    async getLinkedRecord(curRec) {
        return Promise.resolve(true);
    }
    async InitLinkFields(currRec) {
        for (let i = 0; i < this.Fields.length; i++) {
            let field = this.Fields.get_Item(i);
            let isNull = new RefParam(field.isNull());
            let result = new RefParam(field.getValue(false));
            await field.getInitExpVal(result, isNull);
            currRec.SetFieldValue(field.getId(), isNull.value, result.value);
            field.invalidate(true, false);
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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