import { Hashtable, StringBuilder } from "@magic-xpa/mscorelib";
import { Logger, XMLConstants, XmlParser } from "@magic-xpa/utils";
import { DataviewHeadersSaxHandler } from "./DataviewHeadersSaxHandler";
import { RemoteDataviewHeader } from "./RemoteDataviewHeader";
import { ConstInterface } from "../ConstInterface";
export class DataviewHeaders {
    constructor(task) {
        this._dataviewHeaders = null;
        this._task = null;
        this._task = task;
        this._dataviewHeaders = new Hashtable();
    }
    fillData(parser) {
        while (this.initInnerObjects(parser, parser.getNextTag())) {
        }
    }
    initInnerObjects(parser, foundTagName) {
        if (foundTagName === null)
            return false;
        if (foundTagName === ConstInterface.MG_TAG_LINKS) {
            let endContext = parser.getXMLdata().indexOf(ConstInterface.MG_TAG_LINKS_END, parser.getCurrIndex()) + ConstInterface.MG_TAG_LINKS_END.length + 1;
            let xml = parser.getXMLsubstring(endContext);
            xml = XmlParser.escapeUrl(xml);
            new DataviewHeadersSaxHandler(this._task, this._dataviewHeaders, xml);
            parser.setCurrIndex(endContext + XMLConstants.TAG_CLOSE.length);
        }
        else
            Logger.Instance.WriteExceptionToLogWithMsg("There is no such tag in LinksTable.initInnerObjects(): " + foundTagName);
    }
    getDataviewHeaderById(linkId) {
        return this._dataviewHeaders.get_Item(linkId);
    }
    buildDbPosString() {
        if (this._dataviewHeaders.Count === 0) {
            return null;
        }
        let buf = new StringBuilder();
        let dataviewHeaders = this._dataviewHeaders.Values;
        while (dataviewHeaders.MoveNext()) {
            let curr = ((dataviewHeaders.Current instanceof RemoteDataviewHeader) ? dataviewHeaders.Current : null);
            if (curr !== null) {
                let currDbPosVal = curr.getLastFetchedDbPos();
                buf.Append("@");
                if (currDbPosVal !== null) {
                    buf.Append(currDbPosVal);
                }
            }
        }
        buf.Append("@");
        return buf.ToString();
    }
}
//# sourceMappingURL=data:application/json;base64,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