import { Dictionary, isNullOrUndefined } from "@magic-xpa/mscorelib";
import { JSON_Utils } from "@magic-xpa/utils";
import { DataviewHeaderFactory } from "./DataviewHeaderFactory";
import { ConstInterface } from "../ConstInterface";
export class DataviewHeadersSaxHandler {
    constructor(task, dataviewHeaders, xmlData) {
        this._dataviewHeaders = null;
        this._task = null;
        this._dataviewHeadersFactory = null;
        this._dataviewHeaders = dataviewHeaders;
        this._task = task;
        this._dataviewHeadersFactory = new DataviewHeaderFactory();
        JSON_Utils.JSONFromXML(xmlData, this.FillFromJSON.bind(this));
    }
    FillFromJSON(error, result) {
        if (error != null) {
            throw error;
        }
        let links = result[ConstInterface.MG_TAG_LINKS][ConstInterface.MG_TAG_LINK];
        if (!isNullOrUndefined(links) && links.constructor === Array) {
            for (let i = 0; i < links.length; i++) {
                let link = links[i]['$'];
                if (!isNullOrUndefined(link[ConstInterface.MG_ATTR_TABLE_INDEX])) {
                    let dataviewHeader = this._dataviewHeadersFactory.CreateDataviewHeaders(this._task);
                    let attributes = new Dictionary();
                    for (let key in link) {
                        if (key !== ConstInterface.MG_ATTR_TABLE_INDEX) {
                            attributes.Add(key, link[key]);
                        }
                    }
                    dataviewHeader.SetAttributes(attributes);
                    this._dataviewHeaders.set_Item(dataviewHeader.Id, dataviewHeader);
                }
            }
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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