import { NNumber, Stack, StringBuilder } from "@magic-xpa/mscorelib";
import { ExecutionStackEntry } from "./ExecutionStackEntry";
import { ConstInterface } from "../ConstInterface";
import { XMLConstants } from "@magic-xpa/utils";
export class ExecutionStack {
    constructor(inExecStack) {
        this._execStack = null;
        if (arguments.length === 0) {
            this.constructor_0();
            return;
        }
        this.constructor_1(inExecStack);
    }
    constructor_0() {
        this._execStack = new Stack();
    }
    constructor_1(inExecStack) {
        this._execStack = inExecStack.getStack().Clone();
    }
    getStack() {
        return this._execStack;
    }
    push(execEntryOrTaskId, handlerId, operIdx) {
        if (arguments.length === 1)
            this.push_0(execEntryOrTaskId);
        else
            this.push_1(execEntryOrTaskId, handlerId, operIdx);
    }
    push_0(execEntry) {
        this._execStack.push(execEntry);
    }
    push_1(taskId, handlerId, operIdx) {
        let execEntry = new ExecutionStackEntry(taskId, handlerId, operIdx);
        this._execStack.push(execEntry);
    }
    pop() {
        return this._execStack.pop();
    }
    empty() {
        return this._execStack.count() === 0;
    }
    clear() {
        this._execStack.Clear();
    }
    size() {
        return this._execStack.count();
    }
    Equals(execStackCmp) {
        let tmpExecStack = new ExecutionStack(this);
        let tmpExecStackCmp = new ExecutionStack(execStackCmp);
        let equalStacks = false;
        if (tmpExecStack.size() === tmpExecStackCmp.size()) {
            equalStacks = true;
            while (!tmpExecStack.empty() && equalStacks) {
                if (!tmpExecStack.pop().Equals(tmpExecStackCmp.pop()))
                    equalStacks = false;
            }
        }
        return equalStacks;
    }
    pushUpSideDown(inExecStack) {
        let tmpStack = new ExecutionStack(inExecStack);
        while (!tmpStack.empty()) {
            let tmpStackEntry = tmpStack.pop();
            this._execStack.push(tmpStackEntry);
        }
    }
    reverse() {
        let tmpExecStack = new ExecutionStack(this);
        this.clear();
        while (!tmpExecStack.empty()) {
            let tmpExecStackEntry = tmpExecStack.pop();
            this.push(tmpExecStackEntry);
        }
    }
    buildXML(message) {
        let forMessage = new StringBuilder();
        while (this._execStack.count() !== 0) {
            let ExecEntry = this._execStack.pop();
            let taskTag = NNumber.Parse(ExecEntry.TaskId);
            if (taskTag > ConstInterface.INITIAL_OFFLINE_TASK_TAG) {
                forMessage.Remove(0, forMessage.Length);
                continue;
            }
            forMessage.Append("\n " + XMLConstants.TAG_OPEN + ConstInterface.MG_TAG_EXEC_STACK_ENTRY);
            forMessage.Append(" " + XMLConstants.MG_ATTR_TASKID + "=\"" + ExecEntry.TaskId + "\"");
            forMessage.Append(" " + ConstInterface.MG_ATTR_HANDLERID + "=\"" + ExecEntry.HandlerId + "\"");
            forMessage.Append(" " + ConstInterface.MG_ATTR_OPER_IDX + "=\"" + ExecEntry.OperIdx + "\"");
            forMessage.Append(" " + XMLConstants.TAG_TERM);
        }
        message.Append(forMessage.ToString());
    }
}
//# sourceMappingURL=data:application/json;base64,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