import { List } from "@magic-xpa/mscorelib";
import { Logger, XMLConstants } from "@magic-xpa/utils";
import { EventHandler } from "../event/EventHandler";
import { GUIManager } from "../GUIManager";
import { ConstInterface } from "../ConstInterface";
export class HandlersTable {
    constructor() {
        this._handlers = null;
        this._handlers = new List();
    }
    fillData(taskRef, parser) {
        while (this.initInnerObjects(parser, parser.getNextTag(), taskRef)) {
        }
    }
    initInnerObjects(parser, foundTagName, taskRef) {
        if (foundTagName === null)
            return false;
        if (foundTagName === ConstInterface.MG_TAG_EVENTHANDLERS) {
            parser.setCurrIndex(parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex()) + 1);
        }
        else {
            if (foundTagName === ConstInterface.MG_TAG_HANDLER) {
                let eventHandler = new EventHandler();
                eventHandler.fillData(taskRef, parser);
                this._handlers.push(eventHandler);
            }
            else {
                if (foundTagName === '/' + ConstInterface.MG_TAG_EVENTHANDLERS) {
                    parser.setCurrIndex2EndOfTag();
                    return false;
                }
                Logger.Instance.WriteExceptionToLogWithMsg("There is no such tag in HandlersTable. Insert else if to HandlersTable.initInnerObjects for " + foundTagName);
                return false;
            }
        }
        return true;
    }
    add(handler) {
        this._handlers.push(handler);
    }
    remove(idx) {
        this._handlers.RemoveAt(idx);
    }
    insertAfter(handler, idx) {
        this._handlers.Insert(idx, handler);
    }
    getSize() {
        return this._handlers.length;
    }
    getHandler(idx) {
        if (idx < 0 || idx >= this._handlers.length)
            return null;
        return this._handlers.get_Item(idx);
    }
    hasExpressionHandler() {
        let found = false;
        for (let i = 0; i < this._handlers.length; i++) {
            let evt = this.getHandler(i).getEvent();
            if (evt.getType() === ConstInterface.EVENT_TYPE_EXPRESSION ||
                (evt.getType() === ConstInterface.EVENT_TYPE_USER && evt.getUserEventType() === ConstInterface.EVENT_TYPE_EXPRESSION))
                return true;
        }
        return found;
    }
    startTimers(mgd) {
        let guiManager = GUIManager.Instance;
        if (this._handlers !== null) {
            let timersVector = this.getTimersVector();
            for (let i = 0; i < timersVector.length; i++)
                guiManager.startTimer(mgd, timersVector.get_Item(i), false);
        }
    }
    getTimersVector() {
        let timers = new List();
        for (let i = 0; i < this._handlers.length; i++) {
            let timerEvt = this.getHandler(i).getEvent();
            let sec;
            if (timerEvt.getType() === ConstInterface.EVENT_TYPE_TIMER)
                sec = timerEvt.getSeconds();
            else
                sec = timerEvt.getSecondsOfUserEvent();
            let timerExists = false;
            for (let j = 0; j < timers.length; j++) {
                if (sec === timers.get_Item(j)) {
                    timerExists = true;
                    break;
                }
            }
            if (!timerExists) {
                timers.push(sec);
            }
        }
        return timers;
    }
}
//# sourceMappingURL=data:application/json;base64,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