import { Debug } from "@magic-xpa/mscorelib";
import { ControlTable } from "@magic-xpa/gui";
import { TasksTable } from "../tasks/TasksTable";
import { AccessHelper } from "../AccessHelper";
export class LastFocusedManager {
    constructor() {
        this._lastFocusedTasks = null;
        this.LastActionTime = 0;
    }
    Init(mgDataTable) {
        this._lastFocusedTasks = new TasksTable();
    }
    getCurrTask() {
        let rtEvnt = AccessHelper.eventsManager.getLastRtEvent();
        return (rtEvnt !== null && rtEvnt.getTask() !== null && rtEvnt.getTask().GetContextTask() !== null)
            ? this.getLastFocusedTask(rtEvnt.getTask().GetContextTask().getMgdID())
            : this.getLastFocusedTask();
    }
    getLastFocusedTask(mgdID) {
        if (arguments.length === 0)
            return this._lastFocusedTasks.getTask(AccessHelper.mgDataTable.currMgdID);
        else
            return this._lastFocusedTasks.getTask(mgdID);
    }
    setLastFocusedTask(iTask) {
        let task = iTask;
        let currMgdID = task.getMgdID();
        this._lastFocusedTasks.setTaskAt(task, currMgdID);
    }
    clean(index) {
        LastFocusedManager.deleteLastFocusedControlAt(index);
        if (this._lastFocusedTasks !== null) {
            this._lastFocusedTasks.setTaskAt(null, index);
        }
    }
    static getLastFocusedControl(mgdID) {
        if (arguments.length === 1)
            return LastFocusedManager.getLastFocusedControl_1(mgdID);
        else
            return LastFocusedManager.getLastFocusedControl_0();
    }
    static getLastFocusedControl_0() {
        return LastFocusedManager._lastFocusedControls.getCtrl(AccessHelper.mgDataTable.currMgdID);
    }
    static getLastFocusedControl_1(mgdID) {
        return LastFocusedManager._lastFocusedControls.getCtrl(mgdID);
    }
    static deleteLastFocusedControlAt(index) {
        if (LastFocusedManager._lastFocusedControls !== null && LastFocusedManager._lastFocusedControls.getCtrl(index) != null) {
            LastFocusedManager._lastFocusedControls.deleteControlAt(index);
        }
    }
    static setLastFocusedControlAt(ctrl, currMgdID) {
        LastFocusedManager._lastFocusedControls.setControlAt(ctrl, currMgdID);
    }
    static setLastFocusedControl(task, mgControl) {
        let currMgdID = task.getMgdID();
        Debug.Assert(mgControl === null || task === mgControl.getForm().getTask());
        LastFocusedManager.LastFocusMgdID = currMgdID;
        LastFocusedManager.setLastFocusedControlAt(mgControl, currMgdID);
        LastFocusedManager.Instance.setLastFocusedTask(task);
    }
}
LastFocusedManager.Instance = new LastFocusedManager();
LastFocusedManager._lastFocusedControls = new ControlTable();
LastFocusedManager.LastFocusMgdID = 0;
//# sourceMappingURL=data:application/json;base64,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