import { ApplicationException, Int32, List } from "@magic-xpa/mscorelib";
import { Operation } from "./Operation";
import { ConstInterface } from "../ConstInterface";
export class OperationTable {
    constructor() {
        this._operations = new List();
        this._firstBlockOperIdx = Int32.MaxValue;
    }
    fillData(taskRef, evtHandler, parser) {
        while (this.initInnerObjects(parser.getNextTag(), taskRef, evtHandler, parser)) {
        }
        for (let i = this._firstBlockOperIdx; i < this._operations.length; i = i + 1) {
            let operation = this._operations.get_Item(i);
            let operType = operation.getType();
            if (operType === ConstInterface.MG_OPER_LOOP || operType === ConstInterface.MG_OPER_BLOCK ||
                operType === ConstInterface.MG_OPER_ELSE) {
                let operIdx = this.serverId2operIdx(operation.getBlockClose(), i + 1);
                operation.setBlockClose(operIdx);
                operIdx = this.serverId2operIdx(operation.getBlockEnd(), operIdx);
                operation.setBlockEnd(operIdx);
            }
        }
    }
    initInnerObjects(foundTagName, taskRef, evtHandler, parser) {
        if (foundTagName != null && foundTagName === (ConstInterface.MG_TAG_OPER)) {
            let oper = new Operation();
            oper.fillData(taskRef, evtHandler, parser);
            this._operations.push(oper);
            if (this._firstBlockOperIdx === Int32.MaxValue
                && (oper.getType() === ConstInterface.MG_OPER_LOOP || oper.getType() === ConstInterface.MG_OPER_BLOCK))
                this._firstBlockOperIdx = this._operations.length - 1;
            return true;
        }
        return false;
    }
    getSize() {
        return this._operations.length;
    }
    getOperation(idx) {
        if (idx >= 0 && idx < this._operations.length)
            return this._operations.get_Item(idx);
        throw new ApplicationException("in OperationTable.getOperation() index out of bounds: " + idx);
    }
    serverId2operIdx(id, startFrom) {
        let operIdx = -1;
        for (let i = startFrom; i < this._operations.length; i = i + 1) {
            let operation = this._operations.get_Item(i);
            if (id === operation.getServerId()) {
                operIdx = i;
                break;
            }
        }
        return operIdx;
    }
    serverId2FollowingOperIdx(id, startFrom) {
        let operIdx = -1;
        for (let i = startFrom; i < this._operations.length; i = i + 1) {
            let operation = this._operations.get_Item(i);
            if (id < operation.getServerId()) {
                operIdx = i;
                break;
            }
        }
        return operIdx;
    }
}
//# sourceMappingURL=data:application/json;base64,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