import { NString } from "@magic-xpa/mscorelib";
import { Base64, Logger, XMLConstants, XmlParser } from "@magic-xpa/utils";
import { Recompute } from "./Recompute";
import { AccessHelper } from "../AccessHelper";
export class RecomputeTable {
    fillAttributes(parser) {
        let endContext = parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex());
        let Index = parser.getXMLdata().indexOf(XMLConstants.MG_TAG_RECOMPUTE, parser.getCurrIndex()) + XMLConstants.MG_TAG_RECOMPUTE.length;
        let task = null;
        let tokensVector = XmlParser.getTokens(parser.getXMLdata().substr(Index, endContext - Index), '"');
        for (let j = 0; j < tokensVector.length; j += 2) {
            let attribute = (tokensVector.get_Item(j));
            let valueStr = (tokensVector.get_Item(j + 1));
            if (attribute === XMLConstants.MG_ATTR_TASKID)
                task = AccessHelper.mgDataTable.GetTaskByID(valueStr);
            else
                Logger.Instance.WriteExceptionToLogWithMsg(NString.Format("Unrecognized attribute: '{0}'", attribute));
        }
        parser.setCurrIndex(parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex()) + 1);
        return task;
    }
    fillData(parser) {
        let task = this.fillAttributes(parser);
        if (task !== null) {
            Logger.Instance.WriteDevToLog("goes to refill recompute");
            this.fillData_1(task.DataView, task, parser);
        }
        else
            parser.setCurrIndex(parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex()) + 1);
    }
    fillData_1(dataView, task, parser) {
        if (parser.getNextTag() == XMLConstants.MG_TAG_RECOMPUTE) {
            let currrentIndex = parser.getCurrIndex();
            let encoded = parser.ReadContentOfCurrentElement().trim();
            let decoded = Base64.decode(encoded.substr(0, encoded.length).trim());
            let newXmlData = parser.getXMLdata().replace(encoded.trim(), decoded);
            parser.setXMLdata(newXmlData);
            parser.setCurrIndex(currrentIndex);
        }
        while (this.initInnerObjects(parser, parser.getNextTag(), dataView, task)) {
        }
    }
    initInnerObjects(parser, nameOfFound, dataView, task) {
        if (nameOfFound === null)
            return false;
        if (nameOfFound === XMLConstants.MG_TAG_RECOMPUTE)
            parser.setCurrIndex(parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex()) + 1);
        else if (nameOfFound === XMLConstants.MG_TAG_FLD) {
            let recompute = new Recompute();
            recompute.fillData(dataView, task, parser);
        }
        else if (nameOfFound === '/' + XMLConstants.MG_TAG_RECOMPUTE) {
            parser.setCurrIndex2EndOfTag();
            return false;
        }
        else {
            Logger.Instance.WriteExceptionToLogWithMsg("There is no such tag in <recompute>, add case to RecomputeTable.initInnerObjects for " + nameOfFound);
            return false;
        }
        return true;
    }
}
//# sourceMappingURL=data:application/json;base64,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