import { List } from "@magic-xpa/mscorelib";
import { StorageAttribute } from "@magic-xpa/utils";
import { DisplayConvertor, PIC } from "@magic-xpa/gui";
import { DataviewHeaderBase } from "./DataviewHeaderBase";
import { TableCache } from "./TableCache";
import { Record } from "../data/Record";
import { ConstInterface } from "../ConstInterface";
import { TableCacheManager } from "./TableCacheManager";
import { AccessHelper } from "../AccessHelper";
export class RemoteDataviewHeader extends DataviewHeaderBase {
    constructor(task) {
        super(task);
        this._table = null;
        this._lastFetchRecPos = null;
    }
    setAttribute(attribute, valueStr) {
        switch (attribute) {
            case ConstInterface.MG_ATTR_CACHED_TABLE:
                if (valueStr != "") {
                    if (TableCacheManager.Instance.TableExists(valueStr))
                        this._table = TableCacheManager.Instance.GetTableById(valueStr);
                    else {
                        this._table = new TableCache(valueStr);
                        TableCacheManager.Instance.InsertTable(this._table);
                    }
                }
                break;
            case ConstInterface.MG_ATTR_IDENT:
                if (valueStr != "")
                    this._table.SetTableIdent(valueStr);
                break;
            default:
                super.setAttribute(attribute, valueStr);
                break;
        }
    }
    async getLinkedRecord(curRec) {
        let lnkFlds = this._task.DataView.GetFieldsTab().getLinkFields(this._id);
        let ret = false;
        if (this._cond.getVal()) {
            if (this.Loc == null) {
                this.Loc = new List();
                for (let i = 0; i < lnkFlds.length; i++) {
                    let currLoc = lnkFlds.get_Item(i).Locate;
                    if (currLoc != null) {
                        this.Loc.push(currLoc);
                        await currLoc.compute(false);
                    }
                }
            }
            else {
                for (let i = 0; i < this.Loc.length; i++)
                    await this.Loc.get_Item(i).compute(false);
            }
            await this._table.SortTable(this._keyIdx, this._dir);
            let res = this._table.Fetch(this.Loc);
            if (res == null)
                await this.initRec(curRec, false);
            else {
                ret = true;
                await this.copyLinkFldToRec(curRec, lnkFlds, res, true);
            }
        }
        else
            await this.initRec(curRec, false);
        return ret;
    }
    async copyLinkFldToRec(curRec, linkFlds, tableRec, ret) {
        this._lastFetchRecPos = tableRec.getDbPosVal();
        for (let i = 0; i < linkFlds.length; i++) {
            let curFld = linkFlds.get_Item(i);
            curRec.setFieldValue(curFld.getId(), tableRec.GetFieldValue(curFld.CacheTableFldIdx), false);
            curRec.clearFlag(curFld.getId(), Record.FLAG_INVALID);
            curFld.invalidate(true, false);
        }
        await this.SetReturnValue(ret, true);
    }
    async initRec(currRec, ret) {
        this._lastFetchRecPos = "#";
        await this.InitLinkFields(currRec);
        let retFld = this.ReturnField;
        if (retFld != null) {
            currRec.setFieldValue(retFld.getId(), (ret ? "1" : "0"), false);
            retFld.invalidate(true, false);
        }
    }
    getLastFetchedDbPos() {
        return this._lastFetchRecPos;
    }
    async SetReturnValue(ret, recompute) {
        let returnField = this.ReturnField;
        if (returnField !== null) {
            let enforceVariableChange = returnField.getTask() !== this.Task;
            AccessHelper.eventsManager.pushNewExecStacks();
            let result = ret ? "1" : "0";
            if (returnField.getType() === StorageAttribute.NUMERIC)
                result = DisplayConvertor.Instance.toNum(result, new PIC(returnField.getPicture(), StorageAttribute.NUMERIC, 0), 0);
            await returnField.setValueAndStartRecompute(result, false, recompute, false, false, enforceVariableChange);
            AccessHelper.eventsManager.popNewExecStacks();
            if (!recompute)
                returnField.setModified();
            returnField.invalidate(true, false);
            if (returnField.getTask() !== this.Task)
                await returnField.updateDisplay();
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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