import { Misc } from '@magic-xpa/utils';
import { ApplicationException, Exception, Hashtable, List } from '@magic-xpa/mscorelib';
import { RuntimeContextBase } from '@magic-xpa/gui';
import { RemoteCommandsProcessor } from '../remote/RemoteCommandsProcessor';
export class TableCacheManager {
    constructor() {
        this._tables = null;
        this._tables = new Hashtable();
    }
    GetTableById(tableUId) {
        return this._tables.get_Item(tableUId);
    }
    TableExists(tableUId) {
        let result = true;
        if (this.GetTableById(tableUId) === null)
            result = false;
        return result;
    }
    InsertTable(table) {
        let result = false;
        if (!this.TableExists(table.GetTableUniqueId())) {
            this._tables.set_Item(table.GetTableUniqueId(), table);
            result = true;
        }
        return result;
    }
    async LoadTable(tableUId) {
        let server = RemoteCommandsProcessor.GetInstance();
        if (this.TableExists(tableUId)) {
            let current = this._tables.get_Item(tableUId);
            try {
                let residentTableContentStr = await server.GetContent(tableUId, true);
                try {
                    RuntimeContextBase.Instance.Parser.loadTableCacheData(residentTableContentStr);
                }
                catch (innerException) {
                    if (innerException instanceof Exception) {
                        throw new ApplicationException("Unable to parse resident table " + tableUId + ", due to unsupported encoding.", innerException);
                    }
                    else
                        throw innerException;
                }
            }
            catch (throwable) {
                if (throwable instanceof Exception) {
                    Misc.WriteStackTrace(throwable);
                }
                else
                    throw throwable;
            }
            current.FillData();
            let deletedUids = new List();
            let enumerator = this._tables.Values;
            while (enumerator.MoveNext()) {
                let tbl = enumerator.Current;
                let currIdent = tbl.GetTableCommonIdentifier();
                if (currIdent === current.GetTableCommonIdentifier() && tbl.GetTableUniqueId() !== tableUId)
                    deletedUids.push(tbl.GetTableUniqueId());
            }
            for (let i = 0; i < deletedUids.length; i = i + 1) {
                this._tables.Remove(deletedUids.get_Item(i));
            }
        }
    }
}
TableCacheManager.Instance = new TableCacheManager();
//# sourceMappingURL=data:application/json;base64,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