import { ConstInterface } from "../ConstInterface";
export class Transaction {
    constructor(task, setTransId) {
        this._transId = null;
        this._afterTransRetry = ConstInterface.RECOVERY_NONE;
        this._transBegin = '\0';
        this.Opened = false;
        this.OwnerTask = null;
        this.OwnerTask = task;
        this._transId = setTransId;
        this._transBegin = ConstInterface.TRANS_TASK_PREFIX;
    }
    isOwner(task) {
        return task === this.OwnerTask;
    }
    close() {
        this.Opened = false;
    }
    open() {
        this.Opened = true;
    }
    isOpened() {
        return this.Opened;
    }
    setAfterRetry(val) {
        this._afterTransRetry = val;
    }
    getAfterRetry(recovery) {
        if (arguments.length === 0) {
            return this.getAfterRetry_0();
        }
        return this.getAfterRetry_1(recovery);
    }
    getAfterRetry_0() {
        return this._afterTransRetry !== ConstInterface.RECOVERY_NONE;
    }
    getAfterRetry_1(recovery) {
        return this._afterTransRetry === recovery;
    }
    getLevel() {
        return this._transBegin;
    }
    setTransBegin(val) {
        this._transBegin = val;
    }
    getTransId() {
        return this._transId;
    }
    setOwnerTask(task) {
        this.OwnerTask = task;
    }
}
//# sourceMappingURL=data:application/json;base64,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