import { NString } from '@magic-xpa/mscorelib';
import { Logger, XMLConstants, XmlParser } from '@magic-xpa/utils';
import { ConstInterface } from '../ConstInterface';
import { Commands } from '@magic-xpa/gui';
export class UserDetails {
    setIsLoggedIn(value) {
        this.IsLoggedIn = value;
    }
    getIsLoggedIn() {
        return this.IsLoggedIn;
    }
    setUserID(userId) {
        this.UserID = userId;
        if (this.UserID.length == 0 || this.UserID === NString.Empty) {
            this.setIsLoggedIn(false);
        }
        else
            this.setIsLoggedIn(true);
    }
    static get Instance() {
        if (UserDetails._instance === null)
            UserDetails._instance = new UserDetails();
        return UserDetails._instance;
    }
    constructor() {
        this.UserName = null;
        this.UserID = null;
        this.UserInfo = null;
        this.Password = null;
        this.IsLoggedIn = false;
        this.UserName = NString.Empty;
        this.UserInfo = NString.Empty;
        this.IsLoggedIn = false;
        this.setUserID(NString.Empty);
    }
    fillData(parser) {
        let tokensVector;
        let endContext = parser.getXMLdata().indexOf(XMLConstants.TAG_TERM, parser.getCurrIndex());
        if (endContext !== -1 && endContext < parser.getXMLdata().length) {
            let tag = parser.getXMLsubstring(endContext);
            parser.add2CurrIndex(tag.indexOf(ConstInterface.MG_TAG_USER_DETAILS) + ConstInterface.MG_TAG_USER_DETAILS.length);
            tokensVector = XmlParser.getTokens(parser.getXMLsubstring(endContext), XMLConstants.XML_ATTR_DELIM);
            this.initElements(tokensVector);
            parser.setCurrIndex(endContext + XMLConstants.TAG_TERM.length);
        }
        else
            Logger.Instance.WriteExceptionToLogWithMsg("in UserDetails.fillData(): out of bounds");
    }
    initElements(tokensVector) {
        let attribute, valueStr;
        let isSuccess = true;
        let j;
        for (j = 0; j < tokensVector.length; j += 2) {
            attribute = tokensVector.get_Item(j);
            valueStr = tokensVector.get_Item(j + 1);
            switch (attribute) {
                case ConstInterface.MG_TAG_IS_LOGGED_IN:
                    this.setIsLoggedIn(valueStr[0] === '1');
                    Commands.addIsLoggedIn(this.getIsLoggedIn());
                    break;
                default:
                    Logger.Instance.WriteExceptionToLogWithMsg("in UserDetails.initElements(): unknown attribute: " + attribute);
                    isSuccess = false;
                    break;
            }
        }
        return isSuccess;
    }
}
UserDetails._instance = null;
//# sourceMappingURL=data:application/json;base64,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