import { HandlersTable } from "../rt/HandlersTable";
import { TasksTable } from "./TasksTable";
import { CompMainPrgTable } from "../rt/CompMainPrgTable";
import { Task } from "./Task";
import { Logger, XMLConstants, XmlParser } from "@magic-xpa/utils";
import { RecomputeTable } from "../rt/RecomputeTable";
import { Debug, NNumber } from "@magic-xpa/mscorelib";
import { RuntimeContextBase } from "@magic-xpa/gui";
import { GUIManager } from "../GUIManager";
import { HttpManager } from "../http/HttpManager";
import { FlowMonitorQueue } from "../util/FlowMonitorQueue";
import { RunTimeEvent } from "../event/RunTimeEvent";
import { ConstInterface } from "../ConstInterface";
import { LanguageData } from "../env/LanguageData";
import { EnvParamsTable } from "../env/EnvVariablesTable";
import { GlobalParams } from "../exp/GlobalParamsTable";
import { Environment } from "../env/Environment";
import { GlobalCommandsManager } from "../GlobalCommandsManager";
import { ServerConfig } from "../ServerConfig";
import { AccessHelper } from "../AccessHelper";
import { UserDetails } from "../security/UserDetails";
import { RemoteCommandsProcessor } from "../remote/RemoteCommandsProcessor";
export class MGData {
    get ForceModal() {
        return this.forceModal;
    }
    constructor(toClient, toServer, id, parent, isModal, forceModal) {
        this._expHandlers = null;
        this._id = 0;
        this._parent = null;
        this._mprgTab = null;
        this._tasksTab = null;
        this._timerHandlers = null;
        this._timersStarted = false;
        this.forceModal = false;
        this.CmdsToClient = null;
        this.CmdsToServer = null;
        this.IsModal = false;
        this.IsAborting = false;
        this.CmdsToServer = toClient;
        this.CmdsToClient = toServer;
        if (arguments.length === 5)
            this.constructor_0(id, parent, isModal);
        else
            this.constructor_1(id, parent, isModal, forceModal);
    }
    constructor_0(id, parent, isModal) {
        this._timerHandlers = new HandlersTable();
        this._expHandlers = new HandlersTable();
        this._mprgTab = new TasksTable();
        this._tasksTab = new TasksTable();
        this._id = id;
        this._parent = parent;
        if (AccessHelper.eventsManager.getCompMainPrgTab() === null) {
            let compMainPrgTab = new CompMainPrgTable();
            AccessHelper.eventsManager.setCompMainPrgTab(compMainPrgTab);
        }
        this.IsModal = isModal;
    }
    constructor_1(id, parent, isModal, forceModal) {
        this.constructor_0(id, parent, isModal);
        this.forceModal = forceModal;
    }
    GetId() {
        return this._id;
    }
    AlreadyMovedToFirstControl() {
        let alreadyMoved = false;
        let tasksCount = this.getTasksCount();
        for (let i = 0; i < tasksCount; i = i + 1) {
            let mgForm = this.getTask(i).getForm();
            if (mgForm !== null && mgForm.MovedToFirstControl) {
                alreadyMoved = true;
                break;
            }
        }
        return alreadyMoved;
    }
    StartTimers() {
        if (this._timerHandlers !== null && !this._timersStarted) {
            this._timerHandlers.startTimers(this);
            this._timersStarted = true;
        }
    }
    async fillData(openingTaskDetails, parser) {
        let canContinue;
        do {
            let nextTag = parser.getNextTag();
            canContinue = await this.initInnerObjects(parser, nextTag, openingTaskDetails);
        } while (canContinue);
        Logger.Instance.WriteDevToLog("MGData.FillData(): THE END of the parsing " + parser.getCurrIndex() + " characters");
    }
    async initInnerObjects(parser, foundTagName, openingTaskDetails) {
        if (foundTagName == null)
            return false;
        switch (foundTagName) {
            case XMLConstants.MG_TAG_XML:
                parser.setCurrIndex(parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex()) + 1);
                break;
            case ConstInterface.MG_TAG_DATAVIEW:
                if (!await this.insertDataView(parser)) {
                    let endContext = parser.getXMLdata().indexOf('/' + ConstInterface.MG_TAG_DATAVIEW, parser.getCurrIndex());
                    parser.setCurrIndex(endContext);
                    parser.setCurrIndex2EndOfTag();
                }
                break;
            case ConstInterface.MG_TAG_COMPLETE_DV:
                {
                    let task = null;
                    let endContext = parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex());
                    let index = parser.getXMLdata().indexOf(ConstInterface.MG_TAG_COMPLETE_DV, parser.getCurrIndex()) + ConstInterface.MG_TAG_COMPLETE_DV.length;
                    let tokensVector = XmlParser.getTokens(parser.getXMLdata().substr(index, endContext - index), '"');
                    let attribute = (tokensVector.get_Item(0));
                    let valueStr;
                    if (attribute === XMLConstants.MG_ATTR_TASKID) {
                        valueStr = (tokensVector.get_Item(1));
                        let taskId = valueStr;
                        if (this.getTask(taskId) === null)
                            task = AccessHelper.mgDataTable.GetTaskByID(taskId);
                        else
                            task = this.getTask(taskId);
                    }
                    let start = endContext + 1;
                    endContext = parser.getXMLdata().indexOf(XMLConstants.END_TAG + ConstInterface.MG_TAG_COMPLETE_DV, parser.getCurrIndex());
                    let dataViewContent = parser.getXMLdata().substr(start, endContext - start);
                    task.dataViewContent = dataViewContent;
                    parser.setCurrIndex(endContext);
                    parser.setCurrIndex2EndOfTag();
                }
                break;
            case ConstInterface.MG_TAG_CONTEXT: {
                let endContext = parser.getXMLdata().indexOf(XMLConstants.TAG_TERM, parser.getCurrIndex());
                if (endContext !== -1 && endContext < parser.getXMLdata().length) {
                    let tag = parser.getXMLsubstring(endContext);
                    parser.add2CurrIndex(tag.indexOf(ConstInterface.MG_TAG_CONTEXT) + ConstInterface.MG_TAG_CONTEXT.length);
                    parser.setCurrIndex(endContext + XMLConstants.TAG_TERM.length);
                }
                break;
            }
            case XMLConstants.MG_TAG_RECOMPUTE:
                let recompTab = new RecomputeTable();
                recompTab.fillData(parser);
                break;
            case ConstInterface.MG_TAG_COMMAND:
                Logger.Instance.WriteDevToLog("goes to command");
                this.CmdsToClient.fillData(parser);
                break;
            case ConstInterface.MG_TAG_LANGUAGE:
                Logger.Instance.WriteDevToLog("goes to language data");
                await LanguageData.Instance.fillData(parser);
                break;
            case ConstInterface.MG_TAG_KBDMAP_URL:
                Logger.Instance.WriteDevToLog("goes to keyBoard");
                await Environment.Instance.fillFromUrl(foundTagName, parser);
                break;
            case ConstInterface.MG_TAG_KBDMAP:
                break;
            case ConstInterface.MG_TAG_COMPMAINPRG:
                Logger.Instance.WriteDevToLog("goes to compmainprg");
                AccessHelper.eventsManager.getCompMainPrgTab().fillData(parser);
                break;
            case ConstInterface.MG_TAG_EVENTS_QUEUE:
                Logger.Instance.WriteDevToLog("goes to eventsqueue");
                this.fillEventsQueue(parser);
                break;
            case ConstInterface.MG_TAG_TASKURL:
                await Task.ProcessTaskURL();
                break;
            case XMLConstants.MG_TAG_TASK:
                Logger.Instance.WriteDevToLog("goes to task");
                let taskCountBefore = this._mprgTab.getSize();
                await this._mprgTab.fillData(this, openingTaskDetails, parser);
                if (this._id !== 0) {
                    let taskCountAfter = this._mprgTab.getSize();
                    let mgd0 = AccessHelper.mgDataTable.getMGData(0);
                    for (let taskIndex = taskCountBefore; taskIndex < taskCountAfter; taskIndex++) {
                        let newTask = this._mprgTab.getTask(taskIndex);
                        if (newTask.isMainProg() && mgd0._mprgTab.getTask(newTask.getTaskTag()) == null) {
                            mgd0._mprgTab.addTask(newTask);
                            mgd0.addTask(newTask);
                        }
                    }
                }
                break;
            case ConstInterface.MG_TAG_ENV:
                Logger.Instance.WriteDevToLog("goes to environment");
                Environment.Instance.fillData(parser);
                break;
            case ConstInterface.MG_TAG_FLWMTR_CONFIG:
                FlowMonitorQueue.Instance.fillData(parser);
                break;
            case XMLConstants.MG_TAG_XML_END:
                parser.setCurrIndex2EndOfTag();
                return false;
            case ConstInterface.MG_TAG_USER_DETAILS:
                UserDetails.Instance.fillData(parser);
                break;
            case ConstInterface.MG_TAG_DBH_REAL_IDXS:
                parser.SkipXMLElement();
                break;
            case ConstInterface.MG_TAG_GLOBALPARAMSCHANGES:
                Logger.Instance.WriteDevToLog("applying global params changes from the server (Set/GetParams)");
                GlobalParams.Instance.fillData(parser);
                break;
            case ConstInterface.MG_TAG_GLOBALPARAMS:
                Logger.Instance.WriteDevToLog("processing base64 encoded image of all global params from the server");
                this.fillGlobalParams(parser);
                break;
            case ConstInterface.MG_TAG_ENV_PARAM_URL:
                Logger.Instance.WriteDevToLog("goes to env params name ");
                await Environment.Instance.fillFromUrl(foundTagName, parser);
                break;
            case ConstInterface.MG_TAG_ENV_PARAM:
                Logger.Instance.WriteDevToLog("goes to env params name ");
                EnvParamsTable.Instance.fillData(parser);
                break;
            case ConstInterface.MG_TAG_CONTEXT_ID:
                {
                    let ctxId;
                    let ctxEndIdx;
                    parser.setCurrIndex(parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex()) + 1);
                    ctxEndIdx = parser.getXMLdata().indexOf(XMLConstants.TAG_OPEN, parser.getCurrIndex());
                    ctxId = parser.getXMLsubstring(ctxEndIdx).trim();
                    parser.setCurrIndex(ctxEndIdx);
                    parser.setCurrIndex2EndOfTag();
                    RuntimeContextBase.Instance.ContextID = ctxId;
                }
                break;
            case ConstInterface.MG_TAG_SESSION_ID:
                let sessionIdEndIdx;
                parser.setCurrIndex(parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex()) + 1);
                sessionIdEndIdx = parser.getXMLdata().indexOf(XMLConstants.TAG_OPEN, parser.getCurrIndex());
                RemoteCommandsProcessor.GetInstance().SessionId = parser.getXMLsubstring(sessionIdEndIdx).trim();
                parser.setCurrIndex(sessionIdEndIdx);
                parser.setCurrIndex2EndOfTag();
                break;
            case ConstInterface.MG_TAG_HTTP_COMMUNICATION_TIMEOUT:
                {
                    let httpCommunicationTimeout;
                    let httpCommunicationTimeoutIdx;
                    parser.setCurrIndex(parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex()) + 1);
                    httpCommunicationTimeoutIdx = parser.getXMLdata().indexOf(XMLConstants.TAG_OPEN, parser.getCurrIndex());
                    httpCommunicationTimeout = NNumber.Parse(parser.getXMLsubstring(httpCommunicationTimeoutIdx));
                    parser.setCurrIndex(httpCommunicationTimeoutIdx);
                    parser.setCurrIndex2EndOfTag();
                    HttpManager.GetInstance().HttpCommunicationTimeoutMS = httpCommunicationTimeout * 1000;
                }
                break;
            case ConstInterface.MG_TAG_DATABASE_URL:
            case ConstInterface.MG_TAG_DATABASES_HEADER:
            case ConstInterface.MG_TAG_TASKDEFINITION_IDS_URL:
            case ConstInterface.MG_TAG_DBH_DATA_IDS_URL:
            case ConstInterface.MG_TAG_DBHS_END:
            case ConstInterface.MG_TAG_OFFLINE_SNIPPETS_URL:
                parser.SkipXMLElement();
                break;
            case ConstInterface.MG_TAG_DBHS:
            case ConstInterface.MG_TAG_STARTUP_PROGRAM:
                parser.ReadContentOfCurrentElement();
                break;
            case XMLConstants.MG_TAG_MENUS_OPEN:
                break;
            default:
                Logger.Instance.WriteExceptionToLogWithMsg("There is no such tag name in MGData, add case to MGData.initInnerObjects and case to while of MGData.FillData  " + foundTagName);
                return false;
        }
        return true;
    }
    async insertDataView(parser) {
        let task = null;
        let endContext = parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex());
        let index = parser.getXMLdata().indexOf(ConstInterface.MG_TAG_DATAVIEW, parser.getCurrIndex()) + ConstInterface.MG_TAG_DATAVIEW.length;
        let tokensVector = XmlParser.getTokens(parser.getXMLdata().substr(index, endContext - index), '"');
        let invalidate = false;
        for (let i = 0; i < tokensVector.length; i = i + 2) {
            let attribute = tokensVector.get_Item(i);
            if (attribute === XMLConstants.MG_ATTR_TASKID) {
                let valueStr = tokensVector.get_Item(i + 1);
                let taskId = valueStr;
                task = (this.getTask(taskId) || AccessHelper.mgDataTable.GetTaskByID(taskId));
            }
            if (attribute === ConstInterface.MG_ATTR_INVALIDATE) {
                let valueStr = tokensVector.get_Item(i + 1);
                invalidate = XmlParser.getBoolean(valueStr);
                break;
            }
        }
        let result;
        if (task !== null) {
            await task.insertRecordTable(invalidate, parser);
            result = true;
        }
        else {
            result = false;
        }
        return result;
    }
    addTask(newTask) {
        this._tasksTab.addTask(newTask);
    }
    removeTask(task) {
        this._tasksTab.removeTask(task);
        this._mprgTab.removeTask(task);
    }
    getTasksCount() {
        let result;
        if (this._tasksTab !== null) {
            result = this._tasksTab.getSize();
        }
        else {
            result = 0;
        }
        return result;
    }
    getTask(taskIdOrIdx) {
        if (arguments.length === 1 && (taskIdOrIdx === null || typeof taskIdOrIdx === "undefined" || taskIdOrIdx.constructor === String)) {
            return this.getTask_0(taskIdOrIdx);
        }
        return this.getTask_1(taskIdOrIdx);
    }
    getTask_0(taskId) {
        let result;
        if (this._tasksTab !== null && typeof this._tasksTab !== "undefined") {
            result = this._tasksTab.getTask(taskId);
        }
        else {
            result = null;
        }
        return result;
    }
    getTask_1(idx) {
        return this._tasksTab.getTask(idx);
    }
    async buildXML(message, serializeTasks) {
        if (this.CmdsToServer !== null) {
            this.CmdsToServer.buildXML(message);
        }
        if (serializeTasks && this._tasksTab !== null) {
            await this._tasksTab.buildXML(message);
        }
    }
    getFirstTask() {
        let task = null;
        let MDIFrameTask = null;
        for (let i = 0; i < this._tasksTab.getSize(); i = i + 1) {
            task = this._tasksTab.getTask(i);
            if (!task.isMainProg()) {
                break;
            }
            task = null;
        }
        if (task === null && this._id === 0) {
            task = MDIFrameTask;
        }
        return task;
    }
    getMainProg(ctlIdx) {
        for (let i = 0; i < this._mprgTab.getSize(); i = i + 1) {
            let task = this._mprgTab.getTask(i);
            if (task.getCtlIdx() === ctlIdx && task.isMainProg()) {
                return task;
            }
        }
        return null;
    }
    getNextMainProg(ctlIdx) {
        let compMainPrgTab = AccessHelper.eventsManager.getCompMainPrgTab();
        let currSearchIndex = compMainPrgTab.getIndexOf(ctlIdx);
        let nextCtlIdx = compMainPrgTab.getCtlIdx(currSearchIndex + 1);
        let result;
        if (nextCtlIdx === -1) {
            result = null;
        }
        else {
            result = this.getMainProg(nextCtlIdx);
        }
        return result;
    }
    clientTransactionCacheExists() {
        let task;
        for (let i = 0; i < this._tasksTab.getSize(); i = i + 1) {
            task = this._tasksTab.getTask(i);
            if (!task.isMainProg() && task.DataView.modifiedRecordsNumber() > 0) {
                return true;
            }
        }
        return false;
    }
    serverTransactionCacheExists() {
        let task;
        for (let i = 0; i < this._tasksTab.getSize(); i = i + 1) {
            task = this._tasksTab.getTask(i);
            if (!task.isMainProg() && !task.DataView.ServerTransactionCacheEmpty) {
                return true;
            }
        }
        return false;
    }
    getTaskByTaskDefinitionID(taskDefinitionID) {
        let task;
        for (let i = 0; i < this._tasksTab.getSize(); i = i + 1) {
            task = this._tasksTab.getTask(i);
            if (task.TaskDefinitionId.Equals(taskDefinitionID)) {
                return task;
            }
        }
        return null;
    }
    getTimerHandlers() {
        return this._timerHandlers;
    }
    addTimerHandler(handler) {
        this._timerHandlers.add(handler);
    }
    removeTimerHandler(task) {
        for (let i = 0; i < this._timerHandlers.getSize();) {
            let timerTask = this._timerHandlers.getHandler(i).getTask();
            if (timerTask.isDescendentOf(task) && timerTask.getMGData() === this)
                this._timerHandlers.remove(i);
            else
                i++;
        }
    }
    removeExpressionHandler(task) {
        for (let i = 0; i < this._expHandlers.getSize();) {
            let timerTask = this._expHandlers.getHandler(i).getTask();
            if (timerTask.isDescendentOf(task) && timerTask.getMGData() === this)
                this._expHandlers.remove(i);
            else
                i++;
        }
    }
    getExpHandlers() {
        return this._expHandlers;
    }
    addExpHandler(handler, idx) {
        this._expHandlers.insertAfter(handler, idx);
    }
    changeTimers(oldTimers, newTimers) {
        let i = 0;
        let j = 0;
        let guiManager = GUIManager.Instance;
        oldTimers.sort();
        newTimers.sort();
        while (i < oldTimers.length && j < newTimers.length) {
            if (oldTimers.get_Item(i) > newTimers.get_Item(j)) {
                guiManager.startTimer(this, newTimers.get_Item(j), false);
                j = j + 1;
            }
            else {
                if (oldTimers.get_Item(i) < newTimers.get_Item(j)) {
                    guiManager.stopTimer(this, oldTimers.get_Item(i), false);
                    i = i + 1;
                }
                else {
                    i = i + 1;
                    j = j + 1;
                }
            }
        }
        while (i < oldTimers.length) {
            guiManager.stopTimer(this, oldTimers.get_Item(i), false);
            i = i + 1;
        }
        while (j < newTimers.length) {
            guiManager.startTimer(this, newTimers.get_Item(j), false);
            j = j + 1;
        }
    }
    fillEventsQueue(parser) {
        while (this.initEvents(parser, parser.getNextTag())) {
        }
    }
    initEvents(parser, foundTagName) {
        let result;
        if (foundTagName === null) {
            result = false;
        }
        else {
            if (foundTagName === ConstInterface.MG_TAG_EVENT) {
                let evt = new RunTimeEvent(null);
                evt.fillData(parser, null);
                evt.convertParamsToArgs();
                evt.setTask(null);
                evt.setFromServer();
                AccessHelper.eventsManager.addToTail(evt);
            }
            else {
                if (foundTagName === ConstInterface.MG_TAG_EVENTS_QUEUE) {
                    parser.setCurrIndex(parser.getXMLdata().indexOf(">", parser.getCurrIndex()) + 1);
                }
                else {
                    if (foundTagName === "/" + ConstInterface.MG_TAG_EVENTS_QUEUE) {
                        parser.setCurrIndex2EndOfTag();
                        result = false;
                        return result;
                    }
                    Logger.Instance.WriteExceptionToLogWithMsg("There is no such tag in EventsQueue: " + foundTagName);
                    result = false;
                    return result;
                }
            }
            result = true;
        }
        return result;
    }
    isMainWindow() {
        return this._parent === null;
    }
    getParentMGdata() {
        return this._parent;
    }
    abort() {
        this.IsAborting = true;
    }
    copyUnframedCmds() {
        let unframedCmds = GlobalCommandsManager.Instance.getUnframedCmds();
        for (let i = 0; i < unframedCmds.length; i = i + 1) {
            this.CmdsToClient.Add(unframedCmds.get_Item(i));
        }
        unframedCmds.SetSize(0);
    }
    getValidAncestor() {
        return this._parent;
    }
    getMaxCtlIdx() {
        let rc = 0;
        for (let i = 0; i < this._tasksTab.getSize(); i = i + 1) {
            let task = this._tasksTab.getTask(i);
            if (task !== null) {
                rc = Math.max(rc, task.getCtlIdx());
            }
        }
        return rc;
    }
    fillGlobalParams(parser) {
        let XMLdata = parser.getXMLdata();
        let endContext = parser.getXMLdata().indexOf(XMLConstants.TAG_TERM, parser.getCurrIndex());
        if (endContext !== -1 && endContext < XMLdata.length) {
            let tag = parser.getXMLsubstring(endContext);
            parser.add2CurrIndex(tag.indexOf(ConstInterface.MG_TAG_GLOBALPARAMS) + ConstInterface.MG_TAG_GLOBALPARAMS.length);
            let tokens = XmlParser.getTokens(RuntimeContextBase.Instance.Parser.getXMLsubstring(endContext), XMLConstants.XML_ATTR_DELIM);
            Debug.Assert(tokens.get_Item(0) === XMLConstants.MG_ATTR_VALUE);
            ServerConfig.Instance.setGlobalParams(tokens.get_Item(1));
            endContext = XMLdata.indexOf(XMLConstants.TAG_OPEN, endContext);
            if (endContext === -1)
                endContext = XMLdata.length;
            parser.setCurrIndex(endContext);
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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