import { Dictionary, List } from '@magic-xpa/mscorelib';
import { MgTimer } from '@magic-xpa/gui';
class TimerObjectCollection {
}
TimerObjectCollection.MgDataToTimerObjList = new Dictionary();
export class RCTimer extends MgTimer {
    get TimerIntervalMiliSeconds() {
        return this._timerIntervalMilliSeconds;
    }
    set IsIdleTimer(value) {
        this._isIdle = value;
    }
    get IsIdleTimer() {
        return this._isIdle;
    }
    constructor(mgData, milliseconds, isIdle) {
        super(milliseconds);
        this._mgData = null;
        this._isIdle = false;
        this._mgData = mgData;
        this.IsIdleTimer = isIdle;
        let mgDataId = this._mgData.GetId().toString();
        if (!TimerObjectCollection.MgDataToTimerObjList.ContainsKey(mgDataId))
            TimerObjectCollection.MgDataToTimerObjList.Add(mgDataId, new List());
        TimerObjectCollection.MgDataToTimerObjList.get_Item(mgDataId).push(this);
    }
    GetMgdata() {
        return this._mgData;
    }
    static StopTimer(mgData, milliseconds, isIdle) {
        let timers = null;
        let timer = null;
        let mgDataId = mgData.GetId().toString();
        if (TimerObjectCollection.MgDataToTimerObjList.ContainsKey(mgDataId)) {
            timers = TimerObjectCollection.MgDataToTimerObjList.get_Item(mgDataId);
            timer = timers.find(rcTimer => {
                return (rcTimer !== null) && (rcTimer._timerIntervalMilliSeconds === milliseconds && rcTimer._isIdle === isIdle);
            });
            if (timer != null) {
                timer.Stop();
                timers.Remove(timer);
            }
            if (timers.length === 0)
                TimerObjectCollection.MgDataToTimerObjList.Remove(mgDataId);
        }
    }
    static StopAll(mgData) {
        let timers = null;
        let mgDataId = mgData.GetId().toString();
        if (TimerObjectCollection.MgDataToTimerObjList.ContainsKey(mgDataId))
            timers = TimerObjectCollection.MgDataToTimerObjList.get_Item(mgDataId);
        if (timers !== null) {
            timers.forEach(rcTimer => {
                if (rcTimer !== null) {
                    rcTimer.Stop();
                }
            });
            timers.Clear();
            TimerObjectCollection.MgDataToTimerObjList.Remove(mgDataId);
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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