import { TaskServiceBase } from './TaskServiceBase';
import { ReturnResult } from '../util/ReturnResult';
import { MsgInterface, WindowType } from '@magic-xpa/utils';
export class RemoteTaskService extends TaskServiceBase {
    constructor() {
        super();
    }
    GetTaskTag(defaultValue) {
        return defaultValue;
    }
    GetDataviewManagerForVirtuals(task) {
        return task.DataviewManager.RemoteDataviewManager;
    }
    PrepareTask(task) {
        task.DataViewWasRetrieved = true;
        let result = super.PrepareTask(task);
        if (task.getMGData().IsModal && task.getForm() !== null) {
            task.getForm().ConcreteWindowType = WindowType.Overlay;
        }
        return result;
    }
    GetEventTaskId(originalTaskId) {
        return originalTaskId;
    }
    ShouldEvaluatePropertyLocally(propId) {
        return false;
    }
    InitTaskPrefixExecutedFlag(task) {
        task.TaskPrefixExecuted = true;
    }
    RemoveRecomputes(parentTask) {
        parentTask.DataView.GetFieldsTab().resetRecomp();
    }
    GetOwnerTransactionTask(task) {
        let OwnerTransactionTask = task;
        if (task.DataviewManager.RemoteDataviewManager.Transaction !== null)
            OwnerTransactionTask = task.DataviewManager.RemoteDataviewManager.Transaction.OwnerTask;
        return OwnerTransactionTask;
    }
    static async PreparePropMainDisplay(task) {
        await task.ComputeMainDisplay();
        return task.FormIsLegal() ? ReturnResult.SuccessfulResult : new ReturnResult(MsgInterface.BRKTAB_STR_ERR_FORM);
    }
}
//# sourceMappingURL=data:application/json;base64,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