import { ReturnResult } from "../util/ReturnResult";
import { PropInterface } from "@magic-xpa/gui";
export class TaskServiceBase {
    static CreateFirstRecord(task) {
        task.AfterFirstRecordPrefix = true;
    }
    PrepareTask(task) {
        return ReturnResult.SuccessfulResult;
    }
    static async PreparePropOpenTaskWindow(task) {
        let propOpenTaskWindow = task.getProp(PropInterface.PROP_TYPE_TASK_PROPERTIES_OPEN_TASK_WINDOW);
        let propOpenTaskWindowValue = false;
        if (!task.isMainProg() || task.getCtlIdx() === 0) {
            propOpenTaskWindowValue = await propOpenTaskWindow.getValueBoolean();
        }
        task.SetOpenWin(propOpenTaskWindowValue);
    }
    static async Exit(task, reversibleExit, subformDestination) {
        await task.Exit(reversibleExit, subformDestination);
    }
    GetOwnerTransactionTask(task) {
        return null;
    }
}
//# sourceMappingURL=data:application/json;base64,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