import { XMLConstants } from "@magic-xpa/utils";
import { List } from "@magic-xpa/mscorelib";
export class TasksTable {
    constructor() {
        this._tasks = null;
        this._tasks = new List();
    }
    async fillData(mgdata, openingTaskDetails, parser) {
        while (await this.initInnerObjects(parser.getNextTag(), mgdata, openingTaskDetails)) {
        }
    }
    async initInnerObjects(foundTagName, mgdata, openingTaskDetails) {
        let result;
        if (foundTagName === null) {
            result = false;
        }
        else {
            if (foundTagName === XMLConstants.MG_TAG_TASK) {
                let task = TasksTable.createNewtask();
                this._tasks.push(task);
                await task.fillData(mgdata, openingTaskDetails);
                result = true;
            }
            else {
                result = false;
            }
        }
        return result;
    }
    addTask(task) {
        this._tasks.push(task);
    }
    removeTask(task) {
        this._tasks.Remove(task);
    }
    getTask(tasktagOrIdx) {
        if (arguments.length === 1 && (tasktagOrIdx === null || typeof tasktagOrIdx === "undefined" || tasktagOrIdx.constructor === String)) {
            return this.getTask_0(tasktagOrIdx);
        }
        return this.getTask_1(tasktagOrIdx);
    }
    getTask_0(tasktag) {
        let result;
        for (let i = 0; i < this._tasks.length; i = i + 1) {
            let task = this._tasks.get_Item(i);
            if (tasktag === task.getTaskTag()) {
                result = task;
                return result;
            }
        }
        result = null;
        return result;
    }
    getTask_1(idx) {
        let result;
        if (idx >= 0 && idx < this._tasks.length) {
            result = this._tasks.get_Item(idx);
        }
        else {
            result = null;
        }
        return result;
    }
    getSize() {
        return this._tasks.length;
    }
    async buildXML(message) {
        for (let i = 0; i < this.getSize(); i = i + 1) {
            await this.getTask(i).buildXML(message);
        }
    }
    setTaskAt(task, index) {
        if (this._tasks.length <= index) {
            this._tasks.SetSize(index + 1);
        }
        this._tasks.set_Item(index, task);
    }
}
TasksTable.createNewtask = null;
//# sourceMappingURL=data:application/json;base64,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