import { List, NString } from '@magic-xpa/mscorelib';
import { Sort } from './Sort';
import { Logger, XMLConstants, XmlParser } from '@magic-xpa/utils';
import { ConstInterface } from '../../ConstInterface';
export class SortCollection {
    constructor() {
        this._sortTab = null;
        this._sortTab = new List();
    }
    fillData(parser) {
        while (this.initInnerObjects(parser, parser.getNextTag())) {
        }
    }
    initInnerObjects(parser, foundTagName) {
        if (foundTagName === null)
            return false;
        switch (foundTagName) {
            case ConstInterface.MG_TAG_SORTS:
                parser.setCurrIndex(parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex()) + 1);
                break;
            case ConstInterface.MG_TAG_SORT:
                {
                    let sort = new Sort();
                    this._sortTab.push(sort);
                    let endContext = parser.getXMLdata().indexOf(XMLConstants.TAG_TERM, parser.getCurrIndex());
                    if (endContext !== -1 && endContext < parser.getXMLdata().length) {
                        let tag = parser.getXMLsubstring(endContext);
                        parser.add2CurrIndex(tag.indexOf(ConstInterface.MG_TAG_SORT) + ConstInterface.MG_TAG_SORT.length);
                        let tokensVector = new List(XmlParser.getTokens(parser.getXMLsubstring(endContext), XMLConstants.XML_ATTR_DELIM).GetEnumerator());
                        this.InitElements(tokensVector, sort);
                        parser.setCurrIndex(endContext + XMLConstants.TAG_TERM.length);
                    }
                }
                break;
            case ConstInterface.MG_TAG_SORTS_END:
                parser.setCurrIndex2EndOfTag();
                return false;
        }
        return true;
    }
    InitElements(tokensVector, sort) {
        for (let j = 0; j < tokensVector.length; j += 2) {
            let attribute = (tokensVector.get_Item(j));
            let valueStr = (tokensVector.get_Item(j + 1));
            switch (attribute) {
                case XMLConstants.MG_ATTR_ID:
                    sort.fldIdx = XmlParser.getInt(valueStr);
                    break;
                case ConstInterface.MG_ATTR_DIR:
                    sort.dir = valueStr === "A";
                    break;
                default:
                    Logger.Instance.WriteExceptionToLogWithMsg(NString.Format("Unrecognized attribute: '{0}'", attribute));
                    break;
            }
        }
    }
    getSize() {
        if (this._sortTab === null)
            return 0;
        return this._sortTab.length;
    }
    add(sort) {
        this._sortTab.push(sort);
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiU29ydENvbGxlY3Rpb24uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9lbmdpbmUvc3JjL3Rhc2tzL3NvcnQvU29ydENvbGxlY3Rpb24udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUFDLElBQUksRUFBRSxPQUFPLEVBQUMsTUFBTSxzQkFBc0IsQ0FBQztBQUNuRCxPQUFPLEVBQUMsSUFBSSxFQUFDLE1BQU0sUUFBUSxDQUFDO0FBQzVCLE9BQU8sRUFBQyxNQUFNLEVBQUUsWUFBWSxFQUFFLFNBQVMsRUFBQyxNQUFNLGtCQUFrQixDQUFDO0FBQ2pFLE9BQU8sRUFBQyxjQUFjLEVBQUMsTUFBTSxzQkFBc0IsQ0FBQztBQUdwRCxNQUFNLE9BQU8sY0FBYztJQU16QjtRQUxRLGFBQVEsR0FBZSxJQUFJLENBQUM7UUFNbEMsSUFBSSxDQUFDLFFBQVEsR0FBRyxJQUFJLElBQUksRUFBUSxDQUFDO0lBQ25DLENBQUM7SUFLRCxRQUFRLENBQUMsTUFBaUI7UUFDeEIsT0FBTyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsTUFBTSxFQUFFLE1BQU0sQ0FBQyxVQUFVLEVBQUUsQ0FBQyxFQUFFO1NBQzFEO0lBQ0gsQ0FBQztJQU1ELGdCQUFnQixDQUFDLE1BQWlCLEVBQUUsWUFBb0I7UUFDdEQsSUFBSSxZQUFZLEtBQUssSUFBSTtZQUN2QixPQUFPLEtBQUssQ0FBQztRQUVmLFFBQVEsWUFBWSxFQUFFO1lBQ3BCLEtBQUssY0FBYyxDQUFDLFlBQVk7Z0JBQzlCLE1BQU0sQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLFVBQVUsRUFBRSxDQUFDLE9BQU8sQ0FBQyxZQUFZLENBQUMsU0FBUyxFQUFFLE1BQU0sQ0FBQyxZQUFZLEVBQUUsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDO2dCQUVwRyxNQUFNO1lBQ1IsS0FBSyxjQUFjLENBQUMsV0FBVztnQkFBRTtvQkFDL0IsSUFBSSxJQUFJLEdBQVMsSUFBSSxJQUFJLEVBQUUsQ0FBQztvQkFDNUIsSUFBSSxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7b0JBQ3pCLElBQUksVUFBVSxHQUFXLE1BQU0sQ0FBQyxVQUFVLEVBQUUsQ0FBQyxPQUFPLENBQUMsWUFBWSxDQUFDLFFBQVEsRUFBRSxNQUFNLENBQUMsWUFBWSxFQUFFLENBQUMsQ0FBQztvQkFFbkcsSUFBSSxVQUFVLEtBQUssQ0FBQyxDQUFDLElBQUksVUFBVSxHQUFHLE1BQU0sQ0FBQyxVQUFVLEVBQUUsQ0FBQyxNQUFNLEVBQUU7d0JBRWhFLElBQUksR0FBRyxHQUFXLE1BQU0sQ0FBQyxlQUFlLENBQUMsVUFBVSxDQUFDLENBQUM7d0JBQ3JELE1BQU0sQ0FBQyxhQUFhLENBQUMsR0FBRyxDQUFDLE9BQU8sQ0FBQyxjQUFjLENBQUMsV0FBVyxDQUFDLEdBQUcsY0FBYyxDQUFDLFdBQVcsQ0FBQyxNQUFNLENBQUMsQ0FBQzt3QkFFbEcsSUFBSSxZQUFZLEdBQWlCLElBQUksSUFBSSxDQUFTLFNBQVMsQ0FBQyxTQUFTLENBQUMsTUFBTSxDQUFDLGVBQWUsQ0FBQyxVQUFVLENBQUMsRUFBRSxZQUFZLENBQUMsY0FBYyxDQUFDLENBQUMsYUFBYSxFQUFFLENBQUMsQ0FBQzt3QkFFeEosSUFBSSxDQUFDLFlBQVksQ0FBQyxZQUFZLEVBQUUsSUFBSSxDQUFDLENBQUM7d0JBQ3RDLE1BQU0sQ0FBQyxZQUFZLENBQUMsVUFBVSxHQUFHLFlBQVksQ0FBQyxRQUFRLENBQUMsTUFBTSxDQUFDLENBQUM7cUJBQ2hFO2lCQUNGO2dCQUNDLE1BQU07WUFFUixLQUFLLGNBQWMsQ0FBQyxnQkFBZ0I7Z0JBQ2xDLE1BQU0sQ0FBQyxxQkFBcUIsRUFBRSxDQUFDO2dCQUMvQixPQUFPLEtBQUssQ0FBQztTQUNoQjtRQUNELE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUtPLFlBQVksQ0FBQyxZQUEwQixFQUFFLElBQVU7UUFDekQsS0FBSyxJQUFJLENBQUMsR0FBVyxDQUFDLEVBQUUsQ0FBQyxHQUFHLFlBQVksQ0FBQyxNQUFNLEVBQUUsQ0FBQyxJQUFJLENBQUMsRUFBRTtZQUV2RCxJQUFJLFNBQVMsR0FBVyxDQUFDLFlBQVksQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztZQUNuRCxJQUFJLFFBQVEsR0FBVyxDQUFDLFlBQVksQ0FBQyxRQUFRLENBQUMsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUM7WUFFdEQsUUFBUSxTQUFTLEVBQUU7Z0JBQ2pCLEtBQUssWUFBWSxDQUFDLFVBQVU7b0JBQzFCLElBQUksQ0FBQyxNQUFNLEdBQUcsU0FBUyxDQUFDLE1BQU0sQ0FBQyxRQUFRLENBQUMsQ0FBQztvQkFDekMsTUFBTTtnQkFDUixLQUFLLGNBQWMsQ0FBQyxXQUFXO29CQUM3QixJQUFJLENBQUMsR0FBRyxHQUFHLFFBQVEsS0FBSyxHQUFHLENBQUM7b0JBQzVCLE1BQU07Z0JBQ1I7b0JBQ0UsTUFBTSxDQUFDLFFBQVEsQ0FBQywwQkFBMEIsQ0FBQyxPQUFPLENBQUMsTUFBTSxDQUFDLCtCQUErQixFQUFFLFNBQVMsQ0FBQyxDQUFDLENBQUM7b0JBQ3ZHLE1BQU07YUFDVDtTQUNGO0lBQ0gsQ0FBQztJQU1ELE9BQU87UUFDTCxJQUFJLElBQUksQ0FBQyxRQUFRLEtBQUssSUFBSTtZQUN4QixPQUFPLENBQUMsQ0FBQztRQUNYLE9BQU8sSUFBSSxDQUFDLFFBQVEsQ0FBQyxNQUFNLENBQUM7SUFDOUIsQ0FBQztJQU1ELEdBQUcsQ0FBQyxJQUFVO1FBQ1osSUFBSSxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDM0IsQ0FBQztDQUNGIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHtMaXN0LCBOU3RyaW5nfSBmcm9tICdAbWFnaWMteHBhL21zY29yZWxpYic7XHJcbmltcG9ydCB7U29ydH0gZnJvbSAnLi9Tb3J0JztcclxuaW1wb3J0IHtMb2dnZXIsIFhNTENvbnN0YW50cywgWG1sUGFyc2VyfSBmcm9tICdAbWFnaWMteHBhL3V0aWxzJztcclxuaW1wb3J0IHtDb25zdEludGVyZmFjZX0gZnJvbSAnLi4vLi4vQ29uc3RJbnRlcmZhY2UnO1xyXG5cclxuLy8gVGhpcyB3aWxsIGhvbGQgcnVudGltZSBzb3J0cyBhZGRlZCBvbiB0YXNrLlxyXG5leHBvcnQgY2xhc3MgU29ydENvbGxlY3Rpb24ge1xyXG4gIHByaXZhdGUgX3NvcnRUYWI6IExpc3Q8U29ydD4gPSBudWxsO1xyXG5cclxuICAvLy8gPHN1bW1hcnk+XHJcbiAgLy8vICAgQ1RPUlxyXG4gIC8vLyA8L3N1bW1hcnk+XHJcbiAgY29uc3RydWN0b3IoKSB7XHJcbiAgICB0aGlzLl9zb3J0VGFiID0gbmV3IExpc3Q8U29ydD4oKTtcclxuICB9XHJcblxyXG4gIC8vLyA8c3VtbWFyeT5cclxuICAvLy8gICBwYXJzZSBpbnB1dCBzdHJpbmcgYW5kIGZpbGwgaW5uZXIgZGF0YSA6IFZlY3RvciBSVFNvcnRUYWJcclxuICAvLy8gPC9zdW1tYXJ5PlxyXG4gIGZpbGxEYXRhKHBhcnNlcjogWG1sUGFyc2VyKTogdm9pZCB7XHJcbiAgICB3aGlsZSAodGhpcy5pbml0SW5uZXJPYmplY3RzKHBhcnNlciwgcGFyc2VyLmdldE5leHRUYWcoKSkpIHtcclxuICAgIH1cclxuICB9XHJcblxyXG4gIC8vLyA8c3VtbWFyeT5cclxuICAvLy8gICBhbGxvY2F0ZSBhbmQgZmlsbCBpbm5lciBvYmplY3RzIG9mIHRoZSBjbGFzc1xyXG4gIC8vLyA8L3N1bW1hcnk+XHJcbiAgLy8vIDxwYXJhbSBuYW1lID0gXCJmb3VuZFRhZ05hbWVcIj5wb3NzaWJsZSAgdGFnIG5hbWUsIG5hbWUgb2Ygb2JqZWN0LCB3aGljaCBuZWVkIGJlIGFsbG9jYXRlZCA8L3BhcmFtPlxyXG4gIGluaXRJbm5lck9iamVjdHMocGFyc2VyOiBYbWxQYXJzZXIsIGZvdW5kVGFnTmFtZTogc3RyaW5nKTogYm9vbGVhbiB7XHJcbiAgICBpZiAoZm91bmRUYWdOYW1lID09PSBudWxsKVxyXG4gICAgICByZXR1cm4gZmFsc2U7XHJcblxyXG4gICAgc3dpdGNoIChmb3VuZFRhZ05hbWUpIHtcclxuICAgICAgY2FzZSBDb25zdEludGVyZmFjZS5NR19UQUdfU09SVFM6XHJcbiAgICAgICAgcGFyc2VyLnNldEN1cnJJbmRleChwYXJzZXIuZ2V0WE1MZGF0YSgpLmluZGV4T2YoWE1MQ29uc3RhbnRzLlRBR19DTE9TRSwgcGFyc2VyLmdldEN1cnJJbmRleCgpKSArIDEpO1xyXG4gICAgICAgIC8vIGVuZCBvZiBvdXRlciB0YWcgYW5kIGl0cyBcIj5cIlxyXG4gICAgICAgIGJyZWFrO1xyXG4gICAgICBjYXNlIENvbnN0SW50ZXJmYWNlLk1HX1RBR19TT1JUOiB7XHJcbiAgICAgICAgbGV0IHNvcnQ6IFNvcnQgPSBuZXcgU29ydCgpO1xyXG4gICAgICAgIHRoaXMuX3NvcnRUYWIucHVzaChzb3J0KTtcclxuICAgICAgICBsZXQgZW5kQ29udGV4dDogbnVtYmVyID0gcGFyc2VyLmdldFhNTGRhdGEoKS5pbmRleE9mKFhNTENvbnN0YW50cy5UQUdfVEVSTSwgcGFyc2VyLmdldEN1cnJJbmRleCgpKTtcclxuXHJcbiAgICAgICAgaWYgKGVuZENvbnRleHQgIT09IC0xICYmIGVuZENvbnRleHQgPCBwYXJzZXIuZ2V0WE1MZGF0YSgpLmxlbmd0aCkge1xyXG4gICAgICAgICAgLy8gbGFzdCBwb3NpdGlvbiBvZiBpdHMgdGFnXHJcbiAgICAgICAgICBsZXQgdGFnOiBTdHJpbmcgPSBwYXJzZXIuZ2V0WE1Mc3Vic3RyaW5nKGVuZENvbnRleHQpO1xyXG4gICAgICAgICAgcGFyc2VyLmFkZDJDdXJySW5kZXgodGFnLmluZGV4T2YoQ29uc3RJbnRlcmZhY2UuTUdfVEFHX1NPUlQpICsgQ29uc3RJbnRlcmZhY2UuTUdfVEFHX1NPUlQubGVuZ3RoKTtcclxuXHJcbiAgICAgICAgICBsZXQgdG9rZW5zVmVjdG9yOiBMaXN0PHN0cmluZz4gPSBuZXcgTGlzdDxzdHJpbmc+KFhtbFBhcnNlci5nZXRUb2tlbnMocGFyc2VyLmdldFhNTHN1YnN0cmluZyhlbmRDb250ZXh0KSwgWE1MQ29uc3RhbnRzLlhNTF9BVFRSX0RFTElNKS5HZXRFbnVtZXJhdG9yKCkpO1xyXG4gICAgICAgICAgLy8gcGFyc2UgZWFjaCBjb2x1bW5cclxuICAgICAgICAgIHRoaXMuSW5pdEVsZW1lbnRzKHRva2Vuc1ZlY3Rvciwgc29ydCk7XHJcbiAgICAgICAgICBwYXJzZXIuc2V0Q3VyckluZGV4KGVuZENvbnRleHQgKyBYTUxDb25zdGFudHMuVEFHX1RFUk0ubGVuZ3RoKTsgLy8gdG8gZGVsZXRlIFwiLz5cIiB0b29cclxuICAgICAgICB9XHJcbiAgICAgIH1cclxuICAgICAgICBicmVhaztcclxuXHJcbiAgICAgIGNhc2UgQ29uc3RJbnRlcmZhY2UuTUdfVEFHX1NPUlRTX0VORDpcclxuICAgICAgICBwYXJzZXIuc2V0Q3VyckluZGV4MkVuZE9mVGFnKCk7XHJcbiAgICAgICAgcmV0dXJuIGZhbHNlO1xyXG4gICAgfVxyXG4gICAgcmV0dXJuIHRydWU7XHJcbiAgfVxyXG5cclxuICAvLy8gPHN1bW1hcnk+XHJcbiAgLy8vICAgdXNlZCB0byBwYXJzZSBlYWNoIGNvbHVtbiB4bWwgdGFnIGF0dHJpYnV0ZXMgdGhlIGNvbHVtbiByZXByZXNlbnRzIGEgc2VnbWVudCBpbiB0aGUga2V5XHJcbiAgLy8vIDwvc3VtbWFyeT5cclxuICBwcml2YXRlIEluaXRFbGVtZW50cyh0b2tlbnNWZWN0b3I6IExpc3Q8c3RyaW5nPiwgc29ydDogU29ydCk6IHZvaWQge1xyXG4gICAgZm9yIChsZXQgajogbnVtYmVyID0gMDsgaiA8IHRva2Vuc1ZlY3Rvci5sZW5ndGg7IGogKz0gMikge1xyXG5cclxuICAgICAgbGV0IGF0dHJpYnV0ZTogc3RyaW5nID0gKHRva2Vuc1ZlY3Rvci5nZXRfSXRlbShqKSk7XHJcbiAgICAgIGxldCB2YWx1ZVN0cjogc3RyaW5nID0gKHRva2Vuc1ZlY3Rvci5nZXRfSXRlbShqICsgMSkpO1xyXG5cclxuICAgICAgc3dpdGNoIChhdHRyaWJ1dGUpIHtcclxuICAgICAgICBjYXNlIFhNTENvbnN0YW50cy5NR19BVFRSX0lEOiAvLyBzb3J0IHNlZ21lbnQgaS5lLiBmbGRJZHhcclxuICAgICAgICAgIHNvcnQuZmxkSWR4ID0gWG1sUGFyc2VyLmdldEludCh2YWx1ZVN0cik7XHJcbiAgICAgICAgICBicmVhaztcclxuICAgICAgICBjYXNlIENvbnN0SW50ZXJmYWNlLk1HX0FUVFJfRElSOiAvLyBkaXJlY3Rpb24gb2Ygc29ydCBzZWdtZW50XHJcbiAgICAgICAgICBzb3J0LmRpciA9IHZhbHVlU3RyID09PSBcIkFcIjtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGRlZmF1bHQ6XHJcbiAgICAgICAgICBMb2dnZXIuSW5zdGFuY2UuV3JpdGVFeGNlcHRpb25Ub0xvZ1dpdGhNc2coTlN0cmluZy5Gb3JtYXQoXCJVbnJlY29nbml6ZWQgYXR0cmlidXRlOiAnezB9J1wiLCBhdHRyaWJ1dGUpKTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICB9XHJcbiAgICB9XHJcbiAgfVxyXG5cclxuXHJcbiAgLy8vIDxzdW1tYXJ5PlxyXG4gIC8vLyAgIGdldCBzaXplIG9mIHRoZSBzb3J0IHRhYmxlXHJcbiAgLy8vIDwvc3VtbWFyeT5cclxuICBnZXRTaXplKCk6IG51bWJlciB7XHJcbiAgICBpZiAodGhpcy5fc29ydFRhYiA9PT0gbnVsbClcclxuICAgICAgcmV0dXJuIDA7XHJcbiAgICByZXR1cm4gdGhpcy5fc29ydFRhYi5sZW5ndGg7XHJcbiAgfVxyXG5cclxuICAvLy8gPHN1bW1hcnk+XHJcbiAgLy8vICAgYWRkIFNvcnQgdG8gIFNvcnQgY29sbGVjdGlvbi5cclxuICAvLy8gPC9zdW1tYXJ5PlxyXG4gIC8vLyA8cGFyYW0gbmFtZSA9IFwic29ydFwiPlNvcnQgdG8gYmUgYWRkZWQgPC9wYXJhbT5cclxuICBhZGQoc29ydDogU29ydCk6IHZvaWQge1xyXG4gICAgdGhpcy5fc29ydFRhYi5wdXNoKHNvcnQpO1xyXG4gIH1cclxufVxyXG4iXX0=