import { MgPriorityQueue } from "./MgPriorityQueue";
import { RunTimeEventBase } from "../event/RunTimeEventBase";
import { Misc, Priority, SyncExecutionHelper } from "@magic-xpa/utils";
import { Debug, Int32 } from "@magic-xpa/mscorelib";
export class MgPriorityBlockingQueue {
    constructor() {
        this._queue = null;
        this._timeFirstEvent = 0;
        this._queue = new MgPriorityQueue();
    }
    isBackgroundEvent(o) {
        let result = false;
        if (o instanceof RunTimeEventBase) {
            let runTimeEvent = o;
            if (runTimeEvent.getPriority() === Priority.LOWEST)
                result = true;
        }
        return result;
    }
    offer(o) {
        try {
            let condition = this._queue.offer(o);
            if (this._timeFirstEvent === 0) {
                if (!this.isBackgroundEvent(o)) {
                    this._timeFirstEvent = Misc.getSystemMilliseconds();
                }
            }
            Debug.Assert(condition);
            SyncExecutionHelper.Instance.Pulse();
            return true;
        }
        finally { }
    }
    put(o) {
        this.offer(o);
    }
    async waitForElement() {
        if (this._queue.Size === 0) {
            this._timeFirstEvent = 0;
            await SyncExecutionHelper.Instance.Wait();
        }
    }
    GetTime() {
        return this._timeFirstEvent;
    }
    poll() {
        let result;
        try {
            let obj = this._queue.poll();
            if (this.isBackgroundEvent(obj)) {
                this._timeFirstEvent = 0;
            }
            result = obj;
        }
        finally { }
        return result;
    }
    peek() {
        return this._queue.peek();
    }
    size() {
        return this._queue.Size;
    }
    remainingCapacity() {
        return Int32.MaxValue;
    }
    clear() {
        this._queue.clear();
    }
    isEmpty() {
        return this._queue.isEmpty();
    }
}
//# sourceMappingURL=data:application/json;base64,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