export class MgPriorityQueue {
    constructor() {
        this._queue = null;
        this.Size = 0;
        this._queue = new Array(MgPriorityQueue.DEFAULT_INITIAL_CAPACITY + 1);
        for (let _ai = 0; _ai < this._queue.length; ++_ai)
            this._queue[_ai] = null;
    }
    offer(o) {
        ++this.Size;
        if (this.Size >= this._queue.length)
            this._queue.length = this.Size;
        this._queue[this.Size] = o;
        this.fixUp(this.Size);
        return true;
    }
    peek() {
        if (this.Size === 0)
            return null;
        return this._queue[1];
    }
    isEmpty() {
        return this.Size === 0;
    }
    clear() {
        for (let i = 1; i <= this.Size; i++)
            this._queue[i] = null;
        this.Size = 0;
    }
    poll() {
        if (this.Size === 0)
            return null;
        let result = this._queue[1];
        this._queue[1] = this._queue[this.Size];
        this._queue[this.Size--] = null;
        if (this.Size > 1)
            this.fixDown(1);
        return result;
    }
    fixUp(k) {
        while (k > 1) {
            let j = k >> 1;
            if (this._queue[j].CompareTo(this._queue[k]) <= 0)
                break;
            let tmp = this._queue[j];
            this._queue[j] = this._queue[k];
            this._queue[k] = tmp;
            k = j;
        }
    }
    fixDown(k) {
        let j;
        while ((j = k << 1) <= this.Size && j > 0) {
            if (j < this.Size && this._queue[j].CompareTo(this._queue[j + 1]) > 0)
                j++;
            if (this._queue[k].CompareTo(this._queue[j]) <= 0)
                break;
            let tmp = this._queue[j];
            this._queue[j] = this._queue[k];
            this._queue[k] = tmp;
            k = j;
        }
    }
}
MgPriorityQueue.DEFAULT_INITIAL_CAPACITY = 11;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiTWdQcmlvcml0eVF1ZXVlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvZW5naW5lL3NyYy91dGlsL01nUHJpb3JpdHlRdWV1ZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFTQSxNQUFNLE9BQU8sZUFBZTtJQW1CMUI7UUFSUSxXQUFNLEdBQVUsSUFBSSxDQUFDO1FBRzdCLFNBQUksR0FBVyxDQUFDLENBQUM7UUFNZixJQUFJLENBQUMsTUFBTSxHQUFHLElBQUksS0FBSyxDQUFNLGVBQWUsQ0FBQyx3QkFBd0IsR0FBRyxDQUFDLENBQUMsQ0FBQztRQUMzRSxLQUFLLElBQUksR0FBRyxHQUFXLENBQUMsRUFBRSxHQUFHLEdBQUcsSUFBSSxDQUFDLE1BQU0sQ0FBQyxNQUFNLEVBQUUsRUFBRSxHQUFHO1lBQ3ZELElBQUksQ0FBQyxNQUFNLENBQUMsR0FBRyxDQUFDLEdBQUcsSUFBSSxDQUFDO0lBQzVCLENBQUM7SUFjRCxLQUFLLENBQUMsQ0FBTTtRQUVWLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQztRQUdaLElBQUksSUFBSSxDQUFDLElBQUksSUFBSSxJQUFJLENBQUMsTUFBTSxDQUFDLE1BQU07WUFDakMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQztRQUVqQyxJQUFJLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUM7UUFDM0IsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7UUFFdEIsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQsSUFBSTtRQUNGLElBQUksSUFBSSxDQUFDLElBQUksS0FBSyxDQUFDO1lBQ2pCLE9BQU8sSUFBSSxDQUFDO1FBRWQsT0FBTyxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ3hCLENBQUM7SUFVRCxPQUFPO1FBQ0wsT0FBTyxJQUFJLENBQUMsSUFBSSxLQUFLLENBQUMsQ0FBQztJQUN6QixDQUFDO0lBR0QsS0FBSztRQUVILEtBQUssSUFBSSxDQUFDLEdBQVcsQ0FBQyxFQUFFLENBQUMsSUFBSSxJQUFJLENBQUMsSUFBSSxFQUFFLENBQUMsRUFBRTtZQUN6QyxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxHQUFHLElBQUksQ0FBQztRQUV4QixJQUFJLENBQUMsSUFBSSxHQUFHLENBQUMsQ0FBQztJQUNoQixDQUFDO0lBRUQsSUFBSTtRQUNGLElBQUksSUFBSSxDQUFDLElBQUksS0FBSyxDQUFDO1lBQ2pCLE9BQU8sSUFBSSxDQUFDO1FBRWQsSUFBSSxNQUFNLEdBQVEsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsQ0FBQztRQUNqQyxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxHQUFHLElBQUksQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDO1FBRXhDLElBQUksQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLElBQUksRUFBRSxDQUFDLEdBQUcsSUFBSSxDQUFDO1FBQ2hDLElBQUksSUFBSSxDQUFDLElBQUksR0FBRyxDQUFDO1lBQ2YsSUFBSSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQztRQUVsQixPQUFPLE1BQU0sQ0FBQztJQUNoQixDQUFDO0lBUU8sS0FBSyxDQUFDLENBQVM7UUFDckIsT0FBTyxDQUFDLEdBQUcsQ0FBQyxFQUFFO1lBQ1osSUFBSSxDQUFDLEdBQVcsQ0FBQyxJQUFJLENBQUMsQ0FBQztZQUV2QixJQUFrQixJQUFJLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBRSxDQUFDLFNBQVMsQ0FBYyxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQztnQkFDM0UsTUFBTTtZQUVSLElBQUksR0FBRyxHQUFRLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLENBQUM7WUFDOUIsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxDQUFDO1lBQ2hDLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLEdBQUcsR0FBRyxDQUFDO1lBQ3JCLENBQUMsR0FBRyxDQUFDLENBQUM7U0FDUDtJQUNILENBQUM7SUFRTyxPQUFPLENBQUMsQ0FBUztRQUN2QixJQUFJLENBQVMsQ0FBQztRQUNkLE9BQU8sQ0FBQyxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsQ0FBQyxJQUFJLElBQUksQ0FBQyxJQUFJLElBQUksQ0FBQyxHQUFHLENBQUMsRUFBRTtZQUN6QyxJQUFJLENBQUMsR0FBRyxJQUFJLENBQUMsSUFBSSxJQUFrQixJQUFJLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBRSxDQUFDLFNBQVMsQ0FBYyxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxHQUFHLENBQUM7Z0JBQy9GLENBQUMsRUFBRSxDQUFDO1lBRU4sSUFBa0IsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUUsQ0FBQyxTQUFTLENBQWMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUM7Z0JBQzNFLE1BQU07WUFFUixJQUFJLEdBQUcsR0FBUSxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxDQUFDO1lBQzlCLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLEdBQUcsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsQ0FBQztZQUNoQyxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxHQUFHLEdBQUcsQ0FBQztZQUNyQixDQUFDLEdBQUcsQ0FBQyxDQUFDO1NBQ1A7SUFDSCxDQUFDOztBQXBJYyx3Q0FBd0IsR0FBVyxFQUFFLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQge0lDb21wYXJhYmxlfSBmcm9tIFwiQG1hZ2ljLXhwYS9tc2NvcmVsaWJcIjtcclxuXHJcbi8vLyA8c3VtbWFyeT5cclxuLy8vIE91ciBpbXBsZW1lbnRhdGlvbiBvZiBQcmlvcml0eSBfcXVldWUgc2lsaW1hciB0byBKREsgMS41IGphdmEudXRpbC5Qcmlvcml0eVF1ZXVlLiAqXHJcbi8vLyA8cD5cclxuLy8vIEEgcHJpb3JpdHkgX3F1ZXVlIGlzIHVuYm91bmRlZCwgYnV0IGhhcyBhbiBpbnRlcm5hbCA8aT5jYXBhY2l0eTwvaT4gZ292ZXJuaW5nIHRoZSBTaXplIG9mIGFuIGFycmF5IHVzZWQgdG9cclxuLy8vIHN0b3JlIHRoZSBlbGVtZW50cyBvbiB0aGUgX3F1ZXVlLiBJdCBpcyBhbHdheXMgYXQgbGVhc3QgYXMgbGFyZ2UgYXMgdGhlIF9xdWV1ZSBTaXplLiBBcyBlbGVtZW50cyBhcmUgYWRkZWQgdG9cclxuLy8vIGEgcHJpb3JpdHkgX3F1ZXVlLCBpdHMgY2FwYWNpdHkgZ3Jvd3MgYXV0b21hdGljYWxseS4gVGhlIGRldGFpbHMgb2YgdGhlIGdyb3d0aCBwb2xpY3kgYXJlIG5vdCBzcGVjaWZpZWQuXHJcbi8vLyA8L3N1bW1hcnk+XHJcbmV4cG9ydCBjbGFzcyBNZ1ByaW9yaXR5UXVldWUge1xyXG4gIHByaXZhdGUgc3RhdGljIERFRkFVTFRfSU5JVElBTF9DQVBBQ0lUWTogbnVtYmVyID0gMTE7XHJcbiAgLy8vIDxzdW1tYXJ5PiBQcmlvcml0eSBfcXVldWUgcmVwcmVzZW50ZWQgYXMgYSBiYWxhbmNlZCBiaW5hcnkgaGVhcDogdGhlIHR3byBjaGlsZHJlbiBvZiBfcXVldWVbbl0gYXJlIF9xdWV1ZVsyKm5dIGFuZFxyXG4gIC8vLyBfcXVldWVbMipuICsgMV0uIFRoZSBwcmlvcml0eSBfcXVldWUgaXMgb3JkZXJlZCBieSBjb21wYXJhdG9yLCBvciBieSB0aGUgZWxlbWVudHMnIG5hdHVyYWwgb3JkZXJpbmcsIGlmXHJcbiAgLy8vIGNvbXBhcmF0b3IgaXMgbnVsbDogRm9yIGVhY2ggbm9kZSBuIGluIHRoZSBoZWFwIGFuZCBlYWNoIGRlc2NlbmRhbnQgZCBvZiBuLCBuIDw9IGQuXHJcbiAgLy8vXHJcbiAgLy8vIFRoZSBlbGVtZW50IHdpdGggdGhlIGxvd2VzdCB2YWx1ZSBpcyBpbiBfcXVldWVbMV0sIGFzc3VtaW5nIHRoZSBfcXVldWUgaXMgbm9uZW1wdHkuIChBIG9uZS1iYXNlZCBhcnJheSBpc1xyXG4gIC8vLyB1c2VkIGluIHByZWZlcmVuY2UgdG8gdGhlIHRyYWRpdGlvbmFsIDAtYmFzZWQgYXJyYXkgdG8gc2ltcGxpZnkgcGFyZW50IGFuZCBjaGlsZCBjYWxjdWxhdGlvbnMuKVxyXG4gIC8vL1xyXG4gIC8vLyBfcXVldWUubGVuZ3RoIG11c3QgYmUgPj0gMiwgZXZlbiBpZiBTaXplID09IDAuXHJcbiAgLy8vIDwvc3VtbWFyeT5cclxuICBwcml2YXRlIF9xdWV1ZTogYW55W10gPSBudWxsO1xyXG5cclxuICAvLy8gPHN1bW1hcnk+IFRoZSBudW1iZXIgb2YgZWxlbWVudHMgaW4gdGhlIHByaW9yaXR5IF9xdWV1ZS48L3N1bW1hcnk+XHJcbiAgU2l6ZTogbnVtYmVyID0gMDtcclxuXHJcbiAgLy8vIDxzdW1tYXJ5PiBDcmVhdGVzIGEgPHR0PlByaW9yaXR5UXVldWU8L3R0PiB3aXRoIHRoZSBkZWZhdWx0IGluaXRpYWwgY2FwYWNpdHkgKDExKSB0aGF0IG9yZGVycyBpdHMgZWxlbWVudHNcclxuICAvLy8gYWNjb3JkaW5nIHRvIHRoZWlyIG5hdHVyYWwgb3JkZXJpbmcuXHJcbiAgLy8vIDwvc3VtbWFyeT5cclxuICBjb25zdHJ1Y3RvcigpIHtcclxuICAgIHRoaXMuX3F1ZXVlID0gbmV3IEFycmF5PGFueT4oTWdQcmlvcml0eVF1ZXVlLkRFRkFVTFRfSU5JVElBTF9DQVBBQ0lUWSArIDEpO1xyXG4gICAgZm9yIChsZXQgX2FpOiBudW1iZXIgPSAwOyBfYWkgPCB0aGlzLl9xdWV1ZS5sZW5ndGg7ICsrX2FpKVxyXG4gICAgICB0aGlzLl9xdWV1ZVtfYWldID0gbnVsbDtcclxuICB9XHJcblxyXG4gIC8vLyA8c3VtbWFyeT4gSW5zZXJ0cyB0aGUgc3BlY2lmaWVkIGVsZW1lbnQgaW50byB0aGlzIHByaW9yaXR5IF9xdWV1ZS5cclxuICAvLy9cclxuICAvLy8gPC9zdW1tYXJ5PlxyXG4gIC8vLyA8cmV0dXJucz4gPHR0PnRydWU8L3R0PlxyXG4gIC8vLyA8L3JldHVybnM+XHJcbiAgLy8vIDx0aHJvd3M+ICBDbGFzc0Nhc3RFeGNlcHRpb24gPC90aHJvd3M+XHJcbiAgLy8vIDxzdW1tYXJ5PiAgICAgICAgICAgIGlmIHRoZSBzcGVjaWZpZWQgZWxlbWVudCBjYW5ub3QgYmUgY29tcGFyZWQgd2l0aCBlbGVtZW50cyBjdXJyZW50bHkgaW4gdGhlIHByaW9yaXR5IF9xdWV1ZVxyXG4gIC8vLyBhY2NvcmRpbmcgdG8gdGhlIHByaW9yaXR5IF9xdWV1ZSdzIG9yZGVyaW5nLlxyXG4gIC8vLyA8L3N1bW1hcnk+XHJcbiAgLy8vIDx0aHJvd3M+ICBOdWxsUG9pbnRlckV4Y2VwdGlvbiA8L3Rocm93cz5cclxuICAvLy8gPHN1bW1hcnk+ICAgICAgICAgICAgaWYgdGhlIHNwZWNpZmllZCBlbGVtZW50IGlzIDx0dD5udWxsPC90dD4uXHJcbiAgLy8vIDwvc3VtbWFyeT5cclxuICBvZmZlcihvOiBhbnkpOiBib29sZWFuIHtcclxuXHJcbiAgICArK3RoaXMuU2l6ZTtcclxuXHJcbiAgICAvLyBHcm93IGJhY2tpbmcgc3RvcmUgaWYgbmVjZXNzYXJ5XHJcbiAgICBpZiAodGhpcy5TaXplID49IHRoaXMuX3F1ZXVlLmxlbmd0aClcclxuICAgICAgdGhpcy5fcXVldWUubGVuZ3RoID0gdGhpcy5TaXplO1xyXG5cclxuICAgIHRoaXMuX3F1ZXVlW3RoaXMuU2l6ZV0gPSBvO1xyXG4gICAgdGhpcy5maXhVcCh0aGlzLlNpemUpO1xyXG5cclxuICAgIHJldHVybiB0cnVlO1xyXG4gIH1cclxuXHJcbiAgcGVlaygpOiBhbnkge1xyXG4gICAgaWYgKHRoaXMuU2l6ZSA9PT0gMClcclxuICAgICAgcmV0dXJuIG51bGw7XHJcblxyXG4gICAgcmV0dXJuIHRoaXMuX3F1ZXVlWzFdO1xyXG4gIH1cclxuXHJcbiAgLy8vIDxzdW1tYXJ5PiBSZXR1cm5zIDx0dD50cnVlPC90dD4gaWYgX3F1ZXVlIGNvbnRhaW5zIG5vIGVsZW1lbnRzLlxyXG4gIC8vLyA8cD5cclxuICAvLy9cclxuICAvLy8gVGhpcyBpbXBsZW1lbnRhdGlvbiByZXR1cm5zIDx0dD5TaXplKCkgPT0gMDwvdHQ+LlxyXG4gIC8vL1xyXG4gIC8vLyA8L3N1bW1hcnk+XHJcbiAgLy8vIDxyZXR1cm5zPiA8dHQ+dHJ1ZTwvdHQ+IGlmIF9xdWV1ZSBjb250YWlucyBubyBlbGVtZW50cy5cclxuICAvLy8gPC9yZXR1cm5zPlxyXG4gIGlzRW1wdHkoKTogYm9vbGVhbiB7XHJcbiAgICByZXR1cm4gdGhpcy5TaXplID09PSAwO1xyXG4gIH1cclxuXHJcbiAgLy8vIDxzdW1tYXJ5PiBSZW1vdmVzIGFsbCBlbGVtZW50cyBmcm9tIHRoZSBwcmlvcml0eSBfcXVldWUuIFRoZSBfcXVldWUgd2lsbCBiZSBlbXB0eSBhZnRlciB0aGlzIGNhbGwgcmV0dXJucy48L3N1bW1hcnk+XHJcbiAgY2xlYXIoKTogdm9pZCB7XHJcbiAgICAvLyBOdWxsIG91dCBlbGVtZW50IHJlZmVyZW5jZXMgdG8gcHJldmVudCBtZW1vcnkgbGVha1xyXG4gICAgZm9yIChsZXQgaTogbnVtYmVyID0gMTsgaSA8PSB0aGlzLlNpemU7IGkrKylcclxuICAgICAgdGhpcy5fcXVldWVbaV0gPSBudWxsO1xyXG5cclxuICAgIHRoaXMuU2l6ZSA9IDA7XHJcbiAgfVxyXG5cclxuICBwb2xsKCk6IGFueSB7XHJcbiAgICBpZiAodGhpcy5TaXplID09PSAwKVxyXG4gICAgICByZXR1cm4gbnVsbDtcclxuXHJcbiAgICBsZXQgcmVzdWx0OiBhbnkgPSB0aGlzLl9xdWV1ZVsxXTtcclxuICAgIHRoaXMuX3F1ZXVlWzFdID0gdGhpcy5fcXVldWVbdGhpcy5TaXplXTtcclxuXHJcbiAgICB0aGlzLl9xdWV1ZVt0aGlzLlNpemUtLV0gPSBudWxsOyAvLyBEcm9wIGV4dHJhIHJlZiB0byBwcmV2ZW50IG1lbW9yeSBsZWFrXHJcbiAgICBpZiAodGhpcy5TaXplID4gMSlcclxuICAgICAgdGhpcy5maXhEb3duKDEpO1xyXG5cclxuICAgIHJldHVybiByZXN1bHQ7XHJcbiAgfVxyXG5cclxuICAvLy8gPHN1bW1hcnk+IEVzdGFibGlzaGVzIHRoZSBoZWFwIGludmFyaWFudCAoZGVzY3JpYmVkIGFib3ZlKSBhc3N1bWluZyB0aGUgaGVhcCBzYXRpc2ZpZXMgdGhlIGludmFyaWFudCBleGNlcHRcclxuICAvLy8gcG9zc2libHkgZm9yIHRoZSBsZWFmLW5vZGUgaW5kZXhlZCBieSBrICh3aGljaCBtYXkgaGF2ZSBhIG5leHRFeGVjdXRpb25UaW1lIGxlc3MgdGhhbiBpdHMgcGFyZW50J3MpLlxyXG4gIC8vL1xyXG4gIC8vLyBUaGlzIG1ldGhvZCBmdW5jdGlvbnMgYnkgXCJwcm9tb3RpbmdcIiBfcXVldWVba10gdXAgdGhlIGhpZXJhcmNoeSAoYnkgc3dhcHBpbmcgaXQgd2l0aCBpdHMgcGFyZW50KVxyXG4gIC8vLyByZXBlYXRlZGx5IHVudGlsIF9xdWV1ZVtrXSBpcyBncmVhdGVyIHRoYW4gb3IgZXF1YWwgdG8gaXRzIHBhcmVudC5cclxuICAvLy8gPC9zdW1tYXJ5PlxyXG4gIHByaXZhdGUgZml4VXAoazogbnVtYmVyKTogdm9pZCB7XHJcbiAgICB3aGlsZSAoayA+IDEpIHtcclxuICAgICAgbGV0IGo6IG51bWJlciA9IGsgPj4gMTtcclxuXHJcbiAgICAgIGlmICgoPElDb21wYXJhYmxlPnRoaXMuX3F1ZXVlW2pdKS5Db21wYXJlVG8oPElDb21wYXJhYmxlPnRoaXMuX3F1ZXVlW2tdKSA8PSAwKVxyXG4gICAgICAgIGJyZWFrO1xyXG5cclxuICAgICAgbGV0IHRtcDogYW55ID0gdGhpcy5fcXVldWVbal07XHJcbiAgICAgIHRoaXMuX3F1ZXVlW2pdID0gdGhpcy5fcXVldWVba107XHJcbiAgICAgIHRoaXMuX3F1ZXVlW2tdID0gdG1wO1xyXG4gICAgICBrID0gajtcclxuICAgIH1cclxuICB9XHJcblxyXG4gIC8vLyA8c3VtbWFyeT4gRXN0YWJsaXNoZXMgdGhlIGhlYXAgaW52YXJpYW50IChkZXNjcmliZWQgYWJvdmUpIGluIHRoZSBzdWJ0cmVlIHJvb3RlZCBhdCBrLCB3aGljaCBpcyBhc3N1bWVkIHRvIHNhdGlzZnlcclxuICAvLy8gdGhlIGhlYXAgaW52YXJpYW50IGV4Y2VwdCBwb3NzaWJseSBmb3Igbm9kZSBrIGl0c2VsZiAod2hpY2ggbWF5IGJlIGdyZWF0ZXIgdGhhbiBpdHMgY2hpbGRyZW4pLlxyXG4gIC8vL1xyXG4gIC8vLyBUaGlzIG1ldGhvZCBmdW5jdGlvbnMgYnkgXCJkZW1vdGluZ1wiIF9xdWV1ZVtrXSBkb3duIHRoZSBoaWVyYXJjaHkgKGJ5IHN3YXBwaW5nIGl0IHdpdGggaXRzIHNtYWxsZXIgY2hpbGQpXHJcbiAgLy8vIHJlcGVhdGVkbHkgdW50aWwgX3F1ZXVlW2tdIGlzIGxlc3MgdGhhbiBvciBlcXVhbCB0byBpdHMgY2hpbGRyZW4uXHJcbiAgLy8vIDwvc3VtbWFyeT5cclxuICBwcml2YXRlIGZpeERvd24oazogbnVtYmVyKTogdm9pZCB7XHJcbiAgICBsZXQgajogbnVtYmVyO1xyXG4gICAgd2hpbGUgKChqID0gayA8PCAxKSA8PSB0aGlzLlNpemUgJiYgaiA+IDApIHtcclxuICAgICAgaWYgKGogPCB0aGlzLlNpemUgJiYgKDxJQ29tcGFyYWJsZT50aGlzLl9xdWV1ZVtqXSkuQ29tcGFyZVRvKDxJQ29tcGFyYWJsZT50aGlzLl9xdWV1ZVtqICsgMV0pID4gMClcclxuICAgICAgICBqKys7XHJcblxyXG4gICAgICBpZiAoKDxJQ29tcGFyYWJsZT50aGlzLl9xdWV1ZVtrXSkuQ29tcGFyZVRvKDxJQ29tcGFyYWJsZT50aGlzLl9xdWV1ZVtqXSkgPD0gMClcclxuICAgICAgICBicmVhaztcclxuXHJcbiAgICAgIGxldCB0bXA6IGFueSA9IHRoaXMuX3F1ZXVlW2pdO1xyXG4gICAgICB0aGlzLl9xdWV1ZVtqXSA9IHRoaXMuX3F1ZXVlW2tdO1xyXG4gICAgICB0aGlzLl9xdWV1ZVtrXSA9IHRtcDtcclxuICAgICAgayA9IGo7XHJcbiAgICB9XHJcbiAgfVxyXG59XHJcbiJdfQ==