import { ReturnResultBase } from './ReturnResultBase';
import { LanguageData } from '../env/LanguageData';
export class ReturnResult extends ReturnResultBase {
    get Success() {
        return this.success;
    }
    get ErrorDescription() {
        return this.errorDescription;
    }
    constructor(errorDescriptionCodeOrErrorDescriptionOrInnerResult, innerResult) {
        super();
        this.errorDescription = null;
        this.success = false;
        this.ErrorId = null;
        if (arguments.length === 1 && (errorDescriptionCodeOrErrorDescriptionOrInnerResult === null || errorDescriptionCodeOrErrorDescriptionOrInnerResult.constructor === String))
            this.constructor_00(errorDescriptionCodeOrErrorDescriptionOrInnerResult);
        else if (arguments.length === 0)
            this.constructor_01();
        else if (arguments.length === 2)
            this.constructor_02(errorDescriptionCodeOrErrorDescriptionOrInnerResult);
        else
            this.constructor_03(errorDescriptionCodeOrErrorDescriptionOrInnerResult);
    }
    constructor_00(errorDescriptionCode) {
        this.success = false;
        this.ErrorId = errorDescriptionCode;
        this.errorDescription = LanguageData.Instance.getConstMessage(errorDescriptionCode);
    }
    constructor_01() {
        this.success = true;
        this.ErrorId = "";
    }
    constructor_02(errorDescription) {
        this.success = false;
        this.errorDescription = errorDescription;
    }
    constructor_03(innerResult) {
        this.success = innerResult.Success;
        this.errorDescription = innerResult.ErrorDescription;
    }
    GetErrorId() {
        return this.ErrorId;
    }
}
ReturnResult.SuccessfulResult = new ReturnResult();
//# sourceMappingURL=data:application/json;base64,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