import { NChar, NString, StringBuilder } from "@magic-xpa/mscorelib";
export class Scrambler {
    static Scramble(inVal) {
        if (!this.ScramblingEnabled)
            return inVal;
        let curr = 0;
        let currChr;
        let length = inVal.length;
        let random = Scrambler.RandomScramble(length);
        let key = Math.floor(Math.sqrt(length)) + random;
        let outVal = new StringBuilder(length + 1);
        outVal.Append(String.fromCharCode(random + 81));
        for (let i = 0; i < key; i++) {
            curr = i;
            while (curr < length) {
                currChr = inVal[curr];
                outVal.Append(currChr);
                curr += key;
            }
        }
        outVal.Append('_');
        return outVal.ToString();
    }
    static LocateScramble(inVal, from) {
        let i = from;
        while (i < inVal.length && NChar.IsWhiteSpace(inVal.charAt(i))) {
            i = i + 1;
        }
        return i + 1;
    }
    static RandomScramble(len) {
        let delta;
        let sqrt = Math.sqrt(len);
        let low = Scrambler.XML_MIN_RANDOM;
        let high = Scrambler.XML_MAX_RANDOM;
        if (low < (((-1) * sqrt) / 2))
            low = Math.floor(((-1) * sqrt) / 2);
        if (high > (sqrt / 2))
            high = Math.floor(sqrt / 2);
        delta = (Math.random() * (high - low)) + low;
        delta = Math.floor(delta);
        if (delta === Scrambler.XML_ILLEGAL_RANDOM)
            delta++;
        return delta;
    }
    static UnScramble(inVal, beginOffSet, endOffSet) {
        if (!Scrambler.ScramblingEnabled) {
            let outVal = inVal.substr(beginOffSet, endOffSet - beginOffSet + 1);
            return outVal;
        }
        else {
            let currOut, currIn, i;
            let length;
            let key;
            let outVal;
            let currBlk;
            let blockSize;
            let reminder;
            let start;
            let randomChr;
            endOffSet = endOffSet - 1;
            start = this.LocateScramble(inVal, beginOffSet);
            randomChr = inVal[start - 1];
            length = endOffSet - start + 1;
            key = (randomChr.charCodeAt(0) - 81) + Math.floor(Math.sqrt(length));
            outVal = new Array(length);
            blockSize = Math.floor(length / key);
            reminder = length % key;
            for (i = currOut = 0; currOut < length; i++) {
                currIn = i;
                currBlk = 1;
                while (currIn < length && currOut < length) {
                    outVal[currOut] = inVal[currIn + start];
                    currIn += blockSize;
                    if (currBlk <= reminder)
                        currIn++;
                    currOut++;
                    currBlk++;
                }
            }
            return NString.FromChars(outVal);
        }
    }
}
Scrambler.ScramblingEnabled = true;
Scrambler.XML_MIN_RANDOM = -48;
Scrambler.XML_MAX_RANDOM = 47;
Scrambler.XML_ILLEGAL_RANDOM = -21;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiU2NyYW1ibGVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvZW5naW5lL3NyYy91dGlsL1NjcmFtYmxlci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxPQUFPLEVBQUMsS0FBSyxFQUFFLE9BQU8sRUFBRSxhQUFhLEVBQUMsTUFBTSxzQkFBc0IsQ0FBQztBQUVuRSxNQUFNLE9BQU8sU0FBUztJQVNwQixNQUFNLENBQUMsUUFBUSxDQUFDLEtBQWE7UUFDM0IsSUFBSSxDQUFDLElBQUksQ0FBQyxpQkFBaUI7WUFDekIsT0FBTyxLQUFLLENBQUM7UUFFZixJQUFJLElBQUksR0FBVyxDQUFDLENBQUM7UUFDckIsSUFBSSxPQUFlLENBQUM7UUFDcEIsSUFBSSxNQUFNLEdBQVcsS0FBSyxDQUFDLE1BQU0sQ0FBQztRQUNsQyxJQUFJLE1BQU0sR0FBVyxTQUFTLENBQUMsY0FBYyxDQUFDLE1BQU0sQ0FBQyxDQUFDO1FBQ3RELElBQUksR0FBRyxHQUFXLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQyxHQUFHLE1BQU0sQ0FBQztRQUN6RCxJQUFJLE1BQU0sR0FBa0IsSUFBSSxhQUFhLENBQUMsTUFBTSxHQUFHLENBQUMsQ0FBQyxDQUFDO1FBRzFELE1BQU0sQ0FBQyxNQUFNLENBQUMsTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNLEdBQUcsRUFBRSxDQUFDLENBQUMsQ0FBQztRQUVoRCxLQUFLLElBQUksQ0FBQyxHQUFXLENBQUMsRUFBRSxDQUFDLEdBQUcsR0FBRyxFQUFFLENBQUMsRUFBRSxFQUFFO1lBQ3BDLElBQUksR0FBRyxDQUFDLENBQUM7WUFFVCxPQUFPLElBQUksR0FBRyxNQUFNLEVBQUU7Z0JBQ3BCLE9BQU8sR0FBRyxLQUFLLENBQUMsSUFBSSxDQUFDLENBQUM7Z0JBQ3RCLE1BQU0sQ0FBQyxNQUFNLENBQUMsT0FBTyxDQUFDLENBQUM7Z0JBQ3ZCLElBQUksSUFBSSxHQUFHLENBQUM7YUFDYjtTQUNGO1FBR0QsTUFBTSxDQUFDLE1BQU0sQ0FBQyxHQUFHLENBQUMsQ0FBUTtRQUMxQixPQUFPLE1BQU0sQ0FBQyxRQUFRLEVBQUUsQ0FBQztJQUMzQixDQUFDO0lBR08sTUFBTSxDQUFDLGNBQWMsQ0FBQyxLQUFhLEVBQUUsSUFBWTtRQUN2RCxJQUFJLENBQUMsR0FBVyxJQUFJLENBQUM7UUFDckIsT0FBTyxDQUFDLEdBQUcsS0FBSyxDQUFDLE1BQU0sSUFBSSxLQUFLLENBQUMsWUFBWSxDQUFDLEtBQUssQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtZQUM5RCxDQUFDLEdBQUcsQ0FBQyxHQUFHLENBQUMsQ0FBQztTQUNYO1FBQ0QsT0FBTyxDQUFDLEdBQUcsQ0FBQyxDQUFDO0lBQ2YsQ0FBQztJQWdCTyxNQUFNLENBQUMsY0FBYyxDQUFDLEdBQVc7UUFDdkMsSUFBSSxLQUFhLENBQUM7UUFDbEIsSUFBSSxJQUFJLEdBQVcsSUFBSSxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQztRQUNsQyxJQUFJLEdBQUcsR0FBVyxTQUFTLENBQUMsY0FBYyxDQUFDO1FBQzNDLElBQUksSUFBSSxHQUFXLFNBQVMsQ0FBQyxjQUFjLENBQUM7UUFFNUMsSUFBSSxHQUFHLEdBQUcsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsR0FBRyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUM7WUFDM0IsR0FBRyxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEdBQUcsSUFBSSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUM7UUFFdEMsSUFBSSxJQUFJLEdBQUcsQ0FBQyxJQUFJLEdBQUcsQ0FBQyxDQUFDO1lBQ25CLElBQUksR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksR0FBRyxDQUFDLENBQUMsQ0FBQztRQUU5QixLQUFLLEdBQUcsQ0FBQyxJQUFJLENBQUMsTUFBTSxFQUFFLEdBQUcsQ0FBQyxJQUFJLEdBQUcsR0FBRyxDQUFDLENBQUMsR0FBRyxHQUFHLENBQUM7UUFDN0MsS0FBSyxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDMUIsSUFBSSxLQUFLLEtBQUssU0FBUyxDQUFDLGtCQUFrQjtZQUN4QyxLQUFLLEVBQUUsQ0FBQztRQUVWLE9BQU8sS0FBSyxDQUFDO0lBQ2YsQ0FBQztJQU9ELE1BQU0sQ0FBQyxVQUFVLENBQUMsS0FBYSxFQUFFLFdBQW1CLEVBQUUsU0FBaUI7UUFDckUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxpQkFBaUIsRUFBRTtZQUNoQyxJQUFJLE1BQU0sR0FBVyxLQUFLLENBQUMsTUFBTSxDQUFDLFdBQVcsRUFBRSxTQUFTLEdBQUcsV0FBVyxHQUFHLENBQUMsQ0FBQyxDQUFDO1lBQzVFLE9BQU8sTUFBTSxDQUFDO1NBQ2Y7YUFDSTtZQUNILElBQUksT0FBZSxFQUFFLE1BQWMsRUFBRSxDQUFTLENBQUM7WUFDL0MsSUFBSSxNQUFjLENBQUM7WUFDbkIsSUFBSSxHQUFXLENBQUM7WUFDaEIsSUFBSSxNQUFnQixDQUFDO1lBQ3JCLElBQUksT0FBZSxDQUFDO1lBQ3BCLElBQUksU0FBaUIsQ0FBQztZQUN0QixJQUFJLFFBQWdCLENBQUM7WUFDckIsSUFBSSxLQUFhLENBQUM7WUFDbEIsSUFBSSxTQUFpQixDQUFDO1lBR3RCLFNBQVMsR0FBRyxTQUFTLEdBQUcsQ0FBQyxDQUFDO1lBSTFCLEtBQUssR0FBRyxJQUFJLENBQUMsY0FBYyxDQUFDLEtBQUssRUFBRSxXQUFXLENBQUMsQ0FBQztZQUNoRCxTQUFTLEdBQUcsS0FBSyxDQUFDLEtBQUssR0FBRyxDQUFDLENBQUMsQ0FBQztZQUU3QixNQUFNLEdBQUcsU0FBUyxHQUFHLEtBQUssR0FBRyxDQUFDLENBQUM7WUFDL0IsR0FBRyxHQUFHLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsR0FBRyxFQUFFLENBQUMsR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQztZQUNyRSxNQUFNLEdBQUcsSUFBSSxLQUFLLENBQUMsTUFBTSxDQUFDLENBQUM7WUFDM0IsU0FBUyxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsTUFBTSxHQUFHLEdBQUcsQ0FBQyxDQUFDO1lBQ3JDLFFBQVEsR0FBRyxNQUFNLEdBQUcsR0FBRyxDQUFDO1lBRXhCLEtBQUssQ0FBQyxHQUFHLE9BQU8sR0FBRyxDQUFDLEVBQUUsT0FBTyxHQUFHLE1BQU0sRUFBRSxDQUFDLEVBQUUsRUFBRTtnQkFDM0MsTUFBTSxHQUFHLENBQUMsQ0FBQztnQkFDWCxPQUFPLEdBQUcsQ0FBQyxDQUFDO2dCQUVaLE9BQU8sTUFBTSxHQUFHLE1BQU0sSUFBSSxPQUFPLEdBQUcsTUFBTSxFQUFFO29CQUMxQyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsS0FBSyxDQUFDLE1BQU0sR0FBRyxLQUFLLENBQUMsQ0FBQztvQkFDeEMsTUFBTSxJQUFJLFNBQVMsQ0FBQztvQkFDcEIsSUFBSSxPQUFPLElBQUksUUFBUTt3QkFDckIsTUFBTSxFQUFFLENBQUM7b0JBQ1gsT0FBTyxFQUFFLENBQUM7b0JBQ1YsT0FBTyxFQUFFLENBQUM7aUJBQ1g7YUFDRjtZQUVELE9BQU8sT0FBTyxDQUFDLFNBQVMsQ0FBQyxNQUFNLENBQUMsQ0FBQztTQUNsQztJQUNILENBQUM7O0FBbklNLDJCQUFpQixHQUFZLElBQUksQ0FBQztBQUMxQix3QkFBYyxHQUFXLENBQUMsRUFBRSxDQUFDO0FBQzdCLHdCQUFjLEdBQVcsRUFBRSxDQUFDO0FBQzVCLDRCQUFrQixHQUFXLENBQUMsRUFBRSxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHtOQ2hhciwgTlN0cmluZywgU3RyaW5nQnVpbGRlcn0gZnJvbSBcIkBtYWdpYy14cGEvbXNjb3JlbGliXCI7XHJcblxyXG5leHBvcnQgY2xhc3MgU2NyYW1ibGVyIHtcclxuICBzdGF0aWMgU2NyYW1ibGluZ0VuYWJsZWQ6IGJvb2xlYW4gPSB0cnVlOyAvLyBEaXNhYmxlIHNjcmFtYmxpbmdcclxuICBwcml2YXRlIHN0YXRpYyBYTUxfTUlOX1JBTkRPTTogbnVtYmVyID0gLTQ4O1xyXG4gIHByaXZhdGUgc3RhdGljIFhNTF9NQVhfUkFORE9NOiBudW1iZXIgPSA0NztcclxuICBwcml2YXRlIHN0YXRpYyBYTUxfSUxMRUdBTF9SQU5ET006IG51bWJlciA9IC0yMTtcclxuXHJcbiAgLy8vIDxzdW1tYXJ5PnNjcmFtYmxlIHN0cmluZzwvc3VtbWFyeT5cclxuICAvLy8gPHBhcmFtIG5hbWU9XCJpblZhbFwiPnN0cmluZyB0byBzY3JhbWJsZTwvcGFyYW0+XHJcbiAgLy8vIDxyZXR1cm5zPiBzY3JhbWJsZWQgc3RyaW5nPC9yZXR1cm5zPlxyXG4gIHN0YXRpYyBTY3JhbWJsZShpblZhbDogc3RyaW5nKTogc3RyaW5nIHtcclxuICAgIGlmICghdGhpcy5TY3JhbWJsaW5nRW5hYmxlZClcclxuICAgICAgcmV0dXJuIGluVmFsO1xyXG5cclxuICAgIGxldCBjdXJyOiBudW1iZXIgPSAwO1xyXG4gICAgbGV0IGN1cnJDaHI6IHN0cmluZztcclxuICAgIGxldCBsZW5ndGg6IG51bWJlciA9IGluVmFsLmxlbmd0aDtcclxuICAgIGxldCByYW5kb206IG51bWJlciA9IFNjcmFtYmxlci5SYW5kb21TY3JhbWJsZShsZW5ndGgpO1xyXG4gICAgbGV0IGtleTogbnVtYmVyID0gTWF0aC5mbG9vcihNYXRoLnNxcnQobGVuZ3RoKSkgKyByYW5kb207XHJcbiAgICBsZXQgb3V0VmFsOiBTdHJpbmdCdWlsZGVyID0gbmV3IFN0cmluZ0J1aWxkZXIobGVuZ3RoICsgMSk7XHJcblxyXG4gICAgLy8gVGhlIGZpcnN0IGNoYXIgaW4gdGhlIHNjcmFtYmxlZCBzdHJpbmcgaXMgYSByYW5kb20gbW9kaWZpZXIgdG8gdGhlIGRlZmF1bHQga2V5XHJcbiAgICBvdXRWYWwuQXBwZW5kKFN0cmluZy5mcm9tQ2hhckNvZGUocmFuZG9tICsgODEpKTtcclxuXHJcbiAgICBmb3IgKGxldCBpOiBudW1iZXIgPSAwOyBpIDwga2V5OyBpKyspIHtcclxuICAgICAgY3VyciA9IGk7XHJcblxyXG4gICAgICB3aGlsZSAoY3VyciA8IGxlbmd0aCkge1xyXG4gICAgICAgIGN1cnJDaHIgPSBpblZhbFtjdXJyXTtcclxuICAgICAgICBvdXRWYWwuQXBwZW5kKGN1cnJDaHIpO1xyXG4gICAgICAgIGN1cnIgKz0ga2V5O1xyXG4gICAgICB9XHJcbiAgICB9XHJcblxyXG4gICAgLy8gVGhlIGxhc3QgY2hhciBpbiB0aGUgc2NyYW1ibGVkIHN0cmluZyBpcyBhIHBhZGRpbmcgcmVhZGFibGUgY2hhci5cclxuICAgIG91dFZhbC5BcHBlbmQoJ18nKS8qJ18nKi87XHJcbiAgICByZXR1cm4gb3V0VmFsLlRvU3RyaW5nKCk7XHJcbiAgfVxyXG5cclxuICAvLy8gPHN1bW1hcnk+ZGVsZXRlIGZpcnN0IGNoYXJhY3RlciBvZiBzY3JhbWJsZWQgdGV4dCBhbmQgbWFrZXMgbGVmdCB0cmltIHRvIHRoZSBzdHJpbmc8L3N1bW1hcnk+XHJcbiAgcHJpdmF0ZSBzdGF0aWMgTG9jYXRlU2NyYW1ibGUoaW5WYWw6IHN0cmluZywgZnJvbTogbnVtYmVyKTogbnVtYmVyIHtcclxuICAgIGxldCBpOiBudW1iZXIgPSBmcm9tO1xyXG4gICAgd2hpbGUgKGkgPCBpblZhbC5sZW5ndGggJiYgTkNoYXIuSXNXaGl0ZVNwYWNlKGluVmFsLmNoYXJBdChpKSkpIHtcclxuICAgICAgaSA9IGkgKyAxO1xyXG4gICAgfVxyXG4gICAgcmV0dXJuIGkgKyAxO1xyXG4gIH1cclxuXHJcbiAgLy8vIDxzdW1tYXJ5PiBDaG9vc2UgYSByYW5kb20gbW9kaWZpZXIgdG8gdGhlIGtleSBvbiB3aGljaCB3ZSBiYXNlIHRoZSBzY3JhbWJsaW5nIHByb2Nlc3MuXHJcbiAgLy8vIFRoZSByYW5kb20gZmFjdG9yIGNhbm5vdCBiZSBqdXN0IGFueSBudW1iZXIgd2UgY2hvb3NlLiBTaW5jZSB0aGUgc2NyYW1ibGUga2V5XHJcbiAgLy8vIGRldGVybWluZXMgdGhlIGFtb3VudCBvZiAnanVtcHMnIHdlIHBlcmZvcm0gb24gdGhlIHRleHQgdG8gYmUgc2NyYW1ibGVkLCB0aGVuXHJcbiAgLy8vIHRoZSByYW5kb20gbnVtYmVyIHdlIGFkZCB0byBpdCBtdXN0IG5vdCBiZSB0b28gYmlnLCBub3IgdG9vIHNtYWxsLiBBcyBhIHJ1bGUsXHJcbiAgLy8vIHRoZSByYW5kb20gbW9kaWZpZXIgY2FuIHJhbmdlIGZyb20gU1FSVChsZW4pLzInIHRvICctU1FSVChsZW4pLzInLCBhbmQgc2luY2Ugd2VcclxuICAvLy8gcGFzcyB0aGUgc2VsZWN0ZWQgbnVtYmVyIGFzIGEgY2hhcmFjdGVyIHdpdGhpbiB0aGUgWE1MLCB0aGUgd2hvbGUgcmFuZ2UgY2Fubm90XHJcbiAgLy8vIGV4Y2VlZCB0aGUgbnVtYmVyIG9mIHRoZSBwcmludGFibGUgY2hhcmFjdGVycyAoOTUpLCB0aHVzIHRoZSByYW5nZSBpcyBsaW1pdGVkXHJcbiAgLy8vIGJldHdlZW4gKC00OCkgdG8gKDQ3KSwgc28gd2UgY2FwIHRoZSBhbGxvd2VkIHJhbmdlIGFjY29yZGluZyB0byB0aGVzZSBsaW1pdHMuXHJcbiAgLy8vIExhc3QsIHRoZSB2YWx1ZSBYTUxfSUxMRUdBTF9SQU5ET00sIHNpbmNlIGl0IHdpbGwgcmVzdWx0IGluIGFkZGluZyB0aGUgY2hhciAnPCdcclxuICAvLy8gdG8gdGhlIGJlZ2lubmluZyBvZiB0aGUgWE1MLiBUaGlzIHdpbGwgbWFrZSB0aGUgY2xpZW50IGNvbmZ1c2VkLCBzaW5jZSBpdCB3aWxsXHJcbiAgLy8vIHRoaW5rIHRoZSBYTUwgaXMgbm90IHNjcmFtYmxlZC5cclxuICAvLy8gPC9zdW1tYXJ5PlxyXG4gIC8vLyA8cGFyYW0gbmFtZT1cImxlblwiPm9mIG91dGdvaW5nIFN0cmluZzwvcGFyYW0+XHJcbiAgLy8vIDxyZXR1cm5zPiByYW5kb20gbW9kaWZpZXI8L3JldHVybnM+XHJcbiAgcHJpdmF0ZSBzdGF0aWMgUmFuZG9tU2NyYW1ibGUobGVuOiBudW1iZXIpOiBudW1iZXIge1xyXG4gICAgbGV0IGRlbHRhOiBudW1iZXI7XHJcbiAgICBsZXQgc3FydDogbnVtYmVyID0gTWF0aC5zcXJ0KGxlbik7XHJcbiAgICBsZXQgbG93OiBudW1iZXIgPSBTY3JhbWJsZXIuWE1MX01JTl9SQU5ET007XHJcbiAgICBsZXQgaGlnaDogbnVtYmVyID0gU2NyYW1ibGVyLlhNTF9NQVhfUkFORE9NO1xyXG5cclxuICAgIGlmIChsb3cgPCAoKCgtMSkgKiBzcXJ0KSAvIDIpKVxyXG4gICAgICBsb3cgPSBNYXRoLmZsb29yKCgoLTEpICogc3FydCkgLyAyKTtcclxuXHJcbiAgICBpZiAoaGlnaCA+IChzcXJ0IC8gMikpXHJcbiAgICAgIGhpZ2ggPSBNYXRoLmZsb29yKHNxcnQgLyAyKTtcclxuXHJcbiAgICBkZWx0YSA9IChNYXRoLnJhbmRvbSgpICogKGhpZ2ggLSBsb3cpKSArIGxvdztcclxuICAgIGRlbHRhID0gTWF0aC5mbG9vcihkZWx0YSk7XHJcbiAgICBpZiAoZGVsdGEgPT09IFNjcmFtYmxlci5YTUxfSUxMRUdBTF9SQU5ET00pXHJcbiAgICAgIGRlbHRhKys7XHJcblxyXG4gICAgcmV0dXJuIGRlbHRhO1xyXG4gIH1cclxuXHJcbiAgLy8vIDxzdW1tYXJ5Pm1ha2UgdW5zY3JhbWJsaW5nIHRvIHN0cmluZyBpbnNpZGUgdXBwZXIgYW5kIGRvd24gYm9yZGVyPC9zdW1tYXJ5PlxyXG4gIC8vLyA8cGFyYW0gbmFtZT1cImluVmFsXCI+c2NyYW1ibGVkIHN0cmluZyB0byBidWlsZCB1bnNjcmFtYmxlZCBzdHJpbmcgZnJvbSBpdDwvcGFyYW0+XHJcbiAgLy8vIDxwYXJhbSBuYW1lPVwiYmVnaW5PZmZTZXRcIj5vZmZzZXQgd2hlcmUgdGhlIHNjcmFtYmxlZCBzdHJpbmcgYmVnaW5zPC9wYXJhbT5cclxuICAvLy8gPHBhcmFtIG5hbWU9XCJlbmRPZmZTZXRcIj5vZmZzZXQgb2YgdGhlIGxhc3QgY2hhciBpbiB0aGUgc2NyYW1ibGVkIHN0cmluZy48L3BhcmFtPlxyXG4gIC8vLyA8cmV0dXJucz4gdW5zY3JhbWJsZWQgc3RyaW5nPC9yZXR1cm5zPlxyXG4gIHN0YXRpYyBVblNjcmFtYmxlKGluVmFsOiBzdHJpbmcsIGJlZ2luT2ZmU2V0OiBudW1iZXIsIGVuZE9mZlNldDogbnVtYmVyKTogc3RyaW5nIHtcclxuICAgIGlmICghU2NyYW1ibGVyLlNjcmFtYmxpbmdFbmFibGVkKSB7XHJcbiAgICAgIGxldCBvdXRWYWw6IHN0cmluZyA9IGluVmFsLnN1YnN0cihiZWdpbk9mZlNldCwgZW5kT2ZmU2V0IC0gYmVnaW5PZmZTZXQgKyAxKTtcclxuICAgICAgcmV0dXJuIG91dFZhbDtcclxuICAgIH1cclxuICAgIGVsc2Uge1xyXG4gICAgICBsZXQgY3Vyck91dDogbnVtYmVyLCBjdXJySW46IG51bWJlciwgaTogbnVtYmVyO1xyXG4gICAgICBsZXQgbGVuZ3RoOiBudW1iZXI7XHJcbiAgICAgIGxldCBrZXk6IG51bWJlcjtcclxuICAgICAgbGV0IG91dFZhbDogc3RyaW5nW107XHJcbiAgICAgIGxldCBjdXJyQmxrOiBudW1iZXI7XHJcbiAgICAgIGxldCBibG9ja1NpemU6IG51bWJlcjtcclxuICAgICAgbGV0IHJlbWluZGVyOiBudW1iZXI7XHJcbiAgICAgIGxldCBzdGFydDogbnVtYmVyO1xyXG4gICAgICBsZXQgcmFuZG9tQ2hyOiBzdHJpbmc7XHJcblxyXG4gICAgICAvLyBpZ25vcmUgdGhlIGxhc3QgY2hhciBpbiB0aGUgaW5wdXQsIGl0J3MganVzdCBhIHBhZGRpbmcgY2hhcmFjdGVyLlxyXG4gICAgICBlbmRPZmZTZXQgPSBlbmRPZmZTZXQgLSAxO1xyXG5cclxuICAgICAgLy8gc2tpcCBvdmVyIHRoZSBmaXJzdCBjaGFyIGluIHRoZSBpbnB1dCwgaXQgb25seSBjb250YWlucyBhIHJhbmRvbSBtb2RpZmllciB0byB0aGUga2V5LlxyXG4gICAgICAvLyBpdCBpcyBub3QgcGFydCBvZiB0aGUgZGF0YS5cclxuICAgICAgc3RhcnQgPSB0aGlzLkxvY2F0ZVNjcmFtYmxlKGluVmFsLCBiZWdpbk9mZlNldCk7XHJcbiAgICAgIHJhbmRvbUNociA9IGluVmFsW3N0YXJ0IC0gMV07XHJcblxyXG4gICAgICBsZW5ndGggPSBlbmRPZmZTZXQgLSBzdGFydCArIDE7XHJcbiAgICAgIGtleSA9IChyYW5kb21DaHIuY2hhckNvZGVBdCgwKSAtIDgxKSArIE1hdGguZmxvb3IoTWF0aC5zcXJ0KGxlbmd0aCkpO1xyXG4gICAgICBvdXRWYWwgPSBuZXcgQXJyYXkobGVuZ3RoKTtcclxuICAgICAgYmxvY2tTaXplID0gTWF0aC5mbG9vcihsZW5ndGggLyBrZXkpO1xyXG4gICAgICByZW1pbmRlciA9IGxlbmd0aCAlIGtleTtcclxuXHJcbiAgICAgIGZvciAoaSA9IGN1cnJPdXQgPSAwOyBjdXJyT3V0IDwgbGVuZ3RoOyBpKyspIHtcclxuICAgICAgICBjdXJySW4gPSBpO1xyXG4gICAgICAgIGN1cnJCbGsgPSAxO1xyXG5cclxuICAgICAgICB3aGlsZSAoY3VyckluIDwgbGVuZ3RoICYmIGN1cnJPdXQgPCBsZW5ndGgpIHtcclxuICAgICAgICAgIG91dFZhbFtjdXJyT3V0XSA9IGluVmFsW2N1cnJJbiArIHN0YXJ0XTtcclxuICAgICAgICAgIGN1cnJJbiArPSBibG9ja1NpemU7XHJcbiAgICAgICAgICBpZiAoY3VyckJsayA8PSByZW1pbmRlcilcclxuICAgICAgICAgICAgY3VyckluKys7XHJcbiAgICAgICAgICBjdXJyT3V0Kys7XHJcbiAgICAgICAgICBjdXJyQmxrKys7XHJcbiAgICAgICAgfVxyXG4gICAgICB9XHJcblxyXG4gICAgICByZXR1cm4gTlN0cmluZy5Gcm9tQ2hhcnMob3V0VmFsKTtcclxuICAgIH1cclxuICB9XHJcbn1cclxuIl19