import { NString } from '@magic-xpa/mscorelib';
export class CookieService {
    static getCookies(cookieName) {
        if (cookieName == '*')
            return document.cookie;
        return this.getCookie(cookieName);
    }
    static setCookie(name, value, expires, path, domain, secure, sameSite) {
        let cookieString = encodeURIComponent(name) + '=' + encodeURIComponent(CookieService.encode_cookie(value)) + ';';
        if (expires) {
            if (typeof expires === 'number') {
                const dateExpires = new Date(expires);
                cookieString += 'expires=' + dateExpires.toUTCString() + ';';
            }
            else if ((typeof expires === 'string')) {
                const dateExpires = new Date(expires);
                cookieString += 'expires=' + dateExpires.toUTCString() + ';';
            }
            else {
                cookieString += 'expires=' + expires.toUTCString() + ';';
            }
        }
        if (path) {
            cookieString += 'path=' + path + ';';
        }
        if (domain) {
            cookieString += 'domain=' + domain + ';';
        }
        if (secure === false && sameSite === 'None') {
            secure = true;
            console.warn(`cookie ${name} was forced with secure flag because sameSite=None.`);
        }
        if (secure) {
            cookieString += 'secure;';
        }
        if (!sameSite) {
            sameSite = 'Lax';
        }
        cookieString += 'sameSite=' + sameSite + ';';
        document.cookie = cookieString;
        return this.getCookie(name);
    }
    static encode_cookie(cookie_value) {
        cookie_value = cookie_value.trim();
        var coded_string = '';
        for (var counter = 0; counter < cookie_value.length; counter++) {
            coded_string += cookie_value.charCodeAt(counter);
            if (counter < cookie_value.length - 1) {
                coded_string += '+';
            }
        }
        return coded_string;
    }
    static decode_cookie(coded_string) {
        var cookie_value = '';
        var code_array = coded_string.split('+');
        for (var counter = 0; counter < code_array.length; counter++) {
            cookie_value += String.fromCharCode(code_array[counter]);
        }
        return cookie_value;
    }
    static getCookie(cookieName) {
        let name = NString.TrimStart(cookieName + '=');
        let decodedCookie = decodeURIComponent(document.cookie);
        let ca = decodedCookie.split(';');
        for (let i = 0; i < ca.length; i++) {
            let c = ca[i];
            while (c.charAt(0) == ' ') {
                c = c.substring(1);
            }
            if (c.indexOf(name) >= 0) {
                let decode = CookieService.decode_cookie(c.substring(name.length, c.length));
                return decode;
            }
        }
        return '';
    }
    static deleteCookie(cookieName) {
        var cookies = document.cookie.split(';');
        for (var i = 0; i < cookies.length; i++) {
            var cookie = cookies[i];
            var eqPos = cookie.indexOf('=');
            var name = eqPos > -1 ? cookie.substr(0, eqPos) : cookie;
            if (cookieName === NString.TrimStart(decodeURI(name))) {
                document.cookie = name + '=;expires=Thu, 01 Jan 1970 00:00:00 GMT';
                return true;
            }
        }
        return false;
    }
}
//# sourceMappingURL=data:application/json;base64,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