import { StringBuilder, Int32, NString, ApplicationException, NNumber, List, Debug, Char, RefParam, NumberStyles, HashUtils, DateTime, Dictionary, Stack, NChar, isNullOrUndefined, WebException, Thread, Encoding, Exception, isUndefined, Hashtable, NotImplementedException, Array_Enumerator, ISO_8859_1_Encoding, Int64 } from '@magic-xpa/mscorelib';
import { XMLConstants, StorageAttribute, ViewRefreshMode, InternalInterface, Logger, StorageAttributeCheck, StrUtil, SubformType, TableBehaviour, MgControlType, ScrollBarThumbType, ForceExit, XmlParser, Misc, Base64, Priority, SyncExecutionHelper, Queue, Constants, DateTimeUtils, Logger_LogLevels, Logger_MessageDirection, MsgInterface, RequestInfo, OSEnvironment, JSON_Utils, UtilDateJpn, UtilStrByteMode, PICInterface, WindowType, BrkScope, RaiseAt, CtrlButtonTypeGui } from '@magic-xpa/utils';
import { RecordUtils, GuiFieldBase, ExpVal, BlobType, FieldDef, GuiTaskBase, MgControlBase, PropInterface, GuiDataCollection, CommandType, Commands, HtmlProperties, ControlTable, Modifiers, KeyboardItem, TaskDefinitionIdTableSaxHandler, DisplayConvertor, VectorType, PIC, MgTimer, GuiConstants, RuntimeContextBase, UsernamePasswordCredentials, Styles, Manager, NUM_TYPE, GuiExpressionEvaluator, ExpressionInterface, DataModificationTypes, GuiDataViewBase, ObjectReferencesCollection, EMPTY_DCREF, ObjectReferenceBase, PropTable, FieldsTable as FieldsTable$1, DcValuesBuilderBase, MgFormBase, GuiEnvironment, TaskDefinitionId, Events, Helps, FocusManager, EventsProcessor, UIBridge } from '@magic-xpa/gui';
import { HttpHeaders, HttpErrorResponse } from '@angular/common/http';
import { timer, Subject } from 'rxjs';

class AccessHelper {
}
var ClearEventsOnStopExecution;
(function (ClearEventsOnStopExecution) {
    ClearEventsOnStopExecution["NONE"] = " ";
    ClearEventsOnStopExecution["SERVER"] = "S";
    ClearEventsOnStopExecution["ALL"] = "A";
})(ClearEventsOnStopExecution || (ClearEventsOnStopExecution = {}));

var EventSubType;
(function (EventSubType) {
    EventSubType[EventSubType["Normal"] = 0] = "Normal";
    EventSubType[EventSubType["CancelWithNoRollback"] = 1] = "CancelWithNoRollback";
    EventSubType[EventSubType["CancelIsQuit"] = 2] = "CancelIsQuit";
    EventSubType[EventSubType["RtRefreshViewUseCurrentRow"] = 3] = "RtRefreshViewUseCurrentRow";
    EventSubType[EventSubType["ExitDueToError"] = 4] = "ExitDueToError";
})(EventSubType || (EventSubType = {}));
var ClientTargetedCommandType;
(function (ClientTargetedCommandType) {
    ClientTargetedCommandType["Abort"] = "A";
    ClientTargetedCommandType["OpenURL"] = "P";
    ClientTargetedCommandType["Verify"] = "V";
    ClientTargetedCommandType["EnhancedVerify"] = "E";
    ClientTargetedCommandType["Result"] = "S";
    ClientTargetedCommandType["AddRange"] = "R";
    ClientTargetedCommandType["ClientRefresh"] = "C";
    ClientTargetedCommandType["AddLocate"] = "L";
    ClientTargetedCommandType["AddSort"] = "T";
    ClientTargetedCommandType["ResetRange"] = "G";
    ClientTargetedCommandType["ResetLocate"] = "O";
    ClientTargetedCommandType["ResetSort"] = "U";
})(ClientTargetedCommandType || (ClientTargetedCommandType = {}));

class ConstInterface {
}
ConstInterface.MG_TAG_CONTEXT = "context";
ConstInterface.MG_TAG_ENV = "env";
ConstInterface.MG_TAG_COMMAND = "command";
ConstInterface.MG_TAG_LANGUAGE = "language";
ConstInterface.MG_TAG_LANGUAGE_END = "/language";
ConstInterface.MG_TAG_CONSTMESSAGES = "ConstMessages";
ConstInterface.MG_TAG_CONSTMESSAGES_END = "/ConstMessages";
ConstInterface.MG_TAG_CONSTMESSAGESCONTENT = "ConstLangFileContent";
ConstInterface.MG_TAG_CONSTMESSAGESCONTENT_END = "/ConstLangFileContent";
ConstInterface.MG_TAG_MLS_FILE_URL = "MlsFileUrl";
ConstInterface.MG_TAG_MLS_FILE_URL_END = "/MlsFileUrl";
ConstInterface.MG_TAG_MLS_CONTENT = "MlsContent";
ConstInterface.MG_TAG_MLS_CONTENT_END = "/MlsContent";
ConstInterface.MG_TAG_COMPMAINPRG = "compmainprg";
ConstInterface.MG_TAG_STARTUP_PROGRAM = "StartupProgram";
ConstInterface.MG_TAG_CONTEXT_ID = "ContextID";
ConstInterface.MG_TAG_SESSION_ID = "SessionID";
ConstInterface.MG_TAG_HTTP_COMMUNICATION_TIMEOUT = "HttpTimeout";
ConstInterface.MG_TAG_TASKDEFINITION_IDS_URL = "taskDefinitionIdsUrl";
ConstInterface.MG_TAG_OFFLINE_SNIPPETS_URL = "offlineSnippetsUrl";
ConstInterface.MG_ATTR_ISSPECIFIC = "isSpecific";
ConstInterface.MG_ATTR_IS_GUI_THREAD_EXECUTION = "isGuiThreadExecution";
ConstInterface.MG_ATTR_FULLNAME = "fullname";
ConstInterface.MG_TAG_TASKURL = "taskURL";
ConstInterface.MG_TAG_EXPTABLE = "exptable";
ConstInterface.MG_TAG_EXP = "exp";
ConstInterface.MG_TAG_DATAVIEW = "dataview";
ConstInterface.MG_TAG_COMPLETE_DV = "CompleteDataView";
ConstInterface.MG_TAG_REC = "rec";
ConstInterface.MG_TAG_FLD_END = "/fld";
ConstInterface.MG_TAG_HANDLER = "handler";
ConstInterface.MG_TAG_EVENTHANDLERS = "eventhandlers";
ConstInterface.MG_TAG_EVENT = "event";
ConstInterface.MG_TAG_OPER = "oper";
ConstInterface.MG_TAG_KBDMAP_URL = "kbdmapurl";
ConstInterface.MG_TAG_KBDMAP = "kbdmap";
ConstInterface.MG_TAG_USER_EVENTS = "userevents";
ConstInterface.MG_TAG_USER_EVENTS_END = "/userevents";
ConstInterface.MG_TAG_EVENTS_QUEUE = "eventsqueue";
ConstInterface.MG_TAG_DC_VALS = "dc_vals";
ConstInterface.MG_TAG_FLWMTR_CONFIG = "flwmtr_config";
ConstInterface.MG_TAG_FLWMTR_MSG = "flwmtr_msg";
ConstInterface.MG_TAG_FLWMTR_ACT = "act";
ConstInterface.MG_TAG_DEL_LIST = "cacheDelList";
ConstInterface.MG_TAG_LINKS = "links";
ConstInterface.MG_TAG_LINKS_END = "/links";
ConstInterface.MG_TAG_LINK = "link";
ConstInterface.MG_TAG_TASK_TABLES = "taskTables";
ConstInterface.MG_TAG_TASK_TABLES_END = "/taskTables";
ConstInterface.MG_TAG_COLUMN = "column";
ConstInterface.MG_TAG_SORT = "sort";
ConstInterface.MG_TAG_SORTS = "sorts";
ConstInterface.MG_TAG_SORTS_END = "/sorts";
ConstInterface.MG_TAG_CACHED_TABLE = "cachedTable";
ConstInterface.MG_TAG_CACHED_TABLE_END = "/cachedTable";
ConstInterface.MG_TAG_RECORDS = "records";
ConstInterface.MG_TAG_RECORDS_END = "/records";
ConstInterface.MG_TAG_TASK_XML = "taskxml";
ConstInterface.MG_TAG_EXEC_STACK_ENTRY = "execstackentry";
ConstInterface.MG_TAG_DBH_REAL_IDXS = "dbhRealIdxs";
ConstInterface.MG_TAG_USER_DETAILS = "userDetails";
ConstInterface.MG_ATTR_OBJECT = "object";
ConstInterface.MG_ATTR_ARGLIST = "arglist";
ConstInterface.MG_ATTR_VIRTUAL = "virtual";
ConstInterface.MG_ATTR_SUBFORM_TASK = "subform_task";
ConstInterface.MG_ATTR_PARAM = "param";
ConstInterface.MG_ATTR_PARAMS = "params";
ConstInterface.MG_ATTR_ROUTE_PARAMS = "routeParams";
ConstInterface.MG_ATTR_EXPOSED_ROUTE_PARAMS = "exposedRouteParam";
ConstInterface.MG_ATTR_EXPOSED_TO_CLIENT = "exposedToClient";
ConstInterface.MG_ATTR_PAR_ATTRS = "attr";
ConstInterface.MG_ATTR_VIR_AS_REAL = "vir_as_real";
ConstInterface.MG_ATTR_LNK_CREATE = "link_create";
ConstInterface.MG_ATTR_RANGE = "range";
ConstInterface.MG_ATTR_NULLVALUE = "nullvalue";
ConstInterface.MG_ATTR_INIT = "init";
ConstInterface.MG_ATTR_MODE = "mode";
ConstInterface.MG_ATTR_RECOMPUTEBY = "recompute_by";
ConstInterface.MG_ATTR_HANDLEDBY = "handledby";
ConstInterface.MG_ATTR_LEVEL = "level";
ConstInterface.MG_ATTR_SECONDS = "seconds";
ConstInterface.MG_ATTR_SCOPE = "scope";
ConstInterface.MG_ATTR_PROPAGATE = "propagate";
ConstInterface.MG_ATTR_ENABLED = "enabled";
ConstInterface.MG_ATTR_FLD = "fld";
ConstInterface.MG_ATTR_FIELDID = "fieldid";
ConstInterface.MG_ATTR_IGNORE_SUBFORM_RECOMPUTE = "ignoreSubformRecompute";
ConstInterface.MG_ATTR_MAGICEVENT = "magicevent";
ConstInterface.MG_ATTR_FOCUSLIST = "focuslist";
ConstInterface.MG_ATTR_FOCUSTASK = "currFocusedTask";
ConstInterface.MG_ATTR_TEXT = "text";
ConstInterface.MG_ATTR_TITLE = "title";
ConstInterface.MG_ATTR_TITLE_EXP = "titleExp";
ConstInterface.MG_ATTR_IMAGE = "image";
ConstInterface.MG_ATTR_BUTTONS = "buttons";
ConstInterface.MG_ATTR_RETURN_VAL = "returnVal";
ConstInterface.MG_ATTR_ERR_LOG_APPEND = "errorLogAppend";
ConstInterface.MG_ATTR_EVENTTYPE = "eventtype";
ConstInterface.MG_ATTR_HOW = "how";
ConstInterface.MG_ATTR_UNDO = "undo";
ConstInterface.MG_ATTR_CND = "cnd";
ConstInterface.MG_ATTR_KEYCODE = "keycode";
ConstInterface.MG_ATTR_MODIFIER = "modifier";
ConstInterface.MG_ATTR_CURR_REC = "curr_rec";
ConstInterface.MG_ATTR_LAST_REC_ID = "lastRecIdx";
ConstInterface.MG_ATTR_OLD_FIRST_REC_ID = "oldFirstRecIdx";
ConstInterface.MG_ATTR_CURR_REC_POS_IN_FORM = "currRecPosInForm";
ConstInterface.MG_ATTR_DATEMODE = "datemode";
ConstInterface.MG_ATTR_THOUSANDS = "thousands";
ConstInterface.MG_ATTR_DECIMAL_SEPARATOR = "decimalseparator";
ConstInterface.MG_ATTR_DATE = "date";
ConstInterface.MG_ATTR_TIME = "time";
ConstInterface.MG_ATTR_LANGUAGE = "language";
ConstInterface.MG_ATTR_MODAL = "modal";
ConstInterface.MG_ATTR_IS_ROUTE = "is_route";
ConstInterface.MG_ATTR_TASK = "task";
ConstInterface.MG_ATTR_INTERNALEVENT = "internalevent";
ConstInterface.MG_ATTR_VARIABLE = "variable";
ConstInterface.MG_ATTR_HANDLERID = "handlerid";
ConstInterface.MG_ATTR_ROLLBACK_TYPE = "rollbackType";
ConstInterface.MG_ATTR_CENTURY = "century";
ConstInterface.MG_ATTR_INCLUDE_FIRST = "include_first";
ConstInterface.MG_ATTR_INCLUDE_LAST = "include_last";
ConstInterface.MG_ATTR_IS_ONEWAY_KEY = "isonewaykey";
ConstInterface.MG_ATTR_INSERT_AT = "insert_at";
ConstInterface.MG_ATTR_DBVIEWSIZE = "dbviewsize";
ConstInterface.MG_ATTR_INVALIDATE = "invalidate";
ConstInterface.MG_ATTR_RMPOS = "rmpos";
ConstInterface.MG_ATTR_DISPLAY = "display";
ConstInterface.MG_ATTR_SUBTYPE = "subtype";
ConstInterface.MG_ATTR_ADD_AFTER = "add_after";
ConstInterface.MG_ATTR_TOP_REC_ID = "top_rec_id";
ConstInterface.MG_ATTR_LOW_ID = "low_id";
ConstInterface.MG_ATTR_OWNER = "owner";
ConstInterface.MG_ATTR_UPD_IN_QUERY = "updateInQuery";
ConstInterface.MG_ATTR_UPD_IN_QUERY_LOWER = "updateinquery";
ConstInterface.MG_ATTR_CRE_IN_MODIFY = "createInModify";
ConstInterface.MG_ATTR_CRE_IN_MODIFY_LOWER = "createinmodify";
ConstInterface.MG_ATTR_IDLETIME = "idletime";
ConstInterface.MG_ATTR_WAIT = "wait";
ConstInterface.MG_ATTR_RETAIN_FOCUS = "retainFocus";
ConstInterface.MG_ATTR_SYNC_DATA = "syncData";
ConstInterface.MG_ATTR_SHOW = "show";
ConstInterface.MG_ATTR_COMPONENT = "component";
ConstInterface.MG_ATTR_PATH_PARENT_TASK = "path_parent_task";
ConstInterface.MG_ATTR_USER = "user";
ConstInterface.MG_ATTR_FORCE_EXIT = "force_exit";
ConstInterface.MG_ATTR_PUBLIC = "public_name";
ConstInterface.MG_ATTR_PRG_DESCRIPTION = "prgDescription";
ConstInterface.MG_ATTR_TABLE_NAME = "table_name";
ConstInterface.MG_ATTR_INDEX_IN_TABLE = "index_in_table";
ConstInterface.MG_ATTR_CALLINGTASK = "callingtask";
ConstInterface.MG_ATTR_FLAGS = "flags";
ConstInterface.MG_ATTR_LNKEXP = "link_exp";
ConstInterface.MG_ATTR_MODIFIED = "modi";
ConstInterface.MG_ATTR_OPER = "oper";
ConstInterface.MG_ATTR_REFRESHON = "refreshon";
ConstInterface.MG_ATTR_TASKMODE = "taskmode";
ConstInterface.MG_ATTR_EMPTY_DATAVIEW = "EmptyDataview";
ConstInterface.MG_ATTR_TASKLEVEL = "tasklevel";
ConstInterface.MG_ATTR_TRANS_CLEARED = "trans_cleared";
ConstInterface.MG_ATTR_TRANS_STAT = "trans_stat";
ConstInterface.MG_ATTR_SUBFORM_VISIBLE = "visible";
ConstInterface.MG_ATTR_ACK = "ack";
ConstInterface.MG_ATTR_COMPUTE_BY = "compute_by";
ConstInterface.MG_ATTR_CHUNK_SIZE = "chunk_size";
ConstInterface.MG_ATTR_CHUNK_SIZE_EXPRESSION = "chunk_size_expression";
ConstInterface.MG_ATTR_HAS_MAIN_TBL = "has_main_tbl";
ConstInterface.MG_ATTR_SERVER_ID = "serverid";
ConstInterface.MG_ATTR_SUBFORM_CTRL = "subformCtrl";
ConstInterface.MG_ATTR_CHECK_BY_SERVER = "checkByServer";
ConstInterface.MG_ATTR_OPER_IDX = "operidx";
ConstInterface.MG_ATTR_EXP_IDX = "expidx";
ConstInterface.MG_ATTR_EXP_TYPE = "exptype";
ConstInterface.MG_ATTR_NULL = "null";
ConstInterface.MG_ATTR_NULLS = "nulls";
ConstInterface.MG_ATTR_DC_REFS = "dc_refs";
ConstInterface.MG_ATTR_LINKED = "linked";
ConstInterface.MG_ATTR_DISP = "disp";
ConstInterface.MG_ATTR_REMOVE = "remove";
ConstInterface.MG_ATTR_DVPOS = "dvpos";
ConstInterface.MG_ATTR_SIGNIFICANT_NUM_SIZE = "significant_num_size";
ConstInterface.MG_ATTR_DEBUG_MODE = "debug";
ConstInterface.MG_ATTR_POINT_TRANSLATION = "changePoint";
ConstInterface.MG_ATTR_SPECIAL_EXITCTRL = "specialExitCtrl";
ConstInterface.MG_ATTR_DEFAULT_COLOR = "defaultColor";
ConstInterface.MG_ATTR_DEFAULT_FOCUS_COLOR = "defaultFocusColor";
ConstInterface.MG_ATTR_DEFAULT_DISABLED_COLOR = "defaultDisabledColor";
ConstInterface.MG_ATTR_CONTEXT_INACTIVITY_TIMEOUT = "ContextInactivityTimeout";
ConstInterface.MG_ATTR_CLIENT_CONTEXT_INACTIVITY_TIMEOUT = "ClientContextInactivityTimeout";
ConstInterface.MG_ATTR_CONTEXT_INACTIVITY_TIMEOUT_LOWER = "contextinactivitytimeout";
ConstInterface.MG_ATTR_CONTEXT_INACTIVITY_WARNING_TIME = "ContextInactivityWarningTime";
ConstInterface.MG_ATTR_CONTEXT_INACTIVITY_WARNING_TIME_LOWER = "contextinactivitywarningtime";
ConstInterface.MG_ATTR_CONTEXT_UNLOAD_TIMEOUT = "ContextUnloadTimeout";
ConstInterface.MG_ATTR_CONTEXT_UNLOAD_TIMEOUT_LOWER = "contextunloadtimeout";
ConstInterface.MG_ATTR_TOOLTIP_TIMEOUT = "TooltipTimeout";
ConstInterface.MG_ATTR_WEBCLIENT_REINIT_SESSION = "WebClientReInitSession";
ConstInterface.MG_ATTR_LOWHIGH = "lowhigh";
ConstInterface.MG_ATTR_ACCESS_TEST = "AccessTest";
ConstInterface.MG_ATTR_SPECIAL_TEXT_SIZE_FACTORING = "SpecialTextSizeFactoring";
ConstInterface.MG_ATTR_SPECIAL_FLAT_EDIT_ON_CLASSIC_THEME = "SpecialFlatEditOnClassicTheme";
ConstInterface.MG_ATTR_SPECIAL_LEGACY_TRIM_RANGE = "SpecialLegacyTrimRange";
ConstInterface.MG_ATTR_SPECIAL_LEGACY_EMPTY_RANGE = "SpecialFirstRangeOnEmptyField";
ConstInterface.MG_ATTR_ENCODING = "encoding";
ConstInterface.MG_ATTR_SYSTEM = "system";
ConstInterface.MG_ATTR_RECOVERY = "recovery";
ConstInterface.MG_ATTR_REVERSIBLE = "reversible";
ConstInterface.MG_ATTR_NEWID = "newid";
ConstInterface.MG_ATTR_MPRG_SOURCE = "mprg_source";
ConstInterface.MG_ATTR_INVOKER_ID = "invokerid";
ConstInterface.MG_ATTR_TRANS_LEVEL = "level";
ConstInterface.MG_ATTR_LEN = "len";
ConstInterface.MG_ATTR_DESC = "desc";
ConstInterface.MG_ATTR_CLOSE_SUBFORM_ONLY = "closeSubformOnly";
ConstInterface.MG_ATTR_CHECK_ONLY = "checkOnly";
ConstInterface.MG_ATTR_EXEC_ON_SERVER = "execOnServer";
ConstInterface.MG_ATTR_EXEC_ON_CLIENT = "execOnClient";
ConstInterface.MG_ATTR_USER_SORT = "userSort";
ConstInterface.MG_TAG_USERNAME = "userName";
ConstInterface.MG_TAG_IS_LOGGED_IN = "isLoggedIn";
ConstInterface.MG_TAG_PASSWORD = "password";
ConstInterface.MG_ATTR_USERID = "userId";
ConstInterface.MG_ATTR_USERINFO = "userInfo";
ConstInterface.MG_ATTR_CPY_GLB_PRMS = "copy_global_params";
ConstInterface.MG_TAG_GLOBALPARAMS = "globalparams";
ConstInterface.MG_TAG_GLOBALPARAMSCHANGES = "globalParamChanges";
ConstInterface.MG_TAG_PARAM = "param";
ConstInterface.MG_ATTR_IME_AUTO_OFF = "imeAutoOff";
ConstInterface.MG_ATTR_LOCAL_AS400SET = "local_as400set";
ConstInterface.MG_ATTR_LOCAL_EXTRA_GENGO = "local_extraGengo";
ConstInterface.MG_ATTR_LOCAL_FLAGS = "local_flags";
ConstInterface.MG_ATTR_SPEACIAL_ANSI_EXP = "SpecialAnsiExpression";
ConstInterface.MG_ATTR_SPECIAL_IMMEDIATE_HANDLER_END = "SpecialImmediateHandlerEnd";
ConstInterface.MG_ATTR_SPECIAL_SHOW_STATUSBAR_PANES = "SpecialShowStatusBarPanes";
ConstInterface.MG_ATTR_SPECIAL_ROUTE_TO_ROOT_PROG_ON_CONTEXT_RECREATION = "SpecialRouteToRootProgramOnContextRecreation";
ConstInterface.MG_ATTR_SPECIAL_SPECIAL_EDIT_LEFT_ALIGN = "SpecialEditLeftAlign";
ConstInterface.MG_ATTR_SPEACIAL_SWF_CONTROL_NAME = "SpecialSwfControlNameProperty";
ConstInterface.MG_ATTR_SPECIAL_VAL_NEW_POLICY = "SpecialValNewPolicy";
ConstInterface.MG_ATTR_OPER_CALLMODE = "operCallMode";
ConstInterface.MG_ATTR_TASK_MAINLEVEL = "mainlevel";
ConstInterface.MG_ATTR_OPER_METHODNAME = "method_name";
ConstInterface.MG_ATTR_GUID = "GUID";
ConstInterface.MG_ATTR_CONTROLS_PERSISTENCY_PATH = "ControlsPersistencyPath";
ConstInterface.MG_ATTR_PROJDIR = "projdir";
ConstInterface.MG_ATTR_TERMINAL = "terminal";
ConstInterface.MG_TAG_ENV_PARAM_URL = "envparamurl";
ConstInterface.MG_TAG_ENV_PARAM = "environment";
ConstInterface.MG_ATTR_HANDLER_ONFORM = "HandlerOnForm";
ConstInterface.MG_ATTR_DROP_USERFORMATS = "dropuserformats";
ConstInterface.MG_ATTR_CONTROL_NAME = "ControlName";
ConstInterface.MG_TAG_HIDDEN_CONTOLS = "HiddenControls";
ConstInterface.MG_ATTR_ISNS = "Isns";
ConstInterface.MG_ATTR_SPECIAL_CANCEL_ON_CREATE = "SpecialCancelOnCreate";
ConstInterface.MG_ATTR_TIME_SEPARATOR = "timeseparator";
ConstInterface.MG_ATTR_IOTIMING = "iotiming";
ConstInterface.MG_ATTR_HTTP_TIMEOUT = "httptimeout";
ConstInterface.MG_ATTR_USE_SIGNED_BROWSER_CLIENT = "usesignedbrowserclient";
ConstInterface.MG_ATTR_CLOSE_PRINTED_TABLES_IN_SUBTASKS = "closeprintedtablesinsubtasks";
ConstInterface.MG_ATTR_GENERIC_TEXT_PRINTING = "generictextprinting";
ConstInterface.MG_ATTR_HIGH_RESOLUTION_PRINT = "highresolutionprint";
ConstInterface.MG_ATTR_MERGE_TRIM = "mergetrim";
ConstInterface.MG_ATTR_ORIGINAL_IMAGE_LOAD = "originalimageload";
ConstInterface.MG_ATTR_PRINT_DATA_TRIM = "printdatatrim";
ConstInterface.MG_ATTR_PSCRIPT_PRINT_NT = "pscriptprintnt";
ConstInterface.MG_ATTR_THOUSAND_SEPARATOR = "thousandseparator";
ConstInterface.MG_ATTR_RTF_BUFFER_SIZE = "rtfbuffersize";
ConstInterface.MG_ATTR_SPECIAL_CONV_ADD_SLASH = "specialconvaddslash";
ConstInterface.MG_ATTR_SPECIAL_FULL_EXPAND_PRINT = "specialfullexpandprint";
ConstInterface.MG_ATTR_SPECIAL_FULL_TEXT = "specialfulltext";
ConstInterface.MG_ATTR_SPECIAL_LAST_LINE_PRINT = "speciallastlineprint";
ConstInterface.MG_ATTR_SPECIAL_PRINTER_OEM = "specialprinteroem";
ConstInterface.MG_ATTR_RANGE_POP_TIME = "rangepoptime";
ConstInterface.MG_ATTR_TEMP_POP_TIME = "temppoptime";
ConstInterface.MG_ATTR_EMBED_FONTS = "embedfonts";
ConstInterface.MG_ATTR_BATCH_PAINT_TIME = "batchpainttime";
ConstInterface.MG_ATTR_ISAM_TRANSACTION = "isamtransaction";
ConstInterface.MG_ATTR_CENTER_SCREEN_IN_ONLINE = "centerscreeninonline";
ConstInterface.MG_ATTR_REPOSITION_AFTER_MODIFY = "repositionaftermodify";
ConstInterface.MG_ATTR_TASKFLW = "taskflw";
ConstInterface.MG_ATTR_RECOMP = "recomp";
ConstInterface.MG_ATTR_FLWOP = "flwop";
ConstInterface.MG_ATTR_END = "end";
ConstInterface.MG_ATTR_INFO = "info";
ConstInterface.MG_ATTR_KEY = "key";
ConstInterface.MG_ATTR_KEY_EXP = "key_exp";
ConstInterface.MG_ATTR_NULL_FLAGS = "nullFlags";
ConstInterface.MG_ATTR_DVPOS_VALUE = "dvPosValue";
ConstInterface.MG_ATTR_DVPOS_DEC = "DvPosDec";
ConstInterface.MG_ATTR_TRANS_ID = "transId";
ConstInterface.MG_ATTR_REALREFRESH = "realRefresh";
ConstInterface.MG_ATTR_SUB_FORM_RCMP = "sub_form_recomp";
ConstInterface.MG_ATTR_HAS_LINK_RECOMPUTES = "has_link_recomputes";
ConstInterface.MG_ATTR_LOCATE_FIRST_ID = "locateFirstRec";
ConstInterface.MG_ATTR_OFFSET = "offset";
ConstInterface.MG_ATTR_HAS_LOCATE = "hasLocate";
ConstInterface.MG_ATTR_AS_PARENT = "AsParent";
ConstInterface.MG_ATTR_TASK_UNIQUE_SORT = "TaskUniqueSort";
ConstInterface.MG_ATTR_TRANS_OWNER = "newTransOwner";
ConstInterface.MG_ATTR_CLOSE = "close";
ConstInterface.MG_ATTR_TASK_COUNTER = "task_counter";
ConstInterface.MG_ATTR_LOOP_COUNTER = "loop_counter";
ConstInterface.MG_ATTR_CHACHED_FLD_ID = "cachedFldId";
ConstInterface.MG_ATTR_LOCATE = "locate";
ConstInterface.MG_ATTR_LINK = "link";
ConstInterface.MG_ATTR_IS_LINK_FIELD = "isLinkFld";
ConstInterface.MG_ATTR_CACHED_TABLE = "cached_table";
ConstInterface.MG_ATTR_TABLE_INDEX = "tableIndex";
ConstInterface.MG_ATTR_LINK_EVAL_CONDITION = "evalCondition";
ConstInterface.MG_ATTR_LINK_MODE = "linkmode";
ConstInterface.MG_ATTR_LINK_START = "linkBeginAfterField";
ConstInterface.MG_ATTR_IDENT = "tid";
ConstInterface.MG_ATTR_DIR = "dir";
ConstInterface.MG_ATTR_COND = "cndExp";
ConstInterface.MG_ATTR_COND_RES = "tskCndRes";
ConstInterface.MG_ATTR_RET_VAL = "retVal";
ConstInterface.MG_ATTR_DBPOS = "db_pos";
ConstInterface.MG_TAG_USR_DEF_FUC_RET_EXP_ID = "returnexp";
ConstInterface.MG_TAG_USR_DEF_FUC_RET_EXP_ATTR = "returnexpattr";
ConstInterface.MG_ATTR_DIRECTION = "direction";
ConstInterface.MG_ATTR_KEEP_USER_SORT = "keepUserSort";
ConstInterface.MG_TAG_DBHS = "DBHS";
ConstInterface.MG_TAG_DBHS_END = "/DBHS";
ConstInterface.MG_TAG_DBH_DATA_IDS_URL = "dbhDataIdsUrl";
ConstInterface.MG_TAG_FLD = "FLD";
ConstInterface.MG_ATTR_STORAGE = "Storage";
ConstInterface.MG_ATTR_PICTURE = "Picture";
ConstInterface.MG_ATTR_NAME = "name";
ConstInterface.MG_ATTR_FIELD_INDEX = "fieldindex";
ConstInterface.MG_ATTR_MIN_VALUE = "min";
ConstInterface.MG_ATTR_MAX_VALUE = "max";
ConstInterface.MG_ATTR_NULL_MIN_VALUE = "null_min";
ConstInterface.MG_ATTR_NULL_MAX_VALUE = "null_max";
ConstInterface.MG_TAG_DATABASES_HEADER = "Databases";
ConstInterface.MG_TAG_DATABASE_URL = "databaseUrl";
ConstInterface.BYTES_IN_CHAR = 2;
ConstInterface.MG_OPER_VERIFY = 2;
ConstInterface.MG_OPER_BLOCK = 5;
ConstInterface.MG_OPER_LOOP = 97;
ConstInterface.MG_OPER_ELSE = 98;
ConstInterface.MG_OPER_ENDBLOCK = 6;
ConstInterface.MG_OPER_CALL = 7;
ConstInterface.MG_OPER_EVALUATE = 8;
ConstInterface.MG_OPER_UPDATE = 9;
ConstInterface.MG_OPER_USR_EXIT = 13;
ConstInterface.MG_OPER_RAISE_EVENT = 14;
ConstInterface.MG_OPER_SERVER = 99;
ConstInterface.TRANS_COMMIT = 'C';
ConstInterface.TRANS_ABORT = 'A';
ConstInterface.EVENT_TYPE_SYSTEM = 'S';
ConstInterface.EVENT_TYPE_INTERNAL = 'I';
ConstInterface.EVENT_TYPE_TIMER = 'T';
ConstInterface.EVENT_TYPE_EXPRESSION = 'E';
ConstInterface.EVENT_TYPE_USER = 'U';
ConstInterface.EVENT_TYPE_PUBLIC = 'P';
ConstInterface.EVENT_TYPE_NONE = 'N';
ConstInterface.EVENT_TYPE_NOTINITED = 'X';
ConstInterface.EVENT_TYPE_USER_FUNC = 'F';
ConstInterface.BRK_LEVEL_TASK_PREFIX = "TP";
ConstInterface.BRK_LEVEL_TASK_SUFFIX = "TS";
ConstInterface.BRK_LEVEL_REC_PREFIX = "RP";
ConstInterface.BRK_LEVEL_REC_MAIN = "RM";
ConstInterface.BRK_LEVEL_REC_SUFFIX = "RS";
ConstInterface.BRK_LEVEL_CTRL_PREFIX = "CP";
ConstInterface.BRK_LEVEL_CTRL_SUFFIX = "CS";
ConstInterface.BRK_LEVEL_CTRL_VERIFICATION = "CV";
ConstInterface.BRK_LEVEL_HANDLER_INTERNAL = "HI";
ConstInterface.BRK_LEVEL_HANDLER_SYSTEM = "HS";
ConstInterface.BRK_LEVEL_HANDLER_TIMER = "HT";
ConstInterface.BRK_LEVEL_HANDLER_EXPRESSION = "HE";
ConstInterface.BRK_LEVEL_HANDLER_USER = "HU";
ConstInterface.BRK_LEVEL_USER_FUNCTION = "UF";
ConstInterface.BRK_LEVEL_VARIABLE = "VC";
ConstInterface.BRK_LEVEL_MAIN_PROG = "MP";
ConstInterface.BRK_LEVEL_SUBFORM = "SUBFORM";
ConstInterface.BRK_LEVEL_TASK_PREFIX_FM = "Task Prefix ";
ConstInterface.BRK_LEVEL_TASK_SUFFIX_FM = "Task Suffix ";
ConstInterface.BRK_LEVEL_REC_PREFIX_FM = "Record Prefix ";
ConstInterface.BRK_LEVEL_REC_SUFFIX_FM = "Record Suffix ";
ConstInterface.BRK_LEVEL_CTRL_PREFIX_FM = "Control Prefix ";
ConstInterface.BRK_LEVEL_CTRL_SUFFIX_FM = "Control Suffix ";
ConstInterface.BRK_LEVEL_VARIABLE_FM = "Variable Change ";
ConstInterface.BRK_LEVEL_CTRL_VERIFICATION_FM = "Control Verification ";
ConstInterface.BRK_LEVEL_HANDLER_INTERNAL_FM = "Internal: ";
ConstInterface.BRK_LEVEL_HANDLER_SYSTEM_FM = "System: ";
ConstInterface.BRK_LEVEL_HANDLER_TIMER_FM = "Timer:";
ConstInterface.BRK_LEVEL_HANDLER_EXPRESSION_FM = "Expression: ";
ConstInterface.BRK_LEVEL_HANDLER_USER_FM = "User";
ConstInterface.BRK_LEVEL_USER_FUNCTION_FM = "User Defined Function";
ConstInterface.TRANS_NONE = 'O';
ConstInterface.TRANS_RECORD_PREFIX = 'P';
ConstInterface.TRANS_TASK_PREFIX = 'T';
ConstInterface.RECOVERY_NONE = '\0';
ConstInterface.RECOVERY_ROLLBACK = 'R';
ConstInterface.RECOVERY_RETRY = 'T';
ConstInterface.FLW_VERIFY_MODE_ERROR = 'E';
ConstInterface.IMAGE_EXCLAMATION = 'E';
ConstInterface.IMAGE_CRITICAL = 'C';
ConstInterface.IMAGE_QUESTION = 'Q';
ConstInterface.IMAGE_INFORMATION = 'I';
ConstInterface.BUTTONS_OK = 'O';
ConstInterface.BUTTONS_OK_CANCEL = 'K';
ConstInterface.BUTTONS_ABORT_RETRY_IGNORE = 'A';
ConstInterface.BUTTONS_YES_NO_CANCEL = 'Y';
ConstInterface.BUTTONS_YES_NO = 'N';
ConstInterface.BUTTONS_RETRY_CANCEL = 'R';
ConstInterface.DISPLAY_BOX = 'B';
ConstInterface.DISPLAY_STATUS = 'S';
ConstInterface.END_COND_EVAL_BEFORE = "B";
ConstInterface.END_COND_EVAL_AFTER = "A";
ConstInterface.END_COND_EVAL_IMMIDIATE = "I";
ConstInterface.ARG_TYPE_FIELD = 'F';
ConstInterface.ARG_TYPE_EXP = 'E';
ConstInterface.ARG_TYPE_VALUE = 'V';
ConstInterface.ARG_TYPE_SKIP = 'X';
ConstInterface.TOP_LEVEL_CONTAINER = 0;
ConstInterface.REQ_ARG_ALPHA = "-A";
ConstInterface.REQ_ARG_UNICODE = "-C";
ConstInterface.REQ_ARG_NUMERIC = "-N";
ConstInterface.REQ_ARG_DOUBLE = "-D";
ConstInterface.REQ_ARG_LOGICAL = "-L";
ConstInterface.REQ_ARG_NULL = "-U";
ConstInterface.REQ_ARG_SEPARATOR = "&";
ConstInterface.REQ_ARG_START = "?";
ConstInterface.REQ_APP_NAME = "appname";
ConstInterface.REQ_ARGS = "arguments";
ConstInterface.REQ_SKIP_AUTHENTICATION = "SkipAuthentication";
ConstInterface.RC_INDICATION_INITIAL = "WEBCLIENT=INITIAL&";
ConstInterface.RC_INDICATION = "WEBCLIENT=Y&";
ConstInterface.UTF8TRANS = "UTF8TRANS=Y&";
ConstInterface.RC_TOKEN_CTX_ID = "CTX=";
ConstInterface.RC_TOKEN_SESSION_ID = "SI=";
ConstInterface.RC_TOKEN_CTX_GROUP = "CTXGROUP=";
ConstInterface.RC_TOKEN_SESSION_COUNT = "SESSION=";
ConstInterface.RC_TOKEN_DATA = "DATA=";
ConstInterface.WEBCLIENT_REINITIALIZE_REQUEST = "WCREINITIALIZEREQUEST=Y";
ConstInterface.MAIN_PROG_VIEW = "MainProgramsDataView";
ConstInterface.GLOBAL_PARAM_LIST = "GlobalParamList";
ConstInterface.ENV_VAR_LIST = "EnvVarList";
ConstInterface.LAST_EXCEPTION = "LastException";
ConstInterface.CTX_REMOVED_FROM_SRVR = "CtxRemovedFromSrvr";
ConstInterface.LAST_ROUTE_EVENT = "LastRouteEvent";
ConstInterface.LAST_ROUTE_EVENT_ARG_LIST = "LastRouteEventArgList";
ConstInterface.LAST_ROUTE_EVENT_SRC_TSK = "LastRouteEventSourceTask";
ConstInterface.IS_SESSION_REINITIALIZING = "IsSessionReInitializing";
ConstInterface.RC_AUTHENTICATION_REQUEST = "RCAUTHENTICATIONREQUEST=Y";
ConstInterface.V24_RIA_ERROR_PREFIX = "<RIA_ERROR_RESPONSE>";
ConstInterface.SESSION_COUNTER_CLOSE_CTX_INDICATION = -1;
ConstInterface.SERVER = "server";
ConstInterface.CTX_GROUP = "CtxGroup";
ConstInterface.ERROR_STRING = "Error";
ConstInterface.USER_RANGES = "ranges";
ConstInterface.USER_LOCATES = "locates";
ConstInterface.SORT = "srt";
ConstInterface.MIN_RNG = "min";
ConstInterface.MAX_RNG = "max";
ConstInterface.NULL_MIN_RNG = "isNullMin";
ConstInterface.NULL_MAX_RNG = "isNullMax";
ConstInterface.CLEAR_RANGE = "rangeReset";
ConstInterface.CLEAR_LOCATES = "locateReset";
ConstInterface.CLEAR_SORTS = "sortReset";
ConstInterface.USER_RNG = "rng";
ConstInterface.MG_TAG_ENV_CHANGES = "changes";
ConstInterface.MG_ATTR_ENV_VALUE = "value";
ConstInterface.MG_ATTR_ENV_WRITEINI = "writeToINI";
ConstInterface.MG_ATTR_ENV_RESERVED = "reserved";
ConstInterface.MG_ATTR_ENV_REMOVED = "removed";
ConstInterface.INI_SECTION_MAGIC_ENV_BRACKETS = "[MAGIC_ENV]";
ConstInterface.INI_SECTION_LOGICAL_NAMES_BRACKETS = "[MAGIC_LOGICAL_NAMES]";
ConstInterface.INI_SECTION_MAGIC_ENV = "MAGIC_ENV";
ConstInterface.INI_SECTION_MAGIC_SYSTEMS = "MAGIC_SYSTEMS";
ConstInterface.INI_SECTION_MAGIC_DBMS = "MAGIC_DBMS";
ConstInterface.INI_SECTION_MAGIC_SERVERS = "MAGIC_SERVERS";
ConstInterface.INI_SECTION_MAGIC_COMMS = "MAGIC_COMMS";
ConstInterface.INI_SECTION_MAGIC_PRINTERS = "MAGIC_PRINTERS";
ConstInterface.INI_SECTION_MAGIC_SYSTEM_MENU = "MAGIC_SYSTEM_MENU";
ConstInterface.INI_SECTION_MAGIC_DATABASES = "MAGIC_DATABASES";
ConstInterface.INI_SECTION_MAGIC_LANGUAGE = "MAGIC_LANGUAGE";
ConstInterface.INI_SECTION_MAGIC_SERVICES = "MAGIC_SERVICES";
ConstInterface.INI_SECTION_TOOLS_MENU = "TOOLS_MENU";
ConstInterface.INITIAL_OFFLINE_TASK_TAG = 1000000000;
ConstInterface.ENABLE_COMMUNICATION_DIALOGS = "EnableCommunicationDialogs";
ConstInterface.MG_ATTR_VAL_ABORT = "abort";
ConstInterface.MG_ATTR_VAL_ENHANCED_VERIFY = "enhancedverify";
ConstInterface.MG_ATTR_VAL_OPENURL = "openurl";
ConstInterface.MG_ATTR_VAL_RESULT = "result";
ConstInterface.MG_ATTR_VAL_VERIFY = "verify";
ConstInterface.MG_ATTR_VAL_ADD_RANGE = "addrange";
ConstInterface.MG_ATTR_VAL_ADD_LOCATE = "addlocate";
ConstInterface.MG_ATTR_VAL_ADD_SORT = "addsort";
ConstInterface.MG_ATTR_VAL_RESET_RANGE = "resetrange";
ConstInterface.MG_ATTR_VAL_RESET_LOCATE = "resetlocate";
ConstInterface.MG_ATTR_VAL_RESET_SORT = "resetsort";
ConstInterface.MG_ATTR_VAL_CLIENT_REFRESH = "clientrefresh";
ConstInterface.MG_ATTR_VAL_EVAL = "evaluate";
ConstInterface.MG_ATTR_VAL_EVENT = "event";
ConstInterface.MG_ATTR_VAL_EXEC_OPER = "execoper";
ConstInterface.MG_ATTR_VAL_QUERY = "query";
ConstInterface.MG_ATTR_VAL_QUERY_GLOBAL_PARAMS = "globalparams";
ConstInterface.MG_ATTR_VAL_QUERY_TYPE = "query_type";
ConstInterface.MG_ATTR_VAL_RECOMP = "recompute";
ConstInterface.MG_ATTR_VAL_TRANS = "trans";
ConstInterface.MG_ATTR_VAL_UNLOAD = "unload";
ConstInterface.MG_ATTR_VAL_INIPUT_FORCE_WRITE = "iniputForceWrite";
ConstInterface.MG_ATTR_VAL_INIPUT_PARAM = "iniputParam";
ConstInterface.MG_ATTR_ERROR_MESSAGE = "errorMessage";
ConstInterface.MG_ATTR_VAL_TOTAL_RECORDS_COUNT = "totalRecordsCount";
ConstInterface.MG_ATTR_VAL_RECORDS_BEFORE_CURRENT_VIEW = "recordsBeforeCurrentView";
ConstInterface.MG_ATTR_VAL_SERVER_TRANS_CACHE_EMPTY = "serverTransCacheEmpty";
ConstInterface.MG_ATTR_SPECIAL_ANSI_BLOB_CHECK_NULL = "SpecialAnsiBlobCheckNull";
ConstInterface.MG_ATTR_SPECIAL_TABLE_REDUCE_TITLE_HEIGHT = "SpecialTableReduceTitleHeight";
ConstInterface.MG_ATTR_SPECIAL_DOTNET_ALLOW_ZERO_DATE = "SpecialDotNetAllowZeroDate";
ConstInterface.MG_ATTR_SPECIAL_REUSE_TABLE_EDITOR = "SpecialReuseTableEditor";
ConstInterface.MG_TAG_LAST_ROUTE = "LastRoute";

class ClientOriginatedCommand {
    get ShouldSerialize() {
        return true;
    }
    get ShouldSerializeRecords() {
        return true;
    }
    SerializeCommandData() {
        return null;
    }
    SerializeDataAfterCommand() {
        return null;
    }
}

class ClientOriginatedCommandTaskTag extends ClientOriginatedCommand {
    constructor() {
        super();
    }
    get Task() {
        return AccessHelper.mgDataTable.getCurrMGData().getTask(this.TaskTag);
    }
}

class CommandSerializationHelper {
    constructor() {
        this.message = new StringBuilder();
    }
    GetString() {
        return this.message.ToString();
    }
    SerializeTaskTag(taskTag) {
        let id = AccessHelper.mgDataTable.getTaskIdById(taskTag);
        this.SerializeAttribute(XMLConstants.MG_ATTR_TASKID, id);
    }
    SerializeFldId(fldId) {
        this.SerializeAttribute(ConstInterface.MG_ATTR_FIELDID, fldId);
    }
    SerializeDitIdx(ditIdx) {
        if (ditIdx > Int32.MinValue) {
            this.SerializeAttribute(XMLConstants.MG_ATTR_DITIDX, ditIdx);
        }
    }
    SerializeRouteParams(operation) {
        let routeParams = operation.getRouteParams();
        let routeValStr = '';
        for (let i = 0; i < routeParams.length; i++) {
            routeValStr = routeValStr.concat(RecordUtils.serializeItemVal(routeParams[i], StorageAttribute.UNICODE, StorageAttribute.SKIP, true));
        }
        this.SerializeAttribute(ConstInterface.MG_ATTR_ROUTE_PARAMS, routeValStr);
    }
    SerializeRefreshMode(refreshMode) {
        if (refreshMode !== ViewRefreshMode.None) {
            this.SerializeAttribute(ConstInterface.MG_ATTR_REALREFRESH, refreshMode);
        }
    }
    SerializeMagicEvent(magicEvent) {
        this.SerializeAttribute(ConstInterface.MG_ATTR_MAGICEVENT, magicEvent);
    }
    SerializeCloseSubformOnly(closeSubformOnly) {
        if (closeSubformOnly)
            this.SerializeAttribute(ConstInterface.MG_ATTR_CLOSE_SUBFORM_ONLY, "1");
    }
    SerializeKeyIndex(keyIndex) {
        this.SerializeAttribute(ConstInterface.MG_ATTR_KEY, keyIndex);
    }
    SerializeAttribute(attribute, value) {
        if (arguments.length === 2 && (attribute === null || attribute.constructor === String) && (value === null || value.constructor === String)) {
            this.SerializeAttribute_0(attribute, value);
            return;
        }
        if (arguments.length === 2 && (attribute === null || attribute.constructor === String) && (value === null || value.constructor === Number)) {
            this.SerializeAttribute_1(attribute, value);
            return;
        }
        this.SerializeAttribute_2(attribute, value);
    }
    SerializeAttribute_0(attribute, value) {
        this.message.Append(" " + attribute + "=\"" + value + "\"");
    }
    SerializeAttribute_1(attribute, value) {
        this.message.Append(" " + attribute + "=\"" + value + "\"");
    }
    SerializeAttribute_2(attribute, value) {
        this.message.Append(" " + attribute + "=\"" + value + "\"");
    }
}

class EventCommand extends ClientOriginatedCommandTaskTag {
    get CommandTypeAttribute() {
        return ConstInterface.MG_ATTR_VAL_EVENT;
    }
    get EventDescription() {
        return Event.getInternalEvtDescription(this.MagicEvent);
    }
    get Task() {
        return AccessHelper.mgDataTable.getCurrMGData().getTask(this.TaskTag);
    }
    get ShouldSerialize() {
        if (this.TaskTag !== null && AccessHelper.mgDataTable.GetTaskByID(this.TaskTag) !== null &&
            !AccessHelper.mgDataTable.GetTaskByID(this.TaskTag).KnownToServer)
            return false;
        return true;
    }
    constructor(magicEvent) {
        super();
        this.TaskTag = null;
        this.MagicEvent = 0;
        this.ClientRecId = 0;
        this.MagicEvent = magicEvent;
    }
    SerializeCommandData() {
        let helper = new CommandSerializationHelper();
        helper.SerializeTaskTag(this.TaskTag);
        helper.SerializeMagicEvent(this.MagicEvent);
        return helper.GetString();
    }
    getCommandInfo() {
        return NString.Format('[{0} in {1}]', this.EventDescription, this.Task.getTaskInfo());
    }
}

var RollbackEventCommand_RollbackType;
(function (RollbackEventCommand_RollbackType) {
    RollbackEventCommand_RollbackType["NONE"] = " ";
    RollbackEventCommand_RollbackType["CANCEL"] = "C";
    RollbackEventCommand_RollbackType["ROLLBACK"] = "R";
})(RollbackEventCommand_RollbackType || (RollbackEventCommand_RollbackType = {}));
class RollbackEventCommand extends EventCommand {
    constructor() {
        super(InternalInterface.MG_ACT_ROLLBACK);
        this.Rollback = RollbackEventCommand_RollbackType.NONE;
    }
    SerializeCommandData() {
        let helper = new CommandSerializationHelper();
        helper.SerializeTaskTag(this.TaskTag);
        helper.SerializeMagicEvent(this.MagicEvent);
        if (this.Rollback !== RollbackEventCommand_RollbackType.NONE)
            helper.SerializeAttribute(ConstInterface.MG_ATTR_ROLLBACK_TYPE, this.Rollback);
        return helper.GetString();
    }
    getRollbackTypeString() {
        switch (this.Rollback) {
            case RollbackEventCommand_RollbackType.CANCEL:
                return 'Cancel';
            case RollbackEventCommand_RollbackType.ROLLBACK:
                return 'Rollback';
        }
    }
    getCommandInfo() {
        return NString.Format('[{0}{1} in {2}]', this.EventDescription, NString.IsNullOrEmpty(this.getRollbackTypeString())
            ? NString.Empty
            : NString.Format(' while handling {0}', this.getRollbackTypeString()), this.Task.getTaskInfo());
    }
}

class FieldBase extends GuiFieldBase {
    constructor() {
        super(...arguments);
        this.IsEventHandlerField = false;
    }
    async updateDisplay() {
        return Promise.resolve();
    }
    async compute(recompute) {
        return Promise.resolve();
    }
    async setValueAndStartRecompute(val, isNullFld, recompute, setRecordUpdated, isArgUpdate, enforceVariableChange) {
        return Promise.resolve();
    }
}
FieldBase.CLEAR_FLAGS = true;

class Argument {
    constructor(fieldOrExpValOrSrcArg) {
        this._exp = null;
        this._fld = null;
        this._skip = false;
        this._type = '\0';
        this._val = null;
        this._valueAttr = StorageAttribute.NONE;
        this._valueIsNull = false;
        if (arguments.length === 0) {
            this.constructor_0();
            return;
        }
        if (arguments.length === 1 && (fieldOrExpValOrSrcArg === null || fieldOrExpValOrSrcArg instanceof FieldBase)) {
            this.constructor_1(fieldOrExpValOrSrcArg);
            return;
        }
        if (arguments.length === 1 && (fieldOrExpValOrSrcArg === null || fieldOrExpValOrSrcArg instanceof ExpVal)) {
            this.constructor_2(fieldOrExpValOrSrcArg);
            return;
        }
        this.constructor_3(fieldOrExpValOrSrcArg);
    }
    constructor_0() {
        this._type = '\0';
        this._fld = null;
        this._exp = null;
        this._skip = false;
    }
    constructor_1(field) {
        this._fld = field;
        this._type = ConstInterface.ARG_TYPE_FIELD;
        this._exp = null;
        this._skip = false;
    }
    constructor_2(expVal) {
        this._type = ConstInterface.ARG_TYPE_VALUE;
        this._fld = null;
        this._exp = null;
        this._skip = false;
        if (expVal.IsNull)
            this._val = null;
        else
            this._val = expVal.ToMgVal();
        this._valueIsNull = (this._val === null);
        this._valueAttr = expVal.Attr;
    }
    constructor_3(srcArg) {
        this._type = ConstInterface.ARG_TYPE_VALUE;
        switch (srcArg._type) {
            case ConstInterface.ARG_TYPE_FIELD:
                this._valueAttr = srcArg._fld.getType();
                break;
            case ConstInterface.ARG_TYPE_EXP:
                break;
            case ConstInterface.ARG_TYPE_SKIP:
                this._skip = true;
                break;
            default:
                throw new ApplicationException("in Argument.Argument(): illegal source Argument type!");
        }
    }
    async Initialize(srcArg) {
        switch (srcArg._type) {
            case ConstInterface.ARG_TYPE_FIELD:
                this._val = srcArg._fld.getValue(true);
                this._valueIsNull = srcArg._fld.isNull();
                break;
            case ConstInterface.ARG_TYPE_EXP:
                let retVal = await srcArg._exp.evaluateWithResLength(255);
                this._val = retVal.mgVal;
                this._valueAttr = retVal.type;
                this._valueIsNull = (this._val == null);
                if (this._valueIsNull)
                    this._val = Argument.getEmptyValue((retVal.type === StorageAttribute.BLOB ||
                        retVal.type === StorageAttribute.BLOB_VECTOR));
                break;
        }
    }
    fillData(arg, srcTask) {
        this._type = arg[0];
        let argElements = arg.substr(2);
        switch (this._type) {
            case ConstInterface.ARG_TYPE_FIELD:
                {
                    let fieldId = argElements.split(',');
                    let parent = NNumber.Parse(fieldId[0]);
                    let fldIdx = NNumber.Parse(fieldId[1]);
                    this._fld = srcTask.getFieldDef(parent, fldIdx);
                }
                break;
            case ConstInterface.ARG_TYPE_EXP:
                let expNum = NNumber.Parse(argElements);
                this._exp = srcTask.getExpById(expNum);
                break;
            case ConstInterface.ARG_TYPE_SKIP:
                this._skip = true;
                break;
            default:
                Logger.Instance.WriteExceptionToLogWithMsg("in Argument.FillData() illegal type: " + arg);
                break;
        }
    }
    buildXML(message) {
        switch (this._type) {
            case ConstInterface.ARG_TYPE_FIELD:
                message.Append("F:" + this._fld.getTask().getTaskTag() + "," + this._fld.getId());
                break;
            case ConstInterface.ARG_TYPE_EXP:
                message.Append("E:" + this._exp.getId());
                break;
            case ConstInterface.ARG_TYPE_SKIP:
                message.Append("X:0");
                break;
            default:
                Logger.Instance.WriteExceptionToLogWithMsg("in Argument.buildXML() illegal type: " + this._type);
                break;
        }
    }
    getType() {
        return this._type;
    }
    getField() {
        if (this._type === ConstInterface.ARG_TYPE_FIELD)
            return this._fld;
        return null;
    }
    getExp() {
        if (this._type === ConstInterface.ARG_TYPE_EXP)
            return this._exp;
        return null;
    }
    async setValueToField(destFld) {
        let val;
        let isNull;
        switch (this._type) {
            case ConstInterface.ARG_TYPE_FIELD:
                val = this._fld.getValue(true);
                val = Argument.convertArgs(val, this._fld.getType(), destFld.getType());
                isNull = this._fld.isNull() || val == null;
                break;
            case ConstInterface.ARG_TYPE_EXP:
                val = await this._exp.evaluateWithResultTypeAndLength(destFld.getType(), destFld.getSize());
                isNull = (val == null);
                if (isNull)
                    val = Argument.getEmptyValue((destFld.getType() === StorageAttribute.BLOB ||
                        destFld.getType() === StorageAttribute.BLOB_VECTOR));
                break;
            case ConstInterface.ARG_TYPE_VALUE:
                val = Argument.convertArgs(this._val, this._valueAttr, destFld.getType());
                isNull = this._valueIsNull || val == null;
                break;
            default:
                return;
        }
        destFld.takeValFromRec();
        await destFld.setValueAndStartRecompute(val, isNull, destFld.getTask().DataViewWasRetrieved, false, true);
    }
    static convertArgs(value, srcAttr, expectedType) {
        let invalidArg = false;
        switch (expectedType) {
            case StorageAttribute.ALPHA:
            case StorageAttribute.UNICODE:
                if (srcAttr === StorageAttribute.BLOB) {
                    if (BlobType.isValidBlob(value))
                        value = BlobType.getString(value);
                }
                else if (!StorageAttributeCheck.IsTypeAlphaOrUnicode(srcAttr))
                    invalidArg = true;
                break;
            case StorageAttribute.NUMERIC:
            case StorageAttribute.DATE:
            case StorageAttribute.TIME:
                if (!StorageAttributeCheck.isTypeNumeric(srcAttr))
                    invalidArg = true;
                break;
            case StorageAttribute.BLOB:
                if (StorageAttributeCheck.IsTypeAlphaOrUnicode(srcAttr)) {
                    let contentType = srcAttr === StorageAttribute.ALPHA
                        ? BlobType.CONTENT_TYPE_ANSI
                        : BlobType.CONTENT_TYPE_UNICODE;
                    value = BlobType.createFromString(value, contentType);
                }
                else if (!StorageAttributeCheck.isTypeBlob(srcAttr))
                    invalidArg = true;
                break;
        }
        if (invalidArg)
            value = FieldDef.getMagicDefaultValue(expectedType);
        return value;
    }
    async getValue(expType, expSize) {
        switch (this._type) {
            case ConstInterface.ARG_TYPE_EXP:
                this._val = await this._exp.evaluateWithResultTypeAndLength(expType, expSize);
                if (this._val == null)
                    this._val = Argument.getEmptyValue(expType === StorageAttribute.BLOB
                        || expType === StorageAttribute.BLOB_VECTOR);
                break;
            case ConstInterface.ARG_TYPE_FIELD:
                this._val = this._fld.getValue(true);
                break;
            case ConstInterface.ARG_TYPE_VALUE:
                break;
            default:
                return null;
        }
        return this._val;
    }
    skipArg() {
        return this._skip;
    }
    fillDataByParams(paramValueAttr, paramValue, paramNull) {
        this._valueAttr = paramValueAttr;
        this._val = paramValue;
        this._valueIsNull = paramNull;
        if (this._valueAttr === StorageAttribute.SKIP) {
            this._type = ConstInterface.ARG_TYPE_SKIP;
            this._skip = true;
        }
        else {
            this._type = ConstInterface.ARG_TYPE_VALUE;
        }
    }
    static getEmptyValue(isBlob) {
        return isBlob ? (BlobType.getEmptyBlobPrefix('\0') + ";") : "";
    }
    FillFromString(argStr) {
        this._type = ConstInterface.ARG_TYPE_VALUE;
        let argType = null;
        if (argStr.length > 2)
            argType = argStr.substr(0, 2);
        switch (argType) {
            case ConstInterface.REQ_ARG_ALPHA:
                this._valueAttr = StorageAttribute.ALPHA;
                break;
            case ConstInterface.REQ_ARG_UNICODE:
                this._valueAttr = StorageAttribute.UNICODE;
                break;
            case ConstInterface.REQ_ARG_NUMERIC:
                this._valueAttr = StorageAttribute.NUMERIC;
                break;
            case ConstInterface.REQ_ARG_DOUBLE:
                this._valueAttr = StorageAttribute.NUMERIC;
                break;
            case ConstInterface.REQ_ARG_LOGICAL:
                this._valueAttr = StorageAttribute.BOOLEAN;
                break;
            case ConstInterface.REQ_ARG_NULL:
                this._valueAttr = StorageAttribute.NONE;
                break;
            default:
                this._valueAttr = StorageAttribute.ALPHA;
                this._val = argStr;
                return;
        }
        this._val = argStr.substr(2);
    }
}

class ArgumentsList {
    constructor(srcArgsOrExp_paramsOrArgument) {
        this._list = null;
        this.RefreshOnString = null;
        if (arguments.length === 0) {
            this.constructor_0();
            return;
        }
        if (arguments.length === 1 && (srcArgsOrExp_paramsOrArgument === null || srcArgsOrExp_paramsOrArgument instanceof Array)) {
            this.constructor_2(srcArgsOrExp_paramsOrArgument);
            return;
        }
        this.constructor_3(srcArgsOrExp_paramsOrArgument);
    }
    constructor_0() {
    }
    async Initialize(srcArgs) {
        this.constructor_0();
        if (srcArgs === null)
            this._list = null;
        else {
            this._list = new List();
            for (let i = 0; i < srcArgs.getSize(); i = i + 1) {
                let arg = new Argument(srcArgs.getArg(i));
                await arg.Initialize(srcArgs.getArg(i));
                this._list.push(arg);
            }
        }
    }
    constructor_2(Exp_params) {
        this.constructor_0();
        let argCnt = Exp_params.length;
        if (argCnt === 0)
            this._list = null;
        else {
            this._list = new List();
            for (let i = 0; i < argCnt; i = i + 1) {
                this._list.push(new Argument(Exp_params[i]));
            }
        }
    }
    constructor_3(argument) {
        this.Add(argument);
    }
    fillList(valueStr, srcTask) {
        let tok = StrUtil.tokenize(valueStr, "$");
        let size = tok.length;
        this._list = new List();
        for (let i = 0; i < size; i = i + 1) {
            let argument = new Argument();
            argument.fillData(tok[i], srcTask);
            this._list.push(argument);
        }
    }
    buildListFromParams(size, attrs, vals, nulls) {
        this._list = new List();
        for (let i = 0; i < size; i = i + 1) {
            let argument = new Argument();
            argument.fillDataByParams(attrs.charAt(i), vals[i], nulls.charAt(i) !== '0');
            this._list.push(argument);
        }
    }
    buildXML(message) {
        for (let i = 0; i < this._list.length; i = i + 1) {
            if (i > 0)
                message.Append('$');
            this._list.get_Item(i).buildXML(message);
        }
    }
    getSize() {
        return (this._list === null) ? 0 : this._list.length;
    }
    getArg(idx) {
        if (idx < 0 || idx >= this._list.length)
            return null;
        return this._list.get_Item(idx);
    }
    async getArgValue(idx, expType, expSize) {
        let arg = this.getArg(idx);
        if (arg === null)
            return null;
        return await arg.getValue(expType, expSize);
    }
    FillListFromString(argsString) {
        let pattern = new RegExp("(?<!\\\\),");
        let array = argsString.split(pattern);
        this._list = new List();
        for (let i = 0; i < array.length; i = i + 1) {
            let argument = new Argument();
            argument.FillFromString(array[i]);
            this._list.push(argument);
        }
    }
    Add(argument) {
        if (this._list === null)
            this._list = new List();
        this._list.push(argument);
    }
}

var Task_SubformExecModeEnum;
(function (Task_SubformExecModeEnum) {
    Task_SubformExecModeEnum[Task_SubformExecModeEnum["NO_SUBFORM"] = -1] = "NO_SUBFORM";
    Task_SubformExecModeEnum[Task_SubformExecModeEnum["SET_FOCUS"] = 0] = "SET_FOCUS";
    Task_SubformExecModeEnum[Task_SubformExecModeEnum["FIRST_TIME"] = 1] = "FIRST_TIME";
    Task_SubformExecModeEnum[Task_SubformExecModeEnum["REFRESH"] = 2] = "REFRESH";
})(Task_SubformExecModeEnum || (Task_SubformExecModeEnum = {}));
class TaskBase extends GuiTaskBase {
    constructor() {
        super(...arguments);
        this.IsTryingToStop = false;
        this.DoSubformPrefixSuffix = false;
        this.IsAfterRetryBeforeBuildXML = false;
        this.TaskSuffixExecuted = false;
        this.DataviewManager = null;
        this.IsOffline = false;
        this.ResetRange = false;
        this.UserRngs = null;
        this.ResetLocate = false;
        this.UserLocs = null;
        this.ResetSort = false;
        this.UserSorts = null;
        this._transactionFailed = false;
        this.InEndTask = false;
        this.InCtrlPrefix = false;
        this.RetainFocus = false;
        this.SubformExecMode = 0;
        this.TransactionErrorHandlingsRetry = null;
        this.ClosingFormUI = false;
        this.AfterFirstRecordPrefix = false;
    }
    static ShouldNonInteractiveBeModal() {
        return true;
    }
    async isCached() {
        return Promise.resolve(true);
    }
    async prepareCache(ignoreCurr) {
        return Promise.resolve(true);
    }
    async testAndSet(ignoreCurr) {
        return Promise.resolve(true);
    }
    async SubformRefresh(subformTask, explicitSubformRefresh) {
        return Promise.resolve();
    }
    async stop() {
        return Promise.resolve();
    }
    async fillData(mgd, openingTaskDetails) {
        return Promise.resolve();
    }
    async buildXML(message) {
        return Promise.resolve();
    }
}
class UserRange {
    constructor() {
        this.veeIdx = 0;
        this.min = null;
        this.max = null;
        this.nullMax = false;
        this.nullMin = false;
        this.discardMax = false;
        this.discardMin = false;
    }
}
class OpeningTaskDetails {
    constructor(callingTask, pathParentTask) {
        this.CallingTask = null;
        this.PathParentTask = null;
        if (arguments.length === 0) {
            this.constructor_0();
            return;
        }
        this.constructor_1(callingTask, pathParentTask);
    }
    constructor_0() {
        this.CallingTask = (this.PathParentTask = null);
    }
    constructor_1(callingTask, pathParentTask) {
        this.CallingTask = callingTask;
        this.PathParentTask = pathParentTask;
    }
}

class MgControl extends MgControlBase {
    initialize() {
        this._focusedStopExecution = false;
        this._inControlSuffix = false;
        this._rtEvtTask = null;
        this._subformTaskId = null;
        this._subformTask = null;
        this.IsInteractiveUpdate = false;
        this.refreshOnString = null;
        this.SubformLoaded = false;
        this.HasZoomHandler = false;
        this.ArgList = null;
    }
    constructor(type, taskOrParentMgForm, parentControlOrParentControlIdx) {
        if (arguments.length === 0)
            super();
        else if (arguments.length === 3 && (type === null || type.constructor === Number) && (taskOrParentMgForm === null || taskOrParentMgForm instanceof TaskBase) && (parentControlOrParentControlIdx === null || parentControlOrParentControlIdx.constructor === Number))
            super(type, taskOrParentMgForm.getForm(), parentControlOrParentControlIdx);
        else
            super(type, taskOrParentMgForm, parentControlOrParentControlIdx);
        this.initialize();
    }
    GetVarIndex() {
        return super.getForm().getTask().DataView.Dvcount + this.veeIndx;
    }
    async fillData(mgForm, ditIdx, parser) {
        super.fillData(mgForm, ditIdx, parser);
        this.ArgList = await this.GetArgumentList();
    }
    SetAttribute(attribute, valueStr) {
        let isTagProcessed = super.SetAttribute(attribute, valueStr);
        if (!isTagProcessed) {
            switch (attribute) {
                case ConstInterface.MG_ATTR_SUBFORM_TASK:
                    if (valueStr.trim() != "")
                        this._subformTaskId = valueStr;
                    break;
                case ConstInterface.MG_ATTR_REFRESHON:
                    this.refreshOnString = valueStr.trim();
                    break;
                default:
                    isTagProcessed = false;
                    Logger.Instance.WriteExceptionToLogWithMsg(NString.Format("Unrecognized attribute: '{0}'", attribute));
                    break;
            }
        }
        return isTagProcessed;
    }
    async GetArgumentList() {
        let argList = null;
        if (this._propTab === null)
            return argList;
        let ArgListProp = this._propTab.getPropById(PropInterface.PROP_TYPE_PARAMETERS);
        if (ArgListProp === null)
            return argList;
        let parms = await ArgListProp.getValue();
        if (parms !== null) {
            argList = new ArgumentsList();
            argList.fillList(parms, super.getForm().getTask());
            if (this.refreshOnString !== null)
                argList.RefreshOnString = this.refreshOnString;
        }
        return argList;
    }
    isDescendent(parentForm) {
        let isDescendent = false;
        let checkCurrentForm = super.getForm();
        Debug.Assert(parentForm !== null);
        while (!isDescendent && checkCurrentForm !== null) {
            if (parentForm === checkCurrentForm)
                isDescendent = true;
            else {
                let currTask = checkCurrentForm.getTask();
                if (currTask.getParent() !== null)
                    checkCurrentForm = currTask.getParent().getForm();
                else
                    break;
            }
        }
        return isDescendent;
    }
    async refreshOnExpression() {
        let i;
        let size = (this._propTab === null ? 0 : this._propTab.getSize());
        let prop;
        let refresh = false;
        for (i = 0; i < size && !refresh; i++) {
            prop = this._propTab.getProp(i);
            switch (prop.getID()) {
                case PropInterface.PROP_TYPE_DATA:
                    if (!prop.isExpression() && this._field !== null && this._field.getTask() !== this.getForm().getTask()) {
                        refresh = true;
                        break;
                    }
                case PropInterface.PROP_TYPE_FORMAT:
                case PropInterface.PROP_TYPE_VISIBLE:
                case PropInterface.PROP_TYPE_ENABLED:
                case PropInterface.PROP_TYPE_RANGE:
                case PropInterface.PROP_TYPE_TRANSLATOR:
                    if (prop.isExpression())
                        refresh = true;
                    break;
                default:
                    break;
            }
            if (refresh)
                await this.RefreshDisplay();
        }
    }
    async invoke() {
        let invoked = false;
        if (await this.isParkable(true)) {
            await AccessHelper.eventsManager.handleInternalEventWithMgControlBase(this, InternalInterface.MG_ACT_CTRL_PREFIX);
            invoked = true;
        }
        return invoked;
    }
    async isParkable(checkEnabledAndVisible) {
        let result = !super.isImageControl();
        if (result) {
            await super.checkProp(PropInterface.PROP_TYPE_ENABLED, true);
            await super.checkProp(PropInterface.PROP_TYPE_VISIBLE, true);
            result = await super.isParkable(checkEnabledAndVisible);
        }
        return result;
    }
    getSubformTaskId() {
        return this._subformTaskId;
    }
    initSubformTask() {
        if (super.isSubform())
            this._subformTask = GuiDataCollection.MGDataTable.GetTaskByID(this._subformTaskId);
    }
    getParentTable() {
        return this._parentTable;
    }
    async restoreOldValue() {
        if (this._field !== null)
            await this._field.updateDisplay();
        else {
            super.resetPrevVal();
            await super.SetAndRefreshDisplayValue(await this.getMgValue(this.Value), this.IsNull);
        }
    }
    setRtEvtTask(curTask) {
        this._rtEvtTask = curTask;
    }
    getRtEvtTask() {
        return this._rtEvtTask;
    }
    setSubformTaskId(taskId) {
        this._subformTaskId = taskId;
    }
    isFocusedStopExecution() {
        return this._focusedStopExecution;
    }
    setFocusedStopExecution(focusedStopExecution) {
        this._focusedStopExecution = focusedStopExecution;
    }
    onTheSameSubFormControl(ctrl) {
        let retValue = false;
        if (ctrl !== null) {
            if (super.getForm().isSubForm() && ctrl.getForm().isSubForm()) {
                if (super.getForm().getTask() === ctrl.getForm().getTask())
                    retValue = true;
            }
        }
        return retValue;
    }
    onDiffForm(ctrl) {
        let isSubform = super.getForm().isSubForm() || ctrl.getForm().isSubForm();
        let isOnDiffForm = (isSubform) && !this.onTheSameSubFormControl(ctrl);
        return isOnDiffForm;
    }
    isInControlSuffix() {
        return this._inControlSuffix;
    }
    setInControlSuffix(inControlSuffix) {
        this._inControlSuffix = inControlSuffix;
    }
    HasSelectProgram() {
        let HasSelectProgram = false;
        let selectProgProp = super.GetComputedProperty(PropInterface.PROP_TYPE_SELECT_PROGRAM);
        if (selectProgProp !== null && selectProgProp.GetComputedValue() !== null)
            HasSelectProgram = true;
        return HasSelectProgram;
    }
    useZoomHandler() {
        return this.HasZoomHandler || (super.getField() !== null && (super.getField().getHasZoomHandler() || (this.HasSelectProgram())));
    }
    async updatePropertyLogicNesting(propId, commandType, val, updateThis) {
        if (val && super.haveToCheckParentValue())
            val = super.isParentPropValue(propId);
        if (val && super.isSubform() && commandType === CommandType.PROP_SET_VISIBLE && this.ShouldSetSubformInvisible())
            val = false;
        if (updateThis) {
            Commands.addOperationWithLine(CommandType.SET_PROPERTY, this, super.getDisplayLine(false), commandType === CommandType.PROP_SET_VISIBLE ? HtmlProperties.Visible : HtmlProperties.Enabled, val);
        }
        await super.updateChildrenPropValue(propId, commandType, val);
    }
    ShouldSetSubformInvisible() {
        let setInvisible = false;
        let subformType = super.GetComputedProperty(PropInterface.PROP_TYPE_SUBFORM_TYPE).GetComputedValueInteger();
        if (subformType === SubformType.None && this.getSubformTaskId() === null)
            setInvisible = true;
        return setInvisible;
    }
    async updateSubformChildrenPropValue(propId, commandType, val) {
        Debug.Assert(super.isSubform());
        if (!super.getForm().getTask().AfterFirstRecordPrefix)
            return;
        let subformType = super.GetComputedProperty(PropInterface.PROP_TYPE_SUBFORM_TYPE).GetComputedValueInteger();
        if (this._subformTaskId !== null || subformType === SubformType.None) {
            if (this._subformTask !== null && this._subformTask.isStarted()) {
                this.SubformLoaded = true;
                if (commandType === CommandType.PROP_SET_VISIBLE && val && this.RefreshOnVisible) {
                    this.RefreshOnVisible = false;
                    await super.getForm().getTask().SubformRefresh(this._subformTask, true);
                }
                let subformForm = this._subformTask.getForm();
                for (let i = 0; i < subformForm.getCtrlCount(); i++) {
                    let child = subformForm.getCtrl(i);
                    if (!child.isColumnControl())
                        continue;
                    let childValue = await child.checkProp(propId, true) && val;
                    if (childValue)
                        childValue = child.isParentPropValue(propId);
                    await child.updateChildrenPropValue(propId, commandType, childValue);
                }
            }
        }
        else if ((commandType === CommandType.PROP_SET_VISIBLE && val) && !this.SubformLoaded) {
            this.SubformLoaded = true;
            await AccessHelper.eventsManager.handleInternalEventWithMgControlBase(this, InternalInterface.MG_ACT_SUBFORM_OPEN);
        }
    }
    Init() {
        this.initSubformTask();
    }
    GetTableBehaviour() {
        return TableBehaviour.UnlimitedItems;
    }
    async validateAndSetValue(NewValue, updateCtrl) {
        super.UpdateModifiedByUser(NewValue);
        if (this.ModifiedByUser) {
            let ctrlCurrValue = this.Value;
            let vd;
            if (super.getPIC() === null)
                return true;
            vd = super.buildPicture(ctrlCurrValue, NewValue);
            vd.evaluate();
            if (vd.ValidationFailed) {
                this.ModifiedByUser = false;
                return false;
            }
            this.IsInteractiveUpdate = true;
            super.getForm().getTask().setDataSynced(false);
            if (updateCtrl) {
                if (this._field !== null && this._field.getType() === StorageAttribute.NUMERIC && typeof NewValue === 'string' && NewValue.trim().length > 0)
                    vd.setValue(NewValue);
                await this.setValue(vd);
            }
        }
        return true;
    }
    async setValue(vd) {
        let isNull = vd.getIsNull();
        let newValue = vd.getDispValue();
        let mgVal;
        if (!isNull || !this._field.hasNullDisplayValue())
            mgVal = await super.getMgValue(newValue);
        else
            mgVal = ((this._field.getType() === StorageAttribute.BLOB_VECTOR) ? this._field.getCellDefualtValue() : this._field.getDefaultValue());
        if (mgVal !== null) {
            if (this._field !== null && (!(newValue === this.Value) || this.KeyStrokeOn || this.IsNull !== isNull)) {
                await this._field.setValueAndStartRecompute(mgVal, isNull, true, true, false);
                if (super.isCheckBox()) {
                    this.forceRefresh = true;
                    mgVal = this._field.getValue(false);
                }
            }
            if ((this._field !== null && isNull) && this._field.hasNullDisplayValue())
                mgVal = newValue;
            await super.SetAndRefreshDisplayValue(mgVal, isNull);
            this.forceRefresh = false;
            this.KeyStrokeOn = false;
        }
    }
    getSubformTask() {
        return this._subformTask;
    }
    resetSubformTask() {
        this._subformTask = null;
        this._subformTaskId = "0";
    }
    GetSubformMgForm() {
        let form = null;
        if (this._subformTask !== null)
            form = this._subformTask.getForm();
        return form;
    }
    IsTableWithAbsoluteScrollbar() {
        let tableWithAbsoluteScrollbar = false;
        Debug.Assert(this.Type === MgControlType.CTRL_TYPE_TABLE, "In MgControl.IsTableWithAbsoluteScrollbar(): Not a table control.");
        if (this._propTab.propExists(PropInterface.PROP_TYPE_SCROLL_BAR_THUMB))
            tableWithAbsoluteScrollbar = (this._propTab.getPropById(PropInterface.PROP_TYPE_SCROLL_BAR_THUMB).GetComputedValueInteger() === ScrollBarThumbType.Absolute);
        return tableWithAbsoluteScrollbar;
    }
    static validReturnToCtrl() {
        if (MgControl.ReturnToCtrl !== null && MgControl.ReturnToCtrl.getForm().getTask().isAborting())
            return false;
        return true;
    }
    maySetValue() {
        switch (this.Type) {
            case MgControlType.CTRL_TYPE_CHECKBOX:
            case MgControlType.CTRL_TYPE_TEXT:
            case MgControlType.CTRL_TYPE_COMBO:
            case MgControlType.CTRL_TYPE_LIST:
            case MgControlType.CTRL_TYPE_RADIO:
            case MgControlType.CTRL_TYPE_TAB:
                break;
            default:
                return false;
        }
        if (this._field === null || this._valExpId > 0)
            return false;
        return this.isModifiable();
    }
    async validateAndSetValueIfAllowed(NewValue, refreshDisplay) {
        if (!this.maySetValue()) {
            Logger.Instance.WriteErrorToLog(NString.Format("Unable to change value of control {0}: The control is read-only.", this.Name));
            return false;
        }
        let retVal = await this.validateAndSetValue(NewValue, true);
        if (!retVal)
            Logger.Instance.WriteErrorToLog(NString.Format("Value validation failed for {0}.", this.Name));
        if (refreshDisplay) {
            Commands.addNoParameters(CommandType.REFRESH_TASK, this.getForm());
            Commands.invoke();
        }
        return retVal;
    }
}
MgControl.ReturnToCtrl = null;

class MgPriorityQueue {
    constructor() {
        this._queue = null;
        this.Size = 0;
        this._queue = new Array(MgPriorityQueue.DEFAULT_INITIAL_CAPACITY + 1);
        for (let _ai = 0; _ai < this._queue.length; ++_ai)
            this._queue[_ai] = null;
    }
    offer(o) {
        ++this.Size;
        if (this.Size >= this._queue.length)
            this._queue.length = this.Size;
        this._queue[this.Size] = o;
        this.fixUp(this.Size);
        return true;
    }
    peek() {
        if (this.Size === 0)
            return null;
        return this._queue[1];
    }
    isEmpty() {
        return this.Size === 0;
    }
    clear() {
        for (let i = 1; i <= this.Size; i++)
            this._queue[i] = null;
        this.Size = 0;
    }
    poll() {
        if (this.Size === 0)
            return null;
        let result = this._queue[1];
        this._queue[1] = this._queue[this.Size];
        this._queue[this.Size--] = null;
        if (this.Size > 1)
            this.fixDown(1);
        return result;
    }
    fixUp(k) {
        while (k > 1) {
            let j = k >> 1;
            if (this._queue[j].CompareTo(this._queue[k]) <= 0)
                break;
            let tmp = this._queue[j];
            this._queue[j] = this._queue[k];
            this._queue[k] = tmp;
            k = j;
        }
    }
    fixDown(k) {
        let j;
        while ((j = k << 1) <= this.Size && j > 0) {
            if (j < this.Size && this._queue[j].CompareTo(this._queue[j + 1]) > 0)
                j++;
            if (this._queue[k].CompareTo(this._queue[j]) <= 0)
                break;
            let tmp = this._queue[j];
            this._queue[j] = this._queue[k];
            this._queue[k] = tmp;
            k = j;
        }
    }
}
MgPriorityQueue.DEFAULT_INITIAL_CAPACITY = 11;

class TasksTable {
    constructor() {
        this._tasks = null;
        this._tasks = new List();
    }
    async fillData(mgdata, openingTaskDetails, parser) {
        while (await this.initInnerObjects(parser.getNextTag(), mgdata, openingTaskDetails)) {
        }
    }
    async initInnerObjects(foundTagName, mgdata, openingTaskDetails) {
        let result;
        if (foundTagName === null) {
            result = false;
        }
        else {
            if (foundTagName === XMLConstants.MG_TAG_TASK) {
                let task = TasksTable.createNewtask();
                this._tasks.push(task);
                await task.fillData(mgdata, openingTaskDetails);
                result = true;
            }
            else {
                result = false;
            }
        }
        return result;
    }
    addTask(task) {
        this._tasks.push(task);
    }
    removeTask(task) {
        this._tasks.Remove(task);
    }
    getTask(tasktagOrIdx) {
        if (arguments.length === 1 && (tasktagOrIdx === null || typeof tasktagOrIdx === "undefined" || tasktagOrIdx.constructor === String)) {
            return this.getTask_0(tasktagOrIdx);
        }
        return this.getTask_1(tasktagOrIdx);
    }
    getTask_0(tasktag) {
        let result;
        for (let i = 0; i < this._tasks.length; i = i + 1) {
            let task = this._tasks.get_Item(i);
            if (tasktag === task.getTaskTag()) {
                result = task;
                return result;
            }
        }
        result = null;
        return result;
    }
    getTask_1(idx) {
        let result;
        if (idx >= 0 && idx < this._tasks.length) {
            result = this._tasks.get_Item(idx);
        }
        else {
            result = null;
        }
        return result;
    }
    getSize() {
        return this._tasks.length;
    }
    async buildXML(message) {
        for (let i = 0; i < this.getSize(); i = i + 1) {
            await this.getTask(i).buildXML(message);
        }
    }
    setTaskAt(task, index) {
        if (this._tasks.length <= index) {
            this._tasks.SetSize(index + 1);
        }
        this._tasks.set_Item(index, task);
    }
}
TasksTable.createNewtask = null;

class LastFocusedManager {
    constructor() {
        this._lastFocusedTasks = null;
        this.LastActionTime = 0;
    }
    Init(mgDataTable) {
        this._lastFocusedTasks = new TasksTable();
    }
    getCurrTask() {
        let rtEvnt = AccessHelper.eventsManager.getLastRtEvent();
        return (rtEvnt !== null && rtEvnt.getTask() !== null && rtEvnt.getTask().GetContextTask() !== null)
            ? this.getLastFocusedTask(rtEvnt.getTask().GetContextTask().getMgdID())
            : this.getLastFocusedTask();
    }
    getLastFocusedTask(mgdID) {
        if (arguments.length === 0)
            return this._lastFocusedTasks.getTask(AccessHelper.mgDataTable.currMgdID);
        else
            return this._lastFocusedTasks.getTask(mgdID);
    }
    setLastFocusedTask(iTask) {
        let task = iTask;
        let currMgdID = task.getMgdID();
        this._lastFocusedTasks.setTaskAt(task, currMgdID);
    }
    clean(index) {
        LastFocusedManager.deleteLastFocusedControlAt(index);
        if (this._lastFocusedTasks !== null) {
            this._lastFocusedTasks.setTaskAt(null, index);
        }
    }
    static getLastFocusedControl(mgdID) {
        if (arguments.length === 1)
            return LastFocusedManager.getLastFocusedControl_1(mgdID);
        else
            return LastFocusedManager.getLastFocusedControl_0();
    }
    static getLastFocusedControl_0() {
        return LastFocusedManager._lastFocusedControls.getCtrl(AccessHelper.mgDataTable.currMgdID);
    }
    static getLastFocusedControl_1(mgdID) {
        return LastFocusedManager._lastFocusedControls.getCtrl(mgdID);
    }
    static deleteLastFocusedControlAt(index) {
        if (LastFocusedManager._lastFocusedControls !== null && LastFocusedManager._lastFocusedControls.getCtrl(index) != null) {
            LastFocusedManager._lastFocusedControls.deleteControlAt(index);
        }
    }
    static setLastFocusedControlAt(ctrl, currMgdID) {
        LastFocusedManager._lastFocusedControls.setControlAt(ctrl, currMgdID);
    }
    static setLastFocusedControl(task, mgControl) {
        let currMgdID = task.getMgdID();
        Debug.Assert(mgControl === null || task === mgControl.getForm().getTask());
        LastFocusedManager.LastFocusMgdID = currMgdID;
        LastFocusedManager.setLastFocusedControlAt(mgControl, currMgdID);
        LastFocusedManager.Instance.setLastFocusedTask(task);
    }
}
LastFocusedManager.Instance = new LastFocusedManager();
LastFocusedManager._lastFocusedControls = new ControlTable();
LastFocusedManager.LastFocusMgdID = 0;

class Event {
    constructor() {
        this.Exp = null;
        this._forceExit = ForceExit.None;
        this.kbdItm = null;
        this._paramAttrs = null;
        this._paramNulls = null;
        this._paramVals = null;
        this._parameters = 0;
        this._returnExp = 0;
        this._seconds = Int32.MinValue;
        this._timestamp = 0;
        this._type = Char.MinValue;
        this._userDefinedFuncName = null;
        this._userDefinedFuncNameHashCode = 0;
        this._userEvtDesc = '';
        this._userEvtIdx = Int32.MinValue;
        this.InternalEvent = 0;
        this.PublicName = null;
        this.UserEvt = null;
        this.UserEvtTaskTag = null;
        this.constructor_0();
    }
    constructor_0() {
        this.InternalEvent = Int32.MinValue;
        this.setTimestamp();
    }
    constructor_1(evt) {
        this._type = evt._type;
        this.kbdItm = evt.kbdItm;
        this.InternalEvent = evt.InternalEvent;
        this._seconds = evt._seconds;
        this.Exp = evt.Exp;
        this._forceExit = evt._forceExit;
        this.UserEvt = evt.UserEvt;
        this.UserEvtTaskTag = evt.UserEvtTaskTag;
        this._userEvtIdx = evt._userEvtIdx;
        this._timestamp = 0;
    }
    get ForceExit() {
        return this._forceExit;
    }
    fillData(xmlParser, taskRef) {
        let userValue;
        let endContext = xmlParser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, xmlParser.getCurrIndex());
        if (endContext !== -1 && endContext < xmlParser.getXMLdata().length) {
            let tag = xmlParser.getXMLsubstring(endContext);
            xmlParser.add2CurrIndex(tag.indexOf(ConstInterface.MG_TAG_EVENT) + ConstInterface.MG_TAG_EVENT.length);
            let tokensVector = XmlParser.getTokens(xmlParser.getXMLsubstring(endContext), XMLConstants.XML_ATTR_DELIM);
            let refUserValue = new RefParam(userValue);
            this.initElements(tokensVector, taskRef, refUserValue);
            userValue = refUserValue.value;
            xmlParser.setCurrIndex(endContext + XMLConstants.TAG_CLOSE.length);
            this.InitInnerObjects(xmlParser);
            if (userValue !== null)
                this.InitUserData(taskRef, userValue);
        }
        else
            Logger.Instance.WriteExceptionToLogWithMsg('in Event.FillData() out of string bounds');
    }
    InitInnerObjects(xmlParser) {
        let nextTag = xmlParser.getNextTag();
        switch (nextTag) {
            case XMLConstants.MG_TAG_TASKDEFINITIONID_ENTRY:
                let xmlBuffer = xmlParser.ReadToEndOfCurrentElement();
                this.InitTaskDefinitionId(xmlBuffer);
                let endContext = xmlParser.getXMLdata().indexOf(ConstInterface.MG_TAG_EVENT + XMLConstants.TAG_CLOSE, xmlParser.getCurrIndex());
                xmlParser.setCurrIndex(endContext + (ConstInterface.MG_TAG_EVENT + XMLConstants.TAG_CLOSE).length);
                break;
            default:
                break;
        }
    }
    initElements(tokensVector, taskRef, refUserValue) {
        let modifier = Modifiers.MODIFIER_NONE;
        let keyCode = -1;
        refUserValue.value = null;
        for (let j = 0; j < tokensVector.length; j += 2) {
            let attribute = (tokensVector.get_Item(j));
            let valueStr = (tokensVector.get_Item(j + 1));
            switch (attribute) {
                case ConstInterface.MG_ATTR_EVENTTYPE:
                    this._type = valueStr[0];
                    break;
                case ConstInterface.MG_ATTR_MODIFIER:
                    modifier = valueStr[0];
                    break;
                case ConstInterface.MG_ATTR_INTERNALEVENT:
                    this.InternalEvent = XmlParser.getInt(valueStr);
                    break;
                case ConstInterface.MG_ATTR_KEYCODE:
                    keyCode = XmlParser.getInt(valueStr);
                    break;
                case ConstInterface.MG_ATTR_SECONDS:
                    this._seconds = XmlParser.getInt(valueStr);
                    break;
                case XMLConstants.MG_ATTR_EXP:
                    this.Exp = taskRef.getExpById(XmlParser.getInt(valueStr));
                    break;
                case ConstInterface.MG_ATTR_FORCE_EXIT:
                    this._forceExit = valueStr[0];
                    break;
                case ConstInterface.MG_ATTR_DESC:
                    this._userEvtDesc = XmlParser.unescape(valueStr);
                    break;
                case ConstInterface.MG_ATTR_PUBLIC:
                    this.PublicName = XmlParser.unescape(valueStr);
                    break;
                case ConstInterface.MG_ATTR_PARAMS:
                    this._parameters = XmlParser.getInt(valueStr);
                    break;
                case ConstInterface.MG_ATTR_PAR_ATTRS:
                    this._paramAttrs = valueStr;
                    break;
                case XMLConstants.MG_ATTR_VALUE:
                    let paramStr = XmlParser.unescape(valueStr);
                    this._paramVals = new Array(this._parameters);
                    this.parseParamVal(paramStr);
                    break;
                case ConstInterface.MG_ATTR_NULLS:
                    this._paramNulls = valueStr;
                    break;
                case ConstInterface.MG_ATTR_USER:
                    refUserValue.value = valueStr;
                    break;
                case XMLConstants.MG_ATTR_NAME:
                    this.setUserDefinedFuncName(valueStr);
                    break;
                case ConstInterface.MG_TAG_USR_DEF_FUC_RET_EXP_ID:
                    this._returnExp = XmlParser.getInt(valueStr);
                    break;
                case ConstInterface.MG_TAG_USR_DEF_FUC_RET_EXP_ATTR:
                    break;
                default:
                    Logger.Instance.WriteExceptionToLogWithMsg(NString.Format('There is no such tag in Event class. Insert case to Event.initElements for {0}', attribute));
                    break;
            }
        }
        if (this._type === ConstInterface.EVENT_TYPE_SYSTEM)
            this.kbdItm = new KeyboardItem(keyCode, modifier);
    }
    InitUserData(taskRef, userValue) {
        let comma = userValue.indexOf(',');
        if (comma > -1) {
            let ueTaskId = userValue.substr(0, comma);
            if (taskRef !== null)
                ueTaskId = taskRef.TaskService.GetEventTaskId(ueTaskId);
            let ueTask = AccessHelper.mgDataTable.GetTaskByID(ueTaskId);
            let ueIdx = XmlParser.getInt(userValue.substr(comma + 1));
            if (ueTask !== null) {
                this.UserEvt = ueTask.getUserEvent(ueIdx);
                if (this.UserEvt === null) {
                    throw new ApplicationException('in Event.fillData(): user event not found. task id = ' + ueTaskId +
                        ', user event index = ' + ueIdx);
                }
                this.UserEvtTaskTag = ueTaskId;
                this._userEvtIdx = ueIdx;
            }
            else {
                this.UserEvtTaskTag = ueTaskId;
                this._userEvtIdx = ueIdx;
                this.UserEvt = null;
            }
        }
    }
    InitTaskDefinitionId(xmlBuffer) {
        let handler = new TaskDefinitionIdTableSaxHandler(this.SetTaskDefinitionId);
        handler.parse(xmlBuffer);
    }
    SetTaskDefinitionId(taskDefinitionId) {
    }
    findUserEvent() {
        if (this._type === ConstInterface.EVENT_TYPE_USER && this.UserEvt === null) {
            let ueTask = AccessHelper.mgDataTable.GetTaskByID(this.UserEvtTaskTag);
            if (ueTask !== null)
                this.UserEvt = ueTask.getUserEvent(this._userEvtIdx);
            if (this.UserEvt === null)
                throw new ApplicationException(NString.Format('in Event.findUserEvent(): user event not found. task id = {0} doesn\'t exist', this.UserEvtTaskTag));
        }
    }
    equals(evt) {
        let bEqual = false;
        if (this === evt)
            bEqual = true;
        else if (this._type === evt._type) {
            switch (this._type) {
                case ConstInterface.EVENT_TYPE_SYSTEM:
                    bEqual = this.kbdItm.equals(evt.kbdItm);
                    break;
                case ConstInterface.EVENT_TYPE_INTERNAL:
                    bEqual = (this.InternalEvent === evt.InternalEvent);
                    break;
                case ConstInterface.EVENT_TYPE_TIMER:
                    bEqual = (this._seconds === evt._seconds);
                    break;
                case ConstInterface.EVENT_TYPE_EXPRESSION:
                case ConstInterface.EVENT_TYPE_PUBLIC:
                    bEqual = (this.Exp === evt.Exp);
                    break;
                case ConstInterface.EVENT_TYPE_USER:
                    bEqual = (this.UserEvt === evt.UserEvt);
                    break;
                case ConstInterface.EVENT_TYPE_USER_FUNC:
                    if (this._userDefinedFuncNameHashCode === evt.getUserDefinedFuncNameHashCode()) {
                        if (NString.Equals(evt.getUserDefinedFuncName(), this._userDefinedFuncName, true))
                            bEqual = true;
                    }
                    break;
                default:
                    bEqual = false;
                    break;
            }
        }
        if (this._type === ConstInterface.EVENT_TYPE_PUBLIC || evt._type === ConstInterface.EVENT_TYPE_PUBLIC) {
            let name1 = null;
            let name2 = null;
            if (this._type !== ConstInterface.EVENT_TYPE_USER && evt._type !== ConstInterface.EVENT_TYPE_USER)
                bEqual = false;
            else if (this._type === ConstInterface.EVENT_TYPE_PUBLIC) {
                name1 = this.PublicName;
                name2 = evt.getUserEvent().PublicName;
            }
            else {
                name1 = evt.PublicName;
                name2 = this.getUserEvent().PublicName;
            }
            if (name1 === null || name2 === null)
                bEqual = false;
            else
                bEqual = (name1 === name2);
        }
        else if (this._type === ConstInterface.EVENT_TYPE_INTERNAL && evt._type === ConstInterface.EVENT_TYPE_SYSTEM) {
            if (LastFocusedManager.Instance.getCurrTask() !== null && (AccessHelper.eventsManager.getMatchingAction(evt.getKbdItm())) === this.getInternalCode())
                bEqual = true;
        }
        else if (this._type === ConstInterface.EVENT_TYPE_USER && evt._type !== ConstInterface.EVENT_TYPE_USER) {
            this.findUserEvent();
            bEqual = this.UserEvt.equals(evt);
        }
        return bEqual;
    }
    async setPublicName() {
        if (this._type === ConstInterface.EVENT_TYPE_PUBLIC && this.Exp !== null) {
            this.PublicName = (await this.Exp.evaluateWithResLength(255)).mgVal;
            if (this.PublicName !== null)
                this.PublicName = StrUtil.rtrim(this.PublicName);
        }
    }
    setInternal(code) {
        this._type = ConstInterface.EVENT_TYPE_INTERNAL;
        this.InternalEvent = code;
        if (code === InternalInterface.MG_ACT_HIT || code === InternalInterface.MG_ACT_CTRL_HIT)
            LastFocusedManager.Instance.LastActionTime = Misc.getSystemMilliseconds();
    }
    setExpression(expRef) {
        this._type = ConstInterface.EVENT_TYPE_EXPRESSION;
        this.Exp = expRef;
    }
    getExpression() {
        return this.Exp;
    }
    getUsrEvntDesc() {
        return (this.UserEvt !== null) ? this.UserEvt._userEvtDesc : this._userEvtDesc;
    }
    setSystem(keyboardItem) {
        this._type = ConstInterface.EVENT_TYPE_SYSTEM;
        this.kbdItm = keyboardItem;
    }
    setKeyboardItem(keyboardItem) {
        this.kbdItm = keyboardItem;
    }
    getType() {
        return this._type;
    }
    setType(aType) {
        this._type = aType;
    }
    getInternalCode() {
        if (this._type === ConstInterface.EVENT_TYPE_INTERNAL)
            return this.InternalEvent;
        return Int32.MinValue;
    }
    getKbdItm() {
        if (this._type === ConstInterface.EVENT_TYPE_SYSTEM)
            return this.kbdItm;
        return null;
    }
    getKbdItmAlways() {
        return this.kbdItm;
    }
    async dataEventIsTrue() {
        if (this._type !== ConstInterface.EVENT_TYPE_EXPRESSION &&
            !(this._type === ConstInterface.EVENT_TYPE_USER && this.getUserEventType() === ConstInterface.EVENT_TYPE_EXPRESSION))
            return true;
        if (this._type !== ConstInterface.EVENT_TYPE_USER)
            return DisplayConvertor.toBoolean(await this.Exp.evaluateWithResultTypeAndLength(StorageAttribute.BOOLEAN, 0));
        return DisplayConvertor.toBoolean(await this.UserEvt.getExpression().evaluateWithResultTypeAndLength(StorageAttribute.BOOLEAN, 0));
    }
    getSeconds() {
        return this._seconds;
    }
    getBrkLevel(flowMonitor) {
        if (arguments.length === 0) {
            return this.getBrkLevel_0();
        }
        return this.getBrkLevel_1(flowMonitor);
    }
    getBrkLevel_0() {
        return this.getBrkLevel(false);
    }
    getBrkLevel_1(flowMonitor) {
        let level = '';
        switch (this._type) {
            case ConstInterface.EVENT_TYPE_INTERNAL:
                switch (this.InternalEvent) {
                    case InternalInterface.MG_ACT_TASK_PREFIX:
                        level = flowMonitor ? ConstInterface.BRK_LEVEL_TASK_PREFIX_FM : ConstInterface.BRK_LEVEL_TASK_PREFIX;
                        break;
                    case InternalInterface.MG_ACT_TASK_SUFFIX:
                        level = flowMonitor ? ConstInterface.BRK_LEVEL_TASK_SUFFIX_FM : ConstInterface.BRK_LEVEL_TASK_SUFFIX;
                        break;
                    case InternalInterface.MG_ACT_REC_PREFIX:
                        level = flowMonitor ? ConstInterface.BRK_LEVEL_REC_PREFIX_FM : ConstInterface.BRK_LEVEL_REC_PREFIX;
                        break;
                    case InternalInterface.MG_ACT_REC_SUFFIX:
                        level = flowMonitor ? ConstInterface.BRK_LEVEL_REC_SUFFIX_FM : ConstInterface.BRK_LEVEL_REC_SUFFIX;
                        break;
                    case InternalInterface.MG_ACT_CTRL_PREFIX:
                        level = flowMonitor ? ConstInterface.BRK_LEVEL_CTRL_PREFIX_FM : ConstInterface.BRK_LEVEL_CTRL_PREFIX + '_';
                        break;
                    case InternalInterface.MG_ACT_CTRL_SUFFIX:
                        level = flowMonitor ? ConstInterface.BRK_LEVEL_CTRL_SUFFIX_FM : ConstInterface.BRK_LEVEL_CTRL_SUFFIX + '_';
                        break;
                    case InternalInterface.MG_ACT_CTRL_VERIFICATION:
                        level = flowMonitor ? ConstInterface.BRK_LEVEL_CTRL_VERIFICATION_FM : ConstInterface.BRK_LEVEL_CTRL_VERIFICATION + '_';
                        break;
                    case InternalInterface.MG_ACT_VARIABLE:
                        level = flowMonitor ? ConstInterface.BRK_LEVEL_VARIABLE_FM : ConstInterface.BRK_LEVEL_VARIABLE + '_';
                        break;
                    default:
                        level = flowMonitor ? ConstInterface.BRK_LEVEL_HANDLER_INTERNAL_FM : ConstInterface.BRK_LEVEL_HANDLER_INTERNAL + '_';
                        break;
                }
                level += Event.getInternalEvtDescription(this.InternalEvent);
                break;
            case ConstInterface.EVENT_TYPE_SYSTEM:
                level = flowMonitor ? ConstInterface.BRK_LEVEL_HANDLER_SYSTEM_FM : ConstInterface.BRK_LEVEL_HANDLER_SYSTEM + '_';
                level += this.getKeyboardItemString();
                break;
            case ConstInterface.EVENT_TYPE_TIMER:
                level = flowMonitor ? ConstInterface.BRK_LEVEL_HANDLER_TIMER_FM + ' ' + this.seconds2String() : ConstInterface.BRK_LEVEL_HANDLER_TIMER + '_' + this.seconds2String();
                break;
            case ConstInterface.EVENT_TYPE_EXPRESSION:
                level = flowMonitor ? ConstInterface.BRK_LEVEL_HANDLER_EXPRESSION_FM : ConstInterface.BRK_LEVEL_HANDLER_EXPRESSION + '_' + this.Exp.getId();
                break;
            case ConstInterface.EVENT_TYPE_USER:
                level = (flowMonitor ? (ConstInterface.BRK_LEVEL_HANDLER_USER_FM + ': ') : (ConstInterface.BRK_LEVEL_HANDLER_USER + '_')) + (this.UserEvt != null ? this.UserEvt._userEvtDesc : this._userEvtDesc);
                break;
            case ConstInterface.EVENT_TYPE_USER_FUNC:
                level = (flowMonitor ? (ConstInterface.BRK_LEVEL_USER_FUNCTION_FM + ':') : (ConstInterface.BRK_LEVEL_USER_FUNCTION + '_')) + this._userDefinedFuncName;
                break;
        }
        return level;
    }
    static getInternalEvtDescription(internalEventCode) {
        let description;
        switch (internalEventCode) {
            case InternalInterface.MG_ACT_ABOUT:
                description = 'About Magic';
                break;
            case InternalInterface.MG_ACT_ACTION_LIST:
                description = 'Action List';
                break;
            case InternalInterface.MG_ACT_ADD_HYPERLINK:
                description = '';
                break;
            case InternalInterface.MG_ACT_ALIGN_LEFT:
                description = 'Left';
                break;
            case InternalInterface.MG_ACT_ALIGN_RIGHT:
                description = 'Right';
                break;
            case InternalInterface.MG_ACT_APPL_PROPERTIES:
                description = '';
                break;
            case InternalInterface.MG_ACT_APPLICATIONS:
                description = 'Applications';
                break;
            case InternalInterface.MG_ACT_APPLICATIONS_LIST:
                description = 'Applications List';
                break;
            case InternalInterface.MG_ACT_ATTACH_TO_TABLE:
                description = 'Attach to Table';
                break;
            case InternalInterface.MG_ACT_AUTHORIZE:
                description = 'Authorize';
                break;
            case InternalInterface.MG_ACT_EDT_BEGFLD:
                description = 'Begin Field';
                break;
            case InternalInterface.MG_ACT_EDT_BEGFORM:
                description = 'Begin Form';
                break;
            case InternalInterface.MG_ACT_EDT_BEGLINE:
                description = 'Begin Line';
                break;
            case InternalInterface.MG_ACT_EDT_BEGNXTLINE:
                description = 'Begin Next Line';
                break;
            case InternalInterface.MG_ACT_EDT_BEGPAGE:
                description = 'Begin Page';
                break;
            case InternalInterface.MG_ACT_TBL_BEGLINE:
                description = 'Begin Row';
                break;
            case InternalInterface.MG_ACT_TBL_BEGPAGE:
                description = 'Begin Screen';
                break;
            case InternalInterface.MG_ACT_TBL_BEGTBL:
                description = 'Begin table';
                break;
            case InternalInterface.MG_ACT_BOTTOM:
                description = 'Bottom';
                break;
            case InternalInterface.MG_ACT_BULLET:
                description = 'Bullet';
                break;
            case InternalInterface.MG_ACT_BUTTON:
                description = 'Button Press';
                break;
            case InternalInterface.MG_ACT_CANCEL:
                description = 'Cancel';
                break;
            case InternalInterface.MG_ACT_RT_QUIT:
                description = 'Quit';
                break;
            case InternalInterface.MG_ACT_CENTER:
                description = 'Center';
                break;
            case InternalInterface.MG_ACT_CHECK_SYNTAX:
                description = 'Check Syntax';
                break;
            case InternalInterface.MG_ACT_CHECK_TO_END:
                description = 'Check to End';
                break;
            case InternalInterface.MG_ACT_CLEAR_TEMPLATE:
                description = 'Clear Template';
                break;
            case InternalInterface.MG_ACT_CLEAR_VALUE:
                description = 'Clear Value';
                break;
            case InternalInterface.MG_ACT_CLOSE:
                description = 'Close';
                break;
            case InternalInterface.MG_ACT_ACT_CLOSE_APPL:
                description = 'Close Application';
                break;
            case InternalInterface.MG_ACT_COMMUNICATIONS:
                description = 'Communications';
                break;
            case InternalInterface.MG_ACT_COMPONENTS:
                description = 'Components';
                break;
            case InternalInterface.MG_ACT_CTRL_HIT:
                description = 'Control Hit';
                break;
            case InternalInterface.MG_ACT_CONTROL_NAME_LIST:
                description = 'Control Name List';
                break;
            case InternalInterface.MG_ACT_CLIP_COPY:
                description = 'Copy';
                break;
            case InternalInterface.MG_ACT_COPY_LAYOUT:
                description = 'Copy Layout';
                break;
            case InternalInterface.MG_ACT_COPY_SUBTREE:
                description = 'Copy Subtree';
                break;
            case InternalInterface.MG_ACT_CRELINE:
                description = 'Create Line';
                break;
            case InternalInterface.MG_ACT_CRELINE_ABOVE:
                description = 'Create Line Above';
                break;
            case InternalInterface.MG_ACT_CREATE_PARENT:
                description = 'Create Parent';
                break;
            case InternalInterface.MG_ACT_RTO_CREATE:
                description = 'Create Records';
                break;
            case InternalInterface.MG_ACT_CREATE_SUBTASK:
                description = 'Create Subtask';
                break;
            case InternalInterface.MG_ACT_CROSS_REFERENCE:
                description = 'Cross Reference';
                break;
            case InternalInterface.MG_ACT_CUT:
                description = 'Cut';
                break;
            case InternalInterface.MG_ACT_DB_TABLES:
                description = '';
                break;
            case InternalInterface.MG_ACT_DBMS:
                description = 'DBMS';
                break;
            case InternalInterface.MG_ACT_DDF_MAKE:
                description = 'DDF Make';
                break;
            case InternalInterface.MG_ACT_DATABASES:
                description = 'Databases';
                break;
            case InternalInterface.MG_ACT_DEFAULT_LAYOUT:
                description = 'Default Layout';
                break;
            case InternalInterface.MG_ACT_DEFINE_EXPRESSION:
                description = 'Define Expression';
                break;
            case InternalInterface.MG_ACT_EDT_DELCURCH:
                description = 'Current Char';
                break;
            case InternalInterface.MG_ACT_EDT_DELPRVCH:
                description = 'Previous Char';
                break;
            case InternalInterface.MG_ACT_DELETE_HYPERLINK:
                description = 'Delete Hyperlink';
                break;
            case InternalInterface.MG_ACT_DELLINE:
                description = 'Delete Line';
                break;
            case InternalInterface.MG_ACT_DELETE_SUBTREE:
                description = 'Delete Subtree';
                break;
            case InternalInterface.MG_ACT_RT_COPYFLD:
                description = 'Ditto';
                break;
            case InternalInterface.MG_ACT_DISPLAY_REFRESH:
                description = 'Display Refresh';
                break;
            case InternalInterface.MG_ACT_EDIT_MAIN_FORM:
                description = 'Edit Main Form';
                break;
            case InternalInterface.MG_ACT_EDT_ENDFLD:
                description = 'End Field';
                break;
            case InternalInterface.MG_ACT_EDT_ENDFORM:
                description = 'End Form';
                break;
            case InternalInterface.MG_ACT_EDT_ENDLINE:
                description = 'End Line';
                break;
            case InternalInterface.MG_ACT_EDT_ENDPAGE:
                description = 'End Page';
                break;
            case InternalInterface.MG_ACT_TBL_ENDLINE:
                description = 'End Row';
                break;
            case InternalInterface.MG_ACT_TBL_ENDPAGE:
                description = 'End Screen';
                break;
            case InternalInterface.MG_ACT_TBL_ENDTBL:
                description = 'End Table';
                break;
            case InternalInterface.MG_ACT_ENVIRONMENT:
                description = 'Environment';
                break;
            case InternalInterface.MG_ACT_EXECUTE_PROGRAM:
                description = 'Execute Program';
                break;
            case InternalInterface.MG_ACT_EXECUTE_REPORT:
                description = 'Execute Report';
                break;
            case InternalInterface.MG_ACT_EXIT:
                description = 'Exit';
                break;
            case InternalInterface.MG_ACT_EXIT_SYSTEM:
                description = 'Exit System';
                break;
            case InternalInterface.MG_ACT_EXPORT_IMPORT:
                description = 'Export/Import';
                break;
            case InternalInterface.MG_ACT_EXPRESSION_RULES:
                description = 'Expression rules';
                break;
            case InternalInterface.MG_ACT_EXTERNAL_EDITOR:
                description = 'External Editor';
                break;
            case InternalInterface.MG_ACT_EXT_EVENT:
                description = 'External Event';
                break;
            case InternalInterface.MG_ACT_FORMS:
                description = 'Forms';
                break;
            case InternalInterface.MG_ACT_FROM_VALUE:
                description = 'From Value';
                break;
            case InternalInterface.MG_ACT_FUNCTION_LIST:
                description = 'Function List';
                break;
            case InternalInterface.MG_ACT_GENERATE_FORM:
                description = 'Generate Form';
                break;
            case InternalInterface.MG_ACT_GENERATE_PROGRAM:
                description = 'Generate Program';
                break;
            case InternalInterface.MG_ACT_GO_TO_TOP:
                description = 'Go to Top';
                break;
            case InternalInterface.MG_ACT_H_CENTER_OF_FORM:
                description = '';
                break;
            case InternalInterface.MG_ACT_HTML_STYLES:
                description = 'HTML Styles';
                break;
            case InternalInterface.MG_ACT_HELP:
                description = 'Help';
                break;
            case InternalInterface.MG_ACT_HELP_SCREENS:
                description = 'Help Screens';
                break;
            case InternalInterface.MG_ACT_HORIZ_CENTER:
                description = 'Horiz. Center';
                break;
            case InternalInterface.MG_ACT_I_O_FILES:
                description = 'Tables';
                break;
            case InternalInterface.MG_ACT_INDENT:
                description = 'Indent';
                break;
            case InternalInterface.MG_ACT_INSERT_OBJECT:
                description = 'Insert Object';
                break;
            case InternalInterface.MG_ACT_JUMP_TO_ROW:
                description = 'Jump to Row';
                break;
            case InternalInterface.MG_ACT_KEYBOARD_LIST:
                description = 'Keyboard List';
                break;
            case InternalInterface.MG_ACT_KEYBOARD_MAPPING:
                description = 'Keyboard Mapping';
                break;
            case InternalInterface.MG_ACT_LANGUAGES:
                description = 'languages';
                break;
            case InternalInterface.MG_ACT_RTO_SEARCH:
                description = 'Locate Next';
                break;
            case InternalInterface.MG_ACT_RTO_LOCATE:
                description = 'Locate a Record';
                break;
            case InternalInterface.MG_ACT_LOGICALPNAMES:
                description = '';
                break;
            case InternalInterface.MG_ACT_LOGON:
                description = 'Logon';
                break;
            case InternalInterface.MG_ACT_USING_HELP:
                description = 'Help Topics';
                break;
            case InternalInterface.MG_ACT_EDT_MARKNXTCH:
                description = 'Mark Next Char';
                break;
            case InternalInterface.MG_ACT_MARK_NEXT_LINE:
                description = 'Mark Next Line MLE';
                break;
            case InternalInterface.MG_ACT_EDT_MARKPRVCH:
                description = 'Mark Previous Char';
                break;
            case InternalInterface.MG_ACT_EDT_MARKPRVLINE:
                description = 'Mark Previous Line MLE';
                break;
            case InternalInterface.MG_ACT_MARK_SUBTREE:
                description = '';
                break;
            case InternalInterface.MG_ACT_EDT_MARKTOBEG:
                description = 'Mark To Beginning';
                break;
            case InternalInterface.MG_ACT_EDT_MARKTOEND:
                description = 'Mark To End';
                break;
            case InternalInterface.MG_ACT_MAXIMUM_HEIGHT:
                description = 'Maximum Height';
                break;
            case InternalInterface.MG_ACT_MAXIMUM_WIDTH:
                description = 'Maximum Width';
                break;
            case InternalInterface.MG_ACT_MENU_BAR:
                description = 'Menu Bar';
                break;
            case InternalInterface.MG_ACT_MENUS:
                description = '';
                break;
            case InternalInterface.MG_ACT_MINIMUM_HEIGHT:
                description = 'Minimum Height';
                break;
            case InternalInterface.MG_ACT_MINIMUM_WIDTH:
                description = 'Minimum Width';
                break;
            case InternalInterface.MG_ACT_RTO_MODIFY:
                description = 'Modify Records';
                break;
            case InternalInterface.MG_ACT_MONITOR_DEBUGGER:
                description = 'Monitor/Debugger';
                break;
            case InternalInterface.MG_ACT_MOVE_ENTRY:
                description = 'Move Entry';
                break;
            case InternalInterface.MG_ACT_MOVE_SUBTREE:
                description = 'Move Subtree';
                break;
            case InternalInterface.MG_ACT_NULL_SETTINGS:
                description = 'NULL Settings';
                break;
            case InternalInterface.MG_ACT_EDT_NXTCHAR:
                description = 'Next Char';
                break;
            case InternalInterface.MG_ACT_EDT_NXTLINE:
                description = 'Next Line';
                break;
            case InternalInterface.MG_ACT_EDT_NXTPAGE:
                description = 'Next Page';
                break;
            case InternalInterface.MG_ACT_TBL_NXTLINE:
                description = 'Next Row';
                break;
            case InternalInterface.MG_ACT_TBL_NXTPAGE:
                description = 'Next Screen';
                break;
            case InternalInterface.MG_ACT_EDT_NXTTAB:
                description = 'Next Tab';
                break;
            case InternalInterface.MG_ACT_EDT_NXTWORD:
                description = 'Next Word';
                break;
            case InternalInterface.MG_ACT_NORMAL:
                description = 'Normal';
                break;
            case InternalInterface.MG_ACT_OK:
                description = 'OK';
                break;
            case InternalInterface.MG_ACT_OLE2:
                description = 'OLE2';
                break;
            case InternalInterface.MG_ACT_OPEN_APPLICATION:
                description = 'Open Application';
                break;
            case InternalInterface.MG_ACT_OVERWRITE_ENTRY:
                description = 'Overwrite Entry';
                break;
            case InternalInterface.MG_ACT_OVERWRITE_SUBTREE:
                description = 'Overwrite Subtree';
                break;
            case InternalInterface.MG_ACT_PPD:
                description = 'PPD';
                break;
            case InternalInterface.MG_ACT_PAGE_FOOTER:
                description = 'Page Footer';
                break;
            case InternalInterface.MG_ACT_PAGE_HEADER:
                description = 'Page Header';
                break;
            case InternalInterface.MG_ACT_CLIP_PASTE:
                description = 'Paste';
                break;
            case InternalInterface.MG_ACT_PASTE_LINK:
                description = 'Paste Link';
                break;
            case InternalInterface.MG_ACT_PASTE_SUBTREE:
                description = 'Paste Subtree';
                break;
            case InternalInterface.MG_ACT_EDT_PRVCHAR:
                description = 'Previous Char';
                break;
            case InternalInterface.MG_ACT_EDT_PRVLINE:
                description = 'Previous Line';
                break;
            case InternalInterface.MG_ACT_EDT_PRVPAGE:
                description = 'Previous Page';
                break;
            case InternalInterface.MG_ACT_TBL_PRVLINE:
                description = 'Previous Row';
                break;
            case InternalInterface.MG_ACT_TBL_PRVPAGE:
                description = 'Previous Screen';
                break;
            case InternalInterface.MG_ACT_EDT_PRVTAB:
                description = 'Previous Tab';
                break;
            case InternalInterface.MG_ACT_EDT_PRVWORD:
                description = 'Previous Word';
                break;
            case InternalInterface.MG_ACT_PRINT_ATTRIBUTES:
                description = 'Print Attributes';
                break;
            case InternalInterface.MG_ACT_PRINTER_SETUP:
                description = 'Printer Setup';
                break;
            case InternalInterface.MG_ACT_PRINTERS:
                description = 'Printers';
                break;
            case InternalInterface.MG_ACT_PROGRAMS:
                description = 'Programs';
                break;
            case InternalInterface.MG_ACT_PROPERTIES:
                description = 'Properties';
                break;
            case InternalInterface.MG_ACT_RTO_QUERY:
                description = 'Query Records';
                break;
            case InternalInterface.MG_ACT_RTO_RANGE:
                description = 'Range of Records';
                break;
            case InternalInterface.MG_ACT_RT_REFRESH_RECORD:
                description = 'Record Flush';
                break;
            case InternalInterface.MG_ACT_REDIRECT_FILES:
                description = 'Redirect Files';
                break;
            case InternalInterface.MG_ACT_REDRAW_LAYOUT:
                description = '';
                break;
            case InternalInterface.MG_ACT_REPEAT_ENTRY:
                description = 'Repeat Entry';
                break;
            case InternalInterface.MG_ACT_REPEAT_SUBTREE:
                description = 'Repeat Subtree';
                break;
            case InternalInterface.MG_ACT_REPORT_GENERATOR:
                description = '';
                break;
            case InternalInterface.MG_ACT_RESTORE_DEFAULTS:
                description = 'Restore Defaults';
                break;
            case InternalInterface.MG_ACT_RETURN_TO_TREE:
                description = '';
                break;
            case InternalInterface.MG_ACT_RIGHT:
                description = 'Right';
                break;
            case InternalInterface.MG_ACT_RIGHTS:
                description = '';
                break;
            case InternalInterface.MG_ACT_RIGHTS_LIST:
                description = 'Rights List';
                break;
            case InternalInterface.MG_ACT_SQL_ASSIST:
                description = 'SQL Assist';
                break;
            case InternalInterface.MG_ACT_SQL_COLUMNS:
                description = 'SQL Columns';
                break;
            case InternalInterface.MG_ACT_SQL_COMMAND:
                description = 'SQL Command';
                break;
            case InternalInterface.MG_ACT_SQL_FLIP_DESC:
                description = 'SQL Flip Desc.';
                break;
            case InternalInterface.MG_ACT_SQL_KEYWORDS:
                description = 'SQL Keywords';
                break;
            case InternalInterface.MG_ACT_SQL_OPERATORS:
                description = 'SQL Operators';
                break;
            case InternalInterface.MG_ACT_SQL_TABLES:
                description = 'SQL Tables';
                break;
            case InternalInterface.MG_ACT_SQL_WHERE_CLAUSE:
                description = '';
                break;
            case InternalInterface.MG_ACT_RT_REFRESH_SCREEN:
                description = 'Screen Refresh';
                break;
            case InternalInterface.MG_ACT_SECRET_NAMES:
                description = 'Secret Names';
                break;
            case InternalInterface.MG_ACT_SELECT:
                description = 'Select';
                break;
            case InternalInterface.MG_ACT_EDT_MARKALL:
                description = 'Select All';
                break;
            case InternalInterface.MG_ACT_SERVERS:
                description = '';
                break;
            case InternalInterface.MG_ACT_SERVICES:
                description = '';
                break;
            case InternalInterface.MG_ACT_RT_EDT_NULL:
                description = 'Set to NULL';
                break;
            case InternalInterface.MG_ACT_SHELL_TO_OS:
                description = 'Shell to OS';
                break;
            case InternalInterface.MG_ACT_SHOW_EXPRESSION:
                description = 'Show Expression';
                break;
            case InternalInterface.MG_ACT_SHOW_FULL_LAYOUT:
                description = '';
                break;
            case InternalInterface.MG_ACT_SHRINK_TREE:
                description = '';
                break;
            case InternalInterface.MG_ACT_SORT:
                description = 'Sort';
                break;
            case InternalInterface.MG_ACT_SORT_RECORDS:
                description = 'Sort Records';
                break;
            case InternalInterface.MG_ACT_TABLE_LOCATE:
                description = 'Table Locate';
                break;
            case InternalInterface.MG_ACT_TABLE_LOCATE_NEXT:
                description = 'Table Locate Next';
                break;
            case InternalInterface.MG_ACT_TABLES:
                description = '';
                break;
            case InternalInterface.MG_ACT_TASK_CONTROL:
                description = '';
                break;
            case InternalInterface.MG_ACT_TASK_EVENTS:
                description = '';
                break;
            case InternalInterface.MG_ACT_TO_VALUE:
                description = 'To Value';
                break;
            case InternalInterface.MG_ACT_TOOLKIT_RUNTIME:
                description = 'Toolkit/Runtime';
                break;
            case InternalInterface.MG_ACT_TOP:
                description = 'Top';
                break;
            case InternalInterface.MG_ACT_TYPES:
                description = '';
                break;
            case InternalInterface.MG_ACT_EDT_UNDO:
                description = 'Undo Editing';
                break;
            case InternalInterface.MG_ACT_UNINDENT:
                description = 'Unindent';
                break;
            case InternalInterface.MG_ACT_UPDATE_LINK:
                description = '';
                break;
            case InternalInterface.MG_ACT_USER_ACTION_1:
            case InternalInterface.MG_ACT_USER_ACTION_2:
            case InternalInterface.MG_ACT_USER_ACTION_3:
            case InternalInterface.MG_ACT_USER_ACTION_4:
            case InternalInterface.MG_ACT_USER_ACTION_5:
            case InternalInterface.MG_ACT_USER_ACTION_6:
            case InternalInterface.MG_ACT_USER_ACTION_7:
            case InternalInterface.MG_ACT_USER_ACTION_8:
            case InternalInterface.MG_ACT_USER_ACTION_9:
            case InternalInterface.MG_ACT_USER_ACTION_10:
            case InternalInterface.MG_ACT_USER_ACTION_11:
            case InternalInterface.MG_ACT_USER_ACTION_12:
            case InternalInterface.MG_ACT_USER_ACTION_13:
            case InternalInterface.MG_ACT_USER_ACTION_14:
            case InternalInterface.MG_ACT_USER_ACTION_15:
            case InternalInterface.MG_ACT_USER_ACTION_16:
            case InternalInterface.MG_ACT_USER_ACTION_17:
            case InternalInterface.MG_ACT_USER_ACTION_18:
            case InternalInterface.MG_ACT_USER_ACTION_19:
            case InternalInterface.MG_ACT_USER_ACTION_20:
                description = 'User Action ' + (internalEventCode - InternalInterface.MG_ACT_USER_ACTION_1 + 1);
                break;
            case InternalInterface.MG_ACT_USER_GROUPS:
                description = '';
                break;
            case InternalInterface.MG_ACT_USER_IDS:
                description = 'User IDs';
                break;
            case InternalInterface.MG_ACT_V_CENTER_OF_FORM:
                description = 'Center of Form';
                break;
            case InternalInterface.MG_ACT_VERTICAL_CENTER:
                description = 'Vertical Center';
                break;
            case InternalInterface.MG_ACT_VIEW_BY_KEY:
                description = 'View by Key';
                break;
            case InternalInterface.MG_ACT_RT_REFRESH_VIEW:
                description = 'View Refresh';
                break;
            case InternalInterface.MG_ACT_VIRTUAL_VARIABLES:
                description = 'Variables';
                break;
            case InternalInterface.MG_ACT_VISUAL_CONNECTION:
                description = 'Visual Connection';
                break;
            case InternalInterface.MG_ACT_HIT:
                description = 'Window Hit';
                break;
            case InternalInterface.MG_ACT_WINMOVE:
                description = 'Window Reposition';
                break;
            case InternalInterface.MG_ACT_WINSIZE:
                description = 'Window Resize';
                break;
            case InternalInterface.MG_ACT_ZOOM:
                description = 'Zoom';
                break;
            case InternalInterface.MG_ACT_LOCKING_DETAILS:
                description = 'Locking Details';
                break;
            case InternalInterface.MG_ACT_LOCKING_ABORT:
                description = 'Locking Abort';
                break;
            case InternalInterface.MG_ACT_LOCKING_RETRY:
                description = 'Locking Retry';
                break;
            case InternalInterface.MG_ACT_CHECK_OBJECT_LIST:
                description = 'Check Object List';
                break;
            case InternalInterface.MG_ACT_USERS_LIST:
                description = 'Users List';
                break;
            case InternalInterface.MG_ACT_MODELS:
                description = 'Models';
                break;
            case InternalInterface.MG_ACT_WEB_CLICK:
                description = 'Click';
                break;
            case InternalInterface.MG_ACT_WEB_ON_DBLICK:
                description = 'DblClick';
                break;
            case InternalInterface.MG_ACT_BROWSER_ESC:
                description = 'Esc';
                break;
            case InternalInterface.MG_ACT_ROLLBACK:
                description = 'Rollback';
                break;
            case InternalInterface.MG_ACT_EMPTY_DATAVIEW:
                description = 'Empty Dataview';
                break;
            case InternalInterface.MG_ACT_CTRL_MODIFY:
                description = 'Control Modify';
                break;
            case InternalInterface.MG_ACT_PRINT_DATA:
                description = 'Print Data';
                break;
            case InternalInterface.MG_ACT_POST_REFRESH_BY_PARENT:
                description = 'Post Refresh by Parent';
                break;
            case InternalInterface.MG_ACT_SWITCH_TO_OFFLINE:
                description = 'Switch To Offline';
                break;
            case InternalInterface.MG_ACT_UNAVAILABLE_SERVER:
                description = 'Unavailable Server';
                break;
            case InternalInterface.MG_ACT_CONTEXT_MENU:
                description = 'Context Menu';
                break;
            case InternalInterface.MG_ACT_ENTER_ROW_EDITING:
                description = 'Enter Row Editing';
                break;
            case InternalInterface.MG_ACT_NO_PROG_EXE_RIGHTS:
                description = 'No Program Execution Rights';
                break;
            case InternalInterface.MG_ACT_WEBCLIENT_ROUTE:
                description = 'Route';
                break;
            case InternalInterface.MG_ACT_COL_SORT:
                description = 'Column Sort';
                break;
            case InternalInterface.MG_ACT_ROW_DATA_CURR_PAGE:
                description = 'Get Rows';
                break;
            case InternalInterface.MG_ACT_SUBFORM_CLOSE:
                description = 'Subform Close';
                break;
            case InternalInterface.MG_ACT_SUBFORM_REFRESH:
                description = 'Subform Refresh';
                break;
            case InternalInterface.MG_ACT_SUBFORM_OPEN:
                description = 'Subform Open';
                break;
            case InternalInterface.MG_ACT_COMPUTE:
                description = 'Compute';
                break;
            case InternalInterface.MG_ACT_CACHE_NEXT:
                description = 'Get Next Data';
                break;
            case InternalInterface.MG_ACT_CACHE_PREV:
                description = 'Get Previous Data';
                break;
            case InternalInterface.MG_ACT_FETCH_DATA_CONTROL_VALUES:
                description = 'Fetch data control values';
                break;
            case InternalInterface.MG_ACT_INDEX_CHANGE:
                description = 'Index Change';
                break;
            case InternalInterface.MG_ACT_DUMP_ENVIRONMENT:
                description = 'Dump Environment';
                break;
            default:
                description = '';
                break;
        }
        return description;
    }
    getUserEventType() {
        if (this.UserEvt === null)
            return ConstInterface.EVENT_TYPE_NOTINITED;
        return this.UserEvt.getType();
    }
    getSecondsOfUserEvent() {
        return this.UserEvt.getSeconds();
    }
    getUserEvent() {
        return this.UserEvt;
    }
    getKeyboardItemString() {
        let kbi = this.getKbdItm();
        if (kbi === null)
            return '';
        return kbi.ToString();
    }
    seconds2String() {
        let time = new Array(3);
        let buffer = '';
        time[0] = Math.floor(this._seconds / 3600);
        time[1] = Math.floor((this._seconds - time[0] * 3600) / 60);
        time[2] = this._seconds % 60;
        for (let i = 0; i < time.length; i++) {
            if (time[i] === 0)
                buffer += '00';
            else if (time[i] < 10)
                buffer += ('0' + time[i]);
            else
                buffer += time[i];
            if (i < time.length - 1)
                buffer += ':';
        }
        return buffer;
    }
    parseParamVal(valueStr) {
        let startOfs = 0, endOfs = 0, nLen, j;
        let sLen, sValue = null;
        for (j = 0; j < this._parameters; j++) {
            switch (this._paramAttrs[j]) {
                case StorageAttribute.SKIP:
                    sValue = '';
                    break;
                case StorageAttribute.ALPHA:
                case StorageAttribute.BLOB_VECTOR:
                case StorageAttribute.BLOB:
                case StorageAttribute.MEMO:
                case StorageAttribute.UNICODE:
                    endOfs = startOfs + 4;
                    sLen = valueStr.substr(startOfs, (endOfs) - (startOfs));
                    nLen = NNumber.Parse(sLen, NumberStyles.HexNumber);
                    startOfs = endOfs;
                    if (AccessHelper.environment.GetDebugLevel() > 1 || this._paramAttrs[j] === StorageAttribute.ALPHA || this._paramAttrs[j] === StorageAttribute.UNICODE || this._paramAttrs[j] === StorageAttribute.MEMO) {
                        if ((nLen & 0x8000) > 0) {
                            nLen = (nLen & 0x7FFF);
                            nLen *= 2;
                            let res = new StringBuilder();
                            endOfs += RecordUtils.getSpannedField(valueStr, nLen, startOfs, this._paramAttrs[j], res, true);
                            valueStr = res.ToString();
                        }
                        else {
                            endOfs = startOfs + nLen;
                            sValue = valueStr.substr(startOfs, (endOfs) - (startOfs));
                        }
                    }
                    else {
                        if ((nLen & 0x8000) > 0) {
                            nLen = (nLen & 0x7FFF);
                            nLen = Math.floor((nLen + 2) / 3) * 4;
                            let res = new StringBuilder();
                            endOfs += RecordUtils.getSpannedField(valueStr, nLen, startOfs, this._paramAttrs[j], res, false);
                            sValue = res.ToString();
                        }
                        else {
                            endOfs = startOfs + Math.floor((nLen + 2) / 3) * 4;
                            sValue = Base64.decode(valueStr.substr(startOfs, (endOfs) - (startOfs)));
                        }
                    }
                    break;
                case StorageAttribute.NUMERIC:
                case StorageAttribute.DATE:
                case StorageAttribute.TIME:
                    if (AccessHelper.environment.GetDebugLevel() > 1) {
                        endOfs = startOfs + AccessHelper.environment.GetSignificantNumSize() * 2;
                        sValue = valueStr.substr(startOfs, (endOfs) - (startOfs));
                    }
                    else {
                        endOfs = startOfs + (Math.floor((AccessHelper.environment.GetSignificantNumSize() + 2) / 3) * 4);
                        sValue = Base64.decodeToHex(valueStr.substr(startOfs, (endOfs) - (startOfs)));
                    }
                    break;
                case StorageAttribute.BOOLEAN:
                    endOfs = startOfs + 1;
                    sValue = valueStr.substr(startOfs, (endOfs) - (startOfs));
                    break;
            }
            this._paramVals[j] = sValue;
            startOfs = endOfs;
        }
        return endOfs;
    }
    getParamNum() {
        return this._parameters;
    }
    isControlHeader() {
        return this.getType() == ConstInterface.EVENT_TYPE_INTERNAL &&
            (this.getInternalCode() == InternalInterface.MG_ACT_CTRL_PREFIX ||
                this.getInternalCode() == InternalInterface.MG_ACT_CTRL_SUFFIX ||
                this.getInternalCode() == InternalInterface.MG_ACT_CTRL_VERIFICATION);
    }
    isVariableHeader() {
        return this.getType() == ConstInterface.EVENT_TYPE_INTERNAL &&
            this.getInternalCode() == InternalInterface.MG_ACT_VARIABLE;
    }
    AppendDescription(buffer) {
        switch (this._type) {
            case ConstInterface.EVENT_TYPE_INTERNAL:
                buffer.Append(Event.getInternalEvtDescription(this.InternalEvent));
                break;
            case ConstInterface.EVENT_TYPE_SYSTEM:
                buffer.Append(this.getKeyboardItemString());
                break;
            case ConstInterface.EVENT_TYPE_USER:
                buffer.Append(this.getUsrEvntDesc());
                break;
            case ConstInterface.EVENT_TYPE_USER_FUNC:
                buffer.Append(this._userDefinedFuncName);
                break;
            case ConstInterface.EVENT_TYPE_TIMER:
                buffer.Append(this.seconds2String());
                break;
            case ConstInterface.EVENT_TYPE_EXPRESSION:
                buffer.Append('ID ' + this.Exp.getId().toString());
                break;
            default:
                buffer.Append('unknown event type ');
                break;
        }
    }
    isNewInternalEvent() {
        return this.InternalEvent >= 1001 && this.InternalEvent <= 1008;
    }
    getNewInternalEventDescription() {
        let eventDesc = NString.Empty;
        switch (this.InternalEvent) {
            case InternalInterface.MG_ACT_TASK_PREFIX:
                eventDesc = ConstInterface.BRK_LEVEL_TASK_PREFIX_FM;
                break;
            case InternalInterface.MG_ACT_TASK_SUFFIX:
                eventDesc = ConstInterface.BRK_LEVEL_TASK_SUFFIX_FM;
                break;
            case InternalInterface.MG_ACT_REC_PREFIX:
                eventDesc = ConstInterface.BRK_LEVEL_REC_PREFIX_FM;
                break;
            case InternalInterface.MG_ACT_REC_SUFFIX:
                eventDesc = ConstInterface.BRK_LEVEL_REC_SUFFIX_FM;
                break;
            case InternalInterface.MG_ACT_CTRL_PREFIX:
                eventDesc = ConstInterface.BRK_LEVEL_CTRL_PREFIX_FM;
                break;
            case InternalInterface.MG_ACT_CTRL_SUFFIX:
                eventDesc = ConstInterface.BRK_LEVEL_CTRL_SUFFIX_FM;
                break;
            case InternalInterface.MG_ACT_CTRL_VERIFICATION:
                eventDesc = ConstInterface.BRK_LEVEL_CTRL_VERIFICATION_FM;
                break;
            case InternalInterface.MG_ACT_VARIABLE:
                eventDesc = ConstInterface.BRK_LEVEL_VARIABLE_FM;
                break;
        }
        return eventDesc;
    }
    getEventType() {
        return this.isNewInternalEvent()
            ? NString.TrimEnd(this.getNewInternalEventDescription())
            : this.getEventTypeString();
    }
    getEventTypeString() {
        let eventType;
        switch (this.getType()) {
            case ConstInterface.EVENT_TYPE_INTERNAL:
                eventType = 'Internal Event:';
                break;
            case ConstInterface.EVENT_TYPE_SYSTEM:
                eventType = 'System Event:';
                break;
            case ConstInterface.EVENT_TYPE_EXPRESSION:
                eventType = 'Expression Event:';
                break;
            case ConstInterface.EVENT_TYPE_TIMER:
                eventType = 'Timer Event:';
                break;
            case ConstInterface.EVENT_TYPE_USER:
                eventType = 'User Event:';
                break;
            default:
                eventType = '';
                break;
        }
        return eventType;
    }
    setUserDefinedFuncName(name) {
        this._userDefinedFuncName = name;
        let functionNameUpper = this._userDefinedFuncName.toUpperCase();
        this._userDefinedFuncNameHashCode = HashUtils.GetHashCode(functionNameUpper);
    }
    getUserDefinedFuncName() {
        return this._userDefinedFuncName;
    }
    getUserDefinedFuncNameHashCode() {
        return this._userDefinedFuncNameHashCode;
    }
    getUserDefinedFuncRetExp() {
        return this._returnExp;
    }
    setTimestamp() {
        this._timestamp = Event._lastTimestamp++;
    }
    getTimestamp() {
        return this._timestamp;
    }
    toString() {
        return NString.Format('{{Event: {0}}}', this.getBrkLevel());
    }
}
Event._lastTimestamp = 0;

class RunTimeEventBase extends Event {
}

class MgPriorityBlockingQueue {
    constructor() {
        this._queue = null;
        this._timeFirstEvent = 0;
        this._queue = new MgPriorityQueue();
    }
    isBackgroundEvent(o) {
        let result = false;
        if (o instanceof RunTimeEventBase) {
            let runTimeEvent = o;
            if (runTimeEvent.getPriority() === Priority.LOWEST)
                result = true;
        }
        return result;
    }
    offer(o) {
        try {
            let condition = this._queue.offer(o);
            if (this._timeFirstEvent === 0) {
                if (!this.isBackgroundEvent(o)) {
                    this._timeFirstEvent = Misc.getSystemMilliseconds();
                }
            }
            Debug.Assert(condition);
            SyncExecutionHelper.Instance.Pulse();
            return true;
        }
        finally { }
    }
    put(o) {
        this.offer(o);
    }
    async waitForElement() {
        if (this._queue.Size === 0) {
            this._timeFirstEvent = 0;
            await SyncExecutionHelper.Instance.Wait();
        }
    }
    GetTime() {
        return this._timeFirstEvent;
    }
    poll() {
        let result;
        try {
            let obj = this._queue.poll();
            if (this.isBackgroundEvent(obj)) {
                this._timeFirstEvent = 0;
            }
            result = obj;
        }
        finally { }
        return result;
    }
    peek() {
        return this._queue.peek();
    }
    size() {
        return this._queue.Size;
    }
    remainingCapacity() {
        return Int32.MaxValue;
    }
    clear() {
        this._queue.clear();
    }
    isEmpty() {
        return this._queue.isEmpty();
    }
}

class RunTimeEvent extends RunTimeEventBase {
    set Control(value) {
        this._ctrl = value;
    }
    set DisplayLine(value) {
        this._displayLine = value;
    }
    get Control() {
        return this._ctrl;
    }
    get ControlsList() {
        return this._controlsList;
    }
    get Direction() {
        return this._direction;
    }
    constructor(taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt, ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask, ignoreSpecifiedControlOrGuiTriggeredEventOrLineOrXOrControlOrActivatedFromMDIFrame, yOrCtlIdx, width, height) {
        super();
        this._controlsList = null;
        this._direction = 0;
        this._displayLine = Int32.MinValue;
        this._eventSubType = EventSubType.Normal;
        this._actEnableList = null;
        this._argList = null;
        this._ctrl = null;
        this._dotNetObject = null;
        this._eventFld = null;
        this._fromServer = false;
        this._guiTriggeredEvent = false;
        this._immediate = false;
        this._isIdleTimer = false;
        this._isRealRefresh = true;
        this._mgdId = 0;
        this._routeParams = null;
        this._mprgCreator = null;
        this._priority = Priority.HIGH;
        this._produceClick = false;
        this._reversibleExit = true;
        this._selectionEnd = 0;
        this._selectionStart = 0;
        this._sendAll = false;
        this._task = null;
        this._taskTag = null;
        this._val = null;
        this.IgnoreSpecifiedControl = false;
        this.LastFocusedVal = null;
        if (arguments.length === 1 && (taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt === null || taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt instanceof TaskBase))
            this.constructor_5(taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt);
        else if (arguments.length === 2 && (taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt === null || taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt instanceof TaskBase) && (ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask === null || ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask instanceof MgControlBase))
            this.constructor_6(taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt, ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask);
        else if (arguments.length === 1 && (taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt === null || taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt instanceof MgControlBase))
            this.constructor_7(taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt);
        else if (arguments.length === 2 && (taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt === null || taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt instanceof MgControlBase) && (ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask === null || ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask.constructor === Boolean))
            this.constructor_8(taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt, ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask);
        else if (arguments.length === 3 && (taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt === null || taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt instanceof MgControlBase) && (ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask === null || ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask.constructor === Boolean) && (ignoreSpecifiedControlOrGuiTriggeredEventOrLineOrXOrControlOrActivatedFromMDIFrame === null || ignoreSpecifiedControlOrGuiTriggeredEventOrLineOrXOrControlOrActivatedFromMDIFrame.constructor === Boolean))
            this.constructor_9(taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt, ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask, ignoreSpecifiedControlOrGuiTriggeredEventOrLineOrXOrControlOrActivatedFromMDIFrame);
        else if (arguments.length === 2 && (taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt === null || taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt instanceof TaskBase) && (ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask === null || ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask.constructor === Boolean))
            this.constructor_10(taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt, ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask);
        else if (arguments.length === 1 && (taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt === null || taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt instanceof GuiFieldBase))
            this.constructor_11(taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt);
        else if (arguments.length === 2 && (taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt === null || taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt instanceof MgControlBase) && (ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask === null || ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask.constructor === Number))
            this.constructor_12(taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt, ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask);
        else if (arguments.length === 3 && (taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt === null || taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt instanceof MgControlBase) && (ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask === null || ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask.constructor === Number) && (ignoreSpecifiedControlOrGuiTriggeredEventOrLineOrXOrControlOrActivatedFromMDIFrame === null || ignoreSpecifiedControlOrGuiTriggeredEventOrLineOrXOrControlOrActivatedFromMDIFrame.constructor === Boolean))
            this.constructor_13(taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt, ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask, ignoreSpecifiedControlOrGuiTriggeredEventOrLineOrXOrControlOrActivatedFromMDIFrame);
        else if (arguments.length === 3 && (taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt === null || taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt instanceof MgControlBase) && (ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask === null || ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask instanceof List) && (ignoreSpecifiedControlOrGuiTriggeredEventOrLineOrXOrControlOrActivatedFromMDIFrame === null || ignoreSpecifiedControlOrGuiTriggeredEventOrLineOrXOrControlOrActivatedFromMDIFrame.constructor === Boolean))
            this.constructor_14(taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt, ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask, ignoreSpecifiedControlOrGuiTriggeredEventOrLineOrXOrControlOrActivatedFromMDIFrame);
        else if (arguments.length === 3 && (taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt === null || taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt instanceof MgControlBase) && (ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask === null || ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask.constructor === Number) && (ignoreSpecifiedControlOrGuiTriggeredEventOrLineOrXOrControlOrActivatedFromMDIFrame === null || ignoreSpecifiedControlOrGuiTriggeredEventOrLineOrXOrControlOrActivatedFromMDIFrame.constructor === Number))
            this.constructor_15(taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt, ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask);
        else if (arguments.length === 6)
            this.constructor_16(taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt);
        else if (arguments.length === 2 && (taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt === null || taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt instanceof Event) && (ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask === null || ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask instanceof RunTimeEvent)) {
            super.constructor_1(taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt);
            this.constructor_17(ctrlRefOrGuiTriggeredEventOrLineOrControlsListOrDirectionOrColumnHeaderOrRtEvtOrCurrentTask);
        }
        else if (arguments.length === 1 && taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt instanceof RunTimeEvent)
            Object.assign(this, taskRefOrCtrlRefOrTaskrefOrFldRefOrEvt);
    }
    constructor_5(taskRef) {
        this.init(taskRef);
    }
    constructor_6(taskRef, ctrlRef) {
        this.constructor_5((ctrlRef !== null) ? ctrlRef.getForm().getTask() : taskRef);
        this.Control = ctrlRef;
    }
    constructor_7(ctrlRef) {
        this.constructor_6(null, ctrlRef);
        if (ctrlRef !== null && super.getType() === Char.MinValue) {
            let prop = ctrlRef.GetComputedProperty(PropInterface.PROP_TYPE_TRIGGER);
            if (prop !== null) {
                let xmlParser = new XmlParser(prop.GetComputedValue());
                super.fillData(xmlParser, ctrlRef.getForm().getTask());
            }
        }
    }
    constructor_8(ctrlRef, guiTriggeredEvent) {
        this.constructor_7(ctrlRef);
        this._guiTriggeredEvent = guiTriggeredEvent;
        if (guiTriggeredEvent) {
            this._priority = Priority.LOW;
        }
    }
    constructor_9(ctrlRef, guiTriggeredEvent, ignoreSpecifiedControl) {
        this.constructor_8(ctrlRef, guiTriggeredEvent);
        this.IgnoreSpecifiedControl = ignoreSpecifiedControl;
    }
    constructor_10(taskref, guiTriggeredEvent) {
        this.constructor_5(taskref);
        this._guiTriggeredEvent = guiTriggeredEvent;
        if (guiTriggeredEvent) {
            this._priority = Priority.LOW;
        }
    }
    constructor_11(fldRef) {
        this._eventFld = fldRef;
        this.init((fldRef !== null) ? fldRef.getTask() : null);
    }
    constructor_12(ctrlRef, line) {
        this.constructor_7(ctrlRef);
        this._displayLine = line;
    }
    constructor_13(ctrlRef, line, guiTriggeredEvent) {
        this.constructor_8(ctrlRef, guiTriggeredEvent);
        this._displayLine = line;
    }
    constructor_14(ctrlRef, controlsList, guiTriggeredEvent) {
        this.constructor_8(ctrlRef, guiTriggeredEvent);
        this._controlsList = controlsList;
    }
    constructor_15(ctrlRef, direction) {
        this.constructor_8(ctrlRef, true);
        this._direction = direction;
    }
    constructor_16(ctrlRef) {
        this.constructor_8(ctrlRef, true);
    }
    constructor_17(rtEvt) {
        this._taskTag = rtEvt._taskTag;
        this._task = rtEvt._task;
        this.Control = rtEvt.Control;
        this._eventFld = rtEvt._eventFld;
        this._mgdId = rtEvt._mgdId;
        this._displayLine = rtEvt._displayLine;
        this._reversibleExit = rtEvt._reversibleExit;
        this._argList = rtEvt._argList;
        this._immediate = rtEvt._immediate;
        this._mprgCreator = rtEvt._mprgCreator;
        this._priority = rtEvt._priority;
        this._guiTriggeredEvent = rtEvt._guiTriggeredEvent;
        this._isIdleTimer = rtEvt._isIdleTimer;
        this._val = rtEvt._val;
        this._selectionStart = rtEvt._selectionStart;
        this._selectionEnd = rtEvt._selectionEnd;
        this._controlsList = rtEvt._controlsList;
        this._direction = rtEvt._direction;
        this._dotNetObject = rtEvt._dotNetObject;
        this.LastFocusedVal = rtEvt.LastFocusedVal;
        this._routeParams = rtEvt._routeParams;
    }
    CompareTo(obj) {
        let otherTimeEvent = obj;
        let otherPriority = otherTimeEvent._priority;
        let result = otherPriority - this._priority;
        if (result === 0)
            result = (this._timestamp - otherTimeEvent._timestamp);
        return result;
    }
    replicate() {
        let runTimeEvent = new RunTimeEvent(this);
        runTimeEvent.setTimestamp();
        return runTimeEvent;
    }
    init(taskRef) {
        this._task = (taskRef || AccessHelper.mgDataTable.getCurrMGData().getFirstTask());
        this._taskTag = ((this._task === null) ? "" : this._task.getTaskTag());
        this._mprgCreator = null;
    }
    convertParamsToArgs() {
        this._argList = new ArgumentsList();
        this._argList.buildListFromParams(this._parameters, this._paramAttrs, this._paramVals, this._paramNulls);
        this._parameters = 0;
        this._paramAttrs = null;
        this._paramVals = null;
        this._paramNulls = null;
    }
    getTask() {
        super.findUserEvent();
        return this._task;
    }
    setTask(taskRef) {
        this._task = taskRef;
        if (this._task !== null)
            this._taskTag = this._task.getTaskTag();
        else
            this._taskTag = null;
    }
    setTimer(sec, mgdID, isIdle) {
        this._type = ConstInterface.EVENT_TYPE_TIMER;
        this._seconds = sec;
        this._mgdId = mgdID;
        this._isIdleTimer = isIdle;
    }
    getDisplayLine() {
        return this._displayLine;
    }
    getMgdID() {
        return this._mgdId;
    }
    getBrkLevel(flowMonitor) {
        if (arguments.length === 0) {
            return this.getBrkLevel_00();
        }
        return this.getBrkLevel_01(flowMonitor);
    }
    getBrkLevel_00() {
        let level = super.getBrkLevel();
        if (this._type === ConstInterface.EVENT_TYPE_INTERNAL) {
            switch (this.InternalEvent) {
                case InternalInterface.MG_ACT_CTRL_PREFIX:
                case InternalInterface.MG_ACT_CTRL_SUFFIX:
                case InternalInterface.MG_ACT_CTRL_VERIFICATION:
                    level += this.Control.Name;
                    break;
                case InternalInterface.MG_ACT_VARIABLE:
                    level += this._eventFld.getVarName();
                    break;
            }
        }
        return level;
    }
    getBrkLevel_01(flowMonitor) {
        return super.getBrkLevel(flowMonitor);
    }
    setCtrl(newCtrl) {
        this._ctrl = newCtrl;
    }
    setNonReversibleExit() {
        this._reversibleExit = false;
    }
    reversibleExit() {
        return this._reversibleExit;
    }
    buildXML(message) {
        message.Append("\n   " + XMLConstants.TAG_OPEN + ConstInterface.MG_TAG_EVENT);
        if (this._type !== Char.MinValue)
            message.Append(" " + ConstInterface.MG_ATTR_EVENTTYPE + "=\"" + this._type + "\"");
        if (this._type === ConstInterface.EVENT_TYPE_SYSTEM && this.kbdItm != null) {
            let modifier = this.kbdItm.getModifier();
            if (modifier !== Modifiers.MODIFIER_NONE)
                message.Append(" " + ConstInterface.MG_ATTR_MODIFIER + "=\"" + modifier + "\"");
            message.Append(" " + ConstInterface.MG_ATTR_KEYCODE + "=\"" + this.kbdItm.getKeyCode() + "\"");
        }
        if (this.InternalEvent !== Int32.MinValue)
            message.Append(" " + ConstInterface.MG_ATTR_INTERNALEVENT + "=\"" + this.InternalEvent + "\"");
        if (this._seconds !== Int32.MinValue)
            message.Append(" " + ConstInterface.MG_ATTR_SECONDS + "=\"" + this._seconds + "\"");
        if (this.Exp != null)
            message.Append(" " + XMLConstants.MG_ATTR_EXP + "=\"" + this.Exp.getId() + "\"");
        if (this._forceExit !== ForceExit.None)
            message.Append(" " + XMLConstants.MG_ATTR_EXP + "=\"" + this._forceExit + "\"");
        if (this.UserEvt != null)
            message.Append(" " + ConstInterface.MG_ATTR_USER + "=\"" + this.UserEvtTaskTag + "," + this._userEvtIdx + "\"");
        message.Append(XMLConstants.TAG_TERM);
    }
    getArgList() {
        return this._argList;
    }
    setArgList(aArgList) {
        let result = this._argList === null;
        this._argList = aArgList;
        return result;
    }
    setRouteParamList(routeParams) {
        this._routeParams = routeParams;
    }
    getRouteParamList() {
        return this._routeParams;
    }
    setImmediate(val) {
        this._immediate = val;
    }
    isImmediate() {
        return this._immediate;
    }
    setMainPrgCreator(src) {
        this._mprgCreator = src;
    }
    getMainPrgCreator() {
        return this._mprgCreator;
    }
    setIsRealRefresh(val) {
        this._isRealRefresh = val;
    }
    getRefreshType() {
        return this._isRealRefresh;
    }
    setFromServer() {
        this._fromServer = true;
    }
    resetFromServer() {
        this._fromServer = false;
    }
    isFromServer() {
        return this._fromServer;
    }
    isQuit() {
        return this._eventSubType === EventSubType.CancelIsQuit;
    }
    RollbackInCancel() {
        return this._eventSubType !== EventSubType.CancelWithNoRollback;
    }
    ExitDueToError() {
        return this._eventSubType === EventSubType.ExitDueToError;
    }
    RtViewRefreshUseCurrentRow() {
        return this._eventSubType === EventSubType.RtRefreshViewUseCurrentRow;
    }
    SetEventSubType(eventSubType) {
        this._eventSubType = eventSubType;
    }
    getFld() {
        return this._eventFld;
    }
    isGuiTriggeredEvent() {
        return this._guiTriggeredEvent;
    }
    getPriority() {
        return this._priority;
    }
    setPriority(priority) {
        this._priority = priority;
    }
    isIdleTimer() {
        return this._isIdleTimer;
    }
    getValue() {
        return this._val;
    }
    setValue(val) {
        this._val = val;
    }
    getStartSelection() {
        return this._selectionStart;
    }
    getEndSelection() {
        return this._selectionEnd;
    }
    setEditParms(start, end, text) {
        this._selectionStart = start;
        this._selectionEnd = end;
        this.setValue(text);
    }
    isProduceClick() {
        return this._produceClick;
    }
    setProduceClick(produceClick) {
        this._produceClick = produceClick;
    }
    getActEnableList() {
        return this._actEnableList;
    }
    isSendAll() {
        return this._sendAll;
    }
    setSendAll(sendAll) {
        this._sendAll = sendAll;
    }
    isBlockedByModalWindow(activeWindowData) {
        if (activeWindowData.IsModal) {
            let eventTask = this.getTask();
            let baseTask = activeWindowData.getTask(0);
            if (eventTask !== baseTask && baseTask.isDescendentOf(eventTask))
                return true;
        }
        return false;
    }
    toString() {
        return NString.Format("{{RTEvent {0} ({1}), type {2}{3}}}", [
            this.getBrkLevel(), this.InternalEvent, this._type, (this._task === null) ? "" : (" on " + this._task)
        ]);
    }
}

class FlowMonitorInterface {
}
FlowMonitorInterface.FLWMTR_START = 0;
FlowMonitorInterface.FLWMTR_END = 1;
FlowMonitorInterface.FLWMTR_PROPAGATE = 2;
FlowMonitorInterface.FLWMTR_EVENT = 7;
FlowMonitorInterface.FLWMTR_CHNG_MODE = 8;
FlowMonitorInterface.FLWMTR_PREFIX = 15;
FlowMonitorInterface.FLWMTR_SUFFIX = 16;
FlowMonitorInterface.FLWMTR_CTRL_PREFIX = 18;
FlowMonitorInterface.FLWMTR_CTRL_SUFFIX = 19;
FlowMonitorInterface.FLWMTR_TSK_HANDLER = 20;
FlowMonitorInterface.FLWMTR_RECOMP = 31;
FlowMonitorInterface.FLWMTR_DATA_OPER = 41;
FlowMonitorInterface.FLWMTR_VARCHG_VALUE = 119;

class FlowMonitorQueue {
    constructor() {
        this._queue = new Queue();
        this._enabled = false;
        this._isFlowOperation = false;
        this._isRecompute = false;
        this._isTask = false;
        this._isTaskFlow = false;
        this._isDataView = false;
        this.ShouldSerialize = false;
        this.padRight = (string, length, character = ' ') => {
            let result = "";
            let totalLength = length - string.length;
            for (let i = 0; i < totalLength; i++) {
                result = character + result;
            }
            result = result + string;
            return result;
        };
    }
    static get Instance() {
        if (FlowMonitorQueue._instance === null)
            FlowMonitorQueue._instance = new FlowMonitorQueue();
        return FlowMonitorQueue._instance;
    }
    addTaskCngMode(newTaskMode, taskInfo) {
        let info = "Task Mode Change - ";
        if (this._enabled && this._isTask) {
            let activityItem = new ActivityItem(this, FlowMonitorQueue.ACT_TASK, FlowMonitorInterface.FLWMTR_CHNG_MODE);
            switch (newTaskMode) {
                case Constants.TASK_MODE_MODIFY:
                    info += "Modify";
                    break;
                case Constants.TASK_MODE_CREATE:
                    info += "Create";
                    break;
                case Constants.TASK_MODE_DELETE:
                    info += "Delete";
                    break;
                case Constants.TASK_MODE_QUERY:
                    info += "Query";
                    break;
                default:
                    info = null;
                    break;
            }
            activityItem.setInfo(info);
            this._queue.put(activityItem);
            Logger.Instance.WriteSupportToLog(taskInfo + ": " + info, true);
        }
    }
    fillData(parser) {
        let endContext = parser.getXMLdata().indexOf("/>", parser.getCurrIndex());
        if (endContext !== -1 && endContext < parser.getXMLdata().length) {
            let tag = parser.getXMLsubstring(endContext);
            parser.add2CurrIndex(tag.indexOf("flwmtr_config") + "flwmtr_config".length);
            let tokens = XmlParser.getTokens(parser.getXMLsubstring(endContext), XMLConstants.XML_ATTR_DELIM);
            Logger.Instance.WriteDevToLog("in FlowMonitorQueue.FillData: " + tokens.toString());
            this.initElements(tokens);
            parser.setCurrIndex(endContext + XMLConstants.TAG_TERM.length);
            return;
        }
        Logger.Instance.WriteExceptionToLogWithMsg("in  FlowMonitorQueue.FillData() out of string bounds");
    }
    initElements(tokensVector) {
        for (let j = 0; j < tokensVector.length; j = j + 2) {
            let attribute = tokensVector.get_Item(j);
            let valueStr = tokensVector.get_Item(j + 1);
            Logger.Instance.WriteDevToLog(attribute + " value: " + valueStr);
            switch (attribute) {
                case ConstInterface.MG_ATTR_TASK:
                    this._isTask = XmlParser.getBoolean(valueStr);
                    break;
                case ConstInterface.MG_ATTR_TASKFLW:
                    this._isTaskFlow = XmlParser.getBoolean(valueStr);
                    break;
                case ConstInterface.MG_TAG_DATAVIEW:
                    this._isDataView = XmlParser.getBoolean(valueStr);
                    break;
                case ConstInterface.MG_ATTR_RECOMP:
                    this._isRecompute = XmlParser.getBoolean(valueStr);
                    break;
                case ConstInterface.MG_ATTR_FLWOP:
                    this._isFlowOperation = XmlParser.getBoolean(valueStr);
                    break;
                case ConstInterface.MG_ATTR_ENABLED:
                    this.enable(XmlParser.getBoolean(valueStr));
                    break;
                default:
                    Logger.Instance.WriteExceptionToLogWithMsg("in FlowMonitorQueue.initElements(): unknown  attribute: " + attribute);
                    break;
            }
        }
    }
    buildXML(message) {
        if (!this._queue.isEmpty() && this.ShouldSerialize) {
            message.Append(XMLConstants.START_TAG + ConstInterface.MG_TAG_FLWMTR_MSG + XMLConstants.TAG_CLOSE);
            while (!this._queue.isEmpty()) {
                let currAct = this._queue.get();
                currAct.buildXML(message);
            }
            message.Append("</" + ConstInterface.MG_TAG_FLWMTR_MSG + XMLConstants.TAG_CLOSE);
        }
    }
    isEmpty() {
        return this._queue.isEmpty();
    }
    enable(value) {
        let wasEnabled = this._enabled;
        this._enabled = value;
        this.ShouldSerialize = this._enabled;
        return wasEnabled;
    }
    addTaskEvent(triggeredBy, state, taskInfo) {
        if (this._enabled && this._isTask) {
            let act = new ActivityItem(this, FlowMonitorQueue.ACT_TASK, FlowMonitorInterface.FLWMTR_EVENT);
            let info;
            switch (state) {
                case FlowMonitorInterface.FLWMTR_START:
                    info = FlowMonitorQueue.S_EVENT_STR1 + triggeredBy + FlowMonitorQueue.S_EVENT_STR2;
                    break;
                case FlowMonitorInterface.FLWMTR_END:
                    info = FlowMonitorQueue.E_EVENT_STR + triggeredBy;
                    break;
                case FlowMonitorInterface.FLWMTR_PROPAGATE:
                    info = FlowMonitorQueue.S_EVENT_PROPAGATED;
                    break;
                default:
                    info = null;
                    break;
            }
            act.setInfo(info);
            this._queue.put(act);
            Logger.Instance.WriteSupportToLog(taskInfo + ": " + info, true);
        }
    }
    appendVirtualsAndParameters(currentValues) {
        let act = new ActivityItem(this, FlowMonitorQueue.ACT_TASK_FLW, InternalInterface.MG_ACT_REC_PREFIX);
        act.setInfo(currentValues);
        this._queue.put(act);
    }
    addDataViewFlow(task) {
        if (this._isDataView) {
            let fldTab = task.DataView.GetFieldsTab();
            let preparedDisplayString = "";
            let finaldisplayData = "\n";
            let fldValue;
            let data = "";
            for (let i = 0; i < fldTab.getSize(); i++) {
                let fldDef = fldTab.getField(i);
                if (!fldDef.IsEventHandlerField && (fldDef.IsVirtual && !fldDef.VirAsReal) || fldDef.isParam()) {
                    fldValue = fldDef.isNull() ? fldDef.getNullValue() : fldDef.getValue(true);
                    data = this.getFieldData(fldDef.getType(), fldValue, fldDef.getPicture(), fldDef.getCellsType(), task);
                    preparedDisplayString = this.PrepareDisplayString(fldDef.isParam(), fldDef.getVarName(), data, true);
                    finaldisplayData = finaldisplayData + preparedDisplayString + "\n";
                }
            }
            this.appendVirtualsAndParameters(finaldisplayData);
        }
    }
    getFieldData(Storagetype, data, picture, vecCellType, task) {
        switch (Storagetype) {
            case StorageAttribute.DOTNET:
                data = FlowMonitorQueue.UNPRINTABLE_STR_LOG;
                break;
            case StorageAttribute.BLOB:
                {
                    if (BlobType.isValidBlob(data)) {
                        let contentType = BlobType.getContentType(data);
                        if (contentType == BlobType.CONTENT_TYPE_ANSI || contentType == BlobType.CONTENT_TYPE_UNICODE)
                            data = data != null ? BlobType.getString(data) : "";
                        else
                            data = FlowMonitorQueue.UNPRINTABLE_STR_LOG;
                    }
                    else
                        data = "";
                }
                break;
            case StorageAttribute.NUMERIC:
            case StorageAttribute.DATE:
            case StorageAttribute.TIME:
                let conv = DisplayConvertor.Instance;
                data = conv.mg2disp(data, " ", new PIC(picture, Storagetype, task.getCompIdx()), false, task.getCompIdx(), false);
                break;
            case StorageAttribute.BLOB_VECTOR:
                let vecOutData;
                if (data == null) {
                    vecOutData = "[]";
                }
                else {
                    let cellAtt = vecCellType;
                    let vector = new VectorType(data);
                    if (cellAtt == StorageAttribute.BLOB && !VectorType.validateBlobContents(data))
                        vecOutData = "[]";
                    else {
                        let vecSize = VectorType.getVecSize(data);
                        let cellPicture = (cellAtt == StorageAttribute.NUMERIC || cellAtt == StorageAttribute.DATE || cellAtt == StorageAttribute.TIME) ? PIC.buildPicture(cellAtt, vector.getVecCell(1), task.getCompIdx(), true).getFormat() : picture;
                        vecOutData = "[";
                        for (let i = 0; i < vecSize; i++) {
                            vecOutData += this.getFieldData(cellAtt, vector.getVecCell(i + 1), cellPicture, vecCellType, task);
                            vecOutData += i < vecSize - 1 ? "," : "]";
                        }
                    }
                }
                data = vecOutData;
                break;
            case StorageAttribute.BOOLEAN:
                data = data == "1" ? "TRUE" : "FALSE";
                break;
        }
        return data;
    }
    PrepareDisplayString(mode, name, valueContent, addDoubleQuotes) {
        let str = "";
        let finalStringToDisplay = "";
        if (addDoubleQuotes)
            finalStringToDisplay = finalStringToDisplay + "\"";
        finalStringToDisplay = finalStringToDisplay + name;
        if (addDoubleQuotes)
            finalStringToDisplay = finalStringToDisplay + "\"";
        let paddedName = this.padRight(name, 34);
        let formatOfStringVirtual = `Virtual`;
        let formatOfStringParameter = `Parameter`;
        str = (mode ? formatOfStringParameter : formatOfStringVirtual) + " : " + `${paddedName}` + " : " + `${valueContent.trim()}`;
        return str;
    }
    addTaskFlowRec(id, state, taskInfo) {
        if (this._enabled && this._isTaskFlow) {
            let info;
            switch (id) {
                case InternalInterface.MG_ACT_REC_PREFIX:
                    info = state === FlowMonitorInterface.FLWMTR_START
                        ? FlowMonitorQueue.S_RECPRF_STR
                        : FlowMonitorQueue.E_RECPRF_STR;
                    id = FlowMonitorInterface.FLWMTR_PREFIX;
                    break;
                case InternalInterface.MG_ACT_REC_SUFFIX:
                    info = state === FlowMonitorInterface.FLWMTR_START
                        ? FlowMonitorQueue.S_RECSUF_STR
                        : FlowMonitorQueue.E_RECSUF_STR;
                    id = FlowMonitorInterface.FLWMTR_SUFFIX;
                    break;
                case InternalInterface.MG_ACT_TASK_PREFIX:
                    info = state === FlowMonitorInterface.FLWMTR_START
                        ? FlowMonitorQueue.S_TASKPRF_STR
                        : FlowMonitorQueue.E_TASKPRF_STR;
                    id = FlowMonitorInterface.FLWMTR_PREFIX;
                    break;
                case InternalInterface.MG_ACT_TASK_SUFFIX:
                    info = state === FlowMonitorInterface.FLWMTR_START
                        ? FlowMonitorQueue.S_TASKSUF_STR
                        : FlowMonitorQueue.E_TASKSUF_STR;
                    id = FlowMonitorInterface.FLWMTR_SUFFIX;
                    break;
                default:
                    info = null;
                    break;
            }
            let act = new ActivityItem(this, FlowMonitorQueue.ACT_TASK_FLW, id);
            act.setInfo(info);
            this._queue.put(act);
            Logger.Instance.WriteSupportToLog(taskInfo + ": " + info, true);
        }
    }
    addTaskFlowFld(id, fldName, state, taskInfo) {
        this.addTaskFlowCtrl(id, fldName, state, taskInfo);
    }
    addTaskFlowCtrl(id, ctrlName, state, taskInfo) {
        if (this._enabled && this._isTaskFlow) {
            let info;
            switch (id) {
                case InternalInterface.MG_ACT_VARIABLE:
                    info = state === FlowMonitorInterface.FLWMTR_START
                        ? FlowMonitorQueue.S_VARIABLE_STR
                        : FlowMonitorQueue.E_VARIABLE_STR;
                    id = FlowMonitorInterface.FLWMTR_VARCHG_VALUE;
                    break;
                case InternalInterface.MG_ACT_CTRL_PREFIX:
                    info = state === FlowMonitorInterface.FLWMTR_START
                        ? FlowMonitorQueue.S_CTRLPRF_STR
                        : FlowMonitorQueue.E_CTRLPRF_STR;
                    id = FlowMonitorInterface.FLWMTR_CTRL_PREFIX;
                    break;
                case InternalInterface.MG_ACT_CTRL_SUFFIX:
                    info = state === FlowMonitorInterface.FLWMTR_START
                        ? FlowMonitorQueue.S_CTRLSUF_STR
                        : FlowMonitorQueue.E_CTRLSUF_STR;
                    id = FlowMonitorInterface.FLWMTR_CTRL_SUFFIX;
                    break;
                case InternalInterface.MG_ACT_CTRL_VERIFICATION:
                    info = state === FlowMonitorInterface.FLWMTR_START
                        ? FlowMonitorQueue.S_CTRLVER_STR
                        : FlowMonitorQueue.E_CTRLVER_STR;
                    id = FlowMonitorInterface.FLWMTR_CTRL_SUFFIX;
                    break;
                default:
                    info = null;
                    break;
            }
            let act = new ActivityItem(this, FlowMonitorQueue.ACT_TASK_FLW, id);
            if (info !== null) {
                info = info + ctrlName;
                if (id === FlowMonitorInterface.FLWMTR_VARCHG_VALUE && state === FlowMonitorInterface.FLWMTR_START)
                    info = info + FlowMonitorQueue.VARIABLE_REASON_STR;
                act.setInfo(info);
                Logger.Instance.WriteSupportToLog(taskInfo + ": " + info, true);
            }
            this._queue.put(act);
        }
    }
    addTaskFlowHandler(handlerId, state, taskInfo) {
        if (this._enabled && this._isTaskFlow) {
            let act = new ActivityItem(this, FlowMonitorQueue.ACT_TASK_FLW, FlowMonitorInterface.FLWMTR_TSK_HANDLER);
            let info;
            switch (state) {
                case FlowMonitorInterface.FLWMTR_START:
                    info = NString.Format(FlowMonitorQueue.S_HANDLER_STR, handlerId);
                    break;
                case FlowMonitorInterface.FLWMTR_END:
                    info = NString.Format(FlowMonitorQueue.E_HANDLER_STR, handlerId);
                    break;
                default:
                    info = null;
                    break;
            }
            if (info !== null) {
                act.setInfo(info);
                Logger.Instance.WriteSupportToLog(taskInfo + ": " + info, true);
            }
            this._queue.put(act);
        }
    }
    addRecompute(triggeredByVarName, taskInfo) {
        if (this._enabled && this._isRecompute) {
            let act = new ActivityItem(this, FlowMonitorQueue.ACT_RECOMPUTE, FlowMonitorInterface.FLWMTR_RECOMP);
            let info = FlowMonitorQueue.RECOMP_STR + triggeredByVarName;
            act.setInfo(info);
            this._queue.put(act);
            Logger.Instance.WriteSupportToLog(taskInfo + ": " + info, true);
        }
    }
    async addFlowFieldOperation(oper, bExecuted, taskInfo) {
        if (this._enabled && this._isFlowOperation) {
            let act = new ActivityItem(this, FlowMonitorQueue.ACT_FLW_OPER, FlowMonitorInterface.FLWMTR_DATA_OPER);
            let buffer = new StringBuilder(FlowMonitorQueue.FLW_PERFIX);
            await oper.AddFlowDescription(buffer);
            buffer.Append(' ');
            if (!bExecuted)
                buffer.Append("[Not Executed]");
            let info = buffer.ToString();
            act.setInfo(info);
            this._queue.put(act);
            Logger.Instance.WriteSupportToLog(taskInfo + ": " + info, true);
        }
    }
    addFlowOperationUpdate(state, taskInfo) {
        if (this._enabled && this._isFlowOperation) {
            let act = new ActivityItem(this, FlowMonitorQueue.ACT_FLW_OPER, FlowMonitorInterface.FLWMTR_DATA_OPER);
            let info;
            if (state === FlowMonitorInterface.FLWMTR_START)
                info = "Starts Update";
            else
                info = "Ends Update";
            act.setInfo(info);
            this._queue.put(act);
            Logger.Instance.WriteSupportToLog(taskInfo + ": " + info, true);
        }
    }
    addFlowVerifyInfo(info, taskInfo) {
        this.addFlowInfo(info, taskInfo);
    }
    addFlowInvokeOsInfo(info, taskInfo) {
        this.addFlowInfo(info, taskInfo);
    }
    addFlowInfo(info, taskInfo) {
        if (!this._enabled)
            return;
        let act = new ActivityItem(this, FlowMonitorQueue.ACT_FLW_OPER, FlowMonitorInterface.FLWMTR_DATA_OPER);
        let buffer = new StringBuilder("");
        if (!(info === "")) {
            buffer.Append(" >> INFORMATION >> ");
            buffer.Append(info);
        }
        let newInfo = buffer.ToString();
        act.setInfo(newInfo);
        this._queue.put(act);
        Logger.Instance.WriteSupportToLog(taskInfo + ": " + newInfo, true);
    }
}
FlowMonitorQueue._instance = null;
FlowMonitorQueue.UNPRINTABLE_STR_LOG = "#UNPRINTABLE#";
FlowMonitorQueue.S_EVENT_STR1 = ">>Starts ";
FlowMonitorQueue.S_EVENT_STR2 = " Event";
FlowMonitorQueue.S_EVENT_PROPAGATED = "Event was propagated";
FlowMonitorQueue.E_EVENT_STR = "<<Ends Event";
FlowMonitorQueue.S_RECPRF_STR = "Starts Record Prefix";
FlowMonitorQueue.E_RECPRF_STR = "Ends Record Prefix";
FlowMonitorQueue.S_RECSUF_STR = "Starts Record Suffix";
FlowMonitorQueue.E_RECSUF_STR = "Ends Record Suffix";
FlowMonitorQueue.S_TASKSUF_STR = "Starts Task Suffix";
FlowMonitorQueue.E_TASKSUF_STR = "Ends Task Suffix";
FlowMonitorQueue.S_TASKPRF_STR = "Starts Task Prefix";
FlowMonitorQueue.E_TASKPRF_STR = "Ends Task Prefix";
FlowMonitorQueue.S_CTRLPRF_STR = "Starts Control Prefix - ";
FlowMonitorQueue.E_CTRLPRF_STR = "Ends Control Prefix - ";
FlowMonitorQueue.S_CTRLSUF_STR = "Starts Control Suffix - ";
FlowMonitorQueue.E_CTRLSUF_STR = "Ends Control Suffix - ";
FlowMonitorQueue.S_HANDLER_STR = "Starts handling event {0}";
FlowMonitorQueue.E_HANDLER_STR = "Ends handling event {0}";
FlowMonitorQueue.S_CTRLVER_STR = "Starts Control Verification for Control - ";
FlowMonitorQueue.E_CTRLVER_STR = "Ends Control Verification for Control - ";
FlowMonitorQueue.RECOMP_STR = "Recomputes - ";
FlowMonitorQueue.S_VARIABLE_STR = "Starts Variable Change - ";
FlowMonitorQueue.E_VARIABLE_STR = "Ends Variable Change - ";
FlowMonitorQueue.VARIABLE_REASON_STR = " - Reason - Previous value";
FlowMonitorQueue.FLW_PERFIX = "Flow - ";
FlowMonitorQueue.ACT_TASK = 'T';
FlowMonitorQueue.ACT_TASK_FLW = 'F';
FlowMonitorQueue.ACT_RECOMPUTE = 'R';
FlowMonitorQueue.ACT_FLW_OPER = 'T';
FlowMonitorQueue.LongTimePattern = "HH:mm:ss:SSS";
class ActivityItem {
    constructor(enclosingInstance, type, id) {
        this._id = 0;
        this._type = null;
        this._info = null;
        this._time = null;
        this._type = type;
        this._id = id;
        this.setTime();
    }
    setTime() {
        this._time = DateTimeUtils.ToString(DateTime.Now, FlowMonitorQueue.LongTimePattern, Logger.Instance);
    }
    setInfo(info_) {
        this._info = ((info_ !== null) ? XmlParser.escape(info_) : info_);
    }
    buildXML(message) {
        message.Append(XMLConstants.START_TAG + ConstInterface.MG_TAG_FLWMTR_ACT);
        message.Append(" " + XMLConstants.MG_ATTR_TYPE + "=\"" + this._type + "\"");
        message.Append(" " + XMLConstants.MG_ATTR_ID + "=\"" + this._id + "\"");
        if (this._info != null)
            message.Append(" " + ConstInterface.MG_ATTR_INFO + "=\"" + this._info + "\"");
        message.Append(" " + ConstInterface.MG_ATTR_TIME + "=\"" + this._time + "\"");
        message.Append(XMLConstants.TAG_TERM);
    }
}

class TimerObjectCollection {
}
TimerObjectCollection.MgDataToTimerObjList = new Dictionary();
class RCTimer extends MgTimer {
    get TimerIntervalMiliSeconds() {
        return this._timerIntervalMilliSeconds;
    }
    set IsIdleTimer(value) {
        this._isIdle = value;
    }
    get IsIdleTimer() {
        return this._isIdle;
    }
    constructor(mgData, milliseconds, isIdle) {
        super(milliseconds);
        this._mgData = null;
        this._isIdle = false;
        this._mgData = mgData;
        this.IsIdleTimer = isIdle;
        let mgDataId = this._mgData.GetId().toString();
        if (!TimerObjectCollection.MgDataToTimerObjList.ContainsKey(mgDataId))
            TimerObjectCollection.MgDataToTimerObjList.Add(mgDataId, new List());
        TimerObjectCollection.MgDataToTimerObjList.get_Item(mgDataId).push(this);
    }
    GetMgdata() {
        return this._mgData;
    }
    static StopTimer(mgData, milliseconds, isIdle) {
        let timers = null;
        let timer = null;
        let mgDataId = mgData.GetId().toString();
        if (TimerObjectCollection.MgDataToTimerObjList.ContainsKey(mgDataId)) {
            timers = TimerObjectCollection.MgDataToTimerObjList.get_Item(mgDataId);
            timer = timers.find(rcTimer => {
                return (rcTimer !== null) && (rcTimer._timerIntervalMilliSeconds === milliseconds && rcTimer._isIdle === isIdle);
            });
            if (timer != null) {
                timer.Stop();
                timers.Remove(timer);
            }
            if (timers.length === 0)
                TimerObjectCollection.MgDataToTimerObjList.Remove(mgDataId);
        }
    }
    static StopAll(mgData) {
        let timers = null;
        let mgDataId = mgData.GetId().toString();
        if (TimerObjectCollection.MgDataToTimerObjList.ContainsKey(mgDataId))
            timers = TimerObjectCollection.MgDataToTimerObjList.get_Item(mgDataId);
        if (timers !== null) {
            timers.forEach(rcTimer => {
                if (rcTimer !== null) {
                    rcTimer.Stop();
                }
            });
            timers.Clear();
            TimerObjectCollection.MgDataToTimerObjList.Remove(mgDataId);
        }
    }
}

class ExecutionStackEntry {
    constructor(intaskId, inhandlerId, inoperIdx) {
        this.TaskId = null;
        this.HandlerId = null;
        this.OperIdx = 0;
        this.TaskId = intaskId;
        this.HandlerId = inhandlerId;
        this.OperIdx = inoperIdx;
    }
    Equals(obj) {
        let executionStackEntry = ((obj instanceof ExecutionStackEntry) ? obj : null);
        return executionStackEntry !== null &&
            executionStackEntry.HandlerId === this.HandlerId && executionStackEntry.TaskId === this.TaskId &&
            executionStackEntry.OperIdx === this.OperIdx;
    }
}

class ExecutionStack {
    constructor(inExecStack) {
        this._execStack = null;
        if (arguments.length === 0) {
            this.constructor_0();
            return;
        }
        this.constructor_1(inExecStack);
    }
    constructor_0() {
        this._execStack = new Stack();
    }
    constructor_1(inExecStack) {
        this._execStack = inExecStack.getStack().Clone();
    }
    getStack() {
        return this._execStack;
    }
    push(execEntryOrTaskId, handlerId, operIdx) {
        if (arguments.length === 1)
            this.push_0(execEntryOrTaskId);
        else
            this.push_1(execEntryOrTaskId, handlerId, operIdx);
    }
    push_0(execEntry) {
        this._execStack.push(execEntry);
    }
    push_1(taskId, handlerId, operIdx) {
        let execEntry = new ExecutionStackEntry(taskId, handlerId, operIdx);
        this._execStack.push(execEntry);
    }
    pop() {
        return this._execStack.pop();
    }
    empty() {
        return this._execStack.count() === 0;
    }
    clear() {
        this._execStack.Clear();
    }
    size() {
        return this._execStack.count();
    }
    Equals(execStackCmp) {
        let tmpExecStack = new ExecutionStack(this);
        let tmpExecStackCmp = new ExecutionStack(execStackCmp);
        let equalStacks = false;
        if (tmpExecStack.size() === tmpExecStackCmp.size()) {
            equalStacks = true;
            while (!tmpExecStack.empty() && equalStacks) {
                if (!tmpExecStack.pop().Equals(tmpExecStackCmp.pop()))
                    equalStacks = false;
            }
        }
        return equalStacks;
    }
    pushUpSideDown(inExecStack) {
        let tmpStack = new ExecutionStack(inExecStack);
        while (!tmpStack.empty()) {
            let tmpStackEntry = tmpStack.pop();
            this._execStack.push(tmpStackEntry);
        }
    }
    reverse() {
        let tmpExecStack = new ExecutionStack(this);
        this.clear();
        while (!tmpExecStack.empty()) {
            let tmpExecStackEntry = tmpExecStack.pop();
            this.push(tmpExecStackEntry);
        }
    }
    buildXML(message) {
        let forMessage = new StringBuilder();
        while (this._execStack.count() !== 0) {
            let ExecEntry = this._execStack.pop();
            let taskTag = NNumber.Parse(ExecEntry.TaskId);
            if (taskTag > ConstInterface.INITIAL_OFFLINE_TASK_TAG) {
                forMessage.Remove(0, forMessage.Length);
                continue;
            }
            forMessage.Append("\n " + XMLConstants.TAG_OPEN + ConstInterface.MG_TAG_EXEC_STACK_ENTRY);
            forMessage.Append(" " + XMLConstants.MG_ATTR_TASKID + "=\"" + ExecEntry.TaskId + "\"");
            forMessage.Append(" " + ConstInterface.MG_ATTR_HANDLERID + "=\"" + ExecEntry.HandlerId + "\"");
            forMessage.Append(" " + ConstInterface.MG_ATTR_OPER_IDX + "=\"" + ExecEntry.OperIdx + "\"");
            forMessage.Append(" " + XMLConstants.TAG_TERM);
        }
        message.Append(forMessage.ToString());
    }
}

class ExecOperCommand extends ClientOriginatedCommandTaskTag {
    get CommandTypeAttribute() {
        return ConstInterface.MG_ATTR_VAL_EXEC_OPER;
    }
    constructor() {
        super();
        this.ExecutionStack = null;
        this.TaskTag = null;
        this.HandlerId = null;
        this.OperIdx = 0;
        this.DitIdx = 0;
        this.Val = null;
        this.MprgCreator = null;
        this.Operation = null;
        this.CheckOnly = false;
        this.DitIdx = Int32.MinValue;
    }
    SerializeCommandData() {
        let helper = new CommandSerializationHelper();
        let execStackExists = this.ExecutionStack !== null && !this.ExecutionStack.empty();
        helper.SerializeTaskTag(this.TaskTag);
        if (this.HandlerId !== null && !execStackExists)
            helper.SerializeAttribute(ConstInterface.MG_ATTR_HANDLERID, this.HandlerId);
        if (this.OperIdx > Int32.MinValue && !execStackExists)
            helper.SerializeAttribute(ConstInterface.MG_ATTR_OPER_IDX, this.OperIdx);
        if (this.DitIdx > Int32.MinValue)
            helper.SerializeDitIdx(this.DitIdx);
        if (this.Operation != null && this.Operation.getType() === ConstInterface.MG_OPER_CALL && this.Operation.getRouteParams() !== null) {
            helper.SerializeRouteParams(this.Operation);
        }
        if (this.Val !== null)
            helper.SerializeAttribute(XMLConstants.MG_ATTR_VALUE, XmlParser.escape(this.Val));
        if (this.CheckOnly)
            helper.SerializeAttribute(ConstInterface.MG_ATTR_CHECK_ONLY, "1");
        return helper.GetString();
    }
    SetExecutionStack(execStack) {
        this.ExecutionStack = new ExecutionStack();
        this.ExecutionStack.push(AccessHelper.mgDataTable.getTaskIdById(this.TaskTag), this.HandlerId, this.OperIdx);
        this.ExecutionStack.pushUpSideDown(execStack);
    }
    SerializeDataAfterCommand() {
        let execStackExists = this.ExecutionStack !== null && !this.ExecutionStack.empty();
        if (execStackExists) {
            let message = new StringBuilder();
            this.ExecutionStack.buildXML(message);
            return message.ToString();
        }
        return null;
    }
    getCommandInfo() {
        return 'Line number ' + '[' + (this.Operation.getServerId() + 1) + ']' +
            ' in ' + '[' + this.Operation.getEventHandler().getEventHandlerInfo() + ']' +
            ' on ' + '[' + this.Operation.Task.getTaskInfo() + ']';
    }
    getTask() {
        return this.Operation.Task;
    }
}

class Scrambler {
    static Scramble(inVal) {
        if (!this.ScramblingEnabled)
            return inVal;
        let curr = 0;
        let currChr;
        let length = inVal.length;
        let random = Scrambler.RandomScramble(length);
        let key = Math.floor(Math.sqrt(length)) + random;
        let outVal = new StringBuilder(length + 1);
        outVal.Append(String.fromCharCode(random + 81));
        for (let i = 0; i < key; i++) {
            curr = i;
            while (curr < length) {
                currChr = inVal[curr];
                outVal.Append(currChr);
                curr += key;
            }
        }
        outVal.Append('_');
        return outVal.ToString();
    }
    static LocateScramble(inVal, from) {
        let i = from;
        while (i < inVal.length && NChar.IsWhiteSpace(inVal.charAt(i))) {
            i = i + 1;
        }
        return i + 1;
    }
    static RandomScramble(len) {
        let delta;
        let sqrt = Math.sqrt(len);
        let low = Scrambler.XML_MIN_RANDOM;
        let high = Scrambler.XML_MAX_RANDOM;
        if (low < (((-1) * sqrt) / 2))
            low = Math.floor(((-1) * sqrt) / 2);
        if (high > (sqrt / 2))
            high = Math.floor(sqrt / 2);
        delta = (Math.random() * (high - low)) + low;
        delta = Math.floor(delta);
        if (delta === Scrambler.XML_ILLEGAL_RANDOM)
            delta++;
        return delta;
    }
    static UnScramble(inVal, beginOffSet, endOffSet) {
        if (!Scrambler.ScramblingEnabled) {
            let outVal = inVal.substr(beginOffSet, endOffSet - beginOffSet + 1);
            return outVal;
        }
        else {
            let currOut, currIn, i;
            let length;
            let key;
            let outVal;
            let currBlk;
            let blockSize;
            let reminder;
            let start;
            let randomChr;
            endOffSet = endOffSet - 1;
            start = this.LocateScramble(inVal, beginOffSet);
            randomChr = inVal[start - 1];
            length = endOffSet - start + 1;
            key = (randomChr.charCodeAt(0) - 81) + Math.floor(Math.sqrt(length));
            outVal = new Array(length);
            blockSize = Math.floor(length / key);
            reminder = length % key;
            for (i = currOut = 0; currOut < length; i++) {
                currIn = i;
                currBlk = 1;
                while (currIn < length && currOut < length) {
                    outVal[currOut] = inVal[currIn + start];
                    currIn += blockSize;
                    if (currBlk <= reminder)
                        currIn++;
                    currOut++;
                    currBlk++;
                }
            }
            return NString.FromChars(outVal);
        }
    }
}
Scrambler.ScramblingEnabled = true;
Scrambler.XML_MIN_RANDOM = -48;
Scrambler.XML_MAX_RANDOM = 47;
Scrambler.XML_ILLEGAL_RANDOM = -21;

var CommandsProcessorBase_SessionStage;
(function (CommandsProcessorBase_SessionStage) {
    CommandsProcessorBase_SessionStage[CommandsProcessorBase_SessionStage["HANDSHAKE"] = 1] = "HANDSHAKE";
    CommandsProcessorBase_SessionStage[CommandsProcessorBase_SessionStage["INITIAL"] = 2] = "INITIAL";
    CommandsProcessorBase_SessionStage[CommandsProcessorBase_SessionStage["NORMAL"] = 3] = "NORMAL";
})(CommandsProcessorBase_SessionStage || (CommandsProcessorBase_SessionStage = {}));
var CommandsProcessorBase_SendingInstruction;
(function (CommandsProcessorBase_SendingInstruction) {
    CommandsProcessorBase_SendingInstruction[CommandsProcessorBase_SendingInstruction["NO_TASKS_OR_COMMANDS"] = 0] = "NO_TASKS_OR_COMMANDS";
    CommandsProcessorBase_SendingInstruction[CommandsProcessorBase_SendingInstruction["ONLY_COMMANDS"] = 1] = "ONLY_COMMANDS";
    CommandsProcessorBase_SendingInstruction[CommandsProcessorBase_SendingInstruction["TASKS_AND_COMMANDS"] = 2] = "TASKS_AND_COMMANDS";
})(CommandsProcessorBase_SendingInstruction || (CommandsProcessorBase_SendingInstruction = {}));
class CommandsProcessorBase {
    constructor() {
        this._sessionCounter = 0;
    }
    GetSessionCounter() {
        return this._sessionCounter;
    }
    async StartSession() {
        return Promise.resolve(true);
    }
    async Execute(sendingInstruction, sessionStage, res) {
        if (isNullOrUndefined(sessionStage)) {
            await this.Execute_0(sendingInstruction);
            return;
        }
        await this.Execute_1(sendingInstruction, sessionStage, res);
    }
    async Execute_0(sendingInstruction) {
        await this.Execute_1(sendingInstruction, CommandsProcessorBase_SessionStage.NORMAL, null);
    }
    async Execute_1(sendingInstruction, sessionStage, res) {
        return Promise.resolve();
    }
    async GetContent(requestedURL, useCache) {
        return Promise.resolve('');
    }
    static UnScramble(respBuf) {
        let openTagLocation = respBuf.indexOf(XMLConstants.MG_TAG_OPEN);
        let core;
        if (openTagLocation !== -1) {
            let start = openTagLocation + XMLConstants.MG_TAG_OPEN.length;
            let openTag = respBuf.substr(0, start);
            let finish = respBuf.lastIndexOf(XMLConstants.TAG_OPEN);
            let closeTag = respBuf.substr(finish);
            core = openTag + Scrambler.UnScramble(respBuf, start, finish - 1) + closeTag;
        }
        else {
            core = Scrambler.UnScramble(respBuf, 0, respBuf.length - 1);
        }
        return core;
    }
}

class HttpClientEvents {
    static GetHttpCommunicationTimeout() {
        return (HttpClientEvents.GetHttpCommunicationTimeout_Event !== null) ? HttpClientEvents.GetHttpCommunicationTimeout_Event() : 5000;
    }
    static GetExecutionProperty(propertyName) {
        return (HttpClientEvents.GetExecutionProperty_Event !== null) ? HttpClientEvents.GetExecutionProperty_Event(propertyName) : null;
    }
    static GetGlobalUniqueSessionID() {
        return (HttpClientEvents.GetGlobalUniqueSessionID_Event !== null) ? HttpClientEvents.GetGlobalUniqueSessionID_Event() : null;
    }
    static ShouldDisplayGenericError() {
        return HttpClientEvents.ShouldDisplayGenericError_Event === null || HttpClientEvents.ShouldDisplayGenericError_Event();
    }
    static GetRuntimeCtxID() {
        return (HttpClientEvents.GetRuntimeCtxID_Event !== null) ? HttpClientEvents.GetRuntimeCtxID_Event() : "";
    }
    static GetSessionCounter() {
        return (HttpClientEvents.GetSessionCounter_Event !== null) ? HttpClientEvents.GetSessionCounter_Event() : 0;
    }
    static CheckAndSetSessionCounter(value) {
        let flag = HttpClientEvents.CheckAndSetSessionCounter_Event !== null;
        if (flag) {
            HttpClientEvents.CheckAndSetSessionCounter_Event(value);
        }
    }
    static ComputeAndLogRequestInfo(contentLength, roundTrip, isLoggingResponse) {
        if (HttpClientEvents.ComputeAndLogRequestInfo_Event !== null)
            HttpClientEvents.ComputeAndLogRequestInfo_Event(contentLength, roundTrip, isLoggingResponse);
    }
}
HttpClientEvents.GetHttpCommunicationTimeout_Event = null;
HttpClientEvents.GetExecutionProperty_Event = null;
HttpClientEvents.GetGlobalUniqueSessionID_Event = null;
HttpClientEvents.ShouldDisplayGenericError_Event = null;
HttpClientEvents.GetRuntimeCtxID_Event = null;
HttpClientEvents.GetSessionCounter_Event = null;
HttpClientEvents.CheckAndSetSessionCounter_Event = null;
HttpClientEvents.ComputeAndLogRequestInfo_Event = null;

var RequestMethod;
(function (RequestMethod) {
    RequestMethod[RequestMethod["Get"] = 0] = "Get";
    RequestMethod[RequestMethod["Post"] = 1] = "Post";
    RequestMethod[RequestMethod["Put"] = 2] = "Put";
    RequestMethod[RequestMethod["Delete"] = 3] = "Delete";
    RequestMethod[RequestMethod["Options"] = 4] = "Options";
    RequestMethod[RequestMethod["Head"] = 5] = "Head";
    RequestMethod[RequestMethod["Patch"] = 6] = "Patch";
})(RequestMethod || (RequestMethod = {}));
class HttpClientBase {
    constructor() {
        this._HTTPMaxURLLength = 2048;
        this.CommunicationsFailureHandler = null;
        this.CommunicationsFailureHandler = null;
    }
    DecideOnRequestMethod(requestContent, requestURL) {
        let method = RequestMethod.Get;
        if (requestContent === null) {
            method = RequestMethod.Get;
        }
        else {
            if (requestURL.value.length + 1 + requestContent.length <= this._HTTPMaxURLLength) {
                requestURL.value = requestURL.value + "?" + requestContent;
                method = RequestMethod.Get;
            }
            else {
                method = RequestMethod.Post;
            }
        }
        return method;
    }
    async GetContent(requestURL, requestContent, useCache) {
        let contentFromServer = new RefParam(null);
        let requestUrlRef = new RefParam(requestURL);
        let httpMethod = this.DecideOnRequestMethod(requestContent, requestUrlRef);
        requestURL = requestUrlRef.value;
        try {
            let response = await this.ExecuteHttpRequest(requestURL, requestContent, useCache, httpMethod, contentFromServer);
            if (response != null) {
                Logger.Instance.WriteServerToLog("Incoming Headers : " + HttpClientBase.HeadersToString(response.headers, true));
                let nextSessionCounterString = response.headers.get("MgxpaNextSessionCounter".toLowerCase());
                if (!isNullOrUndefined(nextSessionCounterString)) {
                    HttpClientEvents.CheckAndSetSessionCounter(+nextSessionCounterString);
                }
            }
        }
        catch (ex) {
            Logger.Instance.WriteWarningToLog(ex);
            throw ex;
        }
        return contentFromServer.value;
    }
    async ExecuteHttpRequest(urlString, requestContent, useCache, httpMethod, contentFromServer) {
        let httpResponse = null;
        this.prepareRequest();
        let httpCommunicationTimeoutMS = HttpClientEvents.GetHttpCommunicationTimeout();
        let clientID = HttpClientEvents.GetGlobalUniqueSessionID();
        let executionAttempts = 0;
        let startTime = Misc.getSystemMilliseconds();
        while (true) {
            executionAttempts++;
            try {
                let httpHeaders = new HttpHeaders();
                httpHeaders = this.addHeaders(urlString, useCache, httpHeaders, clientID);
                Logger.Instance.WriteServerToLog(NString.Format("Request Timeout set to {0} ms", httpCommunicationTimeoutMS));
                if (Logger.Instance.LogLevel === Logger_LogLevels.Basic) {
                    let contentLength = 0;
                    if (httpMethod === RequestMethod.Get) {
                        let parts = urlString.split('?');
                        if (parts.length === 2)
                            contentLength = parts[1].length;
                    }
                    else
                        contentLength = requestContent.length;
                    Logger.Instance.WriteBasicToLog(Logger_MessageDirection.MessageLeaving, HttpClientEvents.GetRuntimeCtxID(), HttpClientEvents.GetSessionCounter(), clientID, HttpClientEvents.ShouldDisplayGenericError() ? "-" : new URL(urlString).host, 0, '-', JSON.stringify(httpHeaders), contentLength);
                }
                let timeBeforeRequest = Misc.getSystemMilliseconds();
                Logger.Instance.WriteServerToLog(NString.Format("Accessing (method: '{0}'): '{1}'", httpMethod, urlString));
                Logger.Instance.WriteServerToLog("Outgoing Headers : " + HttpClientBase.HeadersToString(httpHeaders, false));
                if (httpMethod === RequestMethod.Post) {
                }
                let requestTime = Misc.getSystemMilliseconds();
                this.LogRequestInfo(!isNullOrUndefined(requestContent) ? requestContent.length : 0, requestTime, false);
                httpResponse = await this.sendRequestToServer(httpMethod, urlString, httpHeaders, requestContent, contentFromServer);
                this.logResponse(httpResponse, clientID, urlString, contentFromServer, timeBeforeRequest);
                this.LogRequestInfo(!isNullOrUndefined(requestContent) ? requestContent.length : 0, Misc.getSystemMilliseconds() - requestTime, true);
                break;
            }
            catch (ex) {
                if (Logger.Instance.LogLevel === Logger_LogLevels.Basic)
                    Logger.Instance.WriteBasicErrorToLog();
                else
                    Logger.Instance.WriteWarningToLog(ex);
                this.handleHttpErrorException(ex, urlString);
                let startTimeRef = new RefParam(startTime);
                if (this.shouldRetry(httpCommunicationTimeoutMS, urlString, this.CommunicationsFailureHandler, ex, startTimeRef)) {
                    startTime = startTimeRef.value;
                    continue;
                }
                this.logAndThrowException(ex);
            }
        }
        this.logExecutionAttempts(executionAttempts);
        return httpResponse;
    }
    LogRequestInfo(contentLength, roundTrip, isLoggingResponse) {
        if (Logger.Instance.LogLevel == Logger_LogLevels.RequestInfo) {
            HttpClientEvents.ComputeAndLogRequestInfo(contentLength, roundTrip, isLoggingResponse);
        }
    }
    static HeadersToString(headers, bFilter) {
        let headersStr = new StringBuilder();
        let headerKeys = headers.keys();
        for (let key in headerKeys) {
            if (!bFilter || headerKeys[key].startsWith("Mg"))
                headersStr.Append(NString.Format("{0}:{1} ", headerKeys[key], headers.get(headerKeys[key])));
        }
        return headersStr;
    }
    async sendRequestToServer(httpMethod, urlString, httpHeaders, requestContent, contentFromServer) {
        return Promise.resolve();
    }
    async shouldRetry(httpCommunicationTimeoutMS, urlString, communicationsFailureHandler, ex, startTimeRef) {
        return Promise.resolve(false);
    }
}

class HttpClientSync extends HttpClientBase {
    constructor() {
        super();
        this.httpRequest = null;
        this.headers = new Headers();
    }
    prepareRequest() {
    }
    addHeaders(urlString, useCache, httpHeaders, clientID) {
        if (!urlString.startsWith("/")) {
            this.headers.append("MgxpaRIAglobalUniqueSessionID", clientID);
        }
        if (!useCache) {
            this.headers.append("Cache-Control", "no-cache");
        }
        return httpHeaders;
    }
    async sendRequestToServer(httpMethod, urlString, httpHeaders, requestContent, contentFromServer) {
        await fetch(urlString, { method: 'POST', headers: this.headers, body: requestContent, keepalive: true });
        return NString.Empty;
    }
    logResponse(httpResponse, clientID, urlString, contentFromServer, timeBeforeRequest) {
        let responseTime = Misc.getSystemMilliseconds() - timeBeforeRequest;
        if (Logger.Instance.LogLevel === Logger_LogLevels.Basic)
            Logger.Instance.WriteBasicToLog(Logger_MessageDirection.MessageEntering, HttpClientEvents.GetRuntimeCtxID(), HttpClientEvents.GetSessionCounter(), clientID, HttpClientEvents.ShouldDisplayGenericError() ? "-" : new URL(urlString).host, responseTime, this.httpRequest.status.toString(), JSON.stringify(this.httpRequest.getAllResponseHeaders()), contentFromServer.value.length);
    }
    handleHttpErrorException(ex, urlString) {
        throw ex;
    }
    async shouldRetry(httpCommunicationTimeoutMS, urlString, communicationsFailureHandler, ex, startTimeRef) {
        return Promise.resolve(false);
    }
    logAndThrowException(ex) {
    }
    logExecutionAttempts(executionAttempts) {
    }
}

class HttpClientAsync extends HttpClientBase {
    constructor(httpClient) {
        super();
        this.httpClient = httpClient;
    }
    prepareRequest() {
    }
    addHeaders(urlString, useCache, httpHeaders, clientID) {
        if (!urlString.startsWith("/"))
            httpHeaders = httpHeaders.append("MgxpaRIAglobalUniqueSessionID", clientID);
        if (!useCache)
            httpHeaders = httpHeaders.append("Cache-Control", 'no-cache');
        return httpHeaders;
    }
    async sendRequestToServer(httpMethod, urlString, httpHeaders, requestContent, contentFromServer) {
        let httpResponse = await this.httpClient.request(RequestMethod[httpMethod], urlString, { headers: httpHeaders, responseType: "text", observe: "response", body: requestContent }).toPromise();
        contentFromServer.value = httpResponse.body;
        return httpResponse;
    }
    logResponse(httpResponse, clientID, urlString, contentFromServer, timeBeforeRequest) {
        let statusCode = httpResponse['status'];
        let responseTime = Misc.getSystemMilliseconds() - timeBeforeRequest;
        if (Logger.Instance.LogLevel === Logger_LogLevels.Basic)
            Logger.Instance.WriteBasicToLog(Logger_MessageDirection.MessageEntering, HttpClientEvents.GetRuntimeCtxID(), HttpClientEvents.GetSessionCounter(), clientID, HttpClientEvents.ShouldDisplayGenericError() ? "-" : new URL(urlString).host, responseTime, statusCode.toString(), JSON.stringify(httpResponse.headers), contentFromServer.value.length);
    }
    handleHttpErrorException(ex, urlString) {
        if (ex instanceof HttpErrorResponse) {
            let statusCode = ex['status'];
            if (statusCode === 404 || statusCode === 403)
                throw new WebException(new Error("bad URL: " + urlString + " - StatusCode = " + statusCode));
        }
    }
    async shouldRetry(httpCommunicationTimeoutMS, urlString, communicationsFailureHandler, ex, startTimeRef) {
        let currentDelayMS = Math.floor(httpCommunicationTimeoutMS / 10);
        let httpElapsedTimeMS = Misc.getSystemMilliseconds() - startTimeRef.value + currentDelayMS;
        if (httpElapsedTimeMS <= httpCommunicationTimeoutMS) {
            await Thread.Sleep(currentDelayMS);
            Logger.Instance.WriteWarningToLogWithMsg(NString.Format("Retrying {0} : elapsed time {1:N0}ms out of {2:N0}ms", urlString, httpElapsedTimeMS, httpCommunicationTimeoutMS));
            return true;
        }
        Logger.Instance.WriteWarningToLogWithMsg(NString.Format("{0} : http timeout {1:N0}ms expired", urlString, httpCommunicationTimeoutMS));
        if (communicationsFailureHandler != null) {
            communicationsFailureHandler.CommunicationFailed(urlString, ex);
            if (communicationsFailureHandler.ShouldRetryLastRequest) {
                Logger.Instance.WriteServerToLog(NString.Format("Retrying {0}, confirmed by user ...", urlString));
                startTimeRef.value = Misc.getSystemMilliseconds();
                return true;
            }
        }
        return false;
    }
    logAndThrowException(ex) {
        Logger.Instance.WriteWarningToLogWithMsg("Re-throwing ...");
        Logger.Instance.WriteWarningToLog(ex);
        throw new WebException(ex);
    }
    logExecutionAttempts(executionAttempts) {
        if (executionAttempts > 1)
            Logger.Instance.WriteServerToLog(NString.Format("Succeeded after {0} attempts ...", executionAttempts));
    }
}

class HttpManager {
    getHttpClient() {
        if (this.IsAbortingMagicEngine)
            return new HttpClientSync();
        return this._httpClientAsync;
    }
    set HttpCommunicationTimeoutMS(value) {
        this._httpCommunicationTimeoutMS = value;
    }
    static setNativeHttpClient(httpClient) {
        HttpManager._nativeHttpClient = httpClient;
    }
    static GetInstance() {
        if (HttpManager._instance === null) {
            HttpManager._instance = new HttpManager();
        }
        return HttpManager._instance;
    }
    get IsAbortingMagicEngine() { return this._isAbortingMagicEngine; }
    set IsAbortingMagicEngine(isAbortingMagicEngine) { this._isAbortingMagicEngine = isAbortingMagicEngine; }
    constructor() {
        this._httpCommunicationTimeoutMS = HttpManager.DEFAULT_HTTP_COMMUNICATION_TIMEOUT;
        this._httpClientAsync = null;
        this._isAbortingMagicEngine = false;
        this._httpClientAsync = new HttpClientAsync(HttpManager._nativeHttpClient);
        this.RegisterBasicDelegates();
    }
    RegisterBasicDelegates() {
        HttpClientEvents.GetHttpCommunicationTimeout_Event = this.GetHttpCommunicationTimeoutMS.bind(this);
    }
    GetHttpCommunicationTimeoutMS() {
        return this._httpCommunicationTimeoutMS;
    }
    SetCommunicationsFailureHandler(handler) {
        this.getHttpClient().CommunicationsFailureHandler = handler;
    }
    async GetContent(requestedURL, requestContent, useCache, isError) {
        let response;
        Debug.Assert(this.getHttpClient() != null);
        try {
            Logger.Instance.WriteServerToLog("*************************************************************************************************");
            isError.value = false;
            Logger.Instance.WriteServerToLog(requestedURL);
            HttpManager.LogAccessToServer("", requestContent);
            response = await this.getHttpClient().GetContent(requestedURL, requestContent, useCache);
            Debug.Assert(response !== null);
            let errorResponse = HttpManager.CheckAndGetErrorResponse(response);
            if (errorResponse !== null) {
                response = errorResponse;
                isError.value = true;
            }
            return response;
        }
        catch (ex) {
            let url = new URL(requestedURL);
            throw new ApplicationException(ex.Message + "\n" + url.origin + url.pathname, ex);
        }
        finally {
        }
    }
    static CheckAndGetErrorResponse(httpResponse) {
        let errorResponse = null;
        if (httpResponse.startsWith(ConstInterface.V24_RIA_ERROR_PREFIX))
            errorResponse = httpResponse.substr(ConstInterface.V24_RIA_ERROR_PREFIX.length);
        return errorResponse;
    }
    static LogAccessToServer(msg, requestContent) {
        if (Logger.Instance.ShouldLogServerRelatedMessages()) {
            if (!NString.IsNullOrEmpty(msg)) {
                msg = msg + "; accessing server ...";
            }
            if (requestContent === null) {
                if (!NString.IsNullOrEmpty(msg)) {
                    Logger.Instance.WriteServerToLog(msg);
                }
            }
            else {
                if (!NString.IsNullOrEmpty(msg)) {
                    msg = msg + " ";
                }
                msg = msg + "uploading " + requestContent.length + " bytes";
                Logger.Instance.WriteServerToLog(msg);
            }
        }
    }
}
HttpManager._instance = null;
HttpManager.DEFAULT_HTTP_COMMUNICATION_TIMEOUT = 5 * 1000;
HttpManager.DEFAULT_OFFLINE_HTTP_COMMUNICATION_TIMEOUT = 2 * 1000;
HttpManager._nativeHttpClient = null;

class ServerConfig {
    constructor() {
        this._protocol = null;
        this._server = null;
        this._httpReq = null;
        this._appName = null;
        this._serverUrl = null;
    }
    Init(obj) {
        this._executionProps = obj;
    }
    ShouldDisplayGenericError() {
        return this._executionProps.DisplayGenericError;
    }
    setUsername(username) {
        this._executionProps[ConstInterface.MG_TAG_USERNAME] = username;
    }
    setPassword(password) {
        this._executionProps[ConstInterface.MG_TAG_PASSWORD] = password;
    }
    setSkipAuthenticationDialog(value) {
        this._executionProps[ConstInterface.REQ_SKIP_AUTHENTICATION] = value.toString();
    }
    setGlobalParams(val) {
        if (val !== null)
            this._executionProps[ConstInterface.MG_TAG_GLOBALPARAMS] = val;
        else
            delete this._executionProps[ConstInterface.MG_TAG_GLOBALPARAMS];
    }
    getGlobalParams() {
        let ret = this._executionProps[ConstInterface.MG_TAG_GLOBALPARAMS];
        return typeof ret === "undefined" ? null : ret;
    }
    getProtocol() {
        if (this._protocol === null)
            this._protocol = this._executionProps.protocol;
        return this._protocol;
    }
    getServer() {
        if (this._server === null)
            this._server = this._executionProps.server;
        return this._server;
    }
    getHttpReq() {
        if (this._httpReq === null) {
            this._httpReq = this._executionProps.requester;
            if (this._httpReq !== null) {
                while (this._httpReq.startsWith("/"))
                    this._httpReq = this._httpReq.substr(1);
                while (this._httpReq.endsWith("/"))
                    this._httpReq = this._httpReq.substr(0, this._httpReq.length - 1);
            }
        }
        return this._httpReq;
    }
    getAppName() {
        if (this._appName === null)
            this._appName = this._executionProps.appname;
        return this._appName;
    }
    getInternalLogLevel() {
        return this._executionProps.InternalLogLevel;
    }
    setInternalLogLevel(value) {
        this._executionProps.InternalLogLevel = value;
    }
    getInternalLogSync() {
        return this._executionProps.InternalLogSync;
    }
    getUsername() {
        let ret = this._executionProps[ConstInterface.MG_TAG_USERNAME];
        return typeof ret === "undefined" ? null : ret;
    }
    getPassword() {
        let ret = this._executionProps[ConstInterface.MG_TAG_PASSWORD];
        return typeof ret === "undefined" ? null : ret;
    }
    getCtxGroup() {
        let ret = this._executionProps[ConstInterface.CTX_GROUP];
        return typeof ret === "undefined" ? null : ret;
    }
    setCtxGroup(CtxGroup) {
        this._executionProps[ConstInterface.CTX_GROUP] = CtxGroup;
    }
    getSkipAuthenticationDialog() {
        let property = this._executionProps[ConstInterface.REQ_SKIP_AUTHENTICATION];
        return !NString.IsNullOrEmpty(property) && property === true.toString();
    }
    GetFirstHttpRequestTimeout() {
        let firstHttpTimeout = this._executionProps.FirstHTTPRequestTimeout;
        return ((firstHttpTimeout > 0) ? (firstHttpTimeout * 1000) : HttpManager.DEFAULT_OFFLINE_HTTP_COMMUNICATION_TIMEOUT);
    }
    GetExecutionProperty(propName) {
        let ret = this._executionProps[propName];
        return typeof ret === "undefined" ? null : ret;
    }
    getServerURL() {
        if (this._serverUrl === null) {
            let httpReq = ServerConfig.Instance.getHttpReq();
            if (httpReq !== null && httpReq.toLowerCase().startsWith("http"))
                this._serverUrl = httpReq;
            else
                this._serverUrl = ServerConfig.Instance.getProtocol() + "://" + ServerConfig.Instance.getServer() + "/" + ServerConfig.Instance.getHttpReq();
        }
        return this._serverUrl;
    }
    IsLogonRTL() {
        let text = ServerConfig.Instance.GetExecutionProperty[GuiConstants.STR_LOGON_RTL];
        return text !== null && typeof text !== "undefined" && text === "Y";
    }
}
ServerConfig.Instance = new ServerConfig();

class ServerError extends ApplicationException {
    constructor(msg, codeOrInnerException) {
        super(msg);
        this._code = 0;
        if (arguments.length === 1 || isNullOrUndefined(codeOrInnerException))
            return;
        if (typeof codeOrInnerException == 'number')
            this._code = codeOrInnerException;
        else
            this.InnerException = codeOrInnerException;
        this.errorLevel = 3;
    }
    GetCode() {
        return this._code;
    }
    GetMessage() {
        let message;
        let shouldDisplayGenericError = ServerConfig.Instance.ShouldDisplayGenericError();
        if (shouldDisplayGenericError && this.GetCode() > 0) {
            let genericErrorMessage = AccessHelper.languageData.getConstMessage(MsgInterface.STR_GENERIC_ERROR_MESSAGE);
            genericErrorMessage = StrUtil.replaceStringTokens(genericErrorMessage, "%d", 1, "{0}");
            message = NString.Format(genericErrorMessage, this.GetCode());
        }
        else
            message = this.Message;
        return message;
    }
}
ServerError.INF_NO_RESULT = -11;
ServerError.ERR_CTX_NOT_FOUND = -197;
ServerError.ERR_AUTHENTICATION = -157;
ServerError.ERR_ACCESS_DENIED = -133;
ServerError.ERR_WEBCLIENT_PROGRAM_RELOADED = -278;
ServerError.ERR_EXECUTED_PROGRAM_CHANGED = -283;
ServerError.ERR_THREAD_ABORTED = -138;

class HttpUtility {
    static ASCIIGetString(bytes) {
        return Encoding.ASCII.GetString(bytes, 0, bytes.length);
    }
    static IntToHexCharCode(n) {
        if (n <= 9)
            return n + 0x30;
        return (n - 10) + 0X61;
    }
    static IsSafe(ch) {
        if ((ch >= 'a' && ch <= 'z') ||
            (ch >= 'A' && ch <= 'Z') ||
            (ch >= '0' && ch <= '9'))
            return true;
        switch (ch) {
            case '\'':
            case '(':
            case ')':
            case '*':
            case '-':
            case '.':
            case '_':
            case '!':
                return true;
        }
        return false;
    }
    static UrlEncode(str, e) {
        let encodedStr = null;
        if (str !== null) {
            encodedStr = HttpUtility.ASCIIGetString(HttpUtility.UrlEncodeToBytes(str, e));
            Logger.Instance.WriteServerMessagesToLog(NString.Format("\n String: {0} \n UrlEncoded by: {1} \n To: {2}", str, e, encodedStr));
        }
        return encodedStr;
    }
    static UrlEncodeToBytes(str, e) {
        if (str === null) {
            return null;
        }
        let bytes = e.GetBytes(str);
        return HttpUtility.UrlEncodeBytesToBytesInternal(bytes, 0, bytes.length);
    }
    static UrlEncodeBytesToBytesInternal(bytes, offset, count) {
        if (!HttpUtility.EncodingEnabled) {
            return bytes;
        }
        let num = 0;
        let num2 = 0;
        for (let i = 0; i < count; i++) {
            let ch = String.fromCharCode(bytes[offset + i]);
            if (ch === ' ') {
                num = num++;
            }
            else if (!HttpUtility.IsSafe(ch)) {
                num2 = num2 + 1;
            }
        }
        if (num === 0 && num2 === 0) {
            return bytes;
        }
        let buffer = new Uint8Array(count + num2 * 2);
        let num4 = 0;
        for (let j = 0; j < count; j++) {
            let num6 = bytes[offset + j];
            let ch = String.fromCharCode(num6);
            if (HttpUtility.IsSafe(ch)) {
                buffer[num4++] = num6;
            }
            else if (ch === ' ') {
                buffer[num4++] = 0X2b;
            }
            else {
                buffer[num4++] = 0X25;
                buffer[num4++] = HttpUtility.IntToHexCharCode(num6 >> 4 & 15);
                buffer[num4++] = HttpUtility.IntToHexCharCode(num6 & 15);
            }
        }
        return buffer;
    }
}
HttpUtility.EncodingEnabled = true;

class MGDataCollection {
    constructor() {
        this._mgDataTab = new List();
        this._iteratorMgdIdx = 0;
        this._iteratorTaskIdx = 0;
        this.currMgdID = 0;
        this.StartupMgData = null;
        this._lastRouteSentToServer = "";
    }
    GetTaskByID(id) {
        let task = null;
        for (let i = 0; i < this.getSize() && task == null; i++) {
            let mgd = this.getMGData(i);
            if (mgd == null)
                continue;
            task = mgd.getTask(id);
        }
        return task;
    }
    static get Instance() {
        if (MGDataCollection._instance == null) {
            if (MGDataCollection._instance == null)
                MGDataCollection._instance = new MGDataCollection();
        }
        return MGDataCollection._instance;
    }
    async addMGData(mgd, idx, isStartup) {
        if (idx < 0 || idx > this.getSize())
            throw new ApplicationException("Illegal MGData requested");
        if (isStartup)
            this.StartupMgData = mgd;
        if (idx === this.getSize())
            this._mgDataTab.push(mgd);
        else {
            let oldMgd = this.getMGData(idx);
            if (oldMgd != null && !oldMgd.IsAborting) {
                await oldMgd.getFirstTask().stop();
                oldMgd.abort();
            }
            this._mgDataTab.set_Item(idx, mgd);
        }
    }
    getMGData(idx) {
        let mgd = null;
        if (idx >= 0 && idx < this.getSize()) {
            mgd = this._mgDataTab.get_Item(idx);
        }
        return mgd;
    }
    getAvailableIdx() {
        let i;
        for (i = 0; i < this._mgDataTab.length; i = i + 1) {
            if (this._mgDataTab.get_Item(i) === null)
                break;
        }
        return i;
    }
    getMgDataIdx(mgd) {
        return this._mgDataTab.indexOf(mgd);
    }
    deleteMGDataTree(index) {
        let mgd, childMgd;
        let i;
        if (index < 0 || index >= this.getSize())
            throw new ApplicationException("in deleteMGData() illegal index: " + index);
        mgd = this.getMGData(index);
        if (mgd != null) {
            if (index > 0 && mgd.getParentMGdata() != null) {
                this._mgDataTab.set_Item(index, null);
            }
            LastFocusedManager.Instance.clean(index);
            for (i = 0; i < this.getSize(); i++) {
                childMgd = this.getMGData(i);
                if (childMgd != null && childMgd.getParentMGdata() === mgd)
                    this.deleteMGDataTree(i);
            }
        }
    }
    getCurrMGData() {
        return this.getMGData(this.currMgdID);
    }
    GetMainProgByCtlIdx(contextIDOrCtlIdx, ctlIdx) {
        if (arguments.length === 2)
            return this.GetMainProgByCtlIdx_0(ctlIdx);
        else
            return this.GetMainProgByCtlIdx_1(contextIDOrCtlIdx);
    }
    GetMainProgByCtlIdx_0(ctlIdx) {
        let task = null;
        for (let i = 0; i < this.getSize() && task == null; i++) {
            let mgd = this.getMGData(i);
            if (mgd == null)
                continue;
            task = mgd.getMainProg(ctlIdx);
        }
        return task;
    }
    GetMainProgByCtlIdx_1(ctlIdx) {
        return this.GetMainProgByCtlIdx(-1, ctlIdx);
    }
    startTasksIteration() {
        this._iteratorMgdIdx = 0;
        this._iteratorTaskIdx = 0;
    }
    getNextTask() {
        let task;
        let mgd = this.getMGData(this._iteratorMgdIdx);
        if (mgd == null)
            return null;
        task = mgd.getTask(this._iteratorTaskIdx);
        if (task == null) {
            do {
                this._iteratorMgdIdx++;
            } while (this._iteratorMgdIdx < this.getSize() && this.getMGData(this._iteratorMgdIdx) == null);
            this._iteratorTaskIdx = 0;
            return this.getNextTask();
        }
        this._iteratorTaskIdx++;
        return task;
    }
    async buildXML(message, serializeTasks) {
        let lastRoute = Commands.getLastRoute();
        if (lastRoute !== this._lastRouteSentToServer) {
            message.Append(XMLConstants.START_TAG + ConstInterface.MG_TAG_LAST_ROUTE);
            message.Append(" " + ConstInterface.MG_ATTR_ENV_VALUE + "=\"" + lastRoute + "\"");
            message.Append(XMLConstants.TAG_TERM);
            this._lastRouteSentToServer = lastRoute;
        }
        for (let i = 0; i < this.getSize(); i = i + 1) {
            let mgd = this.getMGData(i);
            if (mgd !== null && !mgd.IsAborting) {
                await mgd.buildXML(message, serializeTasks);
            }
        }
        FlowMonitorQueue.Instance.buildXML(message);
    }
    getSize() {
        return this._mgDataTab.length;
    }
    async processRecovery() {
        for (let i = 0; i < this.getSize(); i = i + 1) {
            let mgd = this.getMGData(i);
            if (mgd !== null) {
                for (let j = 0; j < mgd.getTasksCount(); j = j + 1) {
                    let task = mgd.getTask(j);
                    if (task !== null)
                        await task.DataView.processRecovery();
                }
            }
        }
    }
    getTriggeredTasks(triggeringTask) {
        let list = new List();
        let task;
        let tag = triggeringTask.getTaskTag();
        this.startTasksIteration();
        while ((task = this.getNextTask()) !== null) {
            if (tag === task.PreviouslyActiveTaskId)
                list.push(task);
        }
        return list;
    }
    GetTasks(p) {
        let taskList = new List();
        this._mgDataTab.forEach(mgd => {
            if (mgd !== null && !mgd.IsAborting) {
                for (let i = 0; i < mgd.getTasksCount(); i = i + 1) {
                    let task = mgd.getTask(i);
                    if (task !== null && p(task)) {
                        taskList.push(task);
                    }
                }
            }
        });
        return taskList;
    }
    getTaskIdById(taskId) {
        let task = this.GetTaskByID(taskId);
        let tag = taskId;
        if (task != null)
            tag = task.getTaskTag();
        return tag;
    }
    GetTopMostForms() {
        let task;
        let forms = new List();
        this.startTasksIteration();
        while ((task = this.getNextTask()) != null) {
            let form = task.getForm();
            if (!task.isAborting() && form != null && !form.isSubForm())
                forms.push(form);
        }
        return forms;
    }
    GetMGDataForStartupProgram() {
        Debug.Assert(this._mgDataTab.length > 0, "The main program must be processed before invoking this method.");
        let mainProgByCtlIdx = this.GetMainProgByCtlIdx(0);
        Debug.Assert(mainProgByCtlIdx !== null, "The main program must be processed before invoking this method.");
        Debug.Assert(mainProgByCtlIdx.getMgdID() === 0, "Main program is expected to be on MGData 0. Is this an error?");
        return this._mgDataTab.get_Item(0);
    }
    async execRequestWithSubformRecordCycle(cmdsToServer, cmdToServer, exp) {
        this.cleanDoSubformPrefixSuffix();
        cmdsToServer.Add(cmdToServer);
        if (!(MGDataCollection.Instance.StartupMgData.getFirstTask().InEndTask && MGDataCollection.Instance.StartupMgData.getFirstTask().ClosingFormUI))
            await CommandsProcessorManager.GetCommandsProcessor().Execute(CommandsProcessorBase_SendingInstruction.TASKS_AND_COMMANDS, CommandsProcessorBase_SessionStage.NORMAL, exp);
        await this.execAllSubformRecordCycle();
    }
    cleanDoSubformPrefixSuffix() {
        for (let i = 0; i < this.getSize(); i++) {
            let mgd = this.getMGData(i);
            if (mgd === null || mgd.IsAborting)
                continue;
            let tasksCount = mgd.getTasksCount();
            for (let j = 0; j < tasksCount; j++) {
                let task = mgd.getTask(j);
                task.DoSubformPrefixSuffix = false;
            }
        }
    }
    async execAllSubformRecordCycle() {
        for (let i = 0; i < this.getSize(); i = i + 1) {
            let mgd = this.getMGData(i);
            if (mgd === null || mgd.IsAborting)
                continue;
            let tasksCount = mgd.getTasksCount();
            for (let j = 0; j < tasksCount; j = j + 1) {
                let task = mgd.getTask(j);
                if (task.IsSubForm && task.DoSubformPrefixSuffix) {
                    task.PerformParentRecordPrefix = false;
                    AccessHelper.eventsManager.pushNewExecStacks();
                    await AccessHelper.eventsManager.handleInternalEventWithTaskAndSubformRefresh(task, InternalInterface.MG_ACT_REC_PREFIX, true);
                    if (!AccessHelper.eventsManager.GetStopExecutionFlag())
                        await AccessHelper.eventsManager.handleInternalEventWithTask(task, InternalInterface.MG_ACT_REC_SUFFIX);
                    AccessHelper.eventsManager.popNewExecStacks();
                    task.PerformParentRecordPrefix = true;
                }
            }
        }
    }
}
MGDataCollection._instance = null;

var RequestStatus;
(function (RequestStatus) {
    RequestStatus[RequestStatus["Handled"] = 0] = "Handled";
    RequestStatus[RequestStatus["Retry"] = 1] = "Retry";
    RequestStatus[RequestStatus["Abort"] = 2] = "Abort";
})(RequestStatus || (RequestStatus = {}));
class RemoteCommandsProcessor extends CommandsProcessorBase {
    static GetInstance() {
        if (RemoteCommandsProcessor._instance === null) {
            RemoteCommandsProcessor._instance = new RemoteCommandsProcessor();
        }
        return RemoteCommandsProcessor._instance;
    }
    constructor() {
        super();
        this._lastRequestTime = 0;
        this.ServerUrl = null;
        this.DelayCommandExecution = false;
        this._requestInfo = new RequestInfo();
        this.ServerUrl = ServerConfig.Instance.getServerURL();
        HttpManager.GetInstance();
        this.RegisterDelegates();
    }
    CheckAndSetSessionCounter(newSessionCounter) {
        if (newSessionCounter === ConstInterface.SESSION_COUNTER_CLOSE_CTX_INDICATION) {
            Debug.Assert(this.GetSessionCounter() === ConstInterface.SESSION_COUNTER_CLOSE_CTX_INDICATION);
        }
        else {
            Debug.Assert(newSessionCounter === this.GetSessionCounter() + 1);
            this.SetSessionCounter(newSessionCounter);
            Logger.Instance.WriteServerToLog(NString.Format("Session Counter --> {0}", this._sessionCounter));
        }
    }
    ClearSessionCounter() {
        this._sessionCounter = 0;
        Logger.Instance.WriteServerToLog(NString.Format("Session Counter --> {0}", this._sessionCounter));
    }
    SetSessionCounter(newSessionCounter) {
        this._sessionCounter = newSessionCounter;
    }
    get GetLastRequestTime() {
        return this._lastRequestTime;
    }
    async ReStartSession() {
        RemoteCommandsProcessor.IsSessionReInitializing = true;
        await this.StoreSessionReInitializingDataOnLocalStorage();
        let navigateRootRoute = false;
        if (!RuntimeContextBase.Instance.RemovedContextFromServer)
            navigateRootRoute = Environment.Instance.getSpecialRouteToRootProgOnContextRecreation() ? true : false;
        Commands.addRefreshPage(navigateRootRoute, RemoteCommandsProcessor.InitialUrl);
        throw new Exception('');
    }
    async StoreSessionReInitializingDataOnLocalStorage() {
        let mainPrgViewStringForServer = await this.BuildXMLForMainProgramDataView();
        let globalParamsString = AccessHelper.globalParams.mirrorAllToXML();
        let changedEnvVarList = AccessHelper.envParamsTable.mirrorAllToXML();
        let dataStorage = window.localStorage;
        dataStorage.setItem(ConstInterface.IS_SESSION_REINITIALIZING, "true");
        dataStorage.setItem(ConstInterface.MAIN_PROG_VIEW, mainPrgViewStringForServer.toString());
        dataStorage.setItem(ConstInterface.GLOBAL_PARAM_LIST, globalParamsString);
        dataStorage.setItem(ConstInterface.ENV_VAR_LIST, changedEnvVarList);
        dataStorage.setItem(ConstInterface.LAST_EXCEPTION, RemoteCommandsProcessor.lastExceptionMessage);
        if (RuntimeContextBase.Instance.RemovedContextFromServer)
            dataStorage.setItem(ConstInterface.CTX_REMOVED_FROM_SRVR, "1");
        EventsManager.Instance.storeLastSavedRouteEventOnLocalStorage();
    }
    RestoreSessionReInitializingDataFromLocalStorage(key) {
        let dataStorage = window.localStorage;
        let val = dataStorage.getItem(key);
        return val;
    }
    async StartSession() {
        let authenticationCancelled = false;
        let handshakeResponse = null;
        try {
            let lastTypedUserId = null;
            let handshakeInitialTokens = new StringBuilder();
            handshakeInitialTokens.Append(ConstInterface.UTF8TRANS +
                ConstInterface.REQ_APP_NAME + "=" +
                HttpUtility.UrlEncode(ServerConfig.Instance.getAppName(), Encoding.UTF8));
            handshakeInitialTokens.Append("&" + ConstInterface.REQ_ARGS + "=" + ConstInterface.REQ_ARG_ALPHA +
                "<Richclient><Requires EncryptionKey=\"False\"/><RIAProtocolVersion=\"" + RemoteCommandsProcessor.WEB_COMMUNICATION_PROTOCOL_VERSION + "\"/></Richclient>");
            Logger.Instance.WriteDevToLog(NString.Format("Handshake request #1 (not scrambled) : {0}", this.ServerUrl + ConstInterface.REQ_ARG_START +
                ConstInterface.RC_INDICATION_INITIAL + handshakeInitialTokens));
            let handshakeInitialUrl = this.ServerUrl + ConstInterface.REQ_ARG_START +
                ConstInterface.RC_INDICATION_INITIAL +
                ConstInterface.RC_TOKEN_DATA +
                HttpUtility.UrlEncode(Scrambler.Scramble(handshakeInitialTokens.ToString()), Encoding.UTF8);
            Logger.Instance.WriteServerMessagesToLog("");
            Logger.Instance.WriteServerMessagesToLog(NString.Format("Handshake request #1: {0}", handshakeInitialUrl));
            let ctxGroup = ServerConfig.Instance.getCtxGroup();
            while (!authenticationCancelled) {
                let requestStatus = new RefParam(RequestStatus.Handled);
                let responseStr = await this.DispatchRequest(handshakeInitialUrl, null, CommandsProcessorBase_SessionStage.HANDSHAKE, requestStatus);
                if (NString.IsNullOrEmpty(responseStr)) {
                    throw new ServerError("Client failed to initialize a session." + OSEnvironment.EolSeq +
                        "Empty response was received from the web server." + OSEnvironment.EolSeq + OSEnvironment.EolSeq + this.ServerUrl);
                }
                Logger.Instance.WriteServerMessagesToLog(NString.Format("Handshake response #1: {0}", responseStr));
                Logger.Instance.WriteServerMessagesToLog("");
                handshakeResponse = new HandshakeResponse(responseStr);
                RuntimeContextBase.Instance.ContextID = handshakeResponse.ContextId;
                this.SessionId = handshakeResponse.GetSessionId;
                HttpManager.GetInstance().HttpCommunicationTimeoutMS = handshakeResponse.HttpTimeout * 1000;
                if (NString.IsNullOrEmpty(ServerConfig.Instance.getCtxGroup())) {
                    ctxGroup = handshakeResponse.ContextId;
                }
                let credentials = null;
                if (ServerConfig.Instance.getSkipAuthenticationDialog()) {
                    if (ServerConfig.Instance.getUsername() !== null) {
                        credentials = new UsernamePasswordCredentials(ServerConfig.Instance.getUsername(), ServerConfig.Instance.getPassword());
                        ServerConfig.Instance.setUsername("");
                        ServerConfig.Instance.setPassword("");
                    }
                }
                else if (handshakeResponse.InputPassword && handshakeResponse.SystemLogin !== HandshakeResponse.SYSTEM_LOGIN_AD) {
                    if (lastTypedUserId !== null) {
                        let title = AccessHelper.languageData.getConstMessage(MsgInterface.BRKTAB_STR_ERROR);
                        let error = AccessHelper.languageData.getConstMessage(MsgInterface.USRINP_STR_BADPASSW);
                        await GUIManager.Instance.MessageBox(title, error, Styles.MSGBOX_ICON_ERROR | Styles.MSGBOX_BUTTON_OK);
                    }
                }
                if (authenticationCancelled) {
                    this.SetSessionCounter(ConstInterface.SESSION_COUNTER_CLOSE_CTX_INDICATION);
                }
                let handshakeAuthUrl = this.PrepareAuthenticationUrl(handshakeResponse.ContextId, ctxGroup, this.GetSessionCounter());
                try {
                    if (credentials !== null) {
                        let credentialsStr = credentials.Username + ":";
                        if (!NString.IsNullOrEmpty(credentials.Password)) {
                            credentialsStr = credentialsStr + credentials.Password + ":";
                        }
                        credentialsStr += handshakeResponse.ContextId;
                        credentialsStr = Scrambler.Scramble(credentialsStr);
                        credentialsStr = Base64.encode(credentialsStr, true, Encoding.UTF8);
                        handshakeAuthUrl += ("&USERNAME=" + HttpUtility.UrlEncode(credentialsStr, Encoding.UTF8));
                        Logger.Instance.WriteServerMessagesToLog(NString.Format("Handshake request #2: {0}", handshakeAuthUrl));
                        let statusRequest = new RefParam(RequestStatus.Handled);
                        responseStr = await this.DispatchRequest(handshakeAuthUrl, null, CommandsProcessorBase_SessionStage.HANDSHAKE, statusRequest);
                        if (responseStr.indexOf(handshakeResponse.ContextId) === -1) {
                            throw new ServerError(AccessHelper.languageData.getConstMessage(MsgInterface.USRINP_STR_BADPASSW));
                        }
                        ServerConfig.Instance.setUsername(credentials.Username);
                        ServerConfig.Instance.setPassword(credentials.Password);
                    }
                    else {
                        let requestStatus = new RefParam(RequestStatus.Handled);
                        Logger.Instance.WriteServerMessagesToLog(NString.Format("Handshake request #2: {0}", handshakeAuthUrl));
                        responseStr = await this.DispatchRequest(handshakeAuthUrl, null, CommandsProcessorBase_SessionStage.HANDSHAKE, requestStatus);
                    }
                    Logger.Instance.WriteServerMessagesToLog(NString.Format("Handshake response #2: {0}", responseStr));
                    Logger.Instance.WriteServerMessagesToLog("");
                    break;
                }
                catch (ex) {
                    if (ex instanceof ServerError) {
                        let serverError = ex;
                        if (ServerConfig.Instance.getSkipAuthenticationDialog()) {
                            switch (serverError.GetCode()) {
                                case ServerError.ERR_ACCESS_DENIED:
                                case ServerError.ERR_AUTHENTICATION:
                                    ServerConfig.Instance.setSkipAuthenticationDialog(false);
                                    throw serverError;
                            }
                        }
                        if (!handshakeResponse.InputPassword)
                            throw serverError;
                        if (serverError.GetCode() !== ServerError.ERR_AUTHENTICATION &&
                            (!authenticationCancelled || serverError.GetCode() !== ServerError.INF_NO_RESULT)) {
                            throw serverError;
                        }
                    }
                    else
                        throw ex;
                }
            }
            ServerConfig.Instance.setSkipAuthenticationDialog(true);
            ServerConfig.Instance.setCtxGroup(ctxGroup);
            RemoteCommandsProcessor.ShouldScrambleAndUnscrambleMessages = handshakeResponse.ScrambleMessages;
            if (Logger.Instance.LogLevel !== Logger_LogLevels.Basic) {
                let maxInternalLogLevel = handshakeResponse.MaxInternalLogLevel;
                if (maxInternalLogLevel !== null) {
                    let maxLogLevel = this.parseLogLevel(maxInternalLogLevel);
                    if (maxLogLevel < Logger.Instance.LogLevel) {
                        ServerConfig.Instance.setInternalLogLevel(maxInternalLogLevel);
                        Logger.Instance.WriteToLog(NString.Format("Internal log level was restricted to '{0}' by the Magic xpa server.", maxInternalLogLevel), false);
                        Logger.Instance.LogLevel = maxLogLevel;
                    }
                }
            }
            if (!authenticationCancelled) {
                await this.ExecuteInitialRequest();
            }
        }
        catch (ex) {
            if (ex instanceof ServerError)
                throw ex;
            if (isNullOrUndefined(ex.InnerException))
                throw new ServerError(ex.message, new Exception(ex));
            else
                throw new ServerError(ex.message, ex.InnerException);
        }
        return !authenticationCancelled;
    }
    PrepareAuthenticationUrl(contextId, ctxGroup, sessionCount) {
        let handshakeAuthUrl = this.ServerUrl + ConstInterface.REQ_ARG_START +
            ConstInterface.RC_INDICATION + ConstInterface.UTF8TRANS +
            ConstInterface.RC_TOKEN_CTX_ID + contextId;
        if (!isNullOrUndefined(this.SessionId))
            handshakeAuthUrl += (ConstInterface.REQ_ARG_SEPARATOR + ConstInterface.RC_TOKEN_SESSION_ID + this.SessionId);
        handshakeAuthUrl += (ConstInterface.REQ_ARG_SEPARATOR +
            ConstInterface.RC_TOKEN_SESSION_COUNT + sessionCount +
            ConstInterface.REQ_ARG_SEPARATOR +
            ConstInterface.RC_TOKEN_CTX_GROUP + ctxGroup +
            ConstInterface.REQ_ARG_SEPARATOR +
            ConstInterface.RC_AUTHENTICATION_REQUEST);
        return handshakeAuthUrl;
    }
    async ExecuteInitialRequest() {
        await this.Execute_1(CommandsProcessorBase_SendingInstruction.TASKS_AND_COMMANDS, CommandsProcessorBase_SessionStage.INITIAL, null);
    }
    GetTaskTree(task) {
        let taskTree = new List();
        while (!isNullOrUndefined(task)) {
            taskTree.push(task.getTaskInfo());
            task = task.getParent();
        }
        return taskTree;
    }
    async UpdateRequestInfo() {
        let currMGData = AccessHelper.mgDataTable.getCurrMGData();
        let eventsManager = AccessHelper.eventsManager;
        let operExecution = false;
        let cmdsToServer = currMGData.CmdsToServer;
        for (let i = 0; i < cmdsToServer.getSize(); i++) {
            if (cmdsToServer.getCmd(i) instanceof ExecOperCommand) {
                let operCmd = currMGData.CmdsToServer.getCmd(i);
                this._requestInfo.serverCallAt = operCmd.getCommandInfo();
                this._requestInfo.runtimeTaskTree = this.GetTaskTree(operCmd.getTask());
                operExecution = true;
                break;
            }
        }
        this._requestInfo.extraInfo.contextID = RuntimeContextBase.Instance.ContextID;
        this._requestInfo.extraInfo.sessionCounter = this.GetSessionCounter();
        if (!operExecution) {
            if (eventsManager.getLastRtEvent() != null && eventsManager.getLastRtEvent().InternalEvent != 0) {
                let rtEvt = eventsManager.getLastRtEvent();
                this._requestInfo.runtimeTaskTree = this.GetTaskTree(rtEvt.getTask());
                let eventDescription = rtEvt.isNewInternalEvent()
                    ? NString.TrimEnd(rtEvt.getNewInternalEventDescription())
                    : Event.getInternalEvtDescription(rtEvt.InternalEvent);
                let cmd = cmdsToServer.getCmd(cmdsToServer.getSize() - 1);
                if (cmd) {
                    let commandInfo = NString.IsNullOrEmpty(cmd.getCommandInfo())
                        ? NString.Empty
                        : cmd.getCommandInfo();
                    if (cmd instanceof EventCommand && rtEvt.InternalEvent == cmd.MagicEvent)
                        eventDescription = NString.Empty;
                    this._requestInfo.serverCallAt = 'Event ' + commandInfo +
                        (!NString.IsNullOrEmpty(eventDescription)
                            ? NString.Format(' while executing [{0}]', eventDescription)
                            : NString.Empty);
                }
            }
        }
    }
    async BuildXMLForMainProgramDataView() {
        let message = new StringBuilder();
        let firstMgData = MGDataCollection.Instance.getMGData(0);
        let mainPrg = firstMgData.getMainProg(0);
        while (mainPrg != null) {
            await mainPrg.buildXML(message);
            mainPrg = firstMgData.getNextMainProg(mainPrg.getCtlIdx());
        }
        if (RemoteCommandsProcessor.ShouldScrambleAndUnscrambleMessages) {
            let scrambledChanges = Scrambler.Scramble(message.ToString());
            message = new StringBuilder(scrambledChanges);
        }
        message.Insert(0, XMLConstants.MG_TAG_OPEN);
        message.Append(XMLConstants.MG_TAG_XML_END_TAGGED);
        return message.ToString();
    }
    async Execute_1(sendingInstruction, sessionStage, res) {
        let reqBuf;
        let isInitialCall = sessionStage === CommandsProcessorBase_SessionStage.INITIAL;
        let globalParamsString = null;
        let envVarsString = null;
        if (this.DelayCommandExecution)
            return;
        if (Logger.Instance.LogLevel == Logger_LogLevels.RequestInfo && !isInitialCall)
            await this.UpdateRequestInfo();
        if (isInitialCall) {
            let val = this.RestoreSessionReInitializingDataFromLocalStorage(ConstInterface.IS_SESSION_REINITIALIZING);
            if (val === 'true') {
                RemoteCommandsProcessor.IsSessionReInitializing = (val === "true") ? true : false;
                RemoteCommandsProcessor.lastExceptionMessage = this.RestoreSessionReInitializingDataFromLocalStorage(ConstInterface.LAST_EXCEPTION);
                let ctxRemoved = this.RestoreSessionReInitializingDataFromLocalStorage(ConstInterface.CTX_REMOVED_FROM_SRVR);
                if (ctxRemoved !== '1') {
                    Logger.Instance.WriteErrorToLog(RemoteCommandsProcessor.lastExceptionMessage);
                    Logger.Instance.WriteToLog("Session is reinitializing...", true);
                }
            }
        }
        if (sendingInstruction === CommandsProcessorBase_SendingInstruction.NO_TASKS_OR_COMMANDS)
            reqBuf = null;
        else {
            reqBuf = await this.PrepareRequest(sendingInstruction === CommandsProcessorBase_SendingInstruction.TASKS_AND_COMMANDS);
            if (RemoteCommandsProcessor.IsSessionReInitializing || !isInitialCall) {
                let changes = new StringBuilder();
                let buffer = new StringBuilder();
                if (!RemoteCommandsProcessor.IsSessionReInitializing)
                    buffer.Append(reqBuf);
                if (RemoteCommandsProcessor.IsSessionReInitializing) {
                    globalParamsString = this.RestoreSessionReInitializingDataFromLocalStorage(ConstInterface.GLOBAL_PARAM_LIST);
                    envVarsString = this.RestoreSessionReInitializingDataFromLocalStorage(ConstInterface.ENV_VAR_LIST);
                }
                else {
                    globalParamsString = AccessHelper.globalParams.mirrorToXML();
                    envVarsString = AccessHelper.envParamsTable.mirrorToXML();
                }
                changes.Append(globalParamsString);
                changes.Append(envVarsString);
                if (changes.Length > 0) {
                    changes.Insert(0, "<" + ConstInterface.MG_TAG_ENV_CHANGES + ">");
                    changes.Append("</" + ConstInterface.MG_TAG_ENV_CHANGES + ">");
                    if (RemoteCommandsProcessor.ShouldScrambleAndUnscrambleMessages) {
                        let scrambledChanges = Scrambler.Scramble(changes.ToString());
                        changes = new StringBuilder(scrambledChanges);
                    }
                    changes.Insert(0, XMLConstants.MG_TAG_OPEN);
                    changes.Append(XMLConstants.MG_TAG_XML_END_TAGGED);
                    buffer.Append(changes.ToString());
                }
                reqBuf = buffer.ToString();
            }
        }
        let requestStatus = new RefParam(RequestStatus.Handled);
        let respBuf = null;
        if (RemoteCommandsProcessor.IsSessionReInitializing) {
            reqBuf = reqBuf + this.RestoreSessionReInitializingDataFromLocalStorage(ConstInterface.MAIN_PROG_VIEW);
        }
        if (RuntimeContextBase.Instance.RemovedContextFromServer)
            requestStatus.value = RequestStatus.Retry;
        else {
            if (RuntimeContextBase.Instance.RemovingContextFromServer)
                RuntimeContextBase.Instance.RemovedContextFromServer = true;
            respBuf = await this.DispatchRequest(this.ServerUrl, reqBuf, sessionStage, requestStatus);
        }
        if (requestStatus.value == RequestStatus.Retry) {
            await this.ReStartSession();
        }
        if (respBuf == null)
            return;
        if (isInitialCall) {
            RemoteCommandsProcessor.InitialUrl = window.location.href;
            if (RemoteCommandsProcessor.IsSessionReInitializing) {
                let dataStorage = window.localStorage;
                dataStorage.removeItem(ConstInterface.IS_SESSION_REINITIALIZING);
                dataStorage.removeItem(ConstInterface.MAIN_PROG_VIEW);
                dataStorage.removeItem(ConstInterface.GLOBAL_PARAM_LIST);
                dataStorage.removeItem(ConstInterface.ENV_VAR_LIST);
                dataStorage.removeItem(ConstInterface.LAST_EXCEPTION);
            }
        }
        FlowMonitorQueue.Instance.enable(false);
        await this.ProcessResponse(respBuf, AccessHelper.mgDataTable.currMgdID, null, res);
        if (RemoteCommandsProcessor.IsSessionReInitializing) {
            AccessHelper.globalParams.RestoreParams(globalParamsString);
            AccessHelper.envParamsTable.RestoreParams(envVarsString);
            let dataStorage = window.localStorage;
            let ctxRemoved = dataStorage.getItem(ConstInterface.CTX_REMOVED_FROM_SRVR);
            if (ctxRemoved === "1") {
                EventsManager.Instance.restoreLastSavedRouteEventFromLocalStorage();
                dataStorage.removeItem(ConstInterface.CTX_REMOVED_FROM_SRVR);
                dataStorage.removeItem(ConstInterface.LAST_ROUTE_EVENT);
                dataStorage.removeItem(ConstInterface.LAST_ROUTE_EVENT_SRC_TSK);
                dataStorage.removeItem(ConstInterface.LAST_ROUTE_EVENT_ARG_LIST);
            }
            RemoteCommandsProcessor.IsSessionReInitializing = false;
        }
        if (sendingInstruction === CommandsProcessorBase_SendingInstruction.TASKS_AND_COMMANDS) {
            AccessHelper.mgDataTable.startTasksIteration();
            let task;
            while ((task = AccessHelper.mgDataTable.getNextTask()) !== null) {
                let dataViewWasRetrieved = task.DataViewWasRetrieved;
                if (dataViewWasRetrieved) {
                    await task.RefreshDisplay();
                }
            }
        }
        if (isInitialCall)
            ServerConfig.Instance.setGlobalParams(null);
    }
    async DispatchRequest(url, reqBuf, sessionStage, requestStatus) {
        let response = null;
        let encodedBody = null;
        requestStatus.value = RequestStatus.Handled;
        if (url === null) {
            Logger.Instance.WriteExceptionToLogWithMsg("in sendMsgToSrvr() unknown server");
            return response;
        }
        if (sessionStage !== CommandsProcessorBase_SessionStage.HANDSHAKE) {
            let urlSuffix = this.BuildUrlSuffix(reqBuf !== null, sessionStage === CommandsProcessorBase_SessionStage.INITIAL);
            let reqBufEncoded = HttpUtility.UrlEncode(reqBuf, Encoding.UTF8);
            encodedBody = urlSuffix + reqBufEncoded;
        }
        try {
            if (Logger.Instance.ShouldLogExtendedServerRelatedMessages())
                Logger.Instance.WriteServerMessagesToLog(NString.Format("MESSAGE TO SERVER:\n URL: {0}\n BODY: {1}", url, encodedBody));
            response = await this.ExecuteRequest(url, encodedBody);
            if (!response.toUpperCase().startsWith("<HTML")) {
                let startIdx = response.indexOf("<xml id=\"MGDATA\">");
                if (startIdx > 0)
                    response = response.substr(startIdx);
            }
            Logger.Instance.WriteServerMessagesToLog("MESSAGE FROM SERVER: " + response);
            if (sessionStage === CommandsProcessorBase_SessionStage.HANDSHAKE ||
                (response.length > 0 &&
                    RemoteCommandsProcessor.ShouldScrambleAndUnscrambleMessages && response !== "<xml id=\"MGDATA\">\n</xml>")) {
                if (sessionStage === CommandsProcessorBase_SessionStage.HANDSHAKE) {
                    Debug.Assert(response.length > 0 && response[0] !== '<');
                }
                response = CommandsProcessorBase.UnScramble(response);
            }
            Logger.Instance.WriteDevToLog("MESSAGE FROM SERVER: (size = " + response.length + ")" + OSEnvironment.EolSeq + response);
            this._lastRequestTime = Misc.getSystemMilliseconds();
        }
        catch (ex) {
            if (ex instanceof ServerError) {
                requestStatus.value = RequestStatus.Abort;
                if (sessionStage == CommandsProcessorBase_SessionStage.NORMAL) {
                    if (ex.GetCode() == ServerError.ERR_CTX_NOT_FOUND || ex.GetCode() == ServerError.ERR_THREAD_ABORTED) {
                        if (RuntimeContextBase.Instance.RemovedContextFromServer) {
                            requestStatus.value = RequestStatus.Retry;
                        }
                        else {
                            switch (Environment.Instance.getWebClientReinitSession()) {
                                case 'Y':
                                    requestStatus.value = RequestStatus.Retry;
                                    break;
                                case 'A':
                                    let retval = await GUIManager.Instance.MessageBox("Error", "Unknown error occurred at server-side." +
                                        " Would you like to reinitialize the session?", Styles.MSGBOX_BUTTON_YES_NO);
                                    requestStatus.value = (retval == Styles.MSGBOX_RESULT_YES) ? RequestStatus.Retry : RequestStatus.Abort;
                                    break;
                                case 'N':
                                default:
                                    requestStatus.value = RequestStatus.Abort;
                                    break;
                            }
                        }
                        if (requestStatus.value == RequestStatus.Abort) {
                            Environment.Instance.setWebClientReinitSession('N');
                            throw ex;
                        }
                        else {
                            let errForConsole = StrUtil.getConsoleErorString(ex.GetMessage());
                            RemoteCommandsProcessor.lastExceptionMessage = "Exception Occured at server side : " + ex.GetCode().toString() + " : " + errForConsole;
                            console.log(RemoteCommandsProcessor.lastExceptionMessage);
                        }
                        return null;
                    }
                }
            }
            this.clearLocalStorage();
            throw ex;
        }
        return response;
    }
    clearLocalStorage() {
        window.localStorage.removeItem(ConstInterface.LAST_ROUTE_EVENT);
        window.localStorage.removeItem(ConstInterface.LAST_ROUTE_EVENT_SRC_TSK);
        window.localStorage.removeItem(ConstInterface.LAST_ROUTE_EVENT_ARG_LIST);
        window.localStorage.removeItem(ConstInterface.IS_SESSION_REINITIALIZING);
        window.localStorage.removeItem(ConstInterface.MAIN_PROG_VIEW);
        window.localStorage.removeItem(ConstInterface.GLOBAL_PARAM_LIST);
        window.localStorage.removeItem(ConstInterface.ENV_VAR_LIST);
        window.localStorage.removeItem(ConstInterface.LAST_EXCEPTION);
        window.localStorage.removeItem(ConstInterface.CTX_REMOVED_FROM_SRVR);
    }
    HandleErrorResponse(response) {
        try {
            Logger.Instance.WriteServerMessagesToLog("MESSAGE FROM SERVER: " + response);
            response = CommandsProcessorBase.UnScramble(response);
            Logger.Instance.WriteServerMessagesToLog("MESSAGE FROM SERVER: " + StrUtil.getConsoleErorString(response));
        }
        catch (ex) {
        }
        if (response.startsWith("<xmlerr")) {
            let errorMessageXml = new ErrorMessageXml(response, this._lastRequestTime, AccessHelper.environment.getContextInactivityTimeout());
            throw new ServerError(errorMessageXml.GetMessage(), errorMessageXml.GetCode());
        }
        else if (response.toUpperCase().startsWith("<HTML")) {
            throw new ServerError(response);
        }
    }
    async ExecuteRequest(url, encodedBody) {
        return await this.GetContent(url, false, encodedBody);
    }
    async GetContent(requestedURL, useCache, requestContent) {
        if (isUndefined(requestContent))
            requestContent = null;
        let responseStr;
        try {
            if (requestedURL.startsWith("/"))
                requestedURL = ServerConfig.Instance.getProtocol() + "://" + ServerConfig.Instance.getServer() + requestedURL;
            var spinnerTimer = timer(50, 50);
            var spinnerTimerSubscription = spinnerTimer.subscribe(() => {
                AccessHelper.eventsManager.CheckAndShowSpinner(true);
            });
            let isError = new RefParam(false);
            responseStr = await HttpManager.GetInstance().GetContent(requestedURL, requestContent, useCache, isError);
            spinnerTimerSubscription.unsubscribe();
            spinnerTimerSubscription = null;
            if (isError.value) {
                this.HandleErrorResponse(responseStr);
            }
        }
        catch (ex) {
            if (!(ex instanceof ServerError) || Logger.Instance.LogLevel !== Logger_LogLevels.Basic) {
                Logger.Instance.WriteExceptionToLog(ex, NString.Format("requested URL = \"{0}\"", requestedURL));
            }
            if (!(ex instanceof ServerError)) {
                ex = new ServerError(ex.Message, ex.InnerException ? ex.InnerException : ex);
            }
            throw ex;
        }
        finally {
            if (spinnerTimerSubscription != null)
                spinnerTimerSubscription.unsubscribe();
        }
        return responseStr;
    }
    ClientActivated() {
    }
    BuildUrlSuffix(hasContent, isInitialCall) {
        let prefix = ConstInterface.RC_INDICATION + ConstInterface.RC_TOKEN_CTX_ID + RuntimeContextBase.Instance.ContextID;
        if (!isNullOrUndefined(this.SessionId))
            prefix += (ConstInterface.REQ_ARG_SEPARATOR + ConstInterface.RC_TOKEN_SESSION_ID + this.SessionId);
        if (isInitialCall) {
            if (RemoteCommandsProcessor.IsSessionReInitializing)
                prefix += (ConstInterface.REQ_ARG_SEPARATOR + ConstInterface.WEBCLIENT_REINITIALIZE_REQUEST);
            let globalParams = ServerConfig.Instance.getGlobalParams();
            if (globalParams !== null) {
                globalParams = NString.Replace(globalParams, "+", "%2B");
                prefix += ("&" + ConstInterface.MG_TAG_GLOBALPARAMS + "=" + globalParams);
            }
        }
        if (hasContent) {
            prefix += ("&" + ConstInterface.RC_TOKEN_SESSION_COUNT + this.GetSessionCounter() +
                ConstInterface.REQ_ARG_SEPARATOR + ConstInterface.RC_TOKEN_DATA);
        }
        return prefix;
    }
    async SendMonitorOnly() {
        let flowMonitor = FlowMonitorQueue.Instance;
        if (AccessHelper.mgDataTable == null || AccessHelper.mgDataTable.getMGData(0) == null || AccessHelper.mgDataTable.getMGData(0).IsAborting)
            return;
        if (!flowMonitor.isEmpty()) {
            let buffer = this.BuildMonitorMessage();
            let shouldAccumulateClientLog = false;
            if (shouldAccumulateClientLog) {
            }
            else {
                try {
                    let requestStatus = new RefParam(RequestStatus.Handled);
                    await this.DispatchRequest(this.ServerUrl, buffer.ToString(), CommandsProcessorBase_SessionStage.NORMAL, requestStatus);
                }
                catch (err) {
                }
            }
        }
    }
    BuildMonitorMessage() {
        let buffer = new StringBuilder(1000);
        let flowMonitor = FlowMonitorQueue.Instance;
        if (!RemoteCommandsProcessor.ShouldScrambleAndUnscrambleMessages) {
            buffer.Append(XMLConstants.MG_TAG_OPEN);
            flowMonitor.buildXML(buffer);
        }
        else {
            flowMonitor.buildXML(buffer);
            let scrambledOut = Scrambler.Scramble(buffer.ToString());
            buffer = new StringBuilder(1000);
            buffer.Append(XMLConstants.MG_TAG_OPEN + scrambledOut);
        }
        buffer.Append("</" + XMLConstants.MG_TAG_XML + XMLConstants.TAG_CLOSE);
        return buffer;
    }
    RegisterDelegates() {
        HttpClientEvents.GetSessionCounter_Event = this.GetSessionCounter.bind(this);
        HttpClientEvents.CheckAndSetSessionCounter_Event = this.CheckAndSetSessionCounter.bind(this);
        HttpClientEvents.ComputeAndLogRequestInfo_Event = this.ComputeAndLogRequestInfo.bind(this);
        AccessHelper.eventsManager.SpinnerStopped.subscribe(clientBusyTime => this.ClientActivated());
    }
    ComputeAndLogRequestInfo(contentLength, roundTrip, isLoggingResponse) {
        if (!isNullOrUndefined(this._requestInfo.serverCallAt)) {
            this._requestInfo.extraInfo.contentLength = contentLength;
            this._requestInfo.extraInfo.timeStamp = new Date().toString();
            let extraMessageStr = isLoggingResponse ? 'Response ⤵' : 'Request ⤵';
            if (isLoggingResponse) {
                this._requestInfo.roundtripTime = roundTrip;
            }
            Logger.Instance.WriteRequestInfoToLog(this._requestInfo, extraMessageStr);
            if (isLoggingResponse)
                this._requestInfo.clear();
        }
    }
    static set ShouldScrambleAndUnscrambleMessages(value) {
        RemoteCommandsProcessor._shouldScrambleAndUnscrambleMessages = value;
        Logger.Instance.WriteServerMessagesToLog(NString.Format("ShouldScrambleAndUnscrambleMessages.Set: {0}", this._shouldScrambleAndUnscrambleMessages));
    }
    static get ShouldScrambleAndUnscrambleMessages() {
        Logger.Instance.WriteServerMessagesToLog(NString.Format("ShouldScrambleAndUnscrambleMessages.Get: {0}", this._shouldScrambleAndUnscrambleMessages));
        return RemoteCommandsProcessor._shouldScrambleAndUnscrambleMessages;
    }
    parseLogLevel(strLogLevel) {
        let logLevel = Logger_LogLevels.None;
        if (!NString.IsNullOrEmpty(strLogLevel)) {
            if (strLogLevel.toUpperCase().startsWith("SERVER"))
                logLevel = strLogLevel.endsWith("#") ? Logger_LogLevels.ServerMessages : Logger_LogLevels.Server;
            else if (strLogLevel.toUpperCase().startsWith("S") || strLogLevel.toUpperCase().startsWith("Q"))
                logLevel = Logger_LogLevels.Support;
            else if (strLogLevel.toUpperCase().startsWith("G"))
                logLevel = Logger_LogLevels.Gui;
            else if (strLogLevel.toUpperCase().startsWith("D"))
                logLevel = Logger_LogLevels.Development;
            else if (strLogLevel.toUpperCase().startsWith("B"))
                logLevel = Logger_LogLevels.Basic;
            else if (strLogLevel.toUpperCase().startsWith("R"))
                logLevel = Logger_LogLevels.RequestInfo;
        }
        return logLevel;
    }
    async PrepareRequest(serializeTasks) {
        let xmlBuf = new StringBuilder();
        xmlBuf.Append(XMLConstants.MG_TAG_OPEN);
        if (AccessHelper.mgDataTable.getCurrMGData() !== null) {
            let xmlUnscrambled = new StringBuilder();
            await AccessHelper.mgDataTable.buildXML(xmlUnscrambled, serializeTasks);
            if (RemoteCommandsProcessor.ShouldScrambleAndUnscrambleMessages)
                xmlBuf.Append(Scrambler.Scramble(xmlUnscrambled.ToString()));
            else
                xmlBuf.Append(xmlUnscrambled.ToString());
        }
        xmlBuf.Append("</" + XMLConstants.MG_TAG_XML + XMLConstants.TAG_CLOSE);
        return xmlBuf.ToString();
    }
    async ProcessResponse(response, currMgdID, openingTaskDetails, res) {
        Logger.Instance.WriteDevToLog("<-- ProcessResponse started -->");
        if (openingTaskDetails === null)
            openingTaskDetails = new OpeningTaskDetails();
        let systemMilliseconds = Misc.getSystemMilliseconds();
        if (response === null || response.trim().length === 0)
            return;
        AccessHelper.mgDataTable.currMgdID = currMgdID;
        RuntimeContextBase.Instance.Parser.push();
        RuntimeContextBase.Instance.Parser.setXMLdata(response);
        RuntimeContextBase.Instance.Parser.setCurrIndex(0);
        let currMGData = AccessHelper.mgDataTable.getCurrMGData();
        await currMGData.fillData(openingTaskDetails, RuntimeContextBase.Instance.Parser);
        RuntimeContextBase.Instance.Parser.setXMLdata(null);
        RuntimeContextBase.Instance.Parser.pop();
        Logger.Instance.WriteDevToLog("<-- ProcessResponse finished --> (" + (Misc.getSystemMilliseconds() - systemMilliseconds) + ")");
        await currMGData.CmdsToClient.Execute(res);
        await this.ProcessRecovery();
    }
    async ProcessRecovery() {
        AccessHelper.eventsManager.pushNewExecStacks();
        await AccessHelper.mgDataTable.processRecovery();
        AccessHelper.eventsManager.popNewExecStacks();
    }
}
RemoteCommandsProcessor.RC_NO_CONTEXT_ID = '-1';
RemoteCommandsProcessor._instance = null;
RemoteCommandsProcessor.IsSessionReInitializing = false;
RemoteCommandsProcessor.lastExceptionMessage = null;
RemoteCommandsProcessor.InitialUrl = null;
RemoteCommandsProcessor.WEB_COMMUNICATION_PROTOCOL_VERSION = "14002";
RemoteCommandsProcessor._shouldScrambleAndUnscrambleMessages = false;
class HandshakeResponse {
    get ScrambleMessages() {
        return this._scrambleMessages;
    }
    get ContextId() {
        return this._contextId;
    }
    get GetSessionId() {
        return this._privateSessionId;
    }
    get InputPassword() {
        return this._inputPassword;
    }
    get HttpTimeout() {
        return this._httpTimeout;
    }
    get SystemLogin() {
        return this._systemLogin;
    }
    get MaxInternalLogLevel() {
        return this._maxInternalLogLevel;
    }
    constructor(responseXML) {
        this._scrambleMessages = true;
        this._contextId = null;
        this._privateSessionId = null;
        this._inputPassword = false;
        this._httpTimeout = 0;
        this._systemLogin = null;
        this._maxInternalLogLevel = null;
        try {
            JSON_Utils.JSONFromXML(responseXML, this.FillFromJSON.bind(this));
        }
        catch (ex) {
            Logger.Instance.WriteExceptionToLog(ex, responseXML);
        }
    }
    FillFromJSON(error, result) {
        if (error != null) {
            throw error;
        }
        let response = result['Richclientresponse'];
        for (let elementName in response) {
            if (response.hasOwnProperty(elementName)) {
                switch (elementName) {
                    case "ContextID":
                        this._contextId = response[elementName][0];
                        break;
                    case "SessionID":
                        this._privateSessionId = response[elementName][0];
                        break;
                    case "Environment":
                        let envAttributes = response["Environment"][0]['$'];
                        if (!isNullOrUndefined(envAttributes["ScrambleMessages"])) {
                            Debug.Assert(envAttributes["ScrambleMessages"] === "N");
                            this._scrambleMessages = false;
                        }
                        if (!isNullOrUndefined(envAttributes["MaxInternalLogLevel"]))
                            this._maxInternalLogLevel = envAttributes["MaxInternalLogLevel"];
                        if (!isNullOrUndefined(envAttributes["InputPassword"]) && envAttributes["InputPassword"].toLocaleLowerCase() === "y")
                            this._inputPassword = true;
                        if (!isNullOrUndefined(envAttributes["SystemLogin"]))
                            this._systemLogin = envAttributes["SystemLogin"];
                        if (!isNullOrUndefined(envAttributes[ConstInterface.MG_TAG_HTTP_COMMUNICATION_TIMEOUT]))
                            this._httpTimeout = +envAttributes[ConstInterface.MG_TAG_HTTP_COMMUNICATION_TIMEOUT];
                        if (!isNullOrUndefined(envAttributes["ForwardSlash"]))
                            AccessHelper.environment.ForwardSlashUsage = envAttributes["ForwardSlash"];
                        break;
                }
            }
        }
    }
}
HandshakeResponse.SYSTEM_LOGIN_AD = 'D';
class ErrorMessageXml {
    constructor(xmlContent, lastRequestTime, contextInactivityTimeout) {
        this._lastRequestTime = 0;
        this._errorMessage = null;
        this._errorCode = 0;
        this._middlewareAddress = null;
        this._parsingFailed = false;
        this._lastRequestTime = lastRequestTime;
        this.contextInactivityTimeout = contextInactivityTimeout;
        try {
            JSON_Utils.JSONFromXML(xmlContent, this.FillFromJSON.bind(this));
        }
        catch (ex) {
            Logger.Instance.WriteExceptionToLog(ex);
            Misc.WriteStackTrace(ex);
            this._parsingFailed = true;
        }
    }
    FillFromJSON(error, result) {
        if (error != null) {
            throw error;
        }
        let xmlerr = result['xmlerr'];
        for (let elementName in xmlerr) {
            if (xmlerr.hasOwnProperty(elementName)) {
                switch (elementName) {
                    case "errmsg":
                        this._errorMessage = xmlerr[elementName][0];
                        break;
                    case "errcode":
                        this._errorCode = +(xmlerr[elementName]);
                        break;
                    case "server":
                        this._middlewareAddress = xmlerr[elementName][0];
                        break;
                    case "appname":
                    case "prgname":
                    case "arguments":
                    case "username":
                    case "xmlerr":
                        break;
                    default:
                        Logger.Instance.WriteExceptionToLogWithMsg(NString.Format("Unknown element: '{0}'", elementName));
                        break;
                }
            }
        }
    }
    GetCode() {
        return this._errorCode;
    }
    GetMessage() {
        let sb = new StringBuilder();
        if (this._parsingFailed) {
            sb.Append(AccessHelper.languageData.getConstMessage(MsgInterface.RC_STR_F7_UNEXPECTED_ERR));
        }
        else {
            switch (this._errorCode) {
                case ServerError.ERR_CTX_NOT_FOUND:
                    if (this.InactivityTimeoutExpired())
                        sb.Append(NString.Format("{0} ({1} {2})", AccessHelper.languageData.getConstMessage(MsgInterface.STR_ERR_SESSION_CLOSED_INACTIVITY), Math.floor(this.contextInactivityTimeout / 600), AccessHelper.languageData.getConstMessage(MsgInterface.STR_MINUTES)));
                    else
                        sb.Append(NString.Format("{0} ({1}).", AccessHelper.languageData.getConstMessage(MsgInterface.STR_ERR_SESSION_CLOSED), this._errorCode));
                    break;
                case ServerError.ERR_WEBCLIENT_PROGRAM_RELOADED:
                    sb.Append(AccessHelper.languageData.getConstMessage(MsgInterface.STR_ERR_WEBCLIENT_PROGRAM_RELOADED));
                    break;
                case ServerError.ERR_EXECUTED_PROGRAM_CHANGED:
                    sb.Append(AccessHelper.languageData.getConstMessage(MsgInterface.STR_ERR_EXECUTED_PROGRAM_CHANGED));
                    break;
                case ServerError.ERR_AUTHENTICATION:
                    sb.Append(AccessHelper.languageData.getConstMessage(MsgInterface.USRINP_STR_BADPASSW));
                    break;
                case ServerError.ERR_ACCESS_DENIED:
                    sb.Append(AccessHelper.languageData.getConstMessage(MsgInterface.STR_ERR_AUTHORIZATION_FAILURE));
                    break;
                default:
                    sb.Append(this._errorMessage);
                    break;
            }
            sb.Append(OSEnvironment.EolSeq + OSEnvironment.EolSeq);
            if (!ServerConfig.Instance.ShouldDisplayGenericError()) {
                sb.Append(AccessHelper.languageData.getConstMessage(MsgInterface.BROWSER_OPT_INFO_SERVER_STR) + ":   ");
                sb.Append(ServerConfig.Instance.getServer());
                if (!NString.IsNullOrEmpty(this._middlewareAddress)) {
                    sb.Append(" --> ");
                    sb.Append(this._middlewareAddress);
                }
                sb.Append(OSEnvironment.EolSeq);
            }
            sb.Append(AccessHelper.languageData.getConstMessage(MsgInterface.TASKRULE_STR_APPLICATION) + ":   \"");
            sb.Append(ServerConfig.Instance.getAppName());
            sb.Append("\" (\"");
            sb.Append("\")");
        }
        return sb.ToString();
    }
    InactivityTimeoutExpired() {
        let expired = false;
        if (this.contextInactivityTimeout > 0) {
            let currTimeMilli = Misc.getSystemMilliseconds();
            expired = ((currTimeMilli - this._lastRequestTime) > (this.contextInactivityTimeout * 100));
        }
        return expired;
    }
}

class InteractiveCommunicationsFailureHandler {
    constructor() {
        this.ShouldRetryLastRequest = false;
    }
    get ShowCommunicationErrors() {
        return true;
    }
    async CommunicationFailed(url, ex) {
        let exceptionCaption = "";
        let exceptionMessage = url.split('?')[0] + OSEnvironment.EolSeq + OSEnvironment.EolSeq + ex.message + OSEnvironment.EolSeq + OSEnvironment.EolSeq;
        this.ShouldRetryLastRequest = (await GUIManager.Instance.MessageBox(exceptionCaption, exceptionMessage + "Do you wish to retry connecting?", Styles.MSGBOX_BUTTON_YES_NO) === Styles.MSGBOX_RESULT_YES);
    }
}

class CommandsProcessorManager {
    static GetCommandsProcessor() {
        return RemoteCommandsProcessor.GetInstance();
    }
    static async GetContent(requestedURL, useCache) {
        let ret = await (CommandsProcessorManager.GetCommandsProcessor().GetContent(requestedURL, useCache));
        return ret;
    }
    static async StartSession() {
        let succeeded = false;
        try {
            HttpManager.GetInstance().SetCommunicationsFailureHandler(new InteractiveCommunicationsFailureHandler());
            succeeded = await RemoteCommandsProcessor.GetInstance().StartSession();
        }
        catch (ex) {
            Logger.Instance.WriteServerToLog("Failed connecting to the server: " + StrUtil.getConsoleErorString(ex.Message));
            throw ex;
        }
        return succeeded;
    }
}

const MLS_EOF_CHARS_TO_READ = 10;
const START_TAG = "<ErrorCodes>";
const END_TAG = "</ErrorCodes>";
class LanguageData {
    constructor() {
        this._constMessages = null;
        this._constMessagesContent = null;
        this._constMessagesUrl = null;
        this._mlsContent = null;
        this._mlsFileUrl = null;
        this._mlsStrings = null;
    }
    async fillData(parser) {
        while (this.initInnerObjects(parser, parser.getNextTag())) {
        }
        await this.InitConstMessagesTable();
        await this.fillMlsMessagesTable();
    }
    initInnerObjects(parser, foundTagName) {
        if (foundTagName == null)
            return false;
        switch (foundTagName) {
            case ConstInterface.MG_TAG_LANGUAGE:
                parser.setCurrIndex(parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex()) + 1);
                break;
            case ConstInterface.MG_TAG_CONSTMESSAGES: {
                let endUrlValue;
                parser.setCurrIndex(parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex()) + 1);
                endUrlValue = parser.getXMLdata().indexOf(XMLConstants.TAG_OPEN, parser.getCurrIndex());
                this._constMessagesUrl = parser.getXMLsubstring(endUrlValue);
                parser.setCurrIndex(endUrlValue);
                break;
            }
            case ConstInterface.MG_TAG_CONSTMESSAGESCONTENT: {
                let endUrlValue;
                parser.setCurrIndex(parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex()) + 1);
                endUrlValue = parser.getXMLdata().indexOf(ConstInterface.MG_TAG_CONSTMESSAGESCONTENT, parser.getCurrIndex()) - 2;
                this._constMessagesContent = parser.getXMLsubstring(endUrlValue);
                parser.setCurrIndex(endUrlValue);
                break;
            }
            case ConstInterface.MG_TAG_MLS_CONTENT: {
                let endUrlValue;
                parser.setCurrIndex(parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex()) + 1);
                endUrlValue = parser.getXMLdata().indexOf(ConstInterface.MG_TAG_MLS_CONTENT, parser.getCurrIndex()) - 2;
                this._mlsContent = parser.getXMLsubstring(endUrlValue);
                parser.setCurrIndex(endUrlValue);
                if (!NString.IsNullOrEmpty(this._mlsContent)) {
                    if (this._mlsStrings != null) {
                        this._mlsStrings.Clear();
                        this._mlsStrings = null;
                    }
                }
                if (NString.IsNullOrEmpty(this._mlsContent) && this._mlsContent != null) {
                    this._mlsContent = null;
                    if (this._mlsStrings != null) {
                        this._mlsStrings.Clear();
                        this._mlsStrings = null;
                    }
                }
                break;
            }
            case ConstInterface.MG_TAG_MLS_FILE_URL: {
                let endUrlValue;
                parser.setCurrIndex(parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex()) + 1);
                endUrlValue = parser.getXMLdata().indexOf(XMLConstants.TAG_OPEN, parser.getCurrIndex());
                this._mlsFileUrl = parser.getXMLsubstring(endUrlValue).trim();
                if (!NString.IsNullOrEmpty(this._mlsFileUrl)) {
                    if (this._mlsStrings != null) {
                        this._mlsStrings.Clear();
                        this._mlsStrings = null;
                    }
                }
                else if (NString.IsNullOrEmpty(this._mlsFileUrl) && this._mlsFileUrl != null) {
                    this._mlsFileUrl = null;
                    if (this._mlsStrings != null) {
                        this._mlsStrings.Clear();
                        this._mlsStrings = null;
                    }
                }
                parser.setCurrIndex(endUrlValue);
                break;
            }
            case ConstInterface.MG_TAG_CONSTMESSAGES_END:
            case ConstInterface.MG_TAG_MLS_FILE_URL_END:
            case ConstInterface.MG_TAG_CONSTMESSAGESCONTENT_END:
            case ConstInterface.MG_TAG_MLS_CONTENT_END:
                parser.setCurrIndex2EndOfTag();
                break;
            case ConstInterface.MG_TAG_LANGUAGE_END:
                parser.setCurrIndex2EndOfTag();
                return false;
            default:
                Logger.Instance.WriteExceptionToLogWithMsg("There is no such tag in LanguageData.initInnerObjects(): " + foundTagName);
                return false;
        }
        return true;
    }
    getConstMessage(msgId) {
        if (this._constMessages === null) {
            this._constMessages = new Hashtable();
            for (let i = 0; i <= MsgInterface.DefaultMessages.length - 1; i = i + 1) {
                this._constMessages.set_Item(MsgInterface.DefaultMessages[i].MsgID, MsgInterface.DefaultMessages[i].MsgString);
            }
        }
        return this._constMessages.get_Item(msgId);
    }
    async InitConstMessagesTable() {
        try {
            let msgsInCommentString = null;
            if (this._constMessagesUrl != null || this._constMessagesContent != null) {
                if (this._constMessagesUrl != null) {
                    try {
                        msgsInCommentString = await CommandsProcessorManager.GetContent(this._constMessagesUrl, true);
                    }
                    catch (err) {
                        Logger.Instance.WriteExceptionToLogWithMsg(NString.Format("Unknown message file: \"{0}\"", this._constMessagesUrl));
                    }
                }
                else {
                    msgsInCommentString = this._constMessagesContent;
                }
                if (msgsInCommentString != null) {
                    let startData = msgsInCommentString.indexOf(START_TAG);
                    let endData = msgsInCommentString.indexOf(END_TAG) + END_TAG.length;
                    let retrievedConstMessages = msgsInCommentString.substr(startData, (endData) - (startData));
                    this.fillConstMessagesTable(retrievedConstMessages);
                }
            }
            else {
                Logger.Instance.WriteDevToLog("'constMessagesUrl' and 'constMessagesContent' were not initialized.");
            }
        }
        catch (ex) {
            Logger.Instance.WriteExceptionToLog(ex);
        }
    }
    fillConstMessagesTable(constMessages) {
        try {
            if (constMessages !== null) {
                this._constMessages = new Hashtable();
                JSON_Utils.JSONFromXML(constMessages, this.FillConstMessagesFromJSON.bind(this));
            }
        }
        catch (ex) {
            Logger.Instance.WriteExceptionToLog(ex);
        }
    }
    FillConstMessagesFromJSON(error, result) {
        if (error != null) {
            throw error;
        }
        let errorMessages = result['ErrorCodes']['ErrorMessage'];
        for (let i = 0; i < errorMessages.length; i++) {
            let errorId = errorMessages[i]['$']['id'];
            let errorMessage = errorMessages[i]['_'];
            this._constMessages.set_Item(errorId, (isUndefined(errorMessage) ? "" : errorMessage.trim()));
        }
    }
    translate(fromString) {
        let toString = null;
        if (this._mlsStrings == null)
            return fromString;
        try {
            toString = this._mlsStrings.get_Item(fromString);
            if (toString == null)
                toString = fromString;
        }
        catch (e) {
            console.log(e);
        }
        return toString;
    }
    async fillMlsMessagesTable() {
        try {
            if (this._mlsContent != null) {
                if (this._mlsContent.length > 0) {
                    let linePairs = 0;
                    let srcLine = this._mlsContent + 3;
                    let transLine;
                    this._mlsStrings = new Hashtable();
                    let linesStr = this._mlsContent.substr(this._mlsContent.length - MLS_EOF_CHARS_TO_READ, 8);
                    linePairs = parseInt(linesStr.toString(), 16);
                    let tokens = StrUtil.tokenize(srcLine.toString(), "\n");
                    for (let pairNum = 0; pairNum < linePairs * 2; pairNum += 2) {
                        srcLine = tokens[pairNum].substr(0, tokens[pairNum].length - 1);
                        transLine = tokens[pairNum + 1].substr(0, tokens[pairNum + 1].length - 1);
                        if (this._mlsStrings.get_Item(srcLine.toString()) == null)
                            this._mlsStrings.set_Item(srcLine.toString(), transLine);
                    }
                }
            }
            else if (this._mlsFileUrl != null) {
                if (this._mlsFileUrl.startsWith("./"))
                    this._mlsFileUrl = NString.Replace(this._mlsFileUrl, './', './assets/cache/');
                let contentStr = await CommandsProcessorManager.GetContent(this._mlsFileUrl, true);
                let buffer = contentStr;
                if (buffer != null && buffer.length > 0) {
                    let contentLen = buffer.length;
                    this._mlsStrings = new Hashtable();
                    let linesStr = buffer.substr(contentLen - MLS_EOF_CHARS_TO_READ, 8);
                    let linePairs = parseInt(linesStr, 16);
                    let srcLine;
                    let transLine;
                    let tokens = StrUtil.tokenize(buffer.toString(), "\n");
                    for (let pairNum = 0; pairNum < linePairs * 2; pairNum += 2) {
                        srcLine = tokens[pairNum].substr(0, tokens[pairNum].length - 1);
                        transLine = tokens[pairNum + 1].substr(0, tokens[pairNum + 1].length - 1);
                        if (this._mlsStrings.get_Item(srcLine) == null)
                            this._mlsStrings.set_Item(srcLine, transLine);
                    }
                }
            }
        }
        catch (e) {
            Logger.Instance.WriteExceptionToLog(e);
            Misc.WriteStackTrace(e);
        }
    }
}
LanguageData.Instance = new LanguageData();

class GUIManager {
    static get Instance() {
        if (GUIManager._instance === null)
            GUIManager._instance = new GUIManager();
        return GUIManager._instance;
    }
    execGuiCommandQueue() {
        Commands.beginInvoke();
    }
    startTimer(mgData, seconds, isIdleTimer) {
        if (seconds > 0) {
            let objRCTimer = new RCTimer(mgData, seconds * 1000, isIdleTimer);
            (objRCTimer).Start();
            Commands.beginInvoke();
        }
    }
    stopTimer(mgData, seconds, isIdleTimer) {
        if (seconds > 0)
            RCTimer.StopTimer(mgData, seconds * 1000, isIdleTimer);
    }
    abort(form) {
        if (arguments.length === 1)
            this.abort_0(form);
        else
            this.abort_1();
    }
    abort_0(form) {
        if (form !== null) {
            Manager.Abort(form);
        }
    }
    abort_1() {
        for (let i = AccessHelper.mgDataTable.getSize(); i > 0; i--) {
            const task = AccessHelper.mgDataTable.getMGData(i - 1).getFirstTask();
            if (task !== null)
                this.abort(task.Form);
        }
    }
    async MessageBox(title, msg, style) {
        await AccessHelper.eventsManager.CheckAndShowSpinner(false);
        return await Commands.messageBox(title, msg, style);
    }
    async writeToMessageBox(titleId, msgId, style) {
        let title = LanguageData.Instance.getConstMessage(titleId);
        let msg = LanguageData.Instance.getConstMessage(msgId);
        return await this.MessageBox(title, msg, style);
    }
    async confirm(msgId, style) {
        return await this.writeToMessageBox(MsgInterface.CONFIRM_STR_WINDOW_TITLE, msgId, style);
    }
    async confirm_bool(msgId) {
        let retResult = await this.confirm(msgId, Styles.MSGBOX_BUTTON_OK_CANCEL);
        return retResult == Styles.MSGBOX_RESULT_OK;
    }
}
GUIManager._instance = null;

class ExpressionLocalJpn {
    constructor(expressionEvaluator) {
        this._expressionEvaluator = null;
        this._expressionEvaluator = expressionEvaluator;
    }
    eval_op_han(strVal) {
        let strbufZenkaku = new StringBuilder(StrUtil.rtrim(strVal));
        let strbufHankaku = new StringBuilder(0);
        let strRet = null;
        for (let i = 0; i < strbufZenkaku.Length; i = i + 1) {
            let cLetter = strbufZenkaku.get_Item(i);
            if (0xff01 <= cLetter.charCodeAt(0) && cLetter.charCodeAt(0) <= 0xff5e && cLetter.charCodeAt(0) !== 0xff3c && cLetter.charCodeAt(0) !== 0xff40) {
                strbufHankaku.Append(String.fromCharCode(cLetter.charCodeAt(0) - 0xfee0));
            }
            else if (0x309b <= cLetter.charCodeAt(0) && cLetter.charCodeAt(0) <= 0x30f6) {
                strbufHankaku.Append(ExpressionLocalJpn.tableZen2Han[cLetter.charCodeAt(0) - 0x309b][0]);
                if (ExpressionLocalJpn.tableZen2Han[cLetter.charCodeAt(0) - 0x309b][1].charCodeAt(0) > 0x0000) {
                    strbufHankaku.Append(ExpressionLocalJpn.tableZen2Han[cLetter.charCodeAt(0) - 0x309b][1]);
                }
            }
            else {
                let j;
                for (j = 0; j < ExpressionLocalJpn.tableExceptZen2Han.length; j++) {
                    if (cLetter === ExpressionLocalJpn.tableExceptZen2Han[j][0]) {
                        strbufHankaku.Append(ExpressionLocalJpn.tableExceptZen2Han[j][1]);
                        break;
                    }
                }
                if (j === ExpressionLocalJpn.tableExceptZen2Han.length)
                    strbufHankaku.Append(cLetter);
            }
        }
        strRet = strbufHankaku.ToString();
        strbufZenkaku = null;
        strbufHankaku = null;
        return strRet;
    }
    eval_op_zens(strVal, mode) {
        let strbufHankaku = new StringBuilder(StrUtil.rtrim(strVal));
        let strbufZenkaku = new StringBuilder(0);
        let strRet = null;
        for (let i = 0; i < strbufHankaku.Length; i = i + 1) {
            let cLetter = strbufHankaku.get_Item(i);
            if (0x0020 <= cLetter.charCodeAt(0) && cLetter.charCodeAt(0) <= 0x007e) {
                switch (cLetter) {
                    case String.fromCharCode(0x0020):
                        if (mode === 1) {
                            strbufZenkaku.Append(String.fromCharCode(0x3000));
                        }
                        else if (mode === 2) {
                            strbufZenkaku.Append(String.fromCharCode(0x0020));
                            strbufZenkaku.Append(String.fromCharCode(0x0020));
                        }
                        else {
                            strbufZenkaku.Append(String.fromCharCode(0x0020));
                        }
                        break;
                    case String.fromCharCode(0x0022):
                        strbufZenkaku.Append(String.fromCharCode(0x201d));
                        break;
                    case String.fromCharCode(0x0027):
                        strbufZenkaku.Append(String.fromCharCode(0x2019));
                        break;
                    case String.fromCharCode(0x005c):
                        strbufZenkaku.Append(String.fromCharCode(0xffe5));
                        break;
                    case String.fromCharCode(0x0060):
                        strbufZenkaku.Append(String.fromCharCode(0x2018));
                        break;
                    default:
                        strbufZenkaku.Append(String.fromCharCode(cLetter.charCodeAt(0) + 0xfee0));
                        break;
                }
            }
            else if (0xff61 <= cLetter.charCodeAt(0) && cLetter.charCodeAt(0) <= 0xff9f) {
                let cCombine = String.fromCharCode(0x0000);
                if ((i + 1) < strbufHankaku.Length) {
                    cCombine = strbufHankaku.get_Item(i + 1);
                    if (cCombine.charCodeAt(0) !== 0xff9e && cCombine.charCodeAt(0) !== 0xff9f)
                        cCombine = String.fromCharCode(0x0000);
                }
                if (cCombine.charCodeAt(0) === 0xff9e) {
                    if (0xff76 <= cLetter.charCodeAt(0) && cLetter.charCodeAt(0) <= 0xff84 || 0xff8a <= cLetter.charCodeAt(0) && cLetter.charCodeAt(0) <= 0xff8e)
                        strbufZenkaku.Append((ExpressionLocalJpn.tableHan2Zen[cLetter.charCodeAt(0) - 0xff61] + 0x001));
                    else if (cLetter.charCodeAt(0) === 0xff73)
                        strbufZenkaku.Append(String.fromCharCode(0x30f4));
                    else
                        cCombine = String.fromCharCode(0x0000);
                }
                else if (cCombine.charCodeAt(0) === 0xff9f) {
                    if (0xff8a <= cLetter.charCodeAt(0) && cLetter.charCodeAt(0) <= 0xff8e)
                        strbufZenkaku.Append((ExpressionLocalJpn.tableHan2Zen[cLetter.charCodeAt(0) - 0xff61] + 0x002));
                    else
                        cCombine = String.fromCharCode(0x0000);
                }
                if (cCombine.charCodeAt(0) !== 0x0000)
                    i++;
                else
                    strbufZenkaku.Append(ExpressionLocalJpn.tableHan2Zen[cLetter.charCodeAt(0) - 0xff61]);
            }
            else {
                strbufZenkaku.Append(cLetter);
            }
        }
        strRet = strbufZenkaku.ToString();
        strbufHankaku = null;
        strbufZenkaku = null;
        return strRet;
    }
    eval_op_zimeread() {
        let strRet = null;
        let utilImeJpn = Manager.UtilImeJpn;
        if (utilImeJpn !== null)
            strRet = utilImeJpn.StrImeRead;
        return strRet;
    }
    eval_op_zkana(strVal, mode) {
        let strbufConverted = new StringBuilder(StrUtil.rtrim(strVal));
        let strRet = null;
        for (let i = 0; i < strbufConverted.Length; i = i + 1) {
            let cLetter = strbufConverted.get_Item(i);
            if (mode === 0) {
                if (0x3041 <= cLetter.charCodeAt(0) && cLetter.charCodeAt(0) <= 0x3093)
                    strbufConverted.set_Item(i, String.fromCharCode(cLetter.charCodeAt(0) + 0x0060));
            }
            else {
                if (0x30A1 <= cLetter.charCodeAt(0) && cLetter.charCodeAt(0) <= 0x30f3)
                    strbufConverted.set_Item(i, String.fromCharCode(cLetter.charCodeAt(0) - 0x0060));
            }
        }
        strRet = strbufConverted.ToString();
        strbufConverted = null;
        return strRet;
    }
    eval_op_jcdow(resVal, val1, displayConvertor) {
        this._expressionEvaluator.eval_op_date_str(resVal, val1, "SSSSSST", displayConvertor);
    }
    eval_op_jmonth(resVal, val1) {
        if (val1.MgNumVal === null) {
            this._expressionEvaluator.SetNULL(resVal, StorageAttribute.ALPHA);
            return;
        }
        val1.MgNumVal = this._expressionEvaluator.mul_add(val1.MgNumVal, 31, -30);
        this._expressionEvaluator.eval_op_month(resVal, val1);
        let month = resVal.MgNumVal.NUM_2_LONG();
        resVal.Attr = StorageAttribute.ALPHA;
        resVal.StrVal = UtilDateJpn.convertStrMonth(month);
    }
    eval_op_jndow(resVal, val1, displayConvertor) {
        if (val1.MgNumVal === null) {
            this._expressionEvaluator.SetNULL(resVal, StorageAttribute.ALPHA);
            return;
        }
        val1.MgNumVal = this._expressionEvaluator.mul_add(val1.MgNumVal, 0, 6);
        this.eval_op_jcdow(resVal, val1.MgNumVal, displayConvertor);
    }
    eval_op_jyear(resVal, val1) {
        this._expressionEvaluator.eval_op_date_brk(resVal, val1.MgNumVal, 4);
    }
    eval_op_jgengo(resVal, val1, val2, displayConvertor) {
        let strFormat;
        resVal.Attr = StorageAttribute.ALPHA;
        if (val1 === null || val2 === null) {
            this._expressionEvaluator.SetNULL(resVal, StorageAttribute.ALPHA);
            return;
        }
        let intType = val2.NUM_2_LONG();
        if (intType >= 4)
            strFormat = "JJJJ";
        else if (intType >= 2)
            strFormat = "JJ";
        else if (intType >= 1)
            strFormat = "J";
        else {
            resVal.StrVal = "";
            return;
        }
        this._expressionEvaluator.eval_op_date_str(resVal, val1, strFormat, displayConvertor);
    }
}
ExpressionLocalJpn.tableZen2Han = [
    [String.fromCharCode(0xff9e), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff9f), String.fromCharCode(0x0000)],
    [String.fromCharCode(0x309d), String.fromCharCode(0x0000)],
    [String.fromCharCode(0x309e), String.fromCharCode(0x0000)],
    [String.fromCharCode(0x309f), String.fromCharCode(0x0000)],
    [String.fromCharCode(0x30a0), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff67), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff71), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff68), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff72), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff69), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff73), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff6a), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff74), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff6b), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff75), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff76), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff76), String.fromCharCode(0xff9e)],
    [String.fromCharCode(0xff77), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff77), String.fromCharCode(0xff9e)],
    [String.fromCharCode(0xff78), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff78), String.fromCharCode(0xff9e)],
    [String.fromCharCode(0xff79), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff79), String.fromCharCode(0xff9e)],
    [String.fromCharCode(0xff7a), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff7a), String.fromCharCode(0xff9e)],
    [String.fromCharCode(0xff7b), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff7b), String.fromCharCode(0xff9e)],
    [String.fromCharCode(0xff7c), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff7c), String.fromCharCode(0xff9e)],
    [String.fromCharCode(0xff7d), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff7d), String.fromCharCode(0xff9e)],
    [String.fromCharCode(0xff7e), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff7e), String.fromCharCode(0xff9e)],
    [String.fromCharCode(0xff7f), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff7f), String.fromCharCode(0xff9e)],
    [String.fromCharCode(0xff80), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff80), String.fromCharCode(0xff9e)],
    [String.fromCharCode(0xff81), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff81), String.fromCharCode(0xff9e)],
    [String.fromCharCode(0xff6f), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff82), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff82), String.fromCharCode(0xff9e)],
    [String.fromCharCode(0xff83), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff83), String.fromCharCode(0xff9e)],
    [String.fromCharCode(0xff84), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff84), String.fromCharCode(0xff9e)],
    [String.fromCharCode(0xff85), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff86), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff87), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff88), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff89), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff8a), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff8a), String.fromCharCode(0xff9e)],
    [String.fromCharCode(0xff8a), String.fromCharCode(0xff9f)],
    [String.fromCharCode(0xff8b), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff8b), String.fromCharCode(0xff9e)],
    [String.fromCharCode(0xff8b), String.fromCharCode(0xff9f)],
    [String.fromCharCode(0xff8c), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff8c), String.fromCharCode(0xff9e)],
    [String.fromCharCode(0xff8c), String.fromCharCode(0xff9f)],
    [String.fromCharCode(0xff8d), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff8d), String.fromCharCode(0xff9e)],
    [String.fromCharCode(0xff8d), String.fromCharCode(0xff9f)],
    [String.fromCharCode(0xff8e), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff8e), String.fromCharCode(0xff9e)],
    [String.fromCharCode(0xff8e), String.fromCharCode(0xff9f)],
    [String.fromCharCode(0xff8f), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff90), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff91), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff92), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff93), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff6c), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff94), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff6d), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff95), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff6e), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff96), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff97), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff98), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff99), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff9a), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff9b), String.fromCharCode(0x0000)],
    [String.fromCharCode(0x30ee), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff9c), String.fromCharCode(0x0000)],
    [String.fromCharCode(0x30f0), String.fromCharCode(0x0000)],
    [String.fromCharCode(0x30f1), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff66), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff9d), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff73), String.fromCharCode(0xff9e)],
    [String.fromCharCode(0xff76), String.fromCharCode(0x0000)],
    [String.fromCharCode(0xff79), String.fromCharCode(0x0000)]
];
ExpressionLocalJpn.tableExceptZen2Han = [
    [String.fromCharCode(0x2018), String.fromCharCode(0x0060)],
    [String.fromCharCode(0x2019), String.fromCharCode(0x0027)],
    [String.fromCharCode(0x201D), String.fromCharCode(0x0022)],
    [String.fromCharCode(0x3000), String.fromCharCode(0x0020)],
    [String.fromCharCode(0x3001), String.fromCharCode(0xFF64)],
    [String.fromCharCode(0x3002), String.fromCharCode(0xFF61)],
    [String.fromCharCode(0x300C), String.fromCharCode(0xFF62)],
    [String.fromCharCode(0x300D), String.fromCharCode(0xFF63)],
    [String.fromCharCode(0x30FB), String.fromCharCode(0xFF65)],
    [String.fromCharCode(0x30FC), String.fromCharCode(0xFF70)],
    [String.fromCharCode(0xFFE5), String.fromCharCode(0x005C)]
];
ExpressionLocalJpn.tableHan2Zen = [
    String.fromCharCode(0x3002), String.fromCharCode(0x300c), String.fromCharCode(0x300d),
    String.fromCharCode(0x3001), String.fromCharCode(0x30fb), String.fromCharCode(0x30f2),
    String.fromCharCode(0x30a1), String.fromCharCode(0x30a3), String.fromCharCode(0x30a5),
    String.fromCharCode(0x30a7), String.fromCharCode(0x30a9), String.fromCharCode(0x30e3),
    String.fromCharCode(0x30e5), String.fromCharCode(0x30e7), String.fromCharCode(0x30c3),
    String.fromCharCode(0x30fc), String.fromCharCode(0x30a2), String.fromCharCode(0x30a4),
    String.fromCharCode(0x30a6), String.fromCharCode(0x30a8), String.fromCharCode(0x30aa),
    String.fromCharCode(0x30ab), String.fromCharCode(0x30ad), String.fromCharCode(0x30af),
    String.fromCharCode(0x30b1), String.fromCharCode(0x30b3), String.fromCharCode(0x30b5),
    String.fromCharCode(0x30b7), String.fromCharCode(0x30b9), String.fromCharCode(0x30bb),
    String.fromCharCode(0x30bd), String.fromCharCode(0x30bf), String.fromCharCode(0x30c1),
    String.fromCharCode(0x30c4), String.fromCharCode(0x30c6), String.fromCharCode(0x30c8),
    String.fromCharCode(0x30ca), String.fromCharCode(0x30cb), String.fromCharCode(0x30cc),
    String.fromCharCode(0x30cd), String.fromCharCode(0x30ce), String.fromCharCode(0x30cf),
    String.fromCharCode(0x30d2), String.fromCharCode(0x30d5), String.fromCharCode(0x30d8),
    String.fromCharCode(0x30db), String.fromCharCode(0x30de), String.fromCharCode(0x30df),
    String.fromCharCode(0x30e0), String.fromCharCode(0x30e1), String.fromCharCode(0x30e2),
    String.fromCharCode(0x30e4), String.fromCharCode(0x30e6), String.fromCharCode(0x30e8),
    String.fromCharCode(0x30e9), String.fromCharCode(0x30ea), String.fromCharCode(0x30eb),
    String.fromCharCode(0x30ec), String.fromCharCode(0x30ed), String.fromCharCode(0x30ef),
    String.fromCharCode(0x30f3), String.fromCharCode(0x309b), String.fromCharCode(0x309c)
];

class ExpDesc {
    constructor(Attr, Prec, ArgCount, ArgEvalCount, ArgAttr, RtfAsAlpha) {
        this.Attr_ = '\0';
        this.Prec_ = 0;
        this.ArgCount_ = 0;
        this.ArgEvalCount_ = 0;
        this.ArgAttr_ = null;
        this.RtfAsAlpha_ = false;
        this.Attr_ = Attr;
        this.Prec_ = Prec;
        this.ArgCount_ = ArgCount;
        this.ArgEvalCount_ = ArgEvalCount;
        this.ArgAttr_ = ArgAttr;
        this.RtfAsAlpha_ = RtfAsAlpha;
    }
}
class ExpressionDict {
}
ExpressionDict.expDesc = [
    new ExpDesc(' ', 0, 0, 0, "", false),
    new ExpDesc(' ', 0, 0, 0, "", false),
    new ExpDesc('N', 0, 0, 0, "", false),
    new ExpDesc('A', 0, 0, 0, "", false),
    new ExpDesc('A', 0, 0, 0, "", false),
    new ExpDesc('N', 0, 0, 0, "", false),
    new ExpDesc('D', 0, 0, 0, "", false),
    new ExpDesc('T', 0, 0, 0, "", false),
    new ExpDesc('B', 0, 0, 0, "", false),
    new ExpDesc('N', 0, 0, 0, "", false),
    new ExpDesc('N', 0, 0, 0, "", false),
    new ExpDesc('N', 0, 0, 0, "", false),
    new ExpDesc('A', 0, 0, 0, "", false),
    new ExpDesc('A', 0, 0, 0, "", false),
    new ExpDesc('A', 0, 0, 0, "", false),
    new ExpDesc('N', 4, 2, 2, "NN", false),
    new ExpDesc('N', 4, 2, 2, "NN", false),
    new ExpDesc('N', 5, 2, 2, "NN", false),
    new ExpDesc('N', 5, 2, 2, "NN", false),
    new ExpDesc('N', 5, 2, 2, "NN", false),
    new ExpDesc('N', 4, 1, 1, "N", false),
    new ExpDesc('N', 0, 3, 3, "NNN", false),
    new ExpDesc('N', 0, 3, 3, "NNN", false),
    new ExpDesc('B', 3, 2, 2, "  ", false),
    new ExpDesc('B', 3, 2, 2, "  ", false),
    new ExpDesc('B', 3, 2, 2, "  ", false),
    new ExpDesc('B', 3, 2, 2, "  ", false),
    new ExpDesc('B', 3, 2, 2, "  ", false),
    new ExpDesc('B', 3, 2, 2, "  ", false),
    new ExpDesc('B', 2, 1, 1, "B", false),
    new ExpDesc('B', 1, 2, 1, "BB", false),
    new ExpDesc('B', 2, 2, 1, "BB", false),
    new ExpDesc(' ', 0, 3, 1, "B  ", false),
    new ExpDesc('N', 0, 1, 1, "U", true),
    new ExpDesc('A', 4, 2, 2, "UU", true),
    new ExpDesc('A', 0, 3, 3, "UNN", true),
    new ExpDesc('A', 0, 2, 2, "UN", true),
    new ExpDesc('A', 0, 2, 2, "UN", true),
    new ExpDesc('A', 0, 2, 2, "UN", true),
    new ExpDesc('N', 0, 2, 2, "UU", true),
    new ExpDesc('A', 0, 1, 1, "U", true),
    new ExpDesc('A', 0, 1, 1, "U", true),
    new ExpDesc('A', 0, 1, 1, "U", true),
    new ExpDesc('A', 0, 2, 2, "NU", true),
    new ExpDesc('N', 0, 2, 2, "UU", true),
    new ExpDesc('B', 0, 2, 2, "NA", true),
    new ExpDesc('A', 0, 1, 1, "N", false),
    new ExpDesc('N', 0, 1, 1, "N", false),
    new ExpDesc('*', 0, 1, 1, "V", false),
    new ExpDesc('*', 0, 1, 1, "V", false),
    new ExpDesc('B', 0, 1, 1, "V", false),
    new ExpDesc('N', 0, 1, 1, "N", false),
    new ExpDesc('A', 0, 1, 1, "V", false),
    new ExpDesc('B', 0, 1, 1, "N", false),
    new ExpDesc('H', 0, 1, 1, "A", true),
    new ExpDesc('A', 0, 1, 1, "A", true),
    new ExpDesc('B', 0, 2, 2, "AB", true),
    null,
    null,
    new ExpDesc('N', 0, 0, 0, "", false),
    null,
    new ExpDesc('D', 0, 0, 0, "", false),
    new ExpDesc('T', 0, 0, 0, "", false),
    new ExpDesc('H', 0, 0, 0, "", false),
    null,
    new ExpDesc('U', 0, 0, 0, "", false),
    new ExpDesc('H', 0, 0, 0, "", false),
    null,
    new ExpDesc('N', 6, 2, 2, "NN", false),
    new ExpDesc('N', 0, 1, 1, "N", false),
    new ExpDesc('N', 0, 1, 1, "N", false),
    new ExpDesc('N', 0, 1, 1, "N", false),
    new ExpDesc('N', 0, 1, 1, "N", false),
    new ExpDesc('N', 0, 1, 1, "N", false),
    new ExpDesc('N', 0, 1, 1, "N", false),
    new ExpDesc('N', 0, 1, 1, "N", false),
    new ExpDesc('N', 0, 1, 1, "N", false),
    new ExpDesc('N', 0, 1, 1, "N", false),
    new ExpDesc('N', 0, 1, 1, "N", false),
    new ExpDesc(' ', 0, -2, -2, "  ", false),
    new ExpDesc(' ', 0, -2, -2, "  ", false),
    new ExpDesc('B', 0, 3, 3, "   ", false),
    new ExpDesc('A', 0, 4, 4, "UUNN", true),
    new ExpDesc('A', 0, 4, 4, "UUNN", true),
    new ExpDesc('A', 0, 3, 3, "UNN", true),
    new ExpDesc('A', 0, 1, 1, "U", true),
    new ExpDesc('A', 0, 1, 1, "U", true),
    new ExpDesc('A', 0, 1, 1, "U", true),
    new ExpDesc('A', 0, 2, 2, "AN", true),
    new ExpDesc('N', 0, 2, 2, "AN", true),
    new ExpDesc('A', 0, 1, 1, "A", true),
    new ExpDesc('A', 0, 1, 1, "N", false),
    new ExpDesc('N', 0, 1, 1, "A", true),
    new ExpDesc('A', 0, 1, 1, "N", false),
    new ExpDesc('N', 0, 1, 1, "A", true),
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    new ExpDesc('A', 0, 2, 2, "NN", false),
    new ExpDesc('N', 0, 1, 1, "A", true),
    new ExpDesc('A', 0, 2, 2, "DU", true),
    new ExpDesc('D', 0, 2, 2, "UU", true),
    new ExpDesc('A', 0, 2, 2, "TU", true),
    new ExpDesc('T', 0, 2, 2, "UU", true),
    new ExpDesc('N', 0, 1, 1, "D", false),
    new ExpDesc('N', 0, 1, 1, "D", false),
    new ExpDesc('N', 0, 1, 1, "D", false),
    new ExpDesc('N', 0, 1, 1, "D", false),
    new ExpDesc('A', 0, 1, 1, "D", false),
    new ExpDesc('A', 0, 1, 1, "D", false),
    new ExpDesc('A', 0, 1, 1, "N", false),
    new ExpDesc('A', 0, 1, 1, "N", false),
    new ExpDesc('N', 0, 1, 1, "T", false),
    new ExpDesc('N', 0, 1, 1, "T", false),
    new ExpDesc('N', 0, 1, 1, "T", false),
    new ExpDesc('B', 0, 1, 1, "N", false),
    new ExpDesc('N', 0, 0, 0, "", false),
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    new ExpDesc('D', 0, 4, 4, "DNNN", false),
    new ExpDesc('T', 0, 4, 4, "TNNN", false),
    new ExpDesc('H', 0, 0, 0, "", false),
    new ExpDesc('A', 0, 1, 1, "V", false),
    new ExpDesc('D', 0, 1, 1, "D", false),
    new ExpDesc('D', 0, 1, 1, "D", false),
    new ExpDesc('D', 0, 1, 1, "D", false),
    new ExpDesc('D', 0, 1, 1, "D", false),
    null,
    new ExpDesc('N', 0, 0, 0, "", false),
    null,
    null,
    new ExpDesc('B', 0, 2, 2, "V ", false),
    null,
    null,
    null,
    null,
    new ExpDesc('*', 0, 0, 0, "", false),
    new ExpDesc('A', 0, 0, 0, "", false),
    new ExpDesc('N', 0, 0, 0, "", false),
    new ExpDesc('B', 0, 0, 0, "", false),
    new ExpDesc('D', 0, 0, 0, "", false),
    new ExpDesc('T', 0, 0, 0, "", false),
    new ExpDesc('B', 0, 1, 1, " ", false),
    new ExpDesc('N', 0, 0, 0, "", false),
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    new ExpDesc('N', 0, 0, 0, "", false),
    new ExpDesc('N', 0, 0, 0, "", false),
    new ExpDesc('N', 0, 0, 0, "", false),
    new ExpDesc('N', 0, 0, 0, "", false),
    new ExpDesc('B', 0, 0, 0, "", false),
    new ExpDesc('B', 0, 0, 0, "", false),
    new ExpDesc('B', 0, 0, 0, "", false),
    null,
    null,
    null,
    new ExpDesc('A', 0, 1, 1, "U", false),
    new ExpDesc('A', 0, 0, 0, "", true),
    new ExpDesc('N', 0, 2, 2, "NA", true),
    new ExpDesc('N', 0, 1, 1, "N", false),
    null,
    null,
    null,
    new ExpDesc('A', 0, 0, 0, "", false),
    new ExpDesc('B', 0, 2, 2, "AB", false),
    new ExpDesc('B', 0, 2, 2, "AB", false),
    new ExpDesc('B', 0, 2, 2, "AB", false),
    new ExpDesc('O', 0, 0, 0, "", false),
    null,
    new ExpDesc('*', 0, 1, 1, "A", false),
    new ExpDesc('B', 0, 2, 2, "A ", false),
    null,
    null,
    null,
    null,
    null,
    new ExpDesc('*', 0, 2, 2, "B*", false),
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    new ExpDesc('B', 0, 1, 1, "V", false),
    new ExpDesc('N', 0, 0, 0, "", false),
    new ExpDesc('A', 0, 3, 3, "UNU", true),
    null,
    null,
    null,
    new ExpDesc('A', 0, 2, 2, "AN", true),
    new ExpDesc('A', 0, 1, 1, "N", true),
    new ExpDesc('N', 0, 0, 0, "", true),
    new ExpDesc('N', 0, 2, 2, "AN", false),
    new ExpDesc('N', 0, 2, 2, "AN", false),
    null,
    null,
    new ExpDesc('N', 0, 2, 2, "AN", false),
    new ExpDesc('N', 0, 2, 2, "AN", false),
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    new ExpDesc('B', 0, 1, 1, "N", false),
    null,
    new ExpDesc('N', 0, 1, 1, "A", false),
    new ExpDesc('A', 0, 1, 1, "N", true),
    null,
    null,
    new ExpDesc('A', 0, 1, 1, "AAAA", true),
    null,
    null,
    null,
    null,
    new ExpDesc('N', 0, 1, 1, "N", true),
    new ExpDesc(' ', 0, -4, -4, "    ", false),
    null,
    new ExpDesc('B', 2, 2, 2, "AA", true),
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    new ExpDesc('B', 0, -1, -1, "A", false),
    null,
    null,
    null,
    null,
    null,
    null,
    new ExpDesc('N', 0, 0, 0, "", false),
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    new ExpDesc('A', 0, 3, 3, "UUU", false),
    null,
    null,
    new ExpDesc('N', 0, 2, 2, "NN", false),
    new ExpDesc('A', 0, 2, 2, "NN", false),
    null,
    new ExpDesc('N', 0, 2, 2, "UU", false),
    new ExpDesc('*', 0, 1, 1, "A", false),
    new ExpDesc('N', 0, 1, 1, "A", false),
    new ExpDesc('A', 0, 0, 0, "", false),
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    new ExpDesc('B', 0, -2, -2, " U", true),
    new ExpDesc('B', 0, 0, 0, "", false),
    new ExpDesc('A', 0, 0, 0, "", false),
    null,
    null,
    new ExpDesc('A', 0, 1, 1, "A", false),
    new ExpDesc('A', 0, 1, 1, "A", false),
    new ExpDesc('A', 0, 1, 1, "A", false),
    new ExpDesc('N', 0, 1, 1, "A", false),
    new ExpDesc('A', 0, 2, 2, "AA", false),
    null,
    null,
    new ExpDesc('A', 0, 1, 1, "A", true),
    new ExpDesc('A', 0, 1, 1, "A", true),
    new ExpDesc('A', 0, 2, 2, "AA", true),
    new ExpDesc('A', 0, 1, 1, "N", false),
    new ExpDesc('A', 0, 2, 2, "AA", true),
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    new ExpDesc('B', 0, 2, 2, "AU", false),
    null,
    null,
    null,
    null,
    new ExpDesc('B', 0, 3, 3, "ANN", false),
    null,
    null,
    null,
    null,
    new ExpDesc('A', 0, 1, 1, "A", false),
    new ExpDesc('U', 0, 2, 2, "UU", false),
    null,
    new ExpDesc('B', 0, 2, 2, "AA", false),
    new ExpDesc('B', 0, -3, -3, "AAA", false),
    new ExpDesc('N', 0, 0, 0, "", false),
    new ExpDesc('*', 0, 1, 1, "N", false),
    new ExpDesc('B', 0, -2, -2, "*NA", false),
    null,
    new ExpDesc('B', 0, -1, -1, "*NA", false),
    new ExpDesc('*', 0, -1, -1, "*NA", false),
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    new ExpDesc('N', 0, 0, 0, "", false),
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    new ExpDesc('N', 0, 0, 0, "", false),
    new ExpDesc('N', 0, 0, 0, "", false),
    null,
    null,
    new ExpDesc('*', 0, 2, 2, "ON", false),
    new ExpDesc('B', 0, 3, 3, "VN ", false),
    new ExpDesc('N', 0, 1, 1, "O", false),
    new ExpDesc('A', 0, 1, 1, "O", false),
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    new ExpDesc('N', 0, 1, 1, "O", false),
    null,
    null,
    null,
    null,
    null,
    new ExpDesc('N', 0, 3, 3, "UUU", false),
    new ExpDesc('N', 0, 0, 0, "", false),
    new ExpDesc('T', 0, 2, 2, "UU", true),
    new ExpDesc('A', 0, 2, 2, "NU", true),
    null,
    null,
    null,
    null,
    null,
    new ExpDesc('B', 0, 1, 1, " ", false),
    null,
    null,
    null,
    null,
    new ExpDesc('B', 0, -2, -2, "  ", true),
    null,
    null,
    new ExpDesc('B', 0, 0, 0, "", false),
    null,
    null,
    null,
    null,
    null,
    null,
    new ExpDesc('N', 0, 2, 2, "NN", true),
    new ExpDesc('B', 0, 1, 1, "U", true),
    new ExpDesc('A', 0, 0, 0, "", true),
    new ExpDesc('N', 0, 0, 0, "", true),
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    new ExpDesc('U', 0, 0, 0, "", false),
    new ExpDesc('B', 0, 2, 2, "NA", false),
    new ExpDesc('B', 0, -1, -1, "NA", false),
    new ExpDesc('B', 0, 0, 0, "", false),
    new ExpDesc('N', 0, 0, 0, "", false),
    new ExpDesc(' ', 0, -16, -16, "               ", false),
    new ExpDesc('N', 0, 1, 1, "N", false),
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    new ExpDesc('A', 0, 1, 1, "N", false),
    new ExpDesc('N', 0, 1, 1, "U", false),
    new ExpDesc('U', 0, 2, 2, "AN", false),
    new ExpDesc('A', 0, 2, 2, "UN", false),
    new ExpDesc('B', 0, 8, 8, "VVNNNNNN", false),
    new ExpDesc('B', 0, 6, 6, "DTDTVV", false),
    new ExpDesc('B', 0, 1, 1, "N", false),
    new ExpDesc('A', 0, 1, 1, "N", false),
    null,
    null,
    new ExpDesc('N', 0, 1, 1, "N", false),
    null,
    null,
    new ExpDesc('B', 0, 1, 1, "U", false),
    new ExpDesc('N', 0, 2, 2, "AB", false),
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    new ExpDesc('N', 0, 1, 1, "N", false),
    new ExpDesc('N', 0, 1, 1, "N", false),
    new ExpDesc('S', 0, 0, 0, "", false),
    new ExpDesc('B', 0, 1, 1, "A", false),
    new ExpDesc('A', 0, 1, 1, "N", false),
    new ExpDesc('A', 0, 1, 1, "N", false),
    null,
    null,
    null,
    null,
    new ExpDesc('A', 0, -2, -2, "UU", false),
    null,
    new ExpDesc('O', 0, 1, 1, "A", false),
    new ExpDesc('B', 0, 2, 2, "OA", false),
    new ExpDesc('B', 0, 2, 2, "AA", false),
    new ExpDesc('B', 0, 1, 1, "A", false),
    new ExpDesc('B', 0, 1, 1, "A", false),
    new ExpDesc('O', 0, 3, 3, "AAB", false),
    new ExpDesc('B', 0, 2, 2, "AA", false),
    new ExpDesc('N', 0, 1, 1, "A", false),
    new ExpDesc('A', 0, 1, 1, "A", false),
    new ExpDesc('B', 0, 2, 2, "AA", false),
    new ExpDesc('B', 0, 1, 1, "N", false),
    new ExpDesc('B', 0, 2, 2, "AA", false),
    new ExpDesc('A', 0, 1, 1, "A", false),
    new ExpDesc('B', 0, -3, -3, "AABU", false),
    new ExpDesc('A', 0, 0, 0, "", false),
    new ExpDesc('N', 0, 2, 2, "AN", false),
    new ExpDesc('N', 0, 2, 2, "AN", false),
    new ExpDesc('A', 0, 1, 1, "U", false),
    null,
    null,
    new ExpDesc('A', 0, 2, 2, "AN", false),
    new ExpDesc('A', 0, 5, 5, "AAABB", true),
    new ExpDesc('A', 0, 5, 5, "AAAAB", true),
    new ExpDesc('A', 0, 3, 3, "AAB", true),
    null,
    null,
    new ExpDesc('B', 0, 4, 4, "UUUB", true),
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    new ExpDesc('B', 0, 0, 0, "", true),
    new ExpDesc('A', 0, 0, 0, "", true),
    new ExpDesc(' ', 0, 3, 3, "ENA", false),
    new ExpDesc(' ', 0, 3, 3, "ENA", false),
    new ExpDesc(' ', 0, -3, -3, "ENA", false),
    new ExpDesc(' ', 0, -3, -3, "ENA", false),
    new ExpDesc(' ', 0, -2, -2, "EN", false),
    new ExpDesc(' ', 0, -2, -2, "EN", false),
    new ExpDesc(' ', 0, -2, -2, "EN", false),
    new ExpDesc(' ', 0, -3, -3, "NE ", false),
    new ExpDesc(' ', 0, 3, 3, "ENA", false),
    new ExpDesc(' ', 0, 3, 3, "ENA", false),
    new ExpDesc(' ', 0, 2, 2, "EA", false),
    new ExpDesc(' ', 0, 2, 2, "EE", false),
    new ExpDesc(' ', 0, 1, 1, " ", false),
    new ExpDesc(' ', 0, 2, 2, "  ", false),
    new ExpDesc(' ', 0, 2, 2, "NA", false),
    new ExpDesc(' ', 0, 0, 0, "", false),
    new ExpDesc(' ', 0, 0, 0, "", false),
    new ExpDesc('A', 0, 1, 1, "N", false),
    null,
    new ExpDesc('A', 0, 1, 1, "A", false),
    new ExpDesc('N', 0, 2, 2, "AA", false),
    null,
    null,
    null,
    null,
    null,
    null,
    new ExpDesc('N', 0, 1, 1, "N", false),
    null,
    null,
    new ExpDesc(' ', 0, 3, 3, "NAA", false),
    null,
    null,
    null,
    null,
    null,
    null,
    new ExpDesc('B', 0, 2, 2, "A ", false),
    new ExpDesc('D', 0, 0, 0, "", false),
    new ExpDesc('T', 0, 0, 0, "", false),
    new ExpDesc('N', 0, 0, 0, "", false),
    new ExpDesc('B', 0, 1, 1, "A", false),
    new ExpDesc('B', 0, 5, 5, "NANAA", false),
    new ExpDesc('B', 0, 2, 2, "NA", false),
    null,
    null,
    null,
    null,
    null,
    null,
    new ExpDesc('*', 0, -2, -2, "AA", false),
    null,
    new ExpDesc('U', 0, 1, 1, "V", false),
    new ExpDesc('B', 0, 2, 2, "NB", false),
    new ExpDesc('B', 0, 2, 2, "AN", false),
    new ExpDesc('N', 0, 1, 1, "V", false),
    new ExpDesc('U', 0, 1, 1, "N", false),
    new ExpDesc('U', 0, 1, 1, "N", false),
    new ExpDesc('B', 0, -2, -2, "AU", false),
    new ExpDesc('N', 0, 2, 2, "NB", false),
    new ExpDesc('N', 0, 2, 2, "NB", false),
    new ExpDesc('N', 0, 1, 1, "N", false),
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    new ExpDesc('S', 0, 5, 5, "NNNNB", false),
    new ExpDesc('B', 0, 2, 2, "UU", false),
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    new ExpDesc('B', 0, 1, 1, "U", false),
    null,
    new ExpDesc('B', 0, 1, 1, "N", false),
    new ExpDesc('B', 0, 0, 0, "", false),
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    new ExpDesc('B', 0, -2, -2, '*', false),
    new ExpDesc('*', 0, 1, 1, 'A', false),
    new ExpDesc('B', 0, 1, 1, 'A', false),
    null,
    new ExpDesc('U', 0, 0, 0, '', false),
];

class EventHandlerPosition {
    constructor() {
        this._handlerIdx = 0;
        this._handlersTab = null;
        this._orgPrevTask = null;
        this._orgTask = null;
        this._phase = 0;
        this._prevTask = null;
        this._rtEvt = null;
        this._task = null;
    }
    init(rtEvent) {
        this._rtEvt = rtEvent;
        this._task = this._rtEvt.getTask();
        if (this._task.isMainProg()) {
            this._prevTask = this._rtEvt.getMainPrgCreator();
            if (this._prevTask !== null && this._prevTask.isMainProg())
                this._prevTask = null;
        }
        if (rtEvent.getType() === ConstInterface.EVENT_TYPE_USER_FUNC)
            this._phase = EventHandlerPosition.PHASE_CONTROL_NON_SPECIFIC;
        else {
            if (rtEvent.getType() === ConstInterface.EVENT_TYPE_USER_FUNC)
                this._phase = EventHandlerPosition.PHASE_CONTROL_NON_SPECIFIC;
            else
                this._phase = EventHandlerPosition.PHASE_CONTROL_SPECIFIC;
        }
        this._orgTask = this._task;
        this._orgPrevTask = this._prevTask;
        this._handlersTab = this._task.getHandlersTab();
        if (this._handlersTab === null) {
            this.goUpTaskChain();
        }
        this._handlerIdx = -1;
    }
    getNext(evt) {
        if (!isNullOrUndefined(evt))
            return this.getNext_0(evt);
        else
            return this.getNext_1();
    }
    getNext_0(evt) {
        this._rtEvt = evt;
        return this.getNext();
    }
    getNext_1() {
        if (this._handlersTab === null)
            return null;
        if (this._rtEvt.getType() === ConstInterface.EVENT_TYPE_INTERNAL && this._rtEvt.getInternalCode() !== InternalInterface.MG_ACT_VARIABLE) {
            switch (this._rtEvt.getInternalCode()) {
                case InternalInterface.MG_ACT_TASK_PREFIX:
                case InternalInterface.MG_ACT_TASK_SUFFIX:
                case InternalInterface.MG_ACT_REC_PREFIX:
                case InternalInterface.MG_ACT_REC_SUFFIX:
                case InternalInterface.MG_ACT_CTRL_PREFIX:
                case InternalInterface.MG_ACT_CTRL_SUFFIX: {
                    if (this._rtEvt.getInternalCode() == InternalInterface.MG_ACT_REC_PREFIX) {
                        FlowMonitorQueue.Instance.addDataViewFlow(this._task);
                    }
                    if (this._handlerIdx === -1) {
                        for (this._handlerIdx = this._handlersTab.getSize() - 1; this._handlerIdx >= 0; this._handlerIdx--) {
                            let handler = this._handlersTab.getHandler(this._handlerIdx);
                            if ((handler.isNonSpecificHandlerOf(this._rtEvt)) || (handler.isSpecificHandlerOf(this._rtEvt))) {
                                return handler;
                            }
                        }
                    }
                    return null;
                }
                default:
                    break;
            }
        }
        while (this.setNextHandlerIdx()) {
            let handler = this._handlersTab.getHandler(this._handlerIdx);
            switch (this._phase) {
                case EventHandlerPosition.PHASE_CONTROL_SPECIFIC:
                    if (handler.isSpecificHandlerOf(this._rtEvt))
                        return handler;
                    continue;
                case EventHandlerPosition.PHASE_CONTROL_NON_SPECIFIC:
                    if (handler.isNonSpecificHandlerOf(this._rtEvt))
                        return handler;
                    continue;
                case EventHandlerPosition.PHASE_GLOBAL_SPECIFIC:
                    if (handler.isGlobalSpecificHandlerOf(this._rtEvt))
                        return handler;
                    continue;
                case EventHandlerPosition.PHASE_GLOBAL:
                    if (handler.isGlobalHandlerOf(this._rtEvt))
                        return handler;
                    continue;
                default:
                    Logger.Instance.WriteExceptionToLogWithMsg("in EventHandlerPosition.getNext() invalid phase: " + this._phase);
                    break;
            }
        }
        return null;
    }
    setNextHandlerIdx() {
        if (this._handlerIdx < 0)
            this._handlerIdx = this._handlersTab.getSize() - 1;
        else
            this._handlerIdx = this._handlerIdx - 1;
        if (this._handlerIdx < 0 || this._task.isAborting()) {
            if (this.goUpTaskChain())
                return this.setNextHandlerIdx();
            else
                return false;
        }
        return true;
    }
    goUpTaskChain() {
        let mGData = this._task.getMGData();
        let ctlIdx = this._task.getCtlIdx();
        switch (this._phase) {
            case EventHandlerPosition.PHASE_CONTROL_SPECIFIC:
            case EventHandlerPosition.PHASE_CONTROL_NON_SPECIFIC: {
                if (!this._task.isMainProg()) {
                    this.getParentOrCompMainPrg();
                    break;
                }
                else {
                    if ((this._rtEvt.getType() === ConstInterface.EVENT_TYPE_PUBLIC ||
                        this._rtEvt.getType() === ConstInterface.EVENT_TYPE_INTERNAL ||
                        this._rtEvt.getType() === ConstInterface.EVENT_TYPE_SYSTEM ||
                        this._rtEvt.getType() === ConstInterface.EVENT_TYPE_USER) && ctlIdx > 0) {
                        if (this._prevTask === null) {
                            this._task = mGData.getNextMainProg(ctlIdx);
                            if (this._task === null && ctlIdx > 0)
                                this._task = AccessHelper.mgDataTable.GetMainProgByCtlIdx(-1, AccessHelper.eventsManager.getCompMainPrgTab().getCtlIdx(0));
                        }
                        else {
                            this._task = this._prevTask.PathParentTask;
                            this._prevTask = null;
                        }
                        this._rtEvt.setMainPrgCreator(null);
                        break;
                    }
                    if (this._phase === EventHandlerPosition.PHASE_CONTROL_SPECIFIC) {
                        this._phase = EventHandlerPosition.PHASE_GLOBAL_SPECIFIC;
                    }
                    else {
                        this._phase = EventHandlerPosition.PHASE_GLOBAL;
                    }
                    this._task = AccessHelper.mgDataTable.GetMainProgByCtlIdx(-1, AccessHelper.eventsManager.getCompMainPrgTab().getCtlIdx(0));
                    this._rtEvt.setMainPrgCreator(this._task);
                    if (this._task === null)
                        return false;
                    break;
                }
            }
            case EventHandlerPosition.PHASE_GLOBAL_SPECIFIC:
            case EventHandlerPosition.PHASE_GLOBAL: {
                this._task = mGData.getNextMainProg(ctlIdx);
                if (this._task === null) {
                    if (this._phase === EventHandlerPosition.PHASE_GLOBAL)
                        return false;
                    this._phase = EventHandlerPosition.PHASE_CONTROL_NON_SPECIFIC;
                    this._task = this._orgTask;
                    this._prevTask = this._orgPrevTask;
                }
                break;
            }
            default:
                Logger.Instance.WriteExceptionToLogWithMsg("in EventHandlerPosition.goUpTaskChain() invalid phase: " + this._phase);
                break;
        }
        if (this._task === null)
            return false;
        this._handlersTab = this._task.getHandlersTab();
        if (this._handlersTab === null)
            return this.goUpTaskChain();
        this._handlerIdx = -1;
        return true;
    }
    getParentOrCompMainPrg() {
        let ctlIdx = this._task.getCtlIdx();
        this._prevTask = this._task;
        let pathParentTask = this._task.PathParentTask;
        if (pathParentTask === null) {
            this._task = null;
            return;
        }
        if (ctlIdx !== pathParentTask.getCtlIdx()) {
            this._rtEvt.setMainPrgCreator(this._task);
            this._task = AccessHelper.mgDataTable.GetMainProgByCtlIdx(-1, ctlIdx);
        }
        else {
            this._rtEvt.setMainPrgCreator(null);
            this._task = pathParentTask;
        }
    }
}
EventHandlerPosition.PHASE_CONTROL_SPECIFIC = 1;
EventHandlerPosition.PHASE_CONTROL_NON_SPECIFIC = 2;
EventHandlerPosition.PHASE_GLOBAL = 3;
EventHandlerPosition.PHASE_GLOBAL_SPECIFIC = 4;

var DataViewCommandType;
(function (DataViewCommandType) {
    DataViewCommandType[DataViewCommandType["Init"] = 0] = "Init";
    DataViewCommandType[DataViewCommandType["Clear"] = 1] = "Clear";
    DataViewCommandType[DataViewCommandType["Prepare"] = 2] = "Prepare";
    DataViewCommandType[DataViewCommandType["FirstChunk"] = 3] = "FirstChunk";
    DataViewCommandType[DataViewCommandType["RecomputeUnit"] = 4] = "RecomputeUnit";
    DataViewCommandType[DataViewCommandType["ExecuteLocalUpdates"] = 5] = "ExecuteLocalUpdates";
    DataViewCommandType[DataViewCommandType["InitDataControlViews"] = 6] = "InitDataControlViews";
    DataViewCommandType[DataViewCommandType["OpenTransaction"] = 7] = "OpenTransaction";
    DataViewCommandType[DataViewCommandType["CloseTransaction"] = 8] = "CloseTransaction";
    DataViewCommandType[DataViewCommandType["SetTransactionState"] = 9] = "SetTransactionState";
    DataViewCommandType[DataViewCommandType["AddUserRange"] = 10] = "AddUserRange";
    DataViewCommandType[DataViewCommandType["ResetUserRange"] = 11] = "ResetUserRange";
    DataViewCommandType[DataViewCommandType["DbDisconnect"] = 12] = "DbDisconnect";
    DataViewCommandType[DataViewCommandType["AddUserLocate"] = 13] = "AddUserLocate";
    DataViewCommandType[DataViewCommandType["ResetUserLocate"] = 14] = "ResetUserLocate";
    DataViewCommandType[DataViewCommandType["AddUserSort"] = 15] = "AddUserSort";
    DataViewCommandType[DataViewCommandType["ResetUserSort"] = 16] = "ResetUserSort";
    DataViewCommandType[DataViewCommandType["DataViewToDataSource"] = 17] = "DataViewToDataSource";
    DataViewCommandType[DataViewCommandType["DbDelete"] = 18] = "DbDelete";
    DataViewCommandType[DataViewCommandType["ControlItemsRefresh"] = 19] = "ControlItemsRefresh";
    DataViewCommandType[DataViewCommandType["SQLExecute"] = 20] = "SQLExecute";
})(DataViewCommandType || (DataViewCommandType = {}));
class DataviewCommand extends ClientOriginatedCommandTaskTag {
    get CommandTypeAttribute() {
        throw new NotImplementedException();
    }
    SerializeCommandData() {
        Debug.Assert(false, "Dataview commands need not be serialized");
        return null;
    }
    get ShouldSerialize() {
        return false;
    }
    constructor() {
        super();
        this.CommandType = 0;
        this.TaskTag = null;
    }
}

class AddUserRangeDataviewCommand extends DataviewCommand {
    constructor() {
        super();
        this.Range = null;
        this.CommandType = DataViewCommandType.AddUserRange;
    }
}

class AddUserSortDataViewCommand extends DataviewCommand {
    constructor() {
        super();
        this.Sort = null;
        this.CommandType = DataViewCommandType.AddUserSort;
    }
}

class AddUserLocateDataViewCommand extends AddUserRangeDataviewCommand {
    constructor() {
        super();
        this.CommandType = DataViewCommandType.AddUserLocate;
    }
}

class SetTransactionStateDataviewCommand extends DataviewCommand {
    constructor() {
        super();
        this.TransactionIsOpen = false;
        this.CommandType = DataViewCommandType.SetTransactionState;
    }
}

class RefreshEventCommand extends EventCommand {
    constructor(magicEvent) {
        super(magicEvent);
        this.RefreshMode = 0;
        this.KeepUserSort = false;
        this.CurrentRecordRow = 0;
        this.IsInternalRefresh = false;
    }
    SerializeCommandData() {
        let helper = new CommandSerializationHelper();
        helper.SerializeTaskTag(this.TaskTag);
        helper.SerializeMagicEvent(this.MagicEvent);
        if (!this.IsInternalRefresh)
            helper.SerializeRefreshMode(this.RefreshMode);
        if (this.KeepUserSort)
            helper.SerializeAttribute(ConstInterface.MG_ATTR_KEEP_USER_SORT, "1");
        return helper.GetString();
    }
    getCommandInfo() {
        return NString.Format('[{0} {1}]', this.EventDescription, this.IsInternalRefresh ? 'Raised by Magic' : 'Raised by User');
    }
}

class FetchDataControlValuesEventCommand extends EventCommand {
    constructor() {
        super(InternalInterface.MG_ACT_FETCH_DATA_CONTROL_VALUES);
        this.ControlName = null;
    }
    SerializeCommandData() {
        let helper = new CommandSerializationHelper();
        helper.SerializeTaskTag(this.TaskTag);
        helper.SerializeMagicEvent(this.MagicEvent);
        helper.SerializeAttribute(ConstInterface.MG_ATTR_CONTROL_NAME, this.ControlName);
        return helper.GetString();
    }
    getCommandInfo() {
        return NString.Format('[{0} for control {1} in {2}]', this.EventDescription, this.ControlName, this.Task.getTaskInfo());
    }
}

class SubformRefreshEventCommand extends RefreshEventCommand {
    constructor() {
        super(InternalInterface.MG_ACT_SUBFORM_REFRESH);
        this.SubformTaskTag = null;
        this.ExplicitSubformRefresh = false;
    }
    SerializeCommandData() {
        let helper = new CommandSerializationHelper();
        helper.SerializeTaskTag(this.TaskTag);
        helper.SerializeMagicEvent(this.MagicEvent);
        helper.SerializeRefreshMode(this.RefreshMode);
        helper.SerializeAttribute(ConstInterface.MG_ATTR_SUBFORM_TASK, this.SubformTaskTag);
        return helper.GetString();
    }
    getCommandInfo() {
        return NString.Format('[{0} for {1}]', this.EventDescription, this.Task.getTaskInfo());
    }
}

class BrowserEscEventCommand extends EventCommand {
    constructor() {
        super(InternalInterface.MG_ACT_BROWSER_ESC);
        this.CloseSubformOnly = false;
    }
    SerializeCommandData() {
        let helper = new CommandSerializationHelper();
        helper.SerializeTaskTag(this.TaskTag);
        helper.SerializeMagicEvent(this.MagicEvent);
        helper.SerializeAttribute(ConstInterface.MG_ATTR_OBJECT, "1");
        helper.SerializeCloseSubformOnly(this.CloseSubformOnly);
        return helper.GetString();
    }
    getCommandInfo() {
        return NString.Format('[{0}{1} in {2}]', this.EventDescription, this.CloseSubformOnly ? ' Subform Only' : NString.Empty, isNullOrUndefined(this.Task) ? NString.Empty : this.Task.getTaskInfo());
    }
}

class IndexChangeEventCommand extends EventCommand {
    constructor() {
        super(InternalInterface.MG_ACT_INDEX_CHANGE);
        this.KeyIndex = 0;
    }
    SerializeCommandData() {
        let helper = new CommandSerializationHelper();
        helper.SerializeTaskTag(this.TaskTag);
        helper.SerializeMagicEvent(this.MagicEvent);
        helper.SerializeKeyIndex(this.KeyIndex);
        return helper.GetString();
    }
    getCommandInfo() {
        return NString.Format('[{0} with Key Index {1} in {2}]', this.EventDescription, this.KeyIndex, this.Task.getTaskInfo());
    }
}

class ColumnSortEventCommand extends EventCommand {
    constructor() {
        super(InternalInterface.MG_ACT_COL_SORT);
        this.FldId = 0;
        this.DitIdx = 0;
        this.Direction = 0;
    }
    SerializeCommandData() {
        let helper = new CommandSerializationHelper();
        helper.SerializeTaskTag(this.TaskTag);
        helper.SerializeFldId(this.FldId);
        helper.SerializeMagicEvent(this.MagicEvent);
        helper.SerializeDitIdx(this.DitIdx);
        helper.SerializeAttribute(ConstInterface.MG_ATTR_DIRECTION, this.Direction);
        return helper.GetString();
    }
    getCommandInfo() {
        return NString.Format('[{0} for column {1} in {2}]', this.EventDescription, this.Task.getForm().getCtrl(this.DitIdx).getName(), this.Task.getTaskInfo());
    }
}

class RefreshScreenEventCommand extends EventCommand {
    constructor() {
        super(InternalInterface.MG_ACT_RT_REFRESH_SCREEN);
        this.TopRecIdx = 0;
        this.RefreshMode = 0;
    }
    SerializeCommandData() {
        let helper = new CommandSerializationHelper();
        helper.SerializeTaskTag(this.TaskTag);
        helper.SerializeMagicEvent(this.MagicEvent);
        helper.SerializeAttribute(ConstInterface.MG_ATTR_OBJECT, this.TopRecIdx);
        helper.SerializeRefreshMode(this.RefreshMode);
        return helper.GetString();
    }
    getCommandInfo() {
        return NString.Format('[{0} in {1}]', this.EventDescription, this.Task.getTaskInfo());
    }
}

class SubformOpenEventCommand extends EventCommand {
    constructor() {
        super(InternalInterface.MG_ACT_SUBFORM_OPEN);
        this.DitIdx = 0;
    }
    SerializeCommandData() {
        let helper = new CommandSerializationHelper();
        helper.SerializeTaskTag(this.TaskTag);
        helper.SerializeMagicEvent(this.MagicEvent);
        helper.SerializeDitIdx(this.DitIdx);
        return helper.GetString();
    }
    getCommandInfo() {
        return NString.Format('[{0} {1} in {2}]', this.EventDescription, this.Task.getForm().getCtrl(this.DitIdx).getName(), this.Task.getTaskInfo());
    }
}

class ComputeEventCommand extends EventCommand {
    constructor() {
        super(InternalInterface.MG_ACT_COMPUTE);
        this.Subforms = false;
    }
    SerializeCommandData() {
        let helper = new CommandSerializationHelper();
        helper.SerializeTaskTag(this.TaskTag);
        helper.SerializeMagicEvent(this.MagicEvent);
        if (this.Subforms)
            helper.SerializeAttribute(ConstInterface.MG_ATTR_OBJECT, "99999");
        return helper.GetString();
    }
    getCommandInfo() {
        return NString.Format('[{0} for {1} in {2}] ', this.EventDescription, this.Subforms ? 'Form and Subform' : 'Form', this.Task.getTaskInfo());
    }
}

class NonReversibleExitEventCommand extends EventCommand {
    constructor() {
        super(InternalInterface.MG_ACT_EXIT);
        this.CloseSubformOnly = false;
    }
    SerializeCommandData() {
        let helper = new CommandSerializationHelper();
        helper.SerializeTaskTag(this.TaskTag);
        helper.SerializeMagicEvent(this.MagicEvent);
        helper.SerializeAttribute(ConstInterface.MG_ATTR_REVERSIBLE, "0");
        helper.SerializeCloseSubformOnly(this.CloseSubformOnly);
        return helper.GetString();
    }
    getCommandInfo() {
        return NString.Format('[{0}{1} in {2}]', this.EventDescription, this.CloseSubformOnly ? ' Closing Subform Only' : NString.Empty, this.Task.getTaskInfo());
    }
}

class RecomputeCommand extends ClientOriginatedCommandTaskTag {
    get CommandTypeAttribute() {
        return ConstInterface.MG_ATTR_VAL_RECOMP;
    }
    SerializeCommandData() {
        let helper = new CommandSerializationHelper();
        helper.SerializeTaskTag(this.TaskTag);
        helper.SerializeFldId(this.FldId);
        if (this.IgnoreSubformRecompute)
            helper.SerializeAttribute(ConstInterface.MG_ATTR_IGNORE_SUBFORM_RECOMPUTE, '1');
        return helper.GetString();
    }
    constructor() {
        super();
        this.TaskTag = null;
        this.FldId = 0;
        this.IgnoreSubformRecompute = false;
    }
    getCommandInfo() {
        return NString.Format('[{0} in {1} for Field {2}]', this.CommandTypeAttribute.charAt(0).toUpperCase() + this.CommandTypeAttribute.substr(1, this.CommandTypeAttribute.length), this.Task.getTaskInfo(), this.Task.getFieldDef(this.FldId).getName());
    }
}

class TransactionCommand extends ClientOriginatedCommandTaskTag {
    get CommandTypeAttribute() {
        return ConstInterface.MG_ATTR_VAL_TRANS;
    }
    SerializeCommandData() {
        let helper = new CommandSerializationHelper();
        helper.SerializeTaskTag(this.TaskTag);
        helper.SerializeAttribute(ConstInterface.MG_ATTR_OPER, this.Oper);
        if (!this.ReversibleExit)
            helper.SerializeAttribute(ConstInterface.MG_ATTR_REVERSIBLE, "0");
        if (this.Level !== '\0')
            helper.SerializeAttribute(ConstInterface.MG_ATTR_TRANS_LEVEL, this.Level);
        return helper.GetString();
    }
    constructor() {
        super();
        this.TaskTag = null;
        this.ReversibleExit = false;
    }
    getCommandInfo() {
        return NString.Format('[{0} in {1}]', this.Oper === 'C' ? 'Commit Transaction' : 'Abort Transaction', this.Task.getTaskInfo());
    }
}

class UnloadCommand extends ClientOriginatedCommand {
    get CommandTypeAttribute() {
        return ConstInterface.MG_ATTR_VAL_UNLOAD;
    }
    constructor() {
        super();
    }
    getCommandInfo() {
        return NString.Format('[{0}]', this.CommandTypeAttribute);
    }
}

class EvaluateCommand extends ClientOriginatedCommandTaskTag {
    get CommandTypeAttribute() {
        return ConstInterface.MG_ATTR_VAL_EVAL;
    }
    constructor() {
        super();
        this.TaskTag = null;
        this.ExpIdx = 0;
        this.LengthExpVal = 0;
        this.MprgCreator = null;
        this.LengthExpVal = Int32.MinValue;
    }
    SerializeCommandData() {
        let helper = new CommandSerializationHelper();
        helper.SerializeTaskTag(this.TaskTag);
        helper.SerializeAttribute(ConstInterface.MG_ATTR_EXP_IDX, this.ExpIdx);
        if (this.ExpType !== StorageAttribute.NONE) {
            let maxDigits = "";
            if (this.LengthExpVal > 0)
                maxDigits += this.LengthExpVal;
            helper.SerializeAttribute(ConstInterface.MG_ATTR_EXP_TYPE, this.ExpType + maxDigits);
        }
        if (this.MprgCreator !== null)
            helper.SerializeAttribute(ConstInterface.MG_ATTR_MPRG_SOURCE, this.MprgCreator.getTaskTag());
        return helper.GetString();
    }
    getCommandInfo() {
        return NString.Format('[{0} ExpID {1} in {2}]', this.CommandTypeAttribute.charAt(0).toUpperCase() + this.CommandTypeAttribute.substr(1, this.CommandTypeAttribute.length), this.ExpIdx, this.Task.getTaskInfo());
    }
}

class QueryCommand extends ClientOriginatedCommand {
    get CommandTypeAttribute() {
        return ConstInterface.MG_ATTR_VAL_QUERY;
    }
    get ShouldSerializeRecords() {
        return false;
    }
    SerializeCommandData() {
        let message = new StringBuilder();
        message.Append(" " + ConstInterface.MG_ATTR_VAL_QUERY_TYPE + "=\"");
        message.Append(this.SerializeQueryCommandData());
        return message.ToString();
    }
    constructor() {
        super();
    }
}

class GlobalParamsQueryCommand extends QueryCommand {
    SerializeQueryCommandData() {
        return ConstInterface.MG_ATTR_VAL_QUERY_GLOBAL_PARAMS + "\"";
    }
    constructor() {
        super();
    }
}

class IniputForceWriteCommand extends ClientOriginatedCommand {
    get CommandTypeAttribute() {
        return ConstInterface.MG_ATTR_VAL_INIPUT_FORCE_WRITE;
    }
    get ShouldSerializeRecords() {
        return false;
    }
    SerializeCommandData() {
        return " " + ConstInterface.MG_ATTR_VAL_INIPUT_PARAM + "=\"" + XmlParser.escape(this.Text) + "\"";
    }
    constructor() {
        super();
        this.Text = null;
    }
    getCommandInfo() {
        return NString.Format('[{0} with {1}] ', this.CommandTypeAttribute, this.Text);
    }
}

class ContextTerminationEventCommand extends EventCommand {
    constructor() {
        super(InternalInterface.MG_ACT_CONTEXT_TERMINATION);
    }
    SerializeCommandData() {
        let helper = new CommandSerializationHelper();
        helper.SerializeTaskTag(this.TaskTag);
        helper.SerializeMagicEvent(this.MagicEvent);
        helper.SerializeAttribute(ConstInterface.MG_ATTR_OBJECT, "1");
        return helper.GetString();
    }
    getCommandInfo() {
        return NString.Empty;
    }
}

class ContextTimeoutResetCommand extends EventCommand {
    constructor() {
        super(InternalInterface.MG_ACT_CONTEXT_TIMEOUT_RESET);
    }
    SerializeCommandData() {
        let helper = new CommandSerializationHelper();
        helper.SerializeMagicEvent(this.MagicEvent);
        helper.SerializeAttribute(ConstInterface.MG_ATTR_OBJECT, '1');
        return helper.GetString();
    }
    getCommandInfo() {
        return NString.Empty;
    }
}

class SelectProgramCommand extends ExecOperCommand {
    getCommandInfo() {
        let eventsManager = AccessHelper.eventsManager;
        let rtEvt = eventsManager.getLastRtEvent();
        return 'Select Program ' + 'on Control ' + rtEvt.Control.Name;
    }
    getTask() {
        let eventsManager = AccessHelper.eventsManager;
        let rtEvt = eventsManager.getLastRtEvent();
        return rtEvt.getTask();
    }
}

class ControlItemsRefreshCommand extends DataviewCommand {
    constructor() {
        super();
        this.Control = null;
    }
}

class CommandFactory {
    static CreateEventCommand(taskTag, magicEvent) {
        let eventCommand = new EventCommand(magicEvent);
        eventCommand.TaskTag = taskTag;
        return eventCommand;
    }
    static CreateRollbackEventCommand(taskTag, rollbackType) {
        let cmd = new RollbackEventCommand();
        cmd.TaskTag = taskTag;
        cmd.Rollback = rollbackType;
        return cmd;
    }
    static CreateDataViewCommand(taskId, commandType) {
        let dataviewCommand = new DataviewCommand();
        dataviewCommand.CommandType = commandType;
        dataviewCommand.TaskTag = taskId;
        return dataviewCommand;
    }
    static CreateControlItemsRefreshCommand(taskId, control) {
        let command = new ControlItemsRefreshCommand();
        command.CommandType = DataViewCommandType.ControlItemsRefresh;
        command.TaskTag = taskId;
        command.Control = control;
        return command;
    }
    static CreateAddUserRangeDataviewCommand(taskId, userRange) {
        let addUserRangeDataviewCommand = new AddUserRangeDataviewCommand();
        addUserRangeDataviewCommand.TaskTag = taskId;
        addUserRangeDataviewCommand.Range = userRange;
        return addUserRangeDataviewCommand;
    }
    static CreateAddUserSortDataviewCommand(taskId, sort) {
        let addUserSortDataViewCommand = new AddUserSortDataViewCommand();
        addUserSortDataViewCommand.TaskTag = taskId;
        addUserSortDataViewCommand.Sort = sort;
        return addUserSortDataViewCommand;
    }
    static CreateAddUserLocateDataviewCommand(taskId, userRange) {
        let addUserLocateDataViewCommand = new AddUserLocateDataViewCommand();
        addUserLocateDataViewCommand.TaskTag = taskId;
        addUserLocateDataViewCommand.Range = userRange;
        return addUserLocateDataViewCommand;
    }
    static CreateSetTransactionStateDataviewCommand(taskId, transactionIsOpened) {
        let setTransactionStateDataviewCommand = new SetTransactionStateDataviewCommand();
        setTransactionStateDataviewCommand.TaskTag = taskId;
        setTransactionStateDataviewCommand.TransactionIsOpen = transactionIsOpened;
        return setTransactionStateDataviewCommand;
    }
    static CreateInternalRefreshCommand(taskId, magicEvent, currentRecId, currentRow) {
        let refreshEventCommand = new RefreshEventCommand(magicEvent);
        refreshEventCommand.TaskTag = taskId;
        refreshEventCommand.RefreshMode = ViewRefreshMode.CurrentLocation;
        refreshEventCommand.ClientRecId = currentRecId;
        refreshEventCommand.IsInternalRefresh = true;
        refreshEventCommand.CurrentRecordRow = currentRow;
        return refreshEventCommand;
    }
    static async CreateRealRefreshCommand(taskId, magicEvent, currentRow, argList, currentRecId) {
        let refreshEventCommand = new RefreshEventCommand(magicEvent);
        refreshEventCommand.TaskTag = taskId;
        refreshEventCommand.RefreshMode = ViewRefreshMode.CurrentLocation;
        refreshEventCommand.KeepUserSort = false;
        refreshEventCommand.ClientRecId = currentRecId;
        refreshEventCommand.CurrentRecordRow = currentRow;
        let cmd = refreshEventCommand;
        if (magicEvent !== InternalInterface.MG_ACT_RT_REFRESH_RECORD && argList !== null && argList.getSize() !== 0) {
            try {
                let refreshMode = new NUM_TYPE(await argList.getArgValue(0, StorageAttribute.NUMERIC, 0));
                cmd.RefreshMode = refreshMode.NUM_2_LONG() + 1;
            }
            catch (e) {
                cmd.RefreshMode = ViewRefreshMode.CurrentLocation;
            }
            if (argList.getSize() > 1) {
                try {
                    cmd.KeepUserSort = (await argList.getArgValue(1, StorageAttribute.BOOLEAN, 0) === '1');
                }
                catch (e) {
                    cmd.KeepUserSort = false;
                }
            }
        }
        return cmd;
    }
    static CreatecFetchDataControlValuesCommand(taskTag, controlName) {
        let fetchDataControlValuesEventCommand = new FetchDataControlValuesEventCommand();
        fetchDataControlValuesEventCommand.TaskTag = taskTag;
        fetchDataControlValuesEventCommand.ControlName = controlName;
        return fetchDataControlValuesEventCommand;
    }
    static CreateSubformRefreshCommand(taskTag, subformTaskTag, explicitSubformRefresh) {
        let subformRefreshEventCommand = new SubformRefreshEventCommand();
        subformRefreshEventCommand.TaskTag = taskTag;
        subformRefreshEventCommand.SubformTaskTag = subformTaskTag;
        subformRefreshEventCommand.ExplicitSubformRefresh = explicitSubformRefresh;
        subformRefreshEventCommand.RefreshMode = ViewRefreshMode.UseTaskLocate;
        return subformRefreshEventCommand;
    }
    static CreateSubformOpenCommand(taskTag, subformDitIdx) {
        let subformOpenEventCommand = new SubformOpenEventCommand();
        subformOpenEventCommand.TaskTag = taskTag;
        subformOpenEventCommand.DitIdx = subformDitIdx;
        return subformOpenEventCommand;
    }
    static CreateScreenRefreshCommand(taskTag, topRecIdx, clientRecId) {
        let refreshScreenEventCommand = new RefreshScreenEventCommand();
        refreshScreenEventCommand.TaskTag = taskTag;
        refreshScreenEventCommand.TopRecIdx = topRecIdx;
        refreshScreenEventCommand.RefreshMode = ViewRefreshMode.CurrentLocation;
        refreshScreenEventCommand.ClientRecId = clientRecId;
        return refreshScreenEventCommand;
    }
    static CreateColumnSortCommand(taskTag, direction, ditIdx, fieldId, recId) {
        let columnSortEventCommand = new ColumnSortEventCommand();
        columnSortEventCommand.TaskTag = taskTag;
        columnSortEventCommand.DitIdx = ditIdx;
        columnSortEventCommand.FldId = fieldId + 1;
        columnSortEventCommand.ClientRecId = recId;
        columnSortEventCommand.Direction = direction;
        return columnSortEventCommand;
    }
    static async CreateIndexChangeCommand(taskTag, recId, argList) {
        let indexChangeEventCommand = new IndexChangeEventCommand();
        indexChangeEventCommand.TaskTag = taskTag;
        indexChangeEventCommand.ClientRecId = recId;
        let cmd = indexChangeEventCommand;
        if (argList !== null && argList.getSize() !== 0) {
            try {
                let keyIndex = new NUM_TYPE(await argList.getArgValue(0, StorageAttribute.NUMERIC, 0));
                cmd.KeyIndex = keyIndex.NUM_2_LONG();
            }
            catch (e) {
                cmd.KeyIndex = 0;
            }
        }
        return cmd;
    }
    static CreateBrowserEscEventCommand(taskTag, closeSubformOnly) {
        let browserEscEventCommand = new BrowserEscEventCommand();
        browserEscEventCommand.TaskTag = taskTag;
        browserEscEventCommand.CloseSubformOnly = closeSubformOnly;
        return browserEscEventCommand;
    }
    static CreateComputeEventCommand(taskTag, subforms, clientRecId) {
        let computeEventCommand = new ComputeEventCommand();
        computeEventCommand.TaskTag = taskTag;
        computeEventCommand.Subforms = subforms;
        computeEventCommand.ClientRecId = clientRecId;
        return computeEventCommand;
    }
    static CreateContextTerminationEventCommand(taskTag) {
        let contextTerminationEventCommand = new ContextTerminationEventCommand();
        contextTerminationEventCommand.TaskTag = taskTag;
        return contextTerminationEventCommand;
    }
    static CreateContextTimeoutResetEventCommand() {
        let contextTimeoutResetCommand = new ContextTimeoutResetCommand();
        return contextTimeoutResetCommand;
    }
    static CreateNonReversibleExitCommand(taskTag, closeSubformOnly) {
        let nonReversibleExitEventCommand = new NonReversibleExitEventCommand();
        nonReversibleExitEventCommand.TaskTag = taskTag;
        nonReversibleExitEventCommand.CloseSubformOnly = closeSubformOnly;
        return nonReversibleExitEventCommand;
    }
    static CreateRecomputeCommand(taskTag, fieldId, ignoreSubformRecompute) {
        let recomputeCommand = new RecomputeCommand();
        recomputeCommand.TaskTag = taskTag;
        recomputeCommand.FldId = fieldId;
        recomputeCommand.IgnoreSubformRecompute = ignoreSubformRecompute;
        return recomputeCommand;
    }
    static CreateTransactionCommand(oper, taskTag, cReversibleExit, level) {
        let transactionCommand = new TransactionCommand();
        transactionCommand.TaskTag = taskTag;
        transactionCommand.Oper = oper;
        transactionCommand.ReversibleExit = cReversibleExit;
        transactionCommand.Level = level;
        return transactionCommand;
    }
    static CreateUnloadCommand() {
        return new UnloadCommand();
    }
    static CreateExecOperCommand(taskTag, handlerId, operIdx, ditIdx, value) {
        let execOperCommand = new ExecOperCommand();
        execOperCommand.OperIdx = operIdx;
        execOperCommand.TaskTag = taskTag;
        execOperCommand.HandlerId = handlerId;
        execOperCommand.DitIdx = ditIdx;
        let cmd = execOperCommand;
        if (value !== null && value.length === 0)
            cmd.Val = ' ';
        else
            cmd.Val = value;
        return cmd;
    }
    static CreateSelectProgramCommand(taskTag, handlerId, operIdx, ditIdx, value) {
        let execOperCommand = new SelectProgramCommand();
        execOperCommand.OperIdx = operIdx;
        execOperCommand.TaskTag = taskTag;
        execOperCommand.HandlerId = handlerId;
        execOperCommand.DitIdx = ditIdx;
        let cmd = execOperCommand;
        if (value !== null && value.length === 0)
            cmd.Val = ' ';
        else
            cmd.Val = value;
        return cmd;
    }
    static CreateEvaluateCommand(taskTag, expType, expIdx, expValLen, mprgCreator) {
        let evaluateCommand = new EvaluateCommand();
        evaluateCommand.TaskTag = taskTag;
        evaluateCommand.ExpIdx = expIdx;
        evaluateCommand.ExpType = expType;
        evaluateCommand.MprgCreator = mprgCreator;
        if (expValLen > 0)
            evaluateCommand.LengthExpVal = expValLen;
        return evaluateCommand;
    }
    static CreateQueryGlobalParamsCommand() {
        return new GlobalParamsQueryCommand();
    }
    static CreateIniputForceWriteCommand(param) {
        let iniputForceWriteCommand = new IniputForceWriteCommand();
        iniputForceWriteCommand.Text = param;
        return iniputForceWriteCommand;
    }
}

var ParamParseResult;
(function (ParamParseResult) {
    ParamParseResult[ParamParseResult["OK"] = 0] = "OK";
    ParamParseResult[ParamParseResult["TOUPPER"] = 1] = "TOUPPER";
    ParamParseResult[ParamParseResult["DELETE"] = 2] = "DELETE";
    ParamParseResult[ParamParseResult["FAILED"] = 3] = "FAILED";
})(ParamParseResult || (ParamParseResult = {}));

class PrmMap {
    getvalue(s) {
        if (this.values.ContainsKey(s))
            return this.values.get_Item(s);
        else
            return null;
    }
    setValue(s, v) {
        this.values.set_Item(s, v);
    }
    remove(s) {
        this.values.Remove(s);
    }
    constructor() {
        this.values = null;
        this.values = new Dictionary();
    }
}
class MirrorPrmMap extends PrmMap {
    constructor(type) {
        super();
        this.changes = null;
        this.mirroredID = null;
        this.type = type;
        this.changes = new List();
    }
    new() {
        return new this.type();
    }
    setValue(s, v, addToChanges) {
        if (arguments.length === 3)
            this.setValue_0(s, v, addToChanges);
        else
            this.setValue_1(s, v);
    }
    setValue_0(s, v, addToChanges) {
        if (addToChanges && !this.changes.Contains(s))
            this.changes.push(s);
        super.setValue(s, v);
    }
    setValue_1(s, v) {
        if (!this.changes.Contains(s))
            this.changes.push(s);
        super.setValue(s, v);
    }
    remove(s) {
        if (!this.changes.Contains(s)) {
            this.changes.push(s);
        }
        super.remove(s);
    }
    mirrorAllToXML() {
        let xml = new StringBuilder();
        if (this.values != null) {
            xml.Append("<" + this.mirroredID + ">");
            for (let key of this.values.Keys) {
                if (this.CheckIfSystemReservedParam(key))
                    continue;
                xml.Append("<" + ConstInterface.MG_TAG_PARAM + " " +
                    XMLConstants.MG_ATTR_NAME + "=\"" + XmlParser.escape(key) + "\" ");
                xml.Append(this.values.get_Item(key).mirrorToXML());
                xml.Append(XMLConstants.TAG_TERM);
            }
            xml.Append("</" + this.mirroredID + ">");
        }
        return xml.ToString();
    }
    CheckIfSystemReservedParam(key) {
        if (key == "UTF8TRANS" || key === "REMOTE_HOST" || key === "REMOTE_ADDR" ||
            key === "CTX" || key === "MGARG0" || key === "DATA" || key === "MGCURRENTREQUESTID" ||
            key === "HTTP_MGXPARIAGLOBALUNIQUESESSIONID" || key === "MG_POST_BODY")
            return true;
        else
            return false;
    }
    mirrorToXML() {
        let xml = new StringBuilder();
        if (this.changes.length > 0) {
            xml.Append("<" + this.mirroredID + ">");
            this.changes.forEach(change => {
                xml.Append("<" + ConstInterface.MG_TAG_PARAM + " " +
                    XMLConstants.MG_ATTR_NAME + "=\"" + XmlParser.escape(change) + "\" ");
                if (this.values.ContainsKey(change))
                    xml.Append(this.values.get_Item(change).mirrorToXML());
                else
                    xml.Append("removed=\"Y\"");
                xml.Append(">");
            });
            xml.Append("</" + this.mirroredID + ">");
        }
        this.changes.Clear();
        return xml.ToString();
    }
    fillData(parser) {
        while (this.mirrorFromXML(parser.getNextTag(), parser)) {
        }
    }
    RestoreParams(xml) {
        let parser = new XmlParser(xml);
        while (this.mirrorFromXML(parser.getNextTag(), parser)) {
        }
    }
    mirrorFromXML(foundTagName, xmlParser) {
        if (foundTagName === null)
            return false;
        if (foundTagName === this.mirroredID) {
            xmlParser.setCurrIndex2EndOfTag();
            this.fillDataEntry(xmlParser);
            return true;
        }
        else if (foundTagName === ("/" + this.mirroredID)) {
            this.changes.Clear();
            xmlParser.setCurrIndex2EndOfTag();
            return false;
        }
        else {
            Logger.Instance.WriteExceptionToLogWithMsg("There is no such tag in MirrorPrmMap.mirrorFromXML(): " + foundTagName);
            return false;
        }
    }
    fillDataEntry(xmlParser) {
        let nextTag = xmlParser.getNextTag();
        while (nextTag === ConstInterface.MG_TAG_PARAM) {
            let nameStart = xmlParser.getXMLdata().indexOf(XMLConstants.MG_ATTR_NAME + "=\"", xmlParser.getCurrIndex()) +
                XMLConstants.MG_ATTR_NAME.length + 2;
            xmlParser.setCurrIndex(nameStart);
            let nameEnd = xmlParser.getXMLdata().indexOf("\"", nameStart);
            let name = xmlParser.getXMLsubstring(nameEnd).trim();
            xmlParser.setCurrIndex(nameEnd);
            let newVal = this.new();
            switch (newVal.init(name, xmlParser)) {
                case ParamParseResult.OK:
                    this.values.set_Item(name, newVal);
                    break;
                case ParamParseResult.TOUPPER:
                    this.values.set_Item(name.toUpperCase(), newVal);
                    break;
                case ParamParseResult.DELETE:
                    this.values.Remove(name);
                    break;
            }
            xmlParser.setCurrIndex2EndOfTag();
            nextTag = xmlParser.getNextTag();
        }
    }
}

class Environment {
    constructor() {
        this._environments = new Hashtable();
        this._contextInactivityTimeout = 0;
        this._clientContextInactivityTimeout = 0;
        this._contextInactivityWarningTime = 0;
        this._toolitipTimeout = 0;
        this._contextUnloadTimeout = 0;
        this._canReplaceDecimalSeparator = false;
        this._codePage = 0;
        this._dateSeparator = '\0';
        this._decimalSeparator = '\0';
        this._thousandsSeparator = '\0';
        this._timeSeparator = '\0';
        this._guid = null;
        this._imeAutoOff = false;
        this._language = '\0';
        this._localAs400Set = false;
        this._localExtraGengo = null;
        this._localFlags = null;
        this._lowHigh = true;
        this._owner = null;
        this._debugMode = 0;
        this._significantNumSize = 0;
        this._specialAnsiExpression = false;
        this._specialImmediatehandlerEnd = false;
        this._specialShowStatusBarPanes = false;
        this._specialRouteToRootProgOnContextRecreation = false;
        this._specialCancelOnCreate = false;
        this._system = null;
        this._terminal = 0;
        this._forwardSlash = Constants.ForwardSlashWebUsage;
        this._dropUserFormats = null;
        this._webclientReinitSession = "N";
        this._specialValNewPolicy = false;
        this.IgnoreReplaceDecimalSeparator = false;
    }
    get Language() {
        return this._language;
    }
    get SpecialRestoreMaximizedForm() {
        return false;
    }
    set ForwardSlashUsage(value) {
        this._forwardSlash = value;
    }
    get ForwardSlashUsage() {
        return this._forwardSlash;
    }
    fillData(tokensVectorOrParser) {
        if (arguments[0] instanceof XmlParser) {
            this.fillData_0(tokensVectorOrParser);
            return;
        }
        this.fillData_1(tokensVectorOrParser);
    }
    fillData_0(parser) {
        let endContext = parser.getXMLdata().indexOf(XMLConstants.TAG_TERM, parser.getCurrIndex());
        if (endContext !== -1 && endContext < parser.getXMLdata().length) {
            let tag = parser.getXMLsubstring(endContext);
            parser.add2CurrIndex(tag.indexOf(ConstInterface.MG_TAG_ENV) + ConstInterface.MG_TAG_ENV.length);
            let tokensVector = XmlParser.getTokens(parser.getXMLsubstring(endContext), XMLConstants.XML_ATTR_DELIM);
            this.fillData(tokensVector);
            parser.setCurrIndex(endContext + XMLConstants.TAG_TERM.length);
        }
        else
            Logger.Instance.WriteExceptionToLogWithMsg("in Environment.FillData() out of string bounds");
    }
    fillData_1(tokensVector) {
        let attribute;
        let valueStr;
        let hashKey;
        let env;
        env = new EnvironmentDetails();
        for (let j = 0; j < tokensVector.length; j += 2) {
            attribute = (tokensVector.get_Item(j));
            valueStr = (tokensVector.get_Item(j + 1));
            valueStr = XmlParser.unescape(valueStr);
            switch (attribute) {
                case ConstInterface.MG_ATTR_THOUSANDS:
                    this._thousandsSeparator = valueStr[0];
                    break;
                case ConstInterface.MG_ATTR_DECIMAL_SEPARATOR:
                    this._decimalSeparator = valueStr[0];
                    break;
                case ConstInterface.MG_ATTR_WEBCLIENT_REINIT_SESSION:
                    this._webclientReinitSession = valueStr[0];
                    break;
                case ConstInterface.MG_ATTR_DATE:
                    this._dateSeparator = valueStr[0];
                    DisplayConvertor.Instance.setDateChar(this._dateSeparator.charCodeAt(0));
                    break;
                case ConstInterface.MG_ATTR_TIME:
                    this._timeSeparator = valueStr[0];
                    break;
                case ConstInterface.MG_ATTR_OWNER:
                    this._owner = valueStr;
                    break;
                case ConstInterface.MG_ATTR_SIGNIFICANT_NUM_SIZE:
                    this._significantNumSize = XmlParser.getInt(valueStr);
                    break;
                case ConstInterface.MG_ATTR_DEBUG_MODE:
                    this._debugMode = XmlParser.getInt(valueStr);
                    break;
                case ConstInterface.MG_ATTR_POINT_TRANSLATION:
                    this._canReplaceDecimalSeparator = XmlParser.getBoolean(valueStr);
                    break;
                case ConstInterface.MG_ATTR_SPECIAL_EXITCTRL:
                    break;
                case ConstInterface.MG_ATTR_LOWHIGH:
                    this._lowHigh = XmlParser.getBoolean(valueStr);
                    break;
                case ConstInterface.MG_ATTR_ACCESS_TEST:
                    break;
                case ConstInterface.MG_ATTR_SPECIAL_TEXT_SIZE_FACTORING:
                    break;
                case ConstInterface.MG_ATTR_SPECIAL_FLAT_EDIT_ON_CLASSIC_THEME:
                    break;
                case ConstInterface.MG_ATTR_ENCODING:
                    if (valueStr !== " ") {
                        this._codePage = XmlParser.getInt(valueStr);
                        UtilStrByteMode.Encoding = this.GetEncoding();
                    }
                    break;
                case ConstInterface.MG_ATTR_SYSTEM:
                    this._system = XmlParser.unescape(valueStr);
                    break;
                case ConstInterface.MG_ATTR_COMPONENT:
                    env.CompIdx = XmlParser.getInt(valueStr);
                    break;
                case ConstInterface.MG_ATTR_DATEMODE:
                    env.DateMode = valueStr[0];
                    break;
                case ConstInterface.MG_ATTR_CENTURY:
                    env.Century = XmlParser.getInt(valueStr);
                    break;
                case ConstInterface.MG_ATTR_IDLETIME:
                    env.IdleTime = XmlParser.getInt(valueStr);
                    if (env.IdleTime === 0)
                        env.IdleTime = 1;
                    break;
                case ConstInterface.MG_ATTR_UPD_IN_QUERY:
                    env.UpdateInQueryMode = XmlParser.getBoolean(valueStr);
                    break;
                case ConstInterface.MG_ATTR_CRE_IN_MODIFY:
                    env.CreateInModifyMode = XmlParser.getBoolean(valueStr);
                    break;
                case ConstInterface.MG_ATTR_DEFAULT_COLOR:
                    break;
                case ConstInterface.MG_ATTR_DEFAULT_FOCUS_COLOR:
                    break;
                case ConstInterface.MG_ATTR_CONTEXT_INACTIVITY_TIMEOUT:
                    this._contextInactivityTimeout = XmlParser.getInt(valueStr);
                    break;
                case ConstInterface.MG_ATTR_CLIENT_CONTEXT_INACTIVITY_TIMEOUT:
                    this._clientContextInactivityTimeout = XmlParser.getInt(valueStr);
                    break;
                case ConstInterface.MG_ATTR_CONTEXT_INACTIVITY_WARNING_TIME:
                    this._contextInactivityWarningTime = XmlParser.getInt(valueStr);
                    break;
                case ConstInterface.MG_ATTR_TOOLTIP_TIMEOUT:
                    this._toolitipTimeout = XmlParser.getInt(valueStr);
                    break;
                case ConstInterface.MG_ATTR_CONTEXT_UNLOAD_TIMEOUT:
                    this._contextUnloadTimeout = XmlParser.getInt(valueStr);
                    break;
                case ConstInterface.MG_ATTR_IME_AUTO_OFF:
                    this._imeAutoOff = XmlParser.getBoolean(valueStr);
                    break;
                case ConstInterface.MG_ATTR_LOCAL_AS400SET:
                    this._localAs400Set = XmlParser.getBoolean(valueStr);
                    break;
                case ConstInterface.MG_ATTR_LOCAL_EXTRA_GENGO:
                    this._localExtraGengo = valueStr;
                    UtilDateJpn.getInstance().addExtraGengo(this._localExtraGengo);
                    break;
                case ConstInterface.MG_ATTR_LOCAL_FLAGS:
                    this._localFlags = valueStr;
                    break;
                case ConstInterface.MG_ATTR_SPECIAL_IMMEDIATE_HANDLER_END:
                    this._specialImmediatehandlerEnd = XmlParser.getBoolean(valueStr);
                    break;
                case ConstInterface.MG_ATTR_SPEACIAL_ANSI_EXP:
                    this._specialAnsiExpression = XmlParser.getBoolean(valueStr);
                    break;
                case ConstInterface.MG_ATTR_SPECIAL_SHOW_STATUSBAR_PANES:
                    this._specialShowStatusBarPanes = XmlParser.getBoolean(valueStr);
                    break;
                case ConstInterface.MG_ATTR_SPECIAL_ROUTE_TO_ROOT_PROG_ON_CONTEXT_RECREATION:
                    this._specialRouteToRootProgOnContextRecreation = XmlParser.getBoolean(valueStr);
                    break;
                case ConstInterface.MG_ATTR_SPECIAL_SPECIAL_EDIT_LEFT_ALIGN:
                    break;
                case ConstInterface.MG_ATTR_SPEACIAL_SWF_CONTROL_NAME:
                    break;
                case ConstInterface.MG_ATTR_LANGUAGE:
                    this._language = valueStr[0];
                    break;
                case ConstInterface.MG_ATTR_USERID:
                    break;
                case ConstInterface.MG_TAG_USERNAME:
                    ServerConfig.Instance.setUsername(valueStr);
                    break;
                case ConstInterface.MG_ATTR_TERMINAL:
                    this._terminal = XmlParser.getInt(valueStr);
                    break;
                case ConstInterface.MG_ATTR_USERINFO:
                    break;
                case ConstInterface.MG_ATTR_GUID:
                    this._guid = valueStr;
                    break;
                case ConstInterface.MG_ATTR_CONTROLS_PERSISTENCY_PATH:
                    break;
                case ConstInterface.MG_ATTR_PROJDIR:
                    env.ProjDir = valueStr;
                    break;
                case ConstInterface.MG_ATTR_DROP_USERFORMATS:
                    this._dropUserFormats = valueStr;
                    break;
                case ConstInterface.MG_ATTR_SPECIAL_VAL_NEW_POLICY:
                    this._specialValNewPolicy = XmlParser.getBoolean(valueStr);
                    break;
                case ConstInterface.MG_ATTR_SPECIAL_CANCEL_ON_CREATE:
                    this._specialCancelOnCreate = XmlParser.getBoolean(valueStr);
                    break;
                case ConstInterface.MG_ATTR_SPECIAL_LEGACY_TRIM_RANGE:
                case ConstInterface.MG_ATTR_SPECIAL_LEGACY_EMPTY_RANGE:
                case ConstInterface.MG_ATTR_DEFAULT_DISABLED_COLOR:
                case ConstInterface.MG_ATTR_SPECIAL_ANSI_BLOB_CHECK_NULL:
                case ConstInterface.MG_ATTR_SPECIAL_TABLE_REDUCE_TITLE_HEIGHT:
                case ConstInterface.MG_ATTR_SPECIAL_DOTNET_ALLOW_ZERO_DATE:
                case ConstInterface.MG_ATTR_SPECIAL_REUSE_TABLE_EDITOR:
                    break;
                default:
                    Logger.Instance.WriteExceptionToLogWithMsg("in Environment.fillData(): unknown attribute: " + attribute);
                    break;
            }
        }
        hashKey = env.CompIdx;
        this._environments.set_Item(hashKey, env);
    }
    async fillFromUrl(tagName, parser) {
        let XMLdata = parser.getXMLdata();
        let endContext = parser.getXMLdata().indexOf(XMLConstants.TAG_TERM, parser.getCurrIndex());
        if (endContext !== -1 && endContext < XMLdata.length) {
            let tagAndAttributes = parser.getXMLsubstring(endContext);
            parser.add2CurrIndex(tagAndAttributes.indexOf(tagName) + tagName.length);
            let tokensVector = XmlParser.getTokens(parser.getXMLsubstring(endContext), XMLConstants.XML_ATTR_DELIM);
            Debug.Assert(tokensVector.get_Item(0) === XMLConstants.MG_ATTR_VALUE);
            let cachedFileUrl = (tokensVector.get_Item(1));
            if (cachedFileUrl.trim() === "")
                Logger.Instance.WriteErrorToLog(NString.Format("Empty cached file URL: '{0}'", tagAndAttributes.trim()));
            else {
                let Content = await CommandsProcessorManager.GetContent(cachedFileUrl, true);
                try {
                    switch (tagName) {
                        case ConstInterface.MG_TAG_KBDMAP_URL:
                            break;
                        case ConstInterface.MG_TAG_ENV_PARAM_URL:
                            let innerXmlParser = new XmlParser(Content);
                            while (AccessHelper.envParamsTable.mirrorFromXML(innerXmlParser.getNextTag(), innerXmlParser)) {
                            }
                            break;
                    }
                }
                catch (ex) {
                    switch (tagName) {
                        case ConstInterface.MG_TAG_KBDMAP_URL:
                            Logger.Instance.WriteExceptionToLogWithMsg(NString.Format("Keyboard Mapping: '{0}'{1}{2}", cachedFileUrl, OSEnvironment.EolSeq, ex.Message));
                            break;
                        case ConstInterface.MG_TAG_ENV_PARAM_URL:
                            Logger.Instance.WriteExceptionToLogWithMsg(NString.Format("Env Params Table: '{0}'{1}{2}", cachedFileUrl, OSEnvironment.EolSeq, ex.Message));
                    }
                }
            }
            endContext = XMLdata.indexOf(XMLConstants.TAG_OPEN, endContext);
            if (endContext !== -1)
                parser.setCurrIndex(endContext);
        }
    }
    getEnvDet(compIdx) {
        let environmentDetails = this._environments.get_Item(compIdx);
        if (environmentDetails === null)
            Logger.Instance.WriteExceptionToLogWithMsg("in Environment.getEnvDet() there is no env");
        return environmentDetails;
    }
    GetDateMode(compIdx) {
        return this.getEnvDet(compIdx).DateMode;
    }
    GetThousands() {
        return this._thousandsSeparator;
    }
    GetDecimal() {
        return this._decimalSeparator;
    }
    setDecimalSeparator(value) {
        this._decimalSeparator = value;
    }
    setThousandsSeparator(value) {
        this._thousandsSeparator = value;
    }
    setDateSeparator(value) {
        this._dateSeparator = value;
    }
    setTimeSeparator(value) {
        this._timeSeparator = value;
    }
    GetDate() {
        return this._dateSeparator;
    }
    getIdleTime(compIdx) {
        return this.getEnvDet(compIdx).IdleTime;
    }
    getOwner() {
        return this._owner;
    }
    GetTime() {
        return this._timeSeparator;
    }
    GetCentury(compIdx) {
        return this.getEnvDet(compIdx).Century;
    }
    allowUpdateInQueryMode(compIdx) {
        return this.getEnvDet(compIdx).allowUpdateInQueryMode();
    }
    allowCreateInModifyMode(compIdx) {
        return this.getEnvDet(compIdx).allowCreateInModifyMode();
    }
    GetSignificantNumSize() {
        return this._significantNumSize;
    }
    setSignificantNumSize(newSize) {
        this._significantNumSize = newSize;
    }
    getCodePage() {
        return this._codePage;
    }
    GetEncoding() {
        let encoding;
        try {
            encoding = Encoding.GetEncoding(this._codePage);
        }
        catch (exception) {
            encoding = null;
        }
        return encoding;
    }
    getSystem() {
        return this._system;
    }
    GetDebugLevel() {
        return this._debugMode;
    }
    CanReplaceDecimalSeparator() {
        return !this.IgnoreReplaceDecimalSeparator && this._canReplaceDecimalSeparator;
    }
    getClientContextInactivityTimeout() {
        return this._clientContextInactivityTimeout;
    }
    getContextInactivityTimeout() {
        return this._contextInactivityTimeout;
    }
    getContextInactivityWarningTime() {
        return this._contextInactivityWarningTime;
    }
    getContextUnloadTimeout() {
        return this._contextUnloadTimeout;
    }
    GetTooltipTimeout() {
        return this._toolitipTimeout;
    }
    getLowHigh() {
        return this._lowHigh;
    }
    GetImeAutoOff() {
        return this._imeAutoOff;
    }
    GetLocalAs400Set() {
        return this._localAs400Set;
    }
    getLocalExtraGengo() {
        return this._localExtraGengo;
    }
    GetLocalFlag(f) {
        return this._localFlags !== null && this._localFlags.indexOf(f) >= 0;
    }
    getSpecialImmediateHandlerEnd() {
        return this._specialImmediatehandlerEnd;
    }
    getSpecialAnsiExpression() {
        return this._specialAnsiExpression;
    }
    getSpecialShowStatusBarPanes() {
        return this._specialShowStatusBarPanes;
    }
    getTerminal() {
        return this._terminal;
    }
    getWebClientReinitSession() {
        return this._webclientReinitSession;
    }
    setWebClientReinitSession(session) {
        this._webclientReinitSession = session;
    }
    getSpecialRouteToRootProgOnContextRecreation() {
        return this._specialRouteToRootProgOnContextRecreation;
    }
    GetGUID() {
        return this._guid;
    }
    getProjDir(compIdx) {
        return this.getEnvDet(compIdx).ProjDir;
    }
    GetSpecialLogInternalExceptions() {
        return true;
    }
    setOwner(val) {
        this._owner = val;
    }
    setDateMode(compIdx, val) {
        this.getEnvDet(compIdx).DateMode = val;
    }
    setCentury(compIdx, val) {
        this.getEnvDet(compIdx).Century = val;
    }
    setIdleTime(compIdx, val) {
        this.getEnvDet(compIdx).IdleTime = val;
    }
    setAllowUpdateInQueryMode(compIdx, val) {
        this.getEnvDet(compIdx).UpdateInQueryMode = val;
    }
    setAllowCreateInModifyMode(compIdx, val) {
        this.getEnvDet(compIdx).CreateInModifyMode = val;
    }
    setContextInactivityTimeout(val) {
        this._contextInactivityTimeout = val;
    }
    setContextInactivityWarningTime(val) {
        this._contextInactivityWarningTime = val;
    }
    setContextUnloadTimeout(val) {
        this._contextUnloadTimeout = val;
    }
    setTerminal(val) {
        this._terminal = val;
    }
    GetDropUserFormats() {
        return this._dropUserFormats;
    }
    GetSpecialValNewPolicy() {
        return this._specialValNewPolicy;
    }
    GetSpecialCancelOnCreate() {
        return this._specialCancelOnCreate;
    }
}
Environment.Instance = new Environment();
class EnvironmentDetails {
    set UpdateInQueryMode(value) {
        this._updateInQueryMode = value;
    }
    set CreateInModifyMode(value) {
        this._createInModifyMode = value;
    }
    constructor() {
        this._createInModifyMode = false;
        this._updateInQueryMode = false;
        this.CompIdx = 0;
        this.DateMode = '\0';
        this.Century = 0;
        this.IdleTime = 0;
        this.ProjDir = null;
        this.CompIdx = 0;
    }
    allowUpdateInQueryMode() {
        return this._updateInQueryMode;
    }
    allowCreateInModifyMode() {
        return this._createInModifyMode;
    }
}

class MirrorExpVal extends ExpVal {
    constructor(val) {
        if (arguments.length === 0) {
            super();
            this.constructor_2();
            return;
        }
        super();
        this.constructor_3(val);
    }
    constructor_2() {
    }
    constructor_3(val) {
        super.Copy(val);
    }
    mirrorToXML() {
        let toBase64 = (Environment.Instance.GetDebugLevel() <= 1);
        let cellAttr = (this.Attr === StorageAttribute.BLOB_VECTOR ? this.VectorField.getCellsType() : StorageAttribute.SKIP);
        let value = "";
        value = RecordUtils.itemValToXML(super.ToMgVal(), this.Attr, cellAttr, toBase64);
        return ConstInterface.MG_ATTR_PAR_ATTRS + "=\"" + this.Attr + "\" " + ConstInterface.MG_ATTR_LEN + "=" +
            value.length + " " + ConstInterface.MG_ATTR_ENV_VALUE + "=\"" + value + "\"";
    }
    init(name, xmlParser) {
        let valueOffset, attrOffset, lenOffset, valueLen, lenOffsetEnd, count;
        let currType;
        let isNull;
        let paramAttr, paramValue, correctValue = null;
        count = xmlParser.getXMLdata().indexOf(XMLConstants.TAG_TERM, xmlParser.getCurrIndex()) - xmlParser.getCurrIndex();
        attrOffset = NString.IndexOf(xmlParser.getXMLdata(), ConstInterface.MG_ATTR_PAR_ATTRS, xmlParser.getCurrIndex(), count);
        if (attrOffset !== -1) {
            attrOffset += ConstInterface.MG_ATTR_PAR_ATTRS.length + 2;
            paramAttr = xmlParser.getXMLdata().substr(attrOffset, 1);
            lenOffset = xmlParser.getXMLdata().indexOf(ConstInterface.MG_ATTR_LEN, attrOffset);
            lenOffset += ConstInterface.MG_ATTR_LEN.length + 1;
            lenOffsetEnd = xmlParser.getXMLdata().indexOf(" ", lenOffset);
            valueLen = XmlParser.getInt(xmlParser.getXMLdata().substr(lenOffset, lenOffsetEnd - lenOffset));
            valueOffset = xmlParser.getXMLdata().indexOf(ConstInterface.MG_ATTR_ENV_VALUE, lenOffset);
            valueOffset += ConstInterface.MG_ATTR_ENV_VALUE.length + 2;
            paramValue = xmlParser.getXMLdata().substr(valueOffset, valueLen);
            currType = paramAttr[0];
            correctValue = RecordUtils.getString(paramValue, currType);
            isNull = false;
            xmlParser.setCurrIndex(valueOffset + valueLen);
        }
        else if (xmlParser.getXMLdata().indexOf(ConstInterface.MG_ATTR_ENV_REMOVED, xmlParser.getCurrIndex()) !== -1) {
            return ParamParseResult.DELETE;
        }
        else {
            currType = StorageAttribute.NONE;
            isNull = true;
        }
        super.Init(currType, isNull, correctValue);
        return ParamParseResult.TOUPPER;
    }
}
class GlobalParams extends MirrorPrmMap {
    constructor() {
        super(MirrorExpVal);
        this.mirroredID = ConstInterface.MG_TAG_GLOBALPARAMSCHANGES;
    }
    set(s, v) {
        if (v.IsNull || v.isEmptyString())
            super.remove(s.trim().toUpperCase());
        else
            super.setValue(s.trim().toUpperCase(), new MirrorExpVal(v));
    }
    get(s) {
        try {
            return super.getvalue(s.trim().toUpperCase());
        }
        catch (err) {
            return null;
        }
    }
}
GlobalParams.Instance = new GlobalParams();

class UserDetails {
    setIsLoggedIn(value) {
        this.IsLoggedIn = value;
    }
    getIsLoggedIn() {
        return this.IsLoggedIn;
    }
    setUserID(userId) {
        this.UserID = userId;
        if (this.UserID.length == 0 || this.UserID === NString.Empty) {
            this.setIsLoggedIn(false);
        }
        else
            this.setIsLoggedIn(true);
    }
    static get Instance() {
        if (UserDetails._instance === null)
            UserDetails._instance = new UserDetails();
        return UserDetails._instance;
    }
    constructor() {
        this.UserName = null;
        this.UserID = null;
        this.UserInfo = null;
        this.Password = null;
        this.IsLoggedIn = false;
        this.UserName = NString.Empty;
        this.UserInfo = NString.Empty;
        this.IsLoggedIn = false;
        this.setUserID(NString.Empty);
    }
    fillData(parser) {
        let tokensVector;
        let endContext = parser.getXMLdata().indexOf(XMLConstants.TAG_TERM, parser.getCurrIndex());
        if (endContext !== -1 && endContext < parser.getXMLdata().length) {
            let tag = parser.getXMLsubstring(endContext);
            parser.add2CurrIndex(tag.indexOf(ConstInterface.MG_TAG_USER_DETAILS) + ConstInterface.MG_TAG_USER_DETAILS.length);
            tokensVector = XmlParser.getTokens(parser.getXMLsubstring(endContext), XMLConstants.XML_ATTR_DELIM);
            this.initElements(tokensVector);
            parser.setCurrIndex(endContext + XMLConstants.TAG_TERM.length);
        }
        else
            Logger.Instance.WriteExceptionToLogWithMsg("in UserDetails.fillData(): out of bounds");
    }
    initElements(tokensVector) {
        let attribute, valueStr;
        let isSuccess = true;
        let j;
        for (j = 0; j < tokensVector.length; j += 2) {
            attribute = tokensVector.get_Item(j);
            valueStr = tokensVector.get_Item(j + 1);
            switch (attribute) {
                case ConstInterface.MG_TAG_IS_LOGGED_IN:
                    this.setIsLoggedIn(valueStr[0] === '1');
                    Commands.addIsLoggedIn(this.getIsLoggedIn());
                    break;
                default:
                    Logger.Instance.WriteExceptionToLogWithMsg("in UserDetails.initElements(): unknown attribute: " + attribute);
                    isSuccess = false;
                    break;
            }
        }
        return isSuccess;
    }
}
UserDetails._instance = null;

class YesNoExp {
    constructor(defaultVal) {
        this._exp = null;
        this._val = false;
        this._val = defaultVal;
        this._exp = null;
    }
    setVal(task, strVal) {
        switch (strVal[0]) {
            case 'Y':
                this._val = true;
                break;
            case 'N':
                this._val = false;
                break;
            default:
                let expId = XmlParser.getInt(strVal);
                if (task != null)
                    this._exp = task.getExpById(expId);
                break;
        }
    }
    async getVal() {
        if (this._exp !== null)
            return await DisplayConvertor.toBoolean(await this._exp.evaluateWithResultTypeAndLength(StorageAttribute.BOOLEAN, 0));
        return this._val;
    }
    isServerExp() {
        if (this._exp != null)
            return this._exp.computedByServerOnly();
        return false;
    }
}

class Operation {
    constructor() {
        this._condExp = new YesNoExp(true);
        this._retainFocus = new YesNoExp(false);
        this._waitExp = new YesNoExp(false);
        this._syncData = new YesNoExp(false);
        this._argList = null;
        this._blockClose = 0;
        this._blockEnd = 0;
        this._buttons = '\0';
        this._checkByServer = false;
        this._cmdToServer = null;
        this._display = 'S';
        this._errLogAppend = false;
        this._evtHandler = null;
        this._execOnServer = false;
        this._execOnClient = false;
        this._exp = null;
        this._field = null;
        this._image = '\0';
        this._incremental = false;
        this._mode = '\0';
        this._publicName = null;
        this._returnVal = null;
        this._rtEvt = null;
        this._serverId = -1;
        this.calledTaskDefinitionId = null;
        this._subformCtrlName = null;
        this._subtype = '\0';
        this._task = null;
        this._text = null;
        this._title = null;
        this._titleExp = null;
        this._type = 0;
        this._undo = true;
        this._isRoute = false;
        this._routerPath = null;
        this._originalRouterOutletName = null;
        this._routeParams = null;
        this.OperCallMode = 0;
    }
    get CalledTaskDefinitionId() {
        return this.calledTaskDefinitionId;
    }
    set Task(value) {
        this._task = value;
    }
    get Task() {
        return this._task;
    }
    async Immediate() {
        return await this._waitExp.getVal();
    }
    fillData(taskRef, evtHandler, parser) {
        this._task = taskRef;
        this._evtHandler = evtHandler;
        while (this.initInnerObjects(parser, parser.getNextTag(), taskRef)) {
        }
    }
    initInnerObjects(parser, foundTagName, taskRef) {
        if (foundTagName === null)
            return false;
        if (foundTagName === ConstInterface.MG_TAG_EVENT) {
            this._rtEvt = new RunTimeEvent(taskRef);
            this._rtEvt.fillData(parser, taskRef);
        }
        else if (foundTagName === ConstInterface.MG_TAG_OPER) {
            this.fillAttributes(parser, taskRef);
        }
        else if (foundTagName === "/" + ConstInterface.MG_TAG_OPER) {
            parser.setCurrIndex2EndOfTag();
            return false;
        }
        else if (foundTagName === XMLConstants.MG_TAG_TASKDEFINITIONID_ENTRY) {
            this.InitTaskDefinitionID(parser);
        }
        else {
            Logger.Instance.WriteExceptionToLogWithMsg("There is no such tag in Operation. Insert else if to Operation.initInnerObjects for " + foundTagName);
            return false;
        }
        return true;
    }
    fillAttributes(parser, taskRef) {
        let tokensVector;
        let endContext = parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex());
        if (endContext !== -1 && endContext < parser.getXMLdata().length) {
            let tag = parser.getXMLsubstring(endContext);
            parser.add2CurrIndex(tag.indexOf(ConstInterface.MG_TAG_OPER) + ConstInterface.MG_TAG_OPER.length);
            tokensVector = XmlParser.getTokens(parser.getXMLsubstring(endContext), XMLConstants.XML_ATTR_DELIM);
            this.initElements(tokensVector, taskRef);
            parser.setCurrIndex(endContext + XMLConstants.TAG_CLOSE.length);
            return;
        }
        Logger.Instance.WriteExceptionToLogWithMsg("in Command.FillData() out of string bounds");
    }
    initElements(tokensVector, taskRef) {
        let attribute, valueStr;
        let expId;
        for (let j = 0; j < tokensVector.length; j += 2) {
            attribute = (tokensVector.get_Item(j));
            valueStr = (tokensVector.get_Item(j + 1));
            switch (attribute) {
                case XMLConstants.MG_ATTR_TYPE:
                    this._type = XmlParser.getInt(valueStr);
                    break;
                case ConstInterface.MG_ATTR_FLD:
                    this._field = Operation.InitField(valueStr, this._task);
                    break;
                case XMLConstants.MG_ATTR_EXP:
                    expId = XmlParser.getInt(valueStr);
                    this._exp = taskRef.getExpById(expId);
                    break;
                case ConstInterface.MG_ATTR_TEXT:
                    this._text = XmlParser.unescape(valueStr);
                    break;
                case ConstInterface.MG_ATTR_MODE:
                    this._mode = valueStr[0];
                    break;
                case ConstInterface.MG_ATTR_SUBTYPE:
                    this._subtype = valueStr[0];
                    if (this._type === ConstInterface.MG_OPER_BLOCK) {
                        if (this._subtype === 'E')
                            this._type = ConstInterface.MG_OPER_ELSE;
                        else if (this._subtype === 'L')
                            this._type = ConstInterface.MG_OPER_LOOP;
                    }
                    break;
                case ConstInterface.MG_ATTR_CLOSE:
                    this._blockClose = XmlParser.getInt(valueStr);
                    break;
                case ConstInterface.MG_ATTR_END:
                    this._blockEnd = XmlParser.getInt(valueStr);
                    break;
                case ConstInterface.MG_ATTR_HOW:
                    this._incremental = (valueStr === "I");
                    break;
                case ConstInterface.MG_ATTR_UNDO:
                    if (valueStr[0] === 'N')
                        this._undo = false;
                    else if (valueStr[0] === 'Y')
                        this._undo = true;
                    else
                        Logger.Instance.WriteExceptionToLogWithMsg("in Operation.initElements(): No such value to the MG_ATTR_UNDO for " + valueStr);
                    break;
                case ConstInterface.MG_ATTR_DISPLAY:
                    this._display = valueStr[0];
                    break;
                case ConstInterface.MG_ATTR_WAIT:
                    this._waitExp.setVal(taskRef, valueStr);
                    break;
                case ConstInterface.MG_ATTR_RETAIN_FOCUS:
                    this._retainFocus.setVal(taskRef, valueStr);
                    break;
                case ConstInterface.MG_ATTR_SYNC_DATA:
                    this._syncData.setVal(taskRef, valueStr);
                    break;
                case ConstInterface.MG_ATTR_SHOW:
                    break;
                case ConstInterface.MG_ATTR_CND:
                    this._condExp.setVal(taskRef, valueStr);
                    break;
                case ConstInterface.MG_ATTR_ARGLIST:
                    this._argList = new ArgumentsList();
                    this._argList.fillList(valueStr, this._task);
                    break;
                case ConstInterface.MG_ATTR_REFRESHON:
                    this._argList.RefreshOnString = valueStr.Trim();
                    break;
                case ConstInterface.MG_ATTR_SERVER_ID:
                    this._serverId = XmlParser.getInt(valueStr);
                    break;
                case ConstInterface.MG_ATTR_OPER_CALLMODE:
                    this.OperCallMode = valueStr[0];
                    break;
                case ConstInterface.MG_ATTR_SUBFORM_CTRL:
                    this._subformCtrlName = XmlParser.unescape(valueStr);
                    break;
                case ConstInterface.MG_ATTR_CHECK_BY_SERVER:
                    this._checkByServer = XmlParser.getBoolean(valueStr);
                    break;
                case ConstInterface.MG_ATTR_PUBLIC:
                    this._publicName = valueStr;
                    break;
                case ConstInterface.MG_ATTR_PRG_DESCRIPTION:
                    break;
                case ConstInterface.MG_ATTR_CPY_GLB_PRMS:
                    break;
                case ConstInterface.MG_ATTR_EXEC_ON_SERVER:
                    this._execOnServer = XmlParser.getBoolean(valueStr);
                    break;
                case ConstInterface.MG_ATTR_EXEC_ON_CLIENT:
                    this._execOnClient = XmlParser.getBoolean(valueStr);
                    break;
                case ConstInterface.MG_ATTR_TITLE:
                    this._title = XmlParser.unescape(valueStr);
                    break;
                case ConstInterface.MG_ATTR_TITLE_EXP:
                    expId = XmlParser.getInt(valueStr);
                    this._titleExp = taskRef.getExpById(expId);
                    break;
                case ConstInterface.MG_ATTR_IMAGE:
                    this._image = valueStr[0];
                    break;
                case ConstInterface.MG_ATTR_BUTTONS:
                    this._buttons = valueStr[0];
                    break;
                case ConstInterface.MG_ATTR_RETURN_VAL:
                    this._returnVal = Operation.InitField(valueStr, this._task);
                    break;
                case ConstInterface.MG_ATTR_ERR_LOG_APPEND:
                    this._errLogAppend = XmlParser.getBoolean(valueStr);
                    break;
                case ConstInterface.MG_ATTR_OPER_METHODNAME:
                    break;
                case ConstInterface.MG_ATTR_IS_GUI_THREAD_EXECUTION:
                    break;
                case ConstInterface.MG_ATTR_IS_ROUTE:
                    this._isRoute = XmlParser.getBoolean(valueStr);
                    break;
                case XMLConstants.MG_ATTR_ROUTER_PATH:
                    this._routerPath = XmlParser.unescape(valueStr);
                    break;
                default:
                    Logger.Instance.WriteExceptionToLogWithMsg("There is no such tag in Operation class. Insert case to Operation.initElements for " + attribute);
                    break;
            }
        }
        if (this._serverId > -1)
            this._cmdToServer = CommandFactory.CreateExecOperCommand(this._task.getTaskTag(), "" + this._evtHandler.getId(), this._serverId, Int32.MinValue, null);
        if (this._isRoute) {
            this._originalRouterOutletName = this._subformCtrlName !== null ? this._subformCtrlName : "";
            if (this._subformCtrlName == null) {
                let defaultRouterOutlet = this._task.getForm().DefaultRouterOutlet;
                this._subformCtrlName = defaultRouterOutlet !== null ? defaultRouterOutlet.Name : "";
            }
        }
    }
    InitTaskDefinitionID(parser) {
        let xmlBuffer = parser.ReadToEndOfCurrentElement();
        let taskDefinitionIdTableSaxHandler = new TaskDefinitionIdTableSaxHandler(this.SetTaskDefinitionId);
        taskDefinitionIdTableSaxHandler.parse(xmlBuffer);
    }
    SetTaskDefinitionId(taskDefinitionId) {
        this.calledTaskDefinitionId = taskDefinitionId;
    }
    static InitField(valueStr, task) {
        let TaskField = XmlParser.getTokens(valueStr, ',');
        if (TaskField.length === 2) {
            let parent = NNumber.Parse(TaskField.get_Item(0));
            let fldID = NNumber.Parse(TaskField.get_Item(1));
            let field = task.getFieldDef(parent, fldID);
            return field;
        }
        Logger.Instance.WriteExceptionToLogWithMsg(NString.Format("Unknown field: '{0}'", valueStr));
        return null;
    }
    async execute(returnedFromServer) {
        let lastRtEvent = AccessHelper.eventsManager.getLastRtEvent();
        let mprgCreator = null;
        let flowMonitor = FlowMonitorQueue.Instance;
        if (lastRtEvent !== null)
            mprgCreator = lastRtEvent.getMainPrgCreator();
        if (returnedFromServer ||
            (!returnedFromServer && (this._type !== ConstInterface.MG_OPER_SERVER || !this._condExp.isServerExp()))) {
            if (!await this.canExecute()) {
                if (this._type !== ConstInterface.MG_OPER_LOOP)
                    await flowMonitor.addFlowFieldOperation(this, false, this._task.GetTaskDetails());
                return false;
            }
        }
        if (this._type !== ConstInterface.MG_OPER_LOOP && this._type !== ConstInterface.MG_OPER_ENDBLOCK)
            await flowMonitor.addFlowFieldOperation(this, true, this._task.GetTaskDetails());
        try {
            switch (this._type) {
                case ConstInterface.MG_OPER_VERIFY:
                    return await this.operVerify();
                case ConstInterface.MG_OPER_BLOCK:
                    return this.operBlock();
                case ConstInterface.MG_OPER_LOOP:
                    if (!this.getExecOnServer())
                        return this.operBlock();
                    else {
                        await this.operServer(mprgCreator);
                        break;
                    }
                case ConstInterface.MG_OPER_ELSE:
                    return this.operElse();
                case ConstInterface.MG_OPER_EVALUATE:
                    await this.operEvaluate();
                    break;
                case ConstInterface.MG_OPER_UPDATE:
                    await this.operUpdate(mprgCreator);
                    break;
                case ConstInterface.MG_OPER_RAISE_EVENT:
                    await this.operRaiseEvent(mprgCreator, returnedFromServer);
                    break;
                case ConstInterface.MG_OPER_SERVER:
                    await this.operServer(mprgCreator);
                    break;
                case ConstInterface.MG_OPER_CALL:
                    if (this._publicName != null) {
                        this.operCallParallel();
                    }
                    else if (this._subformCtrlName == null)
                        await this.operCall(mprgCreator);
                    else {
                        let subformTask;
                        let isEndProg = true;
                        if (this._checkByServer) {
                            if (!(this._cmdToServer instanceof ExecOperCommand))
                                Debug.Assert(false);
                            let command = this._cmdToServer;
                            command.CheckOnly = true;
                            await this.operCall(mprgCreator);
                            command.CheckOnly = false;
                            if (AccessHelper.eventsManager.getNextOperIdx(this, true) > -1)
                                isEndProg = false;
                        }
                        if (isEndProg) {
                            let destSubForm = this._task.getForm().getSubFormCtrlByName(this._subformCtrlName);
                            if (this._isRoute && (destSubForm === null || !destSubForm.IsRouterOutlet()))
                                return false;
                            if (destSubForm != null) {
                                if (this._isRoute) {
                                    let canRoute = false;
                                    let rtEvnt = AccessHelper.eventsManager.getLastRtEvent();
                                    if (rtEvnt !== null) {
                                        this._routeParams = rtEvnt.getRouteParamList();
                                        if ((await rtEvnt.getArgList().getArg(0).getValue(StorageAttribute.ALPHA, 0)).trim() === this._routerPath &&
                                            ((rtEvnt.getArgList().getArg(1).skipArg() && destSubForm === this._task.getForm().DefaultRouterOutlet) ||
                                                (!rtEvnt.getArgList().getArg(1).skipArg() && (await rtEvnt.getArgList().getArg(1).getValue(StorageAttribute.ALPHA, 0)).trim() === this._originalRouterOutletName)))
                                            canRoute = true;
                                        if (!canRoute)
                                            return false;
                                    }
                                }
                                subformTask = destSubForm.getSubformTask();
                                if (subformTask != null) {
                                    let terminateTaskGracefully = true;
                                    let rtEvnt = AccessHelper.eventsManager.getLastRtEvent();
                                    if (this._isRoute && rtEvnt !== null && rtEvnt.isGuiTriggeredEvent()) {
                                        terminateTaskGracefully = false;
                                        AccessHelper.eventsManager.setStopExecution(true, ClearEventsOnStopExecution.NONE);
                                    }
                                    if (await subformTask.endTask(true, false, !terminateTaskGracefully, true)) {
                                        let parentTask = destSubForm.getForm().getTask();
                                        parentTask.TaskService.RemoveRecomputes(parentTask);
                                    }
                                    else
                                        break;
                                }
                                if (LastFocusedManager.getLastFocusedControl() != null &&
                                    LastFocusedManager.getLastFocusedControl().isDescendentOfControl(destSubForm))
                                    this._task.RetainFocus = false;
                                else
                                    this._task.RetainFocus = await this._retainFocus.getVal();
                            }
                            await this.operCall(mprgCreator);
                        }
                    }
                    return this._isRoute;
                default:
                    Logger.Instance.WriteExceptionToLogWithMsg("There is no such type of operation " + this._type);
                    break;
            }
        }
        catch (ex) {
            throw ex;
        }
        return true;
    }
    operCallParallel() {
        Operation.callParallel();
    }
    static callParallel() {
    }
    async getCondVal() {
        return await this._condExp.getVal();
    }
    getType() {
        return this._type;
    }
    getRouteParams() {
        return this._routeParams;
    }
    getServerId() {
        return this._serverId;
    }
    async operVerify() {
        let isError = (this._mode === ConstInterface.FLW_VERIFY_MODE_ERROR);
        let textToDisplay = this._exp === null ? this._text : await this._exp.evaluateWithResultTypeAndLength(StorageAttribute.UNICODE, 255);
        let titleToDisplay = this._titleExp === null ? this._title : await this._titleExp.evaluateWithResultTypeAndLength(StorageAttribute.UNICODE, 255);
        textToDisplay = textToDisplay === null ? "" : StrUtil.rtrim(textToDisplay);
        titleToDisplay = titleToDisplay === null ? "" : StrUtil.rtrim(titleToDisplay);
        if (this._errLogAppend) {
            let prgDescription = this._task.GetContextTask().GetComputedProperty(PropInterface.PROP_TYPE_NAME).GetComputedValue();
            Logger.Instance.WriteExceptionToLogWithMsg(textToDisplay + ", program : " + prgDescription);
        }
        if (this._display === ConstInterface.DISPLAY_STATUS) {
            if (!NString.IsNullOrEmpty(textToDisplay)) {
                FlowMonitorQueue.Instance.addFlowVerifyInfo(textToDisplay, this._task.GetTaskDetails());
                this._task.GetContextTask().WriteToMessagePane(textToDisplay);
            }
        }
        else {
            if (!NString.IsNullOrEmpty(textToDisplay)) {
                let mlsTransTextToDisplay = LanguageData.Instance.translate(textToDisplay);
                let mlsTransTitleToDisplay = LanguageData.Instance.translate(titleToDisplay);
                let verifyMode = Operation.getButtons(this._buttons);
                verifyMode = verifyMode || Operation.getImage(this._image);
                verifyMode = verifyMode;
                if (UtilStrByteMode.isLocaleDefLangJPN()) {
                    let delimPos = mlsTransTextToDisplay.indexOf('|');
                    if (0 <= delimPos && delimPos < mlsTransTextToDisplay.length) {
                        mlsTransTitleToDisplay = mlsTransTextToDisplay.substr(delimPos + 1);
                        mlsTransTextToDisplay = mlsTransTextToDisplay.substr(0, delimPos);
                    }
                }
                let mgForm = null;
                if (!this._task.GetContextTask().getMGData().IsAborting)
                    mgForm = this._task.GetContextTask().getTopMostForm();
                if (mgForm == null && LastFocusedManager.Instance.getLastFocusedTask() != null)
                    mgForm = LastFocusedManager.Instance.getLastFocusedTask().getTopMostForm();
                if (mgForm != null) {
                    mgForm.RefreshUI();
                    Commands.invoke();
                    await Thread.Sleep(10);
                }
                let returnValue = await GUIManager.Instance.MessageBox(mlsTransTitleToDisplay, mlsTransTextToDisplay, verifyMode);
                await Operation.setoperVerifyReturnValue(returnValue, this._returnVal);
            }
        }
        return isError;
    }
    static getButtons(buttonsID) {
        let tmpbuttons = 0;
        switch (buttonsID) {
            case ConstInterface.BUTTONS_OK:
                tmpbuttons = Styles.MSGBOX_BUTTON_OK;
                break;
            case ConstInterface.BUTTONS_OK_CANCEL:
                tmpbuttons = Styles.MSGBOX_BUTTON_OK_CANCEL;
                break;
            case ConstInterface.BUTTONS_ABORT_RETRY_IGNORE:
                tmpbuttons = Styles.MSGBOX_BUTTON_ABORT_RETRY_IGNORE;
                break;
            case ConstInterface.BUTTONS_YES_NO_CANCEL:
                tmpbuttons = Styles.MSGBOX_BUTTON_YES_NO_CANCEL;
                break;
            case ConstInterface.BUTTONS_YES_NO:
                tmpbuttons = Styles.MSGBOX_BUTTON_YES_NO;
                break;
            case ConstInterface.BUTTONS_RETRY_CANCEL:
                tmpbuttons = Styles.MSGBOX_BUTTON_RETRY_CANCEL;
                break;
            default:
                break;
        }
        return tmpbuttons;
    }
    static getImage(imageID) {
        let tmpImage = 0;
        switch (imageID) {
            case ConstInterface.IMAGE_EXCLAMATION:
                tmpImage = Styles.MSGBOX_ICON_EXCLAMATION;
                break;
            case ConstInterface.IMAGE_CRITICAL:
                tmpImage = Styles.MSGBOX_ICON_ERROR;
                break;
            case ConstInterface.IMAGE_QUESTION:
                tmpImage = Styles.MSGBOX_ICON_QUESTION;
                break;
            case ConstInterface.IMAGE_INFORMATION:
                tmpImage = Styles.MSGBOX_ICON_INFORMATION;
                break;
            default:
                break;
        }
        return tmpImage;
    }
    static async setoperVerifyReturnValue(returnValue, returnVal) {
        if (returnVal !== null) {
            let retValueNum = new NUM_TYPE();
            retValueNum.NUM_4_LONG(returnValue);
            let returnValueStr = retValueNum.toXMLrecord();
            await returnVal.setValueAndStartRecompute(returnValueStr, false, true, true, false);
            await returnVal.updateDisplay();
        }
    }
    operBlock() {
        return true;
    }
    operElse() {
        return true;
    }
    async operEvaluate() {
        let result = '\0';
        if (this._field !== null) {
            result = await this._exp.evaluateWithResultTypeAndLength(this._field.getType(), this._field.getSize());
            await this._field.setValueAndStartRecompute(result, result === null, true, true, false);
            await this._field.updateDisplay();
        }
        else
            result = await this._exp.evaluateWithResultTypeAndLength(StorageAttribute.BOOLEAN, 0);
    }
    async operUpdate(mprgCreator) {
        let result, oldVal, newVal, fieldVal;
        let setRecordUpdated;
        let recompute;
        let nOld, nNew, nResult;
        let flowMonitor = FlowMonitorQueue.Instance;
        flowMonitor.addFlowOperationUpdate(FlowMonitorInterface.FLWMTR_START, this._task.GetTaskDetails());
        if (!this._field.DbModifiable && (this._task.getMode() !== Constants.TASK_MODE_CREATE)) {
            if (!await this.CanModify(mprgCreator))
                return;
        }
        let fieldType = this._field.getType();
        if (this._incremental) {
            if (!this._field.IsLinkField) {
                fieldVal = this._field.getValue(true);
                nResult = (fieldVal != null
                    ? new NUM_TYPE(fieldVal)
                    : null);
                if (this._task.getMode() !== Constants.TASK_MODE_CREATE) {
                    this._task.setEvalOldValues(true);
                    oldVal = (this._field.isNull()
                        ? this._field.getMagicDefaultValue()
                        : await this._exp.evaluateWithResultTypeAndLength(fieldType, this._field.getSize()));
                    this._task.setEvalOldValues(false);
                    nOld = new NUM_TYPE(oldVal);
                    nResult = NUM_TYPE.sub(nResult, nOld);
                }
                if (this._task.getMode() !== Constants.TASK_MODE_DELETE) {
                    newVal = await this._exp.evaluateWithResultTypeAndLength(fieldType, this._field.getSize());
                    if (newVal != null) {
                        nNew = new NUM_TYPE(newVal);
                        nResult = NUM_TYPE.add(nResult, nNew);
                    }
                    else
                        nNew = nResult = null;
                }
                if (nResult != null)
                    result = nResult.toXMLrecord();
                else
                    result = this._field.getMagicDefaultValue();
            }
            else {
                await this.operServer(mprgCreator);
                return;
            }
        }
        else
            result = await this._exp.evaluateWithResultTypeAndLength(fieldType, this._field.getSize());
        if (fieldType === StorageAttribute.BLOB_VECTOR)
            if (result != null)
                result = Operation.operUpdateVectors(this._field, result);
        recompute = (this._field.getTask() === this._task);
        setRecordUpdated = (!recompute || !this._undo);
        await this._field.setValueAndStartRecompute(result, result == null, true, setRecordUpdated, false);
        if (!this._undo)
            this._field.setUpdated();
        this._field.setModified();
        await this._field.updateDisplay();
        flowMonitor.addFlowOperationUpdate(FlowMonitorInterface.FLWMTR_END, this._task.GetTaskDetails());
    }
    async CanModify(mprgCreator) {
        let execOperCommand = ((this._cmdToServer instanceof ExecOperCommand) ? this._cmdToServer : null);
        execOperCommand.Operation = this;
        execOperCommand.MprgCreator = mprgCreator;
        return (await this.Task.DataviewManager.Execute(this._cmdToServer)).Success;
    }
    static operUpdateVectors(field, vec) {
        let result = null;
        if (field.getType() === StorageAttribute.BLOB_VECTOR) {
            let cellsAttr = VectorType.getCellsAttr(vec);
            let cellsType = field.getCellsType();
            if (StorageAttributeCheck.isTheSameType(cellsAttr, cellsType)) {
                let newVec = new VectorType(vec);
                newVec.adjustToFit(field);
                return newVec.toString();
            }
            return result;
        }
        throw new ApplicationException("in operUpdateVectors " + field.getName() + " is not of type vector");
    }
    async operRaiseEvent(mprgCreator, returnedFromServer) {
        let immediate = await this.Immediate();
        let aRtEvt = this._rtEvt.replicate();
        await aRtEvt.setPublicName();
        aRtEvt.setImmediate(immediate);
        aRtEvt.setMainPrgCreator(null);
        if (immediate) {
            aRtEvt.setCtrl(this._task.getLastParkedCtrl());
            aRtEvt.setArgList(this._argList);
            if (aRtEvt.getTask().isMainProg())
                aRtEvt.setMainPrgCreator(mprgCreator);
            AccessHelper.eventsManager.checkAndSaveRouteEventIfCtxRemovedFromSrvr(aRtEvt);
            AccessHelper.eventsManager.pushExecStack(this._task.getTaskTag(), this._evtHandler.getId().toString(), this._serverId);
            await AccessHelper.eventsManager.handleEvent(aRtEvt, returnedFromServer);
            AccessHelper.eventsManager.popExecStack();
        }
        else {
            let arglist = new ArgumentsList();
            await arglist.Initialize(this._argList);
            aRtEvt.setArgList(arglist);
            aRtEvt.setTask(null);
            AccessHelper.eventsManager.addToTail(aRtEvt);
            AccessHelper.eventsManager.checkAndSaveRouteEventIfCtxRemovedFromSrvr(aRtEvt);
        }
    }
    async operCall(mprgCreator) {
        await this.operServer(mprgCreator);
    }
    async operServer(mprgCreator) {
        let command = ((this._cmdToServer instanceof ExecOperCommand) ? this._cmdToServer : null);
        Debug.Assert(command !== null);
        if (this._task.isMainProg())
            command.MprgCreator = mprgCreator;
        else
            command.MprgCreator = null;
        command.SetExecutionStack(AccessHelper.eventsManager.getExecStack());
        command.Operation = this;
        await AccessHelper.mgDataTable.execRequestWithSubformRecordCycle(this._task.getMGData().CmdsToServer, this._cmdToServer, null);
    }
    getBlockEnd() {
        return this._blockEnd;
    }
    setBlockEnd(val) {
        this._blockEnd = val;
    }
    getBlockClose() {
        return this._blockClose;
    }
    setBlockClose(val) {
        this._blockClose = val;
    }
    getTaskTag() {
        return this._task.getTaskTag();
    }
    getHandlerId() {
        return this._evtHandler.getId().toString();
    }
    getEventHandler() {
        return this._evtHandler;
    }
    getExecOnServer() {
        return this._execOnServer;
    }
    setExecOnServer(val) {
        this._execOnServer = val;
    }
    getExecOnClient() {
        return this._execOnClient;
    }
    async canExecute() {
        return await this.getCondVal();
    }
    async AddFlowDescription(buffer) {
        switch (this._type) {
            case ConstInterface.MG_OPER_VERIFY:
                buffer.Append("Verify: ");
                if (this._exp == null)
                    buffer.Append(this._text);
                else
                    buffer.Append("Exp #").Append(this._exp.getId());
                break;
            case ConstInterface.MG_OPER_BLOCK:
                buffer.Append("Block If");
                break;
            case ConstInterface.MG_OPER_LOOP:
                buffer.Append("Block Loop");
                break;
            case ConstInterface.MG_OPER_ELSE:
                buffer.Append("Block Else");
                break;
            case ConstInterface.MG_OPER_EVALUATE:
                buffer.Append("Evaluate Exp #").Append(this._exp.getId());
                break;
            case ConstInterface.MG_OPER_UPDATE:
                buffer.AppendFormat("Update {0} with Exp #{1}", this._field.getVarName(), this._exp.getId());
                break;
            case ConstInterface.MG_OPER_ENDBLOCK:
                buffer.Append("End Block");
                break;
            case ConstInterface.MG_OPER_USR_EXIT:
                buffer.Append("Invoke OS");
                break;
            case ConstInterface.MG_OPER_RAISE_EVENT:
                buffer.Append("Raise Event:");
                this._rtEvt.AppendDescription(buffer);
                buffer.AppendFormat(" (Wait={0})", (await this.Immediate() ? 'Y' : 'N'));
                break;
            case ConstInterface.MG_OPER_SERVER:
                buffer.Append("Run server-side operation");
                break;
            case ConstInterface.MG_OPER_CALL:
                buffer.Append("Call program");
                break;
            default:
                buffer.AppendFormat("<<Unknown Operation Code {0}>>", this._type);
                break;
        }
    }
    GetArgList() {
        return this._argList;
    }
    GetReturnValueField() {
        return this._field;
    }
    GetSubformControlName() {
        return this._subformCtrlName;
    }
    toString() {
        return NString.Format("Executing operation number {0}", this._serverId + 1);
    }
    GetRuntimeEvent() {
        return this._rtEvt;
    }
}

class MirrorString {
    constructor(s) {
        this._reserved = false;
        this._value = null;
        if (arguments.length === 0) {
            this.constructor_0();
            return;
        }
        this.constructor_1(s);
    }
    constructor_0() {
        this._reserved = false;
    }
    constructor_1(s) {
        this._value = s;
        this._reserved = false;
    }
    mirrorToXML() {
        return ConstInterface.MG_ATTR_ENV_VALUE + "=\"" + XmlParser.escape(this._value) + "\"";
    }
    init(name, xmlParser) {
        let valueStart, valueEnd, reserveStart, paramEnd;
        let xmlData = xmlParser.getXMLdata();
        let valueAttr = ConstInterface.MG_ATTR_ENV_VALUE + "=\"";
        paramEnd = xmlData.indexOf("/>", xmlParser.getCurrIndex());
        valueStart = NString.IndexOf(xmlData, valueAttr, xmlParser.getCurrIndex(), paramEnd - xmlParser.getCurrIndex());
        if (valueStart !== -1) {
            valueStart += valueAttr.length;
            reserveStart = NString.IndexOf(xmlData, ConstInterface.MG_ATTR_ENV_RESERVED + "=\"", xmlParser.getCurrIndex(), paramEnd - xmlParser.getCurrIndex());
            valueEnd = reserveStart !== -1
                ? xmlData.indexOf(ConstInterface.MG_ATTR_ENV_RESERVED + "=\"", valueStart) - 2
                : paramEnd - 1;
            this._value = xmlData.substr(valueStart, valueEnd - valueStart).trim();
            if (reserveStart !== -1) {
                reserveStart += ConstInterface.MG_ATTR_ENV_RESERVED.length + 2;
                this._reserved = (xmlData[reserveStart] === 'Y');
            }
            else
                this._reserved = false;
            xmlParser.setCurrIndex(valueEnd);
            if (name.startsWith(ConstInterface.INI_SECTION_LOGICAL_NAMES_BRACKETS))
                return ParamParseResult.OK;
            else
                return ParamParseResult.TOUPPER;
        }
        else if (NString.IndexOf(xmlData, ConstInterface.MG_ATTR_ENV_REMOVED, xmlParser.getCurrIndex(), paramEnd - xmlParser.getCurrIndex()) !== -1) {
            return ParamParseResult.DELETE;
        }
        else {
            Debug.Assert(false, "bad XML parsing");
            return ParamParseResult.FAILED;
        }
    }
    ToString() {
        return this._value;
    }
    isReserved() {
        return this._reserved;
    }
}

class EnvParamsTable extends MirrorPrmMap {
    constructor() {
        super(MirrorString);
        this.mirroredID = ConstInterface.MG_TAG_ENV_PARAM;
    }
    get(s) {
        let valName = null;
        let ret = null;
        if (s.charAt(0) !== '[') {
            valName = s;
            s = NString.Insert(s, 0, ConstInterface.INI_SECTION_MAGIC_ENV_BRACKETS);
        }
        else if (s.startsWith(ConstInterface.INI_SECTION_MAGIC_ENV_BRACKETS))
            valName = s.substr(ConstInterface.INI_SECTION_MAGIC_ENV_BRACKETS.length);
        if (!s.startsWith(ConstInterface.INI_SECTION_LOGICAL_NAMES_BRACKETS))
            s = s.toUpperCase();
        if (valName !== null)
            ret = this.getFromEnvironment(valName);
        if (ret !== null)
            return ret;
        try {
            let resultObject = super.getvalue(s);
            if (resultObject !== null) {
                ret = resultObject.ToString();
                if (valName !== null) {
                    ret = this.getProcessedValue(valName, ret);
                }
            }
        }
        catch (ex_BE) {
        }
        return ret;
    }
    getln(section, number) {
        section = section.toUpperCase().trim();
        let sectionFound = false;
        let keys = this.values.Keys;
        for (let i = 0; i < keys.length; i++) {
            let key = keys[i];
            if (key.startsWith(section)) {
                sectionFound = true;
                if (number > 1)
                    number--;
                else
                    return key.substr(section.length) + "=" + this.values.get_Item(key);
            }
            else if (sectionFound)
                break;
        }
        return null;
    }
    getFromEnvironment(valName) {
        switch (valName.toLowerCase()) {
            case ConstInterface.MG_ATTR_DECIMAL_SEPARATOR:
                return Environment.Instance.GetDecimal();
            case ConstInterface.MG_ATTR_DATE:
                return DisplayConvertor.Instance.getDateChar().toString();
            case ConstInterface.MG_ATTR_TIME:
                return Environment.Instance.GetTime();
            case ConstInterface.MG_ATTR_OWNER:
                return Environment.Instance.getOwner();
            case ConstInterface.MG_ATTR_DATEMODE:
                return Environment.Instance.GetDateMode(LastFocusedManager.Instance.getCurrTask().getCompIdx());
            case ConstInterface.MG_ATTR_CENTURY:
                return Environment.Instance.GetCentury(LastFocusedManager.Instance.getCurrTask().getCompIdx()).toString();
            case ConstInterface.MG_ATTR_IDLETIME:
                return Environment.Instance.getIdleTime(LastFocusedManager.Instance.getCurrTask().getCompIdx()).toString();
            case ConstInterface.MG_ATTR_UPD_IN_QUERY:
                return Environment.Instance.allowUpdateInQueryMode(LastFocusedManager.Instance.getCurrTask().getCompIdx()).toString();
            case ConstInterface.MG_ATTR_CRE_IN_MODIFY:
                return Environment.Instance.allowCreateInModifyMode(LastFocusedManager.Instance.getCurrTask().getCompIdx()).toString();
            case ConstInterface.MG_ATTR_CONTEXT_INACTIVITY_TIMEOUT:
                return Environment.Instance.getContextInactivityTimeout().toString();
            case ConstInterface.MG_ATTR_CONTEXT_UNLOAD_TIMEOUT:
                return Environment.Instance.getContextUnloadTimeout().toString();
            case ConstInterface.MG_ATTR_TERMINAL:
                return Environment.Instance.getTerminal().toString();
            case ConstInterface.MG_ATTR_WEBCLIENT_REINIT_SESSION:
                return Environment.Instance.getWebClientReinitSession();
        }
        return null;
    }
    getProcessedValue(valName, val) {
        switch (valName.toLowerCase()) {
            case ConstInterface.MG_ATTR_HTTP_TIMEOUT:
            case ConstInterface.MG_ATTR_RTF_BUFFER_SIZE:
            case ConstInterface.MG_ATTR_RANGE_POP_TIME:
            case ConstInterface.MG_ATTR_TEMP_POP_TIME:
            case ConstInterface.MG_ATTR_BATCH_PAINT_TIME:
                return NNumber.Parse(val).toString();
            case ConstInterface.MG_ATTR_USE_SIGNED_BROWSER_CLIENT:
            case ConstInterface.MG_ATTR_CLOSE_PRINTED_TABLES_IN_SUBTASKS:
            case ConstInterface.MG_ATTR_GENERIC_TEXT_PRINTING:
            case ConstInterface.MG_ATTR_HIGH_RESOLUTION_PRINT:
            case ConstInterface.MG_ATTR_MERGE_TRIM:
            case ConstInterface.MG_ATTR_ORIGINAL_IMAGE_LOAD:
            case ConstInterface.MG_ATTR_PRINT_DATA_TRIM:
            case ConstInterface.MG_ATTR_PSCRIPT_PRINT_NT:
            case ConstInterface.MG_ATTR_SPECIAL_CONV_ADD_SLASH:
            case ConstInterface.MG_ATTR_SPECIAL_FULL_EXPAND_PRINT:
            case ConstInterface.MG_ATTR_SPECIAL_FULL_TEXT:
            case ConstInterface.MG_ATTR_SPECIAL_LAST_LINE_PRINT:
            case ConstInterface.MG_ATTR_SPECIAL_PRINTER_OEM:
            case ConstInterface.MG_ATTR_EMBED_FONTS:
            case ConstInterface.MG_ATTR_CENTER_SCREEN_IN_ONLINE:
            case ConstInterface.MG_ATTR_REPOSITION_AFTER_MODIFY:
            case ConstInterface.MG_ATTR_ISAM_TRANSACTION:
                return (val[0] === 'Y' || val[0] === '1') ? "Y" : "N";
            case ConstInterface.MG_ATTR_TIME_SEPARATOR:
            case ConstInterface.MG_ATTR_IOTIMING:
            case ConstInterface.MG_ATTR_THOUSAND_SEPARATOR:
                return val[0].toString();
            default:
                return val;
        }
    }
    async set(s, updateIni) {
        let allOK = true;
        let sendToServer = false;
        let name, val;
        let i;
        let serverVal = s;
        let offsets = new Array(s.length + 1);
        let offsetsChars = new Array(s.length + 1);
        offsets[0] = 0;
        offsetsChars[0] = 's';
        let nextOffset = 1;
        for (i = 1; i < s.length; i++) {
            if ((s[i] === '=' || s[i] === ',') && s[i - 1] !== '\\') {
                offsets[nextOffset] = i + 1;
                offsetsChars[nextOffset] = s[i];
                nextOffset++;
            }
            if (s[i] === '*') {
                s = NString.Remove(s, i, 1);
                break;
            }
            if (s[i] === '\\') {
                s = NString.Remove(s, i, 1);
            }
        }
        offsets[nextOffset] = s.length + 1;
        offsetsChars[nextOffset] = '\0';
        nextOffset++;
        for (i = 0; i < nextOffset - 1; i++) {
            name = s.substr(offsets[i], offsets[i + 1] - offsets[i] - 1);
            if (s[offsets[i + 1] - 1] === '=') {
                i++;
                let valInit = i;
                let allowedSeparators = this.getAllowedSeparators(name);
                for (let sep = 0; sep < allowedSeparators; sep++) {
                    if (offsetsChars[i + 1] === ',')
                        i++;
                    else
                        break;
                }
                val = s.substr(offsets[valInit], offsets[i + 1] - offsets[valInit] - 1);
            }
            else
                val = null;
            if (this.isReservedLogicalName(name)) {
                allOK = false;
                continue;
            }
            if (name[0] !== '[')
                name = NString.Insert(name, 0, ConstInterface.INI_SECTION_MAGIC_ENV_BRACKETS);
            if (!name.startsWith(ConstInterface.INI_SECTION_LOGICAL_NAMES_BRACKETS))
                name = name.toUpperCase();
            name = name.trim();
            val = val.trim();
            sendToServer = true;
            if (!NString.IsNullOrEmpty(val) ||
                name.startsWith(ConstInterface.INI_SECTION_LOGICAL_NAMES_BRACKETS)) {
                super.setValue(name, new MirrorString(val), !updateIni);
                this.checkSetInEnvironment(name, val);
            }
            else
                super.remove(name);
        }
        if (updateIni && sendToServer) {
            let cmd = CommandFactory.CreateIniputForceWriteCommand(serverVal);
            AccessHelper.mgDataTable.getMGData(0).CmdsToServer.Add(cmd);
            await RemoteCommandsProcessor.GetInstance().Execute(CommandsProcessorBase_SendingInstruction.ONLY_COMMANDS);
        }
        return allOK;
    }
    isReservedLogicalName(name) {
        if (!name.startsWith("[")) {
            name = NString.Insert(name, 0, ConstInterface.INI_SECTION_LOGICAL_NAMES_BRACKETS);
            if (this.values.ContainsKey(name) && this.values.get_Item(name).isReserved())
                return true;
        }
        return false;
    }
    getAllowedSeparators(name) {
        if (name.charAt(0) !== '[')
            return 0;
        let section = name.substr(1, name.indexOf(']') - 1);
        let param = name.substr(name.indexOf(']') + 1);
        switch (section.toUpperCase()) {
            case ConstInterface.INI_SECTION_MAGIC_ENV:
                if (param.toUpperCase() === ConstInterface.MG_ATTR_LANGUAGE.toUpperCase())
                    return 999;
                else
                    return 0;
            case ConstInterface.INI_SECTION_MAGIC_SYSTEMS:
                return 8;
            case ConstInterface.INI_SECTION_MAGIC_DBMS:
                return 13;
            case ConstInterface.INI_SECTION_MAGIC_SERVERS:
                return 6;
            case ConstInterface.INI_SECTION_MAGIC_COMMS:
                return 2;
            case ConstInterface.INI_SECTION_MAGIC_PRINTERS:
                return 3;
            case ConstInterface.INI_SECTION_MAGIC_SYSTEM_MENU:
                return 11;
            case ConstInterface.INI_SECTION_MAGIC_DATABASES:
                return 21;
            case ConstInterface.INI_SECTION_MAGIC_LANGUAGE:
                return 1;
            case ConstInterface.INI_SECTION_MAGIC_SERVICES:
                return 8;
            case ConstInterface.INI_SECTION_TOOLS_MENU:
                return 7;
            default:
                return 0;
        }
    }
    checkSetInEnvironment(name, val) {
        if (name.startsWith(ConstInterface.INI_SECTION_MAGIC_ENV_BRACKETS)) {
            name = name.substr(ConstInterface.INI_SECTION_MAGIC_ENV_BRACKETS.length);
            switch (name.toLowerCase()) {
                case ConstInterface.MG_ATTR_DECIMAL_SEPARATOR:
                    Environment.Instance.setDecimalSeparator(val[0]);
                    break;
                case ConstInterface.MG_ATTR_DATE:
                    DisplayConvertor.Instance.setDateChar(val[0].charCodeAt(0));
                    break;
                case ConstInterface.MG_ATTR_TIME:
                    Environment.Instance.setTimeSeparator(val[0]);
                    break;
                case ConstInterface.MG_ATTR_OWNER:
                    Environment.Instance.setOwner(val);
                    break;
                case ConstInterface.MG_ATTR_DATEMODE:
                    Environment.Instance.setDateMode(LastFocusedManager.Instance.getCurrTask().getCompIdx(), val[0]);
                    break;
                case ConstInterface.MG_ATTR_CENTURY:
                    Environment.Instance.setCentury(LastFocusedManager.Instance.getCurrTask().getCompIdx(), NNumber.Parse(val));
                    break;
                case ConstInterface.MG_ATTR_IDLETIME:
                    Environment.Instance.setIdleTime(LastFocusedManager.Instance.getCurrTask().getCompIdx(), NNumber.Parse(val));
                    break;
                case ConstInterface.MG_ATTR_UPD_IN_QUERY_LOWER:
                    Environment.Instance.setAllowUpdateInQueryMode(LastFocusedManager.Instance.getCurrTask().getCompIdx(), val[0] === '1');
                    break;
                case ConstInterface.MG_ATTR_CRE_IN_MODIFY_LOWER:
                    Environment.Instance.setAllowCreateInModifyMode(LastFocusedManager.Instance.getCurrTask().getCompIdx(), val[0] === '1');
                    break;
                case ConstInterface.MG_ATTR_CONTEXT_INACTIVITY_TIMEOUT_LOWER:
                    Environment.Instance.setContextInactivityTimeout(NNumber.Parse(val));
                    break;
                case ConstInterface.MG_ATTR_CONTEXT_INACTIVITY_WARNING_TIME_LOWER:
                    Environment.Instance.setContextInactivityWarningTime(NNumber.Parse(val));
                    break;
                case ConstInterface.MG_ATTR_CONTEXT_UNLOAD_TIMEOUT_LOWER:
                    Environment.Instance.setContextUnloadTimeout(NNumber.Parse(val));
                    break;
                case ConstInterface.MG_ATTR_TERMINAL:
                    Environment.Instance.setTerminal(NNumber.Parse(val));
                    break;
            }
        }
    }
    translate(logicalName) {
        let stringBuilder = new StringBuilder(logicalName);
        this.log(stringBuilder);
        return stringBuilder.ToString();
    }
    log(stringBldr) {
        let finished;
        do {
            let offset = 0;
            finished = true;
            while (offset < stringBldr.Length && stringBldr.get_Item(offset) > '\0') {
                if (stringBldr.get_Item(offset) === '%') {
                    let oldLength = stringBldr.Length;
                    offset = this.log_trans(stringBldr, offset);
                    if (oldLength !== stringBldr.Length)
                        finished = false;
                }
                else
                    offset = offset + 1;
            }
        } while (!finished);
    }
    log_trans(stringBldr, offset) {
        let ignoreTrans = false;
        let startSym = offset;
        let endSym = offset + 1;
        while (endSym < stringBldr.Length) {
            if (stringBldr.get_Item(endSym) === '%')
                break;
            endSym++;
        }
        if (endSym >= stringBldr.Length) {
            offset = endSym;
            ignoreTrans = true;
        }
        else if (stringBldr.get_Item(endSym) !== '%')
            offset++;
        if (!ignoreTrans) {
            let sym = ConstInterface.INI_SECTION_LOGICAL_NAMES_BRACKETS +
                stringBldr.ToString(startSym + 1, endSym - startSym - 1);
            let trans = this.get(sym);
            if (trans === null) {
                stringBldr.Replace(stringBldr.ToString(offset, endSym + 1 - offset), "", offset, endSym + 1 - offset);
                offset += 1;
            }
            else {
                stringBldr.Replace(stringBldr.ToString(startSym, endSym + 1 - startSym), trans, startSym, endSym + 1 - startSym);
            }
        }
        return offset;
    }
}
EnvParamsTable.Instance = new EnvParamsTable();

class CookieService {
    static getCookies(cookieName) {
        if (cookieName == '*')
            return document.cookie;
        return this.getCookie(cookieName);
    }
    static setCookie(name, value, expires, path, domain, secure, sameSite) {
        let cookieString = encodeURIComponent(name) + '=' + encodeURIComponent(CookieService.encode_cookie(value)) + ';';
        if (expires) {
            if (typeof expires === 'number') {
                const dateExpires = new Date(expires);
                cookieString += 'expires=' + dateExpires.toUTCString() + ';';
            }
            else if ((typeof expires === 'string')) {
                const dateExpires = new Date(expires);
                cookieString += 'expires=' + dateExpires.toUTCString() + ';';
            }
            else {
                cookieString += 'expires=' + expires.toUTCString() + ';';
            }
        }
        if (path) {
            cookieString += 'path=' + path + ';';
        }
        if (domain) {
            cookieString += 'domain=' + domain + ';';
        }
        if (secure === false && sameSite === 'None') {
            secure = true;
            console.warn(`cookie ${name} was forced with secure flag because sameSite=None.`);
        }
        if (secure) {
            cookieString += 'secure;';
        }
        if (!sameSite) {
            sameSite = 'Lax';
        }
        cookieString += 'sameSite=' + sameSite + ';';
        document.cookie = cookieString;
        return this.getCookie(name);
    }
    static encode_cookie(cookie_value) {
        cookie_value = cookie_value.trim();
        var coded_string = '';
        for (var counter = 0; counter < cookie_value.length; counter++) {
            coded_string += cookie_value.charCodeAt(counter);
            if (counter < cookie_value.length - 1) {
                coded_string += '+';
            }
        }
        return coded_string;
    }
    static decode_cookie(coded_string) {
        var cookie_value = '';
        var code_array = coded_string.split('+');
        for (var counter = 0; counter < code_array.length; counter++) {
            cookie_value += String.fromCharCode(code_array[counter]);
        }
        return cookie_value;
    }
    static getCookie(cookieName) {
        let name = NString.TrimStart(cookieName + '=');
        let decodedCookie = decodeURIComponent(document.cookie);
        let ca = decodedCookie.split(';');
        for (let i = 0; i < ca.length; i++) {
            let c = ca[i];
            while (c.charAt(0) == ' ') {
                c = c.substring(1);
            }
            if (c.indexOf(name) >= 0) {
                let decode = CookieService.decode_cookie(c.substring(name.length, c.length));
                return decode;
            }
        }
        return '';
    }
    static deleteCookie(cookieName) {
        var cookies = document.cookie.split(';');
        for (var i = 0; i < cookies.length; i++) {
            var cookie = cookies[i];
            var eqPos = cookie.indexOf('=');
            var name = eqPos > -1 ? cookie.substr(0, eqPos) : cookie;
            if (cookieName === NString.TrimStart(decodeURI(name))) {
                document.cookie = name + '=;expires=Thu, 01 Jan 1970 00:00:00 GMT';
                return true;
            }
        }
        return false;
    }
}

class ExpressionEvaluator extends GuiExpressionEvaluator {
    constructor() {
        super();
        this._charsToTrim = [' ', '\0'];
        this._expressionLocalJpn = null;
        this._expressionLocalJpn = (UtilStrByteMode.isLocaleDefLangJPN() ? new ExpressionLocalJpn(this) : null);
    }
    getExpBasicValue(expStrTracker, opCode) {
        let Val = new ExpVal();
        let len;
        let parent, vee;
        let field;
        let fldVal;
        switch (opCode) {
            case ExpressionInterface.EXP_OP_A:
            case ExpressionInterface.EXP_OP_H:
                Val.Attr = StorageAttribute.UNICODE;
                len = expStrTracker.get4ByteNumber();
                Val.StrVal = expStrTracker.getString(len, true, true);
                len = expStrTracker.get4ByteNumber();
                expStrTracker.getString(len, true, false);
                break;
            case ExpressionInterface.EXP_OP_EXT_A:
                Val.Attr = StorageAttribute.ALPHA;
                len = expStrTracker.get4ByteNumber();
                expStrTracker.getString(len, true, true);
                len = expStrTracker.get4ByteNumber();
                Val.StrVal = expStrTracker.getString(len, true, false);
                break;
            case ExpressionInterface.EXP_OP_N:
            case ExpressionInterface.EXP_OP_T:
            case ExpressionInterface.EXP_OP_D:
            case ExpressionInterface.EXP_OP_E:
                if (opCode === ExpressionInterface.EXP_OP_D)
                    Val.Attr = StorageAttribute.DATE;
                else if (opCode === ExpressionInterface.EXP_OP_T)
                    Val.Attr = StorageAttribute.TIME;
                else
                    Val.Attr = StorageAttribute.NUMERIC;
                len = expStrTracker.get2ByteNumber();
                Val.MgNumVal = expStrTracker.getMagicNumber(len, true);
                break;
            case ExpressionInterface.EXP_OP_L:
                Val.Attr = StorageAttribute.BOOLEAN;
                Val.BoolVal = (expStrTracker.get2ByteNumber() === 1);
                break;
            case ExpressionInterface.EXP_OP_V:
                parent = expStrTracker.getVarIdx();
                vee = expStrTracker.get4ByteNumber();
                field = this.ExpTask.getFieldDef(parent, vee - 1);
                Val.Attr = field.getType();
                let nullAllowed = (field.getType() === StorageAttribute.BLOB_VECTOR)
                    ? true
                    : field.NullAllowed;
                Val.IsNull = field.isNull() && nullAllowed;
                Val.OriginalNull = Val.IsNull;
                fldVal = field.getValue(true);
                if (fldVal != null && Val.IsNull &&
                    field.getTask().getNullArithmetic() === Constants.NULL_ARITH_USE_DEF)
                    Val.IsNull = false;
                switch (Val.Attr) {
                    case StorageAttribute.ALPHA:
                    case StorageAttribute.UNICODE:
                        Val.StrVal = fldVal;
                        break;
                    case StorageAttribute.BLOB_VECTOR:
                        Val.VectorField = field;
                    case StorageAttribute.BLOB:
                        Val.StrVal = fldVal;
                        if (Val.StrVal == null) {
                            Val.IsNull = true;
                            Val.IncludeBlobPrefix = false;
                        }
                        else
                            Val.IncludeBlobPrefix = true;
                        break;
                    case StorageAttribute.NUMERIC:
                    case StorageAttribute.DATE:
                    case StorageAttribute.TIME:
                        Val.MgNumVal = fldVal != null ? new NUM_TYPE(fldVal) : null;
                        break;
                    case StorageAttribute.BOOLEAN:
                        if (fldVal != null)
                            Val.BoolVal = DisplayConvertor.toBoolean(fldVal);
                        break;
                }
                break;
            case ExpressionInterface.EXP_OP_FORM:
                parent = expStrTracker.getVarIdx();
                let formDisplayIndexInTask = expStrTracker.get4ByteNumber();
                formDisplayIndexInTask = this.ExpTask.GetRealMainDisplayIndexOnDepth(formDisplayIndexInTask);
                this.ConstructMagicNum(Val, formDisplayIndexInTask, StorageAttribute.NUMERIC);
                break;
            case ExpressionInterface.EXP_OP_VAR:
                parent = expStrTracker.getVarIdx();
                vee = expStrTracker.get4ByteNumber();
                let itm = this.ExpTask.ctl_itm_4_parent_vee(parent, vee);
                this.ConstructMagicNum(Val, itm, StorageAttribute.NUMERIC);
                break;
            case ExpressionInterface.EXP_OP_RIGHT_LITERAL:
                len = expStrTracker.get2ByteNumber();
                Val.MgNumVal = expStrTracker.getMagicNumber(len, true);
                len = expStrTracker.get2ByteNumber();
                Val.Attr = StorageAttribute.NUMERIC;
                expStrTracker.getString(len, true, false);
                break;
        }
        return Val;
    }
    static isBasicItem(opCode) {
        return (opCode <= ExpressionInterface.EXP_OP_L ||
            opCode === ExpressionInterface.EXP_OP_EXT_A ||
            opCode === ExpressionInterface.EXP_OP_RIGHT_LITERAL ||
            opCode === ExpressionInterface.EXP_OP_E ||
            opCode === ExpressionInterface.EXP_OP_FORM);
    }
    static isVarArgList(expDesc) {
        if (expDesc.ArgCount_ < 0 || expDesc.ArgAttr_.length > expDesc.ArgCount_)
            return true;
        return false;
    }
    async execOperation(opCode, expStrTracker, valStack, addedOpers, expectedType) {
        let val1;
        let val2;
        let val3;
        let val4;
        let val5;
        let val6;
        let val7;
        let val8;
        let dynOper = new DynamicOperation();
        let whole;
        let dec;
        let resVal = new ExpVal();
        let Exp_params;
        let addResult = true;
        let nArgs;
        let specialAnsiExpression = Environment.Instance.getSpecialAnsiExpression();
        let ofs, len, LenMax, j = 0;
        let pic;
        let expDesc = ExpressionDict.expDesc[opCode];
        if (ExpressionEvaluator.isVarArgList(expDesc)) {
            nArgs = expStrTracker.get1ByteNumber();
            for (j = 0; j < nArgs; j++) {
                try {
                    await this.execExpression(expStrTracker, valStack, StorageAttribute.NONE);
                }
                catch (exception) {
                    if (exception instanceof Exception) {
                        break;
                    }
                    else
                        throw exception;
                }
            }
            if (ExpressionEvaluator.isVarArgList(expDesc) && j === nArgs) {
                let temp_object = nArgs;
                valStack.push(temp_object);
            }
            else
                Logger.Instance.WriteExceptionToLogWithMsg('ExpressionEvaluator.execOperation() there is problem with arguments of ' +
                    opCode + '(see ExpressionDict for name)');
        }
        switch (opCode) {
            case ExpressionInterface.EXP_OP_ADD:
                val2 = valStack.pop();
                val1 = valStack.pop();
                resVal.MgNumVal = NUM_TYPE.add(val1.MgNumVal, val2.MgNumVal);
                resVal.Attr = StorageAttribute.NUMERIC;
                resVal.IsNull = (resVal.MgNumVal == null);
                break;
            case ExpressionInterface.EXP_OP_SUB:
                val2 = valStack.pop();
                val1 = valStack.pop();
                resVal.MgNumVal = NUM_TYPE.sub(val1.MgNumVal, val2.MgNumVal);
                resVal.Attr = StorageAttribute.NUMERIC;
                resVal.IsNull = (resVal.MgNumVal == null);
                break;
            case ExpressionInterface.EXP_OP_MUL:
                val2 = valStack.pop();
                val1 = valStack.pop();
                resVal.MgNumVal = NUM_TYPE.mul(val1.MgNumVal, val2.MgNumVal);
                resVal.Attr = StorageAttribute.NUMERIC;
                resVal.IsNull = (resVal.MgNumVal == null);
                break;
            case ExpressionInterface.EXP_OP_DIV:
                val2 = valStack.pop();
                val1 = valStack.pop();
                resVal.MgNumVal = NUM_TYPE.div(val1.MgNumVal, val2.MgNumVal);
                resVal.Attr = StorageAttribute.NUMERIC;
                resVal.IsNull = (resVal.MgNumVal == null);
                break;
            case ExpressionInterface.EXP_OP_MOD:
                val2 = valStack.pop();
                val1 = valStack.pop();
                resVal.MgNumVal = NUM_TYPE.mod(val1.MgNumVal, val2.MgNumVal);
                resVal.Attr = StorageAttribute.NUMERIC;
                resVal.IsNull = (resVal.MgNumVal == null);
                break;
            case ExpressionInterface.EXP_OP_NEG:
                val1 = valStack.pop();
                resVal.Attr = StorageAttribute.NUMERIC;
                if (val1.MgNumVal == null) {
                    super.SetNULL(resVal, StorageAttribute.NUMERIC);
                    break;
                }
                val1.MgNumVal.num_neg();
                resVal.MgNumVal = new NUM_TYPE(val1.MgNumVal);
                break;
            case ExpressionInterface.EXP_OP_FIX:
                val3 = valStack.pop();
                val2 = valStack.pop();
                val1 = valStack.pop();
                resVal.Attr = StorageAttribute.NUMERIC;
                if (val1.MgNumVal == null || val2.MgNumVal == null || val3.MgNumVal == null) {
                    super.SetNULL(resVal, StorageAttribute.NUMERIC);
                    break;
                }
                resVal.MgNumVal = new NUM_TYPE(val1.MgNumVal);
                whole = val2.MgNumVal.NUM_2_LONG();
                resVal.MgNumVal.num_fix(whole);
                dec = val3.MgNumVal.NUM_2_LONG();
                resVal.MgNumVal.num_trunc(dec);
                break;
            case ExpressionInterface.EXP_OP_ROUND:
                val3 = valStack.pop();
                val2 = valStack.pop();
                val1 = valStack.pop();
                resVal.Attr = StorageAttribute.NUMERIC;
                if (val1.MgNumVal == null || val2.MgNumVal == null || val3.MgNumVal == null) {
                    super.SetNULL(resVal, StorageAttribute.NUMERIC);
                    break;
                }
                resVal.MgNumVal = new NUM_TYPE(val1.MgNumVal);
                whole = val2.MgNumVal.NUM_2_LONG();
                resVal.MgNumVal.num_fix(whole);
                dec = val3.MgNumVal.NUM_2_LONG();
                resVal.MgNumVal.round(dec);
                break;
            case ExpressionInterface.EXP_OP_EQ:
                val2 = valStack.pop();
                val1 = valStack.pop();
                resVal.Attr = StorageAttribute.BOOLEAN;
                try {
                    resVal.BoolVal = (ExpressionEvaluator.val_cmp_any(val1, val2) === 0);
                }
                catch (nullValueException) {
                    if (nullValueException instanceof NullValueException) {
                        resVal.BoolVal = false;
                    }
                    else
                        throw nullValueException;
                }
                expStrTracker.resetNullResult();
                break;
            case ExpressionInterface.EXP_OP_NE:
                val2 = valStack.pop();
                val1 = valStack.pop();
                resVal.Attr = StorageAttribute.BOOLEAN;
                try {
                    resVal.BoolVal = (ExpressionEvaluator.val_cmp_any(val1, val2) !== 0);
                }
                catch (nullValueException) {
                    if (nullValueException instanceof NullValueException) {
                        super.SetNULL(resVal, StorageAttribute.BOOLEAN);
                    }
                    else
                        throw nullValueException;
                }
                break;
            case ExpressionInterface.EXP_OP_LE:
                val2 = valStack.pop();
                val1 = valStack.pop();
                resVal.Attr = StorageAttribute.BOOLEAN;
                try {
                    resVal.BoolVal = (ExpressionEvaluator.val_cmp_any(val1, val2) <= 0);
                }
                catch (nullValueException) {
                    if (nullValueException instanceof NullValueException) {
                        super.SetNULL(resVal, StorageAttribute.BOOLEAN);
                    }
                    else
                        throw nullValueException;
                }
                break;
            case ExpressionInterface.EXP_OP_LT:
                val2 = valStack.pop();
                val1 = valStack.pop();
                resVal.Attr = StorageAttribute.BOOLEAN;
                try {
                    resVal.BoolVal = (ExpressionEvaluator.val_cmp_any(val1, val2) < 0);
                }
                catch (nullValueException) {
                    if (nullValueException instanceof NullValueException) {
                        super.SetNULL(resVal, StorageAttribute.BOOLEAN);
                    }
                    else
                        throw nullValueException;
                }
                break;
            case ExpressionInterface.EXP_OP_GE:
                val2 = valStack.pop();
                val1 = valStack.pop();
                resVal.Attr = StorageAttribute.BOOLEAN;
                try {
                    resVal.BoolVal = (ExpressionEvaluator.val_cmp_any(val1, val2) >= 0);
                }
                catch (nullValueException) {
                    if (nullValueException instanceof NullValueException) {
                        super.SetNULL(resVal, StorageAttribute.BOOLEAN);
                    }
                    else
                        throw nullValueException;
                }
                break;
            case ExpressionInterface.EXP_OP_GT:
                val2 = valStack.pop();
                val1 = valStack.pop();
                resVal.Attr = StorageAttribute.BOOLEAN;
                try {
                    resVal.BoolVal = (ExpressionEvaluator.val_cmp_any(val1, val2) > 0);
                }
                catch (nullValueException) {
                    if (nullValueException instanceof NullValueException) {
                        super.SetNULL(resVal, StorageAttribute.BOOLEAN);
                    }
                    else
                        throw nullValueException;
                }
                break;
            case ExpressionInterface.EXP_OP_NOT:
                resVal = valStack.pop();
                resVal.BoolVal = !resVal.BoolVal;
                break;
            case ExpressionInterface.EXP_OP_OR:
                resVal = valStack.pop();
                dynOper = new DynamicOperation();
                dynOper.argCount_ = 1;
                if (resVal.BoolVal) {
                    dynOper.opCode_ = ExpressionInterface.EXP_OP_IGNORE;
                    dynOper.argCount_ = 1;
                    addedOpers.push(dynOper);
                }
                else {
                    dynOper.opCode_ = ExpressionInterface.EXP_OP_EVALX;
                    dynOper.argCount_ = 0;
                    addedOpers.push(dynOper);
                    addResult = false;
                }
                break;
            case ExpressionInterface.EXP_OP_AND:
                resVal = valStack.pop();
                dynOper = new DynamicOperation();
                if (!resVal.BoolVal) {
                    dynOper.opCode_ = ExpressionInterface.EXP_OP_IGNORE;
                    dynOper.argCount_ = 1;
                    addedOpers.push(dynOper);
                }
                else {
                    dynOper.opCode_ = ExpressionInterface.EXP_OP_EVALX;
                    dynOper.argCount_ = 0;
                    addedOpers.push(dynOper);
                    addResult = false;
                }
                break;
            case ExpressionInterface.EXP_OP_IF:
                val1 = valStack.pop();
                if (val1.BoolVal) {
                    dynOper = new DynamicOperation();
                    dynOper.opCode_ = ExpressionInterface.EXP_OP_EVALX;
                    dynOper.argCount_ = 0;
                    addedOpers.push(dynOper);
                    dynOper = new DynamicOperation();
                    {
                        dynOper.opCode_ = ExpressionInterface.EXP_OP_IGNORE;
                        dynOper.argCount_ = 1;
                    }
                    addedOpers.push(dynOper);
                }
                else {
                    dynOper = new DynamicOperation();
                    {
                        dynOper.opCode_ = ExpressionInterface.EXP_OP_IGNORE;
                        dynOper.argCount_ = 1;
                    }
                    addedOpers.push(dynOper);
                    dynOper = new DynamicOperation();
                    {
                        dynOper.opCode_ = ExpressionInterface.EXP_OP_EVALX;
                        dynOper.argCount_ = 0;
                    }
                    addedOpers.push(dynOper);
                }
                addResult = false;
                expStrTracker.resetNullResult();
                break;
            case ExpressionInterface.EXP_OP_LEN:
                val1 = valStack.pop();
                resVal.Attr = StorageAttribute.NUMERIC;
                if (val1.StrVal == null) {
                    super.SetNULL(resVal, StorageAttribute.NUMERIC);
                    break;
                }
                resVal.MgNumVal = new NUM_TYPE();
                if (specialAnsiExpression || val1.Attr !== StorageAttribute.UNICODE)
                    resVal.MgNumVal.NUM_4_LONG(UtilStrByteMode.lenB(val1.StrVal));
                else
                    resVal.MgNumVal.NUM_4_LONG(val1.StrVal.length);
                break;
            case ExpressionInterface.EXP_OP_CON:
                val2 = valStack.pop();
                val1 = valStack.pop();
                resVal.Attr = StorageAttribute.UNICODE;
                if (val1.Attr === StorageAttribute.UNICODE && val1.StrVal == null ||
                    val2.Attr === StorageAttribute.UNICODE && val2.StrVal == null)
                    super.SetNULL(resVal, StorageAttribute.UNICODE);
                else
                    resVal.StrVal = (!NString.IsNullOrEmpty(val1.StrVal) ? val1.StrVal : '') + (!NString.IsNullOrEmpty(val2.StrVal) ? val2.StrVal : '');
                break;
            case ExpressionInterface.EXP_OP_MID:
                val3 = valStack.pop();
                val2 = valStack.pop();
                val1 = valStack.pop();
                resVal.Attr = val1.Attr;
                if (val2.MgNumVal == null || val3.MgNumVal == null || val1.StrVal == null) {
                    super.SetNULL(resVal, resVal.Attr);
                    break;
                }
                ofs = val2.MgNumVal.NUM_2_LONG();
                ofs = (ofs > 1
                    ? ofs - 1
                    : 0);
                len = val3.MgNumVal.NUM_2_LONG();
                if (specialAnsiExpression || val1.Attr !== StorageAttribute.UNICODE) {
                    resVal.Attr = StorageAttribute.ALPHA;
                    resVal.StrVal = UtilStrByteMode.midB(val1.StrVal, ofs, len);
                }
                else {
                    LenMax = val1.StrVal.length - ofs;
                    if (LenMax < len)
                        len = LenMax;
                    if (len < 0)
                        len = 0;
                    resVal.StrVal = val1.StrVal.substr(ofs, len);
                }
                if (resVal.StrVal == null)
                    resVal.StrVal = '';
                break;
            case ExpressionInterface.EXP_OP_LEFT:
                val2 = valStack.pop();
                val1 = valStack.pop();
                resVal.Attr = val1.Attr;
                if (val2.MgNumVal == null || val1.StrVal == null) {
                    super.SetNULL(resVal, val1.Attr);
                    break;
                }
                len = val2.MgNumVal.NUM_2_LONG();
                if (specialAnsiExpression || val1.Attr !== StorageAttribute.UNICODE) {
                    resVal.Attr = StorageAttribute.ALPHA;
                    resVal.StrVal = UtilStrByteMode.leftB(val1.StrVal, len);
                    if (resVal.StrVal == null)
                        resVal.StrVal = '';
                }
                else {
                    if (len > val1.StrVal.length)
                        len = val1.StrVal.length;
                    if (len < 0)
                        len = 0;
                    resVal.StrVal = val1.StrVal.substr(0, len);
                }
                break;
            case ExpressionInterface.EXP_OP_RIGHT:
                val2 = valStack.pop();
                val1 = valStack.pop();
                resVal.Attr = val1.Attr;
                if (val2.MgNumVal == null || val1.StrVal == null) {
                    super.SetNULL(resVal, val1.Attr);
                    break;
                }
                len = val2.MgNumVal.NUM_2_LONG();
                if (specialAnsiExpression || val1.Attr !== StorageAttribute.UNICODE) {
                    resVal.Attr = StorageAttribute.ALPHA;
                    resVal.StrVal = UtilStrByteMode.rightB(val1.StrVal, len);
                    if (resVal.StrVal == null)
                        resVal.StrVal = '';
                }
                else {
                    if (len > val1.StrVal.length)
                        len = val1.StrVal.length;
                    if (len < 0)
                        len = 0;
                    ofs = val1.StrVal.length - len;
                    resVal.StrVal = val1.StrVal.substr(ofs);
                }
                break;
            case ExpressionInterface.EXP_OP_FILL:
                val2 = valStack.pop();
                val1 = valStack.pop();
                resVal.Attr = StorageAttribute.UNICODE;
                if (val2.MgNumVal == null || val1.StrVal == null) {
                    super.SetNULL(resVal, StorageAttribute.UNICODE);
                    break;
                }
                len = val1.StrVal.length;
                j = val2.MgNumVal.NUM_2_LONG();
                if (j < 0)
                    j = 0;
                LenMax = len * j;
                if (LenMax > 0x7FFF)
                    LenMax = Math.floor(0x7FFF / len) * len;
                if (LenMax > 0) {
                    if (len <= 0)
                        resVal.StrVal = '';
                    else if (LenMax === 1)
                        resVal.StrVal = val1.StrVal;
                    else {
                        let tmpBuffer = new StringBuilder(LenMax);
                        for (; LenMax > 0; LenMax -= len)
                            tmpBuffer.Append(val1.StrVal);
                        resVal.StrVal = tmpBuffer.ToString();
                    }
                }
                if (resVal.StrVal == null)
                    resVal.StrVal = '';
                break;
            case ExpressionInterface.EXP_OP_INSTR:
                val2 = valStack.pop();
                val1 = valStack.pop();
                ofs = 0;
                resVal.Attr = StorageAttribute.NUMERIC;
                if (val1.StrVal == null || val2.StrVal == null) {
                    super.SetNULL(resVal, StorageAttribute.NUMERIC);
                    break;
                }
                resVal.MgNumVal = new NUM_TYPE();
                if (specialAnsiExpression ||
                    !(val1.Attr === StorageAttribute.UNICODE ||
                        val2.Attr === StorageAttribute.UNICODE)) {
                    ofs = UtilStrByteMode.instrB(val1.StrVal, val2.StrVal);
                }
                else {
                    if (val2.StrVal.length === 0) {
                        resVal.MgNumVal.NUM_4_LONG(ofs);
                        break;
                    }
                    ofs = val1.StrVal.indexOf(val2.StrVal);
                    if (ofs < 0)
                        ofs = 0;
                    else
                        ofs++;
                }
                resVal.MgNumVal.NUM_4_LONG(ofs);
                break;
            case ExpressionInterface.EXP_OP_TRIM:
            case ExpressionInterface.EXP_OP_LTRIM:
            case ExpressionInterface.EXP_OP_RTRIM:
                val1 = valStack.pop();
                resVal.Attr = val1.Attr === StorageAttribute.ALPHA
                    ? StorageAttribute.ALPHA
                    : StorageAttribute.UNICODE;
                if (val1.StrVal == null) {
                    super.SetNULL(resVal, resVal.Attr);
                    break;
                }
                switch (opCode) {
                    case ExpressionInterface.EXP_OP_TRIM:
                        val1.StrVal = ExpressionEvaluator.trimStr(val1.StrVal, 'B');
                        break;
                    case ExpressionInterface.EXP_OP_LTRIM:
                        val1.StrVal = ExpressionEvaluator.trimStr(val1.StrVal, 'L');
                        break;
                    case ExpressionInterface.EXP_OP_RTRIM:
                        val1.StrVal = ExpressionEvaluator.trimStr(val1.StrVal, 'R');
                        break;
                }
                resVal.StrVal = val1.StrVal;
                break;
            case ExpressionInterface.EXP_OP_STR:
                val2 = valStack.pop();
                val1 = valStack.pop();
                resVal.Attr = StorageAttribute.UNICODE;
                if (val2.StrVal == null || val1.MgNumVal == null) {
                    super.SetNULL(resVal, StorageAttribute.UNICODE);
                    break;
                }
                pic = new PIC(ExpressionEvaluator.set_a_pic(val2.StrVal), StorageAttribute.NUMERIC, this.ExpTask.getCompIdx());
                resVal.StrVal = val1.MgNumVal.to_a(pic);
                break;
            case ExpressionInterface.EXP_OP_VAL:
                val2 = valStack.pop();
                val1 = valStack.pop();
                resVal.Attr = StorageAttribute.NUMERIC;
                if (val2.StrVal == null || val1.StrVal == null) {
                    super.SetNULL(resVal, StorageAttribute.NUMERIC);
                    break;
                }
                pic = new PIC(ExpressionEvaluator.set_a_pic(val2.StrVal), StorageAttribute.NUMERIC, this.ExpTask.getCompIdx());
                resVal.MgNumVal = new NUM_TYPE(val1.StrVal, pic, this.ExpTask.getCompIdx());
                break;
            case ExpressionInterface.EXP_OP_M:
                len = expStrTracker.get2ByteNumber();
                let codes = expStrTracker.getString(len, true, false);
                this.eval_op_m(resVal, codes);
                break;
            case ExpressionInterface.EXP_OP_K:
                resVal.Attr = StorageAttribute.NUMERIC;
                len = expStrTracker.get2ByteNumber();
                resVal.MgNumVal = expStrTracker.getMagicNumber(len, true);
                break;
            case ExpressionInterface.EXP_OP_F:
            case ExpressionInterface.EXP_OP_P:
                resVal.Attr = StorageAttribute.NUMERIC;
                len = expStrTracker.get2ByteNumber();
                resVal.MgNumVal = expStrTracker.getMagicNumber(len, true);
                len = expStrTracker.get2ByteNumber();
                expStrTracker.getMagicNumber(len, true);
                break;
            case ExpressionInterface.EXP_OP_STAT:
                val2 = valStack.pop();
                val1 = valStack.pop();
                this.eval_op_stat(resVal, val1, val2);
                break;
            case ExpressionInterface.EXP_OP_SUBFORM_EXEC_MODE:
                val1 = valStack.pop();
                this.eval_op_subformExecMode(resVal, val1);
                break;
            case ExpressionInterface.EXP_OP_IS_LOGGED_IN:
                this.eval_op_IsLoggedIn(resVal);
                break;
            case ExpressionInterface.EXP_OP_SYS:
                this.eval_op_appname(resVal);
                break;
            case ExpressionInterface.EXP_OP_PROG:
                this.eval_op_prog(resVal);
                break;
            case ExpressionInterface.EXP_OP_LEVEL:
                val1 = valStack.pop();
                this.eval_op_level(resVal, val1);
                break;
            case ExpressionInterface.EXP_OP_COUNTER:
                val1 = valStack.pop();
                this.eval_op_counter(resVal, val1);
                break;
            case ExpressionInterface.EXP_OP_EMPTY_DATA_VIEW:
                val1 = valStack.pop();
                this.eval_op_emptyDataview(resVal, val1);
                break;
            case ExpressionInterface.EXP_OP_MAINLEVEL:
                val1 = valStack.pop();
                this.eval_op_mainlevel(resVal, val1);
                break;
            case ExpressionInterface.EXP_OP_MAINDISPLAY:
                val1 = valStack.pop();
                this.eval_op_maindisplay(resVal, val1);
                break;
            case ExpressionInterface.EXP_OP_ISFIRSTRECORDCYCLE:
                val1 = valStack.pop();
                this.eval_op_IsFirstRecordCycle(resVal, val1);
                break;
            case ExpressionInterface.EXP_OP_DATE:
            case ExpressionInterface.EXP_OP_UTCDATE:
                resVal.MgNumVal = new NUM_TYPE();
                resVal.MgNumVal.NUM_4_LONG(DisplayConvertor.Instance.date_magic(opCode === ExpressionInterface.EXP_OP_UTCDATE));
                resVal.Attr = StorageAttribute.DATE;
                break;
            case ExpressionInterface.EXP_OP_ADDDT:
                val8 = valStack.pop();
                val7 = valStack.pop();
                val6 = valStack.pop();
                val5 = valStack.pop();
                val4 = valStack.pop();
                val3 = valStack.pop();
                val2 = valStack.pop();
                val1 = valStack.pop();
                await this.eval_op_addDateTime(resVal, val1, val2, val3, val4, val5, val6, val7, val8);
                break;
            case ExpressionInterface.EXP_OP_DIFDT:
                val6 = valStack.pop();
                val5 = valStack.pop();
                val4 = valStack.pop();
                val3 = valStack.pop();
                val2 = valStack.pop();
                val1 = valStack.pop();
                await this.eval_op_difdt(resVal, val1, val2, val3, val4, val5, val6);
                break;
            case ExpressionInterface.EXP_OP_VARPREV:
                val1 = valStack.pop();
                this.exp_get_var(resVal, val1, true);
                break;
            case ExpressionInterface.EXP_OP_VARCURR:
                val1 = valStack.pop();
                this.exp_get_var(resVal, val1, false);
                break;
            case ExpressionInterface.EXP_OP_VARMOD:
                val1 = valStack.pop();
                this.eval_op_varmod(resVal, val1);
                break;
            case ExpressionInterface.EXP_OP_VARINP:
                val1 = valStack.pop();
                this.eval_op_varinp(resVal, val1);
                break;
            case ExpressionInterface.EXP_OP_VARNAME:
                val1 = valStack.pop();
                this.eval_op_varname(resVal, val1);
                break;
            case ExpressionInterface.EXP_OP_VARDISPLAYNAME:
                val1 = valStack.pop();
                this.eval_op_VarDisplayName(resVal, val1);
                expStrTracker.resetNullResult();
                break;
            case ExpressionInterface.EXP_OP_CONTROL_ITEMS_REFRESH:
                val2 = valStack.pop();
                val1 = valStack.pop();
                await this.eval_op_controlItemRefresh(val1, val2, resVal);
                break;
            case ExpressionInterface.EXP_OP_VARCONTROLID:
                val1 = valStack.pop();
                this.eval_op_VarControlID(resVal, val1);
                expStrTracker.resetNullResult();
                break;
            case ExpressionInterface.EXP_OP_CONTROLITEMSLIST:
                val1 = valStack.pop();
                await this.eval_op_ControlItemsList(resVal, val1);
                expStrTracker.resetNullResult();
                break;
            case ExpressionInterface.EXP_OP_CONTROLDISPLAYLIST:
                val1 = valStack.pop();
                await this.eval_op_ControlDisplayList(resVal, val1);
                expStrTracker.resetNullResult();
                break;
            case ExpressionInterface.EXP_OP_VIEWMOD:
                val1 = valStack.pop();
                this.eval_op_viewmod(resVal, val1);
                break;
            case ExpressionInterface.EXP_OP_TIME:
            case ExpressionInterface.EXP_OP_UTCTIME:
                resVal.MgNumVal = new NUM_TYPE();
                resVal.MgNumVal.NUM_4_LONG(DisplayConvertor.Instance.time_magic(opCode === ExpressionInterface.EXP_OP_UTCTIME));
                resVal.Attr = StorageAttribute.TIME;
                break;
            case ExpressionInterface.EXP_OP_MTIME:
            case ExpressionInterface.EXP_OP_UTCMTIME:
                resVal.MgNumVal = new NUM_TYPE();
                resVal.MgNumVal.NUM_4_LONG(DisplayConvertor.Instance.mtime_magic(opCode === ExpressionInterface.EXP_OP_UTCMTIME));
                resVal.Attr = StorageAttribute.TIME;
                break;
            case ExpressionInterface.EXP_OP_PWR:
                val2 = valStack.pop();
                val1 = valStack.pop();
                resVal.MgNumVal = new NUM_TYPE();
                resVal.MgNumVal = NUM_TYPE.eval_op_pwr(val1.MgNumVal, val2.MgNumVal);
                resVal.IsNull = (resVal.MgNumVal == null);
                resVal.Attr = StorageAttribute.NUMERIC;
                break;
            case ExpressionInterface.EXP_OP_LOG:
                val1 = valStack.pop();
                resVal.MgNumVal = NUM_TYPE.eval_op_log(val1.MgNumVal);
                resVal.IsNull = (resVal.MgNumVal == null);
                resVal.Attr = StorageAttribute.NUMERIC;
                break;
            case ExpressionInterface.EXP_OP_EXP:
                val1 = valStack.pop();
                resVal.MgNumVal = NUM_TYPE.eval_op_exp(val1.MgNumVal);
                resVal.IsNull = (resVal.MgNumVal == null);
                resVal.Attr = StorageAttribute.NUMERIC;
                break;
            case ExpressionInterface.EXP_OP_ABS:
                val1 = valStack.pop();
                resVal.MgNumVal = NUM_TYPE.eval_op_abs(val1.MgNumVal);
                resVal.IsNull = (resVal.MgNumVal == null);
                resVal.Attr = StorageAttribute.NUMERIC;
                break;
            case ExpressionInterface.EXP_OP_SIN:
                val1 = valStack.pop();
                resVal.MgNumVal = NUM_TYPE.eval_op_sin(val1.MgNumVal);
                resVal.IsNull = (resVal.MgNumVal == null);
                resVal.Attr = StorageAttribute.NUMERIC;
                break;
            case ExpressionInterface.EXP_OP_COS:
                val1 = valStack.pop();
                resVal.MgNumVal = NUM_TYPE.eval_op_cos(val1.MgNumVal);
                resVal.IsNull = (resVal.MgNumVal == null);
                resVal.Attr = StorageAttribute.NUMERIC;
                break;
            case ExpressionInterface.EXP_OP_TAN:
                val1 = valStack.pop();
                resVal.MgNumVal = NUM_TYPE.eval_op_tan(val1.MgNumVal);
                resVal.IsNull = (resVal.MgNumVal == null);
                resVal.Attr = StorageAttribute.NUMERIC;
                break;
            case ExpressionInterface.EXP_OP_ASIN:
                val1 = valStack.pop();
                resVal.MgNumVal = NUM_TYPE.eval_op_asin(val1.MgNumVal);
                resVal.IsNull = (resVal.MgNumVal == null);
                resVal.Attr = StorageAttribute.NUMERIC;
                break;
            case ExpressionInterface.EXP_OP_ACOS:
                val1 = valStack.pop();
                resVal.MgNumVal = NUM_TYPE.eval_op_acos(val1.MgNumVal);
                resVal.IsNull = (resVal.MgNumVal == null);
                resVal.Attr = StorageAttribute.NUMERIC;
                break;
            case ExpressionInterface.EXP_OP_ATAN:
                val1 = valStack.pop();
                resVal.MgNumVal = NUM_TYPE.eval_op_atan(val1.MgNumVal);
                resVal.IsNull = (resVal.MgNumVal == null);
                resVal.Attr = StorageAttribute.NUMERIC;
                break;
            case ExpressionInterface.EXP_OP_RAND:
                val1 = valStack.pop();
                resVal.MgNumVal = NUM_TYPE.eval_op_rand(val1.MgNumVal);
                resVal.IsNull = (resVal.MgNumVal == null);
                resVal.Attr = StorageAttribute.NUMERIC;
                break;
            case ExpressionInterface.EXP_OP_MIN:
            case ExpressionInterface.EXP_OP_MAX:
                nArgs = valStack.pop();
                this.val_cpy(valStack.pop(), resVal);
                try {
                    for (j = 1; j < nArgs; j++) {
                        val1 = valStack.pop();
                        if (opCode === ExpressionInterface.EXP_OP_MIN) {
                            if (ExpressionEvaluator.val_cmp_any(val1, resVal) < 0)
                                this.val_cpy(val1, resVal);
                        }
                        else {
                            if (ExpressionEvaluator.val_cmp_any(val1, resVal) > 0)
                                this.val_cpy(val1, resVal);
                        }
                    }
                }
                catch (oneOfValuesIsNull) {
                    if (oneOfValuesIsNull instanceof NullValueException) {
                        for (; valStack.count() > 0 && j < nArgs; j++)
                            valStack.pop();
                        resVal.IsNull = true;
                        resVal.Attr = oneOfValuesIsNull.getAttr();
                    }
                    else
                        throw oneOfValuesIsNull;
                }
                break;
            case ExpressionInterface.EXP_OP_RANGE:
                val3 = valStack.pop();
                val2 = valStack.pop();
                val1 = valStack.pop();
                this.eval_op_range(val1, val2, val3, resVal);
                break;
            case ExpressionInterface.EXP_OP_REP:
                val4 = valStack.pop();
                val3 = valStack.pop();
                val2 = valStack.pop();
                val1 = valStack.pop();
                if (specialAnsiExpression ||
                    !(val1.Attr === StorageAttribute.UNICODE ||
                        val2.Attr === StorageAttribute.UNICODE)) {
                    resVal.Attr = StorageAttribute.ALPHA;
                    resVal.StrVal = UtilStrByteMode.repB(val1.StrVal, val2.StrVal, val3.MgNumVal.NUM_2_LONG(), val4.MgNumVal.NUM_2_LONG());
                }
                else {
                    this.eval_op_rep_1(resVal, val1, val2, val3, val4);
                }
                break;
            case ExpressionInterface.EXP_OP_INS:
                val4 = valStack.pop();
                val3 = valStack.pop();
                val2 = valStack.pop();
                val1 = valStack.pop();
                if (specialAnsiExpression ||
                    !(val1.Attr === StorageAttribute.UNICODE ||
                        val2.Attr === StorageAttribute.UNICODE)) {
                    resVal.Attr = StorageAttribute.ALPHA;
                    resVal.StrVal = UtilStrByteMode.insB(val1.StrVal, val2.StrVal, val3.MgNumVal.NUM_2_LONG(), val4.MgNumVal.NUM_2_LONG());
                }
                else {
                    this.eval_op_ins(resVal, val1, val2, val3, val4);
                }
                break;
            case ExpressionInterface.EXP_OP_DEL:
                val3 = valStack.pop();
                val2 = valStack.pop();
                val1 = valStack.pop();
                if (specialAnsiExpression || val1.Attr !== StorageAttribute.UNICODE) {
                    resVal.Attr = StorageAttribute.ALPHA;
                    resVal.StrVal = UtilStrByteMode.delB(val1.StrVal, val2.MgNumVal.NUM_2_LONG(), val3.MgNumVal.NUM_2_LONG());
                }
                else {
                    this.eval_op_del(resVal, val1, val2, val3);
                }
                break;
            case ExpressionInterface.EXP_OP_FLIP:
                val1 = valStack.pop();
                this.eval_op_flip(resVal, val1);
                break;
            case ExpressionInterface.EXP_OP_UPPER:
                val1 = valStack.pop();
                this.eval_op_upper(resVal, val1);
                break;
            case ExpressionInterface.EXP_OP_LOWER:
                val1 = valStack.pop();
                this.eval_op_lower(resVal, val1);
                break;
            case ExpressionInterface.EXP_OP_CRC:
                val2 = valStack.pop();
                val1 = valStack.pop();
                this.eval_op_crc(resVal, val1, val2);
                break;
            case ExpressionInterface.EXP_OP_CHKDGT:
                val2 = valStack.pop();
                val1 = valStack.pop();
                this.eval_op_chkdgt(resVal, val1, val2);
                break;
            case ExpressionInterface.EXP_OP_SOUNDX:
                val1 = valStack.pop();
                this.eval_op_soundx(resVal, val1);
                break;
            case ExpressionInterface.EXP_OP_HSTR:
                val1 = valStack.pop();
                this.eval_op_hstr(resVal, val1);
                break;
            case ExpressionInterface.EXP_OP_HVAL:
                val1 = valStack.pop();
                this.eval_op_hval(resVal, val1);
                break;
            case ExpressionInterface.EXP_OP_CHR:
                val1 = valStack.pop();
                this.eval_op_chr(resVal, val1);
                break;
            case ExpressionInterface.EXP_OP_ASC:
                val1 = valStack.pop();
                this.eval_op_asc(resVal, val1);
                break;
            case ExpressionInterface.EXP_OP_MSTR:
                val2 = valStack.pop();
                val1 = valStack.pop();
                this.eval_op_mstr(resVal, val1, val2);
                break;
            case ExpressionInterface.EXP_OP_MVAL:
                val1 = valStack.pop();
                this.eval_op_mval(resVal, val1);
                break;
            case ExpressionInterface.EXP_OP_DSTR:
                val2 = valStack.pop();
                val1 = valStack.pop();
                this.eval_op_dstr(resVal, val1, val2, DisplayConvertor.Instance);
                break;
            case ExpressionInterface.EXP_OP_DVAL:
                val2 = valStack.pop();
                val1 = valStack.pop();
                this.eval_op_dval(resVal, val1, val2, DisplayConvertor.Instance);
                break;
            case ExpressionInterface.EXP_OP_TSTR:
                val2 = valStack.pop();
                val1 = valStack.pop();
                this.eval_op_tstr(resVal, val1, val2, DisplayConvertor.Instance, false);
                break;
            case ExpressionInterface.EXP_OP_MTSTR:
                val2 = valStack.pop();
                val1 = valStack.pop();
                this.eval_op_tstr(resVal, val1, val2, DisplayConvertor.Instance, true);
                break;
            case ExpressionInterface.EXP_OP_TVAL:
                val2 = valStack.pop();
                val1 = valStack.pop();
                this.eval_op_tval(resVal, val1, val2, DisplayConvertor.Instance, false);
                break;
            case ExpressionInterface.EXP_OP_MTVAL:
                val2 = valStack.pop();
                val1 = valStack.pop();
                this.eval_op_tval(resVal, val1, val2, DisplayConvertor.Instance, true);
                break;
            case ExpressionInterface.EXP_OP_DAY:
                val1 = valStack.pop();
                this.eval_op_day(resVal, val1);
                break;
            case ExpressionInterface.EXP_OP_MONTH:
                val1 = valStack.pop();
                this.eval_op_month(resVal, val1);
                break;
            case ExpressionInterface.EXP_OP_YEAR:
                val1 = valStack.pop();
                this.eval_op_year(resVal, val1);
                break;
            case ExpressionInterface.EXP_OP_DOW:
                val1 = valStack.pop();
                this.eval_op_dow(resVal, val1);
                break;
            case ExpressionInterface.EXP_OP_CDOW:
                val1 = valStack.pop();
                this.eval_op_cdow(resVal, val1.MgNumVal, DisplayConvertor.Instance);
                break;
            case ExpressionInterface.EXP_OP_CMONTH:
                val1 = valStack.pop();
                this.eval_op_cmonth(resVal, val1.MgNumVal, DisplayConvertor.Instance);
                break;
            case ExpressionInterface.EXP_OP_NDOW:
                val1 = valStack.pop();
                this.eval_op_ndow(resVal, val1, DisplayConvertor.Instance);
                break;
            case ExpressionInterface.EXP_OP_NMONTH:
                val1 = valStack.pop();
                this.eval_op_nmonth(resVal, val1, DisplayConvertor.Instance);
                break;
            case ExpressionInterface.EXP_OP_SECOND:
                val1 = valStack.pop();
                this.eval_op_second(resVal, val1);
                break;
            case ExpressionInterface.EXP_OP_MINUTE:
                val1 = valStack.pop();
                this.eval_op_minute(resVal, val1);
                break;
            case ExpressionInterface.EXP_OP_HOUR:
                val1 = valStack.pop();
                this.eval_op_hour(resVal, val1);
                break;
            case ExpressionInterface.EXP_OP_DELAY:
                val1 = valStack.pop();
                this.eval_op_delay();
                resVal.Attr = StorageAttribute.BOOLEAN;
                resVal.BoolVal = true;
                break;
            case ExpressionInterface.EXP_OP_IDLE:
                this.eval_op_idle(resVal);
                break;
            case ExpressionInterface.EXP_OP_ADDDATE:
                val4 = valStack.pop();
                val3 = valStack.pop();
                val2 = valStack.pop();
                val1 = valStack.pop();
                this.eval_op_adddate(resVal, val1, val2, val3, val4);
                break;
            case ExpressionInterface.EXP_OP_ADDTIME:
                val4 = valStack.pop();
                val3 = valStack.pop();
                val2 = valStack.pop();
                val1 = valStack.pop();
                this.eval_op_addtime(resVal, val1, val2, val3, val4);
                break;
            case ExpressionInterface.EXP_OP_OWNER:
                resVal.Attr = StorageAttribute.ALPHA;
                resVal.StrVal = Environment.Instance.getOwner();
                break;
            case ExpressionInterface.EXP_OP_VARATTR:
                val1 = valStack.pop();
                this.eval_op_varattr(resVal, val1);
                break;
            case ExpressionInterface.EXP_OP_VARPIC:
                val2 = valStack.pop();
                val1 = valStack.pop();
                this.eval_op_varpic(resVal, val1, val2);
                break;
            case ExpressionInterface.EXP_OP_DBROUND:
                val2 = valStack.pop();
                val1 = valStack.pop();
                this.eval_op_dbround(resVal, val1, val2);
                break;
            case ExpressionInterface.EXP_OP_NULL:
            case ExpressionInterface.EXP_OP_NULL_A:
            case ExpressionInterface.EXP_OP_NULL_N:
            case ExpressionInterface.EXP_OP_NULL_B:
            case ExpressionInterface.EXP_OP_NULL_D:
            case ExpressionInterface.EXP_OP_NULL_T:
            case ExpressionInterface.EXP_OP_NULL_U:
            case ExpressionInterface.EXP_OP_NULL_O:
                this.exp_null_val_get(expectedType, opCode, resVal);
                break;
            case ExpressionInterface.EXP_OP_ISNULL:
                val1 = valStack.pop();
                resVal.BoolVal = val1.IsNull;
                if (!val1.IsNull && val1.OriginalNull)
                    resVal.BoolVal = val1.OriginalNull;
                resVal.Attr = StorageAttribute.BOOLEAN;
                if (expStrTracker.isNull()) {
                    let myArray = new List();
                    let prevNull = false;
                    let i;
                    while (!(valStack.count() === 0) && !prevNull) {
                        myArray.push(valStack.pop());
                        if (myArray.get_Item(myArray.length - 1).IsNull)
                            prevNull = true;
                    }
                    for (i = myArray.length - 1; i >= 0; i--)
                        valStack.push(myArray.get_Item(i));
                    if (!prevNull)
                        expStrTracker.resetNullResult();
                }
                break;
            case ExpressionInterface.EXP_OP_BOM:
                val1 = valStack.pop();
                this.eval_op_bom(resVal, val1);
                break;
            case ExpressionInterface.EXP_OP_BOY:
                val1 = valStack.pop();
                this.eval_op_boy(resVal, val1);
                break;
            case ExpressionInterface.EXP_OP_EOM:
                val1 = valStack.pop();
                this.eval_op_eom(resVal, val1);
                break;
            case ExpressionInterface.EXP_OP_EOY:
                val1 = valStack.pop();
                this.eval_op_eoy(resVal, val1);
                break;
            case ExpressionInterface.EXP_OP_VARSET:
                val2 = valStack.pop();
                val1 = valStack.pop();
                await this.eval_op_varset(resVal, val2, val1);
                break;
            case ExpressionInterface.EXP_OP_CTRL_NAME:
                this.eval_op_ctrl_name(resVal);
                break;
            case ExpressionInterface.EXP_OP_TDEPTH:
                let currTsk = this.ExpTask.GetContextTask();
                len = (currTsk.getTaskDepth(false)) - 1;
                this.ConstructMagicNum(resVal, len, StorageAttribute.NUMERIC);
                break;
            case ExpressionInterface.EXP_OP_ISDEFAULT:
                val1 = valStack.pop();
                this.exp_is_default(resVal, val1);
                break;
            case ExpressionInterface.EXP_OP_STRTOKEN:
                val3 = valStack.pop();
                val2 = valStack.pop();
                val1 = valStack.pop();
                this.eval_op_strtok(resVal, val1, val2, val3);
                break;
            case ExpressionInterface.EXP_OP_STRTOK_CNT:
                val2 = valStack.pop();
                val1 = valStack.pop();
                this.eval_op_strTokenCnt(val1, val2, resVal);
                break;
            case ExpressionInterface.EXP_OP_STRTOKEN_IDX:
                val3 = valStack.pop();
                val2 = valStack.pop();
                val1 = valStack.pop();
                this.eval_op_strTokenIdx(val1, val2, val3, resVal);
                break;
            case ExpressionInterface.EXP_OP_BLOBSIZE:
                val1 = valStack.pop();
                this.eval_op_blobsize(resVal, val1);
                break;
            case ExpressionInterface.EXP_OP_WEB_REFERENCE:
                val1 = valStack.pop();
                resVal.Attr = StorageAttribute.ALPHA;
                resVal.StrVal = '%' + val1.StrVal + '%';
                break;
            case ExpressionInterface.EXP_OP_CASE:
                nArgs = valStack.pop();
                Exp_params = new Array(nArgs);
                for (j = 0; j < nArgs; j++)
                    Exp_params[nArgs - 1 - j] = valStack.pop();
                this.val_cpy(Exp_params[0], resVal);
                for (j = 1; j < nArgs; j += 2) {
                    val1 = Exp_params[j];
                    let valueMatched;
                    try {
                        valueMatched = (ExpressionEvaluator.val_cmp_any(val1, resVal) === 0);
                    }
                    catch (nullValueException) {
                        if (nullValueException instanceof NullValueException) {
                            valueMatched = false;
                        }
                        else
                            throw nullValueException;
                    }
                    if (valueMatched) {
                        this.val_cpy(Exp_params[j + 1], resVal);
                        break;
                    }
                    if (j === (nArgs - 3)) {
                        this.val_cpy(Exp_params[j + 2], resVal);
                        break;
                    }
                }
                expStrTracker.resetNullResult();
                break;
            case ExpressionInterface.EXP_OP_THIS:
                this.eval_op_this(resVal);
                break;
            case ExpressionInterface.EXP_OP_LIKE:
                val2 = valStack.pop();
                val1 = valStack.pop();
                this.eval_op_like(val1, val2, resVal);
                break;
            case ExpressionInterface.EXP_OP_REPSTR:
                val3 = valStack.pop();
                val2 = valStack.pop();
                val1 = valStack.pop();
                this.eval_op_repstr(val1, val2, val3, resVal);
                break;
            case ExpressionInterface.EXP_OP_VARCURRN:
                val1 = valStack.pop();
                this.exp_get_var(val1, resVal);
                break;
            case ExpressionInterface.EXP_OP_VARINDEX:
                val1 = valStack.pop();
                this.exp_get_indx(val1, resVal);
                break;
            case ExpressionInterface.EXP_OP_JCDOW:
                if (this._expressionLocalJpn == null)
                    super.SetNULL(resVal, StorageAttribute.ALPHA);
                else {
                    val1 = valStack.pop();
                    this._expressionLocalJpn.eval_op_jcdow(resVal, val1.MgNumVal, DisplayConvertor.Instance);
                }
                break;
            case ExpressionInterface.EXP_OP_JMONTH:
                if (this._expressionLocalJpn == null)
                    super.SetNULL(resVal, StorageAttribute.ALPHA);
                else {
                    val1 = valStack.pop();
                    this._expressionLocalJpn.eval_op_jmonth(resVal, val1);
                }
                break;
            case ExpressionInterface.EXP_OP_JNDOW:
                if (this._expressionLocalJpn == null)
                    super.SetNULL(resVal, StorageAttribute.ALPHA);
                else {
                    val1 = valStack.pop();
                    this._expressionLocalJpn.eval_op_jndow(resVal, val1, DisplayConvertor.Instance);
                }
                break;
            case ExpressionInterface.EXP_OP_JYEAR:
                if (this._expressionLocalJpn == null)
                    super.SetNULL(resVal, StorageAttribute.ALPHA);
                else {
                    val1 = valStack.pop();
                    this._expressionLocalJpn.eval_op_jyear(resVal, val1);
                }
                break;
            case ExpressionInterface.EXP_OP_JGENGO:
                if (this._expressionLocalJpn == null)
                    super.SetNULL(resVal, StorageAttribute.ALPHA);
                else {
                    val2 = valStack.pop();
                    val1 = valStack.pop();
                    this._expressionLocalJpn.eval_op_jgengo(resVal, val1.MgNumVal, val2.MgNumVal, DisplayConvertor.Instance);
                }
                break;
            case ExpressionInterface.EXP_OP_HAN:
                val1 = valStack.pop();
                resVal.Attr = val1.Attr;
                if (this._expressionLocalJpn == null)
                    resVal.StrVal = val1.StrVal;
                else if (val1.StrVal == null)
                    super.SetNULL(resVal, val1.Attr);
                else {
                    resVal.StrVal = this._expressionLocalJpn.eval_op_han(val1.StrVal);
                    if (resVal.StrVal == null)
                        resVal.StrVal = '';
                }
                break;
            case ExpressionInterface.EXP_OP_ZEN:
                val1 = valStack.pop();
                resVal.Attr = val1.Attr;
                if (this._expressionLocalJpn == null)
                    resVal.StrVal = val1.StrVal;
                else if (val1.StrVal == null)
                    super.SetNULL(resVal, val1.Attr);
                else {
                    resVal.StrVal = this._expressionLocalJpn.eval_op_zens(val1.StrVal, 0);
                    if (resVal.StrVal == null)
                        resVal.StrVal = '';
                }
                break;
            case ExpressionInterface.EXP_OP_ZENS:
                val2 = valStack.pop();
                val1 = valStack.pop();
                resVal.Attr = val1.Attr;
                if (this._expressionLocalJpn == null)
                    resVal.StrVal = val1.StrVal;
                else if (val2.MgNumVal == null || val1.StrVal == null)
                    super.SetNULL(resVal, val1.Attr);
                else {
                    resVal.StrVal = this._expressionLocalJpn.eval_op_zens(val1.StrVal, val2.MgNumVal.NUM_2_LONG());
                    if (resVal.StrVal == null)
                        resVal.StrVal = '';
                }
                break;
            case ExpressionInterface.EXP_OP_ZIMEREAD:
                val1 = valStack.pop();
                resVal.Attr = StorageAttribute.ALPHA;
                if (this._expressionLocalJpn == null)
                    resVal.StrVal = val1.StrVal;
                else {
                    resVal.StrVal = this._expressionLocalJpn.eval_op_zimeread();
                    if (resVal.StrVal == null)
                        resVal.StrVal = '';
                }
                break;
            case ExpressionInterface.EXP_OP_ZKANA:
                val2 = valStack.pop();
                val1 = valStack.pop();
                resVal.Attr = val1.Attr;
                if (this._expressionLocalJpn == null)
                    resVal.StrVal = val1.StrVal;
                else if (val2.MgNumVal == null || val1.StrVal == null)
                    super.SetNULL(resVal, val1.Attr);
                else {
                    resVal.StrVal = this._expressionLocalJpn.eval_op_zkana(val1.StrVal, val2.MgNumVal.NUM_2_LONG());
                    if (resVal.StrVal == null)
                        resVal.StrVal = '';
                }
                break;
            case ExpressionInterface.EXP_OP_GOTO_CTRL:
                val3 = valStack.pop();
                val2 = valStack.pop();
                val1 = valStack.pop();
                this.eval_op_gotoCtrl(val1, val2, val3, resVal);
                break;
            case ExpressionInterface.EXP_OP_TRANSLATE:
                val1 = valStack.pop();
                this.eval_op_translate(val1, resVal);
                break;
            case ExpressionInterface.EXP_OP_ASTR:
                val2 = valStack.pop();
                val1 = valStack.pop();
                this.eval_op_astr(val1, val2, resVal);
                break;
            case ExpressionInterface.EXP_OP_LOOPCOUNTER:
                this.ConstructMagicNum(resVal, this.ExpTask.getLoopCounter(), StorageAttribute.NUMERIC);
                break;
            case ExpressionInterface.EXP_OP_VECCELLATTR:
                val1 = valStack.pop();
                ExpressionEvaluator.eval_op_vecCellAttr(val1, resVal);
                break;
            case ExpressionInterface.EXP_OP_VECGET:
                val2 = valStack.pop();
                val1 = valStack.pop();
                this.eval_op_vecGet(val1, val2, resVal);
                break;
            case ExpressionInterface.EXP_OP_VECSET:
                val3 = valStack.pop();
                val2 = valStack.pop();
                val1 = valStack.pop();
                await this.eval_op_vecSet(val1, val2, val3, resVal);
                resVal.IsNull = false;
                if (expStrTracker.isNull())
                    expStrTracker.resetNullResult();
                break;
            case ExpressionInterface.EXP_OP_VECSIZE:
                val1 = valStack.pop();
                this.eval_op_vecSize(val1, resVal);
                expStrTracker.resetNullResult();
                break;
            case ExpressionInterface.EXP_OP_IN:
                nArgs = valStack.pop();
                resVal.Attr = StorageAttribute.BOOLEAN;
                resVal.BoolVal = false;
                Exp_params = new Array(nArgs);
                for (j = 0; j < nArgs; j++)
                    Exp_params[nArgs - 1 - j] = valStack.pop();
                try {
                    for (j = 1; j < nArgs; j++) {
                        if (ExpressionEvaluator.val_cmp_any(Exp_params[0], Exp_params[j]) === 0) {
                            resVal.BoolVal = true;
                            break;
                        }
                    }
                }
                catch (nullValueException) {
                    if (nullValueException instanceof NullValueException) {
                        super.SetNULL(resVal, StorageAttribute.BOOLEAN);
                    }
                    else
                        throw nullValueException;
                }
                break;
            case ExpressionInterface.EXP_OP_ISCOMPONENT:
                this.eval_op_iscomponent(resVal);
                break;
            case ExpressionInterface.EXP_OP_USER_DEFINED_FUNC:
                nArgs = valStack.pop();
                if (nArgs > 0) {
                    nArgs--;
                    Exp_params = new Array(nArgs);
                    for (j = 0; j < nArgs; j++)
                        Exp_params[nArgs - 1 - j] = valStack.pop();
                    let funcName = valStack.pop().StrVal;
                    await this.eval_op_ExecUserDefinedFunc(funcName, Exp_params, resVal, expectedType);
                    expStrTracker.resetNullResult();
                }
                break;
            case ExpressionInterface.EXP_OP_UNICODEASC:
                val1 = valStack.pop();
                resVal.Attr = StorageAttribute.NUMERIC;
                resVal.IsNull = false;
                if (!val1.IsNull && val1.StrVal.length > 0) {
                    resVal.MgNumVal = new NUM_TYPE();
                    resVal.MgNumVal.NUM_4_LONG(val1.StrVal[0].charCodeAt(0));
                }
                else
                    resVal.IsNull = true;
                break;
            case ExpressionInterface.EXP_OP_PUBLICNAME:
                val1 = valStack.pop();
                this.eval_op_publicName(resVal, val1);
                break;
            case ExpressionInterface.EXP_OP_TASKID:
                val1 = valStack.pop();
                this.eval_op_taskId(resVal, val1);
                break;
            case ExpressionInterface.EXP_OP_DBVIEWSIZE:
                val1 = valStack.pop();
                this.eval_op_dbviewsize(resVal, val1);
                break;
            case ExpressionInterface.EXP_OP_DBVIEWROWIDX:
                val1 = valStack.pop();
                this.eval_op_dbviewrowidx(resVal, val1);
                break;
            case ExpressionInterface.EXP_OP_PROJECTDIR:
                this.eval_op_projectdir(resVal);
                break;
            case ExpressionInterface.EXP_OP_MLS_TRANS:
                val1 = valStack.pop();
                this.eval_op_MlsTrans(resVal, val1);
                break;
            case ExpressionInterface.EXP_OP_STR_BUILD:
                nArgs = valStack.pop();
                this.eval_op_StrBuild(valStack, resVal, nArgs);
                break;
            case ExpressionInterface.EXP_OP_STATUSBARSETTEXT:
                val1 = valStack.pop();
                this.eval_op_statusbar_set_text(resVal, val1);
                expStrTracker.resetNullResult();
                break;
            case ExpressionInterface.EXP_OP_SET_TITLE:
                val1 = valStack.pop();
                this.eval_op_set_title(resVal, val1);
                expStrTracker.resetNullResult();
                break;
            case ExpressionInterface.EXP_OP_IS_ROW_EDITING:
                val1 = valStack.pop();
                this.eval_op_is_row_editing(resVal, val1);
                expStrTracker.resetNullResult();
                break;
            case ExpressionInterface.EXP_OP_GETPARAM:
                val1 = valStack.pop();
                this.eval_op_getParam(resVal, val1);
                break;
            case ExpressionInterface.EXP_OP_SETPARAM:
                val2 = valStack.pop();
                val1 = valStack.pop();
                this.eval_op_setParam(resVal, val1, val2);
                break;
            case ExpressionInterface.EXP_OP_INIPUT:
                val2 = valStack.pop();
                val1 = valStack.pop();
                await this.eval_op_iniput(resVal, val1, val2);
                break;
            case ExpressionInterface.EXP_OP_INIGET:
                val1 = valStack.pop();
                this.eval_op_iniget(resVal, val1);
                break;
            case ExpressionInterface.EXP_OP_INIGETLN:
                val2 = valStack.pop();
                val1 = valStack.pop();
                this.eval_op_inigetln(resVal, val1, val2);
                break;
            case ExpressionInterface.EXP_OP_EXPCALC:
                val1 = valStack.pop();
                await this.eval_op_expcalc(resVal, val1);
                break;
            case ExpressionInterface.EXP_OP_TASKTYPE:
                val1 = valStack.pop();
                this.eval_op_taskType(resVal, val1);
                break;
            case ExpressionInterface.EXP_OP_TSK_INSTANCE:
                val1 = valStack.pop();
                this.eval_op_tsk_instance(resVal, val1);
                break;
            case ExpressionInterface.EXP_OP_TERM:
                this.eval_op_terminal(resVal);
                break;
            case ExpressionInterface.EXP_OP_CLIENTSESSION_SET:
                val2 = valStack.pop();
                val1 = valStack.pop();
                this.eval_op_ClientSessionSet(val1, val2, resVal);
                break;
            case ExpressionInterface.EXP_OP_CND_RANGE:
                val2 = valStack.pop();
                val1 = valStack.pop();
                this.eval_op_CndRange(resVal, val1, val2);
                break;
            case ExpressionInterface.EXP_OP_CONTROL_SELECT_PROGRAM:
                val1 = valStack.pop();
                await this.eval_op_control_select_program(val1, resVal);
                break;
            case ExpressionInterface.EXP_OP_CALLJS:
                nArgs = valStack.pop();
                if (nArgs > 0) {
                    nArgs--;
                    Exp_params = new Array(nArgs);
                    for (j = 0; j < nArgs; j++)
                        Exp_params[nArgs - 1 - j] = valStack.pop();
                    await this.eval_op_CallJS(this.ExpTask, valStack.pop().StrVal, Exp_params, resVal);
                }
                break;
            case ExpressionInterface.EXP_OP_SET_COOKIE:
                nArgs = valStack.pop();
                if (nArgs > 0) {
                    nArgs--;
                    Exp_params = new Array(nArgs);
                    for (j = 0; j < nArgs; j++)
                        Exp_params[nArgs - 1 - j] = valStack.pop();
                    this.eval_op_set_cookie(valStack.pop().StrVal, Exp_params, resVal);
                }
                break;
            case ExpressionInterface.EXP_OP_GET_COOKIE:
                resVal.Attr = StorageAttribute.ALPHA;
                resVal.IsNull = false;
                this.eval_op_get_cookie(valStack.pop().StrVal, resVal);
                break;
            case ExpressionInterface.EXP_OP_DELETE_COOKIE:
                resVal.Attr = StorageAttribute.BOOLEAN;
                resVal.IsNull = false;
                this.eval_op_delete_cookie(valStack.pop().StrVal, resVal);
                break;
            case ExpressionInterface.EXP_OP_ROUTEGET:
                this.eval_op_route_get(resVal);
                break;
            default:
                return;
        }
        if (addResult) {
            this.ConvertExpVal(resVal, expectedType);
            valStack.push(resVal);
            if (resVal.IsNull)
                expStrTracker.setNullResult();
        }
    }
    eval_op_ClientSessionSet(val1, val2, resVal) {
        resVal.BoolVal = false;
        resVal.Attr = StorageAttribute.BOOLEAN;
        if (!val1.isEmptyString()) {
            switch (val1.StrVal) {
                case ConstInterface.ENABLE_COMMUNICATION_DIALOGS:
                    if (val2.Attr === StorageAttribute.BOOLEAN) {
                        resVal.BoolVal = true;
                    }
                    else
                        Logger.Instance.WriteExceptionToLogWithMsg('Invalid attribute for ' + ConstInterface.ENABLE_COMMUNICATION_DIALOGS + ' key in ClientSessionSet()');
                    break;
                default:
                    Logger.Instance.WriteExceptionToLogWithMsg('Invalid Key in ClientSessionSet()');
                    break;
            }
        }
    }
    async execExpression(expStrTracker, valStack, expectedType) {
        let expVal;
        let i;
        let addedOpers = new List();
        let dynOper;
        let opCode = expStrTracker.getOpCode();
        if (ExpressionEvaluator.isBasicItem(opCode)) {
            expVal = this.getExpBasicValue(expStrTracker, opCode);
            this.ConvertExpVal(expVal, expectedType);
            valStack.push(expVal);
            if (expVal.IsNull)
                expStrTracker.setNullResult();
            return;
        }
        let expDesc = ExpressionDict.expDesc[opCode];
        let nullArgs = false;
        if (expDesc.ArgEvalCount_ > 0) {
            for (i = 0; i < expDesc.ArgEvalCount_; i++) {
                expStrTracker.resetNullResult();
                await this.execExpression(expStrTracker, valStack, expDesc.ArgAttr_[i]);
                if (expStrTracker.isNull())
                    nullArgs = true;
            }
        }
        if (nullArgs)
            expStrTracker.setNullResult();
        await this.execOperation(opCode, expStrTracker, valStack, addedOpers, expectedType);
        let nDynOpers = addedOpers.length;
        if (nDynOpers > 0) {
            for (i = 0; i < nDynOpers; i++) {
                dynOper = addedOpers.get_Item(0);
                addedOpers.RemoveAt(0);
                switch (dynOper.opCode_) {
                    case ExpressionInterface.EXP_OP_IGNORE:
                        let j;
                        for (j = 0; j < dynOper.argCount_; j++)
                            expStrTracker.skipOperator();
                        break;
                    case ExpressionInterface.EXP_OP_EVALX:
                        await this.execExpression(expStrTracker, valStack, expectedType);
                        break;
                }
            }
        }
    }
    async DiscardCndRangeExpression(expStrTracker, valStack) {
        let expVal;
        let opCode = expStrTracker.getOpCode();
        if (opCode !== ExpressionInterface.EXP_OP_CND_RANGE) {
            return false;
        }
        let expDesc = ExpressionDict.expDesc[opCode];
        await this.execExpression(expStrTracker, valStack, expDesc.ArgAttr_[0]);
        expVal = valStack.pop();
        return expVal.Attr === StorageAttribute.BOOLEAN && !expVal.BoolVal;
    }
    static val_cmp_any(val1, val2) {
        let retval = 0;
        let attr1 = val1.Attr;
        let attr2 = val2.Attr;
        let expVal = new ExpressionEvaluator();
        if (val1.IsNull && val2.IsNull)
            return 0;
        if (val1.IsNull || val2.IsNull)
            throw new NullValueException(attr1);
        if (StorageAttributeCheck.isTypeBlob(attr1)) {
            if (val1.IncludeBlobPrefix && BlobType.getContentType(val1.StrVal) === BlobType.CONTENT_TYPE_BINARY) {
                val1.StrVal = BlobType.removeBlobPrefix(val1.StrVal);
                val1.Attr = StorageAttribute.ALPHA;
                val1.IncludeBlobPrefix = false;
            }
            else
                expVal.ConvertExpVal(val1, StorageAttribute.UNICODE);
        }
        if (StorageAttributeCheck.isTypeBlob(attr2)) {
            if (val2.IncludeBlobPrefix && BlobType.getContentType(val2.StrVal) === BlobType.CONTENT_TYPE_BINARY) {
                val2.StrVal = BlobType.removeBlobPrefix(val2.StrVal);
                val2.Attr = StorageAttribute.ALPHA;
                val2.IncludeBlobPrefix = false;
            }
            else
                expVal.ConvertExpVal(val2, StorageAttribute.UNICODE);
        }
        attr1 = val1.Attr;
        attr2 = val2.Attr;
        if (attr1 !== attr2) {
            if ((StorageAttributeCheck.isTypeNumeric(attr1) && StorageAttributeCheck.isTypeNumeric(attr2)) ||
                (StorageAttributeCheck.IsTypeAlphaOrUnicode(attr1) && StorageAttributeCheck.IsTypeAlphaOrUnicode(attr2))) {
            }
            else
                return 1;
        }
        switch (attr1) {
            case StorageAttribute.ALPHA:
            case StorageAttribute.BLOB:
            case StorageAttribute.BLOB_VECTOR:
            case StorageAttribute.UNICODE:
                if (val1.StrVal === null && val2.StrVal === null)
                    return 0;
                if (val1.StrVal === null || val2.StrVal === null)
                    throw new NullValueException(attr1);
                let str1 = StrUtil.rtrim(val1.StrVal);
                let str2 = StrUtil.rtrim(val2.StrVal);
                if (Environment.Instance.getSpecialAnsiExpression() ||
                    (UtilStrByteMode.isLocaleDefLangDBCS() &&
                        attr1 === StorageAttribute.ALPHA && attr2 === StorageAttribute.ALPHA))
                    retval = UtilStrByteMode.strcmp(str1, str2);
                else
                    retval = NString.CompareOrdinal(str1, str2);
                break;
            case StorageAttribute.NUMERIC:
            case StorageAttribute.DATE:
            case StorageAttribute.TIME:
                if (val1.MgNumVal === null && val2.MgNumVal === null)
                    return 0;
                if (val1.MgNumVal === null || val2.MgNumVal === null)
                    throw new NullValueException(attr1);
                retval = NUM_TYPE.num_cmp(val1.MgNumVal, val2.MgNumVal);
                break;
            case StorageAttribute.BOOLEAN:
                retval = (val1.BoolVal ? 1 : 0) - (val2.BoolVal ? 1 : 0);
                break;
        }
        return (retval);
    }
    static async eval(exp, expectedType, task) {
        let res = null;
        let valStack = new Stack();
        if (exp !== null && exp.length > 0) {
            let me = new ExpressionEvaluator();
            let expStrTracker = new ExpStrTracker(exp, task.getNullArithmetic() === Constants.NULL_ARITH_NULLIFY);
            me.ExpTask = task;
            await me.execExpression(expStrTracker, valStack, expectedType);
            res = valStack.pop();
            if (expStrTracker.isNull())
                res.IsNull = true;
        }
        return res;
    }
    static async DiscardCndRangeResult(exp, task) {
        let valStack = new Stack();
        if (exp !== null && exp.length > 0) {
            let me = new ExpressionEvaluator();
            let expStrTracker = new ExpStrTracker(exp, task.getNullArithmetic() === Constants.NULL_ARITH_NULLIFY);
            me.ExpTask = task;
            return await me.DiscardCndRangeExpression(expStrTracker, valStack);
        }
        return false;
    }
    static set_a_pic(val) {
        let len = Math.min(val.length, 99);
        return StrUtil.ZstringMake(val, len);
    }
    eval_op_range(val1, val2, val3, resVal) {
        resVal.BoolVal = false;
        resVal.Attr = StorageAttribute.BOOLEAN;
        try {
            if (ExpressionEvaluator.val_cmp_any(val1, val2) >= 0) {
                val2 = val3;
                if (ExpressionEvaluator.val_cmp_any(val1, val2) <= 0)
                    resVal.BoolVal = true;
            }
        }
        catch (ex) {
            if (ex instanceof NullValueException) {
                super.SetNULL(resVal, ex.getAttr());
            }
            else
                throw ex;
        }
    }
    eval_op_rep_1(resVal, val1, val2, val3, val4) {
        if (val1.StrVal === null || val2.StrVal === null || val3.MgNumVal === null || val4.MgNumVal === null) {
            super.SetNULL(resVal, StorageAttribute.UNICODE);
            return;
        }
        ExpressionEvaluator.val_s_cpy(val1, resVal);
        let i = val3.MgNumVal.NUM_2_LONG();
        if (i < 1)
            i = 1;
        let j = val4.MgNumVal.NUM_2_LONG();
        if (j > val2.StrVal.length)
            j = val2.StrVal.length;
        if (i + j - 1 > resVal.StrVal.length)
            j = resVal.StrVal.length - i + 1;
        if ((j <= 0))
            return;
        let tmp_s = StrUtil.memcpy('', 0, resVal.StrVal, i + j - 1, resVal.StrVal.length - i - j + 1);
        resVal.StrVal = StrUtil.memcpy(resVal.StrVal, i - 1, val2.StrVal, 0, j);
        resVal.StrVal = StrUtil.memcpy(resVal.StrVal, i - 1 + j, tmp_s, 0, resVal.StrVal.length - i - j + 1);
        if (j - val2.StrVal.length > 0)
            resVal.StrVal = StrUtil.memset(resVal.StrVal, i + val2.StrVal.length - 1, ' ', j - val2.StrVal.length);
    }
    static val_s_cpy(val, resVal) {
        resVal.Attr = val.Attr;
        resVal.StrVal = val.StrVal;
        resVal.IsNull = val.IsNull;
        resVal.IncludeBlobPrefix = val.IncludeBlobPrefix;
    }
    val_cpy(val, resVal) {
        switch (val.Attr) {
            case StorageAttribute.ALPHA:
            case StorageAttribute.UNICODE:
            case StorageAttribute.BLOB:
            case StorageAttribute.BLOB_VECTOR:
                ExpressionEvaluator.val_s_cpy(val, resVal);
                break;
            case StorageAttribute.NUMERIC:
            case StorageAttribute.DATE:
            case StorageAttribute.TIME:
                if (!val.IsNull)
                    resVal.MgNumVal = new NUM_TYPE(val.MgNumVal);
                break;
            case StorageAttribute.BOOLEAN:
                resVal.BoolVal = val.BoolVal;
                break;
            default:
                Logger.Instance.WriteExceptionToLogWithMsg('Expression Evaluator.val_cpy no such type of attribute : ' + val.Attr);
                break;
        }
        resVal.Attr = val.Attr;
        resVal.IsNull = val.IsNull;
    }
    eval_op_ins(resVal, val1, val2, val3, val4) {
        resVal.Attr = StorageAttribute.UNICODE;
        if (val1.StrVal === null || val2.StrVal === null || val3.MgNumVal === null || val4.MgNumVal === null) {
            super.SetNULL(resVal, StorageAttribute.UNICODE);
            return;
        }
        let i = val1.StrVal.length;
        let ins_ofs = val3.MgNumVal.NUM_2_LONG() - 1;
        ins_ofs = Math.max(ins_ofs, 0);
        ins_ofs = Math.min(ins_ofs, i);
        let ins_len = val4.MgNumVal.NUM_2_LONG();
        ins_len = Math.max(ins_len, 0);
        ins_len = Math.min(ins_len, val2.StrVal.length);
        resVal.StrVal = StrUtil.memcpy('', 0, val1.StrVal, 0, ins_ofs);
        resVal.StrVal = StrUtil.memcpy(resVal.StrVal, ins_ofs, val2.StrVal, 0, ins_len);
        resVal.StrVal = StrUtil.memcpy(resVal.StrVal, ins_ofs + ins_len, val1.StrVal, ins_ofs, i - ins_ofs);
    }
    eval_op_del(resVal, val1, val2, val3) {
        if (val1.StrVal === null || val2.MgNumVal === null || val3.MgNumVal === null) {
            super.SetNULL(resVal, StorageAttribute.UNICODE);
            return;
        }
        ExpressionEvaluator.val_s_cpy(val1, resVal);
        let i = val2.MgNumVal.NUM_2_LONG() - 1;
        if (i < 0) {
            i = 0;
        }
        if (i > resVal.StrVal.length)
            i = resVal.StrVal.length;
        let j = val3.MgNumVal.NUM_2_LONG();
        if (i + j > resVal.StrVal.length)
            j = resVal.StrVal.length - i;
        if (j <= 0)
            return;
        resVal.StrVal = StrUtil.memcpy(resVal.StrVal, i, resVal.StrVal, i + j, resVal.StrVal.length - i);
    }
    eval_op_flip(resVal, val1) {
        resVal.Attr = StorageAttribute.UNICODE;
        if (val1.StrVal === null) {
            super.SetNULL(resVal, StorageAttribute.UNICODE);
            return;
        }
        let rev_str = new StringBuilder(val1.StrVal);
        resVal.StrVal = StrUtil.ReverseString(rev_str).ToString();
    }
    eval_op_upper(resVal, val1) {
        resVal.Attr = StorageAttribute.UNICODE;
        if (val1.StrVal === null) {
            super.SetNULL(resVal, StorageAttribute.UNICODE);
            return;
        }
        resVal.StrVal = val1.StrVal.toUpperCase();
    }
    eval_op_lower(resVal, val1) {
        resVal.Attr = StorageAttribute.UNICODE;
        if (val1.StrVal == null) {
            super.SetNULL(resVal, StorageAttribute.UNICODE);
            return;
        }
        resVal.StrVal = val1.StrVal.toLowerCase();
    }
    eval_op_crc(resVal, val1, val2) {
        resVal.Attr = StorageAttribute.ALPHA;
        if (val1.StrVal == null || val2.MgNumVal == null) {
            super.SetNULL(resVal, StorageAttribute.ALPHA);
            return;
        }
        let mode = val2.MgNumVal.NUM_2_LONG();
        let res = 0;
        switch (mode) {
            case 0:
                res = ExpressionEvaluator.eval_crc_16(val1.StrVal);
                break;
        }
        let left = String.fromCharCode(res % 256);
        let right = String.fromCharCode(res / 256);
        resVal.StrVal = '' + left + right;
    }
    static eval_crc_16(buf) {
        let crc_16_table = [
            40961, 61441, 55297, 52225, 50689, 49921, 49537, 49345
        ];
        let buffer_idx = 0;
        let len = buf.length;
        let crc = 0;
        for (; len > 0; len--) {
            let bt = buf.charCodeAt(buffer_idx++);
            bt = (bt ^ ExpressionEvaluator.LO_CHAR(crc));
            crc = ExpressionEvaluator.LO_CHAR(ExpressionEvaluator.MK_SHRT(0, ExpressionEvaluator.HI_CHAR(crc)));
            let mask;
            let tbl_idx;
            for (tbl_idx = 0, mask = ExpressionEvaluator.LO_CHAR(0x80); tbl_idx < 8; tbl_idx++, mask = (ExpressionEvaluator.LO_CHAR(mask) >> 1)) {
                if (ExpressionEvaluator.LO_CHAR((bt & ExpressionEvaluator.LO_CHAR(mask))) !== 0)
                    crc = (crc ^ crc_16_table[tbl_idx]);
            }
        }
        return (crc);
    }
    static LO_CHAR(n) {
        return (n & 0xff);
    }
    static HI_CHAR(n) {
        return ((n & 0xff00) >> 8);
    }
    static MK_SHRT(c1, c2) {
        return ((c1 << 8) | c2);
    }
    static MK_LONG(c1, c2, c3, c4) {
        return ((c1 << 24) | (c2 << 16) | (c3 << 8) | c4);
    }
    eval_op_chkdgt(resVal, val1, val2) {
        let weight_vals = [
            String.fromCharCode(1), String.fromCharCode(2), String.fromCharCode(5), String.fromCharCode(3), String.fromCharCode(6), String.fromCharCode(4), String.fromCharCode(8),
            String.fromCharCode(7), String.fromCharCode(10), String.fromCharCode(9)
        ];
        let pos;
        let mul;
        let c_str;
        let digits;
        if (val1.StrVal === null || val2.MgNumVal === null) {
            super.SetNULL(resVal, StorageAttribute.NUMERIC);
            return;
        }
        let mode = val2.MgNumVal.NUM_2_LONG();
        let res = 0;
        switch (mode) {
            case 0:
                mul = 2;
                for (pos = val1.StrVal.length; pos >= 1; pos--) {
                    c_str = val1.StrVal.substr(pos - 1);
                    digits = this.a_2_long(c_str, 1) * mul;
                    res += digits + (digits > 9 ? 1 : 0);
                    mul = 3 - mul;
                }
                res %= 10;
                if (res !== 0)
                    res = 10 - res;
                break;
            case 1:
                for (pos = val1.StrVal.length; pos >= 1; pos--) {
                    mul = weight_vals[(val1.StrVal.length - pos) % 10].charCodeAt(0);
                    let c_char = val1.StrVal[pos - 1].toUpperCase();
                    c_str = val1.StrVal.substr(pos - 1);
                    if (UtilStrByteMode.isDigit(c_char))
                        digits = this.a_2_long(c_str, 1) * mul;
                    else if (NChar.IsUpper(c_str[0]))
                        digits = (c_str[0].charCodeAt(0) - 'A'.charCodeAt(0) + 1) * mul;
                    else
                        digits = 0;
                    res += digits;
                }
                res %= 11;
                if (res !== 0)
                    res = 11 - res;
                break;
        }
        super.ConstructMagicNum(resVal, res, StorageAttribute.NUMERIC);
    }
    a_2_long(str, len) {
        let n = 0;
        for (let pos = 0; pos < len; pos = pos + 1) {
            if (UtilStrByteMode.isDigit(str.charAt(pos))) {
                n = n * 10;
                n += (str.charCodeAt(pos) - '0'.charCodeAt(0));
            }
        }
        return n;
    }
    eval_op_soundx(resVal, val1) {
        let soundx_vals = [
            '0', '1', '2', '3', '0', '1', '2', '0', '0', '2', '2', '4', '5', '5', '0', '1', '2',
            '6',
            '2', '3', '0', '1', '0', '2', '0', '2'
        ];
        if (val1.StrVal === null) {
            super.SetNULL(resVal, StorageAttribute.ALPHA);
            return;
        }
        resVal.Attr = StorageAttribute.ALPHA;
        resVal.StrVal = '0000';
        let lastc = ' ';
        let outpos = 0;
        for (let inpos = 0; inpos < val1.StrVal.length; inpos++) {
            let inc = val1.StrVal.charAt(inpos).toUpperCase();
            let outc = soundx_vals[(inc.charCodeAt(0) - 'A'.charCodeAt(0))];
            if (inpos === 0)
                resVal.StrVal = ExpressionEvaluator.setAt(resVal.StrVal, outpos++, inc);
            else if (outc > '0' && outc !== lastc) {
                resVal.StrVal = ExpressionEvaluator.setAt(resVal.StrVal, outpos++, outc);
                if (outpos > 3)
                    break;
            }
            lastc = outc;
        }
    }
    static setAt(str, pos, ch) {
        let buffer = new StringBuilder(str);
        if (pos < str.length) {
            buffer.set_Item(pos, ch);
        }
        else {
            buffer.Append(ch);
        }
        return buffer.ToString();
    }
    eval_op_hstr(resVal, val1) {
        let num16 = new NUM_TYPE();
        let newnum;
        let digit;
        let outstr = new Array(30);
        let tmpOutStr = new StringBuilder(outstr.length);
        let negative = false;
        resVal.Attr = StorageAttribute.ALPHA;
        if (val1.MgNumVal == null) {
            super.SetNULL(resVal, StorageAttribute.ALPHA);
            return;
        }
        num16.num_4_a_std('16');
        let orgnum = new NUM_TYPE(val1.MgNumVal);
        if (orgnum.num_is_neg()) {
            negative = true;
            orgnum.num_abs();
        }
        let digits = 0;
        while (true) {
            newnum = NUM_TYPE.mod(orgnum, num16);
            orgnum = NUM_TYPE.div(orgnum, num16);
            orgnum.num_trunc(0);
            digit = newnum.NUM_2_LONG();
            digits++;
            ExpressionEvaluator.int_2_hex(outstr, outstr.length - digits, 1, digit, 0);
            if (orgnum.num_is_zero())
                break;
        }
        if (negative) {
            digits++;
            outstr[outstr.length - digits] = '-';
        }
        for (digit = outstr.length - digits; digit < outstr.length; digit++)
            tmpOutStr.Append(outstr[digit]);
        resVal.StrVal = tmpOutStr.ToString();
    }
    static int_2_hex(str, strPos, len, n, lead) {
        let pos = len;
        do {
            let digit = n % 16;
            if (digit < 10)
                str[--pos + strPos] = String.fromCharCode('0'.charCodeAt(0) + digit);
            else
                str[--pos + strPos] = String.fromCharCode('A'.charCodeAt(0) + digit - 10);
            n = Math.floor(n / 16);
        } while (pos > 0 && n !== 0);
        ExpressionEvaluator.lib_a_fill(str, len, pos + strPos, lead);
        return;
    }
    static lib_a_fill(str, len, pos, lead) {
        if (lead === 0) {
            len -= pos;
            if (len > 0 && pos > 0) {
                StrUtil.memcpy(str, 0, str, pos, len);
                StrUtil.memset(str, len, ' ', pos);
            }
        }
        else {
            if (pos > 0)
                StrUtil.memset(str, 0, String.fromCharCode(lead), pos);
        }
        return;
    }
    eval_op_hval(resVal, val1) {
        let num16 = new NUM_TYPE();
        let num = new NUM_TYPE();
        let digits;
        let state = 0;
        let negative = false;
        if (val1.StrVal === null) {
            super.SetNULL(resVal, StorageAttribute.NUMERIC);
            return;
        }
        num16.num_4_a_std('16');
        resVal.MgNumVal = new NUM_TYPE();
        resVal.MgNumVal.NUM_ZERO();
        for (digits = 0; digits < val1.StrVal.length; digits++) {
            let digitc = val1.StrVal[digits];
            if (digitc === '-' && state === 0)
                negative = true;
            let digit = this.hex_2_long(val1.StrVal, digits, 1);
            if (digit === 0 && digitc !== '0')
                continue;
            state = 1;
            resVal.MgNumVal = NUM_TYPE.mul(resVal.MgNumVal, num16);
            num.NUM_4_LONG(digit);
            resVal.MgNumVal = NUM_TYPE.add(resVal.MgNumVal, num);
        }
        if (negative)
            resVal.MgNumVal.num_neg();
        resVal.Attr = StorageAttribute.NUMERIC;
    }
    hex_2_long(str, strCount, len) {
        let pos;
        let n = 0;
        for (pos = strCount; pos < strCount + len; pos++) {
            let digit = str.charAt(pos).toUpperCase();
            if (UtilStrByteMode.isDigit(digit)) {
                n *= 16;
                n += digit.charCodeAt(0) - '0'.charCodeAt(0);
            }
            else if (digit >= 'A' && digit <= 'F') {
                n *= 16;
                n += digit.charCodeAt(0) - 'A'.charCodeAt(0) + 10;
            }
        }
        return n;
    }
    eval_op_chr(resVal, val1) {
        resVal.Attr = StorageAttribute.ALPHA;
        if (val1.MgNumVal === null) {
            super.SetNULL(resVal, StorageAttribute.ALPHA);
            return;
        }
        resVal.StrVal = String.fromCharCode(val1.MgNumVal.NUM_2_LONG())[0];
    }
    eval_op_asc(resVal, val1) {
        if (val1.StrVal === null) {
            super.SetNULL(resVal, StorageAttribute.NUMERIC);
            return;
        }
        let c = (val1.StrVal.length > 0) ? (Encoding.ASCII.GetBytes(val1.StrVal))[0] : 0;
        this.ConstructMagicNum(resVal, c, StorageAttribute.NUMERIC);
    }
    eval_op_mstr(resVal, val1, val2) {
        resVal.Attr = StorageAttribute.ALPHA;
        if (val1.MgNumVal == null && val2.MgNumVal == null) {
            super.SetNULL(resVal, StorageAttribute.ALPHA);
            return;
        }
        let num = new NUM_TYPE(val1.MgNumVal);
        if (num.NUM_IS_LONG())
            num.num_4_std_long();
        let len = val2.MgNumVal.NUM_2_LONG();
        len = Math.max(len, 2);
        let tmpArray = new Int8Array(len);
        for (let i = 0; i < len; i++)
            tmpArray[i] = num.Data[i];
        let tmpBytes = Misc.ToByteArray(tmpArray);
        resVal.StrVal = Environment.Instance.GetEncoding().GetString(tmpBytes, 0, tmpBytes.length);
    }
    eval_op_mval(resVal, val1) {
        resVal.Attr = StorageAttribute.NUMERIC;
        if (val1.StrVal == null) {
            super.SetNULL(resVal, StorageAttribute.NUMERIC);
            return;
        }
        resVal.MgNumVal = new NUM_TYPE();
        resVal.MgNumVal.NUM_SET_ZERO();
        let len = Math.min(val1.StrVal.length, NUM_TYPE.NUM_SIZE);
        resVal.MgNumVal = new NUM_TYPE(Misc.ToSByteArray(Environment.Instance.GetEncoding().GetBytes(val1.StrVal)), 0, len);
    }
    eval_op_dstr(resVal, val1, val2, displayConvertor) {
        resVal.Attr = StorageAttribute.UNICODE;
        if (val1.MgNumVal == null || val2.StrVal == null) {
            super.SetNULL(resVal, StorageAttribute.UNICODE);
            return;
        }
        resVal.StrVal = displayConvertor.to_a(resVal.StrVal, 100, val1.MgNumVal.NUM_2_ULONG(), val2.StrVal, this.ExpTask.getCompIdx());
    }
    eval_op_tstr(resVal, val1, val2, displayConvertor, milliSeconds) {
        resVal.Attr = StorageAttribute.ALPHA;
        if (val1.MgNumVal == null || val2.StrVal == null) {
            super.SetNULL(resVal, StorageAttribute.ALPHA);
            return;
        }
        resVal.StrVal = displayConvertor.time_2_a(resVal.StrVal, 100, val1.MgNumVal.NUM_2_ULONG(), val2.StrVal, this.ExpTask.getCompIdx(), milliSeconds);
    }
    eval_op_dval(resVal, val1, val2, displayConvertor) {
        if (val1.StrVal === null || val2.StrVal === null) {
            super.SetNULL(resVal, StorageAttribute.DATE);
            return;
        }
        if (val1.Attr === StorageAttribute.UNICODE)
            if (val1.StrVal.length + 2 <= NUM_TYPE.NUM_SIZE) {
            }
            else {
                let tmp = new Array(val1.StrVal.length + 2);
                for (let _ai = 0; _ai < tmp.length; ++_ai)
                    tmp[_ai] = '\0';
                StrUtil.memcpy(tmp, 0, NString.ToCharArray(val1.StrVal), 0, val1.StrVal.length);
            }
        let l = displayConvertor.a_2_date(val1.StrVal, val2.StrVal, this.ExpTask.getCompIdx());
        if (l >= 1000000000)
            l = 0;
        super.ConstructMagicNum(resVal, l, StorageAttribute.DATE);
    }
    eval_op_tval(resVal, val1, val2, displayConvertor, milliSeconds) {
        if (val1.StrVal === null || val2.StrVal === null) {
            super.SetNULL(resVal, StorageAttribute.TIME);
            return;
        }
        let pic = new PIC(val2.StrVal, StorageAttribute.TIME, this.ExpTask.getCompIdx());
        let l = displayConvertor.a_2_time(val1.StrVal, pic, milliSeconds);
        if (l >= 1000000000)
            l = 0;
        super.ConstructMagicNum(resVal, l, StorageAttribute.TIME);
    }
    eval_op_day(resVal, val1) {
        this.eval_op_date_brk(resVal, val1.MgNumVal, 0);
    }
    eval_op_month(resVal, val1) {
        this.eval_op_date_brk(resVal, val1.MgNumVal, 1);
    }
    eval_op_year(resVal, val1) {
        this.eval_op_date_brk(resVal, val1.MgNumVal, 2);
    }
    eval_op_dow(resVal, val1) {
        this.eval_op_date_brk(resVal, val1.MgNumVal, 3);
    }
    eval_op_second(resVal, val1) {
        this.eval_op_time_brk(resVal, val1.MgNumVal, 2);
    }
    eval_op_minute(resVal, val1) {
        this.eval_op_time_brk(resVal, val1.MgNumVal, 1);
    }
    eval_op_hour(resVal, val1) {
        this.eval_op_time_brk(resVal, val1.MgNumVal, 0);
    }
    eval_op_date_brk(resVal, val1, typ) {
        if (val1 === null) {
            super.SetNULL(resVal, StorageAttribute.NUMERIC);
            return;
        }
        let d = val1.NUM_2_LONG();
        let breakParams = DisplayConvertor.Instance.getNewDateBreakParams();
        DisplayConvertor.Instance.date_break_datemode(breakParams, d, false, this.ExpTask.getCompIdx());
        let year = breakParams.year;
        let month = breakParams.month;
        let day = breakParams.day;
        let doy = breakParams.doy;
        let dow = breakParams.dow;
        switch (typ) {
            case 0:
                d = day;
                break;
            case 1:
                d = month;
                break;
            case 2:
                d = year;
                break;
            case 3:
                d = dow;
                break;
            case 4:
                d = UtilDateJpn.getInstance().date_jpn_year_ofs(year, doy);
                break;
            default:
                d = 0;
                break;
        }
        super.ConstructMagicNum(resVal, d, StorageAttribute.NUMERIC);
    }
    eval_op_time_brk(resVal, val1, typ) {
        if (val1 === null) {
            super.SetNULL(resVal, StorageAttribute.NUMERIC);
            return;
        }
        let d = val1.NUM_2_ULONG();
        let breakParams = DisplayConvertor.Instance.getNewTimeBreakParams();
        DisplayConvertor.time_break(breakParams, d);
        let hour = breakParams.hour;
        let minute = breakParams.minute;
        let second = breakParams.second;
        switch (typ) {
            case 0:
                d = hour;
                break;
            case 1:
                d = minute;
                break;
            case 2:
                d = second;
                break;
            default:
                d = 0;
                break;
        }
        super.ConstructMagicNum(resVal, d, StorageAttribute.NUMERIC);
    }
    async eval_op_addDateTime(resVal, dateVal, timeVal, yearsVal, monthsVal, daysVal, hoursVal, minutesVal, secondsVal) {
        let tmpVal = new ExpVal();
        if (dateVal.MgNumVal === null || timeVal.MgNumVal === null) {
            resVal.Attr = StorageAttribute.BOOLEAN;
            resVal.BoolVal = false;
            return;
        }
        let fldTime = this.GetFieldOfContextTask(timeVal.MgNumVal.NUM_2_LONG());
        super.SetVal(tmpVal, fldTime.getType(), fldTime.getValue(true), null);
        this.eval_op_addtime(resVal, tmpVal, hoursVal, minutesVal, secondsVal);
        let time = resVal.MgNumVal.NUM_2_LONG();
        let date = Math.floor(time / (60 * 60 * 24));
        time = time % (60 * 60 * 24);
        if (time < 0) {
            date--;
            time = (60 * 60 * 24) - (-time);
        }
        let fldDate = this.GetFieldOfContextTask(dateVal.MgNumVal.NUM_2_LONG());
        super.SetVal(tmpVal, fldDate.getType(), fldDate.getValue(true), null);
        this.eval_op_adddate(resVal, tmpVal, yearsVal, monthsVal, daysVal);
        date += resVal.MgNumVal.NUM_2_LONG();
        tmpVal.MgNumVal.NUM_4_LONG(time);
        await fldTime.setValueAndStartRecompute(tmpVal.ToMgVal(), false, true, false, false);
        await fldTime.updateDisplay();
        tmpVal.MgNumVal.NUM_4_LONG(date);
        await fldDate.setValueAndStartRecompute(tmpVal.ToMgVal(), false, true, false, false);
        await fldDate.updateDisplay();
        resVal.Attr = StorageAttribute.BOOLEAN;
        resVal.BoolVal = true;
    }
    async eval_op_difdt(resVal, date1val, time1val, date2val, time2val, difDateVal, difTimeVal) {
        let tmpVal = new ExpVal();
        tmpVal.MgNumVal = new NUM_TYPE();
        tmpVal.Attr = StorageAttribute.NUMERIC;
        if (difDateVal.MgNumVal === null || difTimeVal.MgNumVal === null) {
            resVal.Attr = StorageAttribute.BOOLEAN;
            resVal.BoolVal = false;
            return;
        }
        let difDate = date1val.MgNumVal.NUM_2_LONG() - date2val.MgNumVal.NUM_2_LONG();
        let difTime = time1val.MgNumVal.NUM_2_LONG() - time2val.MgNumVal.NUM_2_LONG();
        if ((difTime < 0) && (difTime > -86400) && (difDate > 0)) {
            difDate--;
            difTime = 86400 - (-difTime);
        }
        let fldDate = this.GetFieldOfContextTask(difDateVal.MgNumVal.NUM_2_LONG());
        let fldTime = this.GetFieldOfContextTask(difTimeVal.MgNumVal.NUM_2_LONG());
        tmpVal.MgNumVal.NUM_4_LONG(difDate);
        await fldDate.setValueAndStartRecompute(tmpVal.ToMgVal(), false, true, false, false);
        await fldDate.updateDisplay();
        tmpVal.MgNumVal.NUM_4_LONG(difTime);
        await fldTime.setValueAndStartRecompute(tmpVal.ToMgVal(), false, true, false, false);
        await fldTime.updateDisplay();
        resVal.Attr = StorageAttribute.BOOLEAN;
        resVal.BoolVal = true;
    }
    eval_op_ndow(resVal, val1, displayConvertor) {
        if (val1.MgNumVal === null) {
            super.SetNULL(resVal, StorageAttribute.NUMERIC);
            return;
        }
        val1.MgNumVal = this.mul_add(val1.MgNumVal, 0, 6);
        this.eval_op_cdow(resVal, val1.MgNumVal, displayConvertor);
    }
    eval_op_nmonth(resVal, val1, displayConvertor) {
        if (val1.MgNumVal == null) {
            super.SetNULL(resVal, StorageAttribute.NUMERIC);
            return;
        }
        val1.MgNumVal = this.mul_add(val1.MgNumVal, 31, -30);
        this.eval_op_cmonth(resVal, val1.MgNumVal, displayConvertor);
    }
    mul_add(num, mul, add) {
        let tmp = new NUM_TYPE();
        if (num === null)
            return null;
        if (mul !== 0) {
            tmp.NUM_4_LONG(mul);
            num = NUM_TYPE.mul(num, tmp);
        }
        if (add !== 0) {
            tmp.NUM_4_LONG(add);
            num = NUM_TYPE.add(num, tmp);
        }
        return num;
    }
    eval_op_cdow(resVal, val1, displayConvertor) {
        this.eval_op_date_str(resVal, val1, 'WWWWWWWWWWT', displayConvertor);
    }
    eval_op_cmonth(resVal, val1, displayConvertor) {
        this.eval_op_date_str(resVal, val1, 'MMMMMMMMMMT', displayConvertor);
    }
    eval_op_date_str(resVal, val1, format, displayConvertor) {
        resVal.Attr = StorageAttribute.ALPHA;
        if (val1 === null) {
            super.SetNULL(resVal, StorageAttribute.ALPHA);
            return;
        }
        let dow = val1.NUM_2_ULONG();
        resVal.StrVal = displayConvertor.to_a(resVal.StrVal, 10, dow, format, this.ExpTask.getCompIdx());
    }
    eval_op_delay() {
    }
    eval_op_idle(resVal) {
        let n = 0;
        let idleTime = Environment.Instance.getIdleTime(this.ExpTask.getCompIdx());
        if (idleTime > 0) {
            let CurrTimeMilli = Misc.getSystemMilliseconds();
            n = Math.floor(Math.floor((CurrTimeMilli - LastFocusedManager.Instance.LastActionTime) / 1000) / idleTime);
        }
        resVal.MgNumVal = new NUM_TYPE();
        resVal.Attr = StorageAttribute.NUMERIC;
        resVal.MgNumVal.NUM_4_LONG(n * idleTime * 10);
    }
    eval_op_adddate(resVal, val1, val2, val3, val4) {
        let tries;
        if (val1.MgNumVal === null || val2.MgNumVal === null || val3.MgNumVal === null || val4.MgNumVal === null) {
            super.SetNULL(resVal, StorageAttribute.DATE);
            return;
        }
        let date = val1.MgNumVal.NUM_2_LONG();
        let breakParams = DisplayConvertor.Instance.getNewDateBreakParams();
        DisplayConvertor.Instance.date_break_datemode(breakParams, date, false, this.ExpTask.getCompIdx());
        let year = breakParams.year;
        let month = breakParams.month;
        let day = breakParams.day;
        if (Environment.Instance.GetDateMode(this.ExpTask.getCompIdx()) === 'B')
            year = Math.max(year - PICInterface.DATE_BUDDHIST_GAP, 0);
        year += val2.MgNumVal.NUM_2_LONG();
        month += val3.MgNumVal.NUM_2_LONG();
        let day1 = val4.MgNumVal.NUM_2_LONG();
        let add_day = (day === 0 && year !== 0 && month !== 0 && day1 !== 0) ? 1 : 0;
        let month1 = month + year * 12;
        year = Math.floor((month1 - 1) / 12);
        month = (month1 - 1) % 12 + 1;
        for (tries = 0; tries < 4; tries++) {
            date = DisplayConvertor.Instance.date_4_calender(year, month, day + add_day, 0, false);
            if (date < 1000000000)
                break;
            day--;
        }
        if (date === 1000000000)
            date = 0;
        else {
            date += day1 - add_day;
            date = Math.max(date, 0);
        }
        super.ConstructMagicNum(resVal, date, StorageAttribute.DATE);
    }
    eval_op_addtime(resVal, val1, val2, val3, val4) {
        if (val1.MgNumVal === null || val2.MgNumVal === null || val3.MgNumVal === null || val4.MgNumVal === null) {
            super.SetNULL(resVal, StorageAttribute.TIME);
            return;
        }
        let time = val1.MgNumVal.NUM_2_ULONG() + val2.MgNumVal.NUM_2_LONG() * 3600 + val3.MgNumVal.NUM_2_LONG() * 60 + val4.MgNumVal.NUM_2_LONG();
        super.ConstructMagicNum(resVal, time, StorageAttribute.TIME);
    }
    eval_op_bom(resVal, val1) {
        let breakParams;
        if (val1.MgNumVal == null) {
            super.SetNULL(resVal, StorageAttribute.DATE);
            return;
        }
        let date = val1.MgNumVal.NUM_2_ULONG();
        if (date !== 0) {
            breakParams = DisplayConvertor.Instance.getNewDateBreakParams();
            DisplayConvertor.Instance.date_break_datemode(breakParams, date, false, this.ExpTask.getCompIdx());
            let day = breakParams.day;
            date -= (day - 1);
        }
        super.ConstructMagicNum(resVal, date, StorageAttribute.DATE);
    }
    eval_op_boy(resVal, val1) {
        let breakParams;
        if (val1.MgNumVal === null) {
            super.SetNULL(resVal, StorageAttribute.DATE);
            return;
        }
        let date = val1.MgNumVal.NUM_2_ULONG();
        if (date !== 0) {
            breakParams = DisplayConvertor.Instance.getNewDateBreakParams();
            DisplayConvertor.Instance.date_break_datemode(breakParams, date, false, this.ExpTask.getCompIdx());
            let year = breakParams.year;
            let day = 1;
            let month = 1;
            if (Environment.Instance.GetDateMode(this.ExpTask.getCompIdx()) === 'B')
                year = Math.max(year - PICInterface.DATE_BUDDHIST_GAP, 0);
            date = DisplayConvertor.Instance.date_4_calender(year, month, day, 0, false);
        }
        super.ConstructMagicNum(resVal, date, StorageAttribute.DATE);
    }
    eval_op_eom(resVal, val1) {
        let breakParams;
        if (val1.MgNumVal === null) {
            super.SetNULL(resVal, StorageAttribute.DATE);
            return;
        }
        let date = val1.MgNumVal.NUM_2_ULONG();
        if (date !== 0) {
            breakParams = DisplayConvertor.Instance.getNewDateBreakParams();
            DisplayConvertor.Instance.date_break_datemode(breakParams, date, false, this.ExpTask.getCompIdx());
            let year = breakParams.year;
            let month = breakParams.month;
            let day = 31;
            if (Environment.Instance.GetDateMode(this.ExpTask.getCompIdx()) === 'B')
                year = Math.max(year - PICInterface.DATE_BUDDHIST_GAP, 0);
            let tries;
            for (tries = 0; tries < 4; tries++) {
                date = DisplayConvertor.Instance.date_4_calender(year, month, day, 0, false);
                if (date < 1000000000)
                    break;
                day--;
            }
        }
        super.ConstructMagicNum(resVal, date, StorageAttribute.DATE);
    }
    eval_op_eoy(resVal, val1) {
        if (val1.MgNumVal === null) {
            super.SetNULL(resVal, StorageAttribute.DATE);
            return;
        }
        let date = val1.MgNumVal.NUM_2_ULONG();
        if (date !== 0) {
            let breakParams = DisplayConvertor.Instance.getNewDateBreakParams();
            DisplayConvertor.Instance.date_break_datemode(breakParams, date, false, this.ExpTask.getCompIdx());
            let year = breakParams.year;
            let month = 12;
            let day = 31;
            if (Environment.Instance.GetDateMode(this.ExpTask.getCompIdx()) === 'B')
                year = Math.max(year - PICInterface.DATE_BUDDHIST_GAP, 0);
            date = DisplayConvertor.Instance.date_4_calender(year, month, day, 0, false);
        }
        super.ConstructMagicNum(resVal, date, StorageAttribute.DATE);
    }
    eval_op_strtok(resVal, val1, val2, val3) {
        let tmp_s;
        let tmp_str;
        let idx;
        let delim;
        let ret_str = '';
        if (val1.StrVal === null || val2.MgNumVal === null || val3.StrVal === null) {
            super.SetNULL(resVal, StorageAttribute.UNICODE);
        }
        if (!NString.IsNullOrEmpty(val1.StrVal) && val3.StrVal.length > 0) {
            tmp_s = new StringBuilder(val1.StrVal.length + 2);
            idx = val2.MgNumVal.NUM_2_LONG();
            if (idx > 0) {
                delim = NString.TrimEnd(val3.StrVal, this._charsToTrim);
                tmp_s.Append(val1.StrVal);
                if (delim.length === 0) {
                    if (idx === 1)
                        ret_str = tmp_s.ToString();
                }
                else {
                    tmp_str = tmp_s.ToString();
                    let i;
                    for (i = 0; i < idx; i++) {
                        ret_str = StrUtil.strstr(tmp_str, delim);
                        if (ret_str === null) {
                            if (i === idx - 1)
                                ret_str = tmp_str;
                            break;
                        }
                        ret_str = tmp_str.substr(0, tmp_str.length - ret_str.length);
                        tmp_str = tmp_str.substr(ret_str.length + delim.length);
                    }
                }
            }
        }
        if (ret_str !== null) {
            resVal.Attr = StorageAttribute.UNICODE;
            resVal.StrVal = ret_str;
        }
        else {
            resVal.Attr = StorageAttribute.UNICODE;
            resVal.StrVal = '';
        }
        idx = val2.MgNumVal.NUM_2_LONG();
        if (!NString.IsNullOrEmpty(val1.StrVal) && val3.StrVal.length === 0 && idx === 1) {
            resVal.Attr = StorageAttribute.UNICODE;
            resVal.StrVal = val1.StrVal;
        }
    }
    eval_op_dbround(resVal, val1, val2) {
        if (val1.MgNumVal === null || val2.MgNumVal === null) {
            super.SetNULL(resVal, StorageAttribute.NUMERIC);
            return;
        }
        resVal.MgNumVal = new NUM_TYPE(val1.MgNumVal);
        let whole = val2.MgNumVal.NUM_2_LONG();
        if (whole < 0)
            resVal.MgNumVal.dbRound(-whole);
        else
            resVal.MgNumVal.round(whole);
        resVal.Attr = StorageAttribute.NUMERIC;
    }
    eval_op_varpic(resVal, val1, val2) {
        let fld;
        let ctrl;
        if (val2.MgNumVal === null) {
            super.SetNULL(resVal, StorageAttribute.UNICODE);
            return;
        }
        if (val1.MgNumVal === null) {
            super.SetNULL(resVal, StorageAttribute.UNICODE);
            return;
        }
        let mode = val2.MgNumVal.NUM_2_LONG();
        let itm = val1.MgNumVal.NUM_2_LONG();
        resVal.Attr = StorageAttribute.UNICODE;
        try {
            fld = this.GetFieldOfContextTask(itm);
        }
        catch (ex) {
            if (ex instanceof Exception) {
                Logger.Instance.WriteExceptionToLog(ex);
                fld = null;
            }
            else
                throw ex;
        }
        if (fld === null) {
            Logger.Instance.WriteExceptionToLogWithMsg('ExpressionEvaluator.eval_op_varpic there is no control number ' + itm);
            resVal.StrVal = '';
            return;
        }
        if (mode !== 0) {
            ctrl = fld.getCtrl();
            if (ctrl !== null) {
                resVal.StrVal = ctrl.getPIC().getFormat();
                return;
            }
        }
        if (fld.getType() !== StorageAttribute.BLOB && fld.getType() !== StorageAttribute.BLOB_VECTOR) {
            resVal.StrVal = fld.getPicture();
            return;
        }
        resVal.StrVal = '';
        return;
    }
    eval_op_varattr(resVal, val1) {
        let fld;
        resVal.Attr = StorageAttribute.ALPHA;
        if (val1.MgNumVal === null) {
            super.SetNULL(resVal, StorageAttribute.ALPHA);
            return;
        }
        let itm = val1.MgNumVal.NUM_2_LONG();
        try {
            fld = this.GetFieldOfContextTask(itm);
        }
        catch (ex) {
            if (ex instanceof Exception) {
                Logger.Instance.WriteExceptionToLog(ex);
                fld = null;
            }
            else
                throw ex;
        }
        if (fld === null) {
            Logger.Instance.WriteExceptionToLogWithMsg('ExpressionEvaluator.eval_op_varattr there is no control number ' + itm);
            resVal.StrVal = '';
            return;
        }
        let attr = fld.getType();
        resVal.StrVal = '' + ExpressionEvaluator.GetAttributeChar(attr);
    }
    exp_null_val_get(exp_attr, opcode, null_parm) {
        let ptr = '';
        let num_val = 0;
        null_parm.IsNull = true;
        if (opcode === ExpressionInterface.EXP_OP_NULL) {
            null_parm.Attr = exp_attr;
            if (exp_attr === StorageAttribute.ALPHA)
                ptr = '';
            switch (exp_attr) {
                case StorageAttribute.ALPHA:
                case StorageAttribute.BLOB:
                case StorageAttribute.BLOB_VECTOR:
                case StorageAttribute.MEMO:
                    opcode = ExpressionInterface.EXP_OP_NULL_A;
                    break;
                case StorageAttribute.NUMERIC:
                    opcode = ExpressionInterface.EXP_OP_NULL_N;
                    break;
                case StorageAttribute.BOOLEAN:
                    opcode = ExpressionInterface.EXP_OP_NULL_B;
                    break;
                case StorageAttribute.DATE:
                    opcode = ExpressionInterface.EXP_OP_NULL_D;
                    break;
                case StorageAttribute.TIME:
                    opcode = ExpressionInterface.EXP_OP_NULL_T;
                    break;
                case StorageAttribute.UNICODE:
                    opcode = ExpressionInterface.EXP_OP_NULL_U;
                    break;
            }
        }
        switch (opcode) {
            case ExpressionInterface.EXP_OP_NULL:
            case ExpressionInterface.EXP_OP_NULL_A:
                if (exp_attr !== StorageAttribute.BLOB &&
                    exp_attr !== StorageAttribute.BLOB_VECTOR)
                    null_parm.Attr = StorageAttribute.ALPHA;
                ptr = '';
                break;
            case ExpressionInterface.EXP_OP_NULL_N:
                null_parm.Attr = StorageAttribute.NUMERIC;
                break;
            case ExpressionInterface.EXP_OP_NULL_B:
                null_parm.Attr = StorageAttribute.BOOLEAN;
                num_val = 0;
                break;
            case ExpressionInterface.EXP_OP_NULL_D:
                null_parm.Attr = StorageAttribute.DATE;
                num_val = NNumber.Parse(PICInterface.DEFAULT_DATE);
                break;
            case ExpressionInterface.EXP_OP_NULL_T:
                null_parm.Attr = StorageAttribute.TIME;
                num_val = NNumber.Parse(PICInterface.DEFAULT_TIME);
                break;
            case ExpressionInterface.EXP_OP_NULL_U:
                if (exp_attr !== StorageAttribute.BLOB &&
                    exp_attr !== StorageAttribute.BLOB_VECTOR)
                    null_parm.Attr = StorageAttribute.UNICODE;
                ptr = '';
                break;
            case ExpressionInterface.EXP_OP_NULL_O:
                null_parm.Attr = StorageAttribute.BLOB;
                break;
        }
        switch (null_parm.Attr) {
            case StorageAttribute.ALPHA:
            case StorageAttribute.BLOB:
            case StorageAttribute.BLOB_VECTOR:
                null_parm.StrVal = ptr;
                break;
            case StorageAttribute.NUMERIC:
            case StorageAttribute.DATE:
            case StorageAttribute.TIME:
                if (opcode === ExpressionInterface.EXP_OP_NULL_N) {
                    let num_value = new Int8Array(NUM_TYPE.NUM_SIZE);
                    for (let i = 0; i < num_value.length; i++)
                        num_value[i] = 0;
                    null_parm.MgNumVal = new NUM_TYPE(num_value);
                }
                else
                    this.ConstructMagicNum(null_parm, num_val, null_parm.Attr);
                break;
            case StorageAttribute.UNICODE:
                null_parm.StrVal = ptr;
                break;
            case StorageAttribute.BOOLEAN:
                null_parm.BoolVal = false;
                break;
        }
    }
    exp_get_var(resValOrVal1, val1OrResVal, is_previous) {
        if (!isNullOrUndefined(is_previous))
            this.exp_get_var_0(resValOrVal1, val1OrResVal, is_previous);
        else
            this.exp_get_var_1(resValOrVal1, val1OrResVal);
    }
    exp_get_var_0(resVal, val1, is_previous) {
        let fld = null;
        if (val1.MgNumVal !== null) {
            let itm = val1.MgNumVal.NUM_2_LONG();
            fld = this.GetFieldOfContextTask(itm);
        }
        if (fld === null) {
            super.SetNULL(resVal, StorageAttribute.NONE);
            return;
        }
        if (fld.IsExposedToClient === false) {
            let sb = new StringBuilder();
            sb.Append(NString.Format('Error: Variable \'{0}\' is not exposed to client.', fld.getVarName()));
            alert(sb.ToString());
            resVal.IsNull = true;
            return;
        }
        if (is_previous)
            fld.getTask().setEvalOldValues(true);
        super.SetVal(resVal, fld.getType(), fld.getValue(true), null);
        if (is_previous) {
            if (fld.isOriginalValueNull())
                super.SetNULL(resVal, StorageAttribute.NONE);
        }
        else
            resVal.IsNull = fld.isNull();
        if (is_previous)
            fld.getTask().setEvalOldValues(false);
    }
    eval_op_varmod(resVal, val1) {
        if (val1.MgNumVal === null) {
            super.SetNULL(resVal, StorageAttribute.BOOLEAN);
            return;
        }
        let itm = val1.MgNumVal.NUM_2_LONG();
        let fld = this.GetFieldOfContextTask(itm);
        resVal.Attr = StorageAttribute.BOOLEAN;
        resVal.BoolVal = false;
        if (fld !== null) {
            let idx = fld.getId();
            let dv = fld.getTask().DataView;
            let rec = dv.getCurrRec();
            resVal.BoolVal = !rec.fldValsEqual(dv.getOriginalRec(), idx);
        }
    }
    eval_op_varinp(resVal, val1) {
        let i = 0;
        if (val1.MgNumVal === null) {
            super.SetNULL(resVal, StorageAttribute.NUMERIC);
            return;
        }
        let expkern_parent = val1.MgNumVal.NUM_2_LONG();
        if ((expkern_parent >= 0 && expkern_parent < (this.ExpTask.getTaskDepth(false))) || expkern_parent === ExpressionEvaluator.TRIGGER_TASK) {
            let tsk = super.GetContextTask(expkern_parent);
            if (tsk !== null)
                i = tsk.ctl_itm_4_parent_vee(0, tsk.getCurrFieldIdx() + 1);
        }
        super.ConstructMagicNum(resVal, i, StorageAttribute.NUMERIC);
    }
    eval_op_varname(resVal, val1) {
        if (val1.MgNumVal === null) {
            super.SetNULL(resVal, StorageAttribute.ALPHA);
            return;
        }
        let itm = val1.MgNumVal.NUM_2_LONG();
        let fld = this.GetFieldOfContextTask(itm);
        let buffer = (fld !== null) ? fld.getName() : '';
        resVal.StrVal = buffer;
        resVal.Attr = StorageAttribute.ALPHA;
    }
    eval_op_VarDisplayName(resVal, val1) {
        resVal.Attr = StorageAttribute.UNICODE;
        resVal.StrVal = '';
        if (val1.MgNumVal !== null) {
            let itm = val1.MgNumVal.NUM_2_LONG();
            let fld = this.GetFieldOfContextTask(itm);
            if (fld !== null)
                resVal.StrVal = fld.VarDisplayName;
        }
    }
    async eval_op_controlItemRefresh(val1, val2, resVal) {
        let success = false;
        let parent = val2.MgNumVal.NUM_2_LONG();
        resVal.Attr = StorageAttribute.BOOLEAN;
        if ((parent >= 0 && parent < (this.ExpTask.getTaskDepth(false))) || parent === ExpressionEvaluator.TRIGGER_TASK) {
            let tsk = super.GetContextTask(parent);
            if (tsk != null && tsk.getForm() != null) {
                let control = tsk.getForm().GetCtrl(val1.StrVal);
                if (control != null && control.isChoiceControl() && control.isDataCtrl()) {
                    let command = CommandFactory.CreateControlItemsRefreshCommand(tsk.getTaskTag(), control);
                    await tsk.DataviewManager.CurrentDataviewManager.Execute(command);
                    success = true;
                }
            }
        }
        resVal.BoolVal = success;
    }
    eval_op_VarControlID(resVal, val1) {
        let ret = 0;
        if (val1.MgNumVal !== null) {
            let itm = val1.MgNumVal.NUM_2_LONG();
            if (itm === ExpressionEvaluator.TRIGGER_TASK)
                itm = (this.ExpTask.GetContextTask().ctl_itm_4_parent_vee(0, this.ExpTask.GetContextTask().getCurrFieldIdx() + 1));
            ret = this.ExpTask.GetContextTask().GetControlIDFromVarItem(itm - 1);
        }
        resVal.Attr = StorageAttribute.NUMERIC;
        resVal.MgNumVal = new NUM_TYPE();
        resVal.MgNumVal.NUM_4_LONG(ret);
    }
    async eval_op_ControlItemsList(resVal, val1) {
        resVal.Attr = StorageAttribute.UNICODE;
        resVal.StrVal = '';
        if (val1.MgNumVal !== null) {
            let controlID = val1.MgNumVal.NUM_2_LONG();
            let parent = 0;
            let refParent = new RefParam(parent);
            let mgControl = (this.ExpTask.GetContextTask().GetControlFromControlID(controlID - 1, refParent));
            parent = refParent.value;
            if (mgControl !== null && mgControl.isChoiceControl())
                resVal.StrVal = await mgControl.getForm().GetChoiceControlItemList(mgControl);
        }
    }
    async eval_op_ControlDisplayList(resVal, val1) {
        resVal.Attr = StorageAttribute.UNICODE;
        resVal.StrVal = '';
        if (val1.MgNumVal !== null) {
            let controlID = val1.MgNumVal.NUM_2_LONG();
            let parent = 0;
            let refParent = new RefParam(parent);
            let mgControl = this.ExpTask.GetContextTask().GetControlFromControlID(controlID - 1, refParent);
            parent = refParent.value;
            if (mgControl !== null && mgControl.isChoiceControl())
                resVal.StrVal = await mgControl.getForm().GetChoiceControlDisplayList(mgControl);
        }
    }
    eval_op_viewmod(resVal, val1) {
        if (val1.MgNumVal === null) {
            super.SetNULL(resVal, StorageAttribute.BOOLEAN);
            return;
        }
        let parent = val1.MgNumVal.NUM_2_LONG();
        if ((parent >= 0 && parent < (this.ExpTask.getTaskDepth(false))) || parent === ExpressionEvaluator.TRIGGER_TASK) {
            let tsk = super.GetContextTask(parent);
            if (!tsk.isMainProg()) {
                resVal.BoolVal = (tsk.DataView.getCurrRec()).Modified;
                if (!resVal.BoolVal) {
                    let currRec = tsk.DataView.getCurrRec();
                    let originalRec = tsk.DataView.getOriginalRec();
                    resVal.BoolVal = !currRec.isSameRecData(originalRec, true, true);
                }
            }
            else {
                resVal.BoolVal = false;
            }
        }
        else
            resVal.BoolVal = false;
        resVal.Attr = StorageAttribute.BOOLEAN;
    }
    eval_op_level(resVal, val1) {
        let outstr = '';
        if (val1.MgNumVal === null) {
            super.SetNULL(resVal, StorageAttribute.ALPHA);
            return;
        }
        let parent = val1.MgNumVal.NUM_2_LONG();
        if ((parent >= 0 && parent < (this.ExpTask.getTaskDepth(false))) || parent === ExpressionEvaluator.TRIGGER_TASK) {
            let tsk = super.GetContextTask(parent);
            outstr = tsk.getBrkLevel();
            if (parent !== ExpressionEvaluator.TRIGGER_TASK && tsk !== this.ExpTask) {
                if (outstr.toUpperCase() === ConstInterface.BRK_LEVEL_REC_MAIN.toUpperCase()) {
                    if (tsk.isMainProg()) {
                        outstr = ConstInterface.BRK_LEVEL_MAIN_PROG;
                    }
                    else {
                        let tskTree = new Array((this.ExpTask.getTaskDepth(false)));
                        for (let _ai = 0; _ai < tskTree.length; ++_ai)
                            tskTree[_ai] = null;
                        this.ExpTask.pathToRoot(tskTree, false);
                        if (parent > 0 && tskTree[parent - 1].IsSubForm)
                            outstr = ConstInterface.BRK_LEVEL_SUBFORM;
                    }
                }
            }
        }
        resVal.StrVal = outstr;
        resVal.Attr = StorageAttribute.ALPHA;
    }
    eval_op_counter(resVal, val1) {
        let num = 0;
        let parent = val1.MgNumVal.NUM_2_LONG();
        if ((parent >= 0 && parent < this.ExpTask.getTaskDepth(false)) || parent === ExpressionEvaluator.TRIGGER_TASK) {
            let task = super.GetContextTask(parent);
            num = ((task === null) ? 0 : task.getCounter());
        }
        resVal.Attr = StorageAttribute.NUMERIC;
        resVal.MgNumVal = new NUM_TYPE();
        resVal.MgNumVal.NUM_4_LONG(num);
    }
    eval_op_emptyDataview(resVal, val1) {
        let ret = false;
        let parent = val1.MgNumVal.NUM_2_LONG();
        if ((parent >= 0 && parent < this.ExpTask.getTaskDepth(false)) || parent === ExpressionEvaluator.TRIGGER_TASK) {
            let tsk = super.GetContextTask(parent);
            if (tsk !== null && tsk.DataView.isEmptyDataview())
                ret = true;
        }
        resVal.Attr = StorageAttribute.BOOLEAN;
        resVal.BoolVal = ret;
    }
    eval_op_mainlevel(resVal, val1) {
        let outstr = '';
        if (val1.MgNumVal === null) {
            super.SetNULL(resVal, StorageAttribute.ALPHA);
            return;
        }
        let parent = val1.MgNumVal.NUM_2_LONG();
        if ((parent >= 0 && parent < (this.ExpTask.getTaskDepth(false))) || parent === ExpressionEvaluator.TRIGGER_TASK) {
            let tsk = super.GetContextTask(parent);
            outstr = tsk.getMainLevel();
        }
        resVal.StrVal = outstr;
        resVal.Attr = StorageAttribute.ALPHA;
    }
    eval_op_maindisplay(resVal, val1) {
        let mainDspIdx = 0;
        if (val1.MgNumVal === null) {
            super.SetNULL(resVal, StorageAttribute.NUMERIC);
            return;
        }
        let parent = val1.MgNumVal.NUM_2_LONG();
        if ((parent >= 0 && parent < (this.ExpTask.getTaskDepth(false))) || parent === ExpressionEvaluator.TRIGGER_TASK) {
            let tsk = super.GetContextTask(parent);
            mainDspIdx = (tsk.getProp(PropInterface.PROP_TYPE_MAIN_DISPLAY)).GetComputedValueInteger();
        }
        super.ConstructMagicNum(resVal, mainDspIdx, StorageAttribute.NUMERIC);
    }
    eval_op_IsFirstRecordCycle(resVal, val1) {
        let isFirstRecCycle = false;
        if (val1.MgNumVal === null) {
            super.SetNULL(resVal, StorageAttribute.ALPHA);
            return;
        }
        let parent = val1.MgNumVal.NUM_2_LONG();
        if ((parent >= 0 && parent < (this.ExpTask.getTaskDepth(false))) || parent === ExpressionEvaluator.TRIGGER_TASK) {
            let tsk = super.GetContextTask(parent);
            isFirstRecCycle = tsk.isFirstRecordCycle();
        }
        resVal.BoolVal = isFirstRecCycle;
        resVal.Attr = StorageAttribute.BOOLEAN;
    }
    exp_is_default(resVal, val1) {
        resVal.Attr = StorageAttribute.BOOLEAN;
        resVal.BoolVal = false;
        let itm = val1.MgNumVal.NUM_2_LONG();
        let fld = (this.ExpTask.ctl_itm_2_parent_vee(itm - 1));
        if (fld === null)
            return;
        if (fld.isNull() && (fld.isNullDefault() || fld.getType() === StorageAttribute.BLOB_VECTOR))
            resVal.BoolVal = true;
        let val = fld.getValue(false);
        let defVal = fld.getDefaultValue();
        let type = fld.getType();
        resVal.BoolVal = ExpressionEvaluator.mgValsEqual(val, fld.isNull(), type, defVal, fld.isNullDefault(), type);
    }
    eval_op_IsLoggedIn(resVal) {
        resVal.Attr = StorageAttribute.BOOLEAN;
        resVal.BoolVal = UserDetails.Instance.getIsLoggedIn();
    }
    eval_op_appname(resVal) {
        resVal.Attr = StorageAttribute.ALPHA;
        resVal.StrVal = ServerConfig.Instance.getAppName();
    }
    eval_op_prog(resVal) {
        resVal.Attr = StorageAttribute.ALPHA;
        resVal.StrVal = ((this.ExpTask.queryTaskPath())).ToString();
    }
    eval_op_this(resVal) {
        let triggerTask = this.ExpTask;
        let Result = 0;
        if (triggerTask !== null) {
            Result = ExpressionEvaluator.TRIGGER_TASK;
        }
        super.ConstructMagicNum(resVal, Result, StorageAttribute.NUMERIC);
    }
    eval_op_stat(resVal, Parent, Modes) {
        let Ret = false;
        let iParent = Parent.MgNumVal.NUM_2_LONG();
        if ((iParent >= 0 && iParent < (this.ExpTask.getTaskDepth(false))) || iParent === ExpressionEvaluator.TRIGGER_TASK) {
            let Tsk = super.GetContextTask(iParent);
            if (Tsk !== null) {
                let tskMode = (Tsk.getMode()).toUpperCase();
                for (let i = 0; i < Modes.StrVal.length; i = i + 1) {
                    let mode = Modes.StrVal.charAt(i).toUpperCase();
                    let code = this.cst_code_trans_buf('I', 'MCDEPLRKSONB', mode, MsgInterface.EXPTAB_TSK_MODE_RT);
                    if (code === '\0') {
                        code = mode.toUpperCase();
                        if (code === 'Q')
                            code = 'E';
                    }
                    if (code === tskMode) {
                        Ret = true;
                        break;
                    }
                }
            }
        }
        resVal.Attr = StorageAttribute.BOOLEAN;
        resVal.BoolVal = Ret;
    }
    eval_op_subformExecMode(resVal, generation) {
        let subformExecMode = Task_SubformExecModeEnum.NO_SUBFORM;
        let iParent = generation.MgNumVal.NUM_2_LONG();
        if ((iParent >= 0 && iParent < (this.ExpTask.getTaskDepth(false))) || iParent === ExpressionEvaluator.TRIGGER_TASK) {
            let task = super.GetContextTask(iParent);
            if (task !== null) {
                if (task.IsSubForm)
                    subformExecMode = task.SubformExecMode;
            }
        }
        super.ConstructMagicNum(resVal, subformExecMode, StorageAttribute.NUMERIC);
    }
    async eval_op_varset(resVal, val, num) {
        resVal.BoolVal = true;
        resVal.Attr = StorageAttribute.BOOLEAN;
        if (num.MgNumVal === null) {
            return;
        }
        let itm = num.MgNumVal.NUM_2_LONG();
        let fld = this.GetFieldOfContextTask(itm);
        if (fld === null) {
            resVal.BoolVal = false;
            return;
        }
        if (StorageAttributeCheck.StorageFldAlphaUnicodeOrBlob(fld.getType(), val.Attr))
            this.ConvertExpVal(val, fld.getType());
        let bufptr;
        if (StorageAttributeCheck.isTheSameType(fld.getType(), val.Attr)) {
            switch (fld.getType()) {
                case StorageAttribute.ALPHA:
                case StorageAttribute.UNICODE:
                    bufptr = val.StrVal;
                    break;
                case StorageAttribute.NUMERIC:
                case StorageAttribute.DATE:
                case StorageAttribute.TIME:
                    bufptr = val.MgNumVal.toXMLrecord();
                    break;
                case StorageAttribute.BOOLEAN:
                    bufptr = val.BoolVal ? '1' : '0';
                    break;
                case StorageAttribute.BLOB:
                    bufptr = val.ToMgVal();
                    break;
                case StorageAttribute.BLOB_VECTOR:
                    bufptr = val.ToMgVal();
                    if (!val.IsNull) {
                        if (val.Attr === StorageAttribute.BLOB)
                            if (!VectorType.validateBlobContents(val.StrVal))
                                bufptr = null;
                        if (bufptr != null)
                            bufptr = Operation.operUpdateVectors(fld, bufptr);
                        if (bufptr != null)
                            break;
                    }
                default:
                    super.SetNULL(resVal, StorageAttribute.BOOLEAN);
                    return;
            }
        }
        else {
            bufptr = fld.getDefaultValue();
        }
        if (val.IsNull) {
            bufptr = fld.getNullValue();
            if (bufptr === null)
                fld.getMagicDefaultValue();
        }
        let setRecordUpdated = fld.getTask() !== this.ExpTask || fld.getTask().getBrkLevel() === ConstInterface.BRK_LEVEL_REC_SUFFIX;
        await fld.setValueAndStartRecompute(bufptr, val.IsNull, true, setRecordUpdated, false);
        await fld.updateDisplay();
    }
    eval_op_like(source, maskOrg, resVal) {
        let i;
        let j;
        let Source = source.StrVal;
        let MaskOrg = maskOrg.StrVal;
        let asteriskCnt = 0;
        let Same = true;
        let esc_ch;
        if (Source === null || MaskOrg === null) {
            super.SetNULL(resVal, StorageAttribute.BOOLEAN);
            return;
        }
        let SourceLen = Source.length;
        let MaskLen = MaskOrg.length;
        let Mask = new Array(MaskLen);
        let buffer = new StringBuilder(MaskLen);
        for (i = 0, j = 0, esc_ch = false; i < MaskLen; i++) {
            let currChr = MaskOrg[i];
            switch (currChr) {
                case '\\':
                    if (esc_ch)
                        Mask[j++] = currChr;
                    esc_ch = !esc_ch;
                    break;
                case '*':
                    if (esc_ch)
                        Mask[j++] = currChr;
                    else {
                        Mask[j++] = ExpressionEvaluator.ASTERISK_CHR;
                        asteriskCnt++;
                    }
                    esc_ch = false;
                    break;
                case '?':
                    Mask[j++] = esc_ch ? currChr : ExpressionEvaluator.QUESTION_CHR;
                    esc_ch = false;
                    break;
                default:
                    Mask[j++] = currChr;
                    esc_ch = false;
                    break;
            }
        }
        MaskLen = j;
        MaskOrg = ExpressionEvaluator.arrToStr(Mask, 0, Mask.length);
        let ast_last_ptr = MaskOrg.lastIndexOf(ExpressionEvaluator.ASTERISK_CHR);
        if (ast_last_ptr === -1)
            Same = ExpressionEvaluator.op_like_cmp(Source, MaskOrg);
        else {
            for (i = 0; Mask[i] !== ExpressionEvaluator.ASTERISK_CHR && Same; i++, MaskLen--, SourceLen--) {
                if (SourceLen === 0)
                    Same = false;
                else
                    Same = (Mask[i] === ExpressionEvaluator.QUESTION_CHR ? true : Mask[i] === Source[i]);
            }
            Source = Source.substr(i);
            Mask = ExpressionEvaluator.cutArray(Mask, i);
            while (Same && asteriskCnt !== 1) {
                let ast_ptr;
                let tmp_len;
                for (ast_ptr = 1, tmp_len = 0; ast_ptr + i !== ast_last_ptr; ast_ptr++, tmp_len++)
                    if (Mask[ast_ptr] === ExpressionEvaluator.ASTERISK_CHR)
                        break;
                asteriskCnt--;
                SourceLen = Source.length;
                if (tmp_len !== 0) {
                    if (SourceLen > 0) {
                        buffer.Remove(0, buffer.Length);
                        buffer.Append(Source);
                        Same = ExpressionEvaluator.op_like_map(buffer, ExpressionEvaluator.arrToStr(Mask, 1, tmp_len + 1), false);
                        Source = buffer.ToString();
                    }
                    else
                        Same = false;
                }
                i += ast_ptr;
                Mask = ExpressionEvaluator.cutArray(Mask, ast_ptr);
            }
            if (Mask[0] === ExpressionEvaluator.ASTERISK_CHR)
                Mask = ExpressionEvaluator.cutArray(Mask, 1);
            if (Same && (Mask.length > 0)) {
                buffer.Remove(0, buffer.Length);
                buffer.Append(Source);
                Same = ExpressionEvaluator.op_like_map(buffer, ExpressionEvaluator.arrToStr(Mask), true);
            }
        }
        resVal.Attr = StorageAttribute.BOOLEAN;
        resVal.BoolVal = Same;
    }
    static cutArray(source, from) {
        let length = source.length - from;
        let buffer = new Array(length);
        for (let curr = 0; curr < length; curr++)
            buffer[curr] = source[from + curr];
        return buffer;
    }
    eval_op_repstr(source, orgSubstr, newSubstr, resVal) {
        if (source.StrVal === null || orgSubstr.StrVal === null || newSubstr.StrVal === null || !StorageAttributeCheck.IsTypeAlphaOrUnicode(source.Attr) || !StorageAttributeCheck.IsTypeAlphaOrUnicode(orgSubstr.Attr) || !StorageAttributeCheck.IsTypeAlphaOrUnicode(newSubstr.Attr)) {
            super.SetNULL(resVal, StorageAttribute.UNICODE);
            return;
        }
        resVal.StrVal = NString.Replace(source.StrVal, orgSubstr.StrVal, newSubstr.StrVal);
        resVal.Attr = StorageAttribute.UNICODE;
    }
    static arrToStr(arr, from, to) {
        if (arguments.length === 1)
            return ExpressionEvaluator.arrToStr_0(arr);
        else
            return ExpressionEvaluator.arrToStr_1(arr, from, to);
    }
    static arrToStr_0(arr) {
        return ExpressionEvaluator.arrToStr(arr, 0, arr.length);
    }
    static arrToStr_1(arr, from, to) {
        let buffer = new StringBuilder(to - from);
        for (; from < to; from++)
            buffer.Append(arr[from]);
        return buffer.ToString();
    }
    static op_like_cmp(Source, MaskOrg) {
        let Same = true;
        let Mask = MaskOrg;
        let SourceLen = Source.length;
        let MaskLen = MaskOrg.length;
        if (SourceLen < MaskLen)
            Same = false;
        else if (SourceLen > MaskLen)
            Mask = MaskOrg;
        while (Mask.length < SourceLen)
            Mask += ' ';
        for (let i = 0; i < SourceLen && Same; i++)
            Same = (Mask.charAt(i) === ExpressionEvaluator.QUESTION_CHR || Mask.charAt(i) === Source.charAt(i));
        return Same;
    }
    static op_like_map(source, mask, end) {
        let same = false;
        let ptr = source.ToString();
        let i = 0;
        if (!end && source.Length < mask.length)
            return false;
        let j = 0;
        for (j = 0; j < source.Length && !same; j++) {
            same = true;
            if (end) {
                same = ExpressionEvaluator.op_like_cmp(ptr.substr(j), mask);
            }
            else {
                for (i = 0; i < mask.length && same; i++) {
                    if (j + i === source.Length) {
                        return false;
                    }
                    same = (mask.charAt(i) === ExpressionEvaluator.QUESTION_CHR || mask.charAt(i) === ptr.charAt(j + i));
                }
            }
        }
        if (same) {
            source.Remove(0, source.Length);
            source.Append(ptr.substr(j + i - 1));
        }
        return same;
    }
    exp_get_var_1(val1, resVal) {
        let fldName = val1.StrVal;
        let fld = this.ExpTask.getFieldByName(fldName);
        if (fld === null) {
            super.SetNULL(resVal, StorageAttribute.NONE);
            return;
        }
        if (fld.IsExposedToClient === false) {
            let sb = new StringBuilder();
            sb.Append(NString.Format('Error: Variable \'{0}\' is not exposed to client.', fld.getVarName()));
            alert(sb.ToString());
            resVal.IsNull = true;
            return;
        }
        let fldValue = fld.getValue(true);
        resVal.IsNull = fld.isNull();
        super.SetVal(resVal, fld.getType(), fldValue, null);
    }
    exp_get_indx(val1, resVal) {
        let index = this.ExpTask.GetContextTask().getIndexOfFieldByName(val1.StrVal);
        super.ConstructMagicNum(resVal, index, StorageAttribute.NUMERIC);
    }
    getField(itm) {
        let fld = (itm !== ExpressionEvaluator.TRIGGER_TASK) ? (this.ExpTask.ctl_itm_2_parent_vee(itm - 1)) : AccessHelper.eventsManager.getCurrField();
        return fld;
    }
    GetFieldOfContextTask(itm) {
        return (itm !== ExpressionEvaluator.TRIGGER_TASK) ? (this.ExpTask.GetContextTask().ctl_itm_2_parent_vee(itm - 1)) : AccessHelper.eventsManager.getCurrField();
    }
    static trimStr(s, type) {
        let l = 0;
        if (NString.IsNullOrEmpty(s))
            return s;
        let r = s.length - 1;
        if (type !== 'R') {
            while (l < s.length && s.charAt(l) === ' ')
                l++;
        }
        if (type !== 'L') {
            while (r >= l && s.charAt(r) === ' ')
                r--;
        }
        r++;
        return r > l ? s.substr(l, (r) - (l)) : '';
    }
    static mgValsEqual(aVal, aIsNull, aDataType, bVal, bIsNull, bDataType) {
        let a = null;
        let b = null;
        let result = false;
        if (aIsNull === bIsNull && (aIsNull || (aVal !== null && bVal !== null))) {
            try {
                a = new ExpVal(aDataType, aIsNull, aVal);
                b = new ExpVal(bDataType, bIsNull, bVal);
                result = (ExpressionEvaluator.val_cmp_any(a, b) === 0);
            }
            catch (nullValueException) {
                if (nullValueException instanceof NullValueException) {
                    if (a.IsNull && b.IsNull)
                        result = true;
                }
                else
                    throw nullValueException;
            }
        }
        return result;
    }
    eval_op_translate(str, resVal) {
        resVal.Attr = StorageAttribute.ALPHA;
        resVal.StrVal = '';
        let name = str.StrVal;
        if (NString.IsNullOrEmpty(name))
            super.SetNULL(resVal, StorageAttribute.ALPHA);
        else
            resVal.StrVal = EnvParamsTable.Instance.translate(name);
    }
    eval_op_astr(source, format, resVal) {
        resVal.Attr = StorageAttribute.UNICODE;
        if (source.StrVal === null || format.StrVal === null) {
            super.SetNULL(resVal, StorageAttribute.UNICODE);
            return;
        }
        if (format.StrVal.length > 0 && source.StrVal.length > 0) {
            let pic = new PIC(ExpressionEvaluator.set_a_pic(format.StrVal), StorageAttribute.UNICODE, this.ExpTask.getCompIdx());
            resVal.StrVal = DisplayConvertor.Instance.mg2disp(source.ToMgVal(), null, pic, false, false, this.ExpTask.getCompIdx(), true, false);
        }
    }
    static eval_op_vecCellAttr(vec, res) {
        res.Attr = StorageAttribute.ALPHA;
        res.IsNull = false;
        let attr = StorageAttribute.NONE;
        if (vec.IsNull && vec.VectorField !== null) {
            attr = vec.VectorField.getCellsType();
        }
        else if (ExpressionEvaluator.IsValidVector(vec)) {
            attr = VectorType.getCellsAttr(vec.StrVal);
        }
        res.StrVal = '' + ExpressionEvaluator.GetAttributeChar(attr);
    }
    eval_op_vecGet(vec, cell, res) {
        if (cell.MgNumVal === null || !ExpressionEvaluator.IsValidVector(vec) || cell.MgNumVal.NUM_2_LONG() <= 0) {
            res.IsNull = true;
        }
        else {
            let cellAttr;
            let cellVal;
            if (vec.VectorField !== null) {
                cellAttr = vec.VectorField.getCellsType();
                cellVal = vec.VectorField.getVecCellValue(cell.MgNumVal.NUM_2_LONG());
            }
            else {
                let vector = new VectorType(vec.StrVal);
                cellVal = vector.getVecCell(cell.MgNumVal.NUM_2_LONG());
                cellAttr = vector.getCellsAttr();
            }
            if (cellVal == null)
                res.IsNull = true;
            else {
                switch (cellAttr) {
                    case StorageAttribute.ALPHA:
                    case StorageAttribute.MEMO:
                        res.Attr = StorageAttribute.ALPHA;
                        res.StrVal = cellVal;
                        break;
                    case StorageAttribute.UNICODE:
                        res.Attr = cellAttr;
                        res.StrVal = cellVal;
                        break;
                    case StorageAttribute.BLOB:
                        res.Attr = cellAttr;
                        res.StrVal = cellVal;
                        res.IncludeBlobPrefix = true;
                        break;
                    case StorageAttribute.BLOB_VECTOR:
                        res.Attr = cellAttr;
                        res.StrVal = cellVal;
                        res.IncludeBlobPrefix = true;
                        break;
                    case StorageAttribute.NUMERIC:
                        res.Attr = cellAttr;
                        res.MgNumVal = new NUM_TYPE(cellVal);
                        break;
                    case StorageAttribute.DATE:
                        res.Attr = cellAttr;
                        res.MgNumVal = new NUM_TYPE(cellVal);
                        break;
                    case StorageAttribute.TIME:
                        res.Attr = cellAttr;
                        res.MgNumVal = new NUM_TYPE(cellVal);
                        break;
                    case StorageAttribute.BOOLEAN:
                        res.Attr = cellAttr;
                        res.BoolVal = DisplayConvertor.toBoolean(cellVal);
                        break;
                    default:
                        throw new ApplicationException('in ExpressionEvaluator.eval_op_vecGet unknowen storage type: ' +
                            cellAttr);
                }
            }
        }
    }
    eval_op_vecSize(vec, res) {
        res.Attr = StorageAttribute.NUMERIC;
        res.IsNull = false;
        res.MgNumVal = new NUM_TYPE();
        res.MgNumVal.NUM_4_LONG(-1);
        if (ExpressionEvaluator.IsValidVector(vec))
            res.MgNumVal.NUM_4_LONG(new VectorType(vec.StrVal).getVecSize());
    }
    async eval_op_vecSet(vec, cell, newVal, res) {
        res.Attr = StorageAttribute.BOOLEAN;
        res.BoolVal = false;
        if (vec.MgNumVal !== null && cell.MgNumVal !== null) {
            let vecField;
            try {
                vecField = this.getField(vec.MgNumVal.NUM_2_LONG());
            }
            catch (ex) {
                if (ex instanceof Exception) {
                    Logger.Instance.WriteExceptionToLog(ex);
                    vecField = null;
                }
                else
                    throw ex;
            }
            if ((StorageAttributeCheck.IsTypeAlphaOrUnicode(vecField.getCellsType()) && StorageAttributeCheck.IsTypeAlphaOrUnicode(newVal.Attr)) || (vecField !== null && (vecField.IsVirtual || vecField.getTask().getMode() === Constants.TASK_MODE_CREATE || vecField.DbModifiable) && vecField.getType() === StorageAttribute.BLOB_VECTOR && (StorageAttributeCheck.isTheSameType(vecField.getCellsType(), newVal.Attr) || newVal.IsNull || (StorageAttributeCheck.IsTypeAlphaOrUnicode(newVal.Attr) && vecField.getCellsType() === StorageAttribute.BLOB)))) {
                if (StorageAttributeCheck.IsTypeAlphaOrUnicode(newVal.Attr) && vecField.getCellsType() === StorageAttribute.BLOB) {
                    this.ConvertExpVal(newVal, StorageAttribute.BLOB);
                }
                res.BoolVal = await vecField.setCellVecValue(cell.MgNumVal.NUM_2_LONG(), newVal.ToMgVal(), newVal.IsNull);
            }
        }
    }
    eval_op_strTokenCnt(sourceString, delimiter, resVal) {
        resVal.Attr = StorageAttribute.NUMERIC;
        resVal.MgNumVal = new NUM_TYPE();
        let res = 0;
        if (!sourceString.IsNull && sourceString.StrVal !== null && NString.TrimEnd(sourceString.StrVal, this._charsToTrim).length !== 0) {
            if (delimiter.IsNull || NString.TrimEnd(delimiter.StrVal, this._charsToTrim).length === 0)
                res = 1;
            else {
                let tokensSize = this.strTokenCount(sourceString.StrVal, delimiter.StrVal);
                if (tokensSize === 0)
                    res = 1;
                else
                    res = tokensSize;
            }
        }
        resVal.MgNumVal.NUM_4_LONG(res);
    }
    eval_op_strTokenIdx(sourceString, token, delimiter, resVal) {
        resVal.Attr = StorageAttribute.NUMERIC;
        resVal.MgNumVal = new NUM_TYPE();
        let res = 0;
        if (!sourceString.IsNull && sourceString.StrVal !== null && !token.IsNull && token.StrVal !== null && NString.TrimEnd(sourceString.StrVal, this._charsToTrim).length !== 0 && token.StrVal.trim().length > 0) {
            if (!delimiter.IsNull && NString.TrimEnd(delimiter.StrVal, this._charsToTrim).length !== 0)
                res = this.strTokenIndex(sourceString.StrVal, delimiter.StrVal, token.StrVal);
            else if (sourceString.StrVal === token.StrVal)
                res = 1;
            else
                res = 0;
        }
        resVal.MgNumVal.NUM_4_LONG(res);
    }
    strTokenIndex(source, delimiter, token) {
        let trimDelim = NString.TrimEnd(delimiter, this._charsToTrim);
        let trimSource = trimDelim + NString.TrimEnd(source, this._charsToTrim) + trimDelim;
        let trimToken = (token !== null) ? NString.TrimEnd(token, this._charsToTrim) : null;
        if (trimToken === null)
            return 0;
        trimToken = trimDelim + trimToken + trimDelim;
        let tokenOffset = trimSource.indexOf(trimToken);
        if (tokenOffset === -1)
            return 0;
        else {
            let tokenIndex = this.strTokenCount(trimSource.substr(0, tokenOffset + trimDelim.length), trimDelim);
            tokenIndex--;
            return tokenIndex;
        }
    }
    strTokenCount(source, delimiter) {
        let counter = 1;
        let trimDelim = NString.TrimEnd(delimiter, this._charsToTrim);
        let trimSource = NString.TrimEnd(source, this._charsToTrim);
        let delimLength = trimDelim.length;
        let data = trimSource;
        let fromOffset = 0;
        let delimiterOffset = 0;
        if (source === null || source.length === 0)
            return 0;
        delimiterOffset = data.indexOf(trimDelim, fromOffset);
        while (delimiterOffset >= 0) {
            counter++;
            fromOffset = delimiterOffset + delimLength;
            delimiterOffset = data.indexOf(trimDelim, fromOffset);
        }
        return counter;
    }
    eval_op_blobsize(resVal, blobVal) {
        let size = 0;
        switch (blobVal.Attr) {
            case StorageAttribute.BLOB_VECTOR:
                size = VectorType.getVecSize(blobVal.StrVal);
                break;
            case StorageAttribute.BLOB:
                size = BlobType.getBlobSize(blobVal.StrVal);
                break;
            default:
                break;
        }
        resVal.Attr = StorageAttribute.NUMERIC;
        resVal.MgNumVal = new NUM_TYPE();
        resVal.MgNumVal.NUM_4_LONG(size);
    }
    eval_op_iscomponent(resVal) {
        let currTsk = AccessHelper.eventsManager.getCurrTask() || this.ExpTask;
        resVal.Attr = StorageAttribute.BOOLEAN;
        resVal.BoolVal = (currTsk.getCompIdx() !== 0);
    }
    async eval_op_ExecUserDefinedFunc(funcName, Exp_params, resVal, expectedType) {
        let rtEvt = new RunTimeEvent(this.ExpTask);
        rtEvt.setType(ConstInterface.EVENT_TYPE_USER_FUNC);
        rtEvt.setUserDefinedFuncName(funcName);
        let evtHanPos = new EventHandlerPosition();
        evtHanPos.init(rtEvt);
        let handler = evtHanPos.getNext();
        let argsMatch = handler !== null && handler.argsMatch(Exp_params);
        let val = null;
        let valIniated = false;
        if (argsMatch) {
            let handlerContextTask = handler.getTask().GetContextTask();
            if (handler.getTask() === handler.getTask().GetContextTask())
                handler.getTask().SetContextTask(rtEvt.getTask());
            let argList = new ArgumentsList(Exp_params);
            rtEvt.setArgList(argList);
            AccessHelper.eventsManager.pushNewExecStacks();
            await handler.execute(rtEvt, false, false);
            AccessHelper.eventsManager.popNewExecStacks();
            let exp = handler.getTask().getExpById(handler.getEvent().getUserDefinedFuncRetExp());
            if (exp !== null) {
                val = await exp.evaluateWithResType(expectedType);
                valIniated = true;
            }
            handler.getTask().SetContextTask(handlerContextTask);
        }
        if (!valIniated) {
            if (expectedType === StorageAttribute.NONE) {
                expectedType = StorageAttribute.ALPHA;
            }
            val = new ExpVal(expectedType, true, null);
        }
        resVal.Copy(val);
    }
    eval_op_publicName(resVal, Parent) {
        let publicName = 'NULL';
        let iParent = Parent.MgNumVal.NUM_2_LONG();
        if ((iParent >= 0 && iParent < (this.ExpTask.getTaskDepth(false))) || iParent === ExpressionEvaluator.TRIGGER_TASK) {
            let task = super.GetContextTask(iParent);
            if (task !== null && task.isProgram() && !task.isMainProg())
                publicName = task.getPublicName();
        }
        resVal.Attr = StorageAttribute.ALPHA;
        resVal.StrVal = publicName;
    }
    eval_op_taskId(resVal, Parent) {
        let taskId = 'NULL';
        let iParent = Parent.MgNumVal.NUM_2_LONG();
        if ((iParent >= 0 && iParent < (this.ExpTask.getTaskDepth(false))) || iParent === ExpressionEvaluator.TRIGGER_TASK) {
            let task = super.GetContextTask(iParent);
            if (task !== null)
                taskId = task.getExternalTaskId();
        }
        resVal.Attr = StorageAttribute.ALPHA;
        resVal.StrVal = taskId;
    }
    eval_op_dbviewsize(resVal, Parent) {
        let size = 0;
        let iParent = Parent.MgNumVal.NUM_2_LONG();
        if ((iParent >= 0 && iParent < this.ExpTask.getTaskDepth(false)) || iParent === ExpressionEvaluator.TRIGGER_TASK) {
            let task = super.GetContextTask(iParent);
            if (task !== null && task.DataView.HasMainTable) {
                if (task.GetComputedProperty(PropInterface.PROP_TYPE_PRELOAD_VIEW).GetComputedValueBoolean()) {
                    size = task.DataView.DBViewSize;
                }
                else if (task.isTableWithAbsolutesScrollbar())
                    size = task.DataView.TotalRecordsCount;
            }
        }
        super.ConstructMagicNum(resVal, size, StorageAttribute.NUMERIC);
    }
    eval_op_dbviewrowidx(resVal, Parent) {
        let idx = 0;
        let iParent = Parent.MgNumVal.NUM_2_LONG();
        if ((iParent >= 0 && iParent < this.ExpTask.getTaskDepth(false)) || iParent === ExpressionEvaluator.TRIGGER_TASK) {
            let task = super.GetContextTask(iParent);
            if (task !== null && task.GetComputedProperty(PropInterface.PROP_TYPE_PRELOAD_VIEW).GetComputedValueBoolean()) {
                if ((task.DataView.getCurrRec()).getMode() !== DataModificationTypes.Insert) {
                    idx = task.DataviewManager.CurrentDataviewManager.GetDbViewRowIdx();
                }
            }
        }
        super.ConstructMagicNum(resVal, idx, StorageAttribute.NUMERIC);
    }
    eval_op_MlsTrans(resVal, fromString) {
        resVal.Attr = StorageAttribute.UNICODE;
        resVal.StrVal = '';
        resVal.StrVal = LanguageData.Instance.translate(NString.TrimEnd(fromString.StrVal, this._charsToTrim));
    }
    eval_op_StrBuild(valStack, resVal, nArgs) {
        let Exp_parms = new Array(nArgs);
        for (let i = 0; i < nArgs; i++)
            Exp_parms[nArgs - 1 - i] = valStack.pop();
        this.val_cpy(Exp_parms[0], resVal);
        let resultStr = new StringBuilder(resVal.StrVal);
        for (let i = 1; i < nArgs; i++) {
            let toReplace = '@' + i.toString().trim() + '@';
            let indexFrom = 0;
            while (indexFrom !== -1) {
                let nextIndex = resultStr.ToString().indexOf(toReplace, indexFrom);
                if (nextIndex === -1)
                    break;
                let precededBySlash = false;
                let shashIndex = resultStr.ToString().indexOf('\\' + toReplace, indexFrom);
                if (shashIndex !== -1)
                    precededBySlash = true;
                if ((precededBySlash && nextIndex !== shashIndex + 1) || !precededBySlash) {
                    resultStr.Replace(resultStr.ToString(nextIndex, nextIndex + toReplace.length - nextIndex), Exp_parms[i].StrVal.trim(), nextIndex, nextIndex + toReplace.length - nextIndex);
                    indexFrom = nextIndex + Exp_parms[i].StrVal.trim().length;
                }
                else
                    indexFrom = nextIndex + 1;
            }
        }
        resultStr.Replace('\\@', '@');
        resVal.StrVal = resultStr.ToString();
    }
    eval_op_tsk_instance(resVal, Parent) {
        let tag = 0;
        let iParent = Parent.MgNumVal.NUM_2_LONG();
        if ((iParent >= 0 && iParent < (this.ExpTask.getTaskDepth(false))) || iParent === ExpressionEvaluator.TRIGGER_TASK) {
            let task = super.GetContextTask(iParent);
            if (task !== null) {
                tag = NNumber.Parse(task.getTaskTag());
            }
        }
        resVal.Attr = StorageAttribute.NUMERIC;
        resVal.MgNumVal = new NUM_TYPE();
        resVal.MgNumVal.NUM_4_LONG(tag);
    }
    eval_op_getParam(resVal, name) {
        Debug.Assert(!name.IsNull && name.StrVal !== null);
        let expVal = GlobalParams.Instance.get(name.StrVal);
        if (expVal !== null)
            resVal.Copy(expVal);
        else
            resVal.Nullify();
    }
    eval_op_setParam(resVal, name, value) {
        Debug.Assert(!name.IsNull && name.StrVal !== null);
        resVal.Attr = StorageAttribute.BOOLEAN;
        let globalParams = GlobalParams.Instance;
        globalParams.set(name.StrVal, value);
        resVal.BoolVal = true;
    }
    async eval_op_iniput(resVal, value, updateIni) {
        resVal.Attr = StorageAttribute.BOOLEAN;
        resVal.BoolVal = await EnvParamsTable.Instance.set(value.StrVal, updateIni.BoolVal);
    }
    eval_op_iniget(resVal, nameVal) {
        resVal.StrVal = EnvParamsTable.Instance.get(nameVal.StrVal);
        resVal.Attr = StorageAttribute.ALPHA;
    }
    eval_op_inigetln(resVal, sectionVal, numberVal) {
        resVal.StrVal = EnvParamsTable.Instance.getln(sectionVal.StrVal, numberVal.MgNumVal.NUM_2_LONG());
        resVal.Attr = StorageAttribute.ALPHA;
    }
    eval_op_m(resVal, codes) {
        resVal.Attr = StorageAttribute.ALPHA;
        resVal.StrVal = '';
        for (let i = 0; i < codes.length; i++) {
            let mode = this.cst_code_trans_buf('O', 'MCDELRKSON ', codes.charAt(i), MsgInterface.EXPTAB_TSK_MODE_RT);
            resVal.StrVal = resVal.StrVal + mode;
        }
    }
    cst_code_trans_buf(opr, intStr, code, strId) {
        let i;
        let constStr = LanguageData.Instance.getConstMessage(strId);
        let tokens = new Array_Enumerator(StrUtil.tokenize(constStr, ','));
        let token;
        let resVal = '\0';
        for (i = 0; i < intStr.length && tokens.MoveNext(); i++) {
            token = tokens.Current;
            let ofs = token.indexOf('&');
            ofs++;
            let currCode = token.charAt(ofs).toUpperCase();
            if (opr === 'I') {
                if (code === currCode) {
                    resVal = intStr.charAt(i);
                    break;
                }
            }
            else {
                if (code === intStr.charAt(i)) {
                    resVal = currCode;
                    break;
                }
            }
        }
        return resVal;
    }
    async eval_op_expcalc(resVal, expVal) {
        resVal.IsNull = true;
        if (ExpressionEvaluator._recursiveExpCalcCount < 50) {
            ExpressionEvaluator._recursiveExpCalcCount++;
            let expVal2 = await this.ExpTask.getExpById(expVal.MgNumVal.NUM_2_LONG()).evaluateWithResType(StorageAttribute.NONE);
            ExpressionEvaluator._recursiveExpCalcCount--;
            if (expVal2 !== null)
                resVal.Copy(expVal2);
        }
    }
    eval_op_CndRange(resVal, val1, val2) {
        if (val1.BoolVal)
            resVal.Copy(val2);
        else
            resVal.IsNull = true;
    }
    eval_op_taskType(resVal, Parent) {
        let iParent = Parent.MgNumVal.NUM_2_LONG();
        if ((iParent >= 0 && iParent < (this.ExpTask.getTaskDepth(false))) || iParent === ExpressionEvaluator.TRIGGER_TASK) {
            let task = super.GetContextTask(iParent);
            if (task !== null) {
                resVal.StrVal = (task.isMainProg() ? 'MW' : 'W');
            }
            else
                resVal.StrVal = ' ';
        }
        resVal.Attr = StorageAttribute.ALPHA;
    }
    eval_op_terminal(resVal) {
        let terminal = Environment.Instance.getTerminal();
        super.ConstructMagicNum(resVal, terminal, StorageAttribute.NUMERIC);
    }
    eval_op_projectdir(resVal) {
        resVal.StrVal = Environment.Instance.getProjDir(this.ExpTask.getCompIdx());
        resVal.Attr = StorageAttribute.ALPHA;
    }
    static IsValidVector(vec) {
        return vec !== null && vec.Attr === StorageAttribute.BLOB_VECTOR && VectorType.validateBlobContents(vec.StrVal);
    }
    static GetAttributeChar(storageAttr) {
        let attr = storageAttr;
        switch (storageAttr) {
            case StorageAttribute.BLOB:
                attr = 'B';
                break;
            case StorageAttribute.BOOLEAN:
                attr = 'L';
                break;
            default:
                break;
        }
        return attr;
    }
    HandleControlGoto(ctrlTask, ctrl, rowNo) {
        let task = ctrlTask;
        if (ctrl !== null) {
            let dv = task.DataView;
            let tCtrl = ctrl;
            let wantedLine = task.getForm().DisplayLine;
            if (ctrl.IsRepeatable && rowNo > 0) {
                task.getForm().getTopIndexFromGUI();
                let topRecIdx = dv.getTopRecIdx();
                wantedLine = topRecIdx + rowNo - 1;
                if (wantedLine - topRecIdx - 1 >= task.getForm().getRowsInPage())
                    return false;
                if (!task.getForm().IsValidRow(wantedLine))
                    return false;
            }
            if (tCtrl.isVisible()) {
                if (tCtrl.isSubform()) {
                    return false;
                }
                let frm = task.getForm();
                let isRowEditing = frm.getIsRowEditingFromGui(wantedLine);
                if (tCtrl.isRepeatable() && !isRowEditing) {
                    AccessHelper.eventsManager.addGuiTriggeredEventWithTaskAndCodeAndLine(task, InternalInterface.MG_ACT_REC_PREFIX, wantedLine);
                    console.log('Unable to park on control: ' + tCtrl.Name + ' as row is not in editing mode');
                    return true;
                }
                else {
                    let rtEvt = new RunTimeEvent(tCtrl, wantedLine);
                    rtEvt.setInternal(InternalInterface.MG_ACT_CTRL_FOCUS);
                    AccessHelper.eventsManager.addToTail(rtEvt);
                    return true;
                }
            }
        }
        return false;
    }
    eval_op_set_title(resVal, title) {
        resVal.Attr = StorageAttribute.BOOLEAN;
        resVal.BoolVal = true;
        if (!(title.Attr !== StorageAttribute.ALPHA && title.Attr !== StorageAttribute.UNICODE)) {
            if (!title.IsNull) {
                let text = title.StrVal;
                let task = this.ExpTask.GetContextTask();
                if (task.getTopMostForm() !== null) {
                    task.getTopMostForm().setTitle(text);
                }
            }
        }
    }
    eval_op_is_row_editing(resVal, val1) {
        let isRowEditing = false;
        if (val1.MgNumVal === null) {
            super.SetNULL(resVal, StorageAttribute.ALPHA);
            return;
        }
        let parent = val1.MgNumVal.NUM_2_LONG();
        if ((parent >= 0 && parent < (this.ExpTask.getTaskDepth(false))) || parent === ExpressionEvaluator.TRIGGER_TASK) {
            let tsk = super.GetContextTask(parent);
            let myform = tsk.getForm();
            isRowEditing = myform.getIsRowEditingFromGui(myform.DisplayLine);
        }
        resVal.BoolVal = isRowEditing;
        resVal.Attr = StorageAttribute.BOOLEAN;
    }
    async eval_op_control_select_program(expVal, resVal) {
        let controlID = expVal.MgNumVal.NUM_2_LONG();
        let parent = 0;
        let refParent = new RefParam(parent);
        let mgControl = this.ExpTask.GetContextTask().GetControlFromControlID(controlID - 1, refParent);
        parent = refParent.value;
        resVal.Attr = StorageAttribute.NUMERIC;
        resVal.MgNumVal = new NUM_TYPE();
        if (mgControl !== null && mgControl.HasSelectProgram()) {
            let selectProgProp = mgControl.getProp(PropInterface.PROP_TYPE_SELECT_PROGRAM);
            let realIndex = NNumber.Parse(await selectProgProp.getValue());
            let programIndex = 0;
            if (realIndex > 0) {
                if (parent > 0)
                    programIndex = realIndex + parent / 100;
                else
                    programIndex = realIndex;
            }
            resVal.MgNumVal = NUM_TYPE.from_double(programIndex);
        }
    }
    async eval_op_CallJS(task, methodName, expVal, resVal) {
        resVal.Attr = StorageAttribute.ALPHA;
        resVal.StrVal = '';
        if (task.isMainProg()) {
            console.error("CallJS cannot be used in Main Program");
            return;
        }
        let form = task.getForm();
        let args = this.params2arguments(expVal, 0, expVal.length);
        if (!isNullOrUndefined(args)) {
            if (task.isFirstRecordCycle()) {
                Commands.invoke();
                await Thread.Sleep(10);
            }
            resVal.StrVal = Commands.addCallJS(form, form.UniqueName, methodName, args);
            resVal.Attr = StorageAttribute.ALPHA;
        }
    }
    eval_op_set_cookie(cookieName, expVal, resVal) {
        resVal.Attr = StorageAttribute.BOOLEAN;
        resVal.StrVal = '';
        let args = this.params2arguments(expVal, 0, expVal.length);
        var expiresDate, path, domain, secure, sameSite;
        expiresDate = args[1];
        let expiresTime = args[2];
        let nativeDt;
        if (expiresDate) {
            let breakParams = DisplayConvertor.Instance.getNewDateBreakParams();
            DisplayConvertor.Instance.date_break_datemode(breakParams, expiresDate, false, this.ExpTask.getCompIdx());
            if (breakParams.year == 0 && breakParams.month == 0 && breakParams.day == 0)
                return null;
            nativeDt = new Date(breakParams.year, breakParams.month - 1, breakParams.day);
            if (expiresTime) {
                let timeBreakParams = DisplayConvertor.Instance.getNewTimeBreakParams();
                DisplayConvertor.time_break(timeBreakParams, expiresTime);
                nativeDt.setHours(timeBreakParams.hour);
                nativeDt.setMinutes(timeBreakParams.minute);
                nativeDt.setSeconds(timeBreakParams.second);
            }
        }
        path = args[3];
        domain = args[4];
        resVal.BoolVal = CookieService.setCookie(cookieName, (args[0] != null ? args[0].toString() : ""), nativeDt, path, domain, secure, sameSite);
    }
    eval_op_get_cookie(cookieName, resVal) {
        resVal.StrVal = CookieService.getCookie(cookieName);
    }
    eval_op_delete_cookie(cookieName, resVal) {
        resVal.Attr = StorageAttribute.BOOLEAN;
        resVal.BoolVal = CookieService.deleteCookie(cookieName);
        ;
    }
    eval_op_route_get(resVal) {
        resVal.Attr = StorageAttribute.UNICODE;
        resVal.IsNull = false;
        resVal.StrVal = Commands.getLastRoute();
    }
    params2arguments(Exp_params, startAt, count) {
        let NULL_STR = '';
        let attr = new Array();
        for (let i = startAt; i < startAt + count; i++) {
            if (isNullOrUndefined(Exp_params[i])) {
                attr.push(NULL_STR);
            }
            else {
                switch (Exp_params[i].Attr) {
                    case StorageAttribute.ALPHA:
                    case StorageAttribute.UNICODE:
                        if (Exp_params[i].StrVal != null && Exp_params[i].StrVal.length > 0)
                            attr.push(Exp_params[i].StrVal);
                        else
                            attr.push(NULL_STR);
                        break;
                    case StorageAttribute.BOOLEAN:
                        attr.push(Exp_params[i].BoolVal ? true : false);
                        break;
                    case StorageAttribute.DATE:
                    case StorageAttribute.TIME:
                        attr.push(Exp_params[i].MgNumVal.NUM_2_LONG());
                        break;
                    case StorageAttribute.NUMERIC:
                        attr.push(Exp_params[i].MgNumVal.to_double());
                        break;
                    case StorageAttribute.BLOB:
                        let blob = Exp_params[i].StrVal;
                        if (!isNullOrUndefined(blob)) {
                            {
                                let contentType = BlobType.getContentType(blob);
                                if (contentType !== BlobType.CONTENT_TYPE_BINARY) {
                                    attr.push(BlobType.getString(blob));
                                }
                                else {
                                    Logger.Instance.WriteErrorToLog('Argument ' + (i + 1) + ' of type Binary Blob is not supported in CallJS');
                                    return null;
                                }
                            }
                        }
                        break;
                    case StorageAttribute.NONE:
                    default:
                        Logger.Instance.WriteErrorToLog(' Argument ' + (i + 1) + ' is not supported in CallJS');
                        return null;
                }
            }
        }
        return attr;
    }
}
ExpressionEvaluator.ASTERISK_CHR = String.fromCharCode(1);
ExpressionEvaluator.QUESTION_CHR = String.fromCharCode(2);
ExpressionEvaluator.PARENT_LEN = 2;
ExpressionEvaluator.SHORT_OBJECT_LEN = 2;
ExpressionEvaluator.LONG_OBJECT_LEN = 4;
ExpressionEvaluator._recursiveExpCalcCount = 0;
ExpressionEvaluator.ErrorToBeWrittenInServerLog = null;
class NullValueException extends Exception {
    constructor(attr) {
        super();
        this._attr = StorageAttribute.NONE;
        this._attr = attr;
        this.name = 'NullValueException';
    }
    getAttr() {
        return this._attr;
    }
}
class ExpStrTracker {
    constructor(expBytes, nullArithmetic) {
        this._expBytes = null;
        this._lowHigh = true;
        this._nullArithmetic = false;
        this._isNull = false;
        this._posIdx = 0;
        this._expBytes = new Int8Array(expBytes.length);
        for (let _ai = 0; _ai < this._expBytes.length; ++_ai)
            this._expBytes[_ai] = 0;
        for (let i = 0; i < expBytes.length; i++)
            this._expBytes[i] = expBytes[i];
        this._nullArithmetic = nullArithmetic;
        this._lowHigh = Environment.Instance.getLowHigh();
    }
    setNullResult() {
        if (this._nullArithmetic)
            this._isNull = true;
    }
    resetNullResult() {
        if (this._nullArithmetic) {
            this._isNull = false;
        }
    }
    isNull() {
        return this._isNull;
    }
    get1ByteNumber() {
        let num = (this._expBytes[this._posIdx] >= 0) ? this._expBytes[this._posIdx] : (256 + this._expBytes[this._posIdx]);
        this._posIdx += 1;
        return num;
    }
    get2ByteNumber() {
        let c1 = (this._expBytes[this._posIdx] >= 0) ? this._expBytes[this._posIdx] : (256 + this._expBytes[this._posIdx]);
        this._posIdx += 1;
        let c2 = (this._expBytes[this._posIdx] >= 0) ? this._expBytes[this._posIdx] : (256 + this._expBytes[this._posIdx]);
        this._posIdx += 1;
        let num = (this._lowHigh ? ExpressionEvaluator.MK_SHRT(c2, c1) : ExpressionEvaluator.MK_SHRT(c1, c2));
        return num;
    }
    get4ByteNumber() {
        let c4 = (this._expBytes[this._posIdx] >= 0) ? this._expBytes[this._posIdx] : (256 + this._expBytes[this._posIdx]);
        this._posIdx += 1;
        let c3 = (this._expBytes[this._posIdx] >= 0) ? this._expBytes[this._posIdx] : (256 + this._expBytes[this._posIdx]);
        this._posIdx += 1;
        let c2 = (this._expBytes[this._posIdx] >= 0) ? this._expBytes[this._posIdx] : (256 + this._expBytes[this._posIdx]);
        this._posIdx += 1;
        let c1 = (this._expBytes[this._posIdx] >= 0) ? this._expBytes[this._posIdx] : (256 + this._expBytes[this._posIdx]);
        this._posIdx += 1;
        let num = this._lowHigh ? ExpressionEvaluator.MK_LONG(c1, c2, c3, c4) : ExpressionEvaluator.MK_LONG(c4, c3, c2, c1);
        return num;
    }
    getString(len, updateIdx, isUnicode) {
        let str = '';
        let bytes;
        if (isUnicode === false) {
            bytes = len;
            let tmpChar = new Array(this._expBytes.length);
            for (let i = 0; i < this._expBytes.length; i = i + 1)
                tmpChar[i] = String.fromCharCode(this._expBytes[i]);
            str = NString.FromChars(tmpChar, this._posIdx, len);
        }
        else {
            bytes = len * 2;
            let tmp = new Uint8Array(bytes);
            let increment = (!this._lowHigh) ? ConstInterface.BYTES_IN_CHAR : 1;
            for (let i = this._posIdx; i < this._posIdx + bytes; i = i + increment) {
                if (!this._lowHigh) {
                    tmp[i - this._posIdx] = this._expBytes[i + 1];
                    tmp[i + 1 - this._posIdx] = this._expBytes[i];
                }
                else
                    tmp[i - this._posIdx] = this._expBytes[i];
            }
            try {
                str = Encoding.Unicode.GetString(tmp, 0, tmp.length);
            }
            catch (ex) {
                if (ex instanceof Exception) {
                    Logger.Instance.WriteExceptionToLog(ex);
                }
                else
                    throw ex;
            }
        }
        if (updateIdx) {
            this._posIdx += bytes;
        }
        return str;
    }
    skipOpFunctionPtr() {
        this._posIdx += ExpressionInterface.EXP_OPER_FUNC_PTR_LEN;
    }
    getOpCode() {
        let tmp = [
            this._lowHigh ? this._expBytes[this._posIdx] : this._expBytes[this._posIdx + 1], this._lowHigh ? this._expBytes[this._posIdx + 1] : this._expBytes[this._posIdx]
        ];
        let num = (tmp[1] >= 0) ? tmp[1] : (256 + tmp[1]);
        num <<= 8;
        num = (num | ((tmp[0] >= 0) ? tmp[0] : (256 + tmp[0])));
        this._posIdx += ExpressionInterface.EXP_OPER_LEN;
        this.skipOpFunctionPtr();
        return num;
    }
    getVarIdx() {
        let flip = 0;
        if (this._lowHigh)
            flip = 1 - flip;
        let num = (this._expBytes[this._posIdx + flip] >= 0) ? this._expBytes[this._posIdx + flip] : (256 + this._expBytes[this._posIdx + flip]);
        num <<= 8;
        flip = 1 - flip;
        num |= ((this._expBytes[this._posIdx + flip] >= 0) ? this._expBytes[this._posIdx + flip] : (256 + this._expBytes[this._posIdx + flip]));
        this._posIdx += ExpressionInterface.EXP_OPER_LEN;
        return num;
    }
    getMagicNumber(len, updateIdx) {
        let mgNum = new NUM_TYPE(this._expBytes, this._posIdx, len);
        if (updateIdx)
            this._posIdx += len;
        return mgNum;
    }
    skipOperator() {
        let argsRemain = 1;
        let expDesc;
        let len;
        while (argsRemain > 0) {
            argsRemain--;
            let opCode = this.getOpCode();
            switch (opCode) {
                case ExpressionInterface.EXP_OP_A:
                case ExpressionInterface.EXP_OP_H:
                    len = this.get4ByteNumber();
                    this._posIdx += (len * ConstInterface.BYTES_IN_CHAR);
                    len = this.get4ByteNumber();
                    this._posIdx += len;
                    break;
                case ExpressionInterface.EXP_OP_EXT_A:
                    len = this.get2ByteNumber();
                    this._posIdx += len;
                    break;
                case ExpressionInterface.EXP_OP_N:
                case ExpressionInterface.EXP_OP_T:
                case ExpressionInterface.EXP_OP_D:
                case ExpressionInterface.EXP_OP_M:
                case ExpressionInterface.EXP_OP_K:
                case ExpressionInterface.EXP_OP_E:
                    len = this.get2ByteNumber();
                    this._posIdx += len;
                    break;
                case ExpressionInterface.EXP_OP_F:
                case ExpressionInterface.EXP_OP_P:
                    len = this.get2ByteNumber();
                    this._posIdx += len;
                    len = this.get2ByteNumber();
                    this._posIdx += len;
                    break;
                case ExpressionInterface.EXP_OP_L:
                    this._posIdx += 2;
                    break;
                case ExpressionInterface.EXP_OP_V:
                    this._posIdx += (ExpressionEvaluator.PARENT_LEN + ExpressionEvaluator.LONG_OBJECT_LEN);
                    break;
                case ExpressionInterface.EXP_OP_FORM:
                    this._posIdx += (ExpressionEvaluator.PARENT_LEN + ExpressionEvaluator.LONG_OBJECT_LEN);
                    break;
                case ExpressionInterface.EXP_OP_VAR:
                    this._posIdx += (ExpressionEvaluator.PARENT_LEN + ExpressionEvaluator.LONG_OBJECT_LEN);
                    break;
                case ExpressionInterface.EXP_OP_RIGHT_LITERAL:
                    len = this.get2ByteNumber();
                    this._posIdx += len;
                    len = this.get2ByteNumber();
                    this._posIdx += len;
                    break;
                default:
                    expDesc = ExpressionDict.expDesc[opCode];
                    if (expDesc.ArgCount_ < 0)
                        argsRemain += this.get1ByteNumber();
                    else
                        argsRemain += expDesc.ArgCount_;
                    break;
            }
        }
    }
}
class DynamicOperation {
    constructor() {
        this.argCount_ = 0;
        this.opCode_ = ExpressionInterface.EXP_OP_NONE;
    }
}

class DataViewBase extends GuiDataViewBase {
}

class Record {
    get InCompute() {
        return this._inCompute;
    }
    get InRecompute() {
        return this._inRecompute;
    }
    constructor(dvOrTableCacheOrCIdOrRecord, dataview) {
        this._id = Int32.MinValue;
        this.dbViewRowIdx = 0;
        this._mode = DataModificationTypes.None;
        this._dcRefs = null;
        this._inCompute = false;
        this._inRecompute = false;
        this._newRec = false;
        this._dataview = null;
        this._sendToServer = true;
        if (dvOrTableCacheOrCIdOrRecord instanceof Record)
            Object.assign(this, dvOrTableCacheOrCIdOrRecord);
        else if (arguments.length === 1)
            this.constructor_0(dvOrTableCacheOrCIdOrRecord);
        else
            this.constructor_1(dvOrTableCacheOrCIdOrRecord, dataview);
    }
    constructor_0(dvOrTableCache) {
        if (dvOrTableCache instanceof DataViewBase)
            this._dataview = dvOrTableCache;
        else
            this._tableCache = dvOrTableCache;
        this._fieldsData = new Array(this.getFieldsTab().getSize());
        this._flags = new Uint8Array(this.getFieldsTab().getSize());
        this._flagsHistory = new Uint8Array(this.getFieldsTab().getSize());
        this._dcRefs = new ObjectReferencesCollection();
    }
    Initialize() {
        for (let i = 0; i < this._flags.length; i = i + 1) {
            let field = this.getFieldsTab().getField(i);
            this._flags[i] = ((field.isNullDefault() || field.getType() === StorageAttribute.BLOB_VECTOR) ? Record.FLAG_NULL : 0);
            if (this._dataview !== null && field.IsVirtual) {
                let record = this._dataview.getCurrRec();
                if (record != null && record.IsFldModifiedAtLeastOnce(i)) {
                    this.setFlag(i, Record.FLAG_MODIFIED_ATLEAST_ONCE);
                }
            }
            this._flagsHistory[i] = this._flags[i];
        }
        this.setNewRec();
    }
    constructor_1(cId, dataview) {
        this.constructor_0(dataview);
        this.setId(cId);
    }
    get Modified() {
        return this._modified;
    }
    get Updated() {
        return this._updated;
    }
    get SendToServer() {
        return this._sendToServer;
    }
    CompareTo(obj) {
        let res = 0;
        let compTo = obj;
        let key = this._tableCache.GetKeyById(this._tableCache.GetCurrSortKey());
        if (key != null) {
            for (let i = 0; i < key.Columns.length; i++) {
                let currFld = key.Columns.get_Item(i);
                let currFldId = currFld.getId();
                if (this.IsNull(currFldId) && compTo.IsNull(currFldId))
                    continue;
                else if (this.IsNull(currFldId) && !compTo.IsNull(currFldId)) {
                    res = 1;
                    break;
                }
                else if (!this.IsNull(currFldId) && compTo.IsNull(currFldId)) {
                    res = -1;
                    break;
                }
                else {
                    try {
                        let first = new ExpVal(currFld.getType(), false, this.GetFieldValue(currFldId));
                        let second = new ExpVal(currFld.getType(), false, compTo.GetFieldValue(currFldId));
                        res = ExpressionEvaluator.val_cmp_any(first, second);
                        if (res !== 0)
                            break;
                    }
                    catch (err) {
                        if (err instanceof NullValueException)
                            Logger.Instance.WriteExceptionToLogWithMsg(" in Record.CompareTo null value was reached");
                    }
                }
            }
            return res;
        }
        else {
            res = -1;
            return res;
        }
    }
    getMode() {
        return this._mode;
    }
    getId() {
        return this._id;
    }
    isNewRec() {
        return this._newRec;
    }
    getFieldDataXML(fldIdx, getOldVal) {
        let fldVal;
        if (!getOldVal)
            fldVal = this.GetFieldValue(fldIdx);
        else
            fldVal = (this.getFieldsTab().getField(fldIdx)).getOriginalValue();
        if (fldVal == null)
            throw new ApplicationException("in Record.buildFieldsData() null field value!\nField id: " + fldIdx);
        let tmpBuf = this.getXMLForValue(fldIdx, fldVal);
        return XmlParser.escape(tmpBuf.toString()).toString();
    }
    getFieldsTab() {
        if (this._dataview !== null)
            return this._dataview.GetFieldsTab();
        else
            return this._tableCache.FldsTab;
    }
    setInitialFldVals(clobberedOnly, isNewRec) {
        let i, size;
        let fld = null;
        size = this.getSizeFld(true);
        for (i = 0; i < size; i++) {
            if (this._fieldsData[i] === null || typeof this._fieldsData[i] === "undefined") {
                fld = this.getFieldsTab().getField(i);
                this._fieldsData[i] = fld.getNewRecValue(clobberedOnly);
                if (isNewRec && fld.IsVirtual && !fld.isNull())
                    this.clearFlag(fld.getId(), Record.FLAG_NULL);
                if (fld.IsVirtual && fld.getModifiedAtLeastOnce())
                    this.setFlag(fld.getId(), Record.FLAG_MODIFIED_ATLEAST_ONCE);
                if (this._fieldsData[i] === null || typeof this._fieldsData[i] === "undefined")
                    this._fieldsData[i] = fld.getDefaultValue();
            }
        }
    }
    setId(cId) {
        this._id = cId;
        this._hashKey = this._id;
    }
    setDBViewRowIdx(rowId) {
        this.dbViewRowIdx = rowId;
    }
    getDBViewRowIdx() {
        return this.dbViewRowIdx;
    }
    fillData(parser) {
        let isCurrRec = false;
        let endContext = parser.getXMLdata().indexOf(XMLConstants.TAG_TERM, parser.getCurrIndex());
        if (endContext !== -1 && endContext < parser.getXMLdata().length) {
            let tag = parser.getXMLsubstring(endContext);
            parser.add2CurrIndex(tag.indexOf(ConstInterface.MG_TAG_REC) + ConstInterface.MG_TAG_REC.length);
            let tokensVector = XmlParser.getTokens(parser.getXMLsubstring(endContext), XMLConstants.XML_ATTR_DELIM);
            isCurrRec = this.initElements(tokensVector);
            parser.setCurrIndex(endContext + XMLConstants.TAG_TERM.length);
        }
        else
            Logger.Instance.WriteExceptionToLogWithMsg("in Record.FillInnerData() out of bounds");
        return isCurrRec;
    }
    initElements(tokensVector) {
        let attribute, valueStr;
        let recFieldsData = null;
        let recFlags = null;
        let j = 0;
        let isCurrRec;
        isCurrRec = this.peekIsCurrRec(tokensVector);
        for (; j < tokensVector.length; j += 2) {
            attribute = (tokensVector.get_Item(j));
            valueStr = (tokensVector.get_Item(j + 1));
            switch (attribute) {
                case ConstInterface.MG_ATTR_MODE:
                    this._mode = valueStr[0];
                    break;
                case XMLConstants.MG_ATTR_ID:
                    this.setId(XmlParser.getInt(valueStr));
                    break;
                case XMLConstants.MG_ATTR_VB_VIEW_ROWIDX:
                    this.setDBViewRowIdx(XmlParser.getInt(valueStr));
                    break;
                case XMLConstants.MG_ATTR_VALUE:
                    if (this.ValueInBase64) {
                        recFieldsData = Base64.decode(valueStr);
                    }
                    else {
                        recFieldsData = XmlParser.unescape(valueStr);
                    }
                    break;
                case ConstInterface.MG_ATTR_CURR_REC:
                    {
                    }
                    break;
                case ConstInterface.MG_ATTR_ADD_AFTER:
                    this._addAfter = XmlParser.getInt(valueStr);
                    break;
                case ConstInterface.MG_ATTR_FLAGS:
                    recFlags = valueStr;
                    break;
                case ConstInterface.MG_ATTR_MODIFIED:
                    this._modified = true;
                    break;
                case ConstInterface.MG_ATTR_DC_REFS:
                    this.fillDCRef(valueStr);
                    break;
                case ConstInterface.MG_ATTR_DBPOS:
                    this._dbPosBase64Val = valueStr;
                    break;
                default:
                    Logger.Instance.WriteExceptionToLogWithMsg("in Record.initElements() unknown attribute: " + attribute);
                    break;
            }
        }
        if (this.ValueInBase64) {
            let fldValInBytes = ISO_8859_1_Encoding.ISO_8859_1.GetBytes(recFieldsData);
            this.fillFieldsData(fldValInBytes, recFlags);
        }
        else {
            this.fillFieldsData(recFieldsData, recFlags, isCurrRec);
        }
        return isCurrRec;
    }
    peekIsCurrRec(tokensVector) {
        let attribute;
        let valueStr;
        for (let j = 0; j < tokensVector.length; j += 2) {
            attribute = (tokensVector.get_Item(j));
            if (attribute === ConstInterface.MG_ATTR_CURR_REC) {
                valueStr = (tokensVector.get_Item(j + 1));
                return XmlParser.getBoolean(valueStr);
            }
        }
        return false;
    }
    fillFieldsData(fldValInBytesOrFldsVal, recFlags, isCurrRec) {
        if (isNullOrUndefined(isCurrRec))
            this.fillFieldsData_0();
        else
            this.fillFieldsData_1(fldValInBytesOrFldsVal, recFlags, isCurrRec);
    }
    fillFieldsData_0() {
    }
    fillFieldsData_1(fldsVal, recFlags, isCurrRec) {
        let val = null;
        let tmp = null;
        let parsedLen = new RefParam(0);
        let i, j = 0, from, size;
        let currType;
        let useHex;
        let fld = null;
        let valueNotPassed;
        from = this.getFromFldIdx(isCurrRec);
        size = this.getSizeFld(isCurrRec);
        for (i = from; j < size; i++, j++) {
            fld = this.getFieldsTab().getField(i);
            currType = fld.getType();
            useHex = (Environment.Instance.GetDebugLevel() > 1 ||
                currType === StorageAttribute.ALPHA ||
                currType === StorageAttribute.UNICODE ||
                StorageAttributeCheck.isTypeLogical(currType));
            if (recFlags[j] === '.')
                this._flags[i] = 0;
            else if (recFlags[j] === '/')
                this._flags[i] = 1;
            else {
                tmp = recFlags.substr(j * 2, 2);
                this._flags[i] = parseInt(tmp, 16);
            }
            valueNotPassed = Record.FLAG_VALUE_NOT_PASSED === (this._flags[i] & Record.FLAG_VALUE_NOT_PASSED);
            this._flags[i] = this._flags[i] & ~Record.FLAG_VALUE_NOT_PASSED;
            this._flagsHistory[i] = this._flags[i];
            if (Record.FLAG_UPDATED === (this._flags[i] & Record.FLAG_UPDATED))
                this._updated = true;
            if (valueNotPassed) {
                if (Record.FLAG_NULL === (this._flags[i] & Record.FLAG_NULL)) {
                    val = fld.getDefaultValue();
                }
                else {
                    val = this._dataview.getCurrRec().GetFieldValue(i);
                }
            }
            else {
                val = RecordUtils.deSerializeItemVal(fldsVal, currType, fld.getSize(), useHex, fld.getCellsType(), parsedLen);
                fldsVal = fldsVal.substr(parsedLen.value);
            }
            this._fieldsData[i] = val;
        }
        this.setInitialFldVals(false, false);
    }
    fillDCRef(valueStr) {
        if (!NString.IsNullOrEmpty(valueStr)) {
            let couples = StrUtil.tokenize(valueStr, "$");
            let size = couples.length;
            for (let i = 0; i < size; i = i + 1) {
                this._dcRefs.Add(DcValuesReference.Parse(couples[i], this._dataview));
            }
        }
    }
    buildFieldsData(message, isCurrRec, getOldVal) {
        let tmpStr = new StringBuilder();
        let from = this.getFromFldIdx(isCurrRec);
        let size = this.getSizeFld(isCurrRec);
        for (let i = from; i < from + size; i = i + 1) {
            let fld = this.getFieldsTab().getField(i);
            if (fld.IsExposedToClient === false)
                this.setShrinkFlag(i);
            if (Record.FLAG_VALUE_NOT_PASSED === (this._flags[i] & Record.FLAG_VALUE_NOT_PASSED))
                continue;
            tmpStr.Append(this.getFieldDataXML(i, getOldVal).toString());
        }
        if (tmpStr.Length === 0) {
            tmpStr.Append(" ");
        }
        message.Append(tmpStr.ToString());
    }
    getXMLForValue(fldIdx, fldVal) {
        let cellAttr = StorageAttribute.SKIP;
        let fldAttr = this.getFieldsTab().getType(fldIdx);
        if (fldAttr === StorageAttribute.BLOB_VECTOR)
            cellAttr = this.getFieldsTab().getField(fldIdx).getCellsType();
        let toBase64 = Environment.Instance.GetDebugLevel() <= 1;
        return Record.serializeItemVal(fldVal, fldAttr, cellAttr, toBase64);
    }
    getFromFldIdx(isCurrRec) {
        if (isCurrRec)
            return 0;
        else
            return this.getFieldsTab().getRMIdx();
    }
    getSizeFld(isCurrRec) {
        if (isCurrRec)
            return this.getFieldsTab().getSize();
        else
            return this.getFieldsTab().getRMSize();
    }
    buildXML(message, isCurrRec, forceBuild) {
        if (isNullOrUndefined(forceBuild))
            this.buildXML_0(message, isCurrRec);
        else
            this.buildXML_1(message, isCurrRec, forceBuild);
    }
    buildXML_0(message, isCurrRec) {
        this.buildXML_1(message, isCurrRec, false);
    }
    buildXML_1(message, isCurrRec, forceBuild) {
        let recFlags;
        let from, size, i;
        let aFlag;
        let hexFlag;
        if (!forceBuild)
            if (this._mode !== DataModificationTypes.Insert && this._mode !== DataModificationTypes.Update &&
                this._mode !== DataModificationTypes.Delete && !isCurrRec)
                return;
        message.Append("\n            <" + ConstInterface.MG_TAG_REC);
        if (this._id > Int32.MinValue)
            message.Append(" " + XMLConstants.MG_ATTR_ID + "=\"" + this._id + "\"");
        message.Append(" " + ConstInterface.MG_ATTR_MODE + "=\"" + this._mode + "\"");
        if (this._mode === DataModificationTypes.Insert && this._prev != null)
            message.Append(" " + ConstInterface.MG_ATTR_ADD_AFTER + "=\"" + this._prev.getId() + "\"");
        if (!forceBuild && !isCurrRec)
            this.clearMode();
        message.Append(" " + XMLConstants.MG_ATTR_VALUE + "=\"");
        if (!forceBuild && isCurrRec)
            this.setShrinkFlags();
        let getOldVal;
        if (this.Synced)
            getOldVal = false;
        else {
            let task = this._dataview.getTask();
            getOldVal = (!isCurrRec && (task.getLevel() === Constants.TASK_LEVEL_RECORD ||
                task.getLevel() === Constants.TASK_LEVEL_CONTROL) &&
                this._dataview.getCurrRec() != null && this._dataview.getCurrRec().getId() === this._id);
        }
        this.buildFieldsData(message, isCurrRec, getOldVal);
        message.Append("\"");
        recFlags = new StringBuilder();
        from = this.getFromFldIdx(isCurrRec);
        size = this.getSizeFld(isCurrRec);
        for (i = from; i < from + size; i++) {
            aFlag = this._flagsHistory[i];
            aFlag = aFlag & Record.FLAG_CRSR_MODIFIED;
            aFlag = aFlag | this._flags[i];
            hexFlag = NNumber.ToString(aFlag, "X2");
            recFlags.Append(hexFlag);
            if (isCurrRec)
                this._flags[i] = (this._flags[i] & ~Record.FLAG_VALUE_NOT_PASSED);
        }
        message.Append(" " + ConstInterface.MG_ATTR_FLAGS + "=\"" + recFlags.ToString() + "\"");
        if (isCurrRec) {
            message.Append(" " + ConstInterface.MG_ATTR_CURR_REC + "=\"1\"");
            if (this.Modified)
                message.Append(" " + ConstInterface.MG_ATTR_MODIFIED + "=\"1\"");
        }
        if (this._linksFldsPos != null)
            message.Append(" " + ConstInterface.MG_ATTR_DBPOS + "=\"" + XmlParser.escape(this._linksFldsPos) + "\" ");
        message.Append(XMLConstants.TAG_TERM);
    }
    setShrinkFlags() {
        let i;
        let size = this.getSizeFld(true);
        let serverCurrRec = this._dataview.getServerCurrRec();
        if (serverCurrRec == null)
            return;
        for (i = 0; i < size; i++) {
            if (this.fldValsEqual(serverCurrRec, i) || (Record.FLAG_NULL === (this._flags[i] & Record.FLAG_NULL))) {
                this._flags[i] = this._flags[i] | Record.FLAG_VALUE_NOT_PASSED;
            }
        }
    }
    setShrinkFlag(fldIdx) {
        this._flags[fldIdx] |= Record.FLAG_VALUE_NOT_PASSED;
    }
    SetFieldValue(idx, isNull, value) {
        let field = this.getFieldsTab().getField(idx);
        field.UpdateNull(isNull, this);
        value = this.CheckMgValue(value, isNull, field);
        this._fieldsData[idx] = value;
        field.takeValFromRec();
        this.clearFlag(field.getId(), Record.FLAG_INVALID);
        field.invalidate(true, false);
    }
    setFieldValue(fldIdx, mgVal, setRecordUpdated) {
        let fld = this.getFieldsTab().getField(fldIdx);
        if (fld.PrevIsNull() === fld.isNull() && mgVal === this.GetFieldValue(fldIdx))
            return;
        mgVal = this.CheckMgValue(mgVal, fld.isNull(), fld);
        if (fldIdx >= 0 && fldIdx < this.getFieldsTab().getSize()) {
            this._fieldsData[fldIdx] = mgVal;
            if (setRecordUpdated) {
                if (fld.PartOfDataview)
                    this._modified = true;
                if (RemoteCommandsProcessor.GetInstance().DelayCommandExecution) {
                    RemoteCommandsProcessor.GetInstance().DelayCommandExecution = false;
                    this._dataview.getTask().DelayCommandExecution = true;
                }
                this._dataview.setChanged(true);
                this.setMode(DataModificationTypes.Update);
            }
        }
        else
            Logger.Instance.WriteExceptionToLogWithMsg("in Record.setFieldValue() illegal field index: " + fldIdx);
    }
    CheckMgValue(mgVal, isNull, fld) {
        if (mgVal === null || isNull) {
            mgVal = fld.getNullValue();
            if (mgVal === null)
                mgVal = fld.getMagicDefaultValue();
        }
        let size = fld.getSize();
        if (UtilStrByteMode.isLocaleDefLangDBCS() && fld.getType() !== StorageAttribute.UNICODE) {
            if (mgVal !== null && UtilStrByteMode.lenB(mgVal) > size)
                mgVal = UtilStrByteMode.leftB(mgVal, size);
        }
        else {
            if (mgVal !== null && mgVal.length > size)
                mgVal = mgVal.substr(0, size);
        }
        return mgVal;
    }
    setModified() {
        this._modified = true;
    }
    resetModified() {
        this._modified = false;
    }
    setUpdated() {
        this._updated = true;
    }
    resetUpdated() {
        this._updated = false;
    }
    GetFieldValue(fldIdx) {
        let val = null;
        if (fldIdx >= 0 && fldIdx < this._fieldsData.length)
            val = this._fieldsData[fldIdx];
        return val.toString();
    }
    replicate() {
        let record = new Record(this);
        record._fieldsData = this._fieldsData.slice();
        record._flags = this._flags.subarray(0);
        record._flagsHistory = this._flagsHistory.subarray(0);
        record._dcRefs = this._dcRefs.Clone();
        return record;
    }
    setSameAs(rec, realOnly, rId) {
        if (arguments.length === 3)
            this.setSameAs_0(rec, realOnly, rId);
        else
            this.setSameAs_1(rec, realOnly);
    }
    setSameAs_0(rec, realOnly, rId) {
        this.setSameAs(rec, realOnly);
        this.setId(rId);
    }
    setSameAs_1(rec, realOnly) {
        this._id = rec._id;
        this._hashKey = rec._hashKey;
        if (!this._dataview.getTask().transactionFailed(ConstInterface.TRANS_RECORD_PREFIX))
            this.setMode(rec._mode);
        this._addAfter = rec._addAfter;
        if (realOnly) {
            for (let i = 0; i < this.getFieldsTab().getSize(); i = i + 1) {
                let afield = rec.getFieldsTab().getField(i);
                if (!afield.IsVirtual) {
                    this._fieldsData[i] = rec._fieldsData[i];
                    this._flags[i] = rec._flags[i];
                    this._flagsHistory[i] = rec._flagsHistory[i];
                }
            }
        }
        else {
            this._fieldsData = rec._fieldsData;
            this._flags = rec._flags;
            this._flagsHistory = rec._flagsHistory;
        }
        this._modified = rec._modified;
        this._dataview = rec._dataview;
        this._computed = rec._computed;
        this._updated = rec._updated;
        this.setDcRefs(rec._dcRefs);
        if (rec._next !== this) {
            this._next = rec._next;
        }
        if (rec._prev !== this) {
            this._prev = rec._prev;
        }
    }
    IsNull(fldIdx) {
        this.checkFlags(fldIdx);
        return ((this._flags[fldIdx] & Record.FLAG_NULL) === Record.FLAG_NULL);
    }
    isLinkInvalid(fldIdx) {
        this.checkFlags(fldIdx);
        return ((this._flags[fldIdx] & Record.FLAG_INVALID) === Record.FLAG_INVALID);
    }
    isFldModified(fldIdx) {
        this.checkFlags(fldIdx);
        return ((this._flags[fldIdx] & Record.FLAG_MODIFIED) === Record.FLAG_MODIFIED);
    }
    IsFldModifiedAtLeastOnce(fldIdx) {
        this.checkFlags(fldIdx);
        return ((this._flags[fldIdx] & Record.FLAG_MODIFIED_ATLEAST_ONCE) === Record.FLAG_MODIFIED_ATLEAST_ONCE);
    }
    isFldUpdated(fldIdx) {
        this.checkFlags(fldIdx);
        return ((this._flags[fldIdx] & Record.FLAG_UPDATED) === Record.FLAG_UPDATED);
    }
    setFlag(fldIdx, aFlag) {
        this.checkFlags(fldIdx);
        this._flags[fldIdx] = this._flags[fldIdx] | aFlag;
        if (aFlag === Record.FLAG_CRSR_MODIFIED)
            this._flagsHistory[fldIdx] = this._flagsHistory[fldIdx] | aFlag;
    }
    clearFlag(fldIdx, aFlags) {
        this.checkFlags(fldIdx);
        this._flags[fldIdx] = this._flags[fldIdx] & ~aFlags;
    }
    clearFlagsHistory() {
        for (let i = 0; i < this._flags.length; i = i + 1)
            this._flagsHistory[i] = 0;
    }
    clearFlags(aFlags) {
        for (let i = 0; i < this._flags.length; i = i + 1)
            this.clearFlag(i, aFlags);
    }
    clearFlagsForRealOnly(aFlags) {
        for (let i = 0; i < this._flags.length; i = i + 1) {
            let field = this.getFieldsTab().getField(i);
            if (!field.IsVirtual) {
                this.clearFlag(i, aFlags);
            }
        }
    }
    clearHistoryFlag(fldIdx) {
        if (this._flagsHistory !== null && fldIdx < this.getFieldsTab().getSize() && fldIdx >= 0) {
            this._flagsHistory[fldIdx] = 0;
        }
    }
    checkFlags(fldIdx) {
        if (this._flags === null || fldIdx >= this.getFieldsTab().getSize() || fldIdx < 0) {
            throw new ApplicationException("Cannot find flags");
        }
    }
    restart(oldMode) {
        let task = this._dataview.getTask();
        if (oldMode === DataModificationTypes.None) {
            let rec = this._dataview.getCurrRec();
            let isCurrRec = (rec != null && rec.getId() === this._id);
            if ((this._dataview.getTask()).getMode() === Constants.TASK_MODE_CREATE)
                if (isCurrRec && !task.getAfterRetry() && task.TryingToCommit && !this._dataview.inRollback())
                    oldMode = DataModificationTypes.Update;
                else
                    oldMode = DataModificationTypes.Insert;
            else
                oldMode = DataModificationTypes.Update;
        }
        this.setMode(oldMode);
        if (oldMode === DataModificationTypes.Insert)
            this.setNewRec();
    }
    setLateCompute(val) {
        this._lateCompute = val;
    }
    lateCompute() {
        return this._lateCompute;
    }
    setInDeleteProcess(val) {
        this._inDeleteProcess = val;
    }
    inDeleteProcess() {
        return this._inDeleteProcess;
    }
    removeRecFromDc() {
        if (this._dcRefs !== null) {
            this._dcRefs.Dispose();
        }
    }
    isSameRecData(rec, currRec, checkOnlyParetOfDataview) {
        let size = this.getSizeFld(currRec);
        let start = this.getFromFldIdx(currRec);
        let i;
        let field;
        if (this === rec)
            return true;
        try {
            if (rec.getSizeFld(currRec) !== size)
                return false;
            if (rec.getFromFldIdx(currRec) !== start)
                return false;
            for (i = 0; i < start + size; i++) {
                field = this.getFieldsTab().getField(i);
                if (checkOnlyParetOfDataview && !field.PartOfDataview)
                    continue;
                if (!this.fldValsEqual(rec, i))
                    return false;
            }
        }
        catch (err) {
            if (err instanceof ApplicationException)
                return false;
            throw err;
        }
        return true;
    }
    fldValsEqual(rec, fldIdx) {
        let type = this.getFieldsTab().getField(fldIdx).getType();
        return ExpressionEvaluator.mgValsEqual(this.GetFieldValue(fldIdx), this.IsNull(fldIdx), type, rec.GetFieldValue(fldIdx), rec.IsNull(fldIdx), type);
    }
    getHashKey() {
        return this._hashKey;
    }
    setNextRec(nextRec) {
        this._next = nextRec;
    }
    setPrevRec(prevRec) {
        this._prev = prevRec;
    }
    getPrevRec() {
        return this._prev;
    }
    getNextRec() {
        return this._next;
    }
    getDcRefs() {
        return this._dcRefs.Clone();
    }
    setDcRefs(newDcRefs) {
        this.removeRecFromDc();
        this._dcRefs = newDcRefs.Clone();
        this.SetDcValueId();
    }
    realModified() {
        let bRc = false;
        let tabSize = this.getFieldsTab().getSize();
        let j;
        for (j = 0; j < tabSize; j++) {
            if ((this._flags[j] & Record.FLAG_MODIFIED) === Record.FLAG_MODIFIED) {
                if (!(this.getFieldsTab().getField(j).IsVirtual)) {
                    bRc = true;
                    break;
                }
            }
        }
        return bRc;
    }
    ToString() {
        let str = new StringBuilder();
        this.buildXML(str, (this._dataview.getCurrRec()).getId() === this._id, true);
        return str.ToString();
    }
    setSendToServer(val) {
        this._sendToServer = val;
    }
    getRecSize() {
        let sum = 0;
        for (let i = 0; i < this.getFieldsTab().getSize(); i = i + 1) {
            let field = this.getFieldsTab().getField(i);
            sum = sum + field.getSize();
        }
        return sum;
    }
    copyCrsrModifiedFlags(rec) {
        let tabSize = this.getFieldsTab().getSize();
        let j;
        for (j = 0; j < tabSize; j++) {
            this._flags[j] = rec._flags[j];
            this._flags[j] = this._flags[j] & Record.FLAG_CRSR_MODIFIED;
        }
    }
    getDbPosVal() {
        return this._dbPosBase64Val;
    }
    buildLinksPosStr() {
        let tbl = this._dataview.getTask().getDataviewHeaders();
        if (tbl !== null) {
            this._linksFldsPos = tbl.buildDbPosString();
        }
    }
    setForceSaveOrg(val) {
        this._forceSaveOrg = val;
    }
    getForceSaveOrg() {
        return this._forceSaveOrg;
    }
    isCauseInvalidation() {
        return this._causeInvalidation;
    }
    setCauseInvalidation(causeInvalidation) {
        this._causeInvalidation = causeInvalidation;
    }
    isComputed() {
        return this._computed;
    }
    setComputed(val) {
        this._computed = val;
    }
    setInCompute(val) {
        if (!val)
            this.setComputed(true);
        this._inCompute = val;
    }
    setInRecompute(val) {
        this._inRecompute = val;
    }
    setMode(newMode) {
        switch (newMode) {
            case DataModificationTypes.None:
            case DataModificationTypes.Insert:
            case DataModificationTypes.Update:
            case DataModificationTypes.Delete:
                if (this._mode === DataModificationTypes.None ||
                    this._mode === DataModificationTypes.Update && newMode === DataModificationTypes.Delete)
                    this._mode = newMode;
                break;
            default:
                Logger.Instance.WriteExceptionToLogWithMsg("in Record.setMode(): illegal mode: " + newMode);
                break;
        }
    }
    clearMode() {
        this._mode = DataModificationTypes.None;
    }
    setOldRec() {
        this._newRec = false;
    }
    setNewRec() {
        this._newRec = true;
    }
    static serializeItemVal(itemVal, itemAttr, cellAttr, ToBase64) {
        return RecordUtils.serializeItemVal(itemVal, itemAttr, cellAttr, ToBase64);
    }
    SetDcValueId() {
        let form = this._dataview.getTask().getForm();
        let mgControl = null;
        if (form != null && this._dcRefs != null) {
            this._dcRefs.Refs.forEach((dcRef) => {
                mgControl = form.getCtrl(dcRef.ditIdx);
                if (mgControl != null)
                    mgControl.setDcValId(dcRef.DcValues.getId());
            });
        }
    }
    resetDcValueId() {
        let form = this._dataview.getTask().getForm();
        let mgControl = null;
        if (form != null && this._dcRefs != null) {
            this._dcRefs.Refs.forEach(function (dcRef) {
                mgControl = form.getCtrl(dcRef.ditIdx);
                if (mgControl != null)
                    mgControl.setDcValId(EMPTY_DCREF);
            });
        }
    }
    AddDcValuesReference(controlId, dcValuesId) {
        let dcValues = this._dataview.getDcValues(dcValuesId);
        let dcRef = new DcValuesReference(controlId, dcValues);
        if (this._dcRefs === null) {
            this._dcRefs = new ObjectReferencesCollection();
        }
        this._dcRefs.Add(dcRef);
    }
}
Record.FLAG_NULL = (0x01);
Record.FLAG_INVALID = (0x02);
Record.FLAG_MODIFIED = (0x04);
Record.FLAG_UPDATED = (0x08);
Record.FLAG_CRSR_MODIFIED = (0x10);
Record.FLAG_VALUE_NOT_PASSED = (0x20);
Record.FLAG_MODIFIED_ATLEAST_ONCE = (0x40);
Record.INCREASE = true;
Record.DECREASE = false;
class DcValuesReference extends ObjectReferenceBase {
    get DcValues() {
        return this.Referent;
    }
    constructor(controlId, referencedDcValues) {
        super(referencedDcValues);
        this.ditIdx = 0;
        this.ditIdx = controlId;
    }
    Clone() {
        return new DcValuesReference(this.ditIdx, this.Referent);
    }
    static Parse(couple, dcValuesOwner) {
        let commaPos = couple.indexOf(",");
        let controlId = NNumber.Parse(couple.substr(0, commaPos));
        let dcId = NNumber.Parse(couple.substr(commaPos + 1));
        return new DcValuesReference(controlId, dcValuesOwner.getDcValues(dcId));
    }
}

class RecordsTable {
    constructor(withLinkedListOrRecordTable) {
        this._useLinkedList = false;
        this._hashTab = null;
        this._initialCurrRecId = Int32.MinValue;
        this._records = null;
        this._serverCurrRec = null;
        this.InsertedRecordsCount = 0;
        if (withLinkedListOrRecordTable.constructor === Boolean) {
            this._records = new List();
            this._hashTab = new Hashtable(100, 0.7);
            this._useLinkedList = withLinkedListOrRecordTable;
            this.InsertedRecordsCount = Int32.MinValue;
        }
        else
            Object.assign(this, withLinkedListOrRecordTable);
    }
    fillData(dataview, insertAt, parser) {
        let c = 'N';
        let record = null;
        let flag = false;
        this.InsertedRecordsCount = 0;
        this._initialCurrRecId = Int32.MinValue;
        let nextTag = parser.getNextTag();
        while (nextTag !== null && nextTag === "rec") {
            let record2 = new Record(dataview);
            record2.Initialize();
            let isCurrRec = record2.fillData(parser);
            if (isCurrRec && !dataview.HasMainTable) {
                let dcRefs2;
                let dcRefs = dcRefs2 = record2.getDcRefs();
                try {
                    for (let i = 0; i < this.getSize(); i = i + 1) {
                        this.getRecByIdx(i).setDcRefs(dcRefs);
                    }
                }
                finally {
                    if (dcRefs2 !== null) {
                        (dcRefs2).Dispose();
                    }
                }
            }
            if (isCurrRec) {
                if (dataview.getTask().getMode() !== 'C') {
                    record2.setOldRec();
                }
                this._initialCurrRecId = record2.getId();
                this._serverCurrRec = record2.replicate();
                if (c === 'N') {
                    c = 'C';
                }
                else {
                    c = 'F';
                }
            }
            else {
                record2.setOldRec();
                c = 'T';
            }
            let foundRec = this.getRecord(record2.getId());
            if (foundRec !== null) {
                let updated = foundRec.Updated;
                let modified = foundRec.Modified;
                let computed = foundRec.isComputed();
                let prevRec = foundRec.getPrevRec();
                let nextRec = foundRec.getNextRec();
                foundRec.setSameAs(record2, false);
                foundRec.setPrevRec(prevRec);
                foundRec.setNextRec(nextRec);
                foundRec.setComputed(computed);
                if (modified)
                    foundRec.setModified();
                if (updated)
                    foundRec.setUpdated();
            }
            else {
                this.InsertRecord(insertAt, record2);
                if (dataview.getTask().isTableWithAbsolutesScrollbar()) {
                    if (dataview.TotalRecordsCount === 0 && dataview.RecordsBeforeCurrentView == 0)
                        dataview.TotalRecordsCount = dataview.TotalRecordsCount + 1;
                    if (dataview.RecordsBeforeCurrentView > 0 && insertAt === 'B')
                        dataview.RecordsBeforeCurrentView = dataview.RecordsBeforeCurrentView - 1;
                }
                if (isCurrRec && dataview.getTask().getMode() === 'C')
                    record2.setMode(DataModificationTypes.Insert);
                record2.setComputed(true);
            }
            nextTag = parser.getNextTag();
            if (!isCurrRec)
                record = record2;
            flag = true;
        }
        let num = 0;
        while (!dataview.HasMainTable && record !== null && num < dataview.getChunkSize() - 1) {
            let record4 = new Record(dataview);
            record4.Initialize();
            record4.setSameAs(record, false, record.getId() + num + 1);
            record4.setOldRec();
            this.addRec(record4);
            num = num + 1;
        }
        if (this._initialCurrRecId === Int32.MinValue) {
            if (flag)
                this._serverCurrRec = null;
            else {
                if (dataview.getCurrRec() !== null)
                    this._serverCurrRec = (dataview.getCurrRec()).replicate();
                else
                    this._serverCurrRec = null;
            }
        }
        return c;
    }
    InsertRecord(insertAt, record) {
        if (insertAt === 'B') {
            let insertedRecordsCount = this.InsertedRecordsCount;
            this.InsertedRecordsCount = insertedRecordsCount + 1;
            this.insertRecord(record, 0);
        }
        else
            this.addRec(record);
    }
    buildXML(message, skipCurrRec, currRecId) {
        for (let i = 0; i < this._records.length; i = i + 1) {
            let record = this._records.get_Item(i);
            if (!record.SendToServer || (skipCurrRec && record.getId() === currRecId))
                continue;
            let prevRec;
            let record2 = prevRec = record.getPrevRec();
            let recIdx;
            while (prevRec !== null && typeof prevRec !== "undefined" &&
                (prevRec.getMode() === DataModificationTypes.Insert || !prevRec.SendToServer) &&
                record.getMode() === DataModificationTypes.Insert &&
                ((recIdx = this.getRecIdx(prevRec.getId())) > i || recIdx === RecordsTable.REC_NOT_FOUND || !prevRec.SendToServer)) {
                prevRec = prevRec.getPrevRec();
                record.setPrevRec(prevRec);
            }
            record.buildXML(message, false);
            if (prevRec !== record2) {
                record.setPrevRec(record2);
            }
        }
    }
    getRecord(id) {
        return this._hashTab.get_Item(id);
    }
    getRecIdx(id) {
        let result = RecordsTable.REC_NOT_FOUND;
        let record = this.getRecord(id);
        if (record !== null) {
            result = this._records.indexOf(record);
        }
        return result;
    }
    getRecByIdx(idx) {
        if (idx < 0 || idx >= this._records.length) {
            Logger.Instance.WriteDevToLog("in RecordsTable.getRecByIdx() index out of bounds: " + idx);
            return null;
        }
        return this._records.get_Item(idx);
    }
    removeAll() {
        this._records.Clear();
        this._hashTab.Clear();
    }
    getSize() {
        return this._records.length;
    }
    getInitialCurrRecId() {
        return this._initialCurrRecId;
    }
    addRecord(rec) {
        if (this._records.indexOf(rec) < 0) {
            this.addRec(rec);
        }
    }
    addRec(rec) {
        if (this._useLinkedList && this._records.length > 0) {
            let record = this._records.get_Item(this._records.length - 1);
            record.setNextRec(rec);
            rec.setPrevRec(record);
        }
        this._records.push(rec);
        this._hashTab.set_Item(rec.getHashKey(), rec);
    }
    insertRecord(rec, idx) {
        if (this._useLinkedList) {
            if (idx > 0) {
                let record = this._records.get_Item(idx - 1);
                rec.setPrevRec(record);
                record.setNextRec(rec);
            }
            if (idx !== this._records.length) {
                let record2 = this._records.get_Item(idx);
                rec.setNextRec(record2);
                record2.setPrevRec(rec);
            }
        }
        this._records.Insert(idx, rec);
        this._hashTab.set_Item(rec.getHashKey(), rec);
    }
    removeRecord(recIdxOrRec) {
        if (arguments.length === 1 && (recIdxOrRec === null || recIdxOrRec.constructor === Number)) {
            this.removeRecord_0(recIdxOrRec);
            return;
        }
        this.removeRecord_1(recIdxOrRec);
    }
    removeRecord_0(recIdx) {
        if (recIdx >= 0 && recIdx < this._records.length) {
            let record = this._records.get_Item(recIdx);
            let useLinkedList = this._useLinkedList;
            if (useLinkedList) {
                if (recIdx > 0) {
                    let record2 = this._records.get_Item(recIdx - 1);
                    record2.setNextRec(record.getNextRec());
                }
                if (recIdx + 1 < this._records.length) {
                    let record2 = this._records.get_Item(recIdx + 1);
                    record2.setPrevRec(record.getPrevRec());
                }
            }
            this._hashTab.Remove(record.getHashKey());
            this._records.RemoveAt(recIdx);
            return;
        }
        throw new ApplicationException("in RecordsTable.removeRecord(): invalid index: " + recIdx);
    }
    removeRecord_1(rec) {
        let num = this._records.indexOf(rec);
        if (num >= 0) {
            this.removeRecord(num);
        }
    }
    replicate() {
        let recordsTable = new RecordsTable(this);
        recordsTable._records = new List();
        recordsTable._hashTab = new Hashtable(100, 0.7);
        for (let i = 0; i < this._records.length; i = i + 1) {
            let record = this._records.get_Item(i).replicate();
            recordsTable._records.push(record);
            recordsTable._hashTab.set_Item(record.getHashKey(), record);
        }
        return recordsTable;
    }
    getServerCurrRec() {
        return this._serverCurrRec;
    }
    zeroServerCurrRec() {
        this._serverCurrRec = null;
    }
    GetSize() {
        return this.getSize();
    }
    GetRecByIdx(idx) {
        return this.getRecByIdx(idx);
    }
    RemoveAll() {
        this.removeAll();
    }
}
RecordsTable.REC_NOT_FOUND = -1;

class DataviewHeaderBase {
    get ReturnField() {
        if (this.returnfield === null && this._retVal !== null)
            this.returnfield = this.Task.getFieldByValueStr(this._retVal);
        return this.returnfield;
    }
    get IsMainSource() {
        return this._id === -1;
    }
    get Task() {
        return this._task;
    }
    get Fields() {
        return this._task.DataView.GetFieldsTab().getLinkFields(this._id);
    }
    get Id() {
        return this._id;
    }
    get LinkEvaluateCondition() {
        return this._linkEvalCondition;
    }
    constructor(task) {
        this._cond = null;
        this._task = null;
        this.Loc = null;
        this._dir = '\0';
        this._id = 0;
        this._keyIdx = 0;
        this._retVal = null;
        this.returnfield = null;
        this.LinkStartAfterField = 0;
        this.KeyExpression = 0;
        this._task = task;
        this._keyIdx = -1;
        this._cond = new YesNoExp(true);
    }
    SetAttributes(attributes) {
        let keys = attributes.Keys;
        keys.forEach((text) => {
            this.setAttribute(text, attributes.get_Item(text));
        });
    }
    setAttribute(attribute, valueStr) {
        switch (attribute) {
            case XMLConstants.MG_ATTR_ID:
                this._id = XmlParser.getInt(valueStr);
                break;
            case ConstInterface.MG_ATTR_KEY:
                this._keyIdx = XmlParser.getInt(valueStr);
                break;
            case ConstInterface.MG_ATTR_KEY_EXP:
                this.KeyExpression = XmlParser.getInt(valueStr);
                break;
            case ConstInterface.MG_ATTR_DIR:
                this._dir = valueStr[0];
                break;
            case ConstInterface.MG_ATTR_COND:
            case ConstInterface.MG_ATTR_COND_RES:
                this._cond.setVal(this._task, valueStr);
                break;
            case ConstInterface.MG_ATTR_RET_VAL:
                this._retVal = valueStr;
                break;
            case ConstInterface.MG_ATTR_LINK_EVAL_CONDITION:
                this._linkEvalCondition = valueStr[0];
                break;
            case ConstInterface.MG_ATTR_LINK_MODE:
                this.Mode = valueStr[0];
                break;
            case ConstInterface.MG_ATTR_LINK_START:
                this.LinkStartAfterField = XmlParser.getInt(valueStr);
                break;
            default:
                Logger.Instance.WriteExceptionToLogWithMsg(NString.Format("Unrecognized attribute: '{0}'", attribute));
                break;
        }
    }
    async getLinkedRecord(curRec) {
        return Promise.resolve(true);
    }
    async InitLinkFields(currRec) {
        for (let i = 0; i < this.Fields.length; i++) {
            let field = this.Fields.get_Item(i);
            let isNull = new RefParam(field.isNull());
            let result = new RefParam(field.getValue(false));
            await field.getInitExpVal(result, isNull);
            currRec.SetFieldValue(field.getId(), isNull.value, result.value);
            field.invalidate(true, false);
        }
    }
}

var Recompute_RcmpBy;
(function (Recompute_RcmpBy) {
    Recompute_RcmpBy["CLIENT"] = "C";
    Recompute_RcmpBy["SERVER_ON_CHANGE"] = "O";
})(Recompute_RcmpBy || (Recompute_RcmpBy = {}));
class Recompute {
    constructor() {
        this._ctrlProps = null;
        this._formProps = null;
        this._isOwnerFld = true;
        this.OwnerFld = null;
        this._rcmpOrder = null;
        this._subForms = null;
        this._subFormsOnlyRecomp = false;
        this._hasServerLinksRecomputes = false;
        this.RcmpMode = null;
        this.Task = null;
    }
    fillData(dataView, taskRef, parser) {
        this.Task = taskRef;
        this._isOwnerFld = true;
        while (this.initInnerObjects(parser, parser.getNextTag(), dataView)) {
        }
    }
    initInnerObjects(parser, foundTagName, dataView) {
        switch (foundTagName) {
            case XMLConstants.MG_TAG_FLD:
                if (this._isOwnerFld) {
                    this.fillFldField(parser, dataView);
                    this._isOwnerFld = false;
                }
                else
                    this.fillFldField(parser, dataView);
                break;
            case ConstInterface.MG_TAG_LINK:
                this.fillLink(parser, dataView);
                break;
            case XMLConstants.MG_TAG_CONTROL:
                if (this._ctrlProps == null)
                    this._ctrlProps = new PropTable();
                this._ctrlProps.fillDataByExists(this.Task, parser);
                if (this._ctrlProps.getCtrlRef() != null && this._ctrlProps.getCtrlRef().IsRepeatable && this.OwnerFld.IsVirtual &&
                    !(this.OwnerFld.hasInitExp()))
                    this.OwnerFld.causeTableInvalidation(true);
                break;
            case XMLConstants.MG_TAG_FORM_PROPERTIES:
                if (this._formProps == null)
                    this._formProps = new PropTable();
                this._formProps.fillDataByExists(this.Task, parser);
                break;
            case ConstInterface.MG_TAG_FLD_END:
                parser.setCurrIndex2EndOfTag();
                return false;
            default:
                Logger.Instance.WriteExceptionToLogWithMsg("There is no such tag in Recompute. Insert else if to Recompute.initInnerObjects for " + foundTagName);
                return false;
        }
        return true;
    }
    AddRecomputeItem(item) {
        if (this._rcmpOrder === null)
            this._rcmpOrder = new List();
        this._rcmpOrder.push(item);
    }
    fillLink(parser, dataView) {
        let endContext = parser.getXMLdata().indexOf(XMLConstants.TAG_TERM, parser.getCurrIndex());
        if (endContext !== -1 && endContext < parser.getXMLdata().length) {
            let tag = parser.getXMLsubstring(endContext);
            parser.add2CurrIndex(tag.indexOf(ConstInterface.MG_TAG_LINK) + ConstInterface.MG_TAG_LINK.length);
            let tokensVector = XmlParser.getTokens(parser.getXMLsubstring(endContext), XMLConstants.XML_ATTR_DELIM);
            for (let j = 0; j < tokensVector.length; j += 2) {
                let attribute = (tokensVector.get_Item(j));
                let valueStr = (tokensVector.get_Item(j + 1));
                if (attribute === XMLConstants.MG_ATTR_ID)
                    this.AddRecomputeItem(dataView.getTask().getDataviewHeaders().getDataviewHeaderById(XmlParser.getInt(valueStr)));
                else
                    Logger.Instance.WriteExceptionToLogWithMsg("There is no such tag in Recompute class. Insert case to Recompute.fillLink for " + attribute);
            }
            parser.setCurrIndex(endContext + XMLConstants.TAG_TERM.length);
            return;
        }
        else
            Logger.Instance.WriteExceptionToLogWithMsg("in Recompute.fillLink() out of bounds");
    }
    fillFldField(parser, dataView) {
        let endContext = parser.getXMLdata().indexOf(this._isOwnerFld
            ? XMLConstants.TAG_CLOSE
            : XMLConstants.TAG_TERM, parser.getCurrIndex());
        if (endContext !== -1 && endContext < parser.getXMLdata().length) {
            let tag = parser.getXMLsubstring(endContext);
            parser.add2CurrIndex(tag.indexOf(XMLConstants.MG_TAG_FLD) + XMLConstants.MG_TAG_FLD.length);
            let tokensVector = XmlParser.getTokens(parser.getXMLsubstring(endContext), XMLConstants.XML_ATTR_DELIM);
            this.initElements(tokensVector, dataView);
            if (this._isOwnerFld) {
                parser.setCurrIndex(++endContext);
                return;
            }
            parser.setCurrIndex(endContext + XMLConstants.TAG_TERM.length);
            return;
        }
        Logger.Instance.WriteExceptionToLogWithMsg("in Command.FillData() out of bounds");
    }
    initElements(tokensVector, dataView) {
        for (let j = 0; j < tokensVector.length; j += 2) {
            let attribute = (tokensVector.get_Item(j));
            let valueStr = (tokensVector.get_Item(j + 1));
            switch (attribute) {
                case XMLConstants.MG_ATTR_ID: {
                    let fldId = XmlParser.getInt(valueStr);
                    let fld = dataView.getField(fldId);
                    if (this._isOwnerFld) {
                        this.OwnerFld = fld;
                        this.OwnerFld.setRecompute(this);
                    }
                    else {
                        fld.setRecomputed();
                        this.AddRecomputeItem(fld);
                    }
                    break;
                }
                case ConstInterface.MG_ATTR_RECOMPUTEBY:
                    this.RcmpMode = valueStr[0];
                    break;
                case ConstInterface.MG_ATTR_SUB_FORM_RCMP:
                    this._subFormsOnlyRecomp = true;
                    break;
                case ConstInterface.MG_ATTR_HAS_LINK_RECOMPUTES:
                    this._hasServerLinksRecomputes = true;
                    break;
                case XMLConstants.MG_ATTR_NAME:
                    break;
                default:
                    Logger.Instance.WriteExceptionToLogWithMsg("There is no such tag in Recompute class. Insert case to Recompute.initElements for " + attribute);
                    break;
            }
        }
    }
    async execute(rec) {
        let i;
        let fld;
        let cmdsToServer = this.Task.getMGData().CmdsToServer;
        let cmd;
        try {
            rec.setInRecompute(true);
            this.Task.SetInRecompute(true);
            this.SetSubformsInRecompute(true);
            let allowServerRecompute = this._hasServerLinksRecomputes ||
                (this.Task.getForm().AllowedSubformRecompute && await this.checkRefreshSubForms());
            if (this.RcmpMode !== Recompute_RcmpBy.CLIENT && allowServerRecompute) {
                let inClient = this._subFormsOnlyRecomp;
                this.Task.ExecuteClientSubformRefresh = false;
                if (inClient) {
                    inClient = await this.Task.prepareCache(true);
                    if (inClient)
                        inClient = await this.Task.testAndSet(true);
                }
                if (!inClient) {
                    this.Task.DataView.GetFieldsTab().setServerRcmp(true);
                    cmd = CommandFactory.CreateRecomputeCommand(this.Task.getTaskTag(), this.OwnerFld.getId(), !this.Task.getForm().AllowedSubformRecompute);
                    cmdsToServer.Add(cmd);
                    await RemoteCommandsProcessor.GetInstance().Execute(CommandsProcessorBase_SendingInstruction.TASKS_AND_COMMANDS);
                }
                if (this.Task.ExecuteClientSubformRefresh)
                    await this.RefreshSubforms();
                else {
                    if (await this.recPrefixSubForms())
                        await this.recSuffixSubForms();
                    this.Task.CleanDoSubformPrefixSuffix();
                }
            }
            else {
                try {
                    FlowMonitorQueue.Instance.addRecompute(this.OwnerFld.getVarName(), this.Task.GetTaskDetails());
                    if (this._formProps != null)
                        await this._formProps.RefreshDisplay(false, false);
                    if (this._ctrlProps != null)
                        await this._ctrlProps.RefreshDisplay(false, false);
                    if (this._rcmpOrder != null) {
                        for (i = 0; i < this._rcmpOrder.length; i++) {
                            if (this._rcmpOrder.get_Item(i) instanceof FieldBase) {
                                fld = this._rcmpOrder.get_Item(i);
                                await this.fldRcmp(fld, true);
                            }
                            else if (this._rcmpOrder.get_Item(i) instanceof DataviewHeaderBase) {
                                let curLnk = this._rcmpOrder.get_Item(i);
                                await curLnk.getLinkedRecord(rec);
                                let linkFields = this.Task.DataView.GetFieldsTab().getLinkFields(curLnk.Id);
                                rec.setInCompute(true);
                                let saveInForceUpdate = rec.InForceUpdate;
                                rec.InForceUpdate = false;
                                for (let j = 0; j < linkFields.length; j++) {
                                    await this.fldRcmp(linkFields.get_Item(j), false);
                                    rec.clearFlag((linkFields.get_Item(j)).getId(), Record.FLAG_UPDATED);
                                    rec.clearFlag((linkFields.get_Item(j)).getId(), Record.FLAG_MODIFIED);
                                    rec.clearFlag((linkFields.get_Item(j)).getId(), Record.FLAG_CRSR_MODIFIED);
                                    rec.clearHistoryFlag((linkFields.get_Item(j)).getId());
                                }
                                rec.InForceUpdate = saveInForceUpdate;
                                let retFld = curLnk.ReturnField;
                                if (retFld != null)
                                    await this.fldRcmp(retFld, false);
                                rec.setInCompute(false);
                                rec.setForceSaveOrg(true);
                            }
                        }
                    }
                    await this.RefreshSubforms();
                }
                catch (e) {
                    Logger.Instance.WriteExceptionToLogWithMsg("in Recompute.execute(): " + e.Message);
                }
            }
            this.Task.SetInRecompute(false);
            this.SetSubformsInRecompute(false);
        }
        finally {
            rec.buildLinksPosStr();
            rec.setInRecompute(false);
        }
    }
    async RefreshSubforms() {
        if (this.Task.getForm().AllowedSubformRecompute) {
            let subformsToRefresh = await this.GetSubformsToRefresh();
            for (let i = 0; i < subformsToRefresh.length; i++) {
                let subformTask = subformsToRefresh.get_Item(i);
                await this.Task.SubformRefresh(subformTask, true);
            }
        }
    }
    async SetSubformsInRecompute(inRecompute) {
        let subformsToRefresh = await this.GetSubformsToRefresh();
        for (let i = 0; i < subformsToRefresh.length; i++) {
            let subformTask = subformsToRefresh.get_Item(i);
            subformTask.SetInRecompute(inRecompute);
        }
    }
    async fldRcmp(fld, computeField) {
        if (fld.IsVirtual
            || ((this.Task.getMode() !== Constants.TASK_MODE_QUERY ||
                Environment.Instance.allowUpdateInQueryMode(this.Task.getCompIdx())))) {
            if (!fld.isInEvalProcess()) {
                if (computeField)
                    await fld.compute(true);
                else
                    await fld.setValueAndStartRecompute(fld.getValue(false), fld.isNull(), true, false, false);
                await fld.updateDisplay();
            }
        }
    }
    buildSubFormList() {
        if (this._subForms === null) {
            this._subForms = new List();
            let subTasksTab = this.Task.getSubTasks();
            if (subTasksTab !== null) {
                for (let i = 0; i < subTasksTab.getSize(); i = i + 1) {
                    let subForm = subTasksTab.getTask(i);
                    if (subForm.getForm().getSubFormCtrl() !== null && subForm.refreshesOn(this.OwnerFld.getId())) {
                        this._subForms.push(subForm);
                    }
                }
            }
        }
    }
    RemoveSubform(subformTask) {
        this._subForms.Remove(subformTask);
    }
    AddSubform(subformTask) {
        if (this._subForms === null)
            this._subForms = new List();
        if (!this._subForms.Contains(subformTask))
            this._subForms.push(subformTask);
    }
    async recSuffixSubForms() {
        let i;
        let subForm;
        let successful = true;
        let subformCtrl;
        this.buildSubFormList();
        for (i = 0; successful && i < this._subForms.length; i++) {
            subForm = this._subForms.get_Item(i);
            subformCtrl = subForm.getForm().getSubFormCtrl();
            if (subForm.isStarted() && !subformCtrl.RefreshOnVisible &&
                await subformCtrl.checkProp(PropInterface.PROP_TYPE_AUTO_REFRESH, true) && !subForm.InSelect
                && subForm.DoSubformPrefixSuffix) {
                await AccessHelper.eventsManager.handleInternalEventWithTask(subForm, InternalInterface.MG_ACT_REC_SUFFIX);
                successful = !AccessHelper.eventsManager.GetStopExecutionFlag();
            }
        }
        this.Task.DataView.setPrevCurrRec();
        return (successful);
    }
    async checkRefreshSubForms() {
        let refresh = !this._subFormsOnlyRecomp;
        let subformsToRefresh = await this.GetSubformsToRefresh();
        if (subformsToRefresh.length > 0)
            refresh = true;
        return refresh;
    }
    async GetSubformsToRefresh() {
        let subTasks = new List();
        let subformCtrl;
        this.buildSubFormList();
        for (let i = 0; i < this._subForms.length; i++) {
            let subTask = this._subForms[i];
            subformCtrl = subTask.getForm().getSubFormCtrl();
            if (subTask.isStarted() && await subformCtrl.checkProp(PropInterface.PROP_TYPE_AUTO_REFRESH, true) &&
                !subTask.InSelect && !subTask.InEndTask) {
                await subformCtrl.checkProp(PropInterface.PROP_TYPE_VISIBLE, true);
                if (!subformCtrl.isVisible() && !await subformCtrl.checkProp(PropInterface.PROP_TYPE_REFRESH_WHEN_HIDDEN, false))
                    subformCtrl.RefreshOnVisible = true;
                else
                    subTasks.push(subTask);
            }
        }
        return subTasks;
    }
    async recPrefixSubForms() {
        let i;
        let subForm;
        let successful = true;
        let subformCtrl;
        this.buildSubFormList();
        for (i = 0; successful && i < this._subForms.length; i++) {
            subForm = this._subForms.get_Item(i);
            subformCtrl = subForm.getForm().getSubFormCtrl();
            if (subForm.isStarted() && !subformCtrl.RefreshOnVisible
                && await subformCtrl.checkProp(PropInterface.PROP_TYPE_AUTO_REFRESH, true)
                && !subForm.InSelect && subForm.DoSubformPrefixSuffix) {
                await AccessHelper.eventsManager.handleInternalEventWithTaskAndSubformRefresh(subForm, InternalInterface.MG_ACT_REC_PREFIX, true);
                successful = !AccessHelper.eventsManager.GetStopExecutionFlag();
            }
        }
        return successful;
    }
    notifyServerOnChange() {
        return this.RcmpMode === Recompute_RcmpBy.SERVER_ON_CHANGE;
    }
    isServerRcmp() {
        return this.RcmpMode !== Recompute_RcmpBy.CLIENT;
    }
}

class Boundary {
    constructor(task, minIdx, maxIdx, returnType, size, cacheTableId) {
        this._cacheTableFldId = 0;
        this._max = null;
        this._min = null;
        this._retType = StorageAttribute.NONE;
        this._size = 0;
        this._maxExpVal = null;
        this._minExpVal = null;
        this.DiscardMin = false;
        this.DiscardMax = false;
        this.MaxEqualsMin = false;
        if (arguments.length === 5)
            this.constructor_0(task, minIdx, maxIdx, returnType, size);
        else
            this.constructor_1(task, minIdx, maxIdx, returnType, size, cacheTableId);
    }
    constructor_0(task, minIdx, maxIdx, returnType, size) {
        this.constructor_1(task, minIdx, maxIdx, returnType, size, -1);
    }
    constructor_1(task, minIdx, maxIdx, returnType, size, cacheTableId) {
        this._retType = returnType;
        this._size = size;
        this._cacheTableFldId = cacheTableId;
        if (minIdx !== -1)
            this._min = task.getExpById(minIdx);
        if (maxIdx !== -1)
            this._max = task.getExpById(maxIdx);
    }
    hasMinExp() {
        return this._min !== null;
    }
    hasMaxExp() {
        return this._max !== null;
    }
    getExpType() {
        return this._retType;
    }
    getCacheTableFldId() {
        return this._cacheTableFldId;
    }
    async compute(padValueWithMinMaxCharacters) {
        if (this.hasMinExp()) {
            let minVal = await this._min.evaluateWithResultTypeAndLength(this.getExpType(), this._size);
            if (minVal !== null) {
                minVal = NString.TrimEnd(minVal, new Array(0));
            }
            this._minExpVal = new ExpVal(this.getExpType(), minVal === null, minVal);
            this.MaxEqualsMin = this.IsMaxEqualsMin();
            if (!this._minExpVal.IsNull && (this._minExpVal.Attr === StorageAttribute.ALPHA || this._minExpVal.Attr === StorageAttribute.UNICODE)) {
                if (padValueWithMinMaxCharacters) {
                    this._minExpVal.StrVal = DisplayConvertor.StringValueToMgValue(this._minExpVal.StrVal, this._minExpVal.Attr, Char.MinValue, this._size).toString();
                    this.MaxEqualsMin = false;
                }
                this._minExpVal.StrVal = StrUtil.SearchAndReplaceWildChars(this._minExpVal.StrVal, this._size, Char.MinValue);
            }
            this.DiscardMin = await this._min.DiscardCndRangeResult();
        }
        if (this.hasMaxExp()) {
            let maxVal = await this._max.evaluateWithResultTypeAndLength(this.getExpType(), this._size);
            this._maxExpVal = new ExpVal(this.getExpType(), maxVal === null, maxVal);
            if (!this._maxExpVal.IsNull && (this._maxExpVal.Attr === StorageAttribute.ALPHA || this._maxExpVal.Attr === StorageAttribute.UNICODE)) {
                if (padValueWithMinMaxCharacters) {
                    this._maxExpVal.StrVal = DisplayConvertor.StringValueToMgValue(this._maxExpVal.StrVal, this._maxExpVal.Attr, Char.MaxValue, this._size);
                }
                this._maxExpVal.StrVal = StrUtil.SearchAndReplaceWildChars(this._maxExpVal.StrVal, this._size, Char.MaxValue);
            }
            this.DiscardMax = await this._max.DiscardCndRangeResult();
        }
    }
    checkRange(val, IsNull) {
        let res = true;
        let cmpVal = new ExpVal(this.getExpType(), IsNull, val);
        if (cmpVal.IsNull && ((this.hasMinExp() && this._minExpVal.IsNull) || (this.hasMaxExp() && this._maxExpVal.IsNull))) {
            res = true;
        }
        else {
            if (this.hasMinExp()) {
                if (!this._minExpVal.IsNull && !cmpVal.IsNull) {
                    try {
                        if (ExpressionEvaluator.val_cmp_any(cmpVal, this._minExpVal) < 0)
                            res = false;
                    }
                    catch (exception) {
                        if (exception instanceof NullValueException) {
                            res = false;
                        }
                        else
                            throw exception;
                    }
                }
                else {
                    if (cmpVal.IsNull !== this._minExpVal.IsNull)
                        res = false;
                }
            }
            if (this.hasMaxExp() && res) {
                if (!this._maxExpVal.IsNull && !cmpVal.IsNull) {
                    try {
                        if (ExpressionEvaluator.val_cmp_any(cmpVal, this._maxExpVal) > 0)
                            res = false;
                    }
                    catch (exception) {
                        if (exception instanceof NullValueException)
                            res = false;
                        else
                            throw exception;
                    }
                }
                else if (cmpVal.IsNull !== this._maxExpVal.IsNull)
                    res = false;
            }
        }
        return res;
    }
    IsMaxEqualsMin() {
        let result = false;
        if (this.hasMaxExp() && this.hasMinExp()) {
            if (this._min.getId() === this._max.getId()) {
                if (this._retType === StorageAttribute.ALPHA || this._retType === StorageAttribute.UNICODE)
                    result = !this.WildCharExist();
                else
                    result = true;
            }
        }
        return result;
    }
    WildCharExist() {
        let wildChars = ["*", "?"];
        let result = false;
        if (!this._minExpVal.IsNull) {
            let stringValue = this._minExpVal.StrVal;
            for (let i = 0; i < wildChars.length; i = i + 1) {
                if (stringValue.endsWith(wildChars[i])) {
                    result = true;
                    break;
                }
            }
        }
        return result;
    }
    toString() {
        return NString.Format("{{Boundary: {0}-{1}, {2}, {3}}}", [
            this._max, this._max, this._retType, this._size
        ]);
    }
}

class Field extends FieldBase {
    constructor(dataview, id) {
        super(id);
        this._linkExp = null;
        this._recompute = null;
        this.CacheTableFldIdx = 0;
        this._causeTableInvalidation = false;
        this._form = null;
        this._hasChangeEvent = false;
        this._hasZoomHandler = false;
        this._inEvalProcess = false;
        this._initExp = null;
        this._invalidValue = true;
        this._isLinkFld = false;
        this._isVirtual = false;
        this._dataviewHeaderId = -1;
        this._linkCreate = false;
        this.Locate = null;
        this.Range = null;
        this._isParam = false;
        this._isExposedRouteParam = false;
        this._isExposedToClient = true;
        this._prevIsNull = false;
        this._prevValue = null;
        this._tableName = null;
        this._indexInTable = -1;
        this._virAsReal = false;
        this._val = null;
        this.modifiedAtLeastOnce = false;
        this._isNull = false;
        this._clearVectorType = true;
        this._vectorType = null;
        if (Field.NUM0 === null) {
            Field.NUM0 = new NUM_TYPE();
            Field.NUM1 = new NUM_TYPE();
            Field.NUM0.NUM_4_LONG(0);
            Field.NUM1.NUM_4_LONG(1);
        }
        this._dataview = dataview;
        this._linkExp = new YesNoExp(false);
        FieldDef._default_date = DisplayConvertor.Instance.disp2mg(PICInterface.DEFAULT_DATE, new PIC("6", StorageAttribute.NUMERIC, super.getTask().getCompIdx()), super.getTask().getCompIdx(), BlobType.CONTENT_TYPE_UNKNOWN);
    }
    get VirAsReal() {
        return this._virAsReal;
    }
    get IsVirtual() {
        return this._isVirtual;
    }
    get IsExposedRouteParam() {
        return this._isExposedRouteParam;
    }
    get IsExposedToClient() {
        return this._isExposedToClient;
    }
    get IndexInTable() {
        return this._indexInTable;
    }
    setAttribute(attribute, valueStr) {
        let isTagProcessed = super.setAttribute(attribute, valueStr);
        if (!isTagProcessed) {
            let data = StrUtil.tokenize(valueStr, ",");
            isTagProcessed = true;
            switch (attribute) {
                case ConstInterface.MG_ATTR_VIRTUAL:
                    this._isVirtual = (XmlParser.getInt(valueStr) !== 0);
                    break;
                case ConstInterface.MG_ATTR_PARAM:
                    this._isParam = (XmlParser.getInt(valueStr) !== 0);
                    if (!this._isVirtual && this._isParam)
                        throw new ApplicationException("in Field.initElements(): non virtual field is defined as a parameter");
                    break;
                case ConstInterface.MG_ATTR_EXPOSED_ROUTE_PARAMS:
                    this._isExposedRouteParam = (XmlParser.getInt(valueStr) !== 0);
                    if (!this._isParam && this._isExposedRouteParam)
                        throw new ApplicationException("in Field.initElements(): non parameter field is defined as a exposed route parameter");
                    break;
                case ConstInterface.MG_ATTR_EXPOSED_TO_CLIENT:
                    if (XmlParser.getInt(valueStr) == 0)
                        this._isExposedToClient = false;
                    break;
                case ConstInterface.MG_ATTR_VIR_AS_REAL:
                    this._virAsReal = XmlParser.getBoolean(valueStr);
                    break;
                case ConstInterface.MG_ATTR_LNK_CREATE:
                    this._linkCreate = XmlParser.getBoolean(valueStr);
                    break;
                case ConstInterface.MG_ATTR_LNKEXP:
                    this._linkExp.setVal((this.getTask()), valueStr);
                    break;
                case ConstInterface.MG_ATTR_TABLE_NAME:
                    this._tableName = XmlParser.unescape(valueStr);
                    break;
                case ConstInterface.MG_ATTR_INDEX_IN_TABLE:
                    this._indexInTable = XmlParser.getInt(valueStr);
                    break;
                case ConstInterface.MG_ATTR_INIT:
                    let expNum = XmlParser.getInt(valueStr);
                    this._initExp = this.getTask().getExpById(expNum);
                    break;
                case XMLConstants.MG_ATTR_NAME:
                    {
                    }
                    break;
                case ConstInterface.MG_ATTR_CHACHED_FLD_ID:
                    if (data[0] != "")
                        this.CacheTableFldIdx = NNumber.Parse(data[1]);
                    break;
                case ConstInterface.MG_ATTR_LOCATE:
                    this.Locate = new Boundary(this.getTask(), NNumber.Parse(data[1]), NNumber.Parse(data[0]), this.getType(), this.getSize(), this.CacheTableFldIdx);
                    break;
                case ConstInterface.MG_ATTR_RANGE:
                    this.Range = new Boundary(this.getTask(), NNumber.Parse(data[1]), NNumber.Parse(data[0]), this.getType(), this.getSize(), this.CacheTableFldIdx);
                    break;
                case ConstInterface.MG_ATTR_LINK:
                    this._dataviewHeaderId = NNumber.Parse(valueStr);
                    break;
                case ConstInterface.MG_ATTR_IS_LINK_FIELD:
                    this._isLinkFld = XmlParser.getBoolean(valueStr);
                    break;
                default:
                    isTagProcessed = false;
                    Logger.Instance.WriteExceptionToLogWithMsg(NString.Format("Unrecognized attribute: '{0}'", attribute));
                    break;
            }
        }
        return isTagProcessed;
    }
    setRecompute(recompRef) {
        this._recompute = recompRef;
    }
    RemoveSubformFromRecompute(subformTask) {
        if (this._recompute !== null) {
            this._recompute.RemoveSubform(subformTask);
        }
    }
    AddSubformRecompute(subformTask) {
        if (this._recompute === null) {
            this._recompute = new Recompute();
            this._recompute.Task = super.getTask();
            this._recompute.OwnerFld = this;
            this._recompute.RcmpMode = Recompute_RcmpBy.CLIENT;
        }
        this._recompute.AddSubform(subformTask);
    }
    SetControl(ctrl) {
        super.SetControl(ctrl);
        if (this._isVirtual && ctrl.IsRepeatable && this._initExp === null) {
            this._causeTableInvalidation = true;
        }
    }
    async compute(recompute) {
        let result = new RefParam(this.getValue(false));
        let isNullFld = new RefParam(this._isNull);
        let rec = this._dataview.getCurrRec();
        let task = super.getTask();
        let zeroReal = this._linkCreate && rec.InCompute && !recompute && task.getMode() === Constants.TASK_MODE_CREATE;
        if (this._form == null)
            this._form = task.getForm();
        if ((this._form != null && this._form.InRestore) || AccessHelper.eventsManager.GetStopExecutionFlag())
            zeroReal = false;
        let rtEvt = AccessHelper.eventsManager.getLastRtEvent();
        let computeOnCancelEvent = false;
        if (rtEvt != null)
            computeOnCancelEvent = rtEvt.getInternalCode() === InternalInterface.MG_ACT_CANCEL;
        if (!this._virAsReal && (this._form == null || !this._form.InRestore) &&
            ((this._isVirtual || (task.getMode() === Constants.TASK_MODE_CREATE && computeOnCancelEvent)) || recompute ||
                zeroReal || rec.isNewRec() && !rec.isComputed())) {
            if (!task.DataView.isEmptyDataview() || (task.DataView.isEmptyDataview() && !this.PartOfDataview)) {
                if ((this._isVirtual || task.getMode() === Constants.TASK_MODE_CREATE) || this._dataview.computeByClient() ||
                    !rec.InCompute || zeroReal || rec.lateCompute()) {
                    if (this._initExp != null) {
                        await this.EvaluateInitExpression(result, isNullFld);
                    }
                    else if (zeroReal)
                        result.value = this.getDefaultValue();
                }
            }
        }
        if (this._invalidValue) {
            this._prevValue = result.value;
            this._prevIsNull = isNullFld.value;
        }
        await this.setValue(result.value, isNullFld.value, recompute, false, recompute && !this._isVirtual, false, false);
    }
    async EvaluateInitExpression(result, isNullFld) {
        Debug.Assert(this._initExp !== null);
        try {
            this._inEvalProcess = true;
            result.value = await this._initExp.evaluateWithResultTypeAndLength(this._type, this._size);
        }
        finally {
            this._inEvalProcess = false;
        }
        isNullFld.value = (result.value === null);
        if (isNullFld.value && this.NullAllowed) {
            result.value = this.getValue(false);
        }
    }
    getValue(checkNullArithmetic) {
        if (super.getTask().getEvalOldValues())
            return this.getOriginalValue();
        if (this._invalidValue)
            this.takeValFromRec();
        if (this._isNull)
            this._val = this.getValueForNull(checkNullArithmetic);
        return this._val;
    }
    isChanged(newValue, isNull) {
        return this._prevValue !== null && (!(this._prevValue === newValue) || this._prevIsNull !== isNull);
    }
    takeValFromRec() {
        let rec = this._dataview.getCurrRec();
        if (rec !== null) {
            this._val = rec.GetFieldValue(this._id);
            this._isNull = rec.IsNull(this._id);
        }
        if (this._invalidValue) {
            if (rec !== null && this._causeTableInvalidation && this.isChanged(this._val, this._isNull) && this._form !== null) {
                rec.setCauseInvalidation(true);
            }
            this._prevValue = this._val;
            this._prevIsNull = this._isNull;
            this._invalidValue = false;
        }
        this._vectorType = null;
    }
    getOriginalValue() {
        let originalRec = this._dataview.getOriginalRec();
        if (originalRec.IsNull(this._id))
            return this.getMagicDefaultValue();
        return originalRec.GetFieldValue(this._id);
    }
    isOriginalValueNull() {
        let originalRec = this._dataview.getOriginalRec();
        return originalRec.IsNull(this._id);
    }
    getValueByRecIdx(idx) {
        let rec = this._dataview.getRecByIdx(idx);
        let fieldValue = rec.GetFieldValue(this._id);
        return rec.IsNull(this._id) ? this.getValueForNull(false) : fieldValue;
    }
    getModifiedAtLeastOnce() {
        return this.modifiedAtLeastOnce;
    }
    isNullByRecIdx(idx) {
        let rec = this._dataview.getRecByIdx(idx);
        return rec.IsNull(this._id);
    }
    isEqual(mgValue, isNullFld, type, recIdx) {
        let rec = (this._dataview.getRecByIdx(recIdx));
        let valsEqual = false;
        if (rec != null) {
            let fieldValue = rec.GetFieldValue(this._id);
            let fielsIsNull = rec.IsNull(this._id);
            valsEqual = ExpressionEvaluator.mgValsEqual(fieldValue, fielsIsNull, this._type, mgValue, isNullFld, type);
        }
        return valsEqual;
    }
    getNewRecValue(clobberedOnly) {
        if (this._isVirtual && this._initExp == null)
            return this._val;
        return !clobberedOnly ? this.getDefaultValue() : null;
    }
    async setValueAndStartRecompute(val, isNullFld, recompute, setRecordUpdated, isArgUpdate, enforceVariableChange) {
        if (isNullOrUndefined(enforceVariableChange))
            enforceVariableChange = false;
        await this.setValueAndStartRecompute_1(val, isNullFld, recompute, setRecordUpdated, isArgUpdate, false);
    }
    async setValueAndStartRecompute_1(val, isNullFld, recompute, setRecordUpdated, isArgUpdate, enforceVariableChange) {
        let task = this.getTask();
        if (task != null)
            task.VewFirst++;
        let valueWasUpdated = await this.setValue(val, isNullFld, recompute, setRecordUpdated, !this._isVirtual, isArgUpdate, enforceVariableChange);
        if (task !== null && task.VewFirst === 1 && this._form !== null && !this.IsEventHandlerField) {
            if (recompute && valueWasUpdated)
                await this._form.refreshOnExpressions();
        }
        if (task != null)
            task.VewFirst--;
    }
    async setValue(newVal, isNullFld, recompute, setRecordModified, setCrsrModified, isArgUpdate, enforceValiableChange) {
        let rec;
        let recFldVal;
        let valsEqual = false;
        let remainder;
        let zeroReal;
        let args = null;
        let mainCtrl = this.getCtrl();
        let pendingEvents;
        let evts;
        let forceUpdate = false;
        let checkForVariableChange = recompute || enforceValiableChange;
        let task = this.getTask();
        if (this._form === null)
            this._form = task.getForm();
        if (isNullFld && !this.NullAllowed && this._type !== StorageAttribute.BLOB_VECTOR) {
            newVal = this.getDefaultValue();
            isNullFld = false;
        }
        if (this._type === StorageAttribute.NUMERIC && newVal != null && !NUM_TYPE.numHexStrIsLong(newVal)) {
            let numVal = new NUM_TYPE(newVal);
            let pic = new PIC(this._picture, this._type, super.getTask().getCompIdx());
            let decs = pic.getDec();
            numVal.round(decs);
            newVal = numVal.toXMLrecord();
        }
        rec = this._dataview.getCurrRec();
        if (rec == null)
            throw new ApplicationException(LanguageData.Instance.getConstMessage(MsgInterface.RT_STR_NO_RECS_IN_RNG));
        if (!this.IsVirtual &&
            (task.getMode() === Constants.TASK_MODE_QUERY &&
                !Environment.Instance.allowUpdateInQueryMode(task.getCompIdx())
                || rec.InForceUpdate && rec.InCompute))
            return !valsEqual;
        if (checkForVariableChange && this.getHasChangeEvent()) {
            let argsList = new Array(2);
            argsList[0] = new ExpVal(StorageAttribute.NUMERIC, false, (mainCtrl !== null && mainCtrl.IsInteractiveUpdate
                ? Field.NUM0.toXMLrecord()
                : Field.NUM1.toXMLrecord()));
            argsList[1] = new ExpVal(this.getType(), this.isNull(), this.getValue(false));
            args = new ArgumentsList(argsList);
        }
        if (mainCtrl != null)
            mainCtrl.IsInteractiveUpdate = false;
        if (this._type !== StorageAttribute.UNICODE && UtilStrByteMode.isLocaleDefLangDBCS()) {
            if (newVal != null)
                remainder = this._size - UtilStrByteMode.lenB(newVal);
            else
                remainder = 0;
            if (newVal != null && this._type !== StorageAttribute.BLOB && this._type !== StorageAttribute.BLOB_VECTOR &&
                remainder < 0)
                this._val = UtilStrByteMode.leftB(newVal, this._size);
            else if (this._type === StorageAttribute.ALPHA && remainder > 0)
                this._val = newVal + NString.FromChars(this._spaces, 0, remainder);
            else if (this._type === StorageAttribute.BLOB)
                this._val = BlobType.copyBlob(this._val, newVal);
            else
                this._val = newVal;
        }
        else {
            if (newVal != null)
                remainder = this._size - newVal.length;
            else
                remainder = 0;
            if (newVal != null && this._type !== StorageAttribute.BLOB && this._type !== StorageAttribute.BLOB_VECTOR && remainder < 0)
                this._val = newVal.substr(0, this._size);
            else if ((this._type === StorageAttribute.ALPHA || this._type === StorageAttribute.UNICODE) && remainder > 0)
                this._val = newVal + NString.FromChars(this._spaces, 0, remainder);
            else if (this._type === StorageAttribute.BLOB) {
                if (this._val === null)
                    this._val = this.getMagicDefaultValue();
                this._val = BlobType.copyBlob(this._val, newVal);
            }
            else
                this._val = newVal;
        }
        {
            recFldVal = rec.GetFieldValue(this._id);
            let oldNullVal = this._isNull;
            if (!recompute && !isArgUpdate && this._initExp == null)
                oldNullVal = rec.IsNull(this._id);
            try {
                valsEqual = ExpressionEvaluator.mgValsEqual(this._val, isNullFld, this._type, recFldVal, oldNullVal, this._type);
            }
            catch (exception) {
                this._val = this.getMagicDefaultValue();
                valsEqual = false;
            }
        }
        if (this._clearVectorType)
            this._vectorType = null;
        if (this._invalidValue) {
            this._invalidValue = false;
            rec.clearFlag(this._id, Record.FLAG_UPDATED);
            rec.clearFlag(this._id, Record.FLAG_MODIFIED);
        }
        zeroReal = this._linkCreate && rec.InCompute && !recompute && (this._form == null || !this._form.InRestore) &&
            !AccessHelper.eventsManager.GetStopExecutionFlag();
        if ((this._isVirtual || zeroReal) && !rec.isNewRec() && !valsEqual)
            forceUpdate = true;
        if (checkForVariableChange || forceUpdate || rec.isNewRec()) {
            this.UpdateNull(isNullFld, rec);
            if (setCrsrModified)
                rec.setFlag(this._id, Record.FLAG_CRSR_MODIFIED);
            rec.setFieldValue(this._id, this._val, setRecordModified);
            evts = Field._variableChangeEvts;
            pendingEvents = evts.length;
            if (checkForVariableChange && this.getHasChangeEvent() && !evts.Contains(this) && !valsEqual) {
                let rtEvt = new RunTimeEvent(this);
                rtEvt.setInternal(InternalInterface.MG_ACT_VARIABLE);
                rtEvt.setArgList(args);
                evts.push(this);
                evts.push(rtEvt);
            }
            if (this._recompute != null && (recompute || forceUpdate) && !this._dataview.InLocalDataviewCommand) {
                try {
                    if (forceUpdate)
                        rec.InForceUpdate = true;
                    await this._recompute.execute(rec);
                }
                finally {
                    if (forceUpdate)
                        rec.InForceUpdate = false;
                }
            }
            if (this._causeTableInvalidation && this.isChanged(this._val, isNullFld))
                rec.setCauseInvalidation(true);
            if ((recompute || forceUpdate) && !this._dataview.InLocalDataviewCommand && mainCtrl != null) {
                if (mainCtrl.isChoiceControl())
                    await this.updateDisplay();
            }
            if (pendingEvents === 0 && checkForVariableChange && this.getHasChangeEvent()) {
                while (evts.length > 0) {
                    let evt = evts.get_Item(1);
                    evts.RemoveAt(0);
                    evts.RemoveAt(0);
                    if (LastFocusedManager.Instance.getLastFocusedTask() == null)
                        evt.setTask(this.getTask());
                    else {
                        let taskRef = LastFocusedManager.Instance.getLastFocusedTask();
                        if (taskRef.TaskSuffixExecuted) {
                            taskRef = (taskRef.PathParentTask != null) ? taskRef.PathParentTask : taskRef;
                        }
                        evt.setTask(taskRef);
                    }
                    evt.setCtrl(LastFocusedManager.getLastFocusedControl());
                    await AccessHelper.eventsManager.handleEvent(evt, false);
                }
            }
        }
        if (recompute && !valsEqual)
            this.setModified();
        return !valsEqual;
    }
    UpdateNull(isNullFld, rec) {
        if (isNullFld)
            rec.setFlag(this._id, Record.FLAG_NULL);
        else
            rec.clearFlag(this._id, Record.FLAG_NULL);
        this._isNull = isNullFld;
    }
    async setCellVecValue(idx, newVal, valIsNull) {
        let res = false;
        if (this._type === StorageAttribute.BLOB_VECTOR) {
            if (this._vectorType == null) {
                this._vectorType = this.isNull()
                    ? new VectorType(this._vecCellsType, this._vecCellsContentType, this.DefaultValue, this.isNullDefault(), this.NullAllowed, this._vecCellsSize)
                    : new VectorType(this._val);
            }
            if (this._vecCellsType === StorageAttribute.BLOB) {
                let tmpNewVal = this.getCellDefualtValue();
                newVal = BlobType.copyBlob(tmpNewVal, newVal);
            }
            res = this._vectorType.setVecCell(idx, newVal, valIsNull);
            if (res) {
                this._clearVectorType = false;
                await this.setValueAndStartRecompute(this._vectorType.toString(), false, true, false, false);
                this._clearVectorType = true;
            }
        }
        return res;
    }
    getVecCellValue(idx) {
        if (this._type === StorageAttribute.BLOB_VECTOR) {
            if (this._vectorType == null)
                this._vectorType = new VectorType(this._val);
            return this._vectorType.getVecCell(idx);
        }
        return null;
    }
    setRecomputed() {
    }
    invalidate(forceInvalidate, clearFlags) {
        let rec = this._dataview.getCurrRec();
        if (!this._isVirtual || this._virAsReal || this._initExp !== null || forceInvalidate) {
            this._invalidValue = true;
        }
        if (clearFlags && rec !== null) {
            rec.clearFlag(this._id, Record.FLAG_UPDATED);
            rec.clearFlag(this._id, Record.FLAG_MODIFIED);
        }
    }
    getTableName() {
        if (this._tableName == null)
            return "";
        return this._tableName;
    }
    getName() {
        if (this._isParam)
            return "Parameter." + this.getVarName();
        else if (this._isVirtual)
            return "Virtual." + this.getVarName();
        else
            return this.getTableName() + "." + this.getVarName();
    }
    isNull() {
        if (super.getTask().getEvalOldValues())
            return this.isOriginalValueNull();
        else if (this._invalidValue)
            this.takeValFromRec();
        return this._isNull;
    }
    PrevIsNull() {
        return this._prevIsNull;
    }
    isModified() {
        let currRec = this._dataview.getCurrRec();
        return currRec.isFldModified(this._id);
    }
    setModified() {
        let rec = (this._dataview.getCurrRec());
        rec.setFlag(this._id, Record.FLAG_MODIFIED);
        rec.setFlag(this._id, Record.FLAG_MODIFIED_ATLEAST_ONCE);
        if (this.IsVirtual)
            this.modifiedAtLeastOnce = true;
    }
    setUpdated() {
        let currRec = this._dataview.getCurrRec();
        currRec.setFlag(this._id, Record.FLAG_UPDATED);
        currRec.setUpdated();
    }
    isParam() {
        return this._isParam;
    }
    isInEvalProcess() {
        return this._inEvalProcess;
    }
    hasInitExp() {
        return this._initExp !== null;
    }
    isServerRcmp() {
        return this._recompute !== null && this._recompute.isServerRcmp();
    }
    getPicture() {
        return this._picture;
    }
    getDataviewHeaderId() {
        return this._dataviewHeaderId;
    }
    get IsLinkField() {
        return this._isLinkFld;
    }
    async getInitExpVal(res, isNull) {
        if (this._initExp != null)
            await this.EvaluateInitExpression(res, isNull);
        else
            res.value = this.getDefaultValue();
    }
    setHasChangeEvent() {
        this._hasChangeEvent = true;
    }
    getHasChangeEvent() {
        return this._hasChangeEvent;
    }
    setHasZoomHandler() {
        this._hasZoomHandler = true;
    }
    getHasZoomHandler() {
        return this._hasZoomHandler;
    }
    isCauseTableInvalidation() {
        return this._causeTableInvalidation;
    }
    causeTableInvalidation(causeTableInvalidation) {
        this._causeTableInvalidation = causeTableInvalidation;
    }
    getValueForNull(checkNullArithmetic) {
        let val;
        if (this.NullAllowed) {
            if (checkNullArithmetic && super.getTask().getNullArithmetic() === Constants.NULL_ARITH_NULLIFY) {
                val = null;
            }
            else {
                if (this._nullValue === null) {
                    this._nullValue = super.getMagicDefaultValue();
                }
                val = this._nullValue;
            }
        }
        else {
            val = super.getMagicDefaultValue();
        }
        return val;
    }
    getCtrl() {
        let ctrl;
        if (this._controls != null) {
            for (let i = 0; i < this._controls.length; i++) {
                ctrl = this._controls.get_Item(i);
                if (ctrl.getForm().getTask() === this.getTask())
                    return ctrl;
            }
        }
        return null;
    }
    async updateDisplay() {
        await super.updateDisplayWithValue(this.getDispValue(), this.isNull());
    }
    getDispValue() {
        if (this.isNull()) {
            if (this._nullDisplay != null)
                return this.getNullDisplay();
            else
                return super.getMagicDefaultValue();
        }
        else
            return this.getValue(false);
    }
    get ShouldCheckRangeInCompute() {
        return this.IsLinkField || (this.IsVirtual && this._dataview.HasMainTable);
    }
    IsForArgument(taskHasParameters) {
        if (taskHasParameters) {
            if (!this.isParam()) {
                return false;
            }
        }
        else {
            if (!this.IsVirtual) {
                return false;
            }
        }
        return true;
    }
}
Field.LEAVE_FLAGS = false;
Field.NUM0 = null;
Field.NUM1 = null;
Field._variableChangeEvts = new List();

class FieldsTable extends FieldsTable$1 {
    constructor() {
        super();
        this._rmIdx = 0;
        this._rmSize = -1;
        this._serverRcmpDone = false;
    }
    fillData(parser, dataview) {
        if (arguments.length === 2)
            super.fillData(parser, dataview);
        else {
            while (this.initFields(parser.getNextTag(), parser)) {
            }
        }
    }
    initFields(foundTagName, parser) {
        if (foundTagName == null)
            return false;
        if (foundTagName === XMLConstants.MG_TAG_FLDH) {
            let item = this.initField(parser);
            this._fields.push(item);
        }
        else {
            return false;
        }
        return true;
    }
    initField(parser, dataview) {
        if (arguments.length === 2)
            return this.initField_0(dataview, parser);
        else
            return this.initField_1(parser);
    }
    initField_0(dataview, parser) {
        let field = new Field(dataview, this._fields.length);
        field.fillData(parser);
        return field;
    }
    initField_1(parser) {
        let fieldDef = new FieldDef(this._fields.length);
        fieldDef.fillData(parser);
        return fieldDef;
    }
    getRMSize() {
        if (this._rmSize === -1)
            return this._fields.length;
        return this._rmSize;
    }
    getRMIdx() {
        return this._rmIdx;
    }
    setRMPos(rms, idx) {
        if (rms < 0 && this._rmSize !== -1) {
            Logger.Instance.WriteExceptionToLogWithMsg("in FieldsTable.setRMSize(): illegal record main size: " + rms);
        }
        else if (this._rmSize >= 0) {
            Logger.Instance.WriteExceptionToLogWithMsg("in FieldsTable.setRMSize(): record main size already set !");
        }
        else {
            this._rmSize = rms;
            this._rmIdx = idx;
        }
    }
    getType(id) {
        return super.getField(id).getType();
    }
    invalidate(forceInvalidate, clearFlags) {
        for (let i = 0; i < this._fields.length; i++) {
            let currField = this._fields[i];
            currField.invalidate(forceInvalidate, clearFlags);
        }
    }
    takeValsFromRec() {
        for (let i = 0; i < this._fields.length; i++) {
            let currField = this._fields[i];
            currField.takeValFromRec();
        }
    }
    serverRcmpDone() {
        return this._serverRcmpDone;
    }
    setServerRcmp(val) {
        this._serverRcmpDone = val;
    }
    getLinkFields(lnkId) {
        let list = new List();
        this._fields.forEach(field => {
            if (field.getDataviewHeaderId() === lnkId) {
                list.push(field);
            }
        });
        return list;
    }
    resetRecomp() {
        this._fields.forEach(field => field.setRecompute(null));
    }
}

var RecordOutOfDataViewException_ExceptionType;
(function (RecordOutOfDataViewException_ExceptionType) {
    RecordOutOfDataViewException_ExceptionType[RecordOutOfDataViewException_ExceptionType["TOP"] = 0] = "TOP";
    RecordOutOfDataViewException_ExceptionType[RecordOutOfDataViewException_ExceptionType["BOTTOM"] = 1] = "BOTTOM";
    RecordOutOfDataViewException_ExceptionType[RecordOutOfDataViewException_ExceptionType["REC_SUFFIX_FAILED"] = 2] = "REC_SUFFIX_FAILED";
    RecordOutOfDataViewException_ExceptionType[RecordOutOfDataViewException_ExceptionType["NONE"] = 3] = "NONE";
})(RecordOutOfDataViewException_ExceptionType || (RecordOutOfDataViewException_ExceptionType = {}));
class RecordOutOfDataViewException extends ApplicationException {
    constructor(type) {
        super((type === RecordOutOfDataViewException_ExceptionType.REC_SUFFIX_FAILED) ? "Record Suffix Failed" :
            ("Record out of the " + ((type === RecordOutOfDataViewException_ExceptionType.TOP) ? "top" : "bottom") + " bound of the Data View"));
        this.name = "RecordOutOfDataViewException";
    }
}

class XMLBasedDcValuesBuilder extends DcValuesBuilderBase {
    set SerializedDCVals(value) {
        this.parser.setXMLdata(value);
        this.parser.setCurrIndex(0);
    }
    constructor() {
        super();
        this.dcv = null;
        this.parser = null;
        this.parser = new XmlParser();
    }
    Build() {
        this.dcv = null;
        let endContext = this.parser.getXMLdata().indexOf(XMLConstants.TAG_TERM, this.parser.getCurrIndex());
        if (endContext !== -1 && endContext < this.parser.getXMLdata().length) {
            let tag = this.parser.getXMLsubstring(endContext);
            this.parser.add2CurrIndex(tag.indexOf(ConstInterface.MG_TAG_DC_VALS) + ConstInterface.MG_TAG_DC_VALS.length);
            let tokensVector = XmlParser.getTokens(this.parser.getXMLsubstring(endContext), XMLConstants.XML_ATTR_DELIM);
            this.dcv = this.CreateDcValues();
            this.InitDCValues(this.dcv, tokensVector);
        }
        return this.dcv;
    }
    InitDCValues(dcv, tokensVector) {
        let type = StorageAttribute.NONE;
        let displayValues = null;
        let serializedLinkValues = null;
        for (let j = 0; j < tokensVector.length; j += 2) {
            let attribute = (tokensVector.get_Item(j));
            let valueStr = (tokensVector.get_Item(j + 1));
            switch (attribute) {
                case XMLConstants.MG_ATTR_ID:
                    this.SetId(dcv, XmlParser.getInt(valueStr));
                    break;
                case XMLConstants.MG_ATTR_TYPE:
                    type = valueStr[0];
                    this.SetType(dcv, type);
                    break;
                case ConstInterface.MG_ATTR_DISP:
                    valueStr = XmlParser.unescape(valueStr);
                    displayValues = this.ParseValues(valueStr, StorageAttribute.UNICODE);
                    break;
                case ConstInterface.MG_ATTR_LINKED:
                    valueStr = XmlParser.unescape(valueStr);
                    serializedLinkValues = valueStr;
                    break;
                case ConstInterface.MG_ATTR_NULL_FLAGS:
                    this.SetNullFlags(dcv, valueStr);
                    break;
                default:
                    Logger.Instance.WriteExceptionToLogWithMsg("in DcValues.initElements() unknown attribute: " + attribute);
                    break;
            }
        }
        this.SetDisplayValues(dcv, displayValues);
        if (serializedLinkValues == null)
            this.SetLinkValues(dcv, displayValues);
        else
            this.SetLinkValues(dcv, this.ParseValues(serializedLinkValues, type));
    }
    ParseValues(valueStr, dataType) {
        let useHex = false;
        if (Environment.Instance.GetDebugLevel() > 1 ||
            dataType === StorageAttribute.ALPHA || dataType === StorageAttribute.UNICODE || dataType === StorageAttribute.BOOLEAN) {
            useHex = true;
        }
        return super.ParseValues(valueStr, dataType, useHex);
    }
}

const SET_DISPLAYLINE_BY_DV = Int32.MinValue;
const COMPUTE_NEWREC_ON_CLIENT = 'C';
const UNKNOWN_RCMPS_NOT_INITED = 'M';
const UNKNOWN_RCMPS_FOUND = 'Y';
const INVOKED_FROM_OFFLINE_TASK = '-99999';
const CHUNK_CACHE_NEXT = 'N';
const CHUNK_CACHE_PREV = 'P';
const CHUNK_DV_BOTTOM = 'B';
const CHUNK_DV_TOP = 'T';
const COMPUTE_FLUSH_UPDATES = 'H';
const COMPUTE_NEWREC_ON_SERVER = 'S';
const END_DV_TAG = '</' + ConstInterface.MG_TAG_DATAVIEW + '>';
const RECOVERY_ACT_BEGIN_SCREEN = 'S';
const RECOVERY_ACT_BEGIN_TABLE = 'T';
const RECOVERY_ACT_CANCEL = 'C';
const RECOVERY_ACT_MOVE_DIRECTION_BEGIN = 'B';
const RECOVERY_ACT_NONE = 'N';
const TRANS_STAT_CLOSED = 'C';
const TRANS_STAT_OPENED = 'O';
class DataView extends DataViewBase {
    set InsertAt(value) {
        this._insertAt = value;
    }
    get InsertAt() {
        return this._insertAt;
    }
    get CurrRec() {
        return this._currRec_DO_NOT_USE_DIRECTLY_USE_SETTER_GETTER;
    }
    set CurrRec(value) {
        if (this._currRec_DO_NOT_USE_DIRECTLY_USE_SETTER_GETTER !== null && value === null) {
            this._currRec_DO_NOT_USE_DIRECTLY_USE_SETTER_GETTER.resetDcValueId();
        }
        this._currRec_DO_NOT_USE_DIRECTLY_USE_SETTER_GETTER = value;
        if (this._currRec_DO_NOT_USE_DIRECTLY_USE_SETTER_GETTER !== null) {
            this._currRec_DO_NOT_USE_DIRECTLY_USE_SETTER_GETTER.SetDcValueId();
        }
    }
    get FlushUpdates() {
        return this._flushUpdates;
    }
    get HasMainTable() {
        return this._hasMainTable;
    }
    get CurrentRecId() {
        return this._currRecId;
    }
    get FirstRecord() {
        return this._recordsTab.getRecByIdx(0);
    }
    get LastRecord() {
        return this._recordsTab.getRecByIdx(this._recordsTab.getSize() - 1);
    }
    constructor(taskOrDataView) {
        super();
        this._cacheLruTimeStamp = 0;
        this._changed = false;
        this._chunkSize = 30;
        this._computeBy = '\0';
        this._currRecId = 0;
        this._currRecIdx = 0;
        this._dvPosValue = 0;
        this._firstDv = true;
        this._flushUpdates = false;
        this._hasMainTable = true;
        this._insertAt = ' ';
        this.InLocalDataviewCommand = false;
        this._lastCreatedRecId = 0;
        this._lastSessionCounter = Int64.MinValue;
        this._locateFirstRec = -1;
        this._modifiedRecordsTab = null;
        this._oldTopRecIdx = Int32.MinValue;
        this._original = null;
        this._pendingRecovery = RECOVERY_ACT_NONE;
        this._prevCurrRec = null;
        this._recordsTab = null;
        this._recovery = ConstInterface.RECOVERY_NONE;
        this._rmIdx = 0;
        this._rmSize = 0;
        this._skipParsing = false;
        this._topRecId = 0;
        this._topRecIdx = Int32.MinValue;
        this._topRecIdxModified = false;
        this._transCleared = false;
        this._unknownRcmp = UNKNOWN_RCMPS_NOT_INITED;
        this.IsOneWayKey = false;
        this._includesFirst = false;
        this._includesLast = false;
        this._serverTransCacheEmpty = true;
        this._currRec_DO_NOT_USE_DIRECTLY_USE_SETTER_GETTER = null;
        this.DBViewSize = 0;
        this.Dvcount = 0;
        this.TotalRecordsCount = 0;
        this.RecordsBeforeCurrentView = 0;
        if (taskOrDataView instanceof TaskBase) {
            this._task = taskOrDataView;
            this._fieldsTab = new FieldsTable();
            this._recordsTab = new RecordsTable(true);
            this._modifiedRecordsTab = new RecordsTable(false);
        }
        else {
            Object.assign(this, taskOrDataView);
        }
    }
    Init() {
        this.init();
    }
    IncludesFirst() {
        return this._includesFirst;
    }
    get ServerTransactionCacheEmpty() {
        return this._serverTransCacheEmpty;
    }
    IncludesLast() {
        return this._includesLast;
    }
    fillHeaderData(parser) {
        while (this.initHeaderInnerObjects(parser, parser.getNextTag())) {
        }
        this.Dvcount = this._task.ctl_itm_4_parent_vee(0, 1);
    }
    initHeaderInnerObjects(parser, foundTagName) {
        if (foundTagName === null)
            return false;
        if (foundTagName === XMLConstants.MG_TAG_DVHEADER) {
            Logger.Instance.WriteDevToLog('dvheader found');
            this.getHeaderAttributes(parser);
            this._fieldsTab.fillData(parser, this);
            this._fieldsTab.setRMPos(this._rmSize, this._rmIdx);
        }
        else if (foundTagName === ('/' + XMLConstants.MG_TAG_DVHEADER)) {
            parser.setCurrIndex2EndOfTag();
            return false;
        }
        else
            return false;
        return true;
    }
    getHeaderAttributes(parser) {
        let tokensVector;
        let tag;
        let attribute;
        let valueStr;
        let endContext = parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex());
        if (endContext !== -1 && endContext < parser.getXMLdata().length) {
            tag = parser.getXMLsubstring(endContext);
            parser.add2CurrIndex(tag.indexOf(XMLConstants.MG_TAG_DVHEADER) + XMLConstants.MG_TAG_DVHEADER.length);
            tokensVector = XmlParser.getTokens(parser.getXMLsubstring(endContext), XMLConstants.XML_ATTR_DELIM);
            for (let j = 0; j < tokensVector.length; j += 2) {
                attribute = (tokensVector.get_Item(j));
                valueStr = (tokensVector.get_Item(j + 1));
                switch (attribute) {
                    case ConstInterface.MG_ATTR_RMPOS: {
                        let i = valueStr.indexOf(',');
                        if (i > -1) {
                            this._rmSize = NNumber.Parse(valueStr.substr(0, i));
                            this._rmIdx = NNumber.Parse(valueStr.substr(i + 1));
                        }
                        break;
                    }
                    case ConstInterface.MG_ATTR_COMPUTE_BY:
                        this._computeBy = valueStr[0];
                        if (this._computeBy === COMPUTE_FLUSH_UPDATES) {
                            this._computeBy = COMPUTE_NEWREC_ON_SERVER;
                            this._flushUpdates = true;
                        }
                        else
                            this._flushUpdates = false;
                        break;
                    case ConstInterface.MG_ATTR_HAS_MAIN_TBL:
                        this._hasMainTable = XmlParser.getBoolean(valueStr);
                        break;
                    case ConstInterface.MG_ATTR_CHUNK_SIZE:
                        this._chunkSize = XmlParser.getInt(valueStr);
                        break;
                    case ConstInterface.MG_ATTR_CHUNK_SIZE_EXPRESSION:
                        break;
                    default:
                        Logger.Instance.WriteExceptionToLogWithMsg('Unknown attribute for <' + XMLConstants.MG_TAG_DVHEADER + '> tag: ' +
                            attribute);
                        break;
                }
            }
            parser.setCurrIndex(++endContext);
            return;
        }
        Logger.Instance.WriteExceptionToLogWithMsg('in DataView.getHeaderAttributes(): out of bounds');
    }
    async fillData(parser) {
        this._skipParsing = false;
        while (await this.initInnerObjects(parser, parser.getNextTag())) {
        }
        this.ResetFirstDv();
    }
    GetTransactionBegin() {
        let transBegin = '\0';
        let transBeginProp = this._task.getProp(PropInterface.PROP_TYPE_TRASACTION_BEGIN);
        if (transBeginProp !== null) {
            transBegin = (transBeginProp.GetComputedValue()).charAt(0);
        }
        return transBegin;
    }
    async initInnerObjects(parser, foundTagName) {
        let form = this._task.getForm();
        if (foundTagName == null)
            return false;
        if (foundTagName === (ConstInterface.MG_TAG_DATAVIEW)) {
            let invalidate = await this.getAttributes(parser);
            if (this._skipParsing) {
                let endContext = parser.getXMLdata().indexOf(END_DV_TAG, parser.getCurrIndex());
                parser.setCurrIndex(endContext + END_DV_TAG.length);
            }
            else {
                this.fillExecStack(parser);
                this.fillDataDc(parser);
                if (invalidate && form != null)
                    form.SetTableItemsCount(0, true);
                let taskRefreshType = this._recordsTab.fillData(this, this._insertAt, parser);
                if (form != null) {
                    if (form.Opened) {
                        if (this._insertAt === 'B' && (invalidate || this._recordsTab.InsertedRecordsCount > 0)) {
                            if (invalidate || !this._task.getForm().isTableWithPagination()) {
                                form.SetTableItemsCount(0, true);
                                form.setTableItemsCount(false);
                            }
                            else
                                form.InsertTableItems(0, this._recordsTab.InsertedRecordsCount);
                        }
                        else
                            form.setTableItemsCount(false);
                    }
                }
                if (this.CurrRec != null && this.CurrRec.InRecompute && taskRefreshType === Constants.TASK_REFRESH_NONE)
                    taskRefreshType = Constants.TASK_REFRESH_CURR_REC;
                if (invalidate) {
                    taskRefreshType = Constants.TASK_REFRESH_FORM;
                    if (this._task.IsSubForm)
                        this.getTask().DoSubformPrefixSuffix = true;
                }
                this.getTask().SetRefreshType(taskRefreshType);
                this.UpdateDataviewAfterInsert();
                let newRecId = this._recordsTab.getInitialCurrRecId();
                if (newRecId !== Int32.MinValue && (this._recovery === ConstInterface.RECOVERY_NONE || this._firstDv)) {
                    if (this._firstDv && this._recovery === ConstInterface.RECOVERY_NONE &&
                        (this._task.getLevel().charCodeAt(0) === 0 || this._task.getLevel() === Constants.TASK_LEVEL_TASK))
                        this._task.setLevel(Constants.TASK_LEVEL_TASK);
                    this._fieldsTab.invalidate(true, Field.LEAVE_FLAGS);
                    if (newRecId !== this._currRecId) {
                        await this.setCurrRec(newRecId, !this._firstDv);
                        this._original = this.CurrRec.replicate();
                        if (this._firstDv)
                            this.takeFldValsFromCurrRec();
                        if (this._task.getForm() != null)
                            (this._task.getForm()).updateDisplayLineByDV();
                    }
                    else
                        this.takeFldValsFromCurrRec();
                }
                else if (invalidate && this._recordsTab.getSize() > 0) {
                    if (form == null || form.isScreenMode()) {
                        try {
                            await this.setCurrRecByIdx(0, false, true, false, 0);
                        }
                        catch (exception) {
                            if (exception instanceof RecordOutOfDataViewException) {
                            }
                            else
                                throw exception;
                        }
                    }
                    else {
                        this._fieldsTab.invalidate(true, Field.LEAVE_FLAGS);
                        this.setTopRecIdx(0);
                        if (this._task.getForm() != null)
                            this._task.getForm().SetTableTopIndex();
                        try {
                            await this.setCurrRecByIdx(0, false, true, true, 0);
                            if (this._task.getForm() != null)
                                (this._task.getForm()).updateDisplayLineByDV();
                        }
                        catch (exception) {
                            if (exception instanceof RecordOutOfDataViewException) {
                            }
                            else
                                throw exception;
                        }
                        if (this._task.getLevel() === Constants.TASK_LEVEL_CONTROL && this._task.getLastParkedCtrl() != null)
                            this._task.getLastParkedCtrl().resetPrevVal();
                    }
                    this.saveOriginal();
                    this._fieldsTab.invalidate(true, FieldBase.CLEAR_FLAGS);
                }
                if (this._firstDv)
                    this.setPrevCurrRec();
                if (invalidate && this._task.IsSubForm)
                    this._task.getForm().getSubFormCtrl().RefreshOnVisible = false;
                if (this._recovery === ConstInterface.RECOVERY_NONE) {
                    if (this.getTask().getAfterRetry(ConstInterface.RECOVERY_RETRY) &&
                        !this.getTask().IsAfterRetryBeforeBuildXML)
                        this._task.setLevel(Constants.TASK_LEVEL_RECORD);
                }
                else {
                    let transBegin = this.GetTransactionBegin();
                    let stopExecution = true;
                    switch (this._recovery) {
                        case ConstInterface.RECOVERY_ROLLBACK:
                            if (transBegin === ConstInterface.TRANS_RECORD_PREFIX) {
                                if (this._task.getMode() === Constants.TASK_MODE_DELETE ||
                                    !this._task.IsInteractive)
                                    stopExecution = false;
                                else {
                                    this.getTask().setAfterRetry(ConstInterface.RECOVERY_ROLLBACK);
                                    this.CurrRec.restart(this.CurrRec.getMode());
                                    this.CurrRec.resetModified();
                                    this._original = this.CurrRec.replicate();
                                    this._pendingRecovery = RECOVERY_ACT_CANCEL;
                                }
                            }
                            else if (transBegin !== ConstInterface.TRANS_NONE) {
                                this._task.setLevel(Constants.TASK_LEVEL_TASK);
                                this._pendingRecovery = RECOVERY_ACT_BEGIN_TABLE;
                                this.getTask().setAfterRetry(ConstInterface.RECOVERY_ROLLBACK);
                            }
                            break;
                        case ConstInterface.RECOVERY_RETRY:
                            this.RecoveryRetry(transBegin);
                            break;
                    }
                    if (stopExecution) {
                        AccessHelper.eventsManager.setStopExecution(true);
                        this.getTask().TaskSuffixExecuted = false;
                    }
                }
            }
        }
        else if (foundTagName === '/' + ConstInterface.MG_TAG_DATAVIEW) {
            if (this._includesFirst && this._includesLast && this.isEmpty()) {
                this._currRecId = Int32.MinValue;
                this._currRecIdx = Int32.MinValue;
                this.CurrRec = null;
                this.setTopRecIdx(Int32.MinValue);
            }
            parser.setCurrIndex2EndOfTag();
            return false;
        }
        else
            return false;
        return true;
    }
    RecoveryRetry(transBegin) {
        if (transBegin === ConstInterface.TRANS_RECORD_PREFIX) {
            this._task.setLevel(Constants.TASK_LEVEL_RECORD);
            this.getTask().setTransactionFailed(true);
            this.getTask().setAfterRetry(ConstInterface.RECOVERY_RETRY);
            this.CurrRec.restart(this.CurrRec.getMode());
            if (!this._firstDv) {
                this.takeFldValsFromCurrRec();
                this._pendingRecovery = RECOVERY_ACT_MOVE_DIRECTION_BEGIN;
            }
        }
        else if (transBegin !== ConstInterface.TRANS_NONE) {
            this._task.setLevel(Constants.TASK_LEVEL_TASK);
            this._pendingRecovery = RECOVERY_ACT_BEGIN_SCREEN;
            this.getTask().setAfterRetry(ConstInterface.RECOVERY_RETRY);
            this.getTask().setTransactionFailed(true);
        }
    }
    UpdateDataviewAfterInsert() {
        if (this._insertAt === 'B') {
            let newRecs = this._recordsTab.InsertedRecordsCount;
            if (this._currRecIdx !== Int32.MinValue)
                this._currRecIdx += newRecs;
            if (this._topRecIdx !== Int32.MinValue)
                this._topRecIdx += newRecs;
            if (this._oldTopRecIdx !== Int32.MinValue)
                this._oldTopRecIdx += newRecs;
        }
    }
    async getAttributes(parser) {
        let tokensVector;
        let tag;
        let boolVal;
        let dataViewCommand = null;
        let isEmptyDataview = false;
        this._recovery = ConstInterface.RECOVERY_NONE;
        let endContext = parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex());
        if (endContext !== -1 && endContext < parser.getXMLdata().length) {
            tag = parser.getXMLsubstring(endContext);
            parser.add2CurrIndex(tag.indexOf(ConstInterface.MG_TAG_DATAVIEW) + ConstInterface.MG_TAG_DATAVIEW.length);
            tokensVector = XmlParser.getTokens(parser.getXMLsubstring(endContext), XMLConstants.XML_ATTR_DELIM);
            this._insertAt = ' ';
            let invalidate = this.peekInvalidate(tokensVector);
            this._locateFirstRec = 0;
            for (let j = 0; j < tokensVector.length; j += 2) {
                let attribute = (tokensVector.get_Item(j));
                let valueStr = (tokensVector.get_Item(j + 1));
                switch (attribute) {
                    case ConstInterface.MG_ATTR_INSERT_AT:
                        this._insertAt = valueStr[0];
                        break;
                    case ConstInterface.MG_ATTR_INCLUDE_FIRST:
                        boolVal = XmlParser.getBoolean(valueStr);
                        this.SetIncludesFirst(boolVal);
                        break;
                    case ConstInterface.MG_ATTR_INCLUDE_LAST:
                        boolVal = XmlParser.getBoolean(valueStr);
                        this.SetIncludesLast(boolVal);
                        break;
                    case ConstInterface.MG_ATTR_IS_ONEWAY_KEY:
                        boolVal = XmlParser.getBoolean(valueStr);
                        this.SetOneWayKey(boolVal);
                        break;
                    case ConstInterface.MG_ATTR_DBVIEWSIZE:
                        this.DBViewSize = XmlParser.getInt(valueStr);
                        break;
                    case ConstInterface.MG_ATTR_INVALIDATE:
                        {
                        }
                        break;
                    case ConstInterface.MG_ATTR_TOP_REC_ID:
                        this._topRecId = NNumber.Parse(valueStr);
                        break;
                    case ConstInterface.MG_ATTR_TASKMODE:
                        if (this._task.getOriginalTaskMode() === Constants.TASK_MODE_NONE || invalidate)
                            this._task.setOriginalTaskMode(valueStr);
                        this._task.setProp(PropInterface.PROP_TYPE_TASK_MODE, valueStr);
                        break;
                    case ConstInterface.MG_ATTR_EMPTY_DATAVIEW:
                        isEmptyDataview = true;
                        break;
                    case XMLConstants.MG_ATTR_TASKID:
                        continue;
                    case ConstInterface.MG_ATTR_LOW_ID:
                        this._lastCreatedRecId = NNumber.Parse(valueStr);
                        break;
                    case ConstInterface.MG_ATTR_TRANS_STAT:
                        let transStat = valueStr[0];
                        switch (transStat) {
                            case TRANS_STAT_OPENED:
                                dataViewCommand = CommandFactory.CreateSetTransactionStateDataviewCommand(this.getTask().getTaskTag(), true);
                                await this.getTask().DataviewManager.RemoteDataviewManager.Execute(dataViewCommand);
                                break;
                            case TRANS_STAT_CLOSED:
                                dataViewCommand = CommandFactory.CreateSetTransactionStateDataviewCommand(this.getTask().getTaskTag(), false);
                                await this.getTask().DataviewManager.RemoteDataviewManager.Execute(dataViewCommand);
                                this.getTask().setTransactionFailed(false);
                                break;
                            default:
                                break;
                        }
                        break;
                    case ConstInterface.MG_ATTR_RECOVERY:
                        if (this._task.IsTryingToStop)
                            this.getTask().setTryingToStop(false);
                        this.getTask().resetExecEndTask();
                        this._recovery = valueStr[0];
                        break;
                    case ConstInterface.MG_ATTR_DVPOS_VALUE:
                        this._dvPosValue = NNumber.Parse(valueStr);
                        break;
                    case ConstInterface.MG_ATTR_LOCATE_FIRST_ID:
                        this._locateFirstRec = NNumber.Parse(valueStr);
                        break;
                    case ConstInterface.MG_ATTR_OFFSET:
                        break;
                    case ConstInterface.MG_ATTR_USER_SORT:
                        let form = this._task.getForm();
                        form.clearTableColumnSortMark(XmlParser.getBoolean(valueStr));
                        break;
                    case ConstInterface.MG_ATTR_VAL_TOTAL_RECORDS_COUNT:
                        this.TotalRecordsCount = XmlParser.getInt(valueStr);
                        break;
                    case ConstInterface.MG_ATTR_VAL_RECORDS_BEFORE_CURRENT_VIEW:
                        this.RecordsBeforeCurrentView = XmlParser.getInt(valueStr);
                        break;
                    case ConstInterface.MG_ATTR_VAL_SERVER_TRANS_CACHE_EMPTY:
                        this._serverTransCacheEmpty = XmlParser.getBoolean(valueStr);
                        break;
                    default:
                        Logger.Instance.WriteExceptionToLogWithMsg('Unknown attribute for <' + ConstInterface.MG_TAG_DATAVIEW + '> tag: ' + attribute);
                        break;
                }
            }
            this.setEmptyDataview(isEmptyDataview);
            parser.setCurrIndex(++endContext);
            return invalidate;
        }
        Logger.Instance.WriteExceptionToLogWithMsg('in DataView.getAttributes(): out of bounds');
        return false;
    }
    SetOneWayKey(val) {
        this.IsOneWayKey = val;
    }
    SetIncludesLast(val) {
        this._includesLast = val;
    }
    SetIncludesFirst(val) {
        let prevIncludeFirst = this._includesFirst;
        this._includesFirst = val;
        if (this._includesFirst !== prevIncludeFirst) {
            let form = this._task.getForm();
            if (form !== null) {
                form.SetTableItemsCount(0, true);
            }
        }
    }
    fillDataDc(parser) {
        let dcvBuilder = new XMLBasedDcValuesBuilder();
        let foundTagName = parser.getNextTag();
        while (foundTagName !== null && foundTagName === ConstInterface.MG_TAG_DC_VALS) {
            let dcValsPosition = parser.getCurrIndex();
            dcvBuilder.SerializedDCVals = parser.ReadToEndOfCurrentElement();
            let dcv = dcvBuilder.Build();
            if (dcv !== null)
                this.AddDcValues(dcv);
            else
                Logger.Instance.WriteExceptionToLogWithMsg('Error while parsing DC values at position ' + dcValsPosition);
            foundTagName = parser.getNextTag();
        }
    }
    AddDcValues(dcv) {
        this._dcValsCollection.Add(dcv.getId().toString(), dcv);
    }
    fillExecStack(parser) {
        let foundTagName = parser.getNextTag();
        let execStackTagExists = false;
        while (foundTagName !== null && foundTagName === ConstInterface.MG_TAG_EXEC_STACK_ENTRY) {
            this.fillInnerExecStack(parser);
            foundTagName = parser.getNextTag();
            execStackTagExists = true;
        }
        if (execStackTagExists) {
            AccessHelper.eventsManager.reverseServerExecStack();
        }
    }
    fillInnerExecStack(parser) {
        let tokensVector;
        const endContext = parser.getXMLdata().indexOf(XMLConstants.TAG_TERM, parser.getCurrIndex());
        let attribute;
        let taskId = '';
        let handlerId = '';
        let operIdx = 0;
        if (endContext !== -1 && endContext < parser.getXMLdata().length) {
            let tag = parser.getXMLsubstring(endContext);
            parser.add2CurrIndex(tag.indexOf(ConstInterface.MG_TAG_EXEC_STACK_ENTRY) + ConstInterface.MG_TAG_EXEC_STACK_ENTRY.length);
            tokensVector = XmlParser.getTokens(parser.getXMLsubstring(endContext), XMLConstants.XML_ATTR_DELIM);
            for (let j = 0; j < tokensVector.length; j += 2) {
                attribute = (tokensVector.get_Item(j));
                let valueStr = (tokensVector.get_Item(j + 1));
                switch (attribute) {
                    case XMLConstants.MG_ATTR_TASKID:
                        taskId = valueStr;
                        break;
                    case ConstInterface.MG_ATTR_HANDLERID:
                        handlerId = valueStr;
                        break;
                    case ConstInterface.MG_ATTR_OPER_IDX:
                        operIdx = XmlParser.getInt(valueStr);
                        break;
                }
            }
            AccessHelper.eventsManager.pushServerExecStack(taskId, handlerId, operIdx);
            parser.setCurrIndex(endContext + XMLConstants.TAG_TERM.length);
        }
        else
            Logger.Instance.WriteExceptionToLogWithMsg('in DataView.fillInnerExecStack() out of bounds');
    }
    peekInvalidate(tokensVector) {
        let sessionCounter = CommandsProcessorManager.GetCommandsProcessor().GetSessionCounter();
        for (let j = 0; j < tokensVector.length; j += 2) {
            let attribute = tokensVector.get_Item(j);
            if (attribute === (ConstInterface.MG_ATTR_INVALIDATE)) {
                let valueStr = tokensVector.get_Item(j + 1);
                if (XmlParser.getBoolean(valueStr)) {
                    if (sessionCounter < this._lastSessionCounter)
                        this._skipParsing = true;
                    else {
                        this._lastSessionCounter = sessionCounter;
                        this.clear();
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }
    getFieldByName(fldName) {
        if (this._fieldsTab !== null)
            return this._fieldsTab.getField(fldName);
        Logger.Instance.WriteExceptionToLogWithMsg('in DataView.getField(String): There is no fieldsTab object');
        return null;
    }
    async buildXML(message) {
        let dcv;
        let taskTag = this._task.getTaskTag();
        let brkLevelIndex = this._task.getBrkLevelIndex();
        let currRecDeleted = false;
        let serverParent;
        let contextTask = (this.getTask().GetContextTask());
        let invokingTaskTag = contextTask.IsOffline ? INVOKED_FROM_OFFLINE_TASK : contextTask.getTaskTag();
        message.Append('\n      <' + ConstInterface.MG_TAG_DATAVIEW + ' ' + XMLConstants.MG_ATTR_TASKID + '="' +
            taskTag + '"');
        message.Append(' ' + ConstInterface.MG_ATTR_TASKLEVEL + '="' + brkLevelIndex + '"');
        serverParent = '0';
        let triggeringTask = this.getTask().getTriggeringTask();
        if (triggeringTask != null) {
            if (triggeringTask.IsOffline) {
                let ctlIdx = triggeringTask.getCtlIdx();
                let mainPrg = AccessHelper.mgDataTable.GetMainProgByCtlIdx(-1, ctlIdx);
                serverParent = mainPrg.getTaskTag();
            }
            else
                serverParent = triggeringTask.getTaskTag();
        }
        if (this._currRecId > Int32.MinValue) {
            if (this.CurrRec != null)
                message.Append(' ' + ConstInterface.MG_ATTR_CURR_REC + '="' + this._currRecId + '"');
            message.Append(' ' + ConstInterface.MG_ATTR_TASKMODE + '="' + this._task.getMode() + '"');
            if (this._transCleared && !(MGDataCollection.Instance.StartupMgData.getFirstTask().InEndTask && MGDataCollection.Instance.StartupMgData.getFirstTask().ClosingFormUI)) {
                message.Append(' ' + ConstInterface.MG_ATTR_TRANS_CLEARED + '="1"');
                this._transCleared = false;
            }
            message.Append(' ' + ConstInterface.MG_ATTR_INVOKER_ID + '="' + invokingTaskTag + ',' + serverParent + '"');
            if (await this.getTask().isCached())
                message.Append(' ' + ConstInterface.MG_ATTR_DVPOS_VALUE + '="' + this._dvPosValue + '"');
            message.Append(' ' + ConstInterface.MG_ATTR_LOOP_COUNTER + '="' + this.getTask().getLoopCounter() + '"');
            if (this._task.IsSubForm) {
                let subformCtrl = this._task.getForm().getSubFormCtrl();
                if (!subformCtrl.isVisible() &&
                    !await subformCtrl.checkProp(PropInterface.PROP_TYPE_REFRESH_WHEN_HIDDEN, false))
                    message.Append(' ' + ConstInterface.MG_ATTR_SUBFORM_VISIBLE + '="0"');
            }
            if (!this._task.IsInteractive)
                message.Append(' ' + ConstInterface.MG_ATTR_TASK_COUNTER + '="' + this.getTask().getCounter() + '"');
            if (this._task != null && this._task.GetComputedProperty(PropInterface.PROP_TYPE_PRELOAD_VIEW).GetComputedValueBoolean()) {
                message.Append(' ' + ConstInterface.MG_ATTR_LAST_REC_ID + '="' +
                    (this._recordsTab.getRecByIdx(this.getSize() - 1).getId()) + '"');
                message.Append(' ' + ConstInterface.MG_ATTR_OLD_FIRST_REC_ID + '="' +
                    this._recordsTab.getRecByIdx(0).getId() + '"');
            }
            if (this._task.IsInteractive) {
                let form = this._task.getForm();
                if (form != null && this._recordsTab.getSize() > 1) {
                    message.Append(' ' + ConstInterface.MG_ATTR_CURR_REC_POS_IN_FORM + '="' +
                        form.getCurrRecPosInForm() + '"');
                }
            }
            message.Append(XMLConstants.TAG_CLOSE);
            if (this.getTask().ResetRange || this.getTask().UserRngs != null) {
                message.Append(XMLConstants.START_TAG + ConstInterface.USER_RANGES);
                if (this.getTask().ResetRange) {
                    message.Append(' ' + ConstInterface.CLEAR_RANGE + '="1"');
                    this.getTask().ResetRange = false;
                }
                if (this.getTask().UserRngs != null) {
                    this.getTask().buildXMLForRngs(message, this.getTask().UserRngs, false);
                    this.getTask().UserRngs.Clear();
                    this.getTask().UserRngs = null;
                }
                else
                    message.Append(XMLConstants.TAG_TERM);
            }
            if (this.getTask().ResetLocate || this.getTask().UserLocs != null) {
                message.Append(XMLConstants.START_TAG + ConstInterface.USER_LOCATES);
                if (this.getTask().ResetLocate) {
                    message.Append(' ' + ConstInterface.CLEAR_LOCATES + '="1"');
                    this.getTask().ResetLocate = false;
                }
                if (this.getTask().UserLocs != null) {
                    this.getTask().buildXMLForRngs(message, this.getTask().UserLocs, true);
                    this.getTask().UserLocs.Clear();
                    this.getTask().UserLocs = null;
                }
                else
                    message.Append(XMLConstants.TAG_TERM);
            }
            if (this.getTask().ResetSort || this.getTask().UserSorts != null) {
                message.Append(XMLConstants.START_TAG + ConstInterface.MG_TAG_SORTS);
                if (this.getTask().ResetSort) {
                    message.Append(' ' + ConstInterface.CLEAR_SORTS + '="1"');
                    this.getTask().ResetSort = false;
                }
                if (this.getTask().UserSorts != null)
                    this.getTask().buildXMLForSorts(message);
                else
                    message.Append(XMLConstants.TAG_TERM);
            }
            if (await this.getTask().isCached()) {
                let delList = this.getTask().getTaskCache().getDeletedListToXML();
                if (delList !== '') {
                    message.Append(XMLConstants.START_TAG + ConstInterface.MG_TAG_DEL_LIST);
                    message.Append(' ' + XMLConstants.MG_ATTR_ID + '="' + this._task.getTaskTag() + '"');
                    message.Append(' ' + ConstInterface.MG_ATTR_REMOVE + '="' + delList + '"');
                    message.Append(XMLConstants.TAG_TERM);
                    if (this.getTask().getTaskCache().isDeleted(this._dvPosValue))
                        this.setChanged(true);
                    this.getTask().getTaskCache().clearDeletedList();
                }
            }
            let dcValKeys = this._dcValsCollection.Keys;
            dcValKeys.forEach((dcValKey) => {
                dcv = this._dcValsCollection.get_Item(dcValKey);
                if (!dcv.HasReferences) {
                    message.Append(XMLConstants.START_TAG + ConstInterface.MG_TAG_DC_VALS);
                    message.Append(' ' + XMLConstants.MG_ATTR_ID + '="' + dcv.getId() + '"');
                    message.Append(' ' + ConstInterface.MG_ATTR_REMOVE + '="1"');
                    message.Append(XMLConstants.TAG_TERM);
                    this._dcValsCollection.Remove(dcValKey);
                }
            });
            if (this.CurrRec != null)
                currRecDeleted = (this.CurrRec.getMode() === DataModificationTypes.Delete
                    && this._modifiedRecordsTab.getRecord(this.CurrRec.getId()) != null && this.CurrRec.SendToServer);
            let skipCurrRec = false;
            if (this.CurrRec != null && this._modifiedRecordsTab.getRecord(this.CurrRec.getId()) != null)
                skipCurrRec = AccessHelper.eventsManager.isForceExitPreRecordUpdate(this.getTask());
            this._modifiedRecordsTab.buildXML(message, skipCurrRec, this.CurrRec.getId());
            if (this._original != null)
                this._original.clearMode();
            for (let i = this._modifiedRecordsTab.getSize() - 1; i >= 0; i--) {
                if (skipCurrRec && this._modifiedRecordsTab.getRecByIdx(i).getId() === this.CurrRec.getId())
                    continue;
                this._modifiedRecordsTab.getRecByIdx(i).clearFlagsHistory();
                this._modifiedRecordsTab.removeRecord(i);
            }
            if (this.CurrRec != null && !currRecDeleted) {
                let forceBuild = (this._task.isMainProg() && (RemoteCommandsProcessor.IsSessionReInitializing));
                this.CurrRec.buildXML(message, true, forceBuild);
            }
        }
        else {
            message.Append(' ' + ConstInterface.MG_ATTR_INVOKER_ID + '="' + invokingTaskTag + ',' + serverParent + '"' +
                XMLConstants.TAG_CLOSE);
        }
        message.Append('\n      </' + ConstInterface.MG_TAG_DATAVIEW + XMLConstants.TAG_CLOSE);
    }
    getCurrRec() {
        if (this.CurrRec === null && this._currRecId > Int32.MinValue) {
            Logger.Instance.WriteExceptionToLogWithMsg('DataView.getCurrRec(): record ' + this._currRecId + ' not found');
        }
        return this.CurrRec;
    }
    getPrevCurrRec() {
        return this._prevCurrRec;
    }
    getOriginalRec() {
        if (this._original === null || this._original.getId() !== this.CurrRec.getId())
            return this.CurrRec;
        return this._original;
    }
    async setCurrRec(id, compute) {
        let oldRecId = this._currRecId;
        if (id > Int32.MinValue) {
            let newIdx = this._recordsTab.getRecIdx(id);
            if (newIdx === -1)
                this._original = null;
            else {
                try {
                    let ignoreCurrRec = this._currRecId === Int32.MinValue;
                    await this.setCurrRecByIdx(newIdx, !ignoreCurrRec, ignoreCurrRec, compute, Int32.MinValue);
                    if (id !== oldRecId)
                        this.saveOriginal();
                    return true;
                }
                catch (exception) {
                    if (exception instanceof RecordOutOfDataViewException) {
                    }
                    else
                        throw exception;
                }
            }
        }
        else {
            this.CurrRec = null;
            this._original = null;
            this._currRecId = Int32.MinValue;
        }
        return false;
    }
    async setCurrRecByIdx(newIdx, doSuffix, ignoreCurrRec, compute, newDisplayLine) {
        let lastRecIdx = this._recordsTab.getSize() - 1;
        let oldFirstRec, nextRec;
        let recordSuff = false;
        if (newIdx === Constants.MG_DATAVIEW_FIRST_RECORD) {
            if (this.getTask().isTableWithAbsolutesScrollbar()) {
                this.RecordsBeforeCurrentView = 0;
            }
            if (this._includesFirst) {
                if (this._currRecIdx >= 0 || this._currRecIdx === Int32.MinValue) {
                    newIdx = 0;
                    recordSuff = true;
                }
                else
                    throw new RecordOutOfDataViewException(RecordOutOfDataViewException_ExceptionType.TOP);
            }
            else {
                await this.fetchChunkFromServer(CHUNK_DV_TOP, doSuffix);
                await this.setCurrRecByIdx(newIdx, false, ignoreCurrRec, compute, SET_DISPLAYLINE_BY_DV);
                return;
            }
        }
        else if (newIdx === Constants.MG_DATAVIEW_LAST_RECORD) {
            if (this._includesLast) {
                if (this._currRecIdx <= lastRecIdx) {
                    newIdx = lastRecIdx;
                    recordSuff = true;
                }
                else
                    throw new RecordOutOfDataViewException(RecordOutOfDataViewException_ExceptionType.BOTTOM);
            }
            else {
                if (this.getTask().isTableWithAbsolutesScrollbar())
                    this.RecordsBeforeCurrentView = this.TotalRecordsCount;
                await this.fetchChunkFromServer(CHUNK_DV_BOTTOM, doSuffix);
                if (!this._includesLast)
                    throw new RecordOutOfDataViewException(RecordOutOfDataViewException_ExceptionType.BOTTOM);
                let form = this._task.getForm();
                if (form != null) {
                    while (!this._includesFirst && form.getRowsInPage() >= this.getSize()) {
                        await this.fetchChunkFromServer(CHUNK_CACHE_PREV, false);
                    }
                }
                await this.setCurrRecByIdx(newIdx, false, ignoreCurrRec, compute, SET_DISPLAYLINE_BY_DV);
                return;
            }
        }
        else if (newIdx < 0) {
            if (this._includesFirst)
                throw new RecordOutOfDataViewException(RecordOutOfDataViewException_ExceptionType.TOP);
            oldFirstRec = this._recordsTab.getRecByIdx(0);
            if (this._recordsTab.getSize() > 0 || this.IncludesLast())
                await this.fetchChunkFromServer(CHUNK_CACHE_PREV, doSuffix);
            else if (this._recordsTab.getSize() === 0 && this.IncludesFirst())
                await this.fetchChunkFromServer(CHUNK_DV_TOP, doSuffix);
            else
                Logger.Instance.WriteExceptionToLogWithMsg('in DataView.fetchChunkFromServer() wrong option');
            let oldFirstNewIdx = oldFirstRec != null
                ? this._recordsTab.getRecIdx(oldFirstRec.getId())
                : this._recordsTab.getSize();
            if (oldFirstNewIdx !== 0)
                await this.setCurrRecByIdx(oldFirstNewIdx + newIdx, false, ignoreCurrRec, compute, SET_DISPLAYLINE_BY_DV);
            return;
        }
        else if (newIdx > lastRecIdx) {
            if (this._includesLast)
                throw new RecordOutOfDataViewException(RecordOutOfDataViewException_ExceptionType.BOTTOM);
            if (this.getForm().isRowCreated(newIdx))
                this.getForm().markRowNOTCreated(newIdx);
            await this.fetchChunkFromServer(CHUNK_CACHE_NEXT, doSuffix);
            await this.setCurrRecByIdx(newIdx, false, ignoreCurrRec, compute, SET_DISPLAYLINE_BY_DV);
            return;
        }
        let isCreateLineAboveAct = false;
        let lastEvent = isNullOrUndefined(AccessHelper.eventsManager.getLastRtEvent()) ? 0 :
            AccessHelper.eventsManager.getLastRtEvent().getInternalCode();
        if (newIdx >= 0 && !this.getTask().transactionFailed(ConstInterface.TRANS_RECORD_PREFIX) &&
            lastEvent === InternalInterface.MG_ACT_CRELINE_ABOVE) {
            if ((this.getTask().getInCreateLine()) && newIdx == this._currRecIdx) {
                let newRec = this._recordsTab.getRecByIdx(newIdx);
                if (newRec.getMode() == DataModificationTypes.Insert)
                    isCreateLineAboveAct = true;
            }
        }
        if (recordSuff || isCreateLineAboveAct || newIdx !== this._currRecIdx || ignoreCurrRec && compute) {
            if (!ignoreCurrRec && doSuffix && this.CurrRec != null) {
                let oldRecTabSize = this._recordsTab.getSize();
                nextRec = this._recordsTab.getRecByIdx(newIdx);
                if (nextRec.isNewRec()) {
                    if (this._task.getMode() !== Constants.TASK_MODE_CREATE &&
                        !await this._task.checkProp(PropInterface.PROP_TYPE_ALLOW_CREATE, true))
                        AccessHelper.eventsManager.setStopExecution(true);
                }
                if (!AccessHelper.eventsManager.GetStopExecutionFlag()) {
                    let orgTopRecIdx = 0;
                    if (this._topRecIdxModified) {
                        orgTopRecIdx = this.getTopRecIdx();
                        this.restoreTopRecIdx();
                    }
                    await AccessHelper.eventsManager.handleInternalEventWithTask(this._task, InternalInterface.MG_ACT_REC_SUFFIX);
                    if (this._topRecIdxModified)
                        this.setTopRecIdx(orgTopRecIdx);
                }
                if (AccessHelper.eventsManager.GetStopExecutionFlag())
                    throw new RecordOutOfDataViewException(RecordOutOfDataViewException_ExceptionType.REC_SUFFIX_FAILED);
                if (nextRec !== this.CurrRec && this.getTask().getAfterRetry())
                    this._task.setLevel(Constants.TASK_LEVEL_TASK);
                if (oldRecTabSize - 1 === this._recordsTab.getSize() && this._currRecIdx < newIdx)
                    newIdx--;
                if (newIdx === this._currRecIdx) {
                    if (this._task.getMode() === Constants.TASK_MODE_CREATE && !this.CurrRec.isNewRec() &&
                        !this._task.getForm().inRefreshDisplay())
                        this._task.setMode(Constants.TASK_MODE_MODIFY);
                    return;
                }
            }
            this.CurrRec = this._recordsTab.getRecByIdx(newIdx);
            if (this.CurrRec == null)
                throw new ApplicationException('in DataView.setCurrRecByIdx() current record not found!');
            this._currRecId = this.CurrRec.getId();
            this._currRecIdx = newIdx;
            if (this._task.getForm() != null) {
                if (newDisplayLine === SET_DISPLAYLINE_BY_DV) {
                    (this._task.getForm()).updateDisplayLineByDV();
                }
                else
                    this._task.getForm().DisplayLine = newDisplayLine;
            }
            if (this._task.getMode() === Constants.TASK_MODE_CREATE && !this.CurrRec.isNewRec() &&
                !this._task.getForm().inRefreshDisplay())
                this._task.setMode(Constants.TASK_MODE_MODIFY);
            if (compute)
                await this.currRecCompute(false);
        }
    }
    async currRecCompute(forceClientCompute) {
        this._fieldsTab.invalidate(false, true);
        await this.compute(false, forceClientCompute);
    }
    saveOriginal() {
        if (!this.CurrRec.Modified)
            this._original = this.CurrRec.replicate();
    }
    async fetchChunkFromServer(chunkId, doSuffix) {
        this._task.getForm().FormRefreshed = true;
        if (doSuffix && this.CurrRec != null) {
            await AccessHelper.eventsManager.handleInternalEventWithTask(this._task, InternalInterface.MG_ACT_REC_SUFFIX);
            if (AccessHelper.eventsManager.GetStopExecutionFlag() || this._task.isAborting())
                throw new RecordOutOfDataViewException(RecordOutOfDataViewException_ExceptionType.REC_SUFFIX_FAILED);
            this._task.getForm().setSuffixDone();
        }
        let eventCode;
        let clientRecId = this._currRecId;
        switch (chunkId) {
            case CHUNK_DV_TOP:
                eventCode = InternalInterface.MG_ACT_DATAVIEW_TOP;
                break;
            case CHUNK_DV_BOTTOM:
                eventCode = InternalInterface.MG_ACT_DATAVIEW_BOTTOM;
                break;
            case CHUNK_CACHE_PREV:
                clientRecId = this.FirstRecord == null ? 0 : this.FirstRecord.getId();
                eventCode = InternalInterface.MG_ACT_CACHE_PREV;
                break;
            case CHUNK_CACHE_NEXT:
                eventCode = InternalInterface.MG_ACT_CACHE_NEXT;
                clientRecId = this.LastRecord == null ? 0 : this.LastRecord.getId();
                break;
            default:
                Logger.Instance.WriteExceptionToLogWithMsg('in DataView.fetchChunkFromServer() unknown chunk id: ' + chunkId);
                return;
        }
        let cmd = CommandFactory.CreateEventCommand(this._task.getTaskTag(), eventCode);
        cmd.ClientRecId = clientRecId;
        await this.getTask().DataviewManager.Execute(cmd);
    }
    async FetchRecordsAheadFromServer() {
        if (!this._includesLast)
            await this.fetchChunkFromServer(CHUNK_CACHE_NEXT, false);
        else if (!this._includesFirst)
            await this.fetchChunkFromServer(CHUNK_CACHE_PREV, false);
    }
    recExists(recIdx) {
        let lastRecIdx = this._recordsTab.getSize() - 1;
        return recIdx >= 0 && recIdx <= lastRecIdx;
    }
    checkFirst(locateFirst) {
        return this._recordsTab.getRecord(locateFirst) !== null;
    }
    getCurrRecIdx() {
        if (this._currRecIdx === Int32.MinValue) {
            if (!this.setCurrRec(this._currRecId, true)) {
                Logger.Instance.WriteWarningToLogWithMsg('DataView.getCurrRecIdx(): _task ' +
                    (this.getTask()).PreviouslyActiveTaskId +
                    ', record ' + this._currRecId + ' not found');
            }
        }
        return this._currRecIdx;
    }
    getCurrDBViewRowIdx() {
        return this.CurrRec.getDBViewRowIdx();
    }
    setTopRecIdx(newTopRecIdx) {
        this._oldTopRecIdx = this.getTopRecIdx();
        this._topRecIdx = newTopRecIdx;
    }
    getTopRecIdx() {
        return this._topRecIdx;
    }
    setTopRecIdxModified(val) {
        this._topRecIdxModified = val;
    }
    getChunkSize() {
        return this._chunkSize;
    }
    restoreTopRecIdx() {
        this._topRecIdx = this._oldTopRecIdx;
    }
    clear() {
        this._recordsTab.removeAll();
        this._original = null;
        let mgForm = this._task.getForm();
        if (mgForm !== null) {
            this._task.getForm().SetTableItemsCount(0, true);
        }
        this._modifiedRecordsTab.removeAll();
        this.init();
    }
    init() {
        this._currRecId = Int32.MinValue;
        this._currRecIdx = Int32.MinValue;
        this.CurrRec = null;
        this._prevCurrRec = null;
        this._includesFirst = false;
        this._includesLast = false;
        this.IsOneWayKey = false;
        this.setTopRecIdx(Int32.MinValue);
        this._fieldsTab.invalidate(false, true);
    }
    async computeSubForms() {
        if (await this.getTask().prepareCache(true)) {
            if (!await this.getTask().testAndSet(true))
                await this.compute(true, false);
        }
        else
            await this.compute(true, false);
    }
    async compute(subForms, forceClientCompute) {
        let tmpRec = null;
        let computeByServer = !this.computeByClient();
        let orgComputeBy = this._computeBy;
        if (forceClientCompute)
            this._computeBy = COMPUTE_NEWREC_ON_CLIENT;
        try {
            this.CurrRec.setInCompute(true);
            if (!subForms) {
                if (this.CurrRec.isNewRec()) {
                    if (this._task.getMode() !== Constants.TASK_MODE_CREATE && !super.isEmptyDataview()) {
                        this._task.setMode(Constants.TASK_MODE_CREATE);
                    }
                }
                else if (this._task.getMode() === Constants.TASK_MODE_CREATE) {
                    this._task.setMode(Constants.TASK_MODE_MODIFY);
                }
            }
            let getRecordData = computeByServer;
            if (subForms || (getRecordData && !this.CurrRec.isComputed() && !forceClientCompute)) {
                let command = CommandFactory.CreateComputeEventCommand(this._task.getTaskTag(), subForms, this._currRecId);
                await this._task.DataviewManager.Execute(command);
            }
            else {
                if (getRecordData) {
                    tmpRec = new Record(this.CurrRec.getId(), this);
                    tmpRec.Initialize();
                    tmpRec.setInitialFldVals(true, true);
                }
                this._fieldsTab.setServerRcmp(false);
                let from = this._fieldsTab.getRMIdx();
                let size = this._fieldsTab.getRMSize();
                for (let i = from; i < from + size; i = i + 1) {
                    let fld = this._fieldsTab.getField(i);
                    if (getRecordData && this._fieldsTab.serverRcmpDone() && fld.IsVirtual && !fld.VirAsReal && !fld.hasInitExp()) {
                        let currRec2 = this.CurrRec;
                        this.CurrRec = tmpRec;
                        try {
                            fld.takeValFromRec();
                        }
                        finally {
                            this.CurrRec = currRec2;
                        }
                    }
                    if (!this._task.getForm().TransferringDataToGUI)
                        await fld.compute(false);
                }
            }
        }
        finally {
            this.CurrRec.setInCompute(false);
            this.CurrRec.setLateCompute(false);
            this._computeBy = orgComputeBy;
        }
    }
    async addRecord(doSuffix, ignoreCurrRec, isCrelineAbove) {
        let newCurrRecId = (--this._lastCreatedRecId);
        let mode = DataModificationTypes.Insert;
        return await this.addRecord_1(doSuffix, ignoreCurrRec, false, newCurrRecId, mode, isCrelineAbove);
    }
    async addRecord_1(doSuffix, ignoreCurrRec, isFirstRecord, newCurrRecId, mode, isCrelineAbove) {
        let rec = new Record(newCurrRecId, this);
        rec.Initialize();
        rec.setInitialFldVals(false, !isFirstRecord);
        let newCurrRecIdx = 0;
        if (isCrelineAbove) {
            newCurrRecIdx = (this._currRecIdx >= 0
                ? this._currRecIdx
                : 0);
        }
        else
            newCurrRecIdx = (this._currRecIdx != Int32.MinValue
                ? this._currRecIdx + 1
                : 0);
        this._recordsTab.insertRecord(rec, newCurrRecIdx);
        rec.setMode(mode);
        try {
            let compute = !isFirstRecord;
            await this.setCurrRecByIdx(newCurrRecIdx, doSuffix, ignoreCurrRec, compute, Int32.MinValue);
            if (isFirstRecord && this.getTask().getMode() !== Constants.TASK_MODE_CREATE)
                rec.setOldRec();
        }
        catch (execption) {
            if (execption instanceof RecordOutOfDataViewException) {
                if (AccessHelper.eventsManager.GetStopExecutionFlag())
                    newCurrRecIdx = -1;
                else
                    throw new ApplicationException('in DataView.addRecord() invalid exception');
            }
            else
                throw execption;
        }
        return newCurrRecIdx;
    }
    async removeCurrRec() {
        let mgForm = this._task.getForm();
        let onDelete;
        if (this.CurrRec.getMode() === DataModificationTypes.Insert &&
            !this.getTask().transactionFailed(ConstInterface.TRANS_RECORD_PREFIX)) {
            this._modifiedRecordsTab.removeRecord(this.CurrRec);
            onDelete = false;
        }
        else {
            this.CurrRec.clearMode();
            this.CurrRec.setMode(DataModificationTypes.Delete);
            onDelete = true;
        }
        this.CurrRec.removeRecFromDc();
        this._recordsTab.removeRecord(this._currRecIdx);
        this.setChanged(true);
        if (this.isEmpty() && !this._task.IsTryingToStop) {
            await this.MoveToEmptyDataviewIfAllowed();
        }
        let newDisplayLine = this.calcLineToMove(onDelete);
        try {
            if (mgForm.isScreenMode()) {
                await this.setCurrRecByIdx(newDisplayLine, false, false, true, SET_DISPLAYLINE_BY_DV);
            }
            else {
                await mgForm.setCurrRowByDisplayLine(newDisplayLine, false, true);
            }
        }
        catch (exception) {
            if (exception instanceof RecordOutOfDataViewException) {
                try {
                    if (!super.isEmptyDataview())
                        newDisplayLine = mgForm.getPrevLine(newDisplayLine);
                    if (mgForm.isScreenMode())
                        await this.setCurrRecByIdx(newDisplayLine, false, false, true, SET_DISPLAYLINE_BY_DV);
                    else
                        await mgForm.setCurrRowByDisplayLine(newDisplayLine, false, true);
                }
                catch (exception) {
                    if (exception instanceof RecordOutOfDataViewException) {
                        this.reset();
                    }
                    else
                        throw exception;
                }
            }
            else
                throw exception;
        }
    }
    RemoveRecord(record) {
        let recIdx = this._recordsTab.getRecIdx(record.getId());
        if (this._topRecIdx > recIdx)
            this._topRecIdx--;
        if (this._oldTopRecIdx > recIdx)
            this._oldTopRecIdx--;
        if (this._currRecIdx > recIdx)
            this._currRecIdx--;
        this._recordsTab.removeRecord(record);
    }
    async MoveToEmptyDataviewIfAllowed() {
        if (!super.isEmptyDataview() && this._task.getMode() !== Constants.TASK_MODE_CREATE) {
            if (await this._task.checkProp(PropInterface.PROP_TYPE_ALLOW_EMPTY_DATAVIEW, true))
                super.setEmptyDataview(true);
        }
        else {
            if (this._task.getMode() === Constants.TASK_MODE_CREATE && super.isEmptyDataview())
                super.setEmptyDataview(false);
        }
    }
    calcLineToMove(onDelete) {
        let newDisplayLine;
        if (onDelete)
            newDisplayLine = this._currRecIdx;
        else {
            if (this._currRecIdx > 0)
                newDisplayLine = this._currRecIdx - 1;
            else
                newDisplayLine = this._currRecIdx;
        }
        return newDisplayLine;
    }
    reset() {
        this._currRecId = Int32.MinValue;
        this._currRecIdx = Int32.MinValue;
        this.CurrRec = null;
        this.setTopRecIdx(Int32.MinValue);
        this.SetIncludesFirst(true);
        this.SetIncludesLast(true);
    }
    async cancelEdit(onlyReal, recomputeUnknowns) {
        let tempCurrRec = null;
        let recRemoved = false;
        let inEndTask = this._task.InEndTask;
        if (inEndTask)
            onlyReal = true;
        if (this.CurrRec.getMode() === DataModificationTypes.Insert && this.CurrRec.isNewRec()) {
            if ((this._includesFirst && this._includesLast && (this._recordsTab === null || this._recordsTab.getSize() === 1)) || !this.HasMainTable) {
                if (this._original !== null) {
                    this.CurrRec.setSameAs(this._original, onlyReal);
                }
            }
            else {
                await this.removeCurrRec();
                recRemoved = true;
                this._original = this.CurrRec.replicate();
            }
        }
        else {
            if (!this.CurrRec.Modified) {
                let currCtrl = this._task.getLastParkedCtrl();
                if (currCtrl !== null)
                    currCtrl.resetPrevVal();
            }
            if (recomputeUnknowns)
                tempCurrRec = this.CurrRec.replicate();
            if (this._original !== null)
                this.CurrRec.setSameAs(this._original, onlyReal);
            if ((this._original !== null && recomputeUnknowns) && !this.CurrRec.isSameRecData(tempCurrRec, false, false))
                await this.execUnknownRcmps(this._original);
            this.takeFldValsFromCurrRec();
            this._original = this.CurrRec.replicate();
        }
        return recRemoved;
    }
    isEmpty() {
        return this._includesFirst && this._includesLast && (this._recordsTab === null || this._recordsTab.getSize() === 0);
    }
    async addCurrToModified(setRecToOld) {
        if (isNullOrUndefined(setRecToOld)) {
            await this.addCurrToModified_0();
            return;
        }
        await this.addCurrToModified_1(setRecToOld);
    }
    async addCurrToModified_0() {
        await this.addCurrToModified(true);
    }
    async addCurrToModified_1(setRecToOld) {
        this._modifiedRecordsTab.addRecord(this.CurrRec);
        if (setRecToOld) {
            this.CurrRec.setOldRec();
        }
        let command = CommandFactory.CreateSetTransactionStateDataviewCommand(this.getTask().getTaskTag(), true);
        await this.getTask().DataviewManager.RemoteDataviewManager.Execute(command);
    }
    takeFldValsFromCurrRec() {
        this._fieldsTab.takeValsFromRec();
    }
    currEqualsPrev(fldList) {
        if (this.CurrRec !== null && this._prevCurrRec !== null) {
            if (this.CurrRec === this._prevCurrRec)
                return true;
            for (let i = 0; i < fldList.length; i = i + 1) {
                if (!this.CurrRec.fldValsEqual(this._prevCurrRec, fldList[i]))
                    return false;
            }
        }
        else if (this.CurrRec !== this._prevCurrRec)
            return false;
        return true;
    }
    getTask() {
        Debug.Assert(this._task instanceof TaskBase);
        return this._task;
    }
    getForm() {
        return this._task.getForm();
    }
    modifiedRecordsNumber() {
        return this._modifiedRecordsTab.getSize();
    }
    getSize() {
        return this._recordsTab.getSize();
    }
    computeByClient() {
        return this._computeBy === COMPUTE_NEWREC_ON_CLIENT;
    }
    recExistsById(id) {
        return this._recordsTab.getRecord(id) !== null;
    }
    ParametersExist(iPos, iLen) {
        if (arguments.length === 2)
            return this.ParametersExist_0(iPos, iLen);
        return this.ParametersExist_1();
    }
    ParametersExist_0(iPos, iLen) {
        for (let i = iPos; i < iPos + iLen; i = i + 1) {
            if (super.getField(i).isParam())
                return true;
        }
        return false;
    }
    ParametersExist_1() {
        return this.ParametersExist(this._rmIdx, this._rmSize);
    }
    recInModifiedTab(id) {
        let record = this._modifiedRecordsTab.getRecord(id);
        return record !== null;
    }
    setPrevCurrRec(rec) {
        if (arguments.length === 0) {
            this.setPrevCurrRec_0();
            return;
        }
        this.setPrevCurrRec_1(rec);
    }
    setPrevCurrRec_0() {
        this._prevCurrRec = this.CurrRec;
    }
    setPrevCurrRec_1(rec) {
        this._prevCurrRec = rec;
    }
    isPrevCurrRecNull() {
        return this._prevCurrRec === null;
    }
    async execUnknownRcmps(orgRec) {
        let i;
        let from = this._fieldsTab.getRMIdx();
        let size = this._fieldsTab.getRMSize();
        let rec = this.getCurrRec();
        if (this._unknownRcmp === UNKNOWN_RCMPS_NOT_INITED) {
            for (i = from; i < from + size && this._unknownRcmp === UNKNOWN_RCMPS_NOT_INITED; i++) {
                let field = this._fieldsTab.getField(i);
                if (field.IsVirtual && !field.hasInitExp() && field.isServerRcmp())
                    this._unknownRcmp = UNKNOWN_RCMPS_FOUND;
            }
        }
        if (this._unknownRcmp === UNKNOWN_RCMPS_FOUND && rec !== null) {
            for (i = from; i < from + size; i = i + 1) {
                let field = this._fieldsTab.getField(i);
                if (field.IsVirtual && !field.hasInitExp() && field.isServerRcmp() && !rec.fldValsEqual(orgRec, i)) {
                    let fieldValue = rec.GetFieldValue(i);
                    let isNullFld = rec.IsNull(i);
                    rec.setFieldValue(i, orgRec.GetFieldValue(i), false);
                    await field.setValueAndStartRecompute(fieldValue, isNullFld, false, false, false);
                }
            }
        }
    }
    setTransCleared() {
        this._transCleared = true;
    }
    async processRecovery() {
        if (!this._task.isAborting()) {
            let orgAction = this._pendingRecovery;
            let orgStopExecution = AccessHelper.eventsManager.GetStopExecutionFlag();
            this._pendingRecovery = RECOVERY_ACT_NONE;
            if (orgStopExecution)
                AccessHelper.eventsManager.setStopExecution(false);
            let temporaryResetInCtrlPrefix = this._task.InCtrlPrefix;
            if (temporaryResetInCtrlPrefix)
                this._task.InCtrlPrefix = false;
            switch (orgAction) {
                case RECOVERY_ACT_CANCEL:
                    (this._task.DataView.getCurrRec()).resetUpdated();
                    this.getTask().getTaskCache().clearCache();
                    if (this.getSize() === 1 && this._task.getMode() === Constants.TASK_MODE_CREATE) {
                        this.CurrRec.resetModified();
                        this.CurrRec.clearMode();
                        this.CurrRec.setMode(DataModificationTypes.Insert);
                        this.CurrRec.setNewRec();
                        this._original.setSameAs(this.CurrRec, false);
                    }
                    await AccessHelper.eventsManager.handleInternalEventWithTaskAndEventSubtype(this.getTask(), InternalInterface.MG_ACT_CANCEL, EventSubType.CancelWithNoRollback);
                    break;
                case RECOVERY_ACT_MOVE_DIRECTION_BEGIN:
                    let lastParkedControl = this._task.getLastParkedCtrl();
                    if (lastParkedControl !== null)
                        await lastParkedControl.invoke();
                    break;
                case RECOVERY_ACT_BEGIN_SCREEN:
                    this.getTask().setPreventRecordSuffix(true);
                    await AccessHelper.eventsManager.handleInternalEventWithTask(this._task, InternalInterface.MG_ACT_TBL_BEGPAGE);
                    this.getTask().setPreventRecordSuffix(false);
                    break;
                case RECOVERY_ACT_BEGIN_TABLE:
                    this._task.ActionManager.enable(InternalInterface.MG_ACT_TBL_BEGTBL, true);
                    await AccessHelper.eventsManager.handleInternalEventWithTask(this._task, InternalInterface.MG_ACT_TBL_BEGTBL);
                    this.getTask().getTaskCache().clearCache();
                    break;
                default:
                    AccessHelper.eventsManager.setStopExecution(orgStopExecution);
                    break;
            }
            if (temporaryResetInCtrlPrefix)
                this._task.InCtrlPrefix = true;
            if (orgAction !== RECOVERY_ACT_NONE)
                AccessHelper.eventsManager.setStopExecution(true, orgAction !== RECOVERY_ACT_BEGIN_TABLE ? ClearEventsOnStopExecution.ALL : ClearEventsOnStopExecution.SERVER);
        }
    }
    replicate() {
        let rep = new DataView(this);
        rep._recordsTab = this._recordsTab.replicate();
        rep._currRecId = rep._recordsTab.getRecByIdx(0).getId();
        rep._currRecIdx = 0;
        rep.CurrRec = rep._recordsTab.getRecByIdx(0);
        rep._prevCurrRec = rep._recordsTab.getRecByIdx(0);
        rep._original = rep._recordsTab.getRecByIdx(0);
        rep.setTopRecIdx(Int32.MinValue);
        return rep;
    }
    getDvPosValue() {
        return this._dvPosValue;
    }
    getFirstDv() {
        return this._firstDv;
    }
    ResetFirstDv() {
        this._firstDv = false;
    }
    getCacheLRU() {
        return this._cacheLruTimeStamp;
    }
    setCacheLRU() {
        this._cacheLruTimeStamp = Misc.getSystemMilliseconds();
    }
    async setSameAs(newDv) {
        this._rmSize = newDv._rmSize;
        this._rmIdx = newDv._rmIdx;
        this._computeBy = newDv._computeBy;
        this._flushUpdates = newDv._flushUpdates;
        this._currRecId = newDv._currRecId;
        this._currRecIdx = newDv._currRecIdx;
        this._topRecId = newDv._topRecId;
        this.CurrRec = newDv.CurrRec;
        this._original = newDv._original;
        this._prevCurrRec = null;
        this._fieldsTab = newDv._fieldsTab;
        this._recordsTab = newDv._recordsTab;
        this._modifiedRecordsTab = newDv._modifiedRecordsTab;
        this._includesFirst = newDv._includesFirst;
        this._includesLast = newDv._includesLast;
        this._insertAt = newDv._insertAt;
        this._lastCreatedRecId = newDv._lastCreatedRecId;
        this._task = newDv._task;
        this._dcValsCollection = newDv._dcValsCollection;
        this._recovery = newDv._recovery;
        this._pendingRecovery = newDv._pendingRecovery;
        this._hasMainTable = newDv._hasMainTable;
        this._chunkSize = newDv._chunkSize;
        this._firstDv = newDv._firstDv;
        this._lastSessionCounter = newDv._lastSessionCounter;
        this._skipParsing = newDv._skipParsing;
        this._unknownRcmp = newDv._unknownRcmp;
        this._transCleared = newDv._transCleared;
        this._dvPosValue = newDv._dvPosValue;
        this._cacheLruTimeStamp = newDv._cacheLruTimeStamp;
        this._changed = newDv._changed;
        this._locateFirstRec = newDv._locateFirstRec;
        super.setEmptyDataview(newDv.isEmptyDataview());
        this._task.setMode(newDv.taskModeFromCache);
        try {
            if (this.getTask().HasLoacte()) {
                await this.setCurrRec(this._locateFirstRec, true);
                this.setTopRecIdx(this._recordsTab.getRecIdx(this._locateFirstRec));
            }
            else {
                this.getTask().setPreventRecordSuffix(true);
                await this.setCurrRecByIdx(Int32.MinValue, true, false, true, Int32.MinValue);
                this.getTask().setPreventRecordSuffix(false);
                this.setTopRecIdx(0);
            }
            if (!this._task.getForm().isScreenMode()) {
                if (this._task.getForm().isTableWithPagination()) {
                    this.TotalRecordsCount = newDv.TotalRecordsCount;
                    this.RecordsBeforeCurrentView = newDv.RecordsBeforeCurrentView;
                }
                await this.setCurrRecByIdx(this._topRecIdx, true, false, true, Int32.MinValue);
            }
            if (this._task.getForm() !== null)
                this._task.getForm().updateDisplayLineByDV();
        }
        catch (ex) {
            if (ex instanceof RecordOutOfDataViewException) {
                Logger.Instance.WriteDevToLog('wrong top record idx in DataView.setSameAs' + ex.Message);
            }
            else
                throw ex;
        }
    }
    setChanged(val) {
        this._changed = val;
    }
    getChanged() {
        return this._changed;
    }
    getLocateFirstRec() {
        return this._locateFirstRec;
    }
    setLocateFirstRec(newFirst) {
        this._locateFirstRec = newFirst;
    }
    getRecByIdx(idx) {
        return this._recordsTab.getRecByIdx(idx);
    }
    getServerCurrRec() {
        return this._recordsTab.getServerCurrRec();
    }
    zeroServerCurrRec() {
        this._recordsTab.zeroServerCurrRec();
    }
    inRollback() {
        let inRollback = false;
        if (this._recovery === ConstInterface.RECOVERY_ROLLBACK && this.getTask().isTransactionOwner()) {
            inRollback = true;
        }
        return inRollback;
    }
    getRecIdx(id) {
        return this._recordsTab.getRecIdx(id);
    }
    backupCurrent() {
        return this.CurrRec.replicate();
    }
    restoreCurrent(recBackup) {
        Debug.Assert(recBackup !== null);
        this._currRecId = recBackup.getId();
        this._currRecIdx = this._recordsTab.getRecIdx(this._currRecId);
        this.CurrRec = this._recordsTab.getRecByIdx(this._currRecIdx);
        this.CurrRec.setSameAs(recBackup, false);
        this.takeFldValsFromCurrRec();
    }
    GetCurrentRecId() {
        return this._currRecId;
    }
    DataviewBoundriesAreChanged(orgIncludesFirst, orgIncludesLast) {
        return orgIncludesFirst !== this.IncludesFirst() || orgIncludesLast !== this.IncludesLast();
    }
    GetRouteParams() {
        let params = new List();
        for (let i = 0; i < this._fieldsTab.getSize(); i++) {
            let field = this._fieldsTab.getField(i);
            let val;
            if (field.IsExposedRouteParam && !field.isNull()) {
                switch (field.getType()) {
                    case StorageAttribute.ALPHA:
                    case StorageAttribute.UNICODE:
                        {
                            val = field.getDispValue();
                            if (field.isNull())
                                val = field.getNullDisplay();
                            val = val.trim();
                            params.push(val.length === 0 ? ' ' : val);
                        }
                        break;
                    case StorageAttribute.BOOLEAN:
                        {
                            if (field.isNull())
                                params.push(false);
                            else
                                params.push((field.getDispValue()).charAt(0) === '1');
                        }
                        break;
                    case StorageAttribute.NUMERIC: {
                        val = field.getDispValue();
                        if (field.isNull())
                            val = field.getNullDisplay();
                        let pic = new PIC(field.getPicture(), field.getType(), this.getTask().getCompIdx());
                        val = DisplayConvertor.Instance.mg2disp(val, '', pic, true, 0, false);
                        params.push(val);
                        break;
                    }
                }
            }
        }
        return (params.length > 0) ? params : null;
    }
}

class DvCache {
    constructor(tsk) {
        this._cacheTable = null;
        this._deletedList = null;
        this._task = null;
        this._task = tsk;
        this._cacheTable = new Hashtable(100, 0.7);
        this._deletedList = new List();
    }
    putInCache(repOfOriginal) {
        let hashKey = repOfOriginal.getDvPosValue();
        if (this._cacheTable.get_Item(hashKey) !== null)
            this.removeDvFromCache(hashKey, false);
        repOfOriginal.setCacheLRU();
        repOfOriginal.taskModeFromCache = this._task.getMode();
        repOfOriginal.zeroServerCurrRec();
        this._cacheTable.set_Item(hashKey, repOfOriginal);
        this._deletedList.Remove(hashKey);
        return true;
    }
    removeDvFromCache(DvPosValue, updateDel) {
        let rep = this._cacheTable.get_Item(DvPosValue);
        if (rep !== null) {
            if (updateDel)
                this._deletedList.push(DvPosValue);
            this._cacheTable.Remove(DvPosValue);
            return true;
        }
        return false;
    }
    getDeletedListToXML() {
        let list = '';
        for (let i = 0; i < this._deletedList.length; i++) {
            if (i > 0)
                list = list + ',';
            list += this._deletedList.get_Item(i).toString();
        }
        return list;
    }
    clearDeletedList() {
        this._deletedList.Clear();
    }
    getCachedDataView(DvPosValue) {
        let cached = this._cacheTable.get_Item(DvPosValue);
        if (cached !== null)
            cached = cached.replicate();
        return cached;
    }
    clearCache() {
        let dvKeysList = new List(this._cacheTable.Keys);
        for (let i = 0; i < dvKeysList.length; i++) {
            let dvKey = dvKeysList[i];
            this.removeDvFromCache(dvKey, true);
        }
        if (this._task.hasSubTasks()) {
            let subTasks = this._task.getSubTasks();
            for (let j = 0; j < subTasks.getSize(); j = j + 1)
                subTasks.getTask(j).getTaskCache().clearCache();
        }
        this._task.DataView.setChanged(true);
    }
    isDeleted(dvPosVal) {
        return this._deletedList.Contains(dvPosVal);
    }
}

class ReturnResultBase {
    constructor(innerResult) {
        this.InnerResult = null;
        if (arguments.length === 1)
            this.constructor_0(innerResult);
        else
            this.constructor_1();
    }
    constructor_0(innerResult) {
        this.InnerResult = innerResult;
    }
    constructor_1() {
    }
    static ErroNeedToBeHandled() {
        return false;
    }
}

class ReturnResult extends ReturnResultBase {
    get Success() {
        return this.success;
    }
    get ErrorDescription() {
        return this.errorDescription;
    }
    constructor(errorDescriptionCodeOrErrorDescriptionOrInnerResult, innerResult) {
        super();
        this.errorDescription = null;
        this.success = false;
        this.ErrorId = null;
        if (arguments.length === 1 && (errorDescriptionCodeOrErrorDescriptionOrInnerResult === null || errorDescriptionCodeOrErrorDescriptionOrInnerResult.constructor === String))
            this.constructor_00(errorDescriptionCodeOrErrorDescriptionOrInnerResult);
        else if (arguments.length === 0)
            this.constructor_01();
        else if (arguments.length === 2)
            this.constructor_02(errorDescriptionCodeOrErrorDescriptionOrInnerResult);
        else
            this.constructor_03(errorDescriptionCodeOrErrorDescriptionOrInnerResult);
    }
    constructor_00(errorDescriptionCode) {
        this.success = false;
        this.ErrorId = errorDescriptionCode;
        this.errorDescription = LanguageData.Instance.getConstMessage(errorDescriptionCode);
    }
    constructor_01() {
        this.success = true;
        this.ErrorId = "";
    }
    constructor_02(errorDescription) {
        this.success = false;
        this.errorDescription = errorDescription;
    }
    constructor_03(innerResult) {
        this.success = innerResult.Success;
        this.errorDescription = innerResult.ErrorDescription;
    }
    GetErrorId() {
        return this.ErrorId;
    }
}
ReturnResult.SuccessfulResult = new ReturnResult();

class TaskServiceBase {
    static CreateFirstRecord(task) {
        task.AfterFirstRecordPrefix = true;
    }
    PrepareTask(task) {
        return ReturnResult.SuccessfulResult;
    }
    static async PreparePropOpenTaskWindow(task) {
        let propOpenTaskWindow = task.getProp(PropInterface.PROP_TYPE_TASK_PROPERTIES_OPEN_TASK_WINDOW);
        let propOpenTaskWindowValue = false;
        if (!task.isMainProg() || task.getCtlIdx() === 0) {
            propOpenTaskWindowValue = await propOpenTaskWindow.getValueBoolean();
        }
        task.SetOpenWin(propOpenTaskWindowValue);
    }
    static async Exit(task, reversibleExit, subformDestination) {
        await task.Exit(reversibleExit, subformDestination);
    }
    GetOwnerTransactionTask(task) {
        return null;
    }
}

class Transaction {
    constructor(task, setTransId) {
        this._transId = null;
        this._afterTransRetry = ConstInterface.RECOVERY_NONE;
        this._transBegin = '\0';
        this.Opened = false;
        this.OwnerTask = null;
        this.OwnerTask = task;
        this._transId = setTransId;
        this._transBegin = ConstInterface.TRANS_TASK_PREFIX;
    }
    isOwner(task) {
        return task === this.OwnerTask;
    }
    close() {
        this.Opened = false;
    }
    open() {
        this.Opened = true;
    }
    isOpened() {
        return this.Opened;
    }
    setAfterRetry(val) {
        this._afterTransRetry = val;
    }
    getAfterRetry(recovery) {
        if (arguments.length === 0) {
            return this.getAfterRetry_0();
        }
        return this.getAfterRetry_1(recovery);
    }
    getAfterRetry_0() {
        return this._afterTransRetry !== ConstInterface.RECOVERY_NONE;
    }
    getAfterRetry_1(recovery) {
        return this._afterTransRetry === recovery;
    }
    getLevel() {
        return this._transBegin;
    }
    setTransBegin(val) {
        this._transBegin = val;
    }
    getTransId() {
        return this._transId;
    }
    setOwnerTask(task) {
        this.OwnerTask = task;
    }
}

class TaskTransactionManager {
    get isClosingTopmostTask() {
        return MGDataCollection.Instance.StartupMgData.getFirstTask().InEndTask;
    }
    constructor(task) {
        this.task = null;
        this.task = task;
    }
    AllowTransaction(transBegin, forLocal) {
        let result;
        if (forLocal)
            result = (transBegin === ConstInterface.TRANS_TASK_PREFIX || transBegin === ConstInterface.TRANS_RECORD_PREFIX);
        else
            result = (transBegin === ConstInterface.TRANS_TASK_PREFIX || transBegin === ConstInterface.TRANS_RECORD_PREFIX || transBegin === ConstInterface.TRANS_NONE);
        return result;
    }
    PrepareTransactionProperties(transaction, forLocal) {
        let transactionBeginValue = this.GetTransactionBeginValue(forLocal);
        let flag = transaction !== null && this.AllowTransaction(transactionBeginValue, forLocal);
        if (flag)
            transaction.setTransBegin(transactionBeginValue);
    }
    GetTransactionBeginValue(forLocal) {
        let result = ConstInterface.TRANS_NONE;
        let prop = this.task.getProp(PropInterface.PROP_TYPE_TRASACTION_BEGIN);
        if (prop !== null) {
            let propgetValue = forLocal ? prop.StudioValue : prop.GetComputedValue();
            if (propgetValue !== null) {
                result = propgetValue.charAt(0);
            }
        }
        return result;
    }
    async checkAndCommit(reversibleExit, level, isAbort) {
        let oper = isAbort ? ConstInterface.TRANS_ABORT : ConstInterface.TRANS_COMMIT;
        let result = await this.ExecuteLocalUpdatesCommand();
        if (!result.Success) {
            if (!this.task.IsInteractive)
                this.task.abort();
            return false;
        }
        let refResult = new RefParam(result);
        let ret = await this.checkAndCommitPerDataview(this.task.DataviewManager.RemoteDataviewManager, reversibleExit, level, oper, refResult);
        result = refResult.value;
        if (!ret) {
            if (level === ConstInterface.TRANS_RECORD_PREFIX && this.task.DataView.modifiedRecordsNumber() > 0 && this.task.DataView.FlushUpdates) {
                try {
                    this.task.TryingToCommit = true;
                    await RemoteCommandsProcessor.GetInstance().Execute(CommandsProcessorBase_SendingInstruction.TASKS_AND_COMMANDS);
                }
                finally {
                    this.task.TryingToCommit = false;
                }
            }
        }
        return false;
    }
    async ExecuteLocalUpdatesCommand() {
        let command = CommandFactory.CreateDataViewCommand(this.task.getTaskTag(), DataViewCommandType.ExecuteLocalUpdates);
        return await this.task.DataviewManager.Execute(command);
    }
    async checkAndCommitPerDataview(dataviewmanager, reversibleExit, level, oper, refResult) {
        refResult.value = new ReturnResult();
        let returnValue = false;
        let currentTransaction = dataviewmanager.Transaction;
        if (currentTransaction !== null && !this.task.isAborting() &&
            currentTransaction.isOpened() && currentTransaction.isOwner(this.task) &&
            currentTransaction.getLevel() === level) {
            let cmd = CommandFactory.CreateTransactionCommand(oper, this.task.getTaskTag(), reversibleExit, level);
            if (this.isClosingTopmostTask && MGDataCollection.Instance.StartupMgData.getFirstTask().ClosingFormUI)
                this.task.getMGData().CmdsToServer.Add(cmd);
            try {
                this.task.TryingToCommit = true;
                if (!(this.isClosingTopmostTask && MGDataCollection.Instance.StartupMgData.getFirstTask().ClosingFormUI))
                    refResult.value = await dataviewmanager.Execute(cmd);
            }
            finally {
                this.task.TryingToCommit = false;
            }
            returnValue = true;
        }
        return returnValue;
    }
    HandelTransactionErrorHandlingsRetry(transBegin) {
        let task = this.task;
        if (task.Transaction === null && transBegin[0] === ConstInterface.TRANS_NONE) {
            task.TransactionErrorHandlingsRetry = new Transaction(task, task.getTaskTag());
            task.TransactionErrorHandlingsRetry.setTransBegin(ConstInterface.TRANS_RECORD_PREFIX);
            transBegin[0] = ConstInterface.TRANS_RECORD_PREFIX;
        }
    }
}

class DataviewManagerBase {
    constructor(task) {
        this.Task = null;
        this.Transaction = null;
        this.Task = task;
    }
    async Execute(command) {
        return new ReturnResult();
    }
    GetDbViewRowIdx() {
        return this.Task.DataView.getCurrDBViewRowIdx();
    }
}

class DataViewCommandBase {
    constructor() {
        this.DataviewManager = null;
    }
    async Execute() {
        return Promise.resolve(new ReturnResult());
    }
}

class RemoteDataViewCommandBase extends DataViewCommandBase {
    constructor(command) {
        super();
        this.Command = null;
        this.Task = null;
        this.Command = command;
        if (command instanceof ClientOriginatedCommandTaskTag) {
            this.Task = AccessHelper.mgDataTable.GetTaskByID(command.TaskTag);
        }
    }
    async Execute() {
        let cmdsToServer = this.Task.getMGData().CmdsToServer;
        cmdsToServer.Add(this.Command);
        await RemoteCommandsProcessor.GetInstance().Execute(CommandsProcessorBase_SendingInstruction.TASKS_AND_COMMANDS);
        return new ReturnResult();
    }
}

class DummyDataViewCommand extends RemoteDataViewCommandBase {
    constructor(command) {
        super(command);
    }
    async Execute() {
        return new ReturnResult();
    }
}

class RemoteDataViewCommandUpdateNonModifiable extends RemoteDataViewCommandBase {
    get execOperCommand() {
        return this.Command;
    }
    constructor(command) {
        super(command);
    }
    async Execute() {
        await this.execOperCommand.Operation.operServer(this.execOperCommand.MprgCreator);
        return new ReturnResult(MsgInterface.RT_STR_NON_MODIFIABLE);
    }
}

class SetTransactionStateRemoteDataViewCommand extends RemoteDataViewCommandBase {
    get dataviewCommand() {
        return this.Command;
    }
    constructor(command) {
        super(command);
    }
    async Execute() {
        if (this.Task !== null) {
            let transaction = this.Task.DataviewManager.RemoteDataviewManager.Transaction;
            if (transaction !== null) {
                transaction.Opened = this.dataviewCommand.TransactionIsOpen;
            }
        }
        return new ReturnResult();
    }
}

class AddUserRangeRemoteDataViewCommand extends RemoteDataViewCommandBase {
    constructor(command) {
        super(command);
        this.userRange = null;
        this.userRange = command.Range;
    }
    async Execute() {
        if (this.Task.UserRngs === null) {
            this.Task.UserRngs = new List();
        }
        this.Task.UserRngs.push(this.userRange);
        return new ReturnResult();
    }
}

class ResetUserRangeRemoteDataviewCommand extends RemoteDataViewCommandBase {
    constructor(command) {
        super(command);
    }
    async Execute() {
        this.Task.UserRngs = null;
        this.Task.ResetRange = true;
        return new ReturnResult();
    }
}

class AddUserLocateRemoteDataViewCommand extends RemoteDataViewCommandBase {
    constructor(command) {
        super(command);
        this.userRange = null;
        this.userRange = command.Range;
    }
    async Execute() {
        if (this.Task.UserLocs === null) {
            this.Task.UserLocs = new List();
        }
        this.Task.UserLocs.push(this.userRange);
        return new ReturnResult();
    }
}

class ResetUserLocateRemoteDataviewCommand extends RemoteDataViewCommandBase {
    constructor(command) {
        super(command);
    }
    async Execute() {
        let flag = this.Task.UserLocs !== null;
        if (flag) {
            this.Task.UserLocs.Clear();
            this.Task.UserLocs = null;
        }
        this.Task.ResetLocate = true;
        return new ReturnResult();
    }
}

class AddUserSortRemoteDataViewCommand extends RemoteDataViewCommandBase {
    constructor(command) {
        super(command);
        this.sort = null;
        this.sort = command.Sort;
    }
    async Execute() {
        if (this.Task.UserSorts === null) {
            this.Task.UserSorts = new List();
        }
        this.Task.UserSorts.push(this.sort);
        return new ReturnResult();
    }
}

class ResetUserSortRemoteDataviewCommand extends RemoteDataViewCommandBase {
    constructor(command) {
        super(command);
    }
    async Execute() {
        if (this.Task.UserSorts !== null) {
            this.Task.UserSorts.Clear();
            this.Task.UserSorts = null;
        }
        this.Task.ResetSort = true;
        return new ReturnResult();
    }
}

class ResultValue {
    constructor() {
        this.Value = null;
        this.Type = StorageAttribute.NONE;
    }
    SetResultValue(result, type) {
        this.Value = result;
        this.Type = type;
    }
}

class RemoteControlItemsRefreshCommand extends RemoteDataViewCommandBase {
    constructor(command) {
        super(command);
        this.control = null;
        this.control = command.Control;
    }
    async Execute() {
        let res = new ResultValue();
        let cmd = CommandFactory.CreatecFetchDataControlValuesCommand(this.Task.getTaskTag(), this.control.getName());
        this.Task.getMGData().CmdsToServer.Add(cmd);
        await RemoteCommandsProcessor.GetInstance().Execute_1(CommandsProcessorBase_SendingInstruction.TASKS_AND_COMMANDS, CommandsProcessorBase_SessionStage.NORMAL, res);
        for (let i = 0; i < this.Task.DataView.getSize(); i = i + 1) {
            this.Task.DataView.getRecByIdx(i).AddDcValuesReference(this.control.getDitIdx(), this.control.getDcRef());
        }
        this.Task.DataView.getOriginalRec().AddDcValuesReference(this.control.getDitIdx(), this.control.getDcRef());
        return new ReturnResult();
    }
}

class RemoteDataViewCommandFactory {
    CreateDataViewCommand(command) {
        let remoteDataViewCommandBase = new DummyDataViewCommand(command);
        let execOperCommand = ((command instanceof ExecOperCommand) ? command : null);
        if (execOperCommand !== null && execOperCommand.Operation !== null && execOperCommand.Operation.getType() === ConstInterface.MG_OPER_UPDATE) {
            remoteDataViewCommandBase = new RemoteDataViewCommandUpdateNonModifiable(execOperCommand);
        }
        else {
            if (!(command instanceof DataviewCommand)) {
                remoteDataViewCommandBase = new RemoteDataViewCommandBase(command);
            }
            else {
                let dataviewCommand = ((command instanceof DataviewCommand) ? command : null);
                switch (dataviewCommand.CommandType) {
                    case DataViewCommandType.SetTransactionState:
                        remoteDataViewCommandBase = new SetTransactionStateRemoteDataViewCommand(dataviewCommand);
                        break;
                    case DataViewCommandType.AddUserRange:
                        remoteDataViewCommandBase = new AddUserRangeRemoteDataViewCommand(command);
                        break;
                    case DataViewCommandType.ResetUserRange:
                        remoteDataViewCommandBase = new ResetUserRangeRemoteDataviewCommand(command);
                        break;
                    case DataViewCommandType.AddUserLocate:
                        remoteDataViewCommandBase = new AddUserLocateRemoteDataViewCommand(command);
                        break;
                    case DataViewCommandType.ResetUserLocate:
                        remoteDataViewCommandBase = new ResetUserLocateRemoteDataviewCommand(command);
                        break;
                    case DataViewCommandType.AddUserSort:
                        remoteDataViewCommandBase = new AddUserSortRemoteDataViewCommand(command);
                        break;
                    case DataViewCommandType.ResetUserSort:
                        remoteDataViewCommandBase = new ResetUserSortRemoteDataviewCommand(command);
                        break;
                    case DataViewCommandType.ControlItemsRefresh:
                        remoteDataViewCommandBase = new RemoteControlItemsRefreshCommand(command);
                        break;
                }
            }
        }
        return remoteDataViewCommandBase;
    }
    constructor() {
    }
}

class RemoteDataviewManager extends DataviewManagerBase {
    constructor(task) {
        super(task);
        this._remoteDataViewCommandFactory = null;
        this._remoteDataViewCommandFactory = new RemoteDataViewCommandFactory();
    }
    async Execute(command) {
        await super.Execute(command);
        let remoteDataViewCommandBase = this._remoteDataViewCommandFactory.CreateDataViewCommand(command);
        let innerResult = await remoteDataViewCommandBase.Execute();
        return new ReturnResult(innerResult);
    }
}

class DataviewManager extends DataviewManagerBase {
    get TaskService() {
        return this.Task.TaskService;
    }
    get CurrentDataviewManager() {
        let result;
        if (this.HasRemoteData)
            result = this.RemoteDataviewManager;
        else
            result = this.VirtualDataviewManager;
        return result;
    }
    get VirtualDataviewManager() {
        return this.TaskService.GetDataviewManagerForVirtuals(this.Task);
    }
    constructor(task) {
        super(task);
        this.RemoteDataviewManager = null;
        this.HasRemoteData = true;
        this.RemoteDataviewManager = new RemoteDataviewManager(task);
    }
    async Execute(command) {
        return await this.CurrentDataviewManager.Execute(command);
    }
}

class Sort {
    constructor() {
        this.fldIdx = 0;
        this.dir = false;
    }
}

class SortCollection {
    constructor() {
        this._sortTab = null;
        this._sortTab = new List();
    }
    fillData(parser) {
        while (this.initInnerObjects(parser, parser.getNextTag())) {
        }
    }
    initInnerObjects(parser, foundTagName) {
        if (foundTagName === null)
            return false;
        switch (foundTagName) {
            case ConstInterface.MG_TAG_SORTS:
                parser.setCurrIndex(parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex()) + 1);
                break;
            case ConstInterface.MG_TAG_SORT:
                {
                    let sort = new Sort();
                    this._sortTab.push(sort);
                    let endContext = parser.getXMLdata().indexOf(XMLConstants.TAG_TERM, parser.getCurrIndex());
                    if (endContext !== -1 && endContext < parser.getXMLdata().length) {
                        let tag = parser.getXMLsubstring(endContext);
                        parser.add2CurrIndex(tag.indexOf(ConstInterface.MG_TAG_SORT) + ConstInterface.MG_TAG_SORT.length);
                        let tokensVector = new List(XmlParser.getTokens(parser.getXMLsubstring(endContext), XMLConstants.XML_ATTR_DELIM).GetEnumerator());
                        this.InitElements(tokensVector, sort);
                        parser.setCurrIndex(endContext + XMLConstants.TAG_TERM.length);
                    }
                }
                break;
            case ConstInterface.MG_TAG_SORTS_END:
                parser.setCurrIndex2EndOfTag();
                return false;
        }
        return true;
    }
    InitElements(tokensVector, sort) {
        for (let j = 0; j < tokensVector.length; j += 2) {
            let attribute = (tokensVector.get_Item(j));
            let valueStr = (tokensVector.get_Item(j + 1));
            switch (attribute) {
                case XMLConstants.MG_ATTR_ID:
                    sort.fldIdx = XmlParser.getInt(valueStr);
                    break;
                case ConstInterface.MG_ATTR_DIR:
                    sort.dir = valueStr === "A";
                    break;
                default:
                    Logger.Instance.WriteExceptionToLogWithMsg(NString.Format("Unrecognized attribute: '{0}'", attribute));
                    break;
            }
        }
    }
    getSize() {
        if (this._sortTab === null)
            return 0;
        return this._sortTab.length;
    }
    add(sort) {
        this._sortTab.push(sort);
    }
}

class CreatedFormVector {
    constructor() {
        this._createdFormVec = null;
        this._createdFormVec = new List();
    }
    add(mgForm) {
        this._createdFormVec.push(mgForm);
    }
    remove(mgForm) {
        this._createdFormVec.Remove(mgForm);
    }
    Count() {
        return this._createdFormVec.length;
    }
    Clear() {
        this._createdFormVec.Clear();
    }
    get(index) {
        return this._createdFormVec.get_Item(index);
    }
}

class MgForm extends MgFormBase {
    constructor() {
        super();
        this.IsMovingInView = false;
        this.PrevDisplayLine = 0;
        this.RefreshAllRows = false;
        this.IgnoreFirstRecordCycle = false;
        this.MovedToFirstControl = false;
        this._suffixDone = false;
        this.hiddenControlsIsnsList = null;
        this._transferringDataToGUI = false;
        this.isFetchingRecordsAhead = false;
    }
    static get CreatedForms() {
        return MgForm._createdForms;
    }
    get InRestore() {
        return this._inRestore;
    }
    get TransferringDataToGUI() {
        return this._transferringDataToGUI;
    }
    get shouldFetchRecordsAheadFromServer() {
        if (this.isTableWithPagination()) {
            let prop = this._tableMgControl.GetComputedProperty(PropInterface.PROP_TYPE_SERVER_READ_AHEAD);
            return (prop != null ? prop.GetComputedValueBoolean() : false);
        }
        else
            return false;
    }
    async FetchRecordsAheadFromServer() {
        this.isFetchingRecordsAhead = true;
        await this.GetDataview().FetchRecordsAheadFromServer();
        this.isFetchingRecordsAhead = false;
    }
    GetDataview() {
        let dv = null;
        if (this._task != null)
            dv = this._task.DataView;
        return (dv);
    }
    async moveInView(unit, direction) {
        let oldRecId = Int32.MinValue;
        let currRec = this.GetDataview().getCurrRec();
        let oldTaskMode = ' ';
        let returnToVisibleLine = false;
        let recordOutOfView = false;
        let visibleLine = 0;
        try {
            this.IsMovingInView = true;
            let oldDisplayLine = this.DisplayLine;
            if (unit === Constants.MOVE_UNIT_TABLE) {
                try {
                    if (direction === Constants.MOVE_DIRECTION_BEGIN) {
                        await this.GetDataview().setCurrRecByIdx(Constants.MG_DATAVIEW_FIRST_RECORD, true, false, true, SET_DISPLAYLINE_BY_DV);
                        if (this.isLineMode()) {
                            this.GetDataview().setTopRecIdx(0);
                            await this.setCurrRowByDisplayLine(0, false, false);
                        }
                    }
                    else {
                        await this.GetDataview().setCurrRecByIdx(Constants.MG_DATAVIEW_LAST_RECORD, true, false, true, SET_DISPLAYLINE_BY_DV);
                        if (this.isLineMode()) {
                            this.GetDataview().setTopRecIdx(this.GetDataview().getCurrRecIdx() - this._rowsInPage + 1);
                            if (this.GetDataview().getTopRecIdx() >= 0)
                                await this.setCurrRowByDisplayLine(this.GetDataview().getCurrRecIdx(), false, false);
                            else {
                                this.GetDataview().setTopRecIdx(0);
                                await this.setCurrRowByDisplayLine(this.GetDataview().getCurrRecIdx(), false, false);
                            }
                        }
                    }
                    this.updateDisplayLineByDV();
                    await this.RefreshDisplay(Constants.TASK_REFRESH_FORM);
                }
                catch (ex) {
                    if (ex instanceof RecordOutOfDataViewException)
                        Logger.Instance.WriteDevToLog(ex.Message);
                }
            }
            else {
                this.getTopIndexFromGUI();
                let size;
                if (unit === Constants.MOVE_UNIT_PAGE && this.isLineMode()) {
                    switch (direction) {
                        case Constants.MOVE_DIRECTION_BEGIN:
                            size = this.GetDataview().getCurrRecIdx() - this.GetDataview().getTopRecIdx();
                            break;
                        case Constants.MOVE_DIRECTION_END:
                            let last = this.GetDataview().getTopRecIdx() + this._rowsInPage - 1;
                            last = Math.min(last, this.GetDataview().getSize() - 1);
                            size = last - this.GetDataview().getCurrRecIdx();
                            break;
                        default:
                            returnToVisibleLine = true;
                            size = this._rowsInPage;
                            break;
                    }
                }
                else
                    size = 1;
                size = (direction === Constants.MOVE_DIRECTION_PREV ||
                    direction === Constants.MOVE_DIRECTION_BEGIN
                    ? -size
                    : size);
                if (this.isLineMode()) {
                    visibleLine = this.getVisibleLine();
                    if (visibleLine < 0) {
                        visibleLine = 0;
                        recordOutOfView = true;
                    }
                    if (visibleLine > this._rowsInPage + 1) {
                        visibleLine = this._rowsInPage;
                        recordOutOfView = true;
                    }
                    if (unit === Constants.MOVE_UNIT_PAGE &&
                        (direction === Constants.MOVE_DIRECTION_NEXT ||
                            direction === Constants.MOVE_DIRECTION_PREV) ||
                        unit === Constants.MOVE_UNIT_ROW &&
                            (direction === Constants.MOVE_DIRECTION_NEXT && visibleLine === this._rowsInPage - 1 ||
                                direction === Constants.MOVE_DIRECTION_PREV && visibleLine === 0)) {
                        if (direction === Constants.MOVE_DIRECTION_PREV &&
                            (unit === Constants.MOVE_UNIT_ROW || unit === Constants.MOVE_UNIT_PAGE) &&
                            visibleLine === 0 && this.GetDataview().getCurrRecIdx() === 0 && this.GetDataview().IncludesFirst())
                            return;
                        if (direction === Constants.MOVE_DIRECTION_NEXT && unit === Constants.MOVE_UNIT_PAGE &&
                            visibleLine === this.getLastValidRow() && this.GetDataview().getCurrRecIdx() === this.GetDataview().getSize() - 1 && this.GetDataview().IncludesLast())
                            return;
                        oldRecId = (this.GetDataview().getCurrRec()).getId();
                        this.GetDataview().setTopRecIdx(this.GetDataview().getTopRecIdx() + size);
                        this.GetDataview().setTopRecIdxModified(true);
                        try {
                            this._suffixDone = false;
                            await this.setCurrRowByDisplayLine(this.GetDataview().getCurrRecIdx() + size, true, false);
                            this.GetDataview().setTopRecIdxModified(false);
                            await this.RefreshDisplay(Constants.TASK_REFRESH_FORM);
                        }
                        catch (ex) {
                            if (ex instanceof RecordOutOfDataViewException) {
                                this.GetDataview().setTopRecIdxModified(false);
                                if (AccessHelper.eventsManager.GetStopExecutionFlag()) {
                                    this.GetDataview().restoreTopRecIdx();
                                    await this.restoreOldDisplayLine(oldDisplayLine);
                                    return;
                                }
                                if (this.GetDataview().getTopRecIdx() < 0) {
                                    this.GetDataview().setTopRecIdx(0);
                                    try {
                                        await this.setCurrRowByDisplayLine(0, true, false);
                                    }
                                    catch (exception) {
                                        if (exception instanceof Exception) {
                                            if (AccessHelper.eventsManager.GetStopExecutionFlag()) {
                                                this.GetDataview().restoreTopRecIdx();
                                                await this.restoreOldDisplayLine(oldDisplayLine);
                                                return;
                                            }
                                        }
                                    }
                                    await this.RefreshDisplay(Constants.TASK_REFRESH_FORM);
                                }
                                else if (unit !== Constants.MOVE_UNIT_ROW && this.GetDataview().recExists(this.GetDataview().getTopRecIdx())) {
                                    let newRecId = (this.GetDataview().getCurrRec()).getId();
                                    if (newRecId === oldRecId && !this._suffixDone) {
                                        await AccessHelper.eventsManager.handleInternalEventWithTask(this._task, InternalInterface.MG_ACT_REC_SUFFIX);
                                        if (AccessHelper.eventsManager.GetStopExecutionFlag()) {
                                            this.GetDataview().restoreTopRecIdx();
                                            await this.restoreOldDisplayLine(oldDisplayLine);
                                            return;
                                        }
                                        try {
                                            await this.RefreshDisplay(Constants.TASK_REFRESH_FORM);
                                            await this.setCurrRowByDisplayLine(this.GetDataview().getTopRecIdx() + this.getLastValidRow(), false, true);
                                            visibleLine = this.getLastValidRow();
                                        }
                                        catch (Exception) {
                                        }
                                    }
                                }
                                else {
                                    this.GetDataview().restoreTopRecIdx();
                                    await this.restoreOldDisplayLine(oldDisplayLine);
                                    if (unit === Constants.MOVE_UNIT_ROW && direction === Constants.MOVE_DIRECTION_NEXT) {
                                        if (!this._task.IsInteractive && this._task.getMode() !== Constants.TASK_MODE_CREATE)
                                            this._task.setExecEndTask();
                                        else
                                            await AccessHelper.eventsManager.handleInternalEventWithTask(this._task, InternalInterface.MG_ACT_CRELINE);
                                    }
                                    return;
                                }
                                Logger.Instance.WriteDevToLog(ex.Message);
                            }
                        }
                    }
                    else {
                        try {
                            oldTaskMode = this._task.getMode();
                            oldRecId = (this.GetDataview().getCurrRec()).getId();
                            await this.setCurrRowByDisplayLine(oldDisplayLine + size, true, false);
                            if (!this.GetDataview().recExistsById(oldRecId)) {
                                if (size > 0 || oldTaskMode !== Constants.TASK_MODE_CREATE)
                                    if (size !== -1 || this.GetDataview().recExists(oldDisplayLine))
                                        await this.setCurrRowByDisplayLine(oldDisplayLine, false, false);
                                    else
                                        Logger.Instance.WriteDevToLog(NString.Format("skipped setcurrRow for row {0}", oldDisplayLine));
                                await this.RefreshDisplay(Constants.TASK_REFRESH_FORM);
                            }
                            else if (AccessHelper.eventsManager.GetStopExecutionFlag()) {
                                await this.RefreshDisplay(Constants.TASK_REFRESH_CURR_REC);
                            }
                        }
                        catch (ex) {
                            if (ex instanceof RecordOutOfDataViewException) {
                                if (this.GetDataview().recExistsById(oldRecId)) {
                                    await this.restoreOldDisplayLine(oldDisplayLine);
                                    if (!currRec.Synced && oldTaskMode === Constants.TASK_MODE_CREATE) {
                                        this._task.setMode(Constants.TASK_MODE_CREATE);
                                        currRec.clearMode();
                                        currRec.setMode(DataModificationTypes.Insert);
                                        currRec.setNewRec();
                                    }
                                    await this.RefreshDisplay(Constants.TASK_REFRESH_CURR_REC);
                                }
                                else {
                                    if (oldTaskMode === Constants.TASK_MODE_CREATE && oldDisplayLine > 0)
                                        await this.restoreOldDisplayLine(oldDisplayLine - 1);
                                    await this.RefreshDisplay(Constants.TASK_REFRESH_FORM);
                                }
                                if (size <= 0 || AccessHelper.eventsManager.GetStopExecutionFlag())
                                    Logger.Instance.WriteDevToLog(ex.Message);
                                else {
                                    if (!this._task.IsInteractive && this._task.getMode() !== Constants.TASK_MODE_CREATE) {
                                        this._task.setExecEndTask();
                                        return;
                                    }
                                    else {
                                        if (this._task.ActionManager.isEnabled(InternalInterface.MG_ACT_CRELINE))
                                            await AccessHelper.eventsManager.handleInternalEventWithTask(this._task, InternalInterface.MG_ACT_CRELINE);
                                        else {
                                            let doRecordSuffix = true;
                                            let refdoRecordSuffix = new RefParam(doRecordSuffix);
                                            if (!await AccessHelper.eventsManager.DoTaskLevelRecordSuffix(this._task, refdoRecordSuffix))
                                                await AccessHelper.eventsManager.DoTaskLevelRecordPrefix(this._task);
                                            doRecordSuffix = refdoRecordSuffix.value;
                                        }
                                    }
                                }
                                return;
                            }
                        }
                    }
                }
                else {
                    try {
                        await this.GetDataview().setCurrRecByIdx(this.GetDataview().getCurrRecIdx() + size, true, false, true, SET_DISPLAYLINE_BY_DV);
                        await this.RefreshDisplay(Constants.TASK_REFRESH_FORM);
                    }
                    catch (ex) {
                        if (ex instanceof RecordOutOfDataViewException) {
                            if (size > 0) {
                                if (!this._task.IsInteractive && this._task.getMode() !== Constants.TASK_MODE_CREATE)
                                    this._task.setExecEndTask();
                                else
                                    await AccessHelper.eventsManager.handleInternalEventWithTask(this._task, InternalInterface.MG_ACT_CRELINE);
                            }
                            else
                                Logger.Instance.WriteDevToLog(ex.Message);
                            return;
                        }
                        else if (ex instanceof ServerError) {
                            await this._task.stop();
                            this._task.abort();
                            await AccessHelper.eventsManager.ProcessAbortingError(ex);
                        }
                        else if (ex instanceof Exception) {
                            Logger.Instance.WriteDevToLog(ex.Message);
                            return;
                        }
                    }
                }
            }
            if (returnToVisibleLine) {
                if (recordOutOfView) {
                    if (visibleLine === 0)
                        this.GetDataview().setTopRecIdx(this.GetDataview().getCurrRecIdx());
                    else
                        this.GetDataview().setTopRecIdx(this.GetDataview().getCurrRecIdx() - this._rowsInPage);
                    this.SetTableTopIndex();
                }
                else {
                    this.SetTableTopIndex();
                    await this.setCurrRowByDisplayLine(this.GetDataview().getTopRecIdx() + visibleLine, false, true);
                }
            }
            else
                this.SetTableTopIndex();
            await AccessHelper.eventsManager.handleInternalEventWithTask(this._task, InternalInterface.MG_ACT_REC_PREFIX);
        }
        catch (e) {
            if (e instanceof RecordOutOfDataViewException) {
                Logger.Instance.WriteDevToLog(e.Message);
            }
        }
        finally {
            this.SelectRow();
            this.IsMovingInView = false;
        }
    }
    async addRec(doSuffix, isCrelineAbove) {
        let newLine = 1;
        let currLine = -1;
        if (!this._task.DataView.isEmptyDataview())
            currLine = this.getVisibleLine();
        if (this.isTableWithAbsoluteScrollbar()) {
            this.GetDataview().TotalRecordsCount += 1;
            this.RefreshAllRows = true;
        }
        let newRecIdx = await this.GetDataview().addRecord(doSuffix, false, isCrelineAbove);
        if (newRecIdx > -1) {
            if (this.isLineMode()) {
                let newCurrRow;
                if (this.GetDataview().getSize() === 0 || this.GetDataview().getTopRecIdx() === Int32.MinValue) {
                    this.GetDataview().setTopRecIdx(0);
                    newCurrRow = 0;
                }
                else if (currLine === this._rowsInPage - 1) {
                    this.GetDataview().setTopRecIdx(this.GetDataview().getTopRecIdx() + 1);
                    newCurrRow = this.getVisibleLine();
                }
                else {
                    if (isCrelineAbove)
                        newCurrRow = currLine > 0 ? currLine : 0;
                    else
                        newCurrRow = currLine + 1;
                }
                newLine = this.GetDataview().getTopRecIdx() + newCurrRow;
                this.removeRecordsAfterIdx(this.GetDataview().getTopRecIdx() + newCurrRow);
                try {
                    if (!this._task.DataView.isEmptyDataview())
                        this._task.setMode(Constants.TASK_MODE_CREATE);
                    await this.setCurrRowByDisplayLine(newLine, false, false);
                }
                catch (ex) {
                    if (ex instanceof RecordOutOfDataViewException) {
                        Logger.Instance.WriteDevToLog(NString.Format("in Form.addRec() {0}", ex.Message));
                    }
                }
                await this.RefreshDisplay(Constants.TASK_REFRESH_TABLE);
            }
        }
        else if (this.isTableWithAbsoluteScrollbar()) {
            this.GetDataview().TotalRecordsCount -= 1;
            this.RefreshAllRows = false;
        }
    }
    async delCurrRec() {
        let topTableRow = super.isLineMode() && this.GetDataview().getTopRecIdx() === this.GetDataview().getCurrRecIdx();
        await this.GetDataview().removeCurrRec();
        if (this.GetDataview().isEmpty() && !this._task.IsTryingToStop) {
            if (this._task.DataView.isEmptyDataview()) {
                await this.addRec(false, false);
            }
            else {
                if (await this._task.checkProp(PropInterface.PROP_TYPE_ALLOW_CREATE, true)) {
                    if (this._task.getMode() !== Constants.TASK_MODE_CREATE)
                        this._task.setMode(Constants.TASK_MODE_CREATE);
                    this._task.enableCreateActs(true);
                    await AccessHelper.eventsManager.handleInternalEventWithTask(this._task, InternalInterface.MG_ACT_CRELINE);
                }
                else
                    await AccessHelper.eventsManager.handleInternalEventWithTask(this._task, InternalInterface.MG_ACT_EXIT);
            }
        }
        if (!this.GetDataview().isEmpty()) {
            if (topTableRow)
                this.GetDataview().setTopRecIdx(this.GetDataview().getCurrRecIdx());
            if (super.isLineMode()) {
                if (super.HasTable()) {
                    if (this.isTableWithAbsoluteScrollbar()) {
                        this.GetDataview().TotalRecordsCount--;
                        this.RefreshAllRows = true;
                    }
                    this.removeRecordsAfterIdx(this.GetDataview().getCurrRecIdx());
                    await this.RefreshDisplay(Constants.TASK_REFRESH_FORM);
                }
                else
                    await this.RefreshDisplay(Constants.TASK_REFRESH_CURR_REC);
            }
            else {
                try {
                    await this.GetDataview().setCurrRecByIdx(this.GetDataview().getCurrRecIdx(), true, true, true, SET_DISPLAYLINE_BY_DV);
                }
                catch (ex) {
                    if (ex instanceof RecordOutOfDataViewException) {
                    }
                    else
                        throw ex;
                }
                await this.RefreshDisplay(Constants.TASK_REFRESH_CURR_REC);
            }
        }
    }
    async cancelEdit(isActCancel, isQuitEvent) {
        let mode = this._task.getMode();
        let newMode;
        let row = 0;
        let execRecPrefix = false;
        if (this.GetDataview().getSize() === 1 && mode === Constants.TASK_MODE_CREATE)
            newMode = Constants.TASK_MODE_CREATE;
        else
            newMode = Constants.TASK_MODE_MODIFY;
        let recRemoved = await this.GetDataview().cancelEdit(false, false);
        this.GetDataview().setPrevCurrRec(null);
        if ((this.GetDataview().isEmpty() || ((isActCancel && recRemoved) && (!GuiEnvironment.Environment.GetSpecialCancelOnCreate()) && this._task.getOriginalTaskMode() === Constants.TASK_MODE_CREATE)) && !this._task.IsTryingToStop) {
            let orgCancelWasRaised = this._task.cancelWasRaised();
            this._task.setCancelWasRaised(isActCancel);
            await AccessHelper.eventsManager.handleInternalEventWithTask(this._task, InternalInterface.MG_ACT_CRELINE);
            this._task.setCancelWasRaised(orgCancelWasRaised);
        }
        else if (isActCancel)
            execRecPrefix = true;
        if (!this.GetDataview().isEmpty()) {
            if (super.isLineMode()) {
                try {
                    if (super.HasTable()) {
                        row = this.getVisibleLine();
                        if (row < 0 || row >= this._rowsInPage) {
                            let topRecIdx = this.GetDataview().getTopRecIdx();
                            let currRecIdx = this.GetDataview().getCurrRecIdx();
                            if (topRecIdx > currRecIdx)
                                this.GetDataview().setTopRecIdx(currRecIdx);
                            row = 0;
                        }
                        await this.setCurrRowByDisplayLine(this.GetDataview().getTopRecIdx() + row, false, true);
                    }
                }
                catch (ex) {
                    if (ex instanceof RecordOutOfDataViewException) {
                        if (row !== 0)
                            Logger.Instance.WriteDevToLog(NString.Format("in Form.cancelEdit() {0}", ex.Message));
                    }
                    else
                        throw ex;
                }
                if (super.HasTable()) {
                    if (this.isTableWithAbsoluteScrollbar() && recRemoved) {
                        this.GetDataview().TotalRecordsCount--;
                        this.RefreshAllRows = true;
                    }
                    this.removeRecordsAfterIdx(this.GetDataview().getCurrRecIdx());
                }
            }
            else {
                try {
                    await this.GetDataview().setCurrRecByIdx(this.GetDataview().getCurrRecIdx(), false, true, true, SET_DISPLAYLINE_BY_DV);
                }
                catch (ex) {
                    if (ex instanceof RecordOutOfDataViewException) {
                        Logger.Instance.WriteDevToLog("in Form.cancelEdit() error in Screen mode for Current Record");
                    }
                    else
                        throw ex;
                }
            }
            this._task.setMode(newMode);
            if (!this._task.InEndTask)
                await this.RefreshDisplay(Constants.TASK_REFRESH_FORM);
            if (!this._task.InEndTask)
                await this.RefreshDisplay(Constants.TASK_REFRESH_CURR_REC);
        }
        if (execRecPrefix) {
            this._task.setLevel(Constants.TASK_LEVEL_TASK);
            let lastParkedCtrl = LastFocusedManager.getLastFocusedControl();
            if (lastParkedCtrl !== null) {
                if (lastParkedCtrl.getForm().getTask().pathContains(this._task))
                    for (let parent = lastParkedCtrl.getForm().getTask(); parent !== null && parent !== this._task; parent = parent.getParent()) {
                        parent.setLevel(Constants.TASK_LEVEL_TASK);
                        (parent.DataView.getCurrRec()).resetModified();
                    }
                else
                    lastParkedCtrl.getForm().getTask().setLevel(Constants.TASK_LEVEL_TASK);
            }
            if (!isQuitEvent) {
                await AccessHelper.eventsManager.handleInternalEventWithTask(this._task, InternalInterface.MG_ACT_REC_PREFIX);
                await AccessHelper.eventsManager.HandleParkabilityOnRowChange(this._task);
            }
        }
    }
    async refreshOnExpressions() {
        for (let i = 0; i < this.CtrlTab.getSize(); i = i + 1) {
            let mgControl = ((this.CtrlTab.getCtrl(i) instanceof MgControl) ? this.CtrlTab.getCtrl(i) : null);
            if (mgControl != null)
                await mgControl.refreshOnExpression();
            else
                Debug.Assert(false);
        }
        await super.refreshPropsOnExpression();
    }
    removeRefsToCtrls() {
        let lastFocusedControl = LastFocusedManager.getLastFocusedControl();
        if (lastFocusedControl !== null && lastFocusedControl.getForm() === this)
            LastFocusedManager.setLastFocusedControl(this._task, null);
        super.removeRefsToCtrls();
    }
    getCtrlByCtrlName(ctrlName) {
        return this.CtrlTab.getCtrl(ctrlName);
    }
    getSubFormCtrlByName(ctrlName) {
        let guiParentTask;
        let destSubForm = null;
        for (guiParentTask = this._task; destSubForm === null && guiParentTask !== null && guiParentTask.getForm() !== null; guiParentTask = guiParentTask.getParent()) {
            destSubForm = guiParentTask.getForm().getCtrlByName(ctrlName, MgControlType.CTRL_TYPE_SUBFORM);
            if (destSubForm == null) {
                if (!guiParentTask.IsSubForm || NString.Equals(guiParentTask.getForm().getSubFormCtrl().Name, ctrlName, true))
                    break;
            }
        }
        return destSubForm;
    }
    setSuffixDone() {
        this._suffixDone = true;
    }
    getDestinationRow() {
        return this._destTblRow;
    }
    setSubFormCtrl(subFormCtrl) {
        Debug.Assert(this._subFormCtrl === null && subFormCtrl !== null);
        this._subFormCtrl = subFormCtrl;
    }
    getSubFormCtrlForTask(taskId) {
        let curr = null;
        let parentCtrlTab;
        let guiParentForm = null;
        let destSubForm = null;
        for (guiParentForm = this; guiParentForm != null; guiParentForm = guiParentForm.ParentForm) {
            parentCtrlTab = guiParentForm.CtrlTab;
            for (let i = 0; i < parentCtrlTab.getSize(); i++) {
                curr = ((parentCtrlTab.getCtrl(i) instanceof MgControl) ? parentCtrlTab.getCtrl(i) : null);
                if (curr != null && curr.isSubform() && (curr.getSubformTaskId() != null))
                    if (curr.getSubformTaskId() === taskId) {
                        destSubForm = curr;
                        break;
                    }
            }
            if (destSubForm != null)
                break;
        }
        return destSubForm;
    }
    removeRecordsAfterIdx(idx) {
        let removeAll = false;
        if (this.isTableWithPagination())
            this.setTableItemsCount(false);
        else {
            if (idx <= this._rowsInPage + 1 && this.GetDataview().getSize() > this._rowsInPage)
                idx = 0;
            if (idx === 0)
                removeAll = true;
            super.SetTableItemsCount(idx, removeAll);
            this.setTableItemsCount(false);
        }
    }
    isRowValidated(idx) {
        if (this.Rows.length <= idx || idx < 0)
            return false;
        let row = this.Rows.get_Item(idx);
        if (row == null)
            return false;
        return row.Created && row.Validated;
    }
    async transferDataToGui() {
        let saveRowIdx = this.GetDataview().getCurrRecIdx();
        let maxTime = Misc.getSystemMilliseconds() + MgForm.TIME_LIMIT;
        let updated = false;
        let currentEditingControl = super.getTask().CurrentEditingControl;
        try {
            let bkpRecord = this.GetDataview().backupCurrent();
            while (Misc.getSystemMilliseconds() < maxTime && this.RefreshRepeatableAllowed) {
                if (this._lastRowSent + 1 >= this.GetDataview().getSize()) {
                    this.RefreshUI();
                    break;
                }
                else if (this.isTableWithPagination() && this._lastRowSent + 1 >= this.getMaxRowsInPaginatedTable()) {
                    this.RefreshUI();
                    break;
                }
                this._lastRowSent++;
                this._transferringDataToGUI = true;
                this.AllowedSubformRecompute = false;
                if (!this.isRowValidated(this._lastRowSent)) {
                    super.checkAndCreateRow(this._lastRowSent);
                    if (this._lastRowSent !== saveRowIdx) {
                        super.getTask().CurrentEditingControl = null;
                        await this.setCurrRowByDisplayLine(this._lastRowSent, false, true);
                        await super.refreshControls(true);
                        updated = true;
                    }
                }
                this.AllowedSubformRecompute = true;
                this._transferringDataToGUI = false;
            }
            if (updated) {
                await this.restoreBackup(saveRowIdx, bkpRecord);
                await super.refreshControls(true);
                super.getTask().CurrentEditingControl = currentEditingControl;
            }
        }
        catch (ex) {
            if (ex instanceof RecordOutOfDataViewException) {
                Logger.Instance.WriteDevToLog(ex.Message);
            }
            else
                throw ex;
        }
        this._transferingData = false;
        this.checkAndCreateRowsEvent();
    }
    checkAndCreateRowsEvent() {
        if (this._tableMgControl !== null && this.Opened && this.RefreshRepeatableAllowed) {
            let size = this.GetDataview().getSize();
            if (this._lastRowSent >= this.Rows.length) {
                this._lastRowSent = this.Rows.length - 1;
            }
            let transferDataToGui = this._lastRowSent < (size - 1);
            if (this.isTableWithPagination() && (this._lastRowSent + 1) >= this.getMaxRowsInPaginatedTable())
                transferDataToGui = false;
            if (transferDataToGui && !this._transferingData) {
                AccessHelper.eventsManager.addInternalEventWithCtrlAndCodeAndPriority(this._tableMgControl, InternalInterface.MG_ACT_DV_TO_GUI, Priority.LOWEST);
                this._transferingData = true;
            }
            else if (this.shouldFetchRecordsAheadFromServer && !transferDataToGui && (!this.GetDataview().IncludesLast() || !this.GetDataview().IncludesFirst())) {
                AccessHelper.eventsManager.addInternalEventWithCtrlAndCodeAndPriority(this._tableMgControl, InternalInterface.MG_ACT_FETCH_RECORDS_AHEAD_FROM_SERVER, Priority.LOWEST);
            }
        }
    }
    async setRowData(desiredTopIndex, sendAll) {
        let saveRowIdx = this.GetDataview().getCurrRecIdx();
        let diff = 0;
        let getPrevChunk = false;
        let getNextChunk = false;
        let updated = false;
        if (desiredTopIndex !== Int32.MinValue) {
            if (desiredTopIndex < 0) {
                getPrevChunk = true;
                this.GetDataview().setTopRecIdx(0);
            }
            else if (desiredTopIndex + this._rowsInPage + 1 >= this.GetDataview().getSize())
                getNextChunk = true;
        }
        else
            desiredTopIndex = this.GetDataview().getTopRecIdx();
        let bkpRecord = this.GetDataview().backupCurrent();
        this._transferringDataToGUI = true;
        this.AllowedSubformRecompute = false;
        let diffRef = new RefParam(diff);
        updated = await this.refreshRows(desiredTopIndex, sendAll, saveRowIdx, diffRef);
        diff = diffRef.value;
        if ((getPrevChunk && diff !== 0) || getNextChunk) {
            this.GetDataview().setTopRecIdx(desiredTopIndex + diff);
            this.SetTableTopIndex();
            if (this._topIndexUpdated) {
                this._topIndexUpdated = false;
            }
        }
        this.AllowedSubformRecompute = true;
        this._transferringDataToGUI = false;
        if (updated) {
            await this.restoreBackup(saveRowIdx + diff, bkpRecord);
            await super.refreshControls(true);
        }
        super.SelectRow();
        if (getPrevChunk) {
            let lastFocusedControl = LastFocusedManager.getLastFocusedControl();
            if (lastFocusedControl !== null && lastFocusedControl.getParentTable() === this._tableMgControl) {
            }
        }
    }
    async refreshRows(desiredTopIndex, sendAll, saveRowIdx, diffRef) {
        let index = 0;
        let updated = false;
        diffRef.value = 0;
        let orgIncludesFirst = this.GetDataview().IncludesFirst();
        let orgIncludesLast = this.GetDataview().IncludesLast();
        for (let i = 0; i < this._rowsInPage; i++) {
            let idx = desiredTopIndex + i;
            let prevTopIdx = this.GetDataview().getTopRecIdx();
            try {
                index = idx + diffRef.value;
                if (!this.isRowValidated(idx) || sendAll || this.RefreshAllRows) {
                    if (index >= 0)
                        super.checkAndCreateRow(index);
                    if (saveRowIdx + diffRef.value !== index) {
                        await this.setCurrRowByDisplayLine(index, false, true);
                        await super.refreshControls(true);
                    }
                    updated = true;
                }
            }
            catch (ex) {
                if (ex instanceof RecordOutOfDataViewException) {
                    if (super.isRowCreated(index))
                        super.markRowNOTCreated(index);
                    break;
                }
                else
                    throw ex;
            }
            finally {
                diffRef.value = diffRef.value + (this.GetDataview().getTopRecIdx() - prevTopIdx);
                prevTopIdx = this.GetDataview().getTopRecIdx();
                if (!updated && this.GetDataview().DataviewBoundriesAreChanged(orgIncludesFirst, orgIncludesLast))
                    updated = true;
            }
        }
        this.RefreshUI();
        this.RefreshAllRows = false;
        return updated;
    }
    getVisibleLine() {
        let currRecIdx = 0;
        if (this.GetDataview().getCurrRecIdx() !== Int32.MinValue)
            currRecIdx = this.GetDataview().getCurrRecIdx();
        return currRecIdx - Math.max(this.GetDataview().getTopRecIdx(), 0);
    }
    async bringRecordToPage() {
        if (this._tableMgControl !== null && !this._task.DataView.isEmptyDataview()) {
            let topIndex = Commands.getTopIndex(this._tableMgControl);
            let currIdx = this.GetDataview().getCurrRecIdx();
            let newTopIndex = topIndex;
            if (!this.isTableWithPagination()) {
                if (topIndex > currIdx) {
                    this._topIndexUpdated = true;
                    newTopIndex = currIdx;
                }
                else if (topIndex + this._rowsInPage - 1 < currIdx) {
                    this._topIndexUpdated = true;
                    if (this._rowsInPage > 0)
                        newTopIndex = currIdx - this._rowsInPage + 1;
                    else
                        newTopIndex = currIdx;
                }
            }
            else {
                let currGuiIdx = this.getGuiRowidx(currIdx);
                let newTopGuiIndex = (currGuiIdx) - ((currGuiIdx) % this._rowsInPage);
                newTopIndex = this.getDvRowIdx(newTopGuiIndex);
                if (newTopIndex !== this._prevGuiTopIndex || this.IsMovingInView)
                    this._topIndexUpdated = true;
            }
            if (this.GetDataview().getTopRecIdx() !== newTopIndex || this._topIndexUpdated) {
                this.GetDataview().setTopRecIdx(newTopIndex);
                this.SetTableTopIndex();
                await this.setRowData(Int32.MinValue, false);
                this._topIndexUpdated = false;
            }
        }
    }
    invalidateTable() {
        for (let i = 0; i < this.Rows.length; i++) {
            let row = this.Rows.get_Item(i);
            if (row !== null)
                row.Validated = false;
        }
        this._lastRowSent = -1;
        this.checkAndCreateRowsEvent();
    }
    getPrevLine(line) {
        return line - 1;
    }
    clearTableColumnSortMark(clearSortMark) {
        if (clearSortMark) {
        }
    }
    async stopRowEditing(idx) {
        if (this.getIsRowEditingFromGui(idx)) {
            Commands.addValueWithLine(CommandType.SET_NOT_IS_ROW_EDITING, this, this.isLineMode() ? idx : 0, this.isLineMode());
            await this.RefreshDisplay(Constants.TASK_REFRESH_CURR_REC);
            Commands.addNoParameters(CommandType.REFRESH_TASK, this.getForm());
        }
    }
    async startRowEditing(idx) {
        if (!this.getIsRowEditingFromGui(idx)) {
            Commands.addValueWithLine(CommandType.SET_IS_ROW_EDITING, this, this.isLineMode() ? idx : 0, this.isLineMode());
            await this.RefreshDisplay(Constants.TASK_REFRESH_CURR_REC);
            Commands.addNoParameters(CommandType.REFRESH_TASK, this.getForm());
        }
    }
    getIsRowEditingFromGui(displayIndex) {
        let isRowEditing = Commands.getIsRowEditing(this, this.isLineMode() ? displayIndex : 0, this.isLineMode());
        return isRowEditing;
    }
    async RefreshDisplay(refreshType) {
        let task = this._task;
        if (this.isFetchingRecordsAhead)
            return false;
        if (task.isAborting())
            return false;
        let currRec = this.GetDataview().getCurrRec();
        if (currRec !== null && currRec.InCompute && !currRec.isNewRec())
            return false;
        if (this._inRefreshDisp)
            return false;
        this._inRefreshDisp = true;
        try {
            if (refreshType === Constants.TASK_REFRESH_FORM || refreshType === Constants.TASK_REFRESH_TABLE) {
                if (super.HasTable() && this.Opened)
                    await this.refreshTable();
            }
            if (refreshType === Constants.TASK_REFRESH_FORM || refreshType === Constants.TASK_REFRESH_CURR_REC) {
                if (refreshType === Constants.TASK_REFRESH_CURR_REC && super.hasTable()) {
                    this.SetTableTopIndex();
                    super.SelectRow();
                    await this.fetchPrevChunkForCurrentPage();
                }
                await super.refreshProps();
                await super.refreshControls(false);
            }
        }
        catch (ex) {
            if (ex instanceof Exception) {
                Logger.Instance.WriteExceptionToLogWithMsg(NString.Format("{0} : {1} in task {2}", ex.GetType(), ex.Message, super.getTask().PreviouslyActiveTaskId));
            }
            else
                throw ex;
        }
        finally {
            this._inRefreshDisp = false;
        }
        if (refreshType === Constants.TASK_REFRESH_CURR_REC && (!super.isLineMode() || this._tableRefreshed)) {
            this.FormRefreshed = true;
            if (this._task.isFirstRecordCycle() || AccessHelper.eventsManager.getIsInViewRefresh()) {
                Commands.addNoParameters(CommandType.SET_WC_IDLE, this);
                AccessHelper.eventsManager.setIsInViewRefresh(false);
            }
        }
        return true;
    }
    RefreshUI() {
        if (!this.getTask().isMainProg()) {
            Commands.addNoParameters(CommandType.REFRESH_TASK, this.getForm());
        }
    }
    async refreshTable() {
        if (this.isFetchingRecordsAhead)
            return;
        Logger.Instance.WriteGuiToLog("Start form.refreshTable()");
        this.updateDisplayLineByDV();
        let oldCurrRow = this.DisplayLine;
        let currRecIdx = this.GetDataview().getCurrRecIdx();
        if (!this._tableRefreshed && currRecIdx >= 0) {
            oldCurrRow = this.GetDataview().getCurrRecIdx();
            if (oldCurrRow + 1 > this._rowsInPage)
                this.GetDataview().setTopRecIdx(oldCurrRow - Math.floor(this._rowsInPage / 2) + 1);
            else
                this.GetDataview().setTopRecIdx(0);
        }
        else {
            if (oldCurrRow === Int32.MinValue)
                oldCurrRow = 0;
            if (this.GetDataview().getTopRecIdx() === Int32.MinValue)
                this.GetDataview().setTopRecIdx(currRecIdx);
        }
        if (this.GetDataview().getTopRecIdx() < 0)
            return;
        oldCurrRow = oldCurrRow - this.GetDataview().getTopRecIdx();
        let bkpRecord = this.GetDataview().backupCurrent();
        this._tableRefreshed = true;
        let oriTransferDataToGui = this._transferringDataToGUI;
        if (!oriTransferDataToGui)
            this._transferringDataToGUI = true;
        this.AllowedSubformRecompute = false;
        for (let i = 0; i < this._rowsInPage; i++) {
            let topIndex = this.GetDataview().getTopRecIdx();
            if (topIndex < 0) {
                this.GetDataview().setTopRecIdx(0);
                topIndex = 0;
            }
            let idx = topIndex + i;
            try {
                super.checkAndCreateRow(idx);
                if (i !== oldCurrRow) {
                    await this.setCurrRowByDisplayLine(idx, false, true);
                    await super.refreshControls(true);
                }
            }
            catch (ex) {
                if (ex.name == "RecordOutOfDataViewException") {
                    if (super.isRowCreated(idx))
                        super.markRowNOTCreated(idx);
                    break;
                }
                else
                    throw ex;
            }
        }
        this.AllowedSubformRecompute = true;
        if (!oriTransferDataToGui)
            this._transferringDataToGUI = false;
        await this.restoreBackup(oldCurrRow + this.GetDataview().getTopRecIdx(), bkpRecord);
        await super.refreshControls(true);
        this.RefreshUI();
        Logger.Instance.WriteGuiToLog("End form.refreshTable()");
    }
    updateDisplayLineByDV() {
        this.DisplayLine = this.recordIdx2DisplayLine(this.GetDataview().getCurrRecIdx());
    }
    async setCurrRowByDisplayLine(displayLine, doSuffix, ignoreCurrRec) {
        let recIdx = this.displayLine2RecordIdx(displayLine);
        await this.setCurrRowByRecIdx(recIdx, doSuffix, ignoreCurrRec, displayLine);
        if (super.HasTable())
            this.updateDisplayLineByDV();
        else
            this.DisplayLine = displayLine;
    }
    async setCurrRowByRecIdx(rowNum, doSuffix, ignoreCurrRec, displayLine) {
        if (this.GetDataview() === null || (!super.hasTable() && rowNum !== 0))
            throw new ApplicationException("in Form.setCurrRow() no table ");
        try {
            this._destTblRow = rowNum;
            await this.GetDataview().setCurrRecByIdx(rowNum, doSuffix, ignoreCurrRec, true, displayLine);
        }
        finally {
            this._destTblRow = rowNum - this.GetDataview().getTopRecIdx();
        }
    }
    getLastValidRow() {
        return Math.min(this._rowsInPage - 1, this.GetDataview().getSize() - 1 - this.GetDataview().getTopRecIdx());
    }
    recordIdx2DisplayLine(recIdx) {
        return recIdx;
    }
    displayLine2RecordIdx(displayLine) {
        return displayLine;
    }
    async restoreOldDisplayLine(displayLine) {
        try {
            this._inRestore = true;
            await this.setCurrRowByDisplayLine(displayLine, false, true);
        }
        catch (ex) {
            if (ex instanceof RecordOutOfDataViewException) {
            }
            else
                throw ex;
        }
        finally {
            this._inRestore = false;
        }
    }
    getTopIndexFromGUI() {
        let topDisplayLine = super.getTopIndexFromGUI();
        if (super.hasTable())
            this.GetDataview().setTopRecIdx(this.displayLine2RecordIdx(topDisplayLine));
        return topDisplayLine;
    }
    getCurrRecPosInForm() {
        let topDisplayLine = super.getTopIndexFromGUI();
        return this.DisplayLine - topDisplayLine + 1;
    }
    async restoreBackup(oldDisplayLine, bkpRecord) {
        if (bkpRecord.getId() >= 0 && this.GetDataview().getRecIdx(bkpRecord.getId()) >= 0 && oldDisplayLine >= 0 && oldDisplayLine < this.GetDataview().getSize() && this.GetDataview().getCurrRecIdx() >= 0 && bkpRecord.getMode() === DataModificationTypes.None) {
            this.GetDataview().restoreCurrent(bkpRecord);
            this.updateDisplayLineByDV();
        }
        else
            await this.restoreOldDisplayLine(oldDisplayLine);
    }
    ConstructMgControl(type, taskOrParentMgForm, parentControlOrParentControlIdx) {
        if (arguments.length === 0) {
            return this.ConstructMgControl_0();
        }
        if (arguments.length === 3 && (type === null || type.constructor === Number) && (taskOrParentMgForm === null || taskOrParentMgForm instanceof TaskBase) && (parentControlOrParentControlIdx === null || parentControlOrParentControlIdx.constructor === Number)) {
            return this.ConstructMgControl_1(type, taskOrParentMgForm, parentControlOrParentControlIdx);
        }
        return this.ConstructMgControl_2(type, taskOrParentMgForm, parentControlOrParentControlIdx);
    }
    ConstructMgControl_0() {
        return new MgControl();
    }
    ConstructMgControl_1(type, task, parentControl) {
        return new MgControl(type, task, parentControl);
    }
    ConstructMgControl_2(type, parentMgForm, parentControlIdx) {
        return new MgControl(type, parentMgForm, parentControlIdx);
    }
    alreadyMovedToFirstControl() {
        return this._task.getMGData().AlreadyMovedToFirstControl();
    }
    async firstTableRefresh() {
        if (this._tableMgControl !== null) {
            super.firstTableRefresh();
            this.setTableItemsCount(false);
            await this.refreshTable();
            super.SelectRow();
        }
    }
    InsertTableItems(idx, count) {
        if (this._tableMgControl != null) {
            this.Rows.InsertRange(new Array(count));
            this.InsertTableChildrenArrays(idx, count);
            this._lastRowSent = -1;
        }
        this.setTableItemsCount(false);
    }
    setTableItemsCount(removeAll) {
        let tableItemsCount;
        if (this.isTableWithAbsoluteScrollbar()) {
            if (this._task.getOriginalTaskMode() === Constants.TASK_MODE_CREATE
                && this._task.getMode() == Constants.TASK_MODE_CREATE) {
                tableItemsCount = this.GetDataview().getSize();
                if (this.GetDataview().RecordsBeforeCurrentView > 0) {
                    this.GetDataview().RecordsBeforeCurrentView = 0;
                    this.SetRecordsBeforeCurrentView(0);
                    this.RefreshUI();
                }
            }
            else {
                tableItemsCount = (this.GetDataview().TotalRecordsCount > 0) ? this.GetDataview().TotalRecordsCount : 1;
                this.SetRecordsBeforeCurrentView(this.GetDataview().RecordsBeforeCurrentView);
            }
        }
        else {
            tableItemsCount = this.GetDataview().getSize();
        }
        super.SetTableItemsCount(this.GetDataview().getSize(), tableItemsCount, removeAll);
    }
    InitTableControl(dvSize, tableItemsCount, removeAll) {
        if (arguments.length === 0) {
            this.InitTableControl_00();
            return;
        }
        this.InitTableControl_01(dvSize, tableItemsCount, removeAll);
    }
    InitTableControl_00() {
        let dvSize = 1;
        let tableItemsCount = 1;
        if (this.isTableWithAbsoluteScrollbar() && this.GetDataview().TotalRecordsCount > 0) {
            let recordsBeforeCurrentView = this.GetDataview().RecordsBeforeCurrentView;
            tableItemsCount = this.GetDataview().TotalRecordsCount;
            Commands.addWithNumber(CommandType.SET_RECORDS_BEFORE_CURRENT_VIEW, this._tableMgControl, recordsBeforeCurrentView);
        }
        this.InitTableControl(dvSize, tableItemsCount, false);
        this.SetTableTopIndex();
    }
    InitTableControl_01(dvSize, tableItemsCount, removeAll) {
        if (this._tableMgControl !== null) {
            if (removeAll) {
                Commands.addBoolWithLine(CommandType.SET_TABLE_INCLUDES_FIRST, this._tableMgControl, 0, true);
                Commands.addBoolWithLine(CommandType.SET_TABLE_INCLUDES_LAST, this._tableMgControl, 0, true);
            }
            else {
                Commands.addBoolWithLine(CommandType.SET_TABLE_INCLUDES_FIRST, this._tableMgControl, 0, this.GetDataview().IncludesFirst() || this.GetDataview().IsOneWayKey);
                Commands.addBoolWithLine(CommandType.SET_TABLE_INCLUDES_LAST, this._tableMgControl, 0, this.GetDataview().IncludesLast());
                Commands.addBoolWithLine(CommandType.SET_EMPTY_DATAVIEW, this._tableMgControl, 0, this.GetDataview().isEmptyDataview());
            }
            super.InitTableControl(dvSize, tableItemsCount, removeAll);
            this.checkAndCreateRowsEvent();
        }
    }
    SetTableTopIndex() {
        if (this._tableMgControl !== null) {
            let index = this.GetDataview().getTopRecIdx();
            if (index === Int32.MinValue)
                index = 0;
            if (!this.isTableWithPagination()) {
                if (this.GetDataview().IncludesLast()) {
                    if (index + this._rowsInPage > this.GetDataview().getSize()) {
                        if (this.GetDataview().IncludesFirst() || this.GetDataview().getSize() > this._rowsInPage + 1) {
                            index = Math.max(this.GetDataview().getSize() - this._rowsInPage, 0);
                            this.GetDataview().setTopRecIdx(index);
                            this._topIndexUpdated = true;
                        }
                    }
                }
            }
            if (index !== this._prevGuiTopIndex || this.IsMovingInView) {
                Commands.addWithNumber(CommandType.SET_TABLE_TOP_INDEX, this._tableMgControl, index);
                this._prevGuiTopIndex = this.getGuiRowidx(index);
            }
        }
    }
    createForm() {
        super.createForm();
        MgForm.CreatedForms.add(this);
    }
    UpdateStatusBar() {
    }
    initInnerObjects(foundTagName) {
        if (foundTagName === null)
            return false;
        let parser = Manager.GetCurrentRuntimeContext().Parser;
        if (foundTagName === XMLConstants.MG_TAG_RECOMPUTE) {
            Logger.Instance.WriteDevToLog("goes to recompute form");
            this._task.RecomputeFillData(parser);
            return true;
        }
        return super.initInnerObjects(foundTagName);
    }
    toString() {
        return "{" + this.constructor.name + ": task=" + this._task + ", Id=" + this._userStateId + "}";
    }
    GetHiddenControlListXML() {
        let xml = new StringBuilder();
        if (this.hiddenControlsIsnsList !== null && this.hiddenControlsIsnsList.length > 0) {
            xml.Append("<" + ConstInterface.MG_TAG_HIDDEN_CONTOLS + " " + ConstInterface.MG_ATTR_ISNS + "=\"");
            this.hiddenControlsIsnsList.forEach((change) => {
                xml.Append(change + ",");
            });
            xml.Remove(xml.Length - 1, 1);
            xml.Append("\"/>");
            this.hiddenControlsIsnsList = null;
        }
        return xml.ToString();
    }
    ShouldBehaveAsModal() {
        let shouldBeModal = false;
        if (!this._task.IsInteractive && !this._task.isMainProg())
            shouldBeModal = TaskBase.ShouldNonInteractiveBeModal();
        else {
            let parentTask = this._task.ParentTask;
            if (parentTask !== null && !parentTask.IsInteractive && !parentTask.isMainProg())
                shouldBeModal = parentTask.ShouldNonInteractiveChildBeModal();
        }
        return shouldBeModal;
    }
    isTableWithPagination() {
        return this.isTableWithAbsoluteScrollbar();
    }
    isTableWithAbsoluteScrollbar() {
        let tableWithAbsoluteScrollbar = false;
        if (this._tableMgControl !== null)
            tableWithAbsoluteScrollbar = this._tableMgControl.IsTableWithAbsoluteScrollbar();
        return tableWithAbsoluteScrollbar;
    }
    SetRecordsBeforeCurrentView(value) {
        if (this._tableMgControl !== null) {
            Commands.addWithNumber(CommandType.SET_RECORDS_BEFORE_CURRENT_VIEW, this._tableMgControl, value);
        }
    }
    buildFormName() {
        let name = this.UniqueName;
        let task = this.getTask();
        name = (task.getProp(PropInterface.PROP_TYPE_NAME)).GetComputedValue() + '_' + name;
        while (task.IsSubtask) {
            task = task.StudioParentTask;
            name = (task.getProp(PropInterface.PROP_TYPE_NAME)).GetComputedValue() + '_' + name;
        }
        name = name.replace(/ /g, "_");
        name = name.replace(/-/g, "_");
        return name;
    }
    async fetchPrevChunkForCurrentPage() {
        if (this.isTableWithAbsoluteScrollbar() && this.GetDataview().TotalRecordsCount > 0) {
            let recPosOnPage = this.GetDataview().RecordsBeforeCurrentView % this._rowsInPage;
            if (recPosOnPage > 0 && this.DisplayLine === 0) {
                await this.setRowData(-recPosOnPage, false);
            }
        }
    }
    getGuiRowidx(dvRowIdx) {
        return dvRowIdx + this.GetDataview().RecordsBeforeCurrentView;
    }
    getDvRowIdx(guiRowIdx) {
        return guiRowIdx - this.GetDataview().RecordsBeforeCurrentView;
    }
}
MgForm.TIME_LIMIT = 50;
MgForm._createdForms = new CreatedFormVector();

class RemoteTaskService extends TaskServiceBase {
    constructor() {
        super();
    }
    GetTaskTag(defaultValue) {
        return defaultValue;
    }
    GetDataviewManagerForVirtuals(task) {
        return task.DataviewManager.RemoteDataviewManager;
    }
    PrepareTask(task) {
        task.DataViewWasRetrieved = true;
        let result = super.PrepareTask(task);
        if (task.getMGData().IsModal && task.getForm() !== null) {
            task.getForm().ConcreteWindowType = WindowType.Overlay;
        }
        return result;
    }
    GetEventTaskId(originalTaskId) {
        return originalTaskId;
    }
    ShouldEvaluatePropertyLocally(propId) {
        return false;
    }
    InitTaskPrefixExecutedFlag(task) {
        task.TaskPrefixExecuted = true;
    }
    RemoveRecomputes(parentTask) {
        parentTask.DataView.GetFieldsTab().resetRecomp();
    }
    GetOwnerTransactionTask(task) {
        let OwnerTransactionTask = task;
        if (task.DataviewManager.RemoteDataviewManager.Transaction !== null)
            OwnerTransactionTask = task.DataviewManager.RemoteDataviewManager.Transaction.OwnerTask;
        return OwnerTransactionTask;
    }
    static async PreparePropMainDisplay(task) {
        await task.ComputeMainDisplay();
        return task.FormIsLegal() ? ReturnResult.SuccessfulResult : new ReturnResult(MsgInterface.BRKTAB_STR_ERR_FORM);
    }
}

class Key {
    constructor(ownerTable) {
        this.Columns = null;
        this._table = null;
        this._id = 0;
        this._table = ownerTable;
        this.Columns = new List();
    }
    FillData(parser) {
        this.FillAttributes(parser);
        while (this.InitInnerObjects(parser, parser.getNextTag())) {
        }
    }
    FillAttributes(parser) {
        let tokensVector;
        let endContext = parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex());
        let tag;
        let attribute;
        if (endContext !== -1 && endContext < parser.getXMLdata().length) {
            tag = parser.getXMLsubstring(endContext);
            parser.add2CurrIndex(tag.indexOf(ConstInterface.MG_ATTR_KEY) + ConstInterface.MG_ATTR_KEY.length);
            tokensVector = XmlParser.getTokens(parser.getXMLsubstring(endContext), XMLConstants.XML_ATTR_DELIM);
            for (let j = 0; j < tokensVector.length; j += 2) {
                attribute = (tokensVector.get_Item(j));
                let valueStr = (tokensVector.get_Item(j + 1));
                if (attribute === XMLConstants.MG_ATTR_ID)
                    this._id = XmlParser.getInt(valueStr);
                else if (attribute === XMLConstants.MG_ATTR_TYPE)
                    Logger.Instance.WriteDevToLog("in Key.fillAttributes() obsolete attribute (TODO: remove from server)" + attribute);
                else
                    Logger.Instance.WriteExceptionToLogWithMsg(NString.Format("Unrecognized attribute: '{0}'", attribute));
            }
            parser.setCurrIndex(++endContext);
            return;
        }
        Logger.Instance.WriteExceptionToLogWithMsg("in Key.fillAttributes() out of string bounds");
    }
    InitElements(tokensVector) {
        for (let j = 0; j < tokensVector.length; j = j + 2) {
            let attribute = tokensVector.get_Item(j);
            let valueStr = tokensVector.get_Item(j + 1);
            switch (attribute) {
                case XMLConstants.MG_ATTR_ID:
                    this.Columns.push(this._table.FldsTab.getField(XmlParser.getInt(valueStr)));
                    break;
                case XMLConstants.MG_ATTR_SIZE:
                    break;
                case ConstInterface.MG_ATTR_DIR:
                    break;
                default:
                    Logger.Instance.WriteExceptionToLogWithMsg(NString.Format("Unrecognized attribute: '{0}'", attribute));
                    break;
            }
        }
    }
    InitInnerObjects(parser, foundTagName) {
        if (foundTagName === null)
            return false;
        if (foundTagName === ConstInterface.MG_TAG_COLUMN) {
            let endContext = parser.getXMLdata().indexOf(XMLConstants.TAG_TERM, parser.getCurrIndex());
            if (endContext !== -1 && endContext < parser.getXMLdata().length) {
                let tag = parser.getXMLsubstring(endContext);
                parser.add2CurrIndex(tag.indexOf(ConstInterface.MG_TAG_COLUMN) + ConstInterface.MG_TAG_COLUMN.length);
                let tokens = XmlParser.getTokens(parser.getXMLsubstring(endContext), XMLConstants.XML_ATTR_DELIM);
                this.InitElements(tokens);
                parser.setCurrIndex(endContext + XMLConstants.TAG_TERM.length);
            }
            else
                Logger.Instance.WriteExceptionToLogWithMsg("in Key.initInnerObjects() out of string bounds");
        }
        else if (foundTagName === '/' + ConstInterface.MG_ATTR_KEY) {
            parser.setCurrIndex2EndOfTag();
            return false;
        }
        else {
            Logger.Instance.WriteExceptionToLogWithMsg("There is no such tag in LinksTable.initInnerObjects(): " + foundTagName);
            return false;
        }
        return true;
    }
    GetKeyId() {
        return this._id;
    }
}

class HeapSort {
    static left(i) {
        return 2 * i + 1;
    }
    static right(i) {
        return 2 * i + 2;
    }
    static sort(array) {
        let sortsize = array.length;
        let temp;
        let largest, i, l, r;
        if (sortsize <= 1)
            return;
        let top = sortsize - 1;
        let t = Math.floor(sortsize / 2);
        do {
            t = t - 1;
            largest = t;
            do {
                i = largest;
                l = HeapSort.left(largest);
                r = HeapSort.right(largest);
                if (l <= top) {
                    if (array[l].CompareTo(array[i]) > 0)
                        largest = l;
                }
                if (r <= top) {
                    if (array[r].CompareTo(array[largest]) > 0)
                        largest = r;
                }
                if (largest !== i) {
                    temp = array[largest];
                    array[largest] = array[i];
                    array[i] = temp;
                }
            } while (largest !== i);
        } while (t > 0);
        t = sortsize;
        do {
            top = top - 1;
            t = t - 1;
            let here = t;
            temp = array[here];
            array[here] = array[0];
            array[0] = temp;
            largest = 0;
            do {
                i = largest;
                l = HeapSort.left(largest);
                r = HeapSort.right(largest);
                if (l <= top) {
                    if (array[l].CompareTo(array[i]) > 0) {
                        largest = l;
                    }
                }
                if (r <= top) {
                    if (array[r].CompareTo(array[largest]) > 0) {
                        largest = r;
                    }
                }
                if (largest !== i) {
                    temp = array[largest];
                    array[largest] = array[i];
                    array[i] = temp;
                }
            } while (largest !== i);
        } while (t > 1);
    }
}

class TableCacheManager {
    constructor() {
        this._tables = null;
        this._tables = new Hashtable();
    }
    GetTableById(tableUId) {
        return this._tables.get_Item(tableUId);
    }
    TableExists(tableUId) {
        let result = true;
        if (this.GetTableById(tableUId) === null)
            result = false;
        return result;
    }
    InsertTable(table) {
        let result = false;
        if (!this.TableExists(table.GetTableUniqueId())) {
            this._tables.set_Item(table.GetTableUniqueId(), table);
            result = true;
        }
        return result;
    }
    async LoadTable(tableUId) {
        let server = RemoteCommandsProcessor.GetInstance();
        if (this.TableExists(tableUId)) {
            let current = this._tables.get_Item(tableUId);
            try {
                let residentTableContentStr = await server.GetContent(tableUId, true);
                try {
                    RuntimeContextBase.Instance.Parser.loadTableCacheData(residentTableContentStr);
                }
                catch (innerException) {
                    if (innerException instanceof Exception) {
                        throw new ApplicationException("Unable to parse resident table " + tableUId + ", due to unsupported encoding.", innerException);
                    }
                    else
                        throw innerException;
                }
            }
            catch (throwable) {
                if (throwable instanceof Exception) {
                    Misc.WriteStackTrace(throwable);
                }
                else
                    throw throwable;
            }
            current.FillData();
            let deletedUids = new List();
            let enumerator = this._tables.Values;
            while (enumerator.MoveNext()) {
                let tbl = enumerator.Current;
                let currIdent = tbl.GetTableCommonIdentifier();
                if (currIdent === current.GetTableCommonIdentifier() && tbl.GetTableUniqueId() !== tableUId)
                    deletedUids.push(tbl.GetTableUniqueId());
            }
            for (let i = 0; i < deletedUids.length; i = i + 1) {
                this._tables.Remove(deletedUids.get_Item(i));
            }
        }
    }
}
TableCacheManager.Instance = new TableCacheManager();

class TableCache {
    constructor(tableId) {
        this._keys = null;
        this._records = null;
        this._currSortDir = '\0';
        this._currSortKey = 0;
        this.FldsTab = null;
        this._isLoaded = false;
        this._tableIdent = null;
        this._tableUId = null;
        this._tableUId = tableId;
        this._keys = new List();
        this._records = new List();
        this._isLoaded = false;
    }
    SetTableIdent(ident) {
        if (this._tableIdent === null)
            this._tableIdent = ident;
        else if (this._tableIdent !== ident) {
            Logger.Instance.WriteExceptionToLogWithMsg("in TableCache.setTableIdent() already set and table identifier  does not match");
        }
    }
    FillData() {
        let parser = RuntimeContextBase.Instance.Parser;
        this.FillAttributes(parser);
        while (this.InitInnerObjects(parser, parser.getNextTag())) {
        }
    }
    FillAttributes(parser) {
        let endContext = parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex());
        if (endContext !== -1 && endContext < parser.getXMLdata().length) {
            let tag = parser.getXMLsubstring(endContext);
            parser.add2CurrIndex(tag.indexOf(ConstInterface.MG_TAG_CACHED_TABLE) + ConstInterface.MG_TAG_CACHED_TABLE.length);
            let tokensVector = XmlParser.getTokens(parser.getXMLsubstring(endContext), XMLConstants.XML_ATTR_DELIM);
            for (let j = 0; j < tokensVector.length; j += 2) {
                let attribute = (tokensVector.get_Item(j));
                let valueStr = (tokensVector.get_Item(j + 1));
                switch (attribute) {
                    case XMLConstants.MG_ATTR_ID:
                        if (this._tableUId.indexOf(valueStr) === -1) {
                            this._tableUId = valueStr;
                            Logger.Instance.WriteExceptionToLogWithMsg("in TableCache.fillAttributes() table unique id does not match");
                        }
                        break;
                    case XMLConstants.MG_ATTR_NAME:
                        break;
                    case ConstInterface.MG_ATTR_IDENT:
                        if (this._tableIdent !== valueStr) {
                            this._tableIdent = valueStr;
                            Logger.Instance.WriteExceptionToLogWithMsg("in TableCache.fillAttributes() table identifier id does not match");
                        }
                        break;
                    default:
                        Logger.Instance.WriteExceptionToLogWithMsg(NString.Format("Unrecognized attribute: '{0}'", attribute));
                        break;
                }
            }
            parser.setCurrIndex(++endContext);
            return;
        }
        Logger.Instance.WriteExceptionToLogWithMsg("in TableCache.fillAttributes() out of string bounds");
    }
    InitInnerObjects(parser, foundTagName) {
        if (foundTagName == null)
            return false;
        switch (foundTagName) {
            case XMLConstants.MG_TAG_FLDH:
                this.FldsTab = new FieldsTable();
                this.FldsTab.fillData(parser);
                break;
            case ConstInterface.MG_ATTR_KEY: {
                let current = new Key(this);
                current.FillData(parser);
                this._keys.push(current);
                break;
            }
            case ConstInterface.MG_TAG_RECORDS:
                parser.setCurrIndex(parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex()) + 1);
                break;
            case ConstInterface.MG_TAG_RECORDS_END:
                parser.setCurrIndex2EndOfTag();
                break;
            case ConstInterface.MG_TAG_CACHED_TABLE_END:
                parser.setCurrIndex2EndOfTag();
                return false;
            case ConstInterface.MG_TAG_REC: {
                let current = new Record(this);
                current.Initialize();
                current.fillData(parser);
                this._records.push(current);
                break;
            }
        }
        return true;
    }
    GetTableUniqueId() {
        return this._tableUId;
    }
    GetTableCommonIdentifier() {
        return this._tableIdent;
    }
    GetCurrSortKey() {
        return this._currSortKey;
    }
    GetKeyById(keyId) {
        for (let i = 0; i < this._keys.length; i = i + 1) {
            if (this._keys.get_Item(i).GetKeyId() === keyId)
                return this._keys.get_Item(i);
        }
        return null;
    }
    async Load() {
        if (!this._isLoaded) {
            await TableCacheManager.Instance.LoadTable(this._tableUId);
            this._isLoaded = true;
        }
    }
    async SortTable(sortKeyId, sortDir) {
        if (!this._isLoaded)
            await this.Load();
        if (sortKeyId !== this._currSortKey || sortDir !== this._currSortDir) {
            this._currSortDir = sortDir;
            this._currSortKey = sortKeyId;
            let recordsArr = this._records.ToArray();
            HeapSort.sort(recordsArr);
            if (this._currSortDir === 'D')
                this.ReverseVector(recordsArr);
            for (let i = 0; i < this._records.length; i = i + 1) {
                this._records.set_Item(i, recordsArr[i]);
            }
        }
    }
    Fetch(loc) {
        let checkLoc = loc.length > 0;
        if (this._isLoaded) {
            if (!checkLoc) {
                return ((this._records.length !== 0) ? this._records.get_Item(0) : null);
            }
            for (let i = 0; i < this._records.length; i = i + 1) {
                let currRec = this._records.get_Item(i);
                if (TableCache.validateRec(currRec, loc)) {
                    return currRec;
                }
            }
        }
        return null;
    }
    static validateRec(currRec, rangeCond) {
        let result = true;
        for (let i = 0; i < rangeCond.length; i = i + 1) {
            let currCnd = rangeCond.get_Item(i);
            if (!currCnd.checkRange(currRec.GetFieldValue(currCnd.getCacheTableFldId()), currRec.IsNull(currCnd.getCacheTableFldId()))) {
                result = false;
                break;
            }
        }
        return result;
    }
    ReverseVector(array) {
        let right = array.length - 1;
        for (let left = 0; left < Math.floor((array.length - 1) / 2); left++, right--) {
            let tmp = array[left];
            array[left] = array[right];
            array[right] = tmp;
        }
    }
}

class RemoteDataviewHeader extends DataviewHeaderBase {
    constructor(task) {
        super(task);
        this._table = null;
        this._lastFetchRecPos = null;
    }
    setAttribute(attribute, valueStr) {
        switch (attribute) {
            case ConstInterface.MG_ATTR_CACHED_TABLE:
                if (valueStr != "") {
                    if (TableCacheManager.Instance.TableExists(valueStr))
                        this._table = TableCacheManager.Instance.GetTableById(valueStr);
                    else {
                        this._table = new TableCache(valueStr);
                        TableCacheManager.Instance.InsertTable(this._table);
                    }
                }
                break;
            case ConstInterface.MG_ATTR_IDENT:
                if (valueStr != "")
                    this._table.SetTableIdent(valueStr);
                break;
            default:
                super.setAttribute(attribute, valueStr);
                break;
        }
    }
    async getLinkedRecord(curRec) {
        let lnkFlds = this._task.DataView.GetFieldsTab().getLinkFields(this._id);
        let ret = false;
        if (this._cond.getVal()) {
            if (this.Loc == null) {
                this.Loc = new List();
                for (let i = 0; i < lnkFlds.length; i++) {
                    let currLoc = lnkFlds.get_Item(i).Locate;
                    if (currLoc != null) {
                        this.Loc.push(currLoc);
                        await currLoc.compute(false);
                    }
                }
            }
            else {
                for (let i = 0; i < this.Loc.length; i++)
                    await this.Loc.get_Item(i).compute(false);
            }
            await this._table.SortTable(this._keyIdx, this._dir);
            let res = this._table.Fetch(this.Loc);
            if (res == null)
                await this.initRec(curRec, false);
            else {
                ret = true;
                await this.copyLinkFldToRec(curRec, lnkFlds, res, true);
            }
        }
        else
            await this.initRec(curRec, false);
        return ret;
    }
    async copyLinkFldToRec(curRec, linkFlds, tableRec, ret) {
        this._lastFetchRecPos = tableRec.getDbPosVal();
        for (let i = 0; i < linkFlds.length; i++) {
            let curFld = linkFlds.get_Item(i);
            curRec.setFieldValue(curFld.getId(), tableRec.GetFieldValue(curFld.CacheTableFldIdx), false);
            curRec.clearFlag(curFld.getId(), Record.FLAG_INVALID);
            curFld.invalidate(true, false);
        }
        await this.SetReturnValue(ret, true);
    }
    async initRec(currRec, ret) {
        this._lastFetchRecPos = "#";
        await this.InitLinkFields(currRec);
        let retFld = this.ReturnField;
        if (retFld != null) {
            currRec.setFieldValue(retFld.getId(), (ret ? "1" : "0"), false);
            retFld.invalidate(true, false);
        }
    }
    getLastFetchedDbPos() {
        return this._lastFetchRecPos;
    }
    async SetReturnValue(ret, recompute) {
        let returnField = this.ReturnField;
        if (returnField !== null) {
            let enforceVariableChange = returnField.getTask() !== this.Task;
            AccessHelper.eventsManager.pushNewExecStacks();
            let result = ret ? "1" : "0";
            if (returnField.getType() === StorageAttribute.NUMERIC)
                result = DisplayConvertor.Instance.toNum(result, new PIC(returnField.getPicture(), StorageAttribute.NUMERIC, 0), 0);
            await returnField.setValueAndStartRecompute(result, false, recompute, false, false, enforceVariableChange);
            AccessHelper.eventsManager.popNewExecStacks();
            if (!recompute)
                returnField.setModified();
            returnField.invalidate(true, false);
            if (returnField.getTask() !== this.Task)
                await returnField.updateDisplay();
        }
    }
}

class DataviewHeaderFactory {
    CreateDataviewHeaders(task) {
        return new RemoteDataviewHeader(task);
    }
}

class DataviewHeadersSaxHandler {
    constructor(task, dataviewHeaders, xmlData) {
        this._dataviewHeaders = null;
        this._task = null;
        this._dataviewHeadersFactory = null;
        this._dataviewHeaders = dataviewHeaders;
        this._task = task;
        this._dataviewHeadersFactory = new DataviewHeaderFactory();
        JSON_Utils.JSONFromXML(xmlData, this.FillFromJSON.bind(this));
    }
    FillFromJSON(error, result) {
        if (error != null) {
            throw error;
        }
        let links = result[ConstInterface.MG_TAG_LINKS][ConstInterface.MG_TAG_LINK];
        if (!isNullOrUndefined(links) && links.constructor === Array) {
            for (let i = 0; i < links.length; i++) {
                let link = links[i]['$'];
                if (!isNullOrUndefined(link[ConstInterface.MG_ATTR_TABLE_INDEX])) {
                    let dataviewHeader = this._dataviewHeadersFactory.CreateDataviewHeaders(this._task);
                    let attributes = new Dictionary();
                    for (let key in link) {
                        if (key !== ConstInterface.MG_ATTR_TABLE_INDEX) {
                            attributes.Add(key, link[key]);
                        }
                    }
                    dataviewHeader.SetAttributes(attributes);
                    this._dataviewHeaders.set_Item(dataviewHeader.Id, dataviewHeader);
                }
            }
        }
    }
}

class DataviewHeaders {
    constructor(task) {
        this._dataviewHeaders = null;
        this._task = null;
        this._task = task;
        this._dataviewHeaders = new Hashtable();
    }
    fillData(parser) {
        while (this.initInnerObjects(parser, parser.getNextTag())) {
        }
    }
    initInnerObjects(parser, foundTagName) {
        if (foundTagName === null)
            return false;
        if (foundTagName === ConstInterface.MG_TAG_LINKS) {
            let endContext = parser.getXMLdata().indexOf(ConstInterface.MG_TAG_LINKS_END, parser.getCurrIndex()) + ConstInterface.MG_TAG_LINKS_END.length + 1;
            let xml = parser.getXMLsubstring(endContext);
            xml = XmlParser.escapeUrl(xml);
            new DataviewHeadersSaxHandler(this._task, this._dataviewHeaders, xml);
            parser.setCurrIndex(endContext + XMLConstants.TAG_CLOSE.length);
        }
        else
            Logger.Instance.WriteExceptionToLogWithMsg("There is no such tag in LinksTable.initInnerObjects(): " + foundTagName);
    }
    getDataviewHeaderById(linkId) {
        return this._dataviewHeaders.get_Item(linkId);
    }
    buildDbPosString() {
        if (this._dataviewHeaders.Count === 0) {
            return null;
        }
        let buf = new StringBuilder();
        let dataviewHeaders = this._dataviewHeaders.Values;
        while (dataviewHeaders.MoveNext()) {
            let curr = ((dataviewHeaders.Current instanceof RemoteDataviewHeader) ? dataviewHeaders.Current : null);
            if (curr !== null) {
                let currDbPosVal = curr.getLastFetchedDbPos();
                buf.Append("@");
                if (currDbPosVal !== null) {
                    buf.Append(currDbPosVal);
                }
            }
        }
        buf.Append("@");
        return buf.ToString();
    }
}

class OperationTable {
    constructor() {
        this._operations = new List();
        this._firstBlockOperIdx = Int32.MaxValue;
    }
    fillData(taskRef, evtHandler, parser) {
        while (this.initInnerObjects(parser.getNextTag(), taskRef, evtHandler, parser)) {
        }
        for (let i = this._firstBlockOperIdx; i < this._operations.length; i = i + 1) {
            let operation = this._operations.get_Item(i);
            let operType = operation.getType();
            if (operType === ConstInterface.MG_OPER_LOOP || operType === ConstInterface.MG_OPER_BLOCK ||
                operType === ConstInterface.MG_OPER_ELSE) {
                let operIdx = this.serverId2operIdx(operation.getBlockClose(), i + 1);
                operation.setBlockClose(operIdx);
                operIdx = this.serverId2operIdx(operation.getBlockEnd(), operIdx);
                operation.setBlockEnd(operIdx);
            }
        }
    }
    initInnerObjects(foundTagName, taskRef, evtHandler, parser) {
        if (foundTagName != null && foundTagName === (ConstInterface.MG_TAG_OPER)) {
            let oper = new Operation();
            oper.fillData(taskRef, evtHandler, parser);
            this._operations.push(oper);
            if (this._firstBlockOperIdx === Int32.MaxValue
                && (oper.getType() === ConstInterface.MG_OPER_LOOP || oper.getType() === ConstInterface.MG_OPER_BLOCK))
                this._firstBlockOperIdx = this._operations.length - 1;
            return true;
        }
        return false;
    }
    getSize() {
        return this._operations.length;
    }
    getOperation(idx) {
        if (idx >= 0 && idx < this._operations.length)
            return this._operations.get_Item(idx);
        throw new ApplicationException("in OperationTable.getOperation() index out of bounds: " + idx);
    }
    serverId2operIdx(id, startFrom) {
        let operIdx = -1;
        for (let i = startFrom; i < this._operations.length; i = i + 1) {
            let operation = this._operations.get_Item(i);
            if (id === operation.getServerId()) {
                operIdx = i;
                break;
            }
        }
        return operIdx;
    }
    serverId2FollowingOperIdx(id, startFrom) {
        let operIdx = -1;
        for (let i = startFrom; i < this._operations.length; i = i + 1) {
            let operation = this._operations.get_Item(i);
            if (id < operation.getServerId()) {
                operIdx = i;
                break;
            }
        }
        return operIdx;
    }
}

class EventHandler {
    constructor() {
        this._enabledExp = new YesNoExp(true);
        this._operationTab = null;
        this._propagateExp = new YesNoExp(true);
        this._isHandlerOnForm = false;
        this._ctrl = null;
        this._ctrlName = null;
        this._dvLen = 0;
        this._dvPos = 0;
        this._evt = null;
        this._handledByClient = false;
        this._handlerFld = null;
        this._hasParameters = false;
        this._id = 0;
        this._level = '\0';
        this._scope = null;
        this._task = null;
        this._taskMgdID = -1;
        this._operationTab = new OperationTable();
    }
    getCtrlName() {
        return this._ctrlName;
    }
    fillData(taskRef, parser) {
        if (this._task === null) {
            this._task = taskRef;
            this._taskMgdID = this._task.getMgdID();
        }
        while (this.initInnerObjects(parser, parser.getNextTag())) {
        }
        let dataView = this._task.DataView;
        this._hasParameters = dataView.ParametersExist(this._dvPos, this._dvLen);
    }
    initInnerObjects(parser, foundTagName) {
        if (foundTagName === null)
            return false;
        if (foundTagName === ConstInterface.MG_TAG_HANDLER)
            this.initInnerElements(parser, this._task);
        else if (foundTagName === ConstInterface.MG_TAG_OPER)
            this._operationTab.fillData(this._task, this, parser);
        else if (foundTagName === ConstInterface.MG_TAG_EVENT && this._evt === null) {
            this._evt = new Event();
            this._evt.fillData(parser, this._task);
            if (this._evt.getType() === ConstInterface.EVENT_TYPE_TIMER ||
                (this._evt.getType() === ConstInterface.EVENT_TYPE_USER && this._evt.getUserEventType() === ConstInterface.EVENT_TYPE_TIMER))
                this._task.getMGData().addTimerHandler(this);
            if (((this._evt.getType() === ConstInterface.EVENT_TYPE_INTERNAL && this._evt.getInternalCode() === InternalInterface.MG_ACT_ZOOM) || (this._evt.getType() === ConstInterface.EVENT_TYPE_USER && this._evt.getUserEvent() !== null && this._evt.getUserEventType() === ConstInterface.EVENT_TYPE_INTERNAL && this._evt.getUserEvent().getInternalCode() === InternalInterface.MG_ACT_ZOOM)) && !this._task.getEnableZoomHandler()) {
                if (this._handlerFld !== null)
                    this._handlerFld.setHasZoomHandler();
                else if (this._ctrl !== null)
                    this._ctrl.HasZoomHandler = true;
                else
                    this._task.setEnableZoomHandler();
            }
        }
        else if (foundTagName === '/' + ConstInterface.MG_TAG_HANDLER) {
            parser.setCurrIndex2EndOfTag();
            return false;
        }
        else {
            Logger.Instance.WriteExceptionToLogWithMsg("there is no such tag in EventHandler.initInnerObjects() " + foundTagName);
            return false;
        }
        return true;
    }
    initInnerElements(parser, taskRef) {
        let endContext = parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex());
        if (endContext !== -1 && endContext < parser.getXMLdata().length) {
            let tag = parser.getXMLsubstring(endContext);
            parser.add2CurrIndex(tag.indexOf(ConstInterface.MG_TAG_HANDLER) + ConstInterface.MG_TAG_HANDLER.length);
            let tokensVector = XmlParser.getTokens(parser.getXMLsubstring(endContext), XMLConstants.XML_ATTR_DELIM);
            this.initElements(tokensVector, taskRef);
            parser.setCurrIndex(++endContext);
            return;
        }
        Logger.Instance.WriteExceptionToLogWithMsg("in Handler.FillData() out of string bounds");
    }
    initElements(tokensVector, taskRef) {
        for (let j = 0; j < tokensVector.length; j += 2) {
            let attribute = (tokensVector.get_Item(j));
            let valueStr = (tokensVector.get_Item(j + 1));
            switch (attribute) {
                case ConstInterface.MG_ATTR_HANDLEDBY:
                    this._handledByClient = (valueStr.toUpperCase() === "C".toUpperCase());
                    break;
                case XMLConstants.MG_ATTR_ID:
                    this._id = XmlParser.getInt(valueStr);
                    break;
                case ConstInterface.MG_ATTR_LEVEL:
                    this._level = valueStr[0];
                    break;
                case ConstInterface.MG_ATTR_OBJECT:
                    let valueStringCtrlName = XmlParser.unescape(valueStr);
                    this._ctrlName = XmlParser.unescape(valueStringCtrlName).toUpperCase();
                    this.calculateCtrlFromControlName(taskRef);
                    break;
                case ConstInterface.MG_ATTR_VARIABLE:
                    this._handlerFld = this._task.DataView.getField(XmlParser.getInt(valueStr));
                    this._handlerFld.setHasChangeEvent();
                    break;
                case ConstInterface.MG_ATTR_SCOPE:
                    this._scope = valueStr[0];
                    break;
                case ConstInterface.MG_ATTR_PROPAGATE:
                    this._propagateExp.setVal(taskRef, valueStr);
                    break;
                case ConstInterface.MG_ATTR_ENABLED:
                    this._enabledExp.setVal(taskRef, valueStr);
                    break;
                case ConstInterface.MG_ATTR_DVPOS:
                    let i = valueStr.indexOf(",");
                    if (i > -1) {
                        this._dvLen = XmlParser.getInt(valueStr.substr(0, i));
                        this._dvPos = XmlParser.getInt(valueStr.substr(i + 1));
                        for (let fldIdx = this._dvPos; fldIdx < this._dvPos + this._dvLen; fldIdx++) {
                            let field = this._task.DataView.getField(fldIdx);
                            field.IsEventHandlerField = true;
                        }
                    }
                    break;
                case ConstInterface.MG_ATTR_HANDLER_ONFORM:
                    this._isHandlerOnForm = XmlParser.getBoolean(valueStr);
                    break;
                default:
                    Logger.Instance.WriteExceptionToLogWithMsg("There is no such tag in EventHandler class. Insert case to EventHandler.initElements for " + attribute);
                    break;
            }
        }
    }
    calculateCtrlFromControlName(taskRef) {
        if (!NString.IsNullOrEmpty(this._ctrlName)) {
            this._ctrl = ((taskRef.getForm() !== null) ? taskRef.getForm().getCtrlByCtrlName(this._ctrlName) : null);
        }
    }
    isSpecificHandlerOf(rtEvt) {
        if (this._ctrl === null && this._ctrlName === null && this._handlerFld === null && !this._isHandlerOnForm)
            return false;
        if (this._scope === BrkScope.Task && this._task !== rtEvt.getTask())
            return false;
        if (this._evt.equals(rtEvt)) {
            if (this._handlerFld !== null) {
                return (this._handlerFld === rtEvt.getFld());
            }
            if (rtEvt.Control !== null && !this._isHandlerOnForm) {
                let eventCtrlName = rtEvt.Control.getControlNameForHandlerSearch();
                if (eventCtrlName !== null && this._ctrlName.toLowerCase() === eventCtrlName.toLowerCase())
                    return true;
            }
            else if (rtEvt.Control === null && this._isHandlerOnForm)
                return true;
        }
        return false;
    }
    isNonSpecificHandlerOf(rtEvt) {
        if (this._ctrl !== null || this._ctrlName !== null || this._handlerFld !== null || this._isHandlerOnForm)
            return false;
        if (this._scope === BrkScope.Task && this._task !== rtEvt.getTask() && rtEvt.getType() !== ConstInterface.EVENT_TYPE_TIMER)
            return false;
        if (this._scope === BrkScope.Global && this._task !== rtEvt.getTask())
            return false;
        if (this._evt.getType() === ConstInterface.EVENT_TYPE_USER && this._evt.getUserEventType() === ConstInterface.EVENT_TYPE_NOTINITED) {
            try {
                this._evt.findUserEvent();
            }
            catch (applicationException) {
                if (applicationException instanceof ApplicationException) {
                }
                else
                    throw applicationException;
            }
        }
        return this._evt.equals(rtEvt);
    }
    isGlobalHandlerOf(rtEvt) {
        if (this._scope !== BrkScope.Global)
            return false;
        if (this._ctrl != null || this._ctrlName != null || this._handlerFld != null || this._isHandlerOnForm)
            return false;
        return this._evt.equals(rtEvt);
    }
    isGlobalSpecificHandlerOf(rtEvt) {
        if (this._scope !== BrkScope.Global)
            return false;
        if (this._ctrl == null && this._ctrlName == null && this._handlerFld == null)
            return false;
        return (this._ctrlName != null && this._evt.equals(rtEvt) &&
            NString.Equals(this._ctrlName, rtEvt.Control.Name, true));
    }
    async execute(rtEvt, returnedFromServer, enabledCndCheckedAndTrue) {
        let ctrl = null;
        let retVal;
        let depth = 0;
        let taskEnd = false;
        let brkLevel = this._task.getBrkLevel();
        let brkLevelIndex = this._task.getBrkLevelIndex();
        let initialLoopStackSize = 0;
        if (taskEnd !== null && this._evt.getType() !== ConstInterface.EVENT_TYPE_EXPRESSION && (this._evt.getType() !== ConstInterface.EVENT_TYPE_USER || (this._evt.getUserEvent().getType() !== ConstInterface.EVENT_TYPE_EXPRESSION && this._evt.getUserEvent().getType() !== ConstInterface.EVENT_TYPE_TIMER))) {
            if (this._evt.getType() !== ConstInterface.EVENT_TYPE_USER_FUNC)
                this._task.setBrkLevel(rtEvt.getBrkLevel(), this._id);
        }
        else
            this._task.setBrkLevel(this._evt.getBrkLevel(), this._id);
        let args = rtEvt.getArgList();
        try {
            let flowMonitor = FlowMonitorQueue.Instance;
            if (rtEvt.getType() === ConstInterface.EVENT_TYPE_INTERNAL && rtEvt.getInternalCode() === InternalInterface.MG_ACT_WEBCLIENT_ROUTE) {
                if (!this._task.IsRoute() && this._task !== AccessHelper.mgDataTable.StartupMgData.getFirstTask()) {
                    return new RetVals(true, true);
                }
            }
            let nextOperIdx = -1;
            if (returnedFromServer) {
                nextOperIdx = AccessHelper.eventsManager.getNextOperIdx(this._operationTab.getOperation(0), false);
            }
            if (nextOperIdx === -1 && !enabledCndCheckedAndTrue && !await this.isEnabled())
                return new RetVals(true, false);
            if (this._scope === BrkScope.Task && (rtEvt.getType() === ConstInterface.EVENT_TYPE_TIMER || rtEvt.getType() === ConstInterface.EVENT_TYPE_EXPRESSION)) {
                let currTask = LastFocusedManager.Instance.getLastFocusedTask();
                if (this._task !== currTask)
                    return new RetVals(true, true);
            }
            if (!this._handledByClient) {
                return new RetVals(false, true);
            }
            if (rtEvt.getType() !== ConstInterface.EVENT_TYPE_USER && !await this._evt.dataEventIsTrue())
                return new RetVals(false, true);
            if (rtEvt.getType() === ConstInterface.EVENT_TYPE_INTERNAL && rtEvt.getInternalCode() === InternalInterface.MG_ACT_TASK_SUFFIX)
                taskEnd = true;
            if (rtEvt.getType() === ConstInterface.EVENT_TYPE_INTERNAL) {
                switch (rtEvt.getInternalCode()) {
                    case InternalInterface.MG_ACT_REC_PREFIX:
                        flowMonitor.addTaskFlowRec(InternalInterface.MG_ACT_REC_PREFIX, FlowMonitorInterface.FLWMTR_START, this._task.GetTaskDetails());
                        break;
                    case InternalInterface.MG_ACT_REC_SUFFIX:
                        flowMonitor.addTaskFlowRec(InternalInterface.MG_ACT_REC_SUFFIX, FlowMonitorInterface.FLWMTR_START, this._task.GetTaskDetails());
                        break;
                    case InternalInterface.MG_ACT_CTRL_SUFFIX:
                        flowMonitor.addTaskFlowCtrl(InternalInterface.MG_ACT_CTRL_SUFFIX, rtEvt.Control.Name, FlowMonitorInterface.FLWMTR_START, this._task.GetTaskDetails());
                        break;
                    case InternalInterface.MG_ACT_CTRL_PREFIX:
                        flowMonitor.addTaskFlowCtrl(InternalInterface.MG_ACT_CTRL_PREFIX, rtEvt.Control.Name, FlowMonitorInterface.FLWMTR_START, this._task.GetTaskDetails());
                        break;
                    case InternalInterface.MG_ACT_VARIABLE:
                        flowMonitor.addTaskFlowFld(InternalInterface.MG_ACT_VARIABLE, rtEvt.getFld().getName(), FlowMonitorInterface.FLWMTR_START, this._task.GetTaskDetails());
                        break;
                    case InternalInterface.MG_ACT_CTRL_VERIFICATION:
                        flowMonitor.addTaskFlowCtrl(InternalInterface.MG_ACT_CTRL_VERIFICATION, rtEvt.Control.Name, FlowMonitorInterface.FLWMTR_START, this._task.GetTaskDetails());
                        break;
                    case InternalInterface.MG_ACT_TASK_PREFIX:
                        flowMonitor.addTaskFlowRec(InternalInterface.MG_ACT_TASK_PREFIX, FlowMonitorInterface.FLWMTR_START, this._task.GetTaskDetails());
                        break;
                    case InternalInterface.MG_ACT_TASK_SUFFIX:
                        flowMonitor.addTaskFlowRec(InternalInterface.MG_ACT_TASK_SUFFIX, FlowMonitorInterface.FLWMTR_START, this._task.GetTaskDetails());
                        break;
                    default:
                        flowMonitor.addTaskFlowHandler(this._evt.getBrkLevel(true), FlowMonitorInterface.FLWMTR_START, this._task.GetTaskDetails());
                        break;
                }
            }
            else
                flowMonitor.addTaskFlowHandler(this._evt.getBrkLevel(true), FlowMonitorInterface.FLWMTR_START, this._task.GetTaskDetails());
            try {
                if (taskEnd !== null)
                    ctrl = rtEvt.Control;
                let mgdID = AccessHelper.mgDataTable.currMgdID;
                let isChangedCurrWnd = false;
                let isChangedCurrWndRef = new RefParam(isChangedCurrWnd);
                if (this._evt.getType() === ConstInterface.EVENT_TYPE_TIMER && mgdID !== rtEvt.getMgdID()) {
                    AccessHelper.mgDataTable.currMgdID = rtEvt.getMgdID();
                    isChangedCurrWndRef.value = true;
                }
                await this.resetLocalVariables(args);
                initialLoopStackSize = this._task.getLoopStackSize();
                let retVals = null;
                if (this._operationTab.getSize() > 0)
                    retVals = await this.executeOperations(0, this._operationTab.getSize() - 1, taskEnd, mgdID, depth, isChangedCurrWndRef, false, false, -1);
                isChangedCurrWnd = isChangedCurrWndRef.value;
                if (retVals !== null)
                    return retVals;
                if (!taskEnd)
                    await this._task.evalEndCond(ConstInterface.END_COND_EVAL_IMMIDIATE);
                if (isChangedCurrWnd) {
                    let oldMgd = AccessHelper.mgDataTable.getMGData(mgdID);
                    if (oldMgd !== null && !oldMgd.IsAborting)
                        AccessHelper.mgDataTable.currMgdID = mgdID;
                }
            }
            catch (ex) {
                if (ex instanceof ServerError) {
                    if (Logger.Instance.LogLevel !== Logger_LogLevels.Basic)
                        Logger.Instance.WriteExceptionToLog(ex);
                    throw ex;
                }
                else if (ex instanceof Exception) {
                    Logger.Instance.WriteExceptionToLog(ex);
                    return new RetVals(false, true);
                }
                else
                    throw ex;
            }
            finally {
                retVal = await this._propagateExp.getVal();
                let currLoopStackSize = this._task.getLoopStackSize();
                for (; currLoopStackSize > initialLoopStackSize; currLoopStackSize = currLoopStackSize--)
                    this._task.popLoopCounter();
            }
            if (args !== null)
                await this.getArgValsFromFlds(args);
            if (rtEvt.getType() === ConstInterface.EVENT_TYPE_INTERNAL) {
                switch (rtEvt.getInternalCode()) {
                    case InternalInterface.MG_ACT_REC_PREFIX:
                        flowMonitor.addTaskFlowRec(InternalInterface.MG_ACT_REC_PREFIX, FlowMonitorInterface.FLWMTR_END, this._task.GetTaskDetails());
                        break;
                    case InternalInterface.MG_ACT_REC_SUFFIX:
                        flowMonitor.addTaskFlowRec(InternalInterface.MG_ACT_REC_SUFFIX, FlowMonitorInterface.FLWMTR_END, this._task.GetTaskDetails());
                        break;
                    case InternalInterface.MG_ACT_TASK_PREFIX:
                        flowMonitor.addTaskFlowRec(InternalInterface.MG_ACT_TASK_PREFIX, FlowMonitorInterface.FLWMTR_END, this._task.GetTaskDetails());
                        break;
                    case InternalInterface.MG_ACT_TASK_SUFFIX:
                        flowMonitor.addTaskFlowRec(InternalInterface.MG_ACT_TASK_SUFFIX, FlowMonitorInterface.FLWMTR_END, this._task.GetTaskDetails());
                        break;
                    case InternalInterface.MG_ACT_CTRL_SUFFIX:
                        flowMonitor.addTaskFlowCtrl(InternalInterface.MG_ACT_CTRL_SUFFIX, ctrl.Name, FlowMonitorInterface.FLWMTR_END, this._task.GetTaskDetails());
                        break;
                    case InternalInterface.MG_ACT_CTRL_PREFIX:
                        flowMonitor.addTaskFlowCtrl(InternalInterface.MG_ACT_CTRL_PREFIX, ctrl.Name, FlowMonitorInterface.FLWMTR_END, this._task.GetTaskDetails());
                        break;
                    case InternalInterface.MG_ACT_VARIABLE:
                        flowMonitor.addTaskFlowFld(InternalInterface.MG_ACT_VARIABLE, rtEvt.getFld().getName(), FlowMonitorInterface.FLWMTR_END, this._task.GetTaskDetails());
                        break;
                    case InternalInterface.MG_ACT_CTRL_VERIFICATION:
                        flowMonitor.addTaskFlowCtrl(InternalInterface.MG_ACT_CTRL_VERIFICATION, ctrl.Name, FlowMonitorInterface.FLWMTR_END, this._task.GetTaskDetails());
                        break;
                    default:
                        flowMonitor.addTaskFlowHandler(this._evt.getBrkLevel(true), FlowMonitorInterface.FLWMTR_END, this._task.GetTaskDetails());
                        break;
                }
            }
            else
                flowMonitor.addTaskFlowHandler(this._evt.getBrkLevel(true), 1, this._task.GetTaskDetails());
        }
        finally {
            this._task.setBrkLevel(brkLevel, brkLevelIndex);
        }
        return new RetVals(retVal, true);
    }
    async executeOperations(fromIdx, toIdx, taskEnd, mgdID, depth, isChangedCurrWndRef, inBlockIf, inReturnedFromServer, inNextOperIdx) {
        let oper;
        let operType;
        let nextOperIdx = -1;
        let returnedFromServer = false;
        let mgd = this._task.getMGData();
        let execFlowIdx = fromIdx;
        let retvals;
        let blockIfReturnedFromServer = false;
        let executeBlock;
        let blockLoopExeconServer;
        let flowMonitor = FlowMonitorQueue.Instance;
        let routeOperationExecuted = false;
        if (!inReturnedFromServer) {
            oper = this._operationTab.getOperation(execFlowIdx);
            nextOperIdx = AccessHelper.eventsManager.getNextOperIdx(oper, true);
            if (nextOperIdx > -1) {
                returnedFromServer = true;
                if (inBlockIf)
                    blockIfReturnedFromServer = true;
            }
            else
                returnedFromServer = false;
        }
        else {
            returnedFromServer = inReturnedFromServer;
            nextOperIdx = inNextOperIdx;
        }
        for (; execFlowIdx <= toIdx &&
            (!AccessHelper.eventsManager.GetStopExecutionFlag()) &&
            !mgd.IsAborting && !routeOperationExecuted; execFlowIdx += 1) {
            if (inBlockIf && blockIfReturnedFromServer && this._operationTab.getOperation(toIdx).getServerId() < nextOperIdx)
                break;
            oper = this._operationTab.getOperation(execFlowIdx);
            operType = oper.getType();
            blockIfReturnedFromServer = false;
            if (RemoteCommandsProcessor.GetInstance().DelayCommandExecution) {
                this._task.setUseLoopStack(depth > 0);
                await oper.operServer(null);
                break;
            }
            if (returnedFromServer && oper.getServerId() < nextOperIdx)
                if (operType !== ConstInterface.MG_OPER_BLOCK)
                    continue;
                else if (this._operationTab.getOperation(oper.getBlockEnd()).getServerId() < nextOperIdx)
                    continue;
            if (!taskEnd) {
                let mainLevel = this._task.getMainLevel().toLowerCase();
                if (await this._task.evalEndCond(ConstInterface.END_COND_EVAL_IMMIDIATE) && Environment.Instance.getSpecialImmediateHandlerEnd() &&
                    mainLevel != "RP".toLowerCase() && mainLevel != "TP".toLowerCase() && mainLevel != "RS".toLowerCase() && mainLevel != "TS".toLowerCase())
                    break;
            }
            if (this._taskMgdID !== mgdID)
                isChangedCurrWndRef.value = true;
            if (!this._task.isMainProg() && this._task.isOpenWin())
                AccessHelper.mgDataTable.currMgdID = this._taskMgdID;
            await AccessHelper.eventsManager.CheckAndShowSpinner(true);
            switch (operType) {
                case ConstInterface.MG_OPER_VERIFY:
                    if (await oper.execute(returnedFromServer)) {
                        if (!(this._task.getBrkLevel() === "TS")) {
                            AccessHelper.eventsManager.setStopExecution(true);
                        }
                        if (this._task.getInRecordSuffix() && this._task.getLevel() === Constants.TASK_LEVEL_TASK)
                            this._task.setLevel(Constants.TASK_LEVEL_RECORD);
                        return new RetVals(false, true);
                    }
                    break;
                case ConstInterface.MG_OPER_LOOP:
                    this._task.enterLoop();
                    this._task.increaseLoopCounter();
                    this._task.setUseLoopStack(true);
                    await flowMonitor.addFlowFieldOperation(oper, true, this._task.GetTaskDetails());
                    blockLoopExeconServer = false;
                    if (!oper.getExecOnServer()) {
                        while (await oper.execute(false)) {
                            retvals = await this.executeOperations(execFlowIdx + 1, oper.getBlockClose() - 1, taskEnd, mgdID, depth + 1, isChangedCurrWndRef, false, false, -1);
                            if (retvals !== null)
                                return retvals;
                            if ((mgd.IsAborting || AccessHelper.eventsManager.GetStopExecutionFlag()))
                                break;
                            this._task.increaseLoopCounter();
                            this._task.setUseLoopStack(true);
                        }
                    }
                    else {
                        if (await oper.execute(false))
                            blockLoopExeconServer = true;
                    }
                    if (!blockLoopExeconServer)
                        execFlowIdx = oper.getBlockEnd() - 1;
                    this._task.leaveLoop();
                    break;
                case ConstInterface.MG_OPER_BLOCK:
                    if (!oper.getExecOnServer() || (returnedFromServer && oper.getServerId() < nextOperIdx)) {
                        this._task.setUseLoopStack(true);
                        if (!returnedFromServer || oper.getServerId() >= nextOperIdx)
                            execFlowIdx = await this.getSignificantBlock(execFlowIdx, oper.getBlockEnd());
                        else
                            execFlowIdx = this.getStartBlockIfIdxByOper(execFlowIdx, nextOperIdx);
                    }
                    else {
                        this._task.setUseLoopStack(depth > 0);
                        await oper.operServer(null);
                        nextOperIdx = AccessHelper.eventsManager.getNextOperIdx(oper, true);
                        if (nextOperIdx > -1) {
                            returnedFromServer = true;
                            if (inBlockIf)
                                blockIfReturnedFromServer = true;
                            if (nextOperIdx < this._operationTab.getOperation(oper.getBlockEnd()).getServerId()) {
                                while (this._operationTab.getOperation(oper.getBlockClose()).getServerId() < nextOperIdx) {
                                    execFlowIdx = oper.getBlockClose();
                                    oper = this._operationTab.getOperation(execFlowIdx);
                                }
                            }
                        }
                        else {
                            returnedFromServer = false;
                            execFlowIdx = -1;
                        }
                    }
                    if (execFlowIdx !== -1) {
                        executeBlock = true;
                        oper = this._operationTab.getOperation(execFlowIdx);
                        if (returnedFromServer) {
                            if (this._operationTab.getOperation(oper.getBlockClose()).getServerId() <= nextOperIdx) {
                                executeBlock = false;
                                blockIfReturnedFromServer = true;
                            }
                        }
                        if (executeBlock) {
                            retvals = await this.executeOperations(execFlowIdx + 1, oper.getBlockClose() - 1, taskEnd, mgdID, depth + 1, isChangedCurrWndRef, true, returnedFromServer, nextOperIdx);
                            if (retvals !== null)
                                if (!retvals.ReturnedFromServer)
                                    return retvals;
                                else {
                                    returnedFromServer = retvals.ReturnedFromServer;
                                    nextOperIdx = retvals.NextOperIdx;
                                    blockIfReturnedFromServer = retvals.BlockIfReturnedFromServer;
                                    execFlowIdx = oper.getBlockEnd() - 1;
                                    continue;
                                }
                        }
                    }
                    execFlowIdx = oper.getBlockEnd() - 1;
                    break;
                case ConstInterface.MG_OPER_ENDBLOCK:
                    await flowMonitor.addFlowFieldOperation(oper, true, this._task.GetTaskDetails());
                    break;
                case ConstInterface.MG_OPER_CALL:
                    this._task.setUseLoopStack(depth > 0);
                    routeOperationExecuted = await oper.execute(returnedFromServer);
                    break;
                default:
                    this._task.setUseLoopStack(depth > 0);
                    await oper.execute(returnedFromServer);
                    break;
            }
            if (!blockIfReturnedFromServer) {
                nextOperIdx = AccessHelper.eventsManager.getNextOperIdx(oper, true);
                if (nextOperIdx > -1) {
                    returnedFromServer = true;
                    if (inBlockIf)
                        blockIfReturnedFromServer = true;
                }
                else
                    returnedFromServer = false;
            }
        }
        if (routeOperationExecuted)
            retvals = new RetVals(false, true);
        else if (blockIfReturnedFromServer)
            retvals = new RetVals(nextOperIdx, returnedFromServer, blockIfReturnedFromServer);
        else
            retvals = null;
        return retvals;
    }
    async getSignificantBlock(startBlockIdx, endIdx) {
        let retIdx = -1;
        while (startBlockIdx < endIdx) {
            let oper = this._operationTab.getOperation(startBlockIdx);
            let operType = oper.getType();
            if (operType !== ConstInterface.MG_OPER_BLOCK && operType !== ConstInterface.MG_OPER_ELSE && operType !== ConstInterface.MG_OPER_SERVER)
                break;
            if (await oper.execute(false)) {
                retIdx = startBlockIdx;
                break;
            }
            else
                startBlockIdx = oper.getBlockClose();
        }
        return retIdx;
    }
    getStartBlockIdxByEnd(endIdx) {
        let retIdx = -1;
        let found = false;
        let j;
        for (j = endIdx - 1; j >= 0 && !found; j--) {
            let oper = this._operationTab.getOperation(j);
            let operType = oper.getType();
            if (operType === ConstInterface.MG_OPER_BLOCK || operType === ConstInterface.MG_OPER_LOOP) {
                if (oper.getBlockEnd() === endIdx) {
                    retIdx = j;
                    found = true;
                }
            }
        }
        return retIdx;
    }
    getStartBlockIdxByElse(elseIdx) {
        let retIdx = -1;
        let found = false;
        let elseBlockEnd = this._operationTab.getOperation(elseIdx).getBlockEnd();
        let j;
        for (j = elseIdx - 1; j >= 0 && !found; j--) {
            let oper = this._operationTab.getOperation(j);
            let operType = oper.getType();
            if (operType === ConstInterface.MG_OPER_BLOCK) {
                if (oper.getBlockEnd() === elseBlockEnd) {
                    retIdx = j;
                    found = true;
                }
            }
        }
        return retIdx;
    }
    getStartBlockIfIdxByOper(blockOperIdx, srvrOperIdx) {
        let retIdx = -1;
        let found = false;
        let j = this._operationTab.serverId2operIdx(srvrOperIdx, blockOperIdx) - 1;
        if (j === -2) {
            j = this._operationTab.serverId2FollowingOperIdx(srvrOperIdx, blockOperIdx) - 1;
        }
        while (j >= 0 && !found) {
            let oper = this._operationTab.getOperation(j);
            let operType = oper.getType();
            if (operType === ConstInterface.MG_OPER_BLOCK) {
                if (j === blockOperIdx) {
                    retIdx = j;
                    found = true;
                }
                else
                    j--;
            }
            else if (operType === ConstInterface.MG_OPER_ELSE) {
                let blockStrt = this.getStartBlockIdxByElse(j);
                if (blockStrt === blockOperIdx) {
                    retIdx = j;
                    found = true;
                }
                else
                    j = blockStrt - 1;
            }
            else if (operType === ConstInterface.MG_OPER_ENDBLOCK)
                j = this.getStartBlockIdxByEnd(j) - 1;
            else
                j--;
        }
        return retIdx;
    }
    getLevel() {
        return this._level;
    }
    getEvent() {
        return this._evt;
    }
    getId() {
        return this._id;
    }
    async isEnabled() {
        return await this._enabledExp.getVal();
    }
    async resetLocalVariables(args) {
        let dv = this._task.DataView;
        let argIdx = 0;
        try {
            for (let fieldIdx = this._dvPos; fieldIdx < this._dvPos + this._dvLen; fieldIdx++) {
                let aField = dv.getField(fieldIdx);
                let varIsParm = !this._hasParameters || aField.isParam();
                if ((args !== null && argIdx < args.getSize()) && varIsParm) {
                    if (!args.getArg(argIdx).skipArg()) {
                        await args.getArg(argIdx).setValueToField(aField);
                    }
                    else {
                        aField.invalidate(true, FieldBase.CLEAR_FLAGS);
                        await aField.compute(false);
                    }
                    argIdx++;
                }
                else {
                    aField.invalidate(true, FieldBase.CLEAR_FLAGS);
                    await aField.compute(false);
                }
                await aField.updateDisplay();
            }
        }
        catch (exception) {
            throw exception;
        }
    }
    async getArgValsFromFlds(args) {
        let dv = this._task.DataView;
        let k = 0;
        let j;
        for (j = this._dvPos; j < this._dvPos + this._dvLen && k < args.getSize(); j++) {
            let aField = dv.getField(j);
            if (!this._hasParameters || aField.isParam()) {
                let arg = args.getArg(k);
                if (arg.getType() === ConstInterface.ARG_TYPE_FIELD) {
                    let argFld = arg.getField();
                    if (argFld.getTask() !== null && !argFld.getTask().isAborting()) {
                        let val = aField.getValue(false);
                        await argFld.setValueAndStartRecompute(val, aField.isNull(), true, aField.isModified(), false);
                        await argFld.updateDisplay();
                    }
                }
                k++;
            }
        }
    }
    getTask() {
        return this._task;
    }
    argsMatch(Exp_params) {
        let argsMatched = true;
        let dv = this._task.DataView;
        let j = 0;
        let paramCount = 0;
        for (let i = this._dvPos; i < this._dvPos + this._dvLen; i++) {
            let field = dv.getField(i);
            if (field.isParam()) {
                paramCount++;
                if (j < Exp_params.length) {
                    let fieldAttr = field.getType();
                    let argAttr = Exp_params[j].Attr;
                    if (!Exp_params[j].IsNull && !StorageAttributeCheck.isTheSameType(fieldAttr, argAttr) && !StorageAttributeCheck.StorageFldAlphaUnicodeOrBlob(fieldAttr, argAttr)) {
                        argsMatched = false;
                        break;
                    }
                    j++;
                }
            }
        }
        if (paramCount !== Exp_params.length) {
            argsMatched = false;
        }
        return argsMatched;
    }
    getOperationTab() {
        return this._operationTab;
    }
    getControlNameForControlHeader() {
        if (this.getEvent().getType() == ConstInterface.EVENT_TYPE_INTERNAL) {
            if (this.getEvent().isControlHeader() && !isNullOrUndefined(this._ctrl))
                return this.getCtrlName();
        }
        return NString.Empty;
    }
    getVarNameForVariableHeader() {
        if (this.getEvent().isVariableHeader() && !isNullOrUndefined(this._handlerFld))
            return this._handlerFld.getVarName().toUpperCase();
        return NString.Empty;
    }
    getEventHandlerInfo() {
        let eventDescription = new StringBuilder();
        this.getEvent().AppendDescription(eventDescription);
        let headerAdditionalInfo = this.getControlNameForControlHeader() + this.getVarNameForVariableHeader();
        eventDescription.Append(headerAdditionalInfo);
        if (!NString.IsNullOrEmpty(eventDescription.toString()))
            eventDescription = new StringBuilder(' ' + eventDescription.toString(), eventDescription.toString().length + 1);
        return NString.Format("Handler {0}{1}", this.getEvent().getEventType(), eventDescription);
    }
    toString() {
        return NString.Format("(Handler for {0} on task {1}, scope {2})", this._evt, this._task, this._scope);
    }
}
class RetVals {
    constructor(pOrOperIdx, eOrInReturnedFromServer, inBlockIfReturnedFromServer) {
        this.BlockIfReturnedFromServer = false;
        this.Enabled = false;
        this.NextOperIdx = 0;
        this.Propagate = false;
        this.ReturnedFromServer = false;
        if (arguments.length === 2)
            this.constructor_0(pOrOperIdx, eOrInReturnedFromServer);
        else
            this.constructor_1(pOrOperIdx, eOrInReturnedFromServer, inBlockIfReturnedFromServer);
    }
    constructor_0(p, e) {
        this.Propagate = p;
        this.Enabled = e;
        this.NextOperIdx = 0;
        this.ReturnedFromServer = false;
        this.BlockIfReturnedFromServer = false;
    }
    constructor_1(operIdx, inReturnedFromServer, inBlockIfReturnedFromServer) {
        this.Propagate = false;
        this.Enabled = true;
        this.NextOperIdx = operIdx;
        this.ReturnedFromServer = inReturnedFromServer;
        this.BlockIfReturnedFromServer = inBlockIfReturnedFromServer;
    }
}

class HandlersTable {
    constructor() {
        this._handlers = null;
        this._handlers = new List();
    }
    fillData(taskRef, parser) {
        while (this.initInnerObjects(parser, parser.getNextTag(), taskRef)) {
        }
    }
    initInnerObjects(parser, foundTagName, taskRef) {
        if (foundTagName === null)
            return false;
        if (foundTagName === ConstInterface.MG_TAG_EVENTHANDLERS) {
            parser.setCurrIndex(parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex()) + 1);
        }
        else {
            if (foundTagName === ConstInterface.MG_TAG_HANDLER) {
                let eventHandler = new EventHandler();
                eventHandler.fillData(taskRef, parser);
                this._handlers.push(eventHandler);
            }
            else {
                if (foundTagName === '/' + ConstInterface.MG_TAG_EVENTHANDLERS) {
                    parser.setCurrIndex2EndOfTag();
                    return false;
                }
                Logger.Instance.WriteExceptionToLogWithMsg("There is no such tag in HandlersTable. Insert else if to HandlersTable.initInnerObjects for " + foundTagName);
                return false;
            }
        }
        return true;
    }
    add(handler) {
        this._handlers.push(handler);
    }
    remove(idx) {
        this._handlers.RemoveAt(idx);
    }
    insertAfter(handler, idx) {
        this._handlers.Insert(idx, handler);
    }
    getSize() {
        return this._handlers.length;
    }
    getHandler(idx) {
        if (idx < 0 || idx >= this._handlers.length)
            return null;
        return this._handlers.get_Item(idx);
    }
    hasExpressionHandler() {
        let found = false;
        for (let i = 0; i < this._handlers.length; i++) {
            let evt = this.getHandler(i).getEvent();
            if (evt.getType() === ConstInterface.EVENT_TYPE_EXPRESSION ||
                (evt.getType() === ConstInterface.EVENT_TYPE_USER && evt.getUserEventType() === ConstInterface.EVENT_TYPE_EXPRESSION))
                return true;
        }
        return found;
    }
    startTimers(mgd) {
        let guiManager = GUIManager.Instance;
        if (this._handlers !== null) {
            let timersVector = this.getTimersVector();
            for (let i = 0; i < timersVector.length; i++)
                guiManager.startTimer(mgd, timersVector.get_Item(i), false);
        }
    }
    getTimersVector() {
        let timers = new List();
        for (let i = 0; i < this._handlers.length; i++) {
            let timerEvt = this.getHandler(i).getEvent();
            let sec;
            if (timerEvt.getType() === ConstInterface.EVENT_TYPE_TIMER)
                sec = timerEvt.getSeconds();
            else
                sec = timerEvt.getSecondsOfUserEvent();
            let timerExists = false;
            for (let j = 0; j < timers.length; j++) {
                if (sec === timers.get_Item(j)) {
                    timerExists = true;
                    break;
                }
            }
            if (!timerExists) {
                timers.push(sec);
            }
        }
        return timers;
    }
}

class RecomputeTable {
    fillAttributes(parser) {
        let endContext = parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex());
        let Index = parser.getXMLdata().indexOf(XMLConstants.MG_TAG_RECOMPUTE, parser.getCurrIndex()) + XMLConstants.MG_TAG_RECOMPUTE.length;
        let task = null;
        let tokensVector = XmlParser.getTokens(parser.getXMLdata().substr(Index, endContext - Index), '"');
        for (let j = 0; j < tokensVector.length; j += 2) {
            let attribute = (tokensVector.get_Item(j));
            let valueStr = (tokensVector.get_Item(j + 1));
            if (attribute === XMLConstants.MG_ATTR_TASKID)
                task = AccessHelper.mgDataTable.GetTaskByID(valueStr);
            else
                Logger.Instance.WriteExceptionToLogWithMsg(NString.Format("Unrecognized attribute: '{0}'", attribute));
        }
        parser.setCurrIndex(parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex()) + 1);
        return task;
    }
    fillData(parser) {
        let task = this.fillAttributes(parser);
        if (task !== null) {
            Logger.Instance.WriteDevToLog("goes to refill recompute");
            this.fillData_1(task.DataView, task, parser);
        }
        else
            parser.setCurrIndex(parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex()) + 1);
    }
    fillData_1(dataView, task, parser) {
        if (parser.getNextTag() == XMLConstants.MG_TAG_RECOMPUTE) {
            let currrentIndex = parser.getCurrIndex();
            let encoded = parser.ReadContentOfCurrentElement().trim();
            let decoded = Base64.decode(encoded.substr(0, encoded.length).trim());
            let newXmlData = parser.getXMLdata().replace(encoded.trim(), decoded);
            parser.setXMLdata(newXmlData);
            parser.setCurrIndex(currrentIndex);
        }
        while (this.initInnerObjects(parser, parser.getNextTag(), dataView, task)) {
        }
    }
    initInnerObjects(parser, nameOfFound, dataView, task) {
        if (nameOfFound === null)
            return false;
        if (nameOfFound === XMLConstants.MG_TAG_RECOMPUTE)
            parser.setCurrIndex(parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex()) + 1);
        else if (nameOfFound === XMLConstants.MG_TAG_FLD) {
            let recompute = new Recompute();
            recompute.fillData(dataView, task, parser);
        }
        else if (nameOfFound === '/' + XMLConstants.MG_TAG_RECOMPUTE) {
            parser.setCurrIndex2EndOfTag();
            return false;
        }
        else {
            Logger.Instance.WriteExceptionToLogWithMsg("There is no such tag in <recompute>, add case to RecomputeTable.initInnerObjects for " + nameOfFound);
            return false;
        }
        return true;
    }
}

class Expression {
    constructor() {
        this._cmdToServer = null;
        this._cmdsToServer = null;
        this._computeBy = '\0';
        this._expBytes = null;
        this._id = -1;
        this._prevResType = StorageAttribute.NONE;
        this._resultValue = null;
        this._task = null;
        this._type = StorageAttribute.NONE;
        this._clientStorageAttribute = StorageAttribute.NONE;
    }
    GetStorageAttribute() {
        return this._clientStorageAttribute;
    }
    async evaluateWithResultTypeAndLength(resType, length) {
        let retVal;
        let retExpressionStorage = StorageAttribute.NONE;
        if (this.computedByClient()) {
            let expVal = await ExpressionEvaluator.eval(this._expBytes, resType, this._task);
            if (expVal.IsNull)
                retVal = null;
            else if (resType === StorageAttribute.BLOB_VECTOR && expVal.Attr === StorageAttribute.BLOB) {
                if (VectorType.validateBlobContents(expVal.StrVal))
                    retVal = expVal.ToMgVal();
                else
                    retVal = null;
            }
            else if (expVal.Attr === StorageAttribute.BLOB_VECTOR && resType !== StorageAttribute.BLOB_VECTOR && resType !== StorageAttribute.BLOB)
                retVal = null;
            else
                retVal = expVal.ToMgVal();
            if (!expVal.IsNull)
                retExpressionStorage = expVal.Attr;
        }
        else {
            let rtEvt = AccessHelper.eventsManager.getLastRtEvent();
            let mprgCreator = null;
            if (rtEvt !== null)
                mprgCreator = rtEvt.getMainPrgCreator();
            if (resType !== this._prevResType)
                this._cmdToServer = CommandFactory.CreateEvaluateCommand(this._task.getTaskTag(), resType, this._id, length, mprgCreator);
            await AccessHelper.mgDataTable.execRequestWithSubformRecordCycle(this._cmdsToServer, this._cmdToServer, this);
            if (resType !== StorageAttribute.BLOB && resType !== StorageAttribute.BLOB_VECTOR)
                retVal = this._resultValue;
            else if (this._resultValue !== null && this._resultValue === " ")
                retVal = "";
            else
                retVal = RecordUtils.byteStreamToString(this._resultValue);
        }
        this._prevResType = resType;
        if (resType === StorageAttribute.NONE)
            this._clientStorageAttribute = retExpressionStorage;
        return retVal;
    }
    async DiscardCndRangeResult() {
        return await ExpressionEvaluator.DiscardCndRangeResult(this._expBytes, this._task);
    }
    async evaluateWithResType(resType) {
        let isNull = false;
        let expVal;
        if (this.computedByClient())
            expVal = await ExpressionEvaluator.eval(this._expBytes, resType, this._task);
        else {
            let rtEvt = AccessHelper.eventsManager.getLastRtEvent();
            let mprgCreator = null;
            if (rtEvt !== null)
                mprgCreator = rtEvt.getMainPrgCreator();
            if (resType !== this._prevResType)
                this._cmdToServer = CommandFactory.CreateEvaluateCommand(this._task.getTaskTag(), resType, this._id, 0, mprgCreator);
            await AccessHelper.mgDataTable.execRequestWithSubformRecordCycle(this._cmdsToServer, this._cmdToServer, this);
            let retVal;
            if (resType !== StorageAttribute.BLOB && resType !== StorageAttribute.BLOB_VECTOR)
                retVal = this._resultValue;
            else if (this._resultValue !== null && this._resultValue === " ")
                retVal = "";
            else
                retVal = RecordUtils.byteStreamToString(this._resultValue);
            if (retVal === null)
                isNull = true;
            if (resType === StorageAttribute.NONE)
                resType = this._type;
            expVal = new ExpVal(resType, isNull, retVal);
        }
        this._prevResType = resType;
        return expVal;
    }
    async evaluateWithResLength(length) {
        let resType = StorageAttribute.NONE;
        let val;
        if (this.computedByClient()) {
            let expVal = await ExpressionEvaluator.eval(this._expBytes, resType, this._task);
            if (expVal.IsNull)
                val = null;
            else
                val = expVal.ToMgVal();
            resType = expVal.Attr;
        }
        else {
            val = await this.evaluateWithResultTypeAndLength(resType, length);
            resType = this._type;
        }
        return new Expression_ReturnValue(val, resType);
    }
    fillData(taskRef, parser) {
        let tokensVector;
        let endContext = parser.getXMLdata().indexOf(XMLConstants.TAG_TERM, parser.getCurrIndex());
        if (this._task == null)
            this._task = taskRef;
        if (endContext !== -1 && endContext < parser.getXMLdata().length) {
            let tag = parser.getXMLsubstring(endContext);
            parser.add2CurrIndex(tag.indexOf(ConstInterface.MG_TAG_EXP) + ConstInterface.MG_TAG_EXP.length);
            tokensVector = XmlParser.getTokens(parser.getXMLsubstring(endContext), XMLConstants.XML_ATTR_DELIM);
            this.initElements(tokensVector);
            parser.setCurrIndex(endContext + XMLConstants.TAG_TERM.length);
        }
        else
            Logger.Instance.WriteExceptionToLogWithMsg("in Command.FillData() out of string bounds");
    }
    initElements(tokensVector) {
        let expStr;
        let attribute, valueStr;
        for (let j = 0; j < tokensVector.length; j += 2) {
            attribute = (tokensVector.get_Item(j));
            valueStr = (tokensVector.get_Item(j + 1));
            switch (attribute) {
                case XMLConstants.MG_ATTR_VALUE:
                    if (Environment.Instance.GetDebugLevel() > 1) {
                        expStr = valueStr;
                        this.buildByteArray(expStr);
                    }
                    else
                        this._expBytes = Misc.ToSByteArray(Base64.decodeToByte(valueStr));
                    break;
                case XMLConstants.MG_ATTR_ID:
                    this._id = XmlParser.getInt(valueStr);
                    break;
                case ConstInterface.MG_ATTR_COMPUTE_BY:
                    this._computeBy = valueStr[0];
                    break;
                default:
                    Logger.Instance.WriteExceptionToLogWithMsg("There is no such tag in Expression.initElements class. Insert case to Expression.initElements for " + attribute);
                    break;
            }
        }
        if (!this.computedByClient())
            this._cmdsToServer = this._task.getMGData().CmdsToServer;
    }
    buildByteArray(expStr) {
        if (expStr === null || expStr.length === 0 || expStr.length % 2 > 0) {
            Logger.Instance.WriteExceptionToLogWithMsg("in Expression.buildByteArray() expStr cannot be changed " + expStr);
            return;
        }
        this._expBytes = new Int8Array(expStr.length / 2);
        for (let i = 0; i < expStr.length; i = i + 2) {
            let twoHexDigits = expStr.substr(i, 2);
            this._expBytes[i / 2] = NUM_TYPE.toSByte(NNumber.Parse(twoHexDigits, NumberStyles.HexNumber));
        }
    }
    getId() {
        return this._id;
    }
    computedByClient() {
        return this._computeBy !== 'S';
    }
    computedByClientOnly() {
        return this._computeBy === 'C';
    }
    computedByServerOnly() {
        return this._computeBy === 'S';
    }
    getTask() {
        return this._task;
    }
    SetResultValue(result, type_) {
        this._resultValue = result;
        this._type = type_;
    }
    toString() {
        return NString.Format("{{Expression #{0} of {1}}}", this._id, this._task);
    }
}
class Expression_ReturnValue {
    constructor(mgVal_, type_) {
        this.mgVal = null;
        this.type = StorageAttribute.NONE;
        this.mgVal = mgVal_;
        this.type = type_;
    }
}

class ExpTable {
    constructor() {
        this._exps = new List();
    }
    fillData(task, parser) {
        while (this.initInnerObjects(parser, parser.getNextTag(), task)) {
        }
    }
    initInnerObjects(parser, foundTagName, task) {
        if (foundTagName === null)
            return false;
        if (foundTagName === ConstInterface.MG_TAG_EXP) {
            let expression = new Expression();
            expression.fillData(task, parser);
            this._exps.push(expression);
        }
        else if (foundTagName === ConstInterface.MG_TAG_EXPTABLE) {
            parser.setCurrIndex(parser.getXMLdata().indexOf(">", parser.getCurrIndex()) + 1);
        }
        else if (foundTagName === ('/' + ConstInterface.MG_TAG_EXPTABLE)) {
            parser.setCurrIndex2EndOfTag();
            return false;
        }
        else {
            Logger.Instance.WriteExceptionToLogWithMsg("There is no such tag in ExpTable.initInnerObjects(): " + foundTagName);
            return false;
        }
        return true;
    }
    getExpById(id) {
        let exp;
        if (id < 0)
            return null;
        for (let i = 0; i < this._exps.length; i++) {
            exp = this._exps.get_Item(i);
            if (exp.getId() === id)
                return exp;
            exp = null;
        }
        return exp;
    }
    getExp(idx) {
        let exp = null;
        if (idx >= 0 && idx < this._exps.length)
            exp = this._exps.get_Item(idx);
        return exp;
    }
    getSize() {
        let count = 0;
        if (this._exps !== null)
            count = this._exps.length;
        return count;
    }
}

class UserEventsTable {
    constructor() {
        this._userEventsTab = null;
        this._userEventsTab = new List();
    }
    fillData(tsk, parser) {
        while (this.initInnerObjects(parser, parser.getNextTag(), tsk)) {
        }
    }
    initInnerObjects(parser, foundTagName, tsk) {
        if (foundTagName === null)
            return false;
        switch (foundTagName) {
            case ConstInterface.MG_TAG_EVENT: {
                let evt = new Event();
                evt.fillData(parser, tsk);
                this._userEventsTab.push(evt);
                break;
            }
            case ConstInterface.MG_TAG_USER_EVENTS:
                parser.setCurrIndex(parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex()) + 1);
                break;
            case ConstInterface.MG_TAG_USER_EVENTS_END:
                parser.setCurrIndex2EndOfTag();
                return false;
            default:
                Logger.Instance.WriteExceptionToLogWithMsg("There is no such tag in UserEventsTable.initInnerObjects : " + foundTagName);
                return false;
        }
        return true;
    }
    getEvent(idx) {
        if (idx < 0 || this._userEventsTab === null || idx >= this._userEventsTab.length)
            return null;
        return this._userEventsTab.get_Item(idx);
    }
    getSize() {
        if (this._userEventsTab === null)
            return 0;
        return this._userEventsTab.length;
    }
}

class FormsTable {
    get Count() {
        return this._formsStringXml.length;
    }
    get_Item(formDisplayIndex) {
        if (formDisplayIndex > 0 && formDisplayIndex <= this._formsStringXml.length)
            return this._formsStringXml.get_Item(formDisplayIndex - 1);
        return null;
    }
    constructor(task, parentForm) {
        this._task = null;
        this._parentForm = null;
        this._formsStringXml = null;
        this._task = task;
        this._parentForm = parentForm;
    }
    async fillData() {
        this._formsStringXml = new List();
        let parser = Manager.GetCurrentRuntimeContext().Parser;
        while (await this.initInnerObjects(parser.getNextTag())) {
        }
    }
    InitFormFromXmlString(formDisplayIndex) {
        let formStrXml = this.get_Item(1);
        if (formDisplayIndex > 0 && formDisplayIndex <= this._formsStringXml.length)
            formStrXml = this.get_Item(formDisplayIndex);
        if (formStrXml !== null) {
            RuntimeContextBase.Instance.Parser.push();
            RuntimeContextBase.Instance.Parser.PrepareFormReadString(formStrXml);
            this._task.FormInitData(this._parentForm);
            RuntimeContextBase.Instance.Parser.pop();
        }
    }
    async initInnerObjects(foundTagName) {
        if (foundTagName === null)
            return false;
        let parser = Manager.GetCurrentRuntimeContext().Parser;
        if (foundTagName === XMLConstants.MG_TAG_FORMS) {
            parser.setCurrIndex(parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex()) + 1);
        }
        else if (foundTagName === XMLConstants.MG_TAG_FORM) {
            let formStringXml = RuntimeContextBase.Instance.Parser.ReadToEndOfCurrentElement();
            this._formsStringXml.push(formStringXml);
            return true;
        }
        else if (foundTagName === ('/' + XMLConstants.MG_TAG_FORM)) {
            parser.setCurrIndex2EndOfTag();
            return true;
        }
        else if (foundTagName === ('/' + XMLConstants.MG_TAG_FORMS)) {
            await this.PrepareMainDisplayForConnectedTask();
            parser.setCurrIndex2EndOfTag();
            return false;
        }
        return true;
    }
    async PrepareMainDisplayForConnectedTask() {
        if (this._task.TaskService instanceof RemoteTaskService)
            await this._task.PrepareTaskForm();
    }
}

class ActionManager {
    constructor() {
        this._actCount = null;
        this._actState = null;
        this._numerator = 0;
        this._numerator = 0;
        this._actState = new Array(InternalInterface.MG_ACT_TOT_CNT);
        for (let _ai = 0; _ai < this._actState.length; ++_ai)
            this._actState[_ai] = false;
        this._actCount = new Array(InternalInterface.MG_ACT_TOT_CNT);
        for (let _ai = 0; _ai < this._actCount.length; ++_ai)
            this._actCount[_ai] = 0;
    }
    enable(act, enable) {
        this._actState[act] = enable;
        if (enable) {
            this._numerator++;
            this._actCount[act] = this._numerator;
        }
    }
    isEnabled(act) {
        return this._actState[act];
    }
    getActCount(act) {
        return this._actCount[act];
    }
    enableList(act, enable, onlyIfChanged) {
        for (let i = 0; i < act.length; i = i + 1) {
            let num = act[i];
            let flag = !onlyIfChanged || this._actState[num] !== enable;
            if (flag) {
                this.enable(num, enable);
            }
        }
    }
    enableNavigationActions(enable) {
        this.enableList(ActionManager.actNavigation, enable, false);
    }
}
ActionManager.actEnabled = [
    InternalInterface.MG_ACT_CLOSE, InternalInterface.MG_ACT_EXIT,
    InternalInterface.MG_ACT_RTO_MODIFY,
    InternalInterface.MG_ACT_RTO_CREATE,
    InternalInterface.MG_ACT_RTO_QUERY, InternalInterface.MG_ACT_OK,
    InternalInterface.MG_ACT_CANCEL,
    InternalInterface.MG_ACT_TBL_PRVFLD,
    InternalInterface.MG_ACT_TBL_NXTFLD,
    InternalInterface.MG_ACT_TBL_BEGLINE,
    InternalInterface.MG_ACT_TBL_ENDLINE,
    InternalInterface.MG_ACT_TBL_BEGPAGE,
    InternalInterface.MG_ACT_TAB_NEXT,
    InternalInterface.MG_ACT_TAB_PREV,
    InternalInterface.MG_ACT_TBL_ENDPAGE,
    InternalInterface.MG_ACT_USING_HELP,
    InternalInterface.MG_ACT_ABOUT,
    InternalInterface.MG_ACT_CTRL_HIT, InternalInterface.MG_ACT_HIT,
    InternalInterface.MG_ACT_WEB_ON_DBLICK,
    InternalInterface.MG_ACT_WEB_CLICK,
    InternalInterface.MG_ACT_RT_REFRESH_RECORD,
    InternalInterface.MG_ACT_RT_REFRESH_SCREEN,
    InternalInterface.MG_ACT_RT_REFRESH_VIEW,
    InternalInterface.MG_ACT_RT_QUIT,
    InternalInterface.MG_ACT_SERVER_TERMINATION,
    InternalInterface.MG_ACT_SUBFORM_REFRESH,
    InternalInterface.MG_ACT_SUBFORM_CLOSE,
    InternalInterface.MG_ACT_EXIT_SYSTEM,
    InternalInterface.MG_ACT_SUBFORM_OPEN,
    InternalInterface.MG_ACT_COL_SORT,
    InternalInterface.MG_ACT_CTRL_MODIFY,
    InternalInterface.MG_ACT_ROLLBACK,
    InternalInterface.MG_ACT_EXT_EVENT,
    InternalInterface.MG_ACT_COL_CLICK,
    InternalInterface.MG_ACT_PRESS,
    InternalInterface.MG_ACT_ENABLE_EVENTS,
    InternalInterface.MG_ACT_COL_FILTER,
    InternalInterface.MG_ACT_INDEX_CHANGE,
    InternalInterface.MG_ACT_WEBCLIENT_ROUTE,
    InternalInterface.MG_ACT_SET_EXTERNAL_VALUE,
    InternalInterface.MG_ACT_FETCH_RECORDS_AHEAD_FROM_SERVER,
    InternalInterface.MG_ACT_CONTEXT_REMOVE
];
ActionManager.actNavigation = [
    InternalInterface.MG_ACT_TBL_PRVLINE,
    InternalInterface.MG_ACT_TBL_PRVPAGE,
    InternalInterface.MG_ACT_TBL_BEGTBL,
    InternalInterface.MG_ACT_TBL_NXTLINE,
    InternalInterface.MG_ACT_TBL_NXTPAGE,
    InternalInterface.MG_ACT_TBL_ENDTBL
];

class GlobalCommandsManager {
    constructor() {
        this._CommandsExecutedAfterTaskStarted = null;
        this._cmdFrame = 0;
        this._unframedCmds = null;
        this._CommandsExecutedAfterTaskStarted = new List();
        this._cmdFrame = 0;
        this._unframedCmds = new List();
    }
    getCommandsExecutedAfterTaskStarted() {
        return this._CommandsExecutedAfterTaskStarted;
    }
    addCommandsExecutedAfterTaskStarted(cmd) {
        this._CommandsExecutedAfterTaskStarted.push(cmd);
    }
    removeCommandsExecutedAfterTaskStarted(cmd) {
        this._CommandsExecutedAfterTaskStarted.Remove(cmd);
    }
    add1toCmdFrame() {
        this._cmdFrame++;
    }
    getCmdFrame() {
        return this._cmdFrame;
    }
    addUnframedCmd(cmd) {
        this._unframedCmds.push(cmd);
    }
    getUnframedCmds() {
        return this._unframedCmds;
    }
}
GlobalCommandsManager.Instance = new GlobalCommandsManager();

var EventsAllowedType;
(function (EventsAllowedType) {
    EventsAllowedType[EventsAllowedType["NONE"] = 0] = "NONE";
    EventsAllowedType[EventsAllowedType["NON_INTERACTIVE"] = 1] = "NON_INTERACTIVE";
    EventsAllowedType[EventsAllowedType["ALL"] = 2] = "ALL";
})(EventsAllowedType || (EventsAllowedType = {}));

var Task_Flow;
(function (Task_Flow) {
    Task_Flow[Task_Flow["NONE"] = 0] = "NONE";
    Task_Flow[Task_Flow["STEP"] = 1] = "STEP";
    Task_Flow[Task_Flow["FAST"] = 2] = "FAST";
})(Task_Flow || (Task_Flow = {}));
var Task_Direction;
(function (Task_Direction) {
    Task_Direction[Task_Direction["BACK"] = -1] = "BACK";
    Task_Direction[Task_Direction["NONE"] = 0] = "NONE";
    Task_Direction[Task_Direction["FORE"] = 1] = "FORE";
})(Task_Direction || (Task_Direction = {}));
class Task extends TaskBase {
    get ParentTask() {
        return this._parentTask;
    }
    set TryingToCommit(value) {
        this._tryingToCommit = value;
    }
    get TryingToCommit() {
        return this._tryingToCommit;
    }
    get TaskService() {
        if (this._taskService == null)
            this._taskService = new RemoteTaskService();
        return this._taskService;
    }
    static get CommandsProcessor() {
        return CommandsProcessorManager.GetCommandsProcessor();
    }
    get LogicalStudioParentTask() {
        if (this.StudioParentTask === null && !super.isMainProg()) {
            return GuiDataCollection.MGDataTable.GetMainProgByCtlIdx(this.ContextID, this._ctlIdx);
        }
        return this.StudioParentTask;
    }
    get KnownToServer() {
        return this._knownToServer;
    }
    set Transaction(value) {
        this.DataviewManager.CurrentDataviewManager.Transaction = value;
    }
    get Transaction() {
        return this.DataviewManager.CurrentDataviewManager.Transaction;
    }
    get TaskDefinitionId() {
        if (this.taskDefinitionId === null) {
            this.taskDefinitionId = new TaskDefinitionId(this._ctlIdx, this.ProgramIsn, this.TaskIsn, this._isPrg);
        }
        return this.taskDefinitionId;
    }
    static get IsBlockingBatch() {
        return false;
    }
    constructor(parent) {
        super();
        this._dvCache = null;
        this._mgData = null;
        this._aborting = false;
        this._bExecEndTask = false;
        this._isStarted = false;
        this._evalOldValues = false;
        this._inRecordSuffix = false;
        this._cancelWasRaised = false;
        this._counter = 0;
        this._currStartProgLevel = 0;
        this._destinationSubform = false;
        this._enableZoomHandler = false;
        this._firstRecordCycle = false;
        this._originalTaskMode = ' ';
        this._inCreateLine = false;
        this.InSelect = false;
        this.InStartProcess = false;
        this._isDestinationCall = false;
        this._knownToServer = true;
        this._loopStack = null;
        this.DelayCommandExecution = false;
        this._parentTask = null;
        this.ContextTask = null;
        this._triggeringTask = null;
        this.PathParentTask = null;
        this._preventControlChange = false;
        this._preventRecordSuffix = false;
        this._taskPath = null;
        this._tryingToCommit = false;
        this._useLoopStack = false;
        this._inProcessingTopMostEndTaskSaved = false;
        this.InHandleActCancel = false;
        this.RuntimeSorts = null;
        this.VewFirst = 0;
        this.dataViewContent = null;
        this.PerformParentRecordPrefix = false;
        this.ModeAsParent = false;
        this.TaskTransactionManager = null;
        this.ExecuteClientSubformRefresh = false;
        this.InCommonHandlerBeforeRP = false;
        this._taskService = null;
        this.hasLocate = false;
        this.taskDefinitionId = null;
        this.ArgumentsList = null;
        this.ConfirmUpdateNo = false;
        this.DataSynced = false;
        this.UniqueSort = null;
        this.RefreshOnVars = null;
        this.DvPosDescriptor = null;
        this.SubTasks = null;
        this.ExpTab = null;
        this.UserEvtTab = null;
        this.DataviewHeadersTable = null;
        this.HandlersTab = null;
        this._forms = null;
        this.Name = null;
        this.PublicName = null;
        this.TaskSuffixExecuted = false;
        this.RetrunValueExp = 0;
        this.SubformControl = null;
        if (isNullOrUndefined(parent)) {
            this.constructor_0();
            return;
        }
        this.constructor_1(parent);
    }
    constructor_0() {
        this.ActionManager = new ActionManager();
        this.DataView = new DataView(this);
        this._flowMonitor = FlowMonitorQueue.Instance;
        this.ContextTask = this;
        this._dvCache = new DvCache(this);
        this.PerformParentRecordPrefix = true;
        this.DataviewManager = new DataviewManager(this);
        this.allowRemoteCmdExecution = true;
        this.TaskTransactionManager = new TaskTransactionManager(this);
    }
    Init() {
        this.DataView.Init();
    }
    constructor_1(parent) {
        this.constructor_0();
        this.PathParentTask = parent;
        this._parentTask = parent;
        this._triggeringTask = null;
        this.buildTaskPath();
    }
    static CreateTask() {
        let task = new Task();
        task.Init();
        return task;
    }
    isAborting() {
        return this._aborting;
    }
    buildTaskPath() {
        this._taskPath = new List();
        if (this._parentTask._taskPath !== null)
            this._taskPath.AddRange(this._parentTask._taskPath.GetEnumerator());
        this._taskPath.push(this);
    }
    async fillData(mgd, openingTaskDetails) {
        if (!super.isMainProg()) {
            if (this._parentTask === null && openingTaskDetails.CallingTask !== null) {
                this._parentTask = openingTaskDetails.CallingTask;
                this.buildTaskPath();
                openingTaskDetails.CallingTask.addSubTask(this);
            }
            if (this.PathParentTask === null && openingTaskDetails.PathParentTask !== null) {
                this.PathParentTask = openingTaskDetails.PathParentTask;
            }
        }
        if (this._parentTask !== null && this._parentTask.getEnableZoomHandler()) {
            this.setEnableZoomHandler();
        }
        this._mgData = mgd;
        this.fillAttributes();
        this._mgData.addTask(this);
        let parentForm = (this._parentTask !== null) ? this._parentTask.getForm() : null;
        while (await this.initInnerObjects(RuntimeContextBase.Instance.Parser.getNextTag(), parentForm)) {
        }
        this.TaskTransactionManager.PrepareTransactionProperties(this.DataviewManager.RemoteDataviewManager.Transaction, false);
        this.HandleTriggerTask();
        this.HandlePreviouslyActiveTaskId();
        this.CheckAndSetSubForm();
        if (this.IsSubForm) {
            let subFormCtrl = this.getParent().getForm().getSubFormCtrlForTask(this._taskTag);
            if (subFormCtrl !== null) {
                subFormCtrl.setSubformTaskId(this._taskTag);
            }
            if (this.Form !== null) {
                this.Form.setSubFormCtrl(subFormCtrl);
            }
        }
    }
    HandlePreviouslyActiveTaskId() {
        if (this._parentTask !== null && this._parentTask.GetContextTask() !== null && this._mgData !== this._parentTask.getMGData())
            this.PreviouslyActiveTaskId = (this._parentTask.GetContextTask()).getTaskTag();
        else if (this._parentTask !== null)
            this.PreviouslyActiveTaskId = this._parentTask.getTaskTag();
    }
    HandleTriggerTask() {
        this._triggeringTask = this._parentTask;
    }
    FillTaskTables(taskTablesData) {
        if (arguments.length === 1) {
            this.FillTaskTables_0();
            return;
        }
        this.FillTaskTables_1();
    }
    FillTaskTables_0() {
    }
    fillAttributes() {
        let parser = RuntimeContextBase.Instance.Parser;
        let endContext = parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex());
        if (endContext !== -1 && endContext < parser.getXMLdata().length) {
            super.fillAttributes(parser);
            if (super.isMainProg())
                this._mgData = AccessHelper.mgDataTable.getMGData(0);
        }
        else {
            Logger.Instance.WriteExceptionToLogWithMsg("in Task.fillAttributes() out of string bounds");
        }
    }
    setAttribute(attribute, valueStr) {
        let isTagProcessed;
        isTagProcessed = super.setAttribute(attribute, valueStr);
        if (!isTagProcessed) {
            isTagProcessed = true;
            switch (attribute) {
                case ConstInterface.MG_ATTR_REFRESHON:
                    if (!(valueStr.trim() === ""))
                        this.SetRefreshOnVars(valueStr);
                    break;
                case XMLConstants.MG_ATTR_NAME:
                    this.Name = valueStr;
                    break;
                case ConstInterface.MG_ATTR_DVPOS_DEC:
                    if (!(valueStr.trim() === ""))
                        this.setDescriptor(valueStr);
                    break;
                case ConstInterface.MG_ATTR_HAS_LOCATE:
                    if (+valueStr == 1)
                        this.hasLocate = true;
                    break;
                case ConstInterface.MG_ATTR_AS_PARENT:
                    if (+valueStr == 1)
                        this.ModeAsParent = true;
                    break;
                case ConstInterface.MG_ATTR_TASK_UNIQUE_SORT:
                    this.UniqueSort = valueStr[0];
                    break;
                case ConstInterface.MG_ATTR_TRANS_ID:
                    this.setRemoteTransaction(valueStr);
                    break;
                case ConstInterface.MG_ATTR_PUBLIC:
                    this.PublicName = XmlParser.unescape(valueStr);
                    break;
                case XMLConstants.MG_ATTR_IS_OFFLINE:
                    this.IsOffline = XmlParser.getBoolean(valueStr);
                    break;
                case XMLConstants.MG_ATTR_RETURN_VALUE_EXP:
                    this.RetrunValueExp = XmlParser.getInt(valueStr);
                    break;
                case XMLConstants.MG_ATTR_MENUS_FILE_NAME:
                    break;
                default:
                    isTagProcessed = false;
                    break;
            }
        }
        if (!isTagProcessed)
            Logger.Instance.WriteExceptionToLogWithMsg(NString.Format("Unrecognized attribute: '{0}'", attribute));
        return true;
    }
    async initInnerObjects(foundTagName, parentForm) {
        if (foundTagName == null)
            return false;
        let parser = RuntimeContextBase.Instance.Parser;
        switch (foundTagName) {
            case XMLConstants.MG_TAG_HELPTABLE:
                if (this._helpTab == null)
                    this._helpTab = new Helps();
                if (Events.ShouldLog(Logger_LogLevels.Development))
                    Events.WriteDevToLog(NString.Format("{0} ...", foundTagName));
                this._helpTab.fillData(parser);
                break;
            case XMLConstants.MG_TAG_DVHEADER:
                if (Events.ShouldLog(Logger_LogLevels.Development))
                    Events.WriteDevToLog(NString.Format("{0} ...", foundTagName));
                this.DataView.fillHeaderData(parser);
                break;
            case XMLConstants.MG_TAG_PROP:
                this._propTab.fillData(this, 'T', parser);
                break;
            case XMLConstants.MG_TAG_FORM:
                this.Form = this.FormInitData(parentForm);
                break;
            case XMLConstants.MG_ATTR_MENU_CONTENT:
                break;
            case "assemblies":
                let endContext = parser.getXMLdata().indexOf('/assemblies', parser.getCurrIndex());
                parser.setCurrIndex(endContext);
                parser.setCurrIndex2EndOfTag();
                break;
            case XMLConstants.MG_TAG_FORMS:
                this._forms = new FormsTable(this, parentForm);
                Logger.Instance.WriteDevToLog(NString.Format("{0} ...", foundTagName));
                await this._forms.fillData();
                break;
            case XMLConstants.MG_TAG_TASK:
                if (this.SubTasks == null)
                    this.SubTasks = new TasksTable();
                let subtask = new Task(this);
                subtask.Init();
                this.SubTasks.addTask(subtask);
                let mgd = this._mgData;
                if (this.isMainProg())
                    mgd = AccessHelper.mgDataTable.GetMGDataForStartupProgram();
                await subtask.fillData(mgd, new OpeningTaskDetails());
                break;
            case ConstInterface.MG_TAG_TASKURL:
                await Task.ProcessTaskURL();
                break;
            case ConstInterface.MG_TAG_EXPTABLE:
                if (this.ExpTab == null)
                    this.ExpTab = new ExpTable();
                Logger.Instance.WriteDevToLog("goes to exp");
                this.ExpTab.fillData(this, parser);
                break;
            case ConstInterface.MG_TAG_USER_EVENTS:
                if (this.UserEvtTab == null)
                    this.UserEvtTab = new UserEventsTable();
                Logger.Instance.WriteDevToLog("goes to user event tab");
                this.UserEvtTab.fillData(this, parser);
                break;
            case ConstInterface.MG_TAG_LINKS:
                this.DataviewHeadersTable = new DataviewHeaders(this);
                this.DataviewHeadersTable.fillData(parser);
                break;
            case ConstInterface.MG_TAG_SORTS:
                this.RuntimeSorts = new SortCollection();
                this.RuntimeSorts.fillData(parser);
                break;
            case ConstInterface.MG_TAG_TASK_TABLES:
                this.FillTaskTables();
                break;
            case XMLConstants.MG_TAG_RECOMPUTE:
                Logger.Instance.WriteDevToLog("goes to recompute");
                this.RecomputeFillData(parser);
                break;
            case ConstInterface.MG_TAG_EVENTHANDLERS:
                Logger.Instance.WriteDevToLog("goes to eventhandlers");
                if (this.HandlersTab == null)
                    this.HandlersTab = new HandlersTable();
                this.HandlersTab.fillData(this, parser);
                this.addExpHandlersToMGData();
                break;
            default:
                if (foundTagName === ("/" + XMLConstants.MG_TAG_TASK)) {
                    RuntimeContextBase.Instance.Parser.setCurrIndex2EndOfTag();
                    return false;
                }
                else {
                    Logger.Instance.WriteDevToLog("There is no such tag in Task.initInnerObjects . Enter case for " + foundTagName);
                    return false;
                }
        }
        return true;
    }
    RecomputeFillData(parser) {
        let recomputeTable = new RecomputeTable();
        recomputeTable.fillData_1(this.DataView, this, parser);
    }
    FillTaskTables_1() {
        let parser = RuntimeContextBase.Instance.Parser;
        let endContext = parser.getXMLdata().indexOf(ConstInterface.MG_TAG_TASK_TABLES_END, parser.getCurrIndex());
        endContext = parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, endContext) + XMLConstants.TAG_CLOSE.length;
        let taskTablesData = parser.getXMLsubstring(endContext);
        this.FillTaskTables(taskTablesData);
        parser.setCurrIndex(endContext);
    }
    addExpHandlersToMGData() {
        let idx = 0;
        for (let i = this.HandlersTab.getSize() - 1; i >= 0; i--) {
            let handler = this.HandlersTab.getHandler(i);
            let evt = handler.getEvent();
            if (evt.getType() === ConstInterface.EVENT_TYPE_EXPRESSION ||
                (evt.getType() === ConstInterface.EVENT_TYPE_USER && evt.getUserEventType() === ConstInterface.EVENT_TYPE_EXPRESSION)) {
                this._mgData.addExpHandler(handler, idx);
                idx++;
            }
        }
    }
    SetRefreshOnVars(variables) {
        let strTok = StrUtil.tokenize(variables, ",");
        let fldNum;
        let intVals = new List();
        let i;
        for (i = 0; i < strTok.length; i++) {
            fldNum = NNumber.Parse(strTok[i]);
            intVals.push(fldNum);
        }
        this.RefreshOnVars = new Array(intVals.length);
        for (i = 0; i < intVals.length; i++) {
            fldNum = intVals.get_Item(i);
            this.RefreshOnVars[i] = fldNum;
        }
    }
    setDataSynced(synced) {
        this.DataSynced = synced;
    }
    getField(fldName) {
        return this.DataView.getFieldByName(fldName);
    }
    getExpById(id) {
        if (this.ExpTab !== null)
            return this.ExpTab.getExpById(id);
        else
            Logger.Instance.WriteExceptionToLogWithMsg("in Task.GetExpById(): no expression table");
        return null;
    }
    getExpObjectById(id) {
        return this.getExpById(id);
    }
    GetExpressionStorage(expId) {
        let result = null;
        if (expId > 0) {
            let expById = this.getExpById(expId);
            Debug.Assert(expById !== null);
            result = expById.GetStorageAttribute();
        }
        return result;
    }
    async CalculateExpression(expId, resType, length) {
        let result = null;
        if (expId > 0) {
            let expById = this.getExpById(expId);
            Debug.Assert(expById !== null);
            result = await expById.evaluateWithResultTypeAndLength(resType, length);
        }
        return result;
    }
    async insertRecordTable(invalidate, parser) {
        if (await this.isCached()) {
            let firstTime = this.DataView.getFirstDv();
            if (!firstTime && invalidate) {
                if (!this.hasLocate) {
                    if (this.DataView.IncludesFirst()) {
                        if (!this.DataView.getChanged())
                            this._dvCache.putInCache(this.DataView.replicate());
                        else
                            this._dvCache.removeDvFromCache(this.DataView.getDvPosValue(), true);
                    }
                }
                else
                    this.locatePutInCache();
            }
        }
        await this.DataView.fillData(parser);
        if (invalidate)
            this.DataView.setChanged(false);
    }
    getHandlersTab() {
        return this.HandlersTab;
    }
    async buildXML(message) {
        this.IsAfterRetryBeforeBuildXML = this.getAfterRetry();
        if (this.KnownToServer && !this.IsOffline) {
            message.Append(XMLConstants.START_TAG + XMLConstants.MG_TAG_TASK);
            message.Append(" " + XMLConstants.MG_ATTR_TASKID + "=\"" + this.getTaskTag() + "\"");
            message.Append(" " + ConstInterface.MG_ATTR_TASK_MAINLEVEL + "=\"" + this.getMainLevel() + "\"");
            message.Append(XMLConstants.TAG_CLOSE);
            await this.DataView.buildXML(message);
            if (this.Form != null && this.Form.Opened)
                message.Append(this.Form.GetHiddenControlListXML());
            message.Append("\n   </" + XMLConstants.MG_TAG_TASK + XMLConstants.TAG_CLOSE);
        }
    }
    buildXMLForRngs(message, UserRanges, locate) {
        let i;
        let fld;
        let cellAttr = StorageAttribute.SKIP;
        let toBase64 = (Environment.Instance.GetDebugLevel() <= 1);
        message.Append(XMLConstants.TAG_CLOSE);
        for (i = 0; i < UserRanges.length; i++) {
            message.Append(XMLConstants.START_TAG + ConstInterface.USER_RNG);
            let rng = UserRanges.get_Item(i);
            message.Append(" " + XMLConstants.MG_TAG_FLD + "=\"" + rng.veeIdx + "\"");
            fld = this.DataView.getField(rng.veeIdx - 1);
            let fldAttr = fld.getType();
            if (rng.nullMin)
                message.Append(" " + ConstInterface.NULL_MIN_RNG + "=\"1\"");
            if (!rng.discardMin && rng.min != null) {
                let val = RecordUtils.itemValToXML(rng.min, fldAttr, cellAttr, toBase64);
                message.Append(" " + ConstInterface.MIN_RNG + "=\"" + val + "\"");
            }
            if (rng.nullMax)
                message.Append(" " + ConstInterface.NULL_MAX_RNG + "=\"1\"");
            if (!rng.discardMax && rng.max != null) {
                let val = RecordUtils.itemValToXML(rng.max, fldAttr, cellAttr, toBase64);
                message.Append(" " + ConstInterface.MAX_RNG + "=\"" + val + "\"");
            }
            message.Append(XMLConstants.TAG_TERM);
        }
        if (locate)
            message.Append(XMLConstants.END_TAG + ConstInterface.USER_LOCATES + XMLConstants.TAG_CLOSE);
        else
            message.Append(XMLConstants.END_TAG + ConstInterface.USER_RANGES + XMLConstants.TAG_CLOSE);
    }
    buildXMLForSorts(message) {
        if (this.UserSorts != null && this.UserSorts.length > 0) {
            let i;
            for (i = 0; i < this.UserSorts.length; i++) {
                message.Append(XMLConstants.TAG_CLOSE);
                let srt = this.UserSorts.get_Item(i);
                message.Append(XMLConstants.START_TAG + ConstInterface.SORT);
                message.Append(" " + XMLConstants.MG_TAG_FLD + "=\"" + srt.fldIdx + "\"");
                if (srt.dir)
                    message.Append(" " + ConstInterface.MG_ATTR_DIR + "=\"1\"");
                message.Append(XMLConstants.TAG_TERM);
            }
            this.UserSorts.Clear();
            this.UserSorts = null;
            message.Append(XMLConstants.END_TAG + ConstInterface.MG_TAG_SORTS + XMLConstants.TAG_CLOSE);
        }
    }
    getUserEvent(idx) {
        Debug.Assert(this.UserEvtTab !== null);
        let retEvent = null;
        if (this.UserEvtTab !== null)
            retEvent = this.UserEvtTab.getEvent(idx);
        return retEvent;
    }
    SetMoveToFirstControl(moveToFirstControl) {
        if (moveToFirstControl || !this.IsSubForm) {
            if (this.Form !== null) {
                let alreadyMoved = this.Form.alreadyMovedToFirstControl();
                if (!alreadyMoved)
                    this.Form.MovedToFirstControl = true;
            }
        }
    }
    async Start(moveToFirstControl, callByDestSubForm) {
        let nonInteractiveTask = null;
        if (!this._isStarted) {
            this._isStarted = true;
            this.InitializeExecution();
            this.InStartProcess = true;
            let result = await this.Setup();
            if (!result.Success)
                return null;
            this._inProcessingTopMostEndTaskSaved = AccessHelper.eventsManager.getProcessingTopMostEndTask();
            AccessHelper.eventsManager.setProcessingTopMostEndTask(false);
            await this.EnableActions();
            result = await this.InitializeForm(moveToFirstControl);
            if (!result.Success)
                return null;
            if (!this.IsInteractive && !this._isMainPrg)
                nonInteractiveTask = this;
            this.DataViewWasRetrieved = true;
            let subTasks = this.SubTasks;
            if (this.isMainProg())
                this.SubTasks = null;
            if (this.isMainProg())
                this.SubTasks = subTasks;
            if (!result.Success)
                return null;
            if (this._aborting)
                return null;
            let dataViewCommand = CommandFactory.CreateDataViewCommand(this.getTaskTag(), DataViewCommandType.FirstChunk);
            result = await this.DataviewManager.Execute(dataViewCommand);
            if (!result.Success)
                return null;
            this.ResumeSubformLayout();
        }
        nonInteractiveTask = await this.StartSubTasks(moveToFirstControl, nonInteractiveTask, callByDestSubForm);
        this.InStartProcess = false;
        return nonInteractiveTask;
    }
    InitializeExecution() {
        super.setBrkLevel(ConstInterface.BRK_LEVEL_REC_MAIN, -1);
        this._firstRecordCycle = true;
        this._currStartProgLevel = ((this.IsSubForm && this.getParent().getForm().alreadyMovedToFirstControl())
            ? this.getParent()._currStartProgLevel
            : Task.StartProgLevel);
    }
    async InitializeForm(moveToFirstControl) {
        if (this.Form !== null) {
            this.SetMoveToFirstControl(moveToFirstControl);
            AccessHelper.eventsManager.pushNewExecStacks();
            this.routeParams = this.DataView.GetRouteParams();
            await this.InitForm();
            AccessHelper.eventsManager.popNewExecStacks();
            this.getMGData().StartTimers();
            Commands.beginInvoke();
        }
        return new ReturnResult();
    }
    async StartSubTasks(moveToFirstControl, nonInteractiveTask, callByDestSubForm) {
        if (this.hasSubTasks()) {
            for (let i = 0; i < this.SubTasks.getSize(); i = i + 1) {
                let task = this.SubTasks.getTask(i);
                let tmpNonInteractiveTask = await task.Start(moveToFirstControl, callByDestSubForm);
                if (nonInteractiveTask === null)
                    nonInteractiveTask = tmpNonInteractiveTask;
                else if (tmpNonInteractiveTask !== null)
                    Debug.Assert(false, "more than 1 non interactive in task.start");
            }
        }
        return nonInteractiveTask;
    }
    async EnableActions() {
        let actList = ActionManager.actEnabled;
        this.ActionManager.enableList(actList, true, false);
        if (this.IsSubForm)
            this.ActionManager.enable(InternalInterface.MG_ACT_POST_REFRESH_BY_PARENT, true);
        await this.enableModes();
        if (await this.checkProp(PropInterface.PROP_TYPE_SELECTION, false)) {
            this.ActionManager.enable(InternalInterface.MG_ACT_SELECT, true);
        }
        let enablePrintdata = await this.checkProp(PropInterface.PROP_TYPE_PRINT_DATA, false);
        this.ActionManager.enable(InternalInterface.MG_ACT_PRINT_DATA, enablePrintdata);
        if (this.getEnableZoomHandler())
            this.ActionManager.enable(InternalInterface.MG_ACT_ZOOM, true);
    }
    async ShowError(text) {
        let mlsTransText = LanguageData.Instance.translate(text);
        let mlsTransTitle = LanguageData.Instance.translate(ConstInterface.ERROR_STRING);
        await GUIManager.Instance.MessageBox(mlsTransTitle, mlsTransText, Styles.MSGBOX_ICON_ERROR | Styles.MSGBOX_BUTTON_OK);
    }
    async EndTaskOnError(result, displayError) {
        if (!result.Success && !this.isAborting()) {
            if (this.InStartProcess) {
                await this.endTask(false, false, false);
                if (displayError)
                    await this.ShowError(result.ErrorDescription);
                this.InStartProcess = false;
                return true;
            }
            else {
                if (displayError)
                    await this.ShowError(result.ErrorDescription);
                await AccessHelper.eventsManager.handleInternalEventWithTask(this, InternalInterface.MG_ACT_EXIT);
            }
        }
        return false;
    }
    async Setup() {
        let result;
        this.TaskService.InitTaskPrefixExecutedFlag(this);
        this.TaskSuffixExecuted = false;
        TaskServiceBase.CreateFirstRecord(this);
        let dataViewCommand = CommandFactory.CreateDataViewCommand(this.getTaskTag(), DataViewCommandType.Init);
        result = await this.DataviewManager.Execute(dataViewCommand);
        if (!result.Success)
            return result;
        if (result.Success) {
            let commands = GlobalCommandsManager.Instance.getCommandsExecutedAfterTaskStarted();
            for (let cmdIdx = 0; cmdIdx < commands.length; cmdIdx++) {
                let command = (commands.get_Item(cmdIdx));
                if (command.TaskTag === this.getTaskTag()) {
                    await command.Execute(null);
                    GlobalCommandsManager.Instance.removeCommandsExecutedAfterTaskStarted(command);
                }
            }
            dataViewCommand = CommandFactory.CreateDataViewCommand(this.getTaskTag(), DataViewCommandType.Prepare);
            result = await this.DataviewManager.Execute(dataViewCommand);
        }
        if (result.Success) {
            result = this.TaskService.PrepareTask(this);
            if (!result.Success)
                await this.EndTaskOnError(result, true);
        }
        if (result.Success) {
            dataViewCommand = CommandFactory.CreateDataViewCommand(this.getTaskTag(), DataViewCommandType.InitDataControlViews);
            result = await this.DataviewManager.Execute(dataViewCommand);
        }
        return result;
    }
    async doFirstRecordCycle() {
        if (!this._isMainPrg) {
            AccessHelper.eventsManager.pushNewExecStacks();
            this.SubformExecMode = Task_SubformExecModeEnum.FIRST_TIME;
            await AccessHelper.eventsManager.handleInternalEventWithTaskAndSubformRefresh(this, InternalInterface.MG_ACT_REC_PREFIX, this.IsSubForm);
            if (!AccessHelper.eventsManager.GetStopExecutionFlag()) {
                if (this.IsSubForm) {
                    if (this.hasSubTasks())
                        for (let i = 0; i < this.SubTasks.getSize(); i++) {
                            let subTask = this.SubTasks.getTask(i);
                            if (subTask.IsSubForm) {
                                subTask.getForm().IgnoreFirstRecordCycle = true;
                                await subTask.doFirstRecordCycle();
                            }
                        }
                    await AccessHelper.eventsManager.handleInternalEventWithTask(this, InternalInterface.MG_ACT_REC_SUFFIX);
                }
            }
            this.SubformExecMode = Task_SubformExecModeEnum.SET_FOCUS;
            AccessHelper.eventsManager.popNewExecStacks();
        }
    }
    CheckAndSetSubForm() {
        this.IsSubForm = (!super.isMainProg() && this !== this._mgData.getFirstTask());
    }
    IsRoute() {
        return (this.RouterPath != null);
    }
    async stop() {
        let task;
        if (this._aborting)
            return;
        if (this.hasSubTasks()) {
            while ((task = this.SubTasks.getTask(0)) != null) {
                task.setDestinationSubform(this._destinationSubform);
                await task.stop();
            }
        }
        if (!this._isMainPrg)
            this._aborting = true;
        if (this._parentTask != null) {
            this._parentTask.removeSubTask(this);
            if (this.IsSubForm) {
                let oldTimers = new List(), newTimers = new List();
                let mgd = this.getMGData();
                if (mgd.getTimerHandlers() != null)
                    oldTimers = mgd.getTimerHandlers().getTimersVector();
                mgd.removeTimerHandler(this);
                mgd.removeExpressionHandler(this);
                if (mgd.getTimerHandlers() != null)
                    newTimers = mgd.getTimerHandlers().getTimersVector();
                mgd.changeTimers(oldTimers, newTimers);
                mgd.removeTask(this);
                GUIManager.Instance.abort(this.getForm());
            }
        }
        this.AbortTransaction();
        if (this.getClickedControl() != null)
            RuntimeContextBase.Instance.CurrentClickedCtrl = null;
        if (this.Form != null)
            this.Form.removeRefsToCtrls();
        if (this.IsSubForm) {
            let subForm = this.Form.getSubFormCtrl();
            subForm.setSubformTaskId(null);
            subForm.initSubformTask();
            if (LastFocusedManager.Instance.getLastFocusedTask() === this)
                LastFocusedManager.Instance.setLastFocusedTask(this._parentTask);
            if (subForm.SubformLoaded)
                await (subForm.getProp(PropInterface.PROP_TYPE_VISIBLE)).RefreshDisplay(true);
        }
        let clearDataViewCommand = CommandFactory.CreateDataViewCommand(this.getTaskTag(), DataViewCommandType.Clear);
        await this.DataviewManager.Execute(clearDataViewCommand);
    }
    abort() {
        this.getMGData().abort();
    }
    hasSubTasks() {
        return this.SubTasks !== null && this.SubTasks.getSize() > 0;
    }
    getTaskDepth(byParentOrder) {
        if (byParentOrder)
            return this.getTaskDepth_(byParentOrder);
        let depth = this.GetContextTask().getTaskDepth_(byParentOrder);
        if (this.isMainProg() && this.getCtlIdx() !== ConstInterface.TOP_LEVEL_CONTAINER)
            depth = depth + 1;
        return depth;
    }
    getTaskDepth_(byParentOrder) {
        let tmpTask = this.getTriggeringTask();
        if (tmpTask == null || byParentOrder)
            if (this._parentTask == null)
                return 1;
            else {
                if (byParentOrder && this.getCtlIdx() !== this._parentTask.getCtlIdx())
                    return 2 + this._parentTask.getTaskDepth_(byParentOrder);
                return 1 + this._parentTask.getTaskDepth_(byParentOrder);
            }
        return 1 + (tmpTask).getTaskDepth_(byParentOrder);
    }
    GetTaskAncestor(generation) {
        return this.getTaskAncestor_(generation);
    }
    getTaskAncestor_(generation) {
        let retTask = null;
        if (generation === 0)
            retTask = this;
        else {
            let tmpTask = this.getTriggeringTask();
            if (tmpTask === null)
                tmpTask = this._parentTask;
            if (tmpTask !== null)
                retTask = tmpTask.getTaskAncestor_(--generation);
        }
        return retTask;
    }
    GetTaskDepth() {
        return this.getTaskDepth(false);
    }
    pathContains(task) {
        return this._taskPath.Contains(task);
    }
    SetContextTask(context) {
        this.ContextTask = context;
    }
    GetContextTask() {
        let currRec = (this.DataView.getCurrRec());
        if (this.InStartProcess
            || currRec !== null && (currRec.InCompute || currRec.InRecompute)
            || this.Form !== null && this.Form.inRefreshDisplay())
            return this;
        return this.ContextTask;
    }
    getTriggeringTask() {
        if (this._triggeringTask !== null && this._triggeringTask.getMGData().IsAborting)
            this._triggeringTask = this._parentTask;
        return this._triggeringTask;
    }
    setLastParkedCtrl(ctrl) {
        super.setLastParkedCtrl(ctrl);
        LastFocusedManager.setLastFocusedControl(this, ctrl);
    }
    queryTaskPath() {
        let insertedNames = 0;
        let result = new StringBuilder(7936);
        let treeRoute = new Array(this.getTaskDepth(false));
        this.pathToRoot(treeRoute, false);
        for (let tsk = treeRoute.length - 1; tsk >= 0; tsk--) {
            let currTsk = treeRoute[tsk];
            if (currTsk.isMainProg())
                continue;
            let nameProp = currTsk.getProp(PropInterface.PROP_TYPE_NAME);
            if (nameProp == null)
                continue;
            let name = nameProp.GetComputedValue();
            if (!NString.IsNullOrEmpty(name)) {
                if (insertedNames++ !== 0)
                    result.Append(';');
                result.Append(name);
            }
        }
        return result;
    }
    ctl_itm_2_parent_vee(itm) {
        let currTsk;
        let currItm = 0;
        let lastItm = 0;
        let treeRoute = new Array(this.getTaskDepth(true));
        this.pathToRoot(treeRoute, true);
        for (let tsk = treeRoute.length - 1; tsk >= 0; tsk--) {
            currTsk = treeRoute[tsk];
            currItm += currTsk.DataView.GetFieldsTab().getSize();
            if (itm < currItm) {
                itm -= lastItm;
                return currTsk.DataView.getField(itm);
            }
            lastItm = currItm;
        }
        return null;
    }
    GetControlIDFromVarItem(item) {
        let currTask;
        let currItem = 0;
        let lastItem = 0;
        let noOfControlsBeforeCurrTask = 0;
        let treeRoute = new Array(this.getTaskDepth(true));
        this.pathToRoot(treeRoute, true);
        for (let task = treeRoute.length - 1; task >= 0; task--) {
            currTask = treeRoute[task];
            currItem += currTask.DataView.GetFieldsTab().getSize();
            if (item < currItem) {
                item -= lastItem;
                let field = currTask.DataView.getField(item);
                if (field.getCtrl() != null)
                    return noOfControlsBeforeCurrTask = noOfControlsBeforeCurrTask + currTask.Form.getControlIdx(field.getCtrl()) + 1;
                return 0;
            }
            if (currTask.Form != null)
                noOfControlsBeforeCurrTask += currTask.Form.getCtrlCount();
            lastItem = currItem;
        }
        return 0;
    }
    GetControlFromControlID(controlID, parent) {
        let control = null;
        parent.value = -1;
        if (controlID >= 0) {
            let currTask = null;
            let callerTask = null;
            let noOfControlsInCurrtask = 0;
            let noOfControlsBeforeCurrTask = 0;
            let controlIdx = 0;
            let treeRoute = new Array(this.getTaskDepth(true));
            this.pathToRoot(treeRoute, true);
            for (let task = treeRoute.length - 1; task >= 0; task--) {
                currTask = treeRoute[task];
                if (currTask.Form != null) {
                    noOfControlsInCurrtask = currTask.Form.getCtrlCount();
                    if (controlID < (noOfControlsBeforeCurrTask + noOfControlsInCurrtask)) {
                        controlIdx = controlID - noOfControlsBeforeCurrTask;
                        control = currTask.Form.CtrlTab.getCtrl(controlIdx);
                        callerTask = currTask;
                        break;
                    }
                    noOfControlsBeforeCurrTask += noOfControlsInCurrtask;
                }
            }
            if (control != null) {
                parent.value = 0;
                let prevCtlIdx = treeRoute[0].TaskDefinitionId.CtlIndex;
                for (let task = 0; task < treeRoute.length - 1; task++) {
                    currTask = treeRoute[task];
                    if (prevCtlIdx !== currTask.TaskDefinitionId.CtlIndex)
                        parent.value++;
                    if (callerTask.TaskDefinitionId.CtlIndex === currTask.TaskDefinitionId.CtlIndex)
                        break;
                    prevCtlIdx = currTask.TaskDefinitionId.CtlIndex;
                }
            }
        }
        return control;
    }
    ctl_itm_4_parent_vee(parent, vee) {
        let tsk;
        let depth = this.getTaskDepth(true);
        if (parent !== TaskBase.MAIN_PRG_PARENT_ID && depth <= parent)
            return vee;
        let treeRoute = new Array(depth);
        if (vee !== 0) {
            this.pathToRoot(treeRoute, true);
            let indOfParentInTaskTree = this.getIndOfParentInTaskTree(parent, treeRoute);
            let i;
            for (i = treeRoute.length - 1; i > indOfParentInTaskTree; i--) {
                tsk = treeRoute[i];
                vee += tsk.DataView.GetFieldsTab().getSize();
            }
        }
        return vee;
    }
    getIndOfParentInTaskTree(parent, taskTree) {
        let indOfParentInTaskTree = 0;
        if (parent === TaskBase.MAIN_PRG_PARENT_ID) {
            for (let i = 1; i < taskTree.length; i = i + 1) {
                if (taskTree[i].isMainProg() && this._ctlIdx === taskTree[i].getCtlIdx()) {
                    indOfParentInTaskTree = i;
                    break;
                }
            }
        }
        else
            indOfParentInTaskTree = parent;
        return indOfParentInTaskTree;
    }
    getFieldByName(fldName) {
        return (this.GetContextTask()).getFieldByName_(fldName);
    }
    getFieldByName_(fldName) {
        let tmpTask;
        if (fldName == null)
            return null;
        let fld = this.getField(fldName);
        if (fld == null) {
            tmpTask = this.getTriggeringTask() != null ? this.getTriggeringTask() : this._parentTask;
            if (tmpTask != null) {
                if (!this.isMainProg() && this.getCtlIdx() !== tmpTask.getCtlIdx()) {
                    let mainPrg = AccessHelper.mgDataTable.GetMainProgByCtlIdx(-1, this.getCtlIdx());
                    fld = mainPrg.getFieldByName_(fldName);
                }
                if (fld == null)
                    fld = tmpTask.getFieldByName_(fldName);
            }
        }
        return fld;
    }
    getIndexOfFieldByName(fldName) {
        let depth = this.getTaskDepth(true);
        let index = 0;
        let fld = this.getFieldByName(fldName);
        let fldTab;
        if (fld == null)
            return 0;
        let treeRoute = new Array(depth);
        this.pathToRoot(treeRoute, true);
        for (let curr = depth - 1; curr >= 0; curr--) {
            let currTask = treeRoute[curr];
            if (currTask === fld.getTask()) {
                curr = fld.getId();
                index += ++curr;
                break;
            }
            fldTab = currTask.DataView.GetFieldsTab();
            index += fldTab.getSize();
        }
        return index;
    }
    pathToRoot(path, byParentOrder) {
        let task = (byParentOrder ? this : this.GetContextTask());
        for (let i = 0; i < path.length; i++) {
            path[i] = task;
            let ctlIdx = task.getCtlIdx();
            let tmpTask = byParentOrder ? null : task.getTriggeringTask();
            if (tmpTask != null)
                task = tmpTask;
            else {
                task = task.getParent();
                if (task == null) {
                    if (!byParentOrder && this.isMainProg() && this.getCtlIdx() !== ConstInterface.TOP_LEVEL_CONTAINER)
                        path[i + 1] = this;
                    break;
                }
                if (byParentOrder && ctlIdx !== task.getCtlIdx())
                    path[++i] = AccessHelper.mgDataTable.GetMainProgByCtlIdx(-1, ctlIdx);
            }
        }
    }
    shouldBeRefreshed() {
        let dataView = this._parentTask.DataView;
        let result = false;
        if (this._parentTask === null || dataView.isPrevCurrRecNull() ||
            (this.RefreshOnVars !== null && !dataView.currEqualsPrev(this.RefreshOnVars)))
            result = true;
        return result;
    }
    async CheckRefreshSubTasks() {
        let ret = false;
        if (this._enteredRecLevel) {
            let subformsToRefresh = await this.GetSubformsToRefresh();
            if (subformsToRefresh.length > 0)
                ret = true;
        }
        return ret;
    }
    GetSubTasks() {
        let subTasks = new List();
        if (this.hasSubTasks()) {
            for (let i = 0; i < this.SubTasks.getSize(); i = i + 1)
                subTasks.push(this.SubTasks.getTask(i));
        }
        return subTasks;
    }
    async GetSubformsToRefresh() {
        let subTasks = this.GetSubTasks();
        let subTasksToRefresh = new List();
        for (let i = 0; i < subTasks.length; i++) {
            let subTask = subTasks.get_Item(i);
            if (await this.ShouldRefreshSubformTask(subTask))
                subTasksToRefresh.push(subTask);
        }
        return subTasksToRefresh;
    }
    async ShouldRefreshSubformTask(subTask) {
        let refresh = false;
        let subformCtrl = subTask.getForm().getSubFormCtrl();
        subTask.DoSubformPrefixSuffix = false;
        if (subformCtrl != null && !subTask.InSelect && subTask.AfterFirstRecordPrefix) {
            let parentMode = this.getMode();
            let modeProperty = (parentMode === Constants.TASK_MODE_QUERY ? PropInterface.PROP_TYPE_ALLOW_QUERY
                : parentMode === Constants.TASK_MODE_MODIFY
                    ? PropInterface.PROP_TYPE_ALLOW_MODIFY
                    : PropInterface.PROP_TYPE_ALLOW_CREATE);
            if (subTask.ModeAsParent && parentMode !== subTask.getMode() &&
                this.getLevel() === Constants.TASK_LEVEL_RECORD &&
                await (subTask.getProp(PropInterface.PROP_TYPE_ALLOW_OPTION)).getValueBoolean() &&
                await subTask.checkProp(modeProperty, true)) {
                if (!subformCtrl.isVisible() &&
                    !await subformCtrl.checkProp(PropInterface.PROP_TYPE_REFRESH_WHEN_HIDDEN, false)) {
                    subformCtrl.RefreshOnVisible = true;
                    refresh = false;
                }
                else
                    refresh = true;
                await subTask.SetModeAsParent(parentMode);
            }
            else {
                refresh = await subformCtrl.checkProp(PropInterface.PROP_TYPE_AUTO_REFRESH, true) && subTask.shouldBeRefreshed();
                if (refresh) {
                    if (!subformCtrl.isVisible() &&
                        !await subformCtrl.checkProp(PropInterface.PROP_TYPE_REFRESH_WHEN_HIDDEN, false)) {
                        subformCtrl.RefreshOnVisible = true;
                        refresh = false;
                    }
                }
            }
            if (refresh)
                subTask.DoSubformPrefixSuffix = true;
        }
        return refresh;
    }
    async SetModeAsParent(parentMode) {
        await this.enableModes();
        if (parentMode === Constants.TASK_MODE_CREATE) {
            let cmd = CommandFactory.CreateEventCommand(this.getTaskTag(), InternalInterface.MG_ACT_RTO_CREATE);
            await this.DataviewManager.Execute(cmd);
        }
        else if (this.getMode() === Constants.TASK_MODE_CREATE) {
            this.setPreventRecordSuffix(true);
            this.setPreventControlChange(true);
            await AccessHelper.eventsManager.handleInternalEventWithTask(this, InternalInterface.MG_ACT_RT_REFRESH_VIEW);
            this.setPreventRecordSuffix(false);
            this.setPreventControlChange(false);
            let subTaskDv = this.DataView;
            if (!subTaskDv.isEmpty() && (subTaskDv.getCurrRec()).getMode() !== DataModificationTypes.Insert)
                this.setMode(parentMode);
            else
                this.setMode(Constants.TASK_MODE_CREATE);
            await this.getForm().RefreshDisplay(Constants.TASK_REFRESH_CURR_REC);
        }
        else
            this.setMode(parentMode);
        this.setOriginalTaskMode(parentMode);
        await this.setCreateDeleteActsEnableState();
    }
    async doSubformRecPrefixSuffix() {
        let subTasks = this.GetSubTasks();
        for (let i = 0; i < subTasks.length; i++) {
            let subTask = subTasks.get_Item(i);
            if (subTask.DoSubformPrefixSuffix) {
                await AccessHelper.eventsManager.handleInternalEventWithTaskAndSubformRefresh(subTask, InternalInterface.MG_ACT_REC_PREFIX, true);
                if (!AccessHelper.eventsManager.GetStopExecutionFlag())
                    await AccessHelper.eventsManager.handleInternalEventWithTask(subTask, InternalInterface.MG_ACT_REC_SUFFIX);
            }
        }
    }
    CleanDoSubformPrefixSuffix() {
        let subTasks = this.GetSubTasks();
        for (let i = 0; i < subTasks.length; i++) {
            let subTask = subTasks.get_Item(i);
            subTask.DoSubformPrefixSuffix = false;
        }
    }
    mustConfirmInDeleteMode() {
        let prop = this.getProp(PropInterface.PROP_TYPE_CONFIRM_UPDATE);
        return !prop.isExpression();
    }
    addSubTask(subTask) {
        if (this.SubTasks === null)
            this.SubTasks = new TasksTable();
        this.SubTasks.addTask(subTask);
    }
    removeSubTask(subTask) {
        if (this.SubTasks !== null)
            this.SubTasks.removeTask(subTask);
    }
    setTransactionFailed(val) {
        this._transactionFailed = val;
        if (!val)
            this.TransactionErrorHandlingsRetry = null;
    }
    transactionFailed(level) {
        if (level === ConstInterface.TRANS_NONE ||
            (this.Transaction != null && this.Transaction.getLevel() === level))
            return this._transactionFailed;
        else if (level === ConstInterface.TRANS_NONE ||
            (this.TransactionErrorHandlingsRetry != null && this.TransactionErrorHandlingsRetry.getLevel() === level))
            return this._transactionFailed;
        return false;
    }
    setAfterRetry(val) {
        if (this.Transaction != null)
            this.Transaction.setAfterRetry(val);
        else if (this.TransactionErrorHandlingsRetry != null) {
            if (val === ConstInterface.RECOVERY_NONE)
                this.TransactionErrorHandlingsRetry = null;
            else
                this.TransactionErrorHandlingsRetry.setAfterRetry(val);
        }
    }
    getAfterRetry(recovery) {
        if (arguments.length === 0) {
            return this.getAfterRetry_0();
        }
        return this.getAfterRetry_1(recovery);
    }
    getAfterRetry_0() {
        if (this.Transaction != null)
            return this.Transaction.getAfterRetry();
        else if (this.TransactionErrorHandlingsRetry != null)
            return this.TransactionErrorHandlingsRetry.getAfterRetry();
        return false;
    }
    getAfterRetry_1(recovery) {
        if (this.Transaction != null)
            return this.Transaction.getAfterRetry(recovery);
        else if (this.TransactionErrorHandlingsRetry != null)
            return this.TransactionErrorHandlingsRetry.getAfterRetry(recovery);
        return false;
    }
    getExecEndTask() {
        return this._bExecEndTask;
    }
    resetExecEndTask() {
        this._bExecEndTask = false;
    }
    setExecEndTask() {
        this._bExecEndTask = true;
    }
    async evalEndCond(mode) {
        let endTaskCondProp;
        let evalEndCondProp = this.getProp(PropInterface.PROP_TYPE_EVAL_END_CONDITION);
        if (this.InEndTask)
            return false;
        if (this._bExecEndTask)
            return true;
        if (evalEndCondProp != null && (NString.Compare(await evalEndCondProp.getValue(), ConstInterface.END_COND_EVAL_IMMIDIATE, true) === 0 || ((await evalEndCondProp.getValue()).toLowerCase() === mode.toLowerCase()))) {
            endTaskCondProp = this.getProp(PropInterface.PROP_TYPE_END_CONDITION);
            if (endTaskCondProp == null)
                return false;
            let endTask = await endTaskCondProp.getValue();
            if (DisplayConvertor.toBoolean(endTask)) {
                this._bExecEndTask = true;
                return true;
            }
            return false;
        }
        return false;
    }
    setTryingToStop(val) {
        if (this.hasSubTasks()) {
            for (let i = 0; i < this.SubTasks.getSize(); i = i + 1) {
                let task = this.SubTasks.getTask(i);
                task.setTryingToStop(val);
            }
        }
        this.IsTryingToStop = val;
    }
    getInRecordSuffix() {
        return this._inRecordSuffix;
    }
    setInRecordSuffix(bValue) {
        if (bValue !== this._inRecordSuffix) {
            this._inRecordSuffix = bValue;
            return true;
        }
        return false;
    }
    setEvalOldValues(bFlag) {
        if (bFlag !== this._evalOldValues) {
            this._evalOldValues = bFlag;
            return true;
        }
        return false;
    }
    getEvalOldValues() {
        return this._evalOldValues;
    }
    async endTask(reversibleExit, onlyDescs, dueToVerifyError, subformDestination) {
        if (isNullOrUndefined(subformDestination))
            return await this.endTask_1(reversibleExit, onlyDescs, false, d