import { PIC } from '@magic-xpa/gui';
import { IGuiEvent } from './bridge/IGuiEvent';
import { HttpClient } from '@angular/common/http';
export declare class ClientManager {
    private static _instance;
    private _globalUniqueSessionId;
    private _buttonIsClicked;
    private static readonly _executionPropertiesFileName;
    static get Instance(): ClientManager;
    AddEvent(guiEvent: IGuiEvent): void;
    private handleNavigateInRowEvent;
    ConfirmationClosed(res: number): void;
    WorkThreadExecution(): Promise<void>;
    WriteExecutionPropertiesToLog(): void;
    constructor();
    private InitGuiManager;
    private InitCircularReferencesBypasses;
    static Main(httpClient: HttpClient): void;
    static StopExecution(): Promise<void>;
    static StartExecution(httpClient: HttpClient): Promise<void>;
    LoadExecutionProps(): Promise<boolean>;
    GetGlobalUniqueSessionID(): string;
    static GetControlPictureMask(taskId: string, controlName: string): PIC;
    static GetFormattedValue(taskId: string, controlName: string, value: any, rowId?: string): string;
    static GetRangedValue(taskId: string, controlName: string, value: string): string;
    static ValidateControlValue(taskId: string, controlName: string, value: any): string;
    static GetFldRanges(taskId: string, controlName: string): string;
    static TransCacheExists(): boolean;
    RegisterDelegates(): void;
    GetRuntimeCtxID(): string;
    static TerminateContextUsingFetchAPI(): void;
}
