import { IResultValue } from './rt/IResultValue';
export declare enum CommandsProcessorBase_SessionStage {
    HANDSHAKE = 1,
    INITIAL = 2,
    NORMAL = 3
}
export declare enum CommandsProcessorBase_SendingInstruction {
    NO_TASKS_OR_COMMANDS = 0,
    ONLY_COMMANDS = 1,
    TASKS_AND_COMMANDS = 2
}
export declare abstract class CommandsProcessorBase {
    _sessionCounter: number;
    GetSessionCounter(): number;
    StartSession(): Promise<boolean>;
    Execute(sendingInstruction: CommandsProcessorBase_SendingInstruction): Promise<void>;
    Execute(sendingInstruction: CommandsProcessorBase_SendingInstruction, sessionStage: CommandsProcessorBase_SessionStage, res: IResultValue): Promise<void>;
    private Execute_0;
    Execute_1(sendingInstruction: CommandsProcessorBase_SendingInstruction, sessionStage: CommandsProcessorBase_SessionStage, res: IResultValue): Promise<void>;
    GetContent(requestedURL: string, useCache: boolean): Promise<string>;
    abstract SendMonitorOnly(): void;
    static UnScramble(respBuf: string): string;
}
